/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_DID_FINISH_H_
#define TESTING_DID_FINISH_H_

#include <core/posix/exit.h>
#include <core/posix/wait.h>

#include <gtest/gtest.h>

#include <iosfwd>

namespace core
{
namespace posix
{
// Pretty prints the given signal to the given output stream.
std::ostream& operator<<(std::ostream& out, Signal signal);
namespace wait
{
// Pretty prints the given status to the given output stream.
std::ostream& operator<<(std::ostream& out, Result::Status status);
}
}
}

namespace testing
{
/// @brief did_finish_successfully returns testing::AssertionSuccess if the given result indicates
/// that the associated child process finished successfully, i.e.:
///   * it exited
///   * exit code indicates success
::testing::AssertionResult did_finish_successfully(const core::posix::wait::Result& result);

/// @brief did_abort returns testing::AssertionSuccess if the given result indicates
/// that the associated child process was aborted, i.e., signaled with SIGABRT.
::testing::AssertionResult did_abort(const core::posix::wait::Result& result);
}

#endif  // TESTING_DID_FINISH_H_
