/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mock_connector.h"
#include "mock_connection.h"

namespace testing
{

MockConnector::MockConnector()
{
    ON_CALL(*this, parameters()).WillByDefault(ReturnRef(params_));
    ON_CALL(*this, request_connection(_,_,_,_)).WillByDefault(Invoke(this, &MockConnector::fake_request_connection));
}

std::shared_ptr<messaging::Connection> MockConnector::fake_request_connection(
        const std::shared_ptr<messaging::Connection::Observer>& connection_observer,
        const std::shared_ptr<messaging::Messenger::Observer>& messenger_observer,
        const std::shared_ptr<messaging::PresenceManager::Observer>& presence_observer,
        const messaging::Dictionary<std::string, messaging::Variant>&)
{
    return std::make_shared<NiceMock<MockConnection>>(connection_observer, messenger_observer, presence_observer);
}

}
