/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_MOCK_CHAT_H_
#define TESTING_MOCK_CHAT_H_

#include <messaging/chat.h>
#include <messaging/group_manager.h>

#include <gmock/gmock.h>

namespace testing
{
class MockChat : public messaging::Chat
{
  public:
    MockChat(const std::shared_ptr<messaging::Chat::Observer>& observer)
            : messaging::Chat{observer}
    {
    }

    MOCK_METHOD0(group_manager, std::shared_ptr<messaging::GroupManager>());
    MOCK_METHOD1(enable_group_manager, void(const std::shared_ptr<messaging::GroupManager::Observer>&));
    MOCK_METHOD1(send_message, std::string(const messaging::Message&));
    MOCK_METHOD1(mark_message_as_read, void(const std::string&));
    MOCK_METHOD1(download_file, std::string(std::string id));
    MOCK_METHOD0(start_typing, void());
    MOCK_METHOD0(end_typing, void());
};
}

#endif // TESTING_MOCK_CHAT_H_
