/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/qt/tp/interfaces/channel_interface_roles_adaptor.h>

#include <TelepathyQt/Constants>

namespace mqti = messaging::qt::tp::interfaces;

mqti::ChannelInterfaceRolesAdaptor::ChannelInterfaceRolesAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(rolesChanged(const HandleRolesMap&, const HandleRolesMap&)), SIGNAL(RolesChanged(const HandleRolesMap&, const HandleRolesMap&)));
}

mqti::ChannelInterfaceRolesAdaptor::~ChannelInterfaceRolesAdaptor()
{
}

void mqti::ChannelInterfaceRolesAdaptor::UpdateRoles(const HandleRolesMap &contactRoles, const QDBusMessage &dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("updateRoles(HandleRolesMap,ChannelInterfaceRolesAdaptor::UpdateRolesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    UpdateRolesContextPtr ctx = UpdateRolesContextPtr(
            new Tp::MethodInvocationContext< >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "updateRoles",
        Q_ARG(HandleRolesMap, contactRoles),
        Q_ARG(ChannelInterfaceRolesAdaptor::UpdateRolesContextPtr, ctx));
}

mqti::HandleRolesMap mqti::ChannelInterfaceRolesAdaptor::Roles() const
{
    return qvariant_cast< HandleRolesMap >(adaptee()->property("roles"));
}

bool mqti::ChannelInterfaceRolesAdaptor::CanUpdateRoles() const
{
    return qvariant_cast< bool >(adaptee()->property("canUpdateRoles"));
}
