/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/qt/tp/initializer.h>

#include <TelepathyQt/Debug>
#include <TelepathyQt/Types>

// We declare a top-level category for capturing everything telepathy qt.
Q_LOGGING_CATEGORY(telepathy_qt, "tp.qt")

namespace
{
// Debug callback is installed on the global (evil) telepathy-qt setup.
// We translate over to Qt's categorized logging which in turn is mapped
// to our own internal logging system.
void debug_callback(const QString& library_name, const QString& library_version, QtMsgType type, const QString& msg)
{
    // We don't need either of them as we declare a common
    // logging category for telepathy qt.
    Q_UNUSED(library_name);
    Q_UNUSED(library_version);

    switch (type)
    {
        case QtDebugMsg:
            qCDebug(telepathy_qt) << msg;
            break;
        case QtWarningMsg:
            qCWarning(telepathy_qt) << msg;
            break;
        default:
            break;
    }
}
}

messaging::qt::tp::Initializer::Initializer(const tp::Initializer::Configuration& config)
{
    Tp::registerTypes();
    Tp::enableDebug(config.enable_debug_output);
    Tp::enableWarnings(config.enable_warning_output);
    Tp::setDebugCallback(debug_callback);
}
