/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/message.h>

namespace messaging
{

std::ostream& operator<<(std::ostream& out, DeliveryStatus status){
    switch (status) {
    case DeliveryStatus::delivered:
        out << "delivered";
        break;
    case DeliveryStatus::temporaly_failed:
        out << "temporaly_failed";
        break;
    case DeliveryStatus::permanently_failed:
        out << "permanently_failed";
        break;
    case DeliveryStatus::accepted:
        out << "accepted";
        break;
    case DeliveryStatus::read:
        out << "read";
        break;
    case DeliveryStatus::deleted:
        out << "deleted";
        break;
    case DeliveryStatus::unknown:
        out << "unknown";
        break;
    }
    return out;
}

}

