/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef USER_H
#define USER_H

#include <messaging/recipient.h>
#include <messaging/variant_map.h>

#include <deque>
#include <memory>

namespace messaging
{

class MESSAGING_FW_PUBLIC User : public Recipient
{
public:
    User(std::string id, std::string display_name = std::string{}, VariantMap properties = VariantMap{});
    virtual ~User() = default;

    RecipientType type() const override;
    std::string display_name() const;
    VariantMap properties() const;

    typedef std::shared_ptr<User> shared_ptr;

private:
    /// @cond
    struct Private;
    std::shared_ptr<Private> impl;
    /// @endcond
};

}

#endif // USER_H
