/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_PROTOCOL_H_
#define MESSAGING_QT_TP_PROTOCOL_H_

#include <messaging/visibility.h>

#include <TelepathyQt/BaseProtocol>

#include <memory>

namespace messaging
{
// A handy fwd declare.
class Connector;

namespace qt
{
// A handy fwd declare.
class Runtime;
namespace tp
{
/// @brief Protocol is a Tp::BaseProtocol implementation, relying
/// on a messaging::Connector to create connection instances.
class MESSAGING_FW_PUBLIC Protocol : public Tp::BaseProtocol
{
    Q_OBJECT
public:
    /// @brief TelepathyProtocol creates a new instance for the given DBus connection,
    /// and the given name.
    ///
    /// TODO(tvoss): We have to pass down the name of the connection manager, too, as Tp::BaseConnection
    /// requires it on creation. Ideally, BaseConnection would not require the name.
    Protocol(const std::shared_ptr<Connector>& connector,
             const std::shared_ptr<qt::Runtime>& runtime,
             const QString& connection_manager_name,
             const QString& protocol_name);

    ~Protocol();

private:
    /// @brief create_connection creates a new connection with the given parameters.
    virtual Tp::BaseConnectionPtr create_connection(const QVariantMap& parameters, Tp::DBusError* error);
    Tp::BaseProtocolAddressingInterfacePtr addressingIface;

    std::shared_ptr<qt::Runtime> runtime;  ///< The qt::Runtime instance we are associated with.
    QString connection_manager_name;       ///< Remembering the name of the connection manager.
    std::shared_ptr<Connector> connector;  ///< The Connector instance we are using to create connections.
};
}
}
}

#endif  // MESSAGING_QT_TP_PROTOCOL_H_
