/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_ROLES
#define  MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_ROLES

#include <TelepathyQt/BaseChannel>
#include <messaging/visibility.h>

#include <messaging/qt/tp/interfaces/types.h>
#include <messaging/qt/tp/interfaces/constants.h>

namespace messaging
{
namespace qt
{
namespace tp
{
namespace interfaces
{

/*!
The spec:

    org.freedesktop.Telepathy.Channel.Interface.Roles

    Methods
    UpdateRoles		(a{uu}:ContactRoles)	-> nothing

    Signals
    RolesChanged(a{uu}:Added, a{uu}:Removed)

    Properties:
    Roles			a{uu} (Handle_Roles_Map)	Read only
    CanUpdateRoles	b							Read only

    Types:
    Channel_Roles		Flags	u
    Handle_Roles_Map	Mapping	a{uu}
*/


class MESSAGING_FW_PUBLIC BaseChannelRolesInterface : public Tp::AbstractChannelInterface
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseChannelRolesInterface)

public:
    static BaseChannelRolesInterfacePtr create() {
        return BaseChannelRolesInterfacePtr(new BaseChannelRolesInterface());
    }
    template<typename BaseChannelRolesInterfaceSubclass>
    static Tp::SharedPtr<BaseChannelRolesInterfaceSubclass> create() {
        return Tp::SharedPtr<BaseChannelRolesInterfaceSubclass>(
                   new BaseChannelRolesInterfaceSubclass());
    }
    virtual ~BaseChannelRolesInterface();

    QVariantMap immutableProperties() const;

    HandleRolesMap roles() const;
    void setRoles(const HandleRolesMap &contactRoles);

    bool canUpdateRoles() const;
    void setCanUpdateRoles(bool canUpdate);

    typedef Tp::Callback2<void, const HandleRolesMap&, Tp::DBusError*> UpdateRolesCallback;
    void setUpdateRolesCallback(const UpdateRolesCallback &cb);
    void updateRoles(const HandleRolesMap &contactRoles, Tp::DBusError *error);

Q_SIGNALS:
    void rolesChanged(const HandleRolesMap &added, const HandleRolesMap& removed);

private:
    BaseChannelRolesInterface();
    void createAdaptor();

    class Adaptee;
    friend class Adaptee;
    struct Private;
    friend struct Private;
    Private *mPriv;
};

}
}
}
}

#endif //  MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_ROLES

