/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_NAMED_SYMBOL_LOADER_H_
#define MESSAGING_NAMED_SYMBOL_LOADER_H_

#include <messaging/non_copyable.h>
#include <messaging/non_movable.h>

#include <string>

namespace messaging
{
/// @brief NamedSymbolLoader abstracts loading of functions/symbols by name.
class NamedSymbolLoader : NonCopyable, NonMovable
{
public:
    /// @brief load_symbol_for_name attempts to load the symbol with the given name.
    /// @throws std::out_of_range if no symbol is known for the given name.
    virtual void* load_symbol_for_name(const std::string& name) const = 0;

protected:
    // Only subsclasses can instantiate.
    NamedSymbolLoader() = default;
};
}

#endif  // MESSAGING_NAMED_SYMBOL_LOADER_H_
