/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_INTERFACE
#define MESSAGING_INTERFACE

#include <messaging/visibility.h>
#include <set>
#include <memory>

#include <vector>

namespace messaging
{

class HasInterfaces;
class Interface;

typedef std::set<std::shared_ptr<Interface>, std::owner_less<std::shared_ptr<Interface>>> InterfacesSet;

class MESSAGING_FW_PUBLIC Interface
{
public:
    virtual ~Interface() = default;

    /// @brief on_plugged executed when this interfaces is plugged to a host object. Overwrite this method
    /// in subclasses if wanted certain behaviour when plug happens.
    virtual void on_plugged(const std::weak_ptr<HasInterfaces> &where) = 0;
};

}
#endif // MESSAGING_INTERFACE

