#ifndef MESSAGING_GROUP_STARTER_H
#define MESSAGING_GROUP_STARTER_H

#include <messaging/visibility.h>
#include <messaging/non_copyable.h>
#include <messaging/non_movable.h>
#include <messaging/members.h>

#include <memory>

namespace messaging
{

class Group;
class GroupManager;
class Broadcast;

/// @brief GroupStarter models the object for group creation
class MESSAGING_FW_PUBLIC GroupStarter : public NonCopyable, NonMovable
{
public:
    virtual ~GroupStarter() = default;

    /// @brief create_group initiate group from app
    virtual std::shared_ptr<GroupManager> create_group(const std::shared_ptr<Group> &group) = 0;

    /// @brief accept_group accept group creation initiated in plugin
    virtual std::shared_ptr<GroupManager> accept_group(const std::shared_ptr<Group> &group) = 0;

    /// @brief rejoin_group joins a previously created group in plugin
    virtual std::shared_ptr<GroupManager> rejoin_group(const std::shared_ptr<Group> &group) = 0;

    /// @brief reject_group rejects establishing a group with the parameter
    virtual void reject_group(const std::shared_ptr<Group> &group) = 0;

    /// @brief create_broadcast creates a broadcast group where sending messages to several recipients
    virtual std::shared_ptr<Broadcast> create_broadcast(const Members& recipients) = 0;

protected:
    /// @brief GroupStarter constructs a new instance.
    GroupStarter() = default;
};

}
#endif // MESSAGING_GROUP_STARTER_H

