/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GROUP_H
#define GROUP_H

#include <messaging/recipient.h>
#include <messaging/member.h>
#include <messaging/members.h>

namespace messaging
{

class MESSAGING_FW_PUBLIC Group : public Recipient
{
public:
    static const std::string ROOM_NAME;
    static const std::string DESCRIPTION;
    static const std::string SERVER;
    static const std::string CREATION_TIMESTAMP;
    static const std::string SUBJECT;

    Group(std::string id, 
    	const Members &initial_invitees = Members{}, 
    	std::string initial_title = std::string{}, 
        const std::shared_ptr<Member> &creator = std::make_shared<Member>(std::string{}),
        const VariantMap &additional_properties = VariantMap{});

    RecipientType type() const override;

    Members initial_invitees() const;
    std::string initial_title() const;
    std::shared_ptr<Member> creator() const;
    VariantMap &additional_properties();

    std::shared_ptr<Variant> additional_property(const std::string &key) const;
    void set_additional_property(const std::string &key, const std::shared_ptr<messaging::Variant> &value);
    bool exists_additional_property(const std::string &key) const;

    typedef std::shared_ptr<Group> shared_ptr;
private:
    /// @cond
    struct Private;
    std::shared_ptr<Private> impl;
    /// @endcond
};

}

#endif // GROUP_H
