# Messaging Framework

### Checking dependencies

Check all the dependencies needed for the project to be built:
```sh
$ dpkg-checkbuilddeps
```
(this will return the list of dependencies). Install the returned dependencies:
```sh
$ apt-get install <list_of_dependencies>
```

### Building the code

You can check the needed packages by using:
```sh	
$ dpkg-checkdependencies
```

and install the list of needed dependencies returned. Once done, execute:
```sh
$ mkdir build && cd build
$ cmake -DCMAKE_INSTALL_PREFIX=/usr ../..
$ make -j<n>
```
where <n> is the number of cores available to use for building.
You can use ccache also if expected to build several times (apt-get install ccache)


### Running the tests

Once built, into build folder, execute:
```sh
$ ctest -j<n>
```
where <n> is the number of cores available to use for executing the tests in parallel


### Building the package

NOTE: Before building the package it is needed run a hook which updates debian folder. You have to execute
that hook from project folder:
```sh
$ ./debian/bileto_pre_release_hook
```

If all goes well, no response should be returned.

You can build the deb package in current arch by executing:
```sh
$ dh_clean
$ dpkg-buildpackage -b
```

in case you want to skip signage and dependencies to build a test package, you can use some additional params:
```sh
$ dpkg-buildpackage -nc -us -uc -d -b
```

besides, if you are in a lxd container and want to build a package for that container architecture:
```sh
$ dpkg-buildpackage -nc -us -uc -d -b --target-arch <arch> -a <arch> -j<n>
```

where <arch> is the architecture of the environment and <n> the number of cores to use

Depending on the release the soname of the resultant library will be on or another. You can query file:
```sh
tools/get_soversion.sh
```

the soversion that will be used for the library. The resultant .deb package will be like:
```sh
libmessaging-framework<apiversion>-<soversion>_XXX_<arch>.deb
```

