##############################################################################
#
# Widget to activate categories <Peter.Bienstman@ugent.be>
#
##############################################################################

from qt import *

from memaid_core import *
from activate_categories_frm import *



##############################################################################
#
# ActivateCategoriesDlg
#
##############################################################################

class ActivateCategoriesDlg(ActivateCategoriesFrm):
    
    ##########################################################################
    #
    # __init__
    #
    ##########################################################################
    
    def __init__(self, parent=None, name=None, modal=0, fl=0):
        
        ActivateCategoriesFrm.__init__(self,parent,name,modal,fl)

        for cat in get_categories():
            c = QListBoxText(self.list_scheduled, cat.name)
            self.list_scheduled.setSelected(c, cat.scheduled)
        self.list_scheduled.sort()

        for cat in get_categories():
            c = QListBoxText(self.list_badly_known, cat.name)
            self.list_badly_known.setSelected(c, cat.badly_known)
        self.list_badly_known.sort()

        self.connect(self.button_all_sch, SIGNAL("clicked()"),
                     self.activate_all_sch)
        self.connect(self.button_all_bad, SIGNAL("clicked()"),
                     self.activate_all_bad)
        self.connect(self.button_ok, SIGNAL("clicked()"),
                     self.apply)
        
    ##########################################################################
    #
    # activate_all_sch
    #
    ##########################################################################
    
    def activate_all_sch(self):
        
        item = self.list_scheduled.firstItem()
        while item != None:
            self.list_scheduled.setSelected(item, 1)
            item = item.next()
            
    ##########################################################################
    #
    # activate_all_bad
    #
    ##########################################################################
    
    def activate_all_bad(self):
        
        item = self.list_badly_known.firstItem()
        while item != None:
            self.list_badly_known.setSelected(item, 1)
            item = item.next()
            
    ##########################################################################
    #
    # apply
    #
    ##########################################################################

    def apply(self):

        item = self.list_scheduled.firstItem()
        while item != None:
            if item.isSelected() == True:
                get_category_by_name(unicode(item.text())).scheduled = True
            else:
                get_category_by_name(unicode(item.text())).scheduled = False
            item = item.next()

        item = self.list_badly_known.firstItem()
        while item != None:
            if item.isSelected() == True:
                get_category_by_name(unicode(item.text())).badly_known = True
            else:
                get_category_by_name(unicode(item.text())).badly_known = False 
            item = item.next()

        rebuild_revision_queue()

        self.close()
        
