/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: tentacle.h,v 1.15 2003/02/05 04:40:14 kos Exp $
 *
 */

#ifndef _TENTACLE_H
#define _TENTACLE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "common.h"
#include "net.h"
#include "array.h"
#include "method.h"
#include "configfile.h"
#include "keyspace.h"
#include "generator.h"

#define TENTACLE_VERSION VERSION

#define TEN_LINELEN 1024
#define DEF_SERVER "localhost"
#define DEF_SERVERPORT "5444"
#define DEF_VERBOSE "1"
#define DEF_CONNDELAY "5"
#define DEF_NICENESS "4"
#define DEF_CONFIGCLASS "tentacle"
#define DEF_CONFIGFILE "tentaclerc"
#define DEF_LOGMETHOD "stderr"

typedef struct tentacle_t {
  config_t *conf;
  char i1[DEF_LINELEN];
  char i2[DEF_LINELEN];

  int keyfound;
  char keyindex[DEF_LINELEN];
  bstring key;

  char hashtype[DEF_LINELEN];
  bstring hash;
  method_t *method;
  char method_name[DEF_LINELEN];
  char method_params[DEF_LINELEN];
  generator_t *generator;
  char generator_name[DEF_LINELEN];
  char generator_params[DEF_LINELEN];
  net_t *n;  
  net_conn_t *conn;
} tentacle_t;

#endif /* _TENTACLE_H */
