#ifndef _MDFN_DRIVERS_INPUT_H
#define _MDFN_DRIVERS_INPUT_H
#define MAXBUTTCONFIG   4

typedef struct {
        uint8  ButtType;
        uint8  DeviceNum;;
        uint32 ButtonNum;
	uint64 DeviceID;
} ButtConfig;

extern CFGSTRUCT InputConfig[];

#define BUTTC_NONE		0x00
#define BUTTC_KEYBOARD          0x01
#define BUTTC_JOYSTICK          0x02
#define BUTTC_MOUSE             0x03

void InitOtherInput(MDFNGI *GI);

void ResyncOtherInput(void);

void KillOtherInput(void);
void KillOtherInputSettings(void); // Call after MDFNI_Kill() is called

void MDFND_UpdateInput(void);

#define MKK(k) SDLK_##k
#define MKK_COUNT (SDLK_LAST+1)

void MakeInputSettings(std::vector <MDFNSetting> &settings);

#endif
