#ifndef _INPUT_H
#include "input-driver.h"
#include "../state.h"

typedef struct {
        uint8 (*Read)(int w);
	void (*Write)(uint8 v);
        void (*Strobe)(int w);
	void (*Update)(int w, void *data, int arg);
	void (*SLHook)(int w, uint8 *bg, uint8 *spr, uint32 linets, int final);
	void (*Draw)(int w, uint32 *buf, int arg);
	int (*StateAction)(int w, StateMem *sm, int load, int data_only);
	int InDataElements;
	int InDataElementSize;
} INPUTC;

typedef struct {
	uint8 (*Read)(int w, uint8 ret);
	void (*Write)(uint8 v);
	void (*Strobe)(void);
        void (*Update)(void *data, int arg);
        void (*SLHook)(uint8 *bg, uint8 *spr, uint32 linets, int final);
        void (*Draw)(uint32 *buf, int arg);
        int (*StateAction)(StateMem *sm, int load, int data_only);
        int InDataElements;
        int InDataElementSize;
} INPUTCFC;

void MDFN_DrawInput(uint32 *buf);
void MDFN_UpdateInput(void);
void NESINPUT_Power(void);
void NESINPUT_Init(void);
int NESINPUT_StateAction(StateMem *sm, int load, int data_only);

extern void (*PStrobe[2])(void);
extern void (*InputScanlineHook)(uint8 *bg, uint8 *spr, uint32 linets, int final);

void MDFNNES_DoSimpleCommand(int cmd);
void MDFNNES_SetInput(int port, int type, void *ptr, int attrib);

#define _INPUT_H
#endif
