/*
 *    Copyright (C) 2010
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.update;

import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilmUpdate;
import mediathek.daten.ListeFilmUpdate;
import mediathek.gui.dialoge.DialogHinweis;
import mediathek.gui.dialoge.DialogHinweisZeit;

public class UpdateSuchen {

    private ListeFilmUpdate listeFilme;
    private Daten daten;

    public UpdateSuchen(Daten ddaten) {
        daten = ddaten;
        listeFilme = new ListeFilmUpdate();
    }

    public void suchen(boolean progUpdate) {
        String version = "";
        String release = "";
        String updateUrl = "";
        String parsername = "";
        try {
            int event;
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty(XMLInputFactory.IS_COALESCING, Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader inReader = null;
            String user_agent = daten.system[Konstanten.SYSTEM_USER_AGENT_NR];
            int timeout = 10000;
            URLConnection conn = null;
            conn = new URL(Konstanten.ADRESSE_UPDATE).openConnection();
            conn.setRequestProperty("User-Agent", user_agent);
            conn.setReadTimeout(timeout);
            conn.setConnectTimeout(timeout);
            inReader = new InputStreamReader(conn.getInputStream(), Konstanten.KODIERUNG_UTF);
            parser = inFactory.createXMLStreamReader(inReader);
            while (parser.hasNext()) {
                event = parser.next();
                if (event == XMLStreamConstants.START_ELEMENT) {
                    parsername = parser.getLocalName();
                    if (parser.getLocalName().equals("Program_Version")) {
                        version = parser.getElementText();
                    } else if (parser.getLocalName().equals("Program_Release_Info")) {
                        release = parser.getElementText();
                    } else if (parser.getLocalName().equals("Download_Programm")) {
                        updateUrl = parser.getElementText();
                    } else if (parser.getLocalName().equals("Server")) {
                        //wieder ein neuer Server, toll
                        getServer(parser);
                    }
                }
            }
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "UpdateSuchen.suchen:");
        }
        // ##########################
        // Serverupdate
        //nur dann die existierende Liste ersetzen
        if (listeFilme.alle.isEmpty()) {
            new DialogHinweis(null, true, daten,
                    "Es ist ein Fehler aufgetreten!"
                    + "\n\n"
                    + "Es konnten keine Updateserver zum aktualisieren der Filme"
                    + "\n"
                    + "gefunden werden."
                    + "\n\n"
                    + "", Konstanten.ADRESSE_ANLEITUNG_UPDATE,
                    "Online nach neuen Programmversionen suchen?",
                    Konstanten.SYSTEM_UPDATE_SUCHEN_NR, "Update suchen").setVisible(true);
        } else {
            daten.listeFilmUpdate = listeFilme; //Liste übernehmen
            daten.listeFilmUpdate.check20(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_UPDATE_20_NR])); // Liste aufbauen
            if (Funktionen.getUpdateFilme(daten) != Konstanten.UPDATE_FILME_AUS) {
                daten.filmeLaden.aktuellsterServer = daten.listeFilmUpdate.getAktuellster();
                daten.system[Konstanten.SYSTEM_IMPORT_URL_AUTO_NR] = daten.listeFilmUpdate.getRand(0); //eine Zufällige Adresse wählen
            }
            daten.setGeaendertSofort();
        }
        // ############################
        if (progUpdate) {
            if (!version.equals("")) {
                daten.system[Konstanten.SYSTEM_UPDATE_DATUM_NR] = Funktionen.getHeute_yyyyMMdd();
                String vers = Konstanten.VERSION;
                while (vers.endsWith("+")) {
                    vers = vers.substring(0, vers.length() - 1);
                }
                if (!version.equals(vers)) {
                    //public DialogHinweis(java.awt.Frame parent, boolean modal, Daten ddaten, String text, String uurl, String ttextCheck, int ccheck, String titel) {
                    new DialogHinweis(null, false, daten,
                            "   ==================================================\n"
                            + "   Neue Version:\n" + "   " + version + "\n\n"
                            + "   ==================================================\n"
                            + "   Änderungen:\n" + "   " + release + "\n\n"
                            + "   ==================================================\n"
                            + "   URL:\n"
                            + "   " + updateUrl + "\n\n",
                            updateUrl,
                            "Online nach neuen Programmversionen suchen?",
                            Konstanten.SYSTEM_UPDATE_SUCHEN_NR,
                            "Eine neue Version liegt vor").setVisible(true);
                } else {
                    new DialogHinweisZeit(null, false, "Alles aktuell!", "Update suchen", 5).setVisible(true);
                }
            } else {
                new DialogHinweis(null, true, daten,
                        "Es ist ein Fehler aufgetreten!"
                        + "\n\n"
                        + "", Konstanten.ADRESSE_DOWNLAD,
                        "Online nach neuen Programmversionen suchen?",
                        Konstanten.SYSTEM_UPDATE_SUCHEN_NR, "Update suchen").setVisible(true);
            }
        }
    }

    private void getServer(XMLStreamReader parser) {
        String anzahl = "";
        String zeit = "";
        String datum = "";
        String filmUrl = "";
        String parsername = "";
        String prio = "";
        int event;
        try {
            while (parser.hasNext()) {
                prio = Konstanten.FILM_UPDATE_PRIO_1;
                event = parser.next();
                if (event == XMLStreamConstants.END_ELEMENT) {
                    parsername = parser.getLocalName();
                    if (parser.getLocalName().equals("Server")) {
                        if (!filmUrl.equals("")) {
                            //public DatenFilmUpdate(String url, String prio, String zeit, String datum, String anzahl) {
                            listeFilme.addAlle(new DatenFilmUpdate(filmUrl, prio, zeit, datum, anzahl));
                        }
                        break;
                    }
                }
                if (event == XMLStreamConstants.START_ELEMENT) {
                    parsername = parser.getLocalName();
                    if (parser.getLocalName().equals("Download_Filme_1")) {
                        filmUrl = parser.getElementText();
                        prio = Konstanten.FILM_UPDATE_PRIO_1;
                    } else if (parser.getLocalName().equals("Download_Filme_2")) {
                        filmUrl = parser.getElementText();
                        prio = Konstanten.FILM_UPDATE_PRIO_2;
                    } else if (parser.getLocalName().equals("Datum")) {
                        datum = parser.getElementText();
                    } else if (parser.getLocalName().equals("Zeit")) {
                        zeit = parser.getElementText();
                    } else if (parser.getLocalName().equals("Anzahl")) {
                        anzahl = parser.getElementText();
                    }
                }
            }
        } catch (XMLStreamException ex) {
        }

    }
}
