/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.io;

import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;
import mediathek.Konstanten;
import mediathek.daten.Daten;

public class FeedReaderPodster {

    private Daten daten;
    private String[][] feeds = {{"http://podster.de/tag/business/opml", "Business"}, {"http://podster.de/tag/comedy/opml", "Comedy"},
                                {"http://podster.de/tag/filme/opml", "Filme"}, {"http://podster.de/tag/gesellschaft/opml", "Gesellschaft"},
                                {"http://podster.de/tag/kultur/opml", "Kultur"}, {"http://podster.de/tag/kunst/opml", "Kunst"},
                                {"http://podster.de/tag/musik/opml", "Musik"}, {"http://podster.de/tag/news/opml", "News"},
                                {"http://podster.de/tag/politik/opml", "Politik"}, {"http://podster.de/tag/privates/opml", "Privates"},
                                {"http://podster.de/tag/religion/opml", "Religion"}, {"http://podster.de/tag/spiele/opml", "Spiele"},
                                {"http://podster.de/tag/sport/opml", "Sport"}, {"http://podster.de/tag/technologie/opml", "Technologie"},
                                {"http://podster.de/tag/unterhaltung/opml", "Unterhaltung"}, {"http://podster.de/tag/wissenschaft/opml", "Wissenschaft"}
    };

    //===================================
    // public
    //===================================
    public FeedReaderPodster(Daten d) {
        daten = d;
    }

    public synchronized void starten() {
        daten.listePodster.clear();
        for (int i = 0; i < feeds.length; ++i) {
            new Laden(feeds[i][0], feeds[i][1]).laden();
        }
    }

    //===================================
    // private
    //===================================
    private class Laden {

        String feedurl = "";
        String thema = "";

        public Laden(String uurl, String tthema) {
            feedurl = uurl;
            thema = tthema;
        }

        public void laden() {
            try {
                if (!feedurl.equals("")) {
                    URL feedUrl = new URL(feedurl);
                    URLConnection conn = feedUrl.openConnection();
                    conn.setRequestProperty("User-Agent", daten.system[Konstanten.SYSTEM_USER_AGENT_NR]);
                    conn.setReadTimeout(2000);
                    int event;

                    XMLInputFactory inFactory = XMLInputFactory.newInstance();
                    inFactory.setProperty(XMLInputFactory.IS_COALESCING, Boolean.FALSE);
                    XMLStreamReader parser = null;
                    InputStreamReader in = null;
                    in = new InputStreamReader(conn.getInputStream(), Konstanten.KODIERUNG_ISO15);
                    parser = inFactory.createXMLStreamReader(in);
                    while (parser.hasNext()) {
                        event = parser.next();
                        if (event == XMLStreamConstants.START_ELEMENT) {
                            if (parser.getLocalName().equals("outline")) {
                                get(parser, thema);
                            }
                        }
                    }
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "FeedReaderPodster.Laden");
            }
        }

        private boolean get(XMLStreamReader parser, String thema) {
            boolean ret = true;
            String titel = "";
            String url = "";
            try {
                int attr = parser.getAttributeCount();
                String strAttr = "";
                for (int i = 0; i < attr; ++i) {
                    strAttr = parser.getAttributeLocalName(i);
                    if (strAttr.equals("title")) {
                        titel = parser.getAttributeValue(i);
                    }
                    if (strAttr.equals("url")) {
                        url = parser.getAttributeValue(i);
                    }
                }
                //Neues Podster-Object hinzufügen
                daten.listePodster.addPod(titel, url, thema);
            } catch (Exception ex) {
                ret = false;
            }
            return ret;
        }

    }

}


