/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme;

import mediathek.filme.sender.MediathekArd;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.TModelFilm;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.daten.Datum;
import mediathek.daten.ListeAbo;
import mediathek.io.starter.Starts;
import org.apache.commons.lang.StringEscapeUtils;

/**
 * 
 * @author emil
 */
public class ListeFilme extends LinkedList<DatenFilm> {

    private Daten daten;
    private TModel model = null;
    private int nr = 0;
    private final int MAX_STELLEN = 6;
    private final String FUELL_ZEICHEN = "0";

    /**
     * 
     * @param ddaten
     */
    public ListeFilme(Daten ddaten) {
        daten = ddaten;
    }

    //===================================
    // public
    //===================================
    @Override
    public synchronized void clear() {
        nr = 0;
        super.clear();
    }

    public void sort() {
        Collections.<DatenFilm>sort(this);
    }

    /**
     *
     * @param film
     * @return
     */
    @Override
    public synchronized boolean add(DatenFilm film) {
        String str = String.valueOf(nr++);
        while (str.length() < MAX_STELLEN) {
            str = FUELL_ZEICHEN + str;
        }
        film.arr[Konstanten.FILM_THEMA_NR] = StringEscapeUtils.unescapeHtml(film.arr[Konstanten.FILM_THEMA_NR].trim());
        film.arr[Konstanten.FILM_TITEL_NR] = StringEscapeUtils.unescapeHtml(film.arr[Konstanten.FILM_TITEL_NR].trim());
        film.arr[Konstanten.FILM_NR_NR] = str;
        return super.add(film);
    }

    public synchronized boolean superAdd(DatenFilm film) {
        //Nummer der Filme wird nicht geändert, muss schon stimmen
        return super.add(film);
    }

    public synchronized void delThema(String sender, String thema) {
        DatenFilm film = null;
        ListIterator<DatenFilm> it = this.listIterator(0);
        while (it.hasNext()) {
            film = it.next();
            if (film.arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(sender) && film.arr[Konstanten.FILM_THEMA_NR].equalsIgnoreCase(thema)) {
                it.remove();
            }
        }
    }

    public synchronized void delSender(String sender) {
        DatenFilm film = null;
        ListIterator<DatenFilm> it = this.listIterator(0);
        while (it.hasNext()) {
            film = it.next();
            if (film.arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(sender)) {
                it.remove();
            }
        }
    }

    public synchronized int countSender(String sender) {
        int ret = 0;
        ListIterator<DatenFilm> it = this.listIterator(0);
        while (it.hasNext()) {
            if (it.next().arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(sender)) {
                ++ret;
            }
        }
        return ret;
    }

    public synchronized void delOhneSender(String sender) {
        DatenFilm film = null;
        ListIterator<DatenFilm> it = this.listIterator(0);
        while (it.hasNext()) {
            film = it.next();
            if (!film.arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(sender)) {
                it.remove();
            }
        }
    }

    /**
     *
     * @param filterSender
     * @param filterThema
     * @param filterExakt
     * @param filterText
     * @return
     */
    public synchronized TModelFilm getModelTabFilme(String filterSender, String filterThema, boolean filterExakt, String filterText) {
        TModelFilm modelFilm = null;
        if (this.size() == 0) {
            return null;
        } else {
            ListeFilme liste = new ListeFilme(daten);
            Iterator<DatenFilm> it = this.iterator();
            DatenFilm film;
            while (it.hasNext()) {
                film = it.next();
                // aboPruefen(String senderSuchen, String themaSuchen, boolean themaExakt, String textSuchen,
                //                     String imSender, String imThema, String imText) {
                if (ListeAbo.aboPruefen(filterSender, filterThema, filterExakt, filterText,
                        film.arr[Konstanten.FILM_SENDER_NR], film.arr[Konstanten.FILM_THEMA_NR], film.arr[Konstanten.FILM_TITEL_NR])) {
                    liste.superAdd(film);
                }
            }
            modelFilm = new TModelFilm(liste.getObjectDataTabFilme(), Konstanten.FILME_COLUMN_NAMES);
            return modelFilm;
        }
    }

    /**
     * 
     * @return
     */
    public synchronized TModel getAboModel() {
        model = new TModel(this.getAboObjectData(), Konstanten.FILME_COLUMN_NAMES);
        return model;
    }

    public synchronized TModel getPodModel() {
        model = new TModel(this.getPodObjectData(), Konstanten.FILME_COLUMN_NAMES_POD);
        return model;
    }

    public synchronized String[] getModelOfField(int feld, String filterString, int filterFeld) {
        /* erstellt ein StringArray mit den Daten des Feldes und filtert nach filterFeld */
        LinkedList<String> list = new LinkedList<String>();
        String str = "";
        list.add("");
        DatenFilm film;
        Iterator<DatenFilm> it = this.iterator();
        if (filterString.equals("")) {
            //alle Werte dieses Feldes
            while (it.hasNext()) {
                str = it.next().arr[feld];
                //hinzufügen
                if (!list.contains(str)) {
                    list.add(str);
                }
            }
        } else {
            //Werte dieses Feldes, filtern nach filterString im FilterFeld
            while (it.hasNext()) {
                film = it.next();
                str = film.arr[feld];
                if (film.arr[filterFeld].equalsIgnoreCase(filterString)) {
                    //hinzufügen
                    if (!list.contains(str)) {
                        list.add(str);
                    }
                }
            }
        }
        Funktionen.listeSort(list);
        String[] ret = new String[0];
        ret = (String[]) list.toArray(ret);
        return ret;
    }

    /**
     * 
     * @param url
     * @return
     */
    public synchronized DatenFilm getFilmByUrl(String url) {
        DatenFilm ret = null;
        ListIterator<DatenFilm> it = this.listIterator(0);
        while (it.hasNext()) {
            DatenFilm f = it.next();
            if (f.arr[Konstanten.FILM_URL_NR].equals(url)) {
                ret = f;
                break;
            }
        }
        return ret;
    }

//    synchronized void leitungAendern() {
//        Iterator<DatenFilm> it = this.iterator();
//        DatenFilm film;
//        while (it.hasNext()) {
//            film = it.next();
//            if (film.arr[Konstanten.FILM_SENDER_NR].equals(Konstanten.SENDER_3SAT)) {
//                film.arr[Konstanten.FILM_URL_NR] = Mediathek3Sat.leitungAendern(daten, film);
//            } else if (film.arr[Konstanten.FILM_SENDER_NR].equals(Konstanten.SENDER_ZDF)) {
//                film.arr[Konstanten.FILM_URL_NR] = MediathekZdf.leitungAendern(daten, film);
//            } else if (film.arr[Konstanten.FILM_SENDER_NR].equals(Konstanten.SENDER_NDR)) {
//                film.arr[Konstanten.FILM_URL_NR] = MediathekNdr.leitungAendern(daten, film);
//            }
//        }
//    }
    public synchronized void rtmpAendern() {
        final String RTMP = "-r ";
        final String RTMP_PRTOKOLL = "rtmp";
        Iterator<DatenFilm> it = this.iterator();
        DatenFilm film;
        while (it.hasNext()) {
            film = it.next();
            if (film.arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(Konstanten.SENDER_ARD)) {
                //rtmpAendern(Daten daten, String urlorg, String urlRtmp)
                film.arr[Konstanten.FILM_URL_NR] = MediathekArd.rtmpAendern(daten, film.arr[Konstanten.FILM_URL_ORG_NR],
                        film.arr[Konstanten.FILM_URL_RTMP_NR]);
            } else {
                if (Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_LEITUNG_RTMP_NR])) {
                    if (film.arr[Konstanten.FILM_URL_NR].startsWith(RTMP_PRTOKOLL)) {
                        film.arr[Konstanten.FILM_URL_NR] = RTMP + film.arr[Konstanten.FILM_URL_NR];
                    }
                } else {
                    if (film.arr[Konstanten.FILM_URL_NR].startsWith(RTMP)) {
                        film.arr[Konstanten.FILM_URL_NR] = film.arr[Konstanten.FILM_URL_NR].substring(RTMP.length());
                    }

                }

            }
        }
    }

//    public synchronized void listeSpeichern() {
//        OutputStreamWriter writer = null;
//        DialogExport dialog = new DialogExport(null, true, daten, daten.system[Konstanten.SYSTEM_PFAD_EXPORT_ABOS_NR]);
//        dialog.setVisible(true);
//        if (dialog.ok) {
//            File f = new File(dialog.ziel);
//            if (!f.exists()
//                    || JOptionPane.showConfirmDialog(null, "Trotzdem anlegen und \u00fcberschreiben?",
//                    "Datei existiert bereits!", JOptionPane.YES_NO_OPTION) == JOptionPane.OK_OPTION) {
//                try {
//                    daten.system[Konstanten.SYSTEM_PFAD_EXPORT_ABOS_NR] = dialog.ziel;
//                    writer = new OutputStreamWriter(new FileOutputStream(f));
//                    //schreiben
//                    Iterator<DatenFilm> it = this.iterator();
//                    DatenFilm film;
//                    while (it.hasNext()) {
//                        film = it.next();
//                        writer.write("Sender: " + film.arr[Konstanten.FILM_SENDER_NR] + "\n"
//                                + "    Thema: " + film.arr[Konstanten.FILM_THEMA_NR] + "\n"
//                                + "    Titel: " + film.arr[Konstanten.FILM_TITEL_NR] + "\n"
//                                + "    Url: " + film.arr[Konstanten.FILM_URL_NR] + "\n");
//                    }
//                    //
//                } catch (Exception ex) {
//                    daten.fehler.fehlerMeldung(ex, "GuiAbo.zeileSchreiben");
//                } finally {
//                    try {
//                        writer.close();
//                    } catch (Exception ex) {
//                        daten.fehler.fehlerMeldung(ex, "GuiAbo.zeileSchreiben");
//                    }
//                }
//            }
//        }
//    }
    //===================================
    // private
    //===================================
    private Object[][] getObjectDataTabFilme() {
        Object[][] object = null;
        DatenFilm film;
        DatenAbo datenAbo;
        int i = 0;
        if (this.size() > 0) {
            ListIterator<DatenFilm> iterator = this.listIterator(0);
            object = new Object[this.size()][Konstanten.FILME_MAX_ELEM];
            while (iterator.hasNext()) {
                film = iterator.next();
                datenAbo = daten.listeAbo.getAbo(film.arr[Konstanten.FILM_SENDER_NR],
                        film.arr[Konstanten.FILM_THEMA_NR],
                        film.arr[Konstanten.FILM_TITEL_NR],
                        film.arr[Konstanten.FILM_URL_NR]);
                if (datenAbo != null) {
                    film.arr[Konstanten.FILM_ABO_NR] = datenAbo.arr[Konstanten.ABO_NAME_NR];
                } else {
                    film.arr[Konstanten.FILM_ABO_NR] = "";
                }
                for (int m = 0; m < Konstanten.FILME_MAX_ELEM; ++m) {
                    if (m == Konstanten.FILM_DATUM_NR) {
                        Datum tmp = new Datum(0);
                        if (!film.arr[Konstanten.FILM_DATUM_NR].equals("")) {
                            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                            try {
                                tmp.setTime(sdf.parse(film.arr[Konstanten.FILM_DATUM_NR]).getTime());
                            } catch (ParseException ex) {
                            }
                        }
                        object[i][m] = tmp;
                    } else {
                        object[i][m] = film.arr[m];
                    }
                }
//                object[i] = film.arr;
                ++i;
            }
        }
        return object;
    }

    private Object[][] getAboObjectData() {
        LinkedList<DatenFilm> liste = new LinkedList<DatenFilm>();
        Object[][] object = null;
        DatenFilm film;
        String zielPfad = "";
        String zielDateiname = "";
        DatenAbo abo;
        DatenProg datenProg;
        ListIterator<DatenFilm> itFilm = this.listIterator(0);
        while (itFilm.hasNext()) {
            film = itFilm.next();
            abo = daten.listeAbo.getAbo(film.arr[Konstanten.FILM_SENDER_NR],
                    film.arr[Konstanten.FILM_THEMA_NR],
                    film.arr[Konstanten.FILM_TITEL_NR],
                    film.arr[Konstanten.FILM_URL_NR]);
            if (abo != null) {
                if ((abo.binEinmal() && !Boolean.parseBoolean(abo.arr[Konstanten.ABO_EINMAL_ERLEDIGT_NR]))
                        || !daten.log.zeilePruefen(film.arr[Konstanten.FILM_URL_NR], Konstanten.LOG_DATEI_ZDF)) { //erst im Logfile suchen ob schon da gewesen
                    //Zeitstempel des Abos setzen
                    abo.arr[Konstanten.ABO_DOWN_DATUM_NR] = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
                    daten.setGeaendert();
                    //ende Zeitstempel
                    if (!checkListe(liste, film.arr[Konstanten.FILM_URL_NR])) {
                        //wenn nicht doppelt, dann anzeigen
                        //dann die passende Programmgruppe
                        DatenPgruppe gruppe = daten.listePgruppeAbo.getName(abo.arr[Konstanten.ABO_PGRUPPE_NR]);
                        if (gruppe != null) {
                            //mit der Url das passende Programm aus der Pgruppe finden
                            datenProg = gruppe.getProgUrl(film.arr[Konstanten.FILM_URL_NR]);
                            if (datenProg != null) {
                                if (gruppe.checkDownloadDirekt(daten, film.arr[Konstanten.FILM_URL_NR]) == Starts.ART_DOWNLOAD) {
                                    film.arr[Konstanten.FILM_PROG_NR] = "direkter Download";
                                } else {
                                    film.arr[Konstanten.FILM_PROG_NR] = datenProg.arr[Konstanten.PROGRAMM_NAME_NR];
                                }
                            }
                            zielDateiname = gruppe.getZielDateiname();
                            zielPfad = gruppe.getZielPfad();
                        }
                        zielPfad = abo.aboPfadAnhaengen(daten, zielPfad);
                        zielDateiname = film.dateiNamenBauen(zielPfad, zielDateiname);
                        liste.add(film);
                    }
                }
            }
        }
        if (liste.size() > 0) {
            object = new Object[liste.size()][Konstanten.FILME_MAX_ELEM];
            itFilm = liste.listIterator();
            int i = 0;
            while (itFilm.hasNext()) {
                film = itFilm.next();
                DatenAbo datenAbo = daten.listeAbo.getAbo(film.arr[Konstanten.FILM_SENDER_NR],
                        film.arr[Konstanten.FILM_THEMA_NR],
                        film.arr[Konstanten.FILM_TITEL_NR],
                        film.arr[Konstanten.FILM_URL_NR]);
                if (datenAbo != null) {
                    film.arr[Konstanten.FILM_ABO_NR] = datenAbo.arr[Konstanten.ABO_NAME_NR];
                }
                object[i] = film.arr;
                ++i;
            }
        }
        return object;
    }

    private Object[][] getPodObjectData() {
        LinkedList<DatenFilm> liste = new LinkedList<DatenFilm>();
        Object[][] object = null;
        DatenFilm film;
        int i = 0;
        String zielpfad;
        ListIterator<DatenFilm> itFilm = this.listIterator(0);
        while (itFilm.hasNext()) {
            film = itFilm.next();
            if ((zielpfad = daten.listePod.getZiel(film.arr[Konstanten.FILM_THEMA_NR])) != null) {
                if (!daten.log.zeilePruefen(film.arr[Konstanten.FILM_URL_NR], Konstanten.LOG_DATEI_POD)) {
                    if (!checkListe(liste, film.arr[Konstanten.FILM_URL_NR])) {
                        zielpfad = Funktionen.addsPfad(daten, daten.system[Konstanten.SYSTEM_ZIELPFAD_POD_NR], zielpfad);
                        film.dateiNamenBauen(zielpfad, Funktionen.getDateiName(daten, film.arr[Konstanten.FILM_URL_NR]));
                        liste.add(film);
                    }
                }
            }
        }
        if (liste.size() > 0) {
            object = new Object[liste.size()][Konstanten.FILME_MAX_ELEM];
            itFilm = liste.listIterator();
            while (itFilm.hasNext()) {
                object[i] = itFilm.next().arr;
                ++i;
            }
        }
        return object;
    }

    private boolean checkListe(LinkedList<DatenFilm> liste, String url) {
        boolean ret = false;
        DatenFilm film;
        ListIterator<DatenFilm> it = liste.listIterator();
        while (it.hasNext()) {
            film = it.next();
            if (url.equals(film.arr[Konstanten.FILM_URL_NR])) {
                ret = true;
                break;
            }
        }
        return ret;
    }
}
