/*
 *    Copyright (C) 20010
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme;

/**
 *
 * @author emil
 */
public class BeobFilmeLaden implements FilmListener {

    int max;
    int progress;
    int threads = 1;

    public BeobFilmeLaden() {
        max = 0;
        progress = 0;
    }

    @Override
    public void start(String sender, int m) {
        max = m;
        starten();
        if (max == 0) {
            initProgressBar(sender, threads, 1, 0, "");
        } else {
            initProgressBar(sender, threads, max, 0, "");
        }
    }

    @Override
    public void progress(String sender, String text) {
        if (!text.contains("*")) {
            ++progress;
        } else {
            text = text.replace("*", "");
        }
        if (progress > max) {
            progress = max;
        }
        initProgressBar(sender, threads, max, progress, text);
    }

    @Override
    public synchronized void fertig(String sender, boolean stop) {
        progress = 0;
        max = 0;
        threads = 0;
        beenden();
        initProgressBar(sender, threads, max, progress, "");
    }

    @Override
    public void addMax(String sender, int m) {
        max += m;
        initProgressBar(sender, threads, max, progress, "");
    }

    @Override
    public void threads(String sender, int tthreads) {
        threads = tthreads;
        initProgressBar(sender, threads, max, progress, "");
    }

    public void initProgressBar(String sender, int threads, int max, int progress, String text) {
    }

    public void starten() {
    }

    public void beenden() {
    }
}
