/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.daten;

import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Funktionen;
import mediathek.Konstanten;

public class ListePodster extends LinkedList<DatenPodster> {

    private int nr = 0;

    public void addPod(String name, String url, String thema) {
        addPod(new DatenPodster(name, url, thema));
    }

    public void addPod(DatenPodster datenPod) {
        String str = String.valueOf(nr++);
        while (str.length() < 3) {
            str = "0" + str;
        }
        datenPod.arr[Konstanten.POD_NR_NR] = str;
        super.add(datenPod);
    }

    public DatenPodster getPodNr(int i) {
        return super.get(i);
    }

    @Override
    public DatenPodster remove(int idx) {
        return super.remove(idx);
    }

    public void sort() {
        Collections.<DatenPodster>sort(this);
    }

    public Object[][] getObjectData() {
        Object[][] object;
        DatenPodster daten;
        int i = 0;
        ListIterator<DatenPodster> iterator = this.listIterator(0);
        object = new Object[this.size()][Konstanten.PODSTER_MAX_ELEM];
        while (iterator.hasNext()) {
            daten = iterator.next();
            object[i] = daten.arr;
            ++i;
        }
        return object;
    }

    public synchronized String[] getModelOfField(int feld) {
        /* erstellt ein StringArray mit den Daten des Feldes und filtert nach filterFeld */
        LinkedList<String> list = new LinkedList<String>();
        String[] ret;
        String str;
        for (int i = 0; i < this.size(); ++i) {
            str = this.get(i).arr[feld];
            if (!str.equals("")) {
                //hinzufügen
                if (!list.contains(str)) {
                    list.add(str);
                }
            }
        }
        Funktionen.listeSort(list);
        ret = new String[list.size() + 1];
        ret[0] = "";
        for (int i = 0; i < list.size(); ++i) {
            ret[i + 1] = list.get(i);
        }
        return ret;
    }

}
