/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.daten;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import mediathek.Konstanten;

public class ListePgruppe extends LinkedList<DatenPgruppe> {

    public ListePgruppe getCopyOfMe() {
        //Kopie dieser Liste zurückgeben
        ListePgruppe ret = new ListePgruppe();
        Iterator<DatenPgruppe> it = this.iterator();
        while (it.hasNext()) {
            ret.add(it.next().copy());
        }
        return ret;
    }

    public boolean nameExists(String name) {
        boolean ret = false;
        ListIterator<DatenPgruppe> it = this.listIterator(0);
        while (it.hasNext()) {
            if (it.next().arr[Konstanten.PROGRAMMGRUPPE_NAME_NR].equals(name)) {
                ret = true;
            }
        }
        return ret;
    }

    public void setDoppelklick(int nr) {
        //Doppelklick für Programmgruppe (Button) mit der Nr setzen und die anderen löschen
        ListIterator<DatenPgruppe> it = this.listIterator(0);
        while (it.hasNext()) {
            it.next().arr[Konstanten.PROGRAMMGRUPPE_DOPPELKLICK_NR] = Boolean.toString(false);
        }
        this.get(nr).arr[Konstanten.PROGRAMMGRUPPE_DOPPELKLICK_NR] = Boolean.toString(true);
    }

    public int getDoppelklick() {
        //Doppelklick (Button) mit der Nr suchen oder -1 zurückgeben
        int ret = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).arr[Konstanten.PROGRAMMGRUPPE_DOPPELKLICK_NR].equals(Boolean.toString(true))) {
                ret = i;
            }
        }
        return ret;
    }

    public DatenPgruppe getName(String name) {
        //liefert mit dem Namen eine Programmgruppe zurück
        //wird nichts gefunden, wird die erste Programmgruppe genommen
        DatenPgruppe ret = null;
        if (this.size() == 0) {
            JOptionPane.showMessageDialog(null, "Programme einrichten!",
                                          "Keine Programmgruppe", JOptionPane.INFORMATION_MESSAGE);
        } else if (this.size() == 1) {
            ret = this.getFirst();
        } else {
            ListIterator<DatenPgruppe> it = this.listIterator(0);
            while (it.hasNext()) {
                DatenPgruppe gruppe;
                gruppe = it.next();
                if (gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR].equals(name)) {
                    ret = gruppe;
                }
            }
            if (ret == null) {
                ret = this.getFirst();
            }
        }
        return ret;
    }

    public void duplicate(DatenPgruppe gruppe) {
        this.add(gruppe.copy());
    }

    public String[] getObjectDataCombo() {
        //liefert eine Liste aller Pgruppen
        String[] object;
        int i = 0;
        ListIterator<DatenPgruppe> it = this.listIterator(0);
        object = new String[this.size()];
        while (it.hasNext()) {
            object[i] = it.next().arr[Konstanten.PROGRAMMGRUPPE_NAME_NR];
            ++i;
        }
        return object;
    }

    public boolean freeLine(int idx) {
        //Wenn die Programmgruppe keinen Namen hat, leere Zeile
        boolean ret = true;
        DatenPgruppe pgruppe = this.get(idx);
        if (!pgruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR].equals("")) {
            ret = false;
        }
        return ret;
    }

    public int auf(int idx, boolean auf) {
        DatenPgruppe prog = this.remove(idx);
        int neu = idx;
        if (auf) {
            if (neu > 0) {
                --neu;
            }
        } else {
            if (neu < this.size()) {
                ++neu;
            }
        }
        this.add(neu, prog);
        return neu;
    }

}
