/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.daten;

import mediathek.Funktionen;
import mediathek.Konstanten;

public class DatenProg {

    public String[] arr;
//    public boolean standard = false;

    public DatenProg() {
        makeArr();
    }

    public DatenProg(String name, String programmpfad, String schalter) {
        makeArr();
        arr[Konstanten.PROGRAMM_NAME_NR] = name;
        arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] = programmpfad;
        arr[Konstanten.PROGRAMM_SCHALTER_NR] = schalter;
    }

//    public DatenProg(String name, String programmpfad, String schalter, boolean sstandard) {
//        makeArr();
//        arr[Konstanten.PROGRAMM_NAME_NR] = name;
//        arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] = programmpfad;
//        arr[Konstanten.PROGRAMM_SCHALTER_NR] = schalter;
////        standard = sstandard;
//    }

    public DatenProg(String name, String programmpfad, String schalter, String farbe) {
        makeArr();
        arr[Konstanten.PROGRAMM_NAME_NR] = name;
        arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] = programmpfad;
        arr[Konstanten.PROGRAMM_SCHALTER_NR] = schalter;
    }

    public DatenProg copy() {
        DatenProg ret = new DatenProg();
        for (int i = 0; i < arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        return ret;
    }

    public boolean urlTesten(String url) {
        //prüfen ob das Programm zur Url passt
        boolean ret = false;
        if (url != null) {
            //Felder sind entweder leer oder passen
            if (Funktionen.praefixTesten(this.arr[Konstanten.PROGRAMM_PRAEFIX_NR], url, true)
                && Funktionen.praefixTesten(this.arr[Konstanten.PROGRAMM_SUFFIX_NR], url, false)) {
                ret = true;
            }
        }
        return ret;
    }

    public String getBegehl() {
        return arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] + " " + arr[Konstanten.PROGRAMM_SCHALTER_NR];
    }

    //===================================
    // Private
    //===================================
    private void makeArr() {
        arr = new String[Konstanten.PROGRAMM_MAX_ELEM];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new String("");
        }
    }

}
