/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.daten;

import mediathek.Funktionen;
import mediathek.Konstanten;

public class DatenAbo implements Comparable<DatenAbo> {

    public String[] arr;

    public DatenAbo() {
        makeArr();
    }

    public DatenAbo(String name, String sender, String thema, boolean exakt, String titel, String ziel, String programmname) {
        makeArr();
        arr[Konstanten.ABO_NAME_NR] = name;
        arr[Konstanten.ABO_SENDER_NR] = sender;
        arr[Konstanten.ABO_THEMA_NR] = thema;
        arr[Konstanten.ABO_THEMA_EXAKT_NR] = Boolean.toString(exakt);
        arr[Konstanten.ABO_TITEL_NR] = titel;
        arr[Konstanten.ABO_ZIELPFAD_NR] = ziel;
        arr[Konstanten.ABO_PGRUPPE_NR] = programmname;
    }

    public DatenAbo getCopy() {
        DatenAbo ret = new DatenAbo();
        for (int i = 0; i < arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        return ret;
    }

    public boolean binEinmal() {
        // true wenn EinmalAbo
        if (arr[Konstanten.ABO_EINMAL_URL_NR].equals("")) {
            return false;
        } else {
            return true;
        }
    }

    public void aufMichKopieren(DatenAbo datenAbo) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new String(datenAbo.arr[i]);
        }
    }

    public String aboPfadAnhaengen(Daten daten, String pfad) {
        String ret = pfad;
        if (!arr[Konstanten.ABO_ZIELPFAD_NR].equals("")) {
            ret = Funktionen.addsPfad(daten, pfad, arr[Konstanten.ABO_ZIELPFAD_NR]);
        }
        return ret;
    }

    private void makeArr() {
        arr = new String[Konstanten.ABO_MAX_ELEM];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new String("");
        }
    }

    @Override
    public int compareTo(DatenAbo arg0) {
        return (arr[Konstanten.ABO_THEMA_NR].compareToIgnoreCase(((DatenAbo) arg0).arr[Konstanten.ABO_THEMA_NR]));
    }
}
