/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.daten;

import mediathek.io.starter.StarterClass;
import mediathek.gui.PanelListe;
import mediathek.gui.dialoge.DialogProgSimmulieren;
import mediathek.gui.GuiMediathek;
import mediathek.gui.menue.DialogMeldungen;
import java.io.File;
import mediathek.Fehler;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.filme.FilmeLaden;
import mediathek.filme.BeobTimerFilmeLaden;
import mediathek.filme.MediathekTimer;
import mediathek.io.IoXml;
import mediathek.io.Log;
import mediathek.io.FeedReaderPods;
import mediathek.io.FeedReaderPodster;
import mediathek.io.History;

public final class Daten {

    public FilmeLaden filmeLaden;
    public ListePgruppe listePgruppeButton;
    public ListePgruppe listePgruppeAbo;
    public ListeProg listeProgVorlagen;
    public ListeAbo listeAbo;
    public ListeBlacklist listeBlacklist;
    public ListePod listePod;
    public ListePodster listePodster;
    public ListeFilmUpdate listeFilmUpdate;
    public Log log;
    public IoXml ioXml;
    public String[] system;
    public GuiMediathek guiMediathek;
    public StarterClass starterClass;
    private boolean geaendert;
    private String basisverzeichnis;
    public PanelListe panelListe;
    public Boolean simmulieren = false;
    public DialogProgSimmulieren dialogLog = null;
    public DialogMeldungen dialogFehler = null;
    public boolean debug = false;
    public boolean progAusgabe = false;
    public boolean auto = false; //gestarte in der Funktion Auto
    public boolean noGui = false; //gestarte ohne Gui
    public FeedReaderPods feedReaderPods;
    public boolean keinFehlerFenster = false;
    public Fehler fehler;
    public FeedReaderPodster feedReaderPodster = null;
    public boolean allesLaden = false;
    public MediathekTimer timerLaden;
    public int neuLadenIn = Konstanten.NEU_LADEN_IN;
    public History history;

    public Daten(String basis, boolean ddebug, GuiMediathek gguiMediathek, boolean nnoGui) {
        basisverzeichnis = basis;
        debug = ddebug;
        noGui = nnoGui;
        geaendert = false;
        system = new String[Konstanten.SYSTEM_MAX_ELEM];
        for (int i = 0; i < system.length; ++i) {
            system[i] = "";
        }
        fehler = new Fehler(this);
        listeBlacklist = new ListeBlacklist(this);
        if (!noGui) {
            timerLaden = new MediathekTimer();
            new Thread(timerLaden).start();
            guiMediathek = gguiMediathek;
            panelListe = new PanelListe(this);
            listePgruppeButton = new ListePgruppe();
            listePgruppeAbo = new ListePgruppe();
            listeProgVorlagen = new ListeProg();
            listeAbo = new ListeAbo(this);
            listePod = new ListePod();
            listePodster = new ListePodster();
            listeFilmUpdate = new ListeFilmUpdate();
            //FeedReaderPodster
            feedReaderPodster = new FeedReaderPodster(this);
            feedReaderPods = new FeedReaderPods(this);
            log = new Log(this);
            system[Konstanten.SYSTEM_IMPORT_URL_AUTO_NR] = listeFilmUpdate.getRand(0);
        }
        //initialisieren
        system[Konstanten.SYSTEM_LEITUNG_NR] = Konstanten.LEITUNG_DSL2000;
        system[Konstanten.SYSTEM_MAX_DOWNLOAD_NR] = "2";
        system[Konstanten.SYSTEM_WARTEN_NR] = "1";
        system[Konstanten.SYSTEM_USER_AGENT_NR] = Funktionen.getStandardUserAgent();
        filmeLaden = new FilmeLaden(this);
        ioXml = new IoXml(this);
        if (!noGui) {
            history = new History(getBasisVerzeichnis(true) + Konstanten.LOG_DATEI_HISTORY);
            history.laden();
            ioXml.datenLesen();
            dialogFehler = new DialogMeldungen(this);
            timerLaden.addAdListener(new BeobTimerFilmeLaden(this));
            starterClass = new StarterClass(this);
            Funktionen.addProgVorlagen(this);
            if (listeFilmUpdate.size() == 0) {
                listeFilmUpdate.add(new DatenFilmUpdate("http://mediathek.perfectz.info/Mediathek_22.zip", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://mediathekview.xml.in/mediathek-00_00.zip", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://usrmed.netfast.org/mediathek-00_00.zip", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://mediathekview.xml.in/mediathek-00_02.zip", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://mediathekview.mezoka.com/mediathek-00_04.zip", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://mediathekview.spaceydu.de/mediathek-00_06.zip	", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://mediathek.000a.de/Mediathek_10.zip", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://mediathekview.heim.at/mediathek-00_14.zip", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://178.77.79.81/mediathek1/Mediathek_12.zip", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://178.77.79.81/mediathek2/Mediathek_14.zip", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://178.77.79.81/mediathek3/Mediathek_16.zip", "1"));
                listeFilmUpdate.add(new DatenFilmUpdate("http://178.77.79.81/mediathek4/Mediathek_18.zip", "1"));
            }
        } else if (!allesLaden) {
            // bei nogui fürs update
            ioXml.datenLesenFilme(); //die brauchen wir schon!
        }
        if (system[Konstanten.SYSTEM_WARTEN_NR].equals("")) {
            system[Konstanten.SYSTEM_WARTEN_NR] = "1";
        }
//        if (system[Konstanten.SYSTEM_ARTE_DE_NR].equals("")) {
//            system[Konstanten.SYSTEM_ARTE_DE_NR] = Boolean.toString(true);
//        }
        if (system[Konstanten.SYSTEM_HINWEIS_ANZEIGEN_NR].equals("")) {
            system[Konstanten.SYSTEM_HINWEIS_ANZEIGEN_NR] = Boolean.toString(true);
        }
        if (system[Konstanten.SYSTEM_LOOK_NR].equals("")) {
            system[Konstanten.SYSTEM_LOOK_NR] = "1";
        }
        if (system[Konstanten.SYSTEM_LEITUNG_RTMP_NR].equals("")) {
            system[Konstanten.SYSTEM_LEITUNG_RTMP_NR] = Boolean.toString(true);
        }
        if (system[Konstanten.SYSTEM_UPDATE_FILME_NR].equals("")) {
            system[Konstanten.SYSTEM_UPDATE_FILME_NR] = String.valueOf(Konstanten.UPDATE_FILME_URL);
        }
        //Version prüfen+++++++++++++++++++++++
        if (!system[Konstanten.SYSTEM_VERSION_NR].equals(Konstanten.VERSION)) {
            system[Konstanten.SYSTEM_USER_AGENT_NR] = Funktionen.getStandardUserAgent();
            //Version setzten
            system[Konstanten.SYSTEM_VERSION_NR] = Konstanten.VERSION;
        }
        //Version prüfen+++++++++++++++++++++++
    }

    /**
     *
     */
    public void setGeaendert() {
        if (!noGui) {
            this.panelListe.aendern();
        }
        geaendert = true;
    }

    /**
     *
     */
    public void setGeaendertSofort() {
        if (!noGui) {
            this.panelListe.aendern();
            this.panelListe.aendernSofort();
        }
        geaendert = true;
    }

    /**
     * 
     */
    public void setGeaendertOhnePanel() {
        geaendert = true;
    }

    public boolean isGeaendert() {
        return geaendert;
    }

    public void speichern() {
        ioXml.datenSchreiben();
    }

    public void allesAbbrechen() {
        if (starterClass != null) {
            starterClass.abbrechen();
        }
    }

    public void allesAbbrechenNachFilm() {
        if (starterClass != null) {
            starterClass.abbrechenNachFilm();
        }
    }

    public String getBasisVerzeichnis() {
        return getBasisVerzeichnis(false);
    }

    public String getBasisVerzeichnis(boolean anlegen) {
        String ret;
        if (basisverzeichnis.equals("")) {
            ret = System.getProperty("user.home") + File.separator + ".mediathek" + File.separator;
        } else {
            ret = basisverzeichnis;
        }
        if (anlegen) {
            File basis = new File(ret);
            if (!basis.exists()) {
                if (!basis.mkdir()) {
                    fehler.fehlerMeldung("Fehler!", new String[]{"Kann den Ordner zum Speichern der Daten nicht anlegen!",
                                "Daten.getBasisVerzeichnis"});
                }

            }
        }
        return ret;
    }
}
