//
// CustomSerializer.cs
//
// This code is autogenerated from SerializationCodeGenerator (and removed
// GeneratedReader, and renamed class name and namespace name.)
//
// Author:
//	Atsushi Enomoto <atsushi@ximian.com>
//
// (C)2004 Novell Inc.
//

//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
using System;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;
using System.Text;
using System.Collections;
using System.Globalization;

namespace System.Xml.Schema
{
	internal class XmlSchemaSerializationWriter : XmlSerializationWriter
	{
		public void WriteRoot_XmlSchema (object o)
		{
			WriteStartDocument ();
			System.Xml.Schema.XmlSchema ob = (System.Xml.Schema.XmlSchema) o;
			TopLevelElement ();
			WriteObject_XmlSchema (ob, "schema", "http://www.w3.org/2001/XMLSchema", true, false, true);
		}

		void WriteObject_XmlSchema (System.Xml.Schema.XmlSchema ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchema", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			if (ob.@ElementFormDefault != ((System.Xml.Schema.XmlSchemaForm) 0)) {
				WriteAttribute ("elementFormDefault", "", GetEnumValue_XmlSchemaForm (ob.@ElementFormDefault));
			}
			if (ob.@BlockDefault != ((System.Xml.Schema.XmlSchemaDerivationMethod) 256)) {
				WriteAttribute ("blockDefault", "", GetEnumValue_XmlSchemaDerivationMethod (ob.@BlockDefault));
			}
			WriteAttribute ("version", "", ob.@Version);
			if (ob.@FinalDefault != ((System.Xml.Schema.XmlSchemaDerivationMethod) 256)) {
				WriteAttribute ("finalDefault", "", GetEnumValue_XmlSchemaDerivationMethod (ob.@FinalDefault));
			}
			if (ob.@AttributeFormDefault != ((System.Xml.Schema.XmlSchemaForm) 0)) {
				WriteAttribute ("attributeFormDefault", "", GetEnumValue_XmlSchemaForm (ob.@AttributeFormDefault));
			}
			WriteAttribute ("targetNamespace", "", ob.@TargetNamespace);

			ICollection o133 = ob.@UnhandledAttributes;
			if (o133 != null) {
				foreach (XmlAttribute o134 in o133)
					WriteXmlAttribute (o134, ob);
			}

			if (ob.@Includes != null) {
				for (int n135 = 0; n135 < ob.@Includes.Count; n135++) {
					if (ob.@Includes[n135] == null) { }
					else if (ob.@Includes[n135].GetType() == typeof(System.Xml.Schema.XmlSchemaInclude)) {
						WriteObject_XmlSchemaInclude (((System.Xml.Schema.XmlSchemaInclude) ob.@Includes[n135]), "include", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Includes[n135].GetType() == typeof(System.Xml.Schema.XmlSchemaImport)) {
						WriteObject_XmlSchemaImport (((System.Xml.Schema.XmlSchemaImport) ob.@Includes[n135]), "import", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Includes[n135].GetType() == typeof(System.Xml.Schema.XmlSchemaRedefine)) {
						WriteObject_XmlSchemaRedefine (((System.Xml.Schema.XmlSchemaRedefine) ob.@Includes[n135]), "redefine", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Includes[n135]);
				}
			}
			if (ob.@Items != null) {
				for (int n136 = 0; n136 < ob.@Items.Count; n136++) {
					if (ob.@Items[n136] == null) { }
					else if (ob.@Items[n136].GetType() == typeof(System.Xml.Schema.XmlSchemaAttribute)) {
						WriteObject_XmlSchemaAttribute (((System.Xml.Schema.XmlSchemaAttribute) ob.@Items[n136]), "attribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n136].GetType() == typeof(System.Xml.Schema.XmlSchemaNotation)) {
						WriteObject_XmlSchemaNotation (((System.Xml.Schema.XmlSchemaNotation) ob.@Items[n136]), "notation", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n136].GetType() == typeof(System.Xml.Schema.XmlSchemaElement)) {
						WriteObject_XmlSchemaElement (((System.Xml.Schema.XmlSchemaElement) ob.@Items[n136]), "element", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n136].GetType() == typeof(System.Xml.Schema.XmlSchemaAttributeGroup)) {
						WriteObject_XmlSchemaAttributeGroup (((System.Xml.Schema.XmlSchemaAttributeGroup) ob.@Items[n136]), "attributeGroup", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n136].GetType() == typeof(System.Xml.Schema.XmlSchemaGroup)) {
						WriteObject_XmlSchemaGroup (((System.Xml.Schema.XmlSchemaGroup) ob.@Items[n136]), "group", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n136].GetType() == typeof(System.Xml.Schema.XmlSchemaAnnotation)) {
						WriteObject_XmlSchemaAnnotation (((System.Xml.Schema.XmlSchemaAnnotation) ob.@Items[n136]), "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n136].GetType() == typeof(System.Xml.Schema.XmlSchemaComplexType)) {
						WriteObject_XmlSchemaComplexType (((System.Xml.Schema.XmlSchemaComplexType) ob.@Items[n136]), "complexType", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n136].GetType() == typeof(System.Xml.Schema.XmlSchemaSimpleType)) {
						WriteObject_XmlSchemaSimpleType (((System.Xml.Schema.XmlSchemaSimpleType) ob.@Items[n136]), "simpleType", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Items[n136]);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaForm (System.Xml.Schema.XmlSchemaForm ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaForm", "");

			Writer.WriteString (GetEnumValue_XmlSchemaForm (ob));
			if (writeWrappingElem) WriteEndElement (ob);
		}

		string GetEnumValue_XmlSchemaForm (System.Xml.Schema.XmlSchemaForm val)
		{
			switch (val)
			{
				case System.Xml.Schema.XmlSchemaForm.Qualified: return "qualified";
				case System.Xml.Schema.XmlSchemaForm.Unqualified: return "unqualified";
				default: return ((long)val).ToString (CultureInfo.InvariantCulture);
			}
		}

		void WriteObject_XmlSchemaDerivationMethod (System.Xml.Schema.XmlSchemaDerivationMethod ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaDerivationMethod", "");

			Writer.WriteString (GetEnumValue_XmlSchemaDerivationMethod (ob));
			if (writeWrappingElem) WriteEndElement (ob);
		}

		string GetEnumValue_XmlSchemaDerivationMethod (System.Xml.Schema.XmlSchemaDerivationMethod val)
		{
			switch (val)
			{
				case System.Xml.Schema.XmlSchemaDerivationMethod.Empty: return "";
				case System.Xml.Schema.XmlSchemaDerivationMethod.Substitution: return "substitution";
				case System.Xml.Schema.XmlSchemaDerivationMethod.Extension: return "extension";
				case System.Xml.Schema.XmlSchemaDerivationMethod.Restriction: return "restriction";
				case System.Xml.Schema.XmlSchemaDerivationMethod.List: return "list";
				case System.Xml.Schema.XmlSchemaDerivationMethod.Union: return "union";
				case System.Xml.Schema.XmlSchemaDerivationMethod.All: return "#all";
				default:
					System.Text.StringBuilder sb = new System.Text.StringBuilder ();
					string[] enumNames = val.ToString().Split (',');
					foreach (string name in enumNames)
					{
						switch (name.Trim())
						{
							case "Empty": sb.Append ("").Append (' '); break; 
							case "Substitution": sb.Append ("substitution").Append (' '); break; 
							case "Extension": sb.Append ("extension").Append (' '); break; 
							case "Restriction": sb.Append ("restriction").Append (' '); break; 
							case "List": sb.Append ("list").Append (' '); break; 
							case "Union": sb.Append ("union").Append (' '); break; 
							case "All": sb.Append ("#all").Append (' '); break; 
							default: sb.Append (name.Trim()).Append (' '); break; 
						}
					}
					return sb.ToString ().Trim();
			}
		}

		void WriteObject_XmlSchemaInclude (System.Xml.Schema.XmlSchemaInclude ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaInclude", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("schemaLocation", "", ob.@SchemaLocation);
			WriteAttribute ("id", "", ob.@Id);

			ICollection o137 = ob.@UnhandledAttributes;
			if (o137 != null) {
				foreach (XmlAttribute o138 in o137)
					WriteXmlAttribute (o138, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaImport (System.Xml.Schema.XmlSchemaImport ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaImport", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("schemaLocation", "", ob.@SchemaLocation);
			WriteAttribute ("namespace", "", ob.@Namespace);
			WriteAttribute ("id", "", ob.@Id);

			ICollection o139 = ob.@UnhandledAttributes;
			if (o139 != null) {
				foreach (XmlAttribute o140 in o139)
					WriteXmlAttribute (o140, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaRedefine (System.Xml.Schema.XmlSchemaRedefine ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaRedefine", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("schemaLocation", "", ob.@SchemaLocation);
			WriteAttribute ("id", "", ob.@Id);

			ICollection o141 = ob.@UnhandledAttributes;
			if (o141 != null) {
				foreach (XmlAttribute o142 in o141)
					WriteXmlAttribute (o142, ob);
			}

			if (ob.@Items != null) {
				for (int n143 = 0; n143 < ob.@Items.Count; n143++) {
					if (ob.@Items[n143] == null) { }
					else if (ob.@Items[n143].GetType() == typeof(System.Xml.Schema.XmlSchemaGroup)) {
						WriteObject_XmlSchemaGroup (((System.Xml.Schema.XmlSchemaGroup) ob.@Items[n143]), "group", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n143].GetType() == typeof(System.Xml.Schema.XmlSchemaAttributeGroup)) {
						WriteObject_XmlSchemaAttributeGroup (((System.Xml.Schema.XmlSchemaAttributeGroup) ob.@Items[n143]), "attributeGroup", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n143].GetType() == typeof(System.Xml.Schema.XmlSchemaAnnotation)) {
						WriteObject_XmlSchemaAnnotation (((System.Xml.Schema.XmlSchemaAnnotation) ob.@Items[n143]), "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n143].GetType() == typeof(System.Xml.Schema.XmlSchemaSimpleType)) {
						WriteObject_XmlSchemaSimpleType (((System.Xml.Schema.XmlSchemaSimpleType) ob.@Items[n143]), "simpleType", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n143].GetType() == typeof(System.Xml.Schema.XmlSchemaComplexType)) {
						WriteObject_XmlSchemaComplexType (((System.Xml.Schema.XmlSchemaComplexType) ob.@Items[n143]), "complexType", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Items[n143]);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaAttribute (System.Xml.Schema.XmlSchemaAttribute ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaAttribute", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			if (ob.@Use != ((System.Xml.Schema.XmlSchemaUse) 0)) {
				WriteAttribute ("use", "", GetEnumValue_XmlSchemaUse (ob.@Use));
			}
			WriteAttribute ("ref", "", FromXmlQualifiedName (ob.@RefName));
			if (ob.@Form != ((System.Xml.Schema.XmlSchemaForm) 0)) {
				WriteAttribute ("form", "", GetEnumValue_XmlSchemaForm (ob.@Form));
			}
			WriteAttribute ("type", "", FromXmlQualifiedName (ob.@SchemaTypeName));
			if (ob.@FixedValue != null) {
				WriteAttribute ("fixed", "", ob.@FixedValue);
			}
			if (ob.@DefaultValue != null) {
				WriteAttribute ("default", "", ob.@DefaultValue);
			}
			WriteAttribute ("name", "", ob.@Name);

			ICollection o144 = ob.@UnhandledAttributes;
			if (o144 != null) {
				foreach (XmlAttribute o145 in o144)
					WriteXmlAttribute (o145, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			WriteObject_XmlSchemaSimpleType (ob.@SchemaType, "simpleType", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaNotation (System.Xml.Schema.XmlSchemaNotation ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaNotation", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("public", "", ob.@Public);
			WriteAttribute ("name", "", ob.@Name);
			WriteAttribute ("system", "", ob.@System);

			ICollection o146 = ob.@UnhandledAttributes;
			if (o146 != null) {
				foreach (XmlAttribute o147 in o146)
					WriteXmlAttribute (o147, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaElement (System.Xml.Schema.XmlSchemaElement ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaElement", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			if (ob.@Form != ((System.Xml.Schema.XmlSchemaForm) 0)) {
				WriteAttribute ("form", "", GetEnumValue_XmlSchemaForm (ob.@Form));
			}
			WriteAttribute ("minOccurs", "", ob.@MinOccursString);
			if (ob.@Final != ((System.Xml.Schema.XmlSchemaDerivationMethod) 256)) {
				WriteAttribute ("final", "", GetEnumValue_XmlSchemaDerivationMethod (ob.@Final));
			}
			WriteAttribute ("substitutionGroup", "", FromXmlQualifiedName (ob.@SubstitutionGroup));
			if (ob.@IsNillable != false) {
				WriteAttribute ("nillable", "", (ob.@IsNillable?"true":"false"));
			}
			if (ob.@IsAbstract != false) {
				WriteAttribute ("abstract", "", (ob.@IsAbstract?"true":"false"));
			}
			if (ob.@FixedValue != null) {
				WriteAttribute ("fixed", "", ob.@FixedValue);
			}
			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("maxOccurs", "", ob.@MaxOccursString);
			if (ob.@DefaultValue != null) {
				WriteAttribute ("default", "", ob.@DefaultValue);
			}
			if (ob.@Name != null) {
				WriteAttribute ("name", "", ob.@Name);
			}
			WriteAttribute ("ref", "", FromXmlQualifiedName (ob.@RefName));
			if (ob.@Block != ((System.Xml.Schema.XmlSchemaDerivationMethod) 256)) {
				WriteAttribute ("block", "", GetEnumValue_XmlSchemaDerivationMethod (ob.@Block));
			}
			WriteAttribute ("type", "", FromXmlQualifiedName (ob.@SchemaTypeName));

			ICollection o148 = ob.@UnhandledAttributes;
			if (o148 != null) {
				foreach (XmlAttribute o149 in o148)
					WriteXmlAttribute (o149, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@SchemaType is System.Xml.Schema.XmlSchemaSimpleType) {
				WriteObject_XmlSchemaSimpleType (((System.Xml.Schema.XmlSchemaSimpleType) ob.@SchemaType), "simpleType", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@SchemaType is System.Xml.Schema.XmlSchemaComplexType) {
				WriteObject_XmlSchemaComplexType (((System.Xml.Schema.XmlSchemaComplexType) ob.@SchemaType), "complexType", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			if (ob.@Constraints != null) {
				for (int n150 = 0; n150 < ob.@Constraints.Count; n150++) {
					if (ob.@Constraints[n150] == null) { }
					else if (ob.@Constraints[n150].GetType() == typeof(System.Xml.Schema.XmlSchemaKeyref)) {
						WriteObject_XmlSchemaKeyref (((System.Xml.Schema.XmlSchemaKeyref) ob.@Constraints[n150]), "keyref", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Constraints[n150].GetType() == typeof(System.Xml.Schema.XmlSchemaUnique)) {
						WriteObject_XmlSchemaUnique (((System.Xml.Schema.XmlSchemaUnique) ob.@Constraints[n150]), "unique", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Constraints[n150].GetType() == typeof(System.Xml.Schema.XmlSchemaKey)) {
						WriteObject_XmlSchemaKey (((System.Xml.Schema.XmlSchemaKey) ob.@Constraints[n150]), "key", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Constraints[n150]);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaAttributeGroup (System.Xml.Schema.XmlSchemaAttributeGroup ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaAttributeGroup", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("name", "", ob.@Name);

			ICollection o151 = ob.@UnhandledAttributes;
			if (o151 != null) {
				foreach (XmlAttribute o152 in o151)
					WriteXmlAttribute (o152, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Attributes != null) {
				for (int n153 = 0; n153 < ob.@Attributes.Count; n153++) {
					if (ob.@Attributes[n153] == null) { }
					else if (ob.@Attributes[n153].GetType() == typeof(System.Xml.Schema.XmlSchemaAttributeGroupRef)) {
						WriteObject_XmlSchemaAttributeGroupRef (((System.Xml.Schema.XmlSchemaAttributeGroupRef) ob.@Attributes[n153]), "attributeGroup", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Attributes[n153].GetType() == typeof(System.Xml.Schema.XmlSchemaAttribute)) {
						WriteObject_XmlSchemaAttribute (((System.Xml.Schema.XmlSchemaAttribute) ob.@Attributes[n153]), "attribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Attributes[n153]);
				}
			}
			WriteObject_XmlSchemaAnyAttribute (ob.@AnyAttribute, "anyAttribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaGroup (System.Xml.Schema.XmlSchemaGroup ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaGroup", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("name", "", ob.@Name);

			ICollection o154 = ob.@UnhandledAttributes;
			if (o154 != null) {
				foreach (XmlAttribute o155 in o154)
					WriteXmlAttribute (o155, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Particle is System.Xml.Schema.XmlSchemaChoice) {
				WriteObject_XmlSchemaChoice (((System.Xml.Schema.XmlSchemaChoice) ob.@Particle), "choice", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaSequence) {
				WriteObject_XmlSchemaSequence (((System.Xml.Schema.XmlSchemaSequence) ob.@Particle), "sequence", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaAll) {
				WriteObject_XmlSchemaAll (((System.Xml.Schema.XmlSchemaAll) ob.@Particle), "all", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaAnnotation (System.Xml.Schema.XmlSchemaAnnotation ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaAnnotation", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);

			ICollection o156 = ob.@UnhandledAttributes;
			if (o156 != null) {
				foreach (XmlAttribute o157 in o156)
					WriteXmlAttribute (o157, ob);
			}

			if (ob.@Items != null) {
				for (int n158 = 0; n158 < ob.@Items.Count; n158++) {
					if (ob.@Items[n158] == null) { }
					else if (ob.@Items[n158].GetType() == typeof(System.Xml.Schema.XmlSchemaAppInfo)) {
						WriteObject_XmlSchemaAppInfo (((System.Xml.Schema.XmlSchemaAppInfo) ob.@Items[n158]), "appinfo", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n158].GetType() == typeof(System.Xml.Schema.XmlSchemaDocumentation)) {
						WriteObject_XmlSchemaDocumentation (((System.Xml.Schema.XmlSchemaDocumentation) ob.@Items[n158]), "documentation", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Items[n158]);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaComplexType (System.Xml.Schema.XmlSchemaComplexType ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaComplexType", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			if (ob.@IsAbstract != false) {
				WriteAttribute ("abstract", "", (ob.@IsAbstract?"true":"false"));
			}
			WriteAttribute ("name", "", ob.@Name);
			if (ob.@IsMixed != false) {
				WriteAttribute ("mixed", "", (ob.@IsMixed?"true":"false"));
			}
			if (ob.@Block != ((System.Xml.Schema.XmlSchemaDerivationMethod) 256)) {
				WriteAttribute ("block", "", GetEnumValue_XmlSchemaDerivationMethod (ob.@Block));
			}
			if (ob.@Final != ((System.Xml.Schema.XmlSchemaDerivationMethod) 256)) {
				WriteAttribute ("final", "", GetEnumValue_XmlSchemaDerivationMethod (ob.@Final));
			}

			ICollection o159 = ob.@UnhandledAttributes;
			if (o159 != null) {
				foreach (XmlAttribute o160 in o159)
					WriteXmlAttribute (o160, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@ContentModel is System.Xml.Schema.XmlSchemaSimpleContent) {
				WriteObject_XmlSchemaSimpleContent (((System.Xml.Schema.XmlSchemaSimpleContent) ob.@ContentModel), "simpleContent", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@ContentModel is System.Xml.Schema.XmlSchemaComplexContent) {
				WriteObject_XmlSchemaComplexContent (((System.Xml.Schema.XmlSchemaComplexContent) ob.@ContentModel), "complexContent", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			if (ob.@Particle is System.Xml.Schema.XmlSchemaChoice) {
				WriteObject_XmlSchemaChoice (((System.Xml.Schema.XmlSchemaChoice) ob.@Particle), "choice", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaSequence) {
				WriteObject_XmlSchemaSequence (((System.Xml.Schema.XmlSchemaSequence) ob.@Particle), "sequence", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaAll) {
				WriteObject_XmlSchemaAll (((System.Xml.Schema.XmlSchemaAll) ob.@Particle), "all", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaGroupRef) {
				WriteObject_XmlSchemaGroupRef (((System.Xml.Schema.XmlSchemaGroupRef) ob.@Particle), "group", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			if (ob.@Attributes != null) {
				for (int n161 = 0; n161 < ob.@Attributes.Count; n161++) {
					if (ob.@Attributes[n161] == null) { }
					else if (ob.@Attributes[n161].GetType() == typeof(System.Xml.Schema.XmlSchemaAttributeGroupRef)) {
						WriteObject_XmlSchemaAttributeGroupRef (((System.Xml.Schema.XmlSchemaAttributeGroupRef) ob.@Attributes[n161]), "attributeGroup", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Attributes[n161].GetType() == typeof(System.Xml.Schema.XmlSchemaAttribute)) {
						WriteObject_XmlSchemaAttribute (((System.Xml.Schema.XmlSchemaAttribute) ob.@Attributes[n161]), "attribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Attributes[n161]);
				}
			}
			WriteObject_XmlSchemaAnyAttribute (ob.@AnyAttribute, "anyAttribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaSimpleType (System.Xml.Schema.XmlSchemaSimpleType ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaSimpleType", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("name", "", ob.@Name);
			if (ob.@Final != ((System.Xml.Schema.XmlSchemaDerivationMethod) 256)) {
				WriteAttribute ("final", "", GetEnumValue_XmlSchemaDerivationMethod (ob.@Final));
			}

			ICollection o162 = ob.@UnhandledAttributes;
			if (o162 != null) {
				foreach (XmlAttribute o163 in o162)
					WriteXmlAttribute (o163, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Content is System.Xml.Schema.XmlSchemaSimpleTypeUnion) {
				WriteObject_XmlSchemaSimpleTypeUnion (((System.Xml.Schema.XmlSchemaSimpleTypeUnion) ob.@Content), "union", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Content is System.Xml.Schema.XmlSchemaSimpleTypeList) {
				WriteObject_XmlSchemaSimpleTypeList (((System.Xml.Schema.XmlSchemaSimpleTypeList) ob.@Content), "list", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Content is System.Xml.Schema.XmlSchemaSimpleTypeRestriction) {
				WriteObject_XmlSchemaSimpleTypeRestriction (((System.Xml.Schema.XmlSchemaSimpleTypeRestriction) ob.@Content), "restriction", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaUse (System.Xml.Schema.XmlSchemaUse ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaUse", "");

			Writer.WriteString (GetEnumValue_XmlSchemaUse (ob));
			if (writeWrappingElem) WriteEndElement (ob);
		}

		string GetEnumValue_XmlSchemaUse (System.Xml.Schema.XmlSchemaUse val)
		{
			switch (val)
			{
				case System.Xml.Schema.XmlSchemaUse.Optional: return "optional";
				case System.Xml.Schema.XmlSchemaUse.Prohibited: return "prohibited";
				case System.Xml.Schema.XmlSchemaUse.Required: return "required";
				default: return ((long)val).ToString (CultureInfo.InvariantCulture);
			}
		}

		void WriteObject_XmlSchemaKeyref (System.Xml.Schema.XmlSchemaKeyref ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaKeyref", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("refer", "", FromXmlQualifiedName (ob.@Refer));
			WriteAttribute ("name", "", ob.@Name);

			ICollection o164 = ob.@UnhandledAttributes;
			if (o164 != null) {
				foreach (XmlAttribute o165 in o164)
					WriteXmlAttribute (o165, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			WriteObject_XmlSchemaXPath (ob.@Selector, "selector", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Fields != null) {
				for (int n166 = 0; n166 < ob.@Fields.Count; n166++) {
					WriteObject_XmlSchemaXPath (((System.Xml.Schema.XmlSchemaXPath) ob.@Fields[n166]), "field", "http://www.w3.org/2001/XMLSchema", false, false, true);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaUnique (System.Xml.Schema.XmlSchemaUnique ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaUnique", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("name", "", ob.@Name);

			ICollection o167 = ob.@UnhandledAttributes;
			if (o167 != null) {
				foreach (XmlAttribute o168 in o167)
					WriteXmlAttribute (o168, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			WriteObject_XmlSchemaXPath (ob.@Selector, "selector", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Fields != null) {
				for (int n169 = 0; n169 < ob.@Fields.Count; n169++) {
					WriteObject_XmlSchemaXPath (((System.Xml.Schema.XmlSchemaXPath) ob.@Fields[n169]), "field", "http://www.w3.org/2001/XMLSchema", false, false, true);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaKey (System.Xml.Schema.XmlSchemaKey ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaKey", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("name", "", ob.@Name);

			ICollection o170 = ob.@UnhandledAttributes;
			if (o170 != null) {
				foreach (XmlAttribute o171 in o170)
					WriteXmlAttribute (o171, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			WriteObject_XmlSchemaXPath (ob.@Selector, "selector", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Fields != null) {
				for (int n172 = 0; n172 < ob.@Fields.Count; n172++) {
					WriteObject_XmlSchemaXPath (((System.Xml.Schema.XmlSchemaXPath) ob.@Fields[n172]), "field", "http://www.w3.org/2001/XMLSchema", false, false, true);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaAttributeGroupRef (System.Xml.Schema.XmlSchemaAttributeGroupRef ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaAttributeGroupRef", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("ref", "", FromXmlQualifiedName (ob.@RefName));

			ICollection o173 = ob.@UnhandledAttributes;
			if (o173 != null) {
				foreach (XmlAttribute o174 in o173)
					WriteXmlAttribute (o174, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaAnyAttribute (System.Xml.Schema.XmlSchemaAnyAttribute ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaAnyAttribute", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			if (ob.@ProcessContents != ((System.Xml.Schema.XmlSchemaContentProcessing) 0)) {
				WriteAttribute ("processContents", "", GetEnumValue_XmlSchemaContentProcessing (ob.@ProcessContents));
			}
			WriteAttribute ("namespace", "", ob.@Namespace);

			ICollection o175 = ob.@UnhandledAttributes;
			if (o175 != null) {
				foreach (XmlAttribute o176 in o175)
					WriteXmlAttribute (o176, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaChoice (System.Xml.Schema.XmlSchemaChoice ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaChoice", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("maxOccurs", "", ob.@MaxOccursString);
			WriteAttribute ("minOccurs", "", ob.@MinOccursString);

			ICollection o177 = ob.@UnhandledAttributes;
			if (o177 != null) {
				foreach (XmlAttribute o178 in o177)
					WriteXmlAttribute (o178, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Items != null) {
				for (int n179 = 0; n179 < ob.@Items.Count; n179++) {
					if (ob.@Items[n179] == null) { }
					else if (ob.@Items[n179].GetType() == typeof(System.Xml.Schema.XmlSchemaChoice)) {
						WriteObject_XmlSchemaChoice (((System.Xml.Schema.XmlSchemaChoice) ob.@Items[n179]), "choice", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n179].GetType() == typeof(System.Xml.Schema.XmlSchemaElement)) {
						WriteObject_XmlSchemaElement (((System.Xml.Schema.XmlSchemaElement) ob.@Items[n179]), "element", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n179].GetType() == typeof(System.Xml.Schema.XmlSchemaAny)) {
						WriteObject_XmlSchemaAny (((System.Xml.Schema.XmlSchemaAny) ob.@Items[n179]), "any", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n179].GetType() == typeof(System.Xml.Schema.XmlSchemaGroupRef)) {
						WriteObject_XmlSchemaGroupRef (((System.Xml.Schema.XmlSchemaGroupRef) ob.@Items[n179]), "group", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n179].GetType() == typeof(System.Xml.Schema.XmlSchemaSequence)) {
						WriteObject_XmlSchemaSequence (((System.Xml.Schema.XmlSchemaSequence) ob.@Items[n179]), "sequence", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Items[n179]);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaSequence (System.Xml.Schema.XmlSchemaSequence ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaSequence", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("maxOccurs", "", ob.@MaxOccursString);
			WriteAttribute ("minOccurs", "", ob.@MinOccursString);

			ICollection o180 = ob.@UnhandledAttributes;
			if (o180 != null) {
				foreach (XmlAttribute o181 in o180)
					WriteXmlAttribute (o181, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Items != null) {
				for (int n182 = 0; n182 < ob.@Items.Count; n182++) {
					if (ob.@Items[n182] == null) { }
					else if (ob.@Items[n182].GetType() == typeof(System.Xml.Schema.XmlSchemaAny)) {
						WriteObject_XmlSchemaAny (((System.Xml.Schema.XmlSchemaAny) ob.@Items[n182]), "any", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n182].GetType() == typeof(System.Xml.Schema.XmlSchemaSequence)) {
						WriteObject_XmlSchemaSequence (((System.Xml.Schema.XmlSchemaSequence) ob.@Items[n182]), "sequence", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n182].GetType() == typeof(System.Xml.Schema.XmlSchemaChoice)) {
						WriteObject_XmlSchemaChoice (((System.Xml.Schema.XmlSchemaChoice) ob.@Items[n182]), "choice", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n182].GetType() == typeof(System.Xml.Schema.XmlSchemaGroupRef)) {
						WriteObject_XmlSchemaGroupRef (((System.Xml.Schema.XmlSchemaGroupRef) ob.@Items[n182]), "group", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Items[n182].GetType() == typeof(System.Xml.Schema.XmlSchemaElement)) {
						WriteObject_XmlSchemaElement (((System.Xml.Schema.XmlSchemaElement) ob.@Items[n182]), "element", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Items[n182]);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaAll (System.Xml.Schema.XmlSchemaAll ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaAll", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("maxOccurs", "", ob.@MaxOccursString);
			WriteAttribute ("minOccurs", "", ob.@MinOccursString);

			ICollection o183 = ob.@UnhandledAttributes;
			if (o183 != null) {
				foreach (XmlAttribute o184 in o183)
					WriteXmlAttribute (o184, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Items != null) {
				for (int n185 = 0; n185 < ob.@Items.Count; n185++) {
					WriteObject_XmlSchemaElement (((System.Xml.Schema.XmlSchemaElement) ob.@Items[n185]), "element", "http://www.w3.org/2001/XMLSchema", false, false, true);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaAppInfo (System.Xml.Schema.XmlSchemaAppInfo ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaAppInfo", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("source", "", ob.@Source);

			if (ob.@Markup != null) {
				foreach (XmlNode o186 in ob.@Markup) {
					XmlElement o187 = o186 as XmlElement;
					if (o187 == null) throw CreateUnknownTypeException (o187);
					WriteElementLiteral (o187, "", "", false, true);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaDocumentation (System.Xml.Schema.XmlSchemaDocumentation ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaDocumentation", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("xml:lang", "", ob.@Language);
			WriteAttribute ("source", "", ob.@Source);

			if (ob.@Markup != null) {
				foreach (XmlNode o188 in ob.@Markup) {
					XmlElement o189 = o188 as XmlElement;
					if (o189 == null) throw CreateUnknownTypeException (o189);
					WriteElementLiteral (o189, "", "", false, true);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaSimpleContent (System.Xml.Schema.XmlSchemaSimpleContent ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaSimpleContent", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);

			ICollection o190 = ob.@UnhandledAttributes;
			if (o190 != null) {
				foreach (XmlAttribute o191 in o190)
					WriteXmlAttribute (o191, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Content is System.Xml.Schema.XmlSchemaSimpleContentRestriction) {
				WriteObject_XmlSchemaSimpleContentRestriction (((System.Xml.Schema.XmlSchemaSimpleContentRestriction) ob.@Content), "restriction", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Content is System.Xml.Schema.XmlSchemaSimpleContentExtension) {
				WriteObject_XmlSchemaSimpleContentExtension (((System.Xml.Schema.XmlSchemaSimpleContentExtension) ob.@Content), "extension", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaComplexContent (System.Xml.Schema.XmlSchemaComplexContent ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaComplexContent", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("mixed", "", (ob.@IsMixed?"true":"false"));

			ICollection o192 = ob.@UnhandledAttributes;
			if (o192 != null) {
				foreach (XmlAttribute o193 in o192)
					WriteXmlAttribute (o193, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Content is System.Xml.Schema.XmlSchemaComplexContentRestriction) {
				WriteObject_XmlSchemaComplexContentRestriction (((System.Xml.Schema.XmlSchemaComplexContentRestriction) ob.@Content), "restriction", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Content is System.Xml.Schema.XmlSchemaComplexContentExtension) {
				WriteObject_XmlSchemaComplexContentExtension (((System.Xml.Schema.XmlSchemaComplexContentExtension) ob.@Content), "extension", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaGroupRef (System.Xml.Schema.XmlSchemaGroupRef ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaGroupRef", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("maxOccurs", "", ob.@MaxOccursString);
			WriteAttribute ("minOccurs", "", ob.@MinOccursString);
			WriteAttribute ("ref", "", FromXmlQualifiedName (ob.@RefName));

			ICollection o194 = ob.@UnhandledAttributes;
			if (o194 != null) {
				foreach (XmlAttribute o195 in o194)
					WriteXmlAttribute (o195, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaSimpleTypeUnion (System.Xml.Schema.XmlSchemaSimpleTypeUnion ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaSimpleTypeUnion", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			string s196 = null;
			if (ob.@MemberTypes != null) {
				System.Text.StringBuilder s197 = new System.Text.StringBuilder();
				for (int n198 = 0; n198 < ob.@MemberTypes.Length; n198++) {
					s197.Append (FromXmlQualifiedName (ob.@MemberTypes[n198])).Append (" ");
				}
				s196 = s197.ToString ().Trim ();
			}
			WriteAttribute ("memberTypes", "", s196);

			ICollection o199 = ob.@UnhandledAttributes;
			if (o199 != null) {
				foreach (XmlAttribute o200 in o199)
					WriteXmlAttribute (o200, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@BaseTypes != null) {
				for (int n201 = 0; n201 < ob.@BaseTypes.Count; n201++) {
					WriteObject_XmlSchemaSimpleType (((System.Xml.Schema.XmlSchemaSimpleType) ob.@BaseTypes[n201]), "simpleType", "http://www.w3.org/2001/XMLSchema", false, false, true);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaSimpleTypeList (System.Xml.Schema.XmlSchemaSimpleTypeList ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaSimpleTypeList", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("itemType", "", FromXmlQualifiedName (ob.@ItemTypeName));

			ICollection o202 = ob.@UnhandledAttributes;
			if (o202 != null) {
				foreach (XmlAttribute o203 in o202)
					WriteXmlAttribute (o203, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			WriteObject_XmlSchemaSimpleType (ob.@ItemType, "simpleType", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaSimpleTypeRestriction (System.Xml.Schema.XmlSchemaSimpleTypeRestriction ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaSimpleTypeRestriction", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("base", "", FromXmlQualifiedName (ob.@BaseTypeName));

			ICollection o204 = ob.@UnhandledAttributes;
			if (o204 != null) {
				foreach (XmlAttribute o205 in o204)
					WriteXmlAttribute (o205, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			WriteObject_XmlSchemaSimpleType (ob.@BaseType, "simpleType", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Facets != null) {
				for (int n206 = 0; n206 < ob.@Facets.Count; n206++) {
					if (ob.@Facets[n206] == null) { }
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaPatternFacet)) {
						WriteObject_XmlSchemaPatternFacet (((System.Xml.Schema.XmlSchemaPatternFacet) ob.@Facets[n206]), "pattern", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaWhiteSpaceFacet)) {
						WriteObject_XmlSchemaWhiteSpaceFacet (((System.Xml.Schema.XmlSchemaWhiteSpaceFacet) ob.@Facets[n206]), "whiteSpace", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaEnumerationFacet)) {
						WriteObject_XmlSchemaEnumerationFacet (((System.Xml.Schema.XmlSchemaEnumerationFacet) ob.@Facets[n206]), "enumeration", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaMaxLengthFacet)) {
						WriteObject_XmlSchemaMaxLengthFacet (((System.Xml.Schema.XmlSchemaMaxLengthFacet) ob.@Facets[n206]), "maxLength", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaMinLengthFacet)) {
						WriteObject_XmlSchemaMinLengthFacet (((System.Xml.Schema.XmlSchemaMinLengthFacet) ob.@Facets[n206]), "minLength", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaLengthFacet)) {
						WriteObject_XmlSchemaLengthFacet (((System.Xml.Schema.XmlSchemaLengthFacet) ob.@Facets[n206]), "length", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaFractionDigitsFacet)) {
						WriteObject_XmlSchemaFractionDigitsFacet (((System.Xml.Schema.XmlSchemaFractionDigitsFacet) ob.@Facets[n206]), "fractionDigits", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaTotalDigitsFacet)) {
						WriteObject_XmlSchemaTotalDigitsFacet (((System.Xml.Schema.XmlSchemaTotalDigitsFacet) ob.@Facets[n206]), "totalDigits", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaMaxInclusiveFacet)) {
						WriteObject_XmlSchemaMaxInclusiveFacet (((System.Xml.Schema.XmlSchemaMaxInclusiveFacet) ob.@Facets[n206]), "maxInclusive", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaMaxExclusiveFacet)) {
						WriteObject_XmlSchemaMaxExclusiveFacet (((System.Xml.Schema.XmlSchemaMaxExclusiveFacet) ob.@Facets[n206]), "maxExclusive", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaMinInclusiveFacet)) {
						WriteObject_XmlSchemaMinInclusiveFacet (((System.Xml.Schema.XmlSchemaMinInclusiveFacet) ob.@Facets[n206]), "minInclusive", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n206].GetType() == typeof(System.Xml.Schema.XmlSchemaMinExclusiveFacet)) {
						WriteObject_XmlSchemaMinExclusiveFacet (((System.Xml.Schema.XmlSchemaMinExclusiveFacet) ob.@Facets[n206]), "minExclusive", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Facets[n206]);
				}
			}
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaXPath (System.Xml.Schema.XmlSchemaXPath ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaXPath", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			if (ob.@XPath != null) {
				WriteAttribute ("xpath", "", ob.@XPath);
			}

			ICollection o207 = ob.@UnhandledAttributes;
			if (o207 != null) {
				foreach (XmlAttribute o208 in o207)
					WriteXmlAttribute (o208, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaContentProcessing (System.Xml.Schema.XmlSchemaContentProcessing ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaContentProcessing", "");

			Writer.WriteString (GetEnumValue_XmlSchemaContentProcessing (ob));
			if (writeWrappingElem) WriteEndElement (ob);
		}

		string GetEnumValue_XmlSchemaContentProcessing (System.Xml.Schema.XmlSchemaContentProcessing val)
		{
			switch (val)
			{
				case System.Xml.Schema.XmlSchemaContentProcessing.Skip: return "skip";
				case System.Xml.Schema.XmlSchemaContentProcessing.Lax: return "lax";
				case System.Xml.Schema.XmlSchemaContentProcessing.Strict: return "strict";
				default: return ((long)val).ToString (CultureInfo.InvariantCulture);
			}
		}

		void WriteObject_XmlSchemaAny (System.Xml.Schema.XmlSchemaAny ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaAny", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			if (ob.@ProcessContents != ((System.Xml.Schema.XmlSchemaContentProcessing) 0)) {
				WriteAttribute ("processContents", "", GetEnumValue_XmlSchemaContentProcessing (ob.@ProcessContents));
			}
			WriteAttribute ("maxOccurs", "", ob.@MaxOccursString);
			WriteAttribute ("minOccurs", "", ob.@MinOccursString);
			WriteAttribute ("namespace", "", ob.@Namespace);

			ICollection o209 = ob.@UnhandledAttributes;
			if (o209 != null) {
				foreach (XmlAttribute o210 in o209)
					WriteXmlAttribute (o210, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaSimpleContentRestriction (System.Xml.Schema.XmlSchemaSimpleContentRestriction ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaSimpleContentRestriction", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("base", "", FromXmlQualifiedName (ob.@BaseTypeName));

			ICollection o211 = ob.@UnhandledAttributes;
			if (o211 != null) {
				foreach (XmlAttribute o212 in o211)
					WriteXmlAttribute (o212, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			WriteObject_XmlSchemaSimpleType (ob.@BaseType, "simpleType", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Facets != null) {
				for (int n213 = 0; n213 < ob.@Facets.Count; n213++) {
					if (ob.@Facets[n213] == null) { }
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaPatternFacet)) {
						WriteObject_XmlSchemaPatternFacet (((System.Xml.Schema.XmlSchemaPatternFacet) ob.@Facets[n213]), "pattern", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaWhiteSpaceFacet)) {
						WriteObject_XmlSchemaWhiteSpaceFacet (((System.Xml.Schema.XmlSchemaWhiteSpaceFacet) ob.@Facets[n213]), "whiteSpace", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaEnumerationFacet)) {
						WriteObject_XmlSchemaEnumerationFacet (((System.Xml.Schema.XmlSchemaEnumerationFacet) ob.@Facets[n213]), "enumeration", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaMaxLengthFacet)) {
						WriteObject_XmlSchemaMaxLengthFacet (((System.Xml.Schema.XmlSchemaMaxLengthFacet) ob.@Facets[n213]), "maxLength", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaMinLengthFacet)) {
						WriteObject_XmlSchemaMinLengthFacet (((System.Xml.Schema.XmlSchemaMinLengthFacet) ob.@Facets[n213]), "minLength", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaLengthFacet)) {
						WriteObject_XmlSchemaLengthFacet (((System.Xml.Schema.XmlSchemaLengthFacet) ob.@Facets[n213]), "length", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaFractionDigitsFacet)) {
						WriteObject_XmlSchemaFractionDigitsFacet (((System.Xml.Schema.XmlSchemaFractionDigitsFacet) ob.@Facets[n213]), "fractionDigits", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaTotalDigitsFacet)) {
						WriteObject_XmlSchemaTotalDigitsFacet (((System.Xml.Schema.XmlSchemaTotalDigitsFacet) ob.@Facets[n213]), "totalDigits", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaMaxInclusiveFacet)) {
						WriteObject_XmlSchemaMaxInclusiveFacet (((System.Xml.Schema.XmlSchemaMaxInclusiveFacet) ob.@Facets[n213]), "maxInclusive", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaMaxExclusiveFacet)) {
						WriteObject_XmlSchemaMaxExclusiveFacet (((System.Xml.Schema.XmlSchemaMaxExclusiveFacet) ob.@Facets[n213]), "maxExclusive", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaMinInclusiveFacet)) {
						WriteObject_XmlSchemaMinInclusiveFacet (((System.Xml.Schema.XmlSchemaMinInclusiveFacet) ob.@Facets[n213]), "minInclusive", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Facets[n213].GetType() == typeof(System.Xml.Schema.XmlSchemaMinExclusiveFacet)) {
						WriteObject_XmlSchemaMinExclusiveFacet (((System.Xml.Schema.XmlSchemaMinExclusiveFacet) ob.@Facets[n213]), "minExclusive", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Facets[n213]);
				}
			}
			if (ob.@Attributes != null) {
				for (int n214 = 0; n214 < ob.@Attributes.Count; n214++) {
					if (ob.@Attributes[n214] == null) { }
					else if (ob.@Attributes[n214].GetType() == typeof(System.Xml.Schema.XmlSchemaAttribute)) {
						WriteObject_XmlSchemaAttribute (((System.Xml.Schema.XmlSchemaAttribute) ob.@Attributes[n214]), "attribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Attributes[n214].GetType() == typeof(System.Xml.Schema.XmlSchemaAttributeGroupRef)) {
						WriteObject_XmlSchemaAttributeGroupRef (((System.Xml.Schema.XmlSchemaAttributeGroupRef) ob.@Attributes[n214]), "attributeGroup", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Attributes[n214]);
				}
			}
			WriteObject_XmlSchemaAnyAttribute (ob.@AnyAttribute, "anyAttribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaSimpleContentExtension (System.Xml.Schema.XmlSchemaSimpleContentExtension ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaSimpleContentExtension", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("base", "", FromXmlQualifiedName (ob.@BaseTypeName));

			ICollection o215 = ob.@UnhandledAttributes;
			if (o215 != null) {
				foreach (XmlAttribute o216 in o215)
					WriteXmlAttribute (o216, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Attributes != null) {
				for (int n217 = 0; n217 < ob.@Attributes.Count; n217++) {
					if (ob.@Attributes[n217] == null) { }
					else if (ob.@Attributes[n217].GetType() == typeof(System.Xml.Schema.XmlSchemaAttribute)) {
						WriteObject_XmlSchemaAttribute (((System.Xml.Schema.XmlSchemaAttribute) ob.@Attributes[n217]), "attribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Attributes[n217].GetType() == typeof(System.Xml.Schema.XmlSchemaAttributeGroupRef)) {
						WriteObject_XmlSchemaAttributeGroupRef (((System.Xml.Schema.XmlSchemaAttributeGroupRef) ob.@Attributes[n217]), "attributeGroup", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Attributes[n217]);
				}
			}
			WriteObject_XmlSchemaAnyAttribute (ob.@AnyAttribute, "anyAttribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaComplexContentRestriction (System.Xml.Schema.XmlSchemaComplexContentRestriction ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaComplexContentRestriction", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("base", "", FromXmlQualifiedName (ob.@BaseTypeName));

			ICollection o218 = ob.@UnhandledAttributes;
			if (o218 != null) {
				foreach (XmlAttribute o219 in o218)
					WriteXmlAttribute (o219, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Particle is System.Xml.Schema.XmlSchemaAll) {
				WriteObject_XmlSchemaAll (((System.Xml.Schema.XmlSchemaAll) ob.@Particle), "all", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaChoice) {
				WriteObject_XmlSchemaChoice (((System.Xml.Schema.XmlSchemaChoice) ob.@Particle), "choice", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaSequence) {
				WriteObject_XmlSchemaSequence (((System.Xml.Schema.XmlSchemaSequence) ob.@Particle), "sequence", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaGroupRef) {
				WriteObject_XmlSchemaGroupRef (((System.Xml.Schema.XmlSchemaGroupRef) ob.@Particle), "group", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			if (ob.@Attributes != null) {
				for (int n220 = 0; n220 < ob.@Attributes.Count; n220++) {
					if (ob.@Attributes[n220] == null) { }
					else if (ob.@Attributes[n220].GetType() == typeof(System.Xml.Schema.XmlSchemaAttribute)) {
						WriteObject_XmlSchemaAttribute (((System.Xml.Schema.XmlSchemaAttribute) ob.@Attributes[n220]), "attribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Attributes[n220].GetType() == typeof(System.Xml.Schema.XmlSchemaAttributeGroupRef)) {
						WriteObject_XmlSchemaAttributeGroupRef (((System.Xml.Schema.XmlSchemaAttributeGroupRef) ob.@Attributes[n220]), "attributeGroup", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Attributes[n220]);
				}
			}
			WriteObject_XmlSchemaAnyAttribute (ob.@AnyAttribute, "anyAttribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaComplexContentExtension (System.Xml.Schema.XmlSchemaComplexContentExtension ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaComplexContentExtension", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("base", "", FromXmlQualifiedName (ob.@BaseTypeName));

			ICollection o221 = ob.@UnhandledAttributes;
			if (o221 != null) {
				foreach (XmlAttribute o222 in o221)
					WriteXmlAttribute (o222, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (ob.@Particle is System.Xml.Schema.XmlSchemaGroupRef) {
				WriteObject_XmlSchemaGroupRef (((System.Xml.Schema.XmlSchemaGroupRef) ob.@Particle), "group", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaChoice) {
				WriteObject_XmlSchemaChoice (((System.Xml.Schema.XmlSchemaChoice) ob.@Particle), "choice", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaSequence) {
				WriteObject_XmlSchemaSequence (((System.Xml.Schema.XmlSchemaSequence) ob.@Particle), "sequence", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			else if (ob.@Particle is System.Xml.Schema.XmlSchemaAll) {
				WriteObject_XmlSchemaAll (((System.Xml.Schema.XmlSchemaAll) ob.@Particle), "all", "http://www.w3.org/2001/XMLSchema", false, false, true);
			}
			if (ob.@Attributes != null) {
				for (int n223 = 0; n223 < ob.@Attributes.Count; n223++) {
					if (ob.@Attributes[n223] == null) { }
					else if (ob.@Attributes[n223].GetType() == typeof(System.Xml.Schema.XmlSchemaAttribute)) {
						WriteObject_XmlSchemaAttribute (((System.Xml.Schema.XmlSchemaAttribute) ob.@Attributes[n223]), "attribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else if (ob.@Attributes[n223].GetType() == typeof(System.Xml.Schema.XmlSchemaAttributeGroupRef)) {
						WriteObject_XmlSchemaAttributeGroupRef (((System.Xml.Schema.XmlSchemaAttributeGroupRef) ob.@Attributes[n223]), "attributeGroup", "http://www.w3.org/2001/XMLSchema", false, false, true);
					}
					else throw CreateUnknownTypeException (ob.@Attributes[n223]);
				}
			}
			WriteObject_XmlSchemaAnyAttribute (ob.@AnyAttribute, "anyAttribute", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaPatternFacet (System.Xml.Schema.XmlSchemaPatternFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaPatternFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o224 = ob.@UnhandledAttributes;
			if (o224 != null) {
				foreach (XmlAttribute o225 in o224)
					WriteXmlAttribute (o225, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaWhiteSpaceFacet (System.Xml.Schema.XmlSchemaWhiteSpaceFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaWhiteSpaceFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o226 = ob.@UnhandledAttributes;
			if (o226 != null) {
				foreach (XmlAttribute o227 in o226)
					WriteXmlAttribute (o227, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaEnumerationFacet (System.Xml.Schema.XmlSchemaEnumerationFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaEnumerationFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o228 = ob.@UnhandledAttributes;
			if (o228 != null) {
				foreach (XmlAttribute o229 in o228)
					WriteXmlAttribute (o229, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaMaxLengthFacet (System.Xml.Schema.XmlSchemaMaxLengthFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaMaxLengthFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o230 = ob.@UnhandledAttributes;
			if (o230 != null) {
				foreach (XmlAttribute o231 in o230)
					WriteXmlAttribute (o231, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaMinLengthFacet (System.Xml.Schema.XmlSchemaMinLengthFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaMinLengthFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o232 = ob.@UnhandledAttributes;
			if (o232 != null) {
				foreach (XmlAttribute o233 in o232)
					WriteXmlAttribute (o233, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaLengthFacet (System.Xml.Schema.XmlSchemaLengthFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaLengthFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o234 = ob.@UnhandledAttributes;
			if (o234 != null) {
				foreach (XmlAttribute o235 in o234)
					WriteXmlAttribute (o235, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaFractionDigitsFacet (System.Xml.Schema.XmlSchemaFractionDigitsFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaFractionDigitsFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o236 = ob.@UnhandledAttributes;
			if (o236 != null) {
				foreach (XmlAttribute o237 in o236)
					WriteXmlAttribute (o237, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaTotalDigitsFacet (System.Xml.Schema.XmlSchemaTotalDigitsFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaTotalDigitsFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o238 = ob.@UnhandledAttributes;
			if (o238 != null) {
				foreach (XmlAttribute o239 in o238)
					WriteXmlAttribute (o239, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaMaxInclusiveFacet (System.Xml.Schema.XmlSchemaMaxInclusiveFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaMaxInclusiveFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o240 = ob.@UnhandledAttributes;
			if (o240 != null) {
				foreach (XmlAttribute o241 in o240)
					WriteXmlAttribute (o241, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaMaxExclusiveFacet (System.Xml.Schema.XmlSchemaMaxExclusiveFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaMaxExclusiveFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o242 = ob.@UnhandledAttributes;
			if (o242 != null) {
				foreach (XmlAttribute o243 in o242)
					WriteXmlAttribute (o243, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaMinInclusiveFacet (System.Xml.Schema.XmlSchemaMinInclusiveFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaMinInclusiveFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o244 = ob.@UnhandledAttributes;
			if (o244 != null) {
				foreach (XmlAttribute o245 in o244)
					WriteXmlAttribute (o245, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		void WriteObject_XmlSchemaMinExclusiveFacet (System.Xml.Schema.XmlSchemaMinExclusiveFacet ob, string element, string namesp, bool isNullable, bool needType, bool writeWrappingElem)
		{
			if (ob == null)
			{
				if (isNullable)
					WriteNullTagLiteral(element, namesp);
				return;
			}

			if (writeWrappingElem) {
				WriteStartElement (element, namesp, ob);
			}

			if (needType) WriteXsiType("XmlSchemaMinExclusiveFacet", "http://www.w3.org/2001/XMLSchema");

			WriteNamespaceDeclarations ((XmlSerializerNamespaces) ob.@Namespaces);

			WriteAttribute ("id", "", ob.@Id);
			WriteAttribute ("value", "", ob.@Value);
			if (ob.@IsFixed != false) {
				WriteAttribute ("fixed", "", (ob.@IsFixed?"true":"false"));
			}

			ICollection o246 = ob.@UnhandledAttributes;
			if (o246 != null) {
				foreach (XmlAttribute o247 in o246)
					WriteXmlAttribute (o247, ob);
			}

			WriteObject_XmlSchemaAnnotation (ob.@Annotation, "annotation", "http://www.w3.org/2001/XMLSchema", false, false, true);
			if (writeWrappingElem) WriteEndElement (ob);
		}

		protected override void InitCallbacks ()
		{
		}

	}

}

