/* File generated by GAA 1.6.2
 */
#define GAA_NO_WIN32
#line 1 "mcrypt.gaa"


#include <defines.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifndef GAA_NO_WIN32
#if defined(_WIN32) || defined(__WIN32__) || defined(WIN32) || defined(WINDOWS)
#define GAA_WIN32
#endif
#endif

void* gaa_malloc( size_t size) {
void* ret;
	ret = malloc(size);
	if (ret==NULL) {
		fprintf(stderr, "gaa: could not allocate memory");
		exit(1);
	}
	return ret;
}

void __gaa_helpsingle(char short_name, char *name, 
	char *arg_desc, char *opt_help)
{
     int col1, col3, col4, tabsize = 3, curr;
     int i;

     col1 = 5; /* Default values */
     col3 = 30;
     col4 = 70;

     curr = 0;
     for(i = 0; i < col1; i++)
        {
        printf(" ");
        curr++;
        }
     if(short_name)
        {
        if(name && *name)
          {
            printf("-%c, ", short_name);
            curr += 4;
          }
        else
          {
            printf("-%c ", short_name);
            curr += 3;
          }
        }
     if(name && *name)
        {
          printf("--%s ", name);
          curr += 3 + strlen(name);
        }
     if(arg_desc && *arg_desc)
        {
          printf("%s ", arg_desc);
          curr += 1 + strlen(arg_desc);
        }
     if(curr >= col3)
        {
          printf("\n");
          curr = 0;
        }
     if(opt_help) /* let's print the option's help body */
        {
        const char *str = opt_help;
        while(*str)
          {
             while(curr < col3)
               {
                 printf(" ");
                 curr++;
               }
             switch(*str)
               {
                 case '\n':
                     printf("\n");
                     curr = 0;
                     break;
                 case '\t':
                     do
                        {
                        printf(" ");
                        curr++;
                        }
                     while((curr - col3) % tabsize != 0 && curr < col4);
                 case ' ':
                     if(*str == ' ')
                        {
                        curr++;
                        printf(" ");
                        }
                     for(i = 1; str[i] && str[i] != ' ' && str[i] != '\n'
                        && str[i] != '\t'; i++);
                     if(curr + i - 1 >= col4)
                        curr = col4;
                     break;
                default:
                     printf("%c", *str);
                     curr++;
               }
             if(curr >= col4)
               {
                 printf("\n");
                 curr = 0;
               }
             str++;
          }
        }
     printf("\n");
}

void gaa_help(void)
{
	printf(_("Mcrypt encrypts and decrypts files with symmetric encryption algorithms.\nUsage: mcrypt [-dFusgbhLvrzp] [-f keyfile] [-k key1 key2 ...] [-m mode] [-o keymode] [-s keysize] [-a algorithm] [-c config_file] [file ...]\n\n"));
	__gaa_helpsingle('g', "openpgp", "", _("Use the OpenPGP (RFC2440) file format."));
	__gaa_helpsingle(0, "openpgp-z", _("INTEGER "), _("Sets the compression level for openpgp packets (0 disables)."));
	__gaa_helpsingle('d', "decrypt", "", _("decrypts."));
	__gaa_helpsingle('s', "keysize", _("INTEGER "), _("Set the algorithm's key size (in bytes)."));
	__gaa_helpsingle('o', "keymode", _("KEYMODE "), _("Specify the keyword mode. Use the --list-keymodes parameter to view all modes."));
	__gaa_helpsingle('f', "keyfile", _("FILE "), _("Specify the file to read the keyword from."));
	__gaa_helpsingle('c', "config", _("FILE "), _("Use configuration file FILE."));
	__gaa_helpsingle('a', "algorithm", _("ALGORITHM "), _("Specify the encryption and decryption algorithm. Use the --list parameter to see the supported algorithms."));
	__gaa_helpsingle(0, "algorithms-directory", _("DIRECTORY "), _("Set the algorithms directory."));
	__gaa_helpsingle('m', "mode", _("MODE "), _("Specify the encryption and decryption mode. Use the --list parameter to see the supported modes."));
	__gaa_helpsingle(0, "modes-directory", _("DIRECTORY "), _("Set the modes directory."));
	__gaa_helpsingle('h', "hash", _("HASH "), _("Specify the hash algorithm to be used. Use the --list-hash parameter to view the hash algorithms."));
	__gaa_helpsingle('k', "key", _("KEY1 KEY2...KEYN "), _("Specify the key(s)"));
	__gaa_helpsingle(0, "noiv", "", _("Do not use an IV."));
	__gaa_helpsingle('b', "bare", "", _("Do not keep algorithm information in the encrypted file."));
	__gaa_helpsingle('z', "gzip", "", _("Use gzip to compress files before encryption."));
	__gaa_helpsingle('p', "bzip2", "", _("Use bzip2 to compress files before encryption."));
	__gaa_helpsingle(0, "flush", "", _("Immediately flush the output"));
	__gaa_helpsingle('l', "doublecheck", "", _("Double check passwords."));
	__gaa_helpsingle('u', "unlink", "", _("Unlink the input file after encryption or decryption."));
	__gaa_helpsingle(0, "nodelete", "", _("Do not delete the output file if decryption failed."));
	__gaa_helpsingle('t', "time", "", _("Prints timing information."));
	__gaa_helpsingle('F', "force", "", _("Forces output to stdout."));
	__gaa_helpsingle(0, "echo", "", _("Echo asterisks when entering the password."));
	__gaa_helpsingle('r', "random", "", _("Use real random data (if your system supports it)."));
	__gaa_helpsingle(0, "list", "", _("Prints a list of the supported algorithms and modes."));
	__gaa_helpsingle(0, "list-keymodes", "", _("Prints a list of the supported key modes."));
	__gaa_helpsingle(0, "list-hash", "", _("Prints a list of the supported hash algorithms."));
	__gaa_helpsingle('V', "verbose", "", _("More information is displayed."));
	__gaa_helpsingle('q', "quiet", "", _("Suppress some non critical warnings."));
	__gaa_helpsingle(0, "help", "", _("Prints this help"));
	__gaa_helpsingle('v', "version", "", _("Prints the version number"));
	__gaa_helpsingle('L', "license", "", _("Displays license information."));

#line 100 "gaa.skel"
}
/* Copy of C area */

#line 104 "gaa.skel"
/* GAA HEADER */
#ifndef GAA_HEADER_POKY
#define GAA_HEADER_POKY

typedef struct _gaainfo gaainfo;

struct _gaainfo
{
#line 111 "mcrypt.gaa"
	char **input;
#line 110 "mcrypt.gaa"
	int size;
#line 100 "mcrypt.gaa"
	int quiet;
#line 92 "mcrypt.gaa"
	int real_random_flag;
#line 89 "mcrypt.gaa"
	int noecho;
#line 86 "mcrypt.gaa"
	int force;
#line 83 "mcrypt.gaa"
	int timer;
#line 79 "mcrypt.gaa"
	int nodelete;
#line 76 "mcrypt.gaa"
	int unlink_flag;
#line 73 "mcrypt.gaa"
	int double_check;
#line 70 "mcrypt.gaa"
	int flush;
#line 66 "mcrypt.gaa"
	int bzipflag;
#line 63 "mcrypt.gaa"
	int gzipflag;
#line 61 "mcrypt.gaa"
	int bare_flag;
#line 58 "mcrypt.gaa"
	int noiv;
#line 54 "mcrypt.gaa"
	char **keys;
#line 53 "mcrypt.gaa"
	int keylen;
#line 50 "mcrypt.gaa"
	char *hash;
#line 47 "mcrypt.gaa"
	char *modes_directory;
#line 44 "mcrypt.gaa"
	char *mode;
#line 41 "mcrypt.gaa"
	char *algorithms_directory;
#line 38 "mcrypt.gaa"
	char *algorithm;
#line 35 "mcrypt.gaa"
	char *config_file;
#line 34 "mcrypt.gaa"
	int config;
#line 31 "mcrypt.gaa"
	char *keyfile;
#line 28 "mcrypt.gaa"
	char *kmode;
#line 25 "mcrypt.gaa"
	int keysize;
#line 22 "mcrypt.gaa"
	int ed_specified;
#line 21 "mcrypt.gaa"
	int ein;
#line 20 "mcrypt.gaa"
	int din;
#line 16 "mcrypt.gaa"
	int openpgp_z;
#line 13 "mcrypt.gaa"
	int openpgp;

#line 114 "gaa.skel"
};

#ifdef __cplusplus
extern "C"
{
#endif

    int gaa(int argc, char *argv[], gaainfo *gaaval);

    void gaa_help(void);
    
    int gaa_file(char *name, gaainfo *gaaval);
    
#ifdef __cplusplus
}
#endif


#endif

#line 135 "gaa.skel"

/* C declarations */

#define GAAERROR(x)    \
{                   \
gaa_error = 1;      \
return x;        \
}

char *gaa_current_option;
int gaa_error = 0;

/* Generated by gaa */

#include <string.h>
#include <stdlib.h>


#define GAA_OK                       -1

#define GAA_ERROR_NOMATCH            0
#define GAA_ERROR_NOTENOUGH_ARGS     1
#define GAA_ERROR_INVALID_ARG        2
#define GAA_ERROR_UNKNOWN            3

#define GAA_NOT_AN_OPTION       0
#define GAA_WORD_OPTION         1
#define GAA_LETTER_OPTION       2
#define GAA_MULTIPLE_OPTION     3

#define GAA_REST                0
#define GAA_NB_OPTION           33
#define GAAOPTID_license	1
#define GAAOPTID_version	2
#define GAAOPTID_help	3
#define GAAOPTID_quiet	4
#define GAAOPTID_verbose	5
#define GAAOPTID_list_hash	6
#define GAAOPTID_list_keymodes	7
#define GAAOPTID_list	8
#define GAAOPTID_random	9
#define GAAOPTID_echo	10
#define GAAOPTID_force	11
#define GAAOPTID_time	12
#define GAAOPTID_nodelete	13
#define GAAOPTID_unlink	14
#define GAAOPTID_doublecheck	15
#define GAAOPTID_flush	16
#define GAAOPTID_bzip2	17
#define GAAOPTID_gzip	18
#define GAAOPTID_bare	19
#define GAAOPTID_noiv	20
#define GAAOPTID_key	21
#define GAAOPTID_hash	22
#define GAAOPTID_modes_directory	23
#define GAAOPTID_mode	24
#define GAAOPTID_algorithms_directory	25
#define GAAOPTID_algorithm	26
#define GAAOPTID_config	27
#define GAAOPTID_keyfile	28
#define GAAOPTID_keymode	29
#define GAAOPTID_keysize	30
#define GAAOPTID_decrypt	31
#define GAAOPTID_openpgp_z	32
#define GAAOPTID_openpgp	33

#line 168 "gaa.skel"

#define GAA_CHECK1STR(a,b)      \
if(a[0] == str[0])              \
{                               \
    gaa_current_option = a;     \
    return b;                   \
}

#define GAA_CHECKSTR(a,b)                \
if(strcmp(a,str) == 0)                   \
{                                        \
    gaa_current_option = a;              \
    return b;                            \
}

#define GAA_TESTMOREARGS                                                  \
if(!OK)                                                                     \
{                                  \
while((gaa_last_non_option != gaa_index) && (gaa_arg_used[gaa_index] == 1)) \
    gaa_index++;                                                            \
if(gaa_last_non_option == gaa_index)                                        \
    return GAA_ERROR_NOTENOUGH_ARGS; \
}

#define GAA_TESTMOREOPTIONALARGS                                                  \
if(!OK) \
{ \
while((gaa_last_non_option != gaa_index) && (gaa_arg_used[gaa_index] == 1)) \
    gaa_index++;                                                            \
if(gaa_last_non_option == gaa_index)                                        \
    OK = 1; \
}

#define GAA_FILL_2ARGS(target, func)           \
target = func(GAAargv[gaa_index]);       \
gaa_arg_used[gaa_index] = 1;             \
if(gaa_error == 1)                       \
{                                        \
    gaa_error = 0;                       \
    return GAA_ERROR_INVALID_ARG;        \
} 



#define GAA_FILL(target, func, num)           \
if(!OK) \
{ \
target = func(GAAargv[gaa_index]);       \
gaa_arg_used[gaa_index] = 1;             \
if(gaa_error == 1)                       \
{                                        \
    gaa_error = 0;                       \
    return GAA_ERROR_INVALID_ARG;        \
} \
num = 1;  \
} \
else \
{ \
num = 0; \
}

#define GAA_LIST_FILL(target, func, type ,num)                      \
if(!OK) \
{ \
num = 0;                                                            \
target = NULL;                                                      \
if ( gaa_last_non_option - gaa_index > 0)                           \
  target = gaa_malloc((gaa_last_non_option - gaa_index) * sizeof(type));\
for(; gaa_index < gaa_last_non_option; gaa_index++)                 \
{                                                                   \
    if(gaa_arg_used[gaa_index] == 0)                                \
    {                                                               \
        GAA_FILL_2ARGS(target[num], func);                          \
        num++;                                                      \
    }                                                               \
}                                                                   \
if(num == 0)                                                        \
    return GAA_ERROR_NOTENOUGH_ARGS; \
}

#define GAA_OPTIONALLIST_FILL(target, func, type ,num)                      \
if(!OK) \
{ \
num = 0;                                                            \
target = NULL;                                                      \
if ( gaa_last_non_option - gaa_index > 0)                           \
  target = gaa_malloc((gaa_last_non_option - gaa_index) * sizeof(type));\
for(; gaa_index < gaa_last_non_option; gaa_index++)                 \
{                                                                   \
    if(gaa_arg_used[gaa_index] == 0)                                \
    {                                                               \
        GAA_FILL_2ARGS(target[num], func);                                \
        num++;                                                      \
    }                                                               \
} \
}

#define GAA_OBLIGAT(str)                                            \
k = 0;                                                              \
for(i = 0; i < strlen(str); i++)                                    \
{                                                                   \
    j = gaa_get_option_num(str + i, GAA_LETTER_OPTION);           \
    if(j == GAA_ERROR_NOMATCH)                                       \
    {                                                               \
        printf("Error: invalid 'obligat' set\n");                  \
        exit(-1);                                                   \
    }                                                               \
    if(opt_list[j] == 1)                                            \
        k = 1;                                                      \
}                                                                    \
if(k == 0)                                                            \
{                                                                      \
    if(strlen(str) == 1)                                                \
        printf("You must give the -%s option\n", str);                     \
    else                                                                  \
        printf("You must give at least one option of '%s'\n", str);          \
    return 0;         \
}
        
#define GAA_INCOMP(str)                                                \
k = 0;                                                              \
for(i = 0; i < strlen(str); i++)                                    \
{                                                                   \
    j = gaa_get_option_num(str + i, GAA_LETTER_OPTION);           \
    if(j == GAA_ERROR_NOMATCH)                                      \
    {                                                               \
        printf("Error: invalid 'obligat' set\n");                  \
        exit(-1);                                                   \
    }                                                               \
    if(opt_list[j] == 1)                                            \
        k++;                                                      \
}                   \
if(k > 1)                                                            \
{                                                                      \
    printf("The options '%s' are incompatible\n", str);              \
    return 0;                                                          \
}
        

char **GAAargv;
int GAAargc;
char *gaa_arg_used;
int gaa_processing_file = 0;
int inited = 0;

int gaa_getint(char *arg)
{
    int tmp;
    char a;
    if(sscanf(arg, "%d%c", &tmp, &a) != 1)
    {
        printf("Option %s: '%s' isn't an integer\n", gaa_current_option, arg);
        GAAERROR(-1);
    }
    return tmp;
}

char gaa_getchar(char *arg)
{
    if(strlen(arg) != 1)
    {
        printf("Option %s: '%s' isn't an character\n", gaa_current_option, arg);
        GAAERROR(-1);
    }
    return arg[0];
}

char* gaa_getstr(char *arg)
{
    return arg;
}
float gaa_getfloat(char *arg)
{
    float tmp;
    char a;
    if(sscanf(arg, "%f%c", &tmp, &a) != 1)
    {
        printf("Option %s: '%s' isn't a float number\n", gaa_current_option, arg);
        GAAERROR(-1);
    }
    return tmp;
}
/* option structures */

struct GAAOPTION_key 
{
	char** arg1;
	int size1;
};

struct GAAOPTION_hash 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_modes_directory 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_mode 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_algorithms_directory 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_algorithm 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_config 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_keyfile 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_keymode 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_keysize 
{
	int arg1;
	int size1;
};

struct GAAOPTION_openpgp_z 
{
	int arg1;
	int size1;
};
#define GAA_REST_EXISTS

struct GAAREST
{
	char** arg1;
	int size1;
};
         
#line 349 "gaa.skel"
int gaa_is_an_argument(char *str)
{
#ifdef GAA_WIN32
    if(str[0] == '/' && str[1] != 0)
	return GAA_MULTIPLE_OPTION;
#endif
    if(str[0] != '-')
        return GAA_NOT_AN_OPTION;
    if(str[1] == 0)
        return GAA_NOT_AN_OPTION;
    if(str[1] == '-')
    {
        if(str[2] != 0)
            return GAA_WORD_OPTION;
        else
            return GAA_NOT_AN_OPTION;
    }
    if(str[2] == 0)
        return GAA_LETTER_OPTION;
    else
        return GAA_MULTIPLE_OPTION;
}

int gaa_get_option_num(char *str, int status)
{
    switch(status)
        {
        case GAA_LETTER_OPTION:
			GAA_CHECK1STR("k", GAAOPTID_key);
			GAA_CHECK1STR("h", GAAOPTID_hash);
			GAA_CHECK1STR("", GAAOPTID_modes_directory);
			GAA_CHECK1STR("m", GAAOPTID_mode);
			GAA_CHECK1STR("", GAAOPTID_algorithms_directory);
			GAA_CHECK1STR("a", GAAOPTID_algorithm);
			GAA_CHECK1STR("c", GAAOPTID_config);
			GAA_CHECK1STR("f", GAAOPTID_keyfile);
			GAA_CHECK1STR("o", GAAOPTID_keymode);
			GAA_CHECK1STR("s", GAAOPTID_keysize);
			GAA_CHECK1STR("", GAAOPTID_openpgp_z);
        case GAA_MULTIPLE_OPTION:
#line 375 "gaa.skel"
			GAA_CHECK1STR("L", GAAOPTID_license);
			GAA_CHECK1STR("v", GAAOPTID_version);
			GAA_CHECK1STR("", GAAOPTID_help);
			GAA_CHECK1STR("q", GAAOPTID_quiet);
			GAA_CHECK1STR("V", GAAOPTID_verbose);
			GAA_CHECK1STR("", GAAOPTID_list_hash);
			GAA_CHECK1STR("", GAAOPTID_list_keymodes);
			GAA_CHECK1STR("", GAAOPTID_list);
			GAA_CHECK1STR("r", GAAOPTID_random);
			GAA_CHECK1STR("", GAAOPTID_echo);
			GAA_CHECK1STR("F", GAAOPTID_force);
			GAA_CHECK1STR("t", GAAOPTID_time);
			GAA_CHECK1STR("", GAAOPTID_nodelete);
			GAA_CHECK1STR("u", GAAOPTID_unlink);
			GAA_CHECK1STR("l", GAAOPTID_doublecheck);
			GAA_CHECK1STR("", GAAOPTID_flush);
			GAA_CHECK1STR("p", GAAOPTID_bzip2);
			GAA_CHECK1STR("z", GAAOPTID_gzip);
			GAA_CHECK1STR("b", GAAOPTID_bare);
			GAA_CHECK1STR("", GAAOPTID_noiv);
			GAA_CHECK1STR("d", GAAOPTID_decrypt);
			GAA_CHECK1STR("g", GAAOPTID_openpgp);

#line 277 "gaa.skel"
        break;
        case GAA_WORD_OPTION:
			GAA_CHECKSTR("license", GAAOPTID_license);
			GAA_CHECKSTR("version", GAAOPTID_version);
			GAA_CHECKSTR("help", GAAOPTID_help);
			GAA_CHECKSTR("quiet", GAAOPTID_quiet);
			GAA_CHECKSTR("verbose", GAAOPTID_verbose);
			GAA_CHECKSTR("list-hash", GAAOPTID_list_hash);
			GAA_CHECKSTR("list-keymodes", GAAOPTID_list_keymodes);
			GAA_CHECKSTR("list", GAAOPTID_list);
			GAA_CHECKSTR("random", GAAOPTID_random);
			GAA_CHECKSTR("echo", GAAOPTID_echo);
			GAA_CHECKSTR("force", GAAOPTID_force);
			GAA_CHECKSTR("time", GAAOPTID_time);
			GAA_CHECKSTR("nodelete", GAAOPTID_nodelete);
			GAA_CHECKSTR("unlink", GAAOPTID_unlink);
			GAA_CHECKSTR("doublecheck", GAAOPTID_doublecheck);
			GAA_CHECKSTR("flush", GAAOPTID_flush);
			GAA_CHECKSTR("bzip2", GAAOPTID_bzip2);
			GAA_CHECKSTR("gzip", GAAOPTID_gzip);
			GAA_CHECKSTR("bare", GAAOPTID_bare);
			GAA_CHECKSTR("noiv", GAAOPTID_noiv);
			GAA_CHECKSTR("key", GAAOPTID_key);
			GAA_CHECKSTR("hash", GAAOPTID_hash);
			GAA_CHECKSTR("modes-directory", GAAOPTID_modes_directory);
			GAA_CHECKSTR("mode", GAAOPTID_mode);
			GAA_CHECKSTR("algorithms-directory", GAAOPTID_algorithms_directory);
			GAA_CHECKSTR("algorithm", GAAOPTID_algorithm);
			GAA_CHECKSTR("config", GAAOPTID_config);
			GAA_CHECKSTR("keyfile", GAAOPTID_keyfile);
			GAA_CHECKSTR("keymode", GAAOPTID_keymode);
			GAA_CHECKSTR("keysize", GAAOPTID_keysize);
			GAA_CHECKSTR("decrypt", GAAOPTID_decrypt);
			GAA_CHECKSTR("openpgp-z", GAAOPTID_openpgp_z);
			GAA_CHECKSTR("openpgp", GAAOPTID_openpgp);

#line 281 "gaa.skel"
	break;
        default: break;
        }
    return GAA_ERROR_NOMATCH;
}

int gaa_try(int gaa_num, int gaa_index, gaainfo *gaaval, char *opt_list)
{
    int OK = 0;
    int gaa_last_non_option;
	struct GAAOPTION_key GAATMP_key;
	struct GAAOPTION_hash GAATMP_hash;
	struct GAAOPTION_modes_directory GAATMP_modes_directory;
	struct GAAOPTION_mode GAATMP_mode;
	struct GAAOPTION_algorithms_directory GAATMP_algorithms_directory;
	struct GAAOPTION_algorithm GAATMP_algorithm;
	struct GAAOPTION_config GAATMP_config;
	struct GAAOPTION_keyfile GAATMP_keyfile;
	struct GAAOPTION_keymode GAATMP_keymode;
	struct GAAOPTION_keysize GAATMP_keysize;
	struct GAAOPTION_openpgp_z GAATMP_openpgp_z;

#line 393 "gaa.skel"
#ifdef GAA_REST_EXISTS
    struct GAAREST GAAREST_tmp;
#endif

    opt_list[gaa_num] = 1;
    
    for(gaa_last_non_option = gaa_index;
        (gaa_last_non_option != GAAargc) && (gaa_is_an_argument(GAAargv[gaa_last_non_option]) == GAA_NOT_AN_OPTION);
        gaa_last_non_option++);

    if(gaa_num == GAA_REST)
    {
        gaa_index = 1;
        gaa_last_non_option = GAAargc;
    }
    
    switch(gaa_num)
    {
	case GAAOPTID_license:
	OK = 0;
#line 108 "mcrypt.gaa"
{ mcrypt_license(); exit(0); ;};

		return GAA_OK;
		break;
	case GAAOPTID_version:
	OK = 0;
#line 107 "mcrypt.gaa"
{ mcrypt_version(); exit(0); ;};

		return GAA_OK;
		break;
	case GAAOPTID_help:
	OK = 0;
#line 106 "mcrypt.gaa"
{ usage(); exit(0); ;};

		return GAA_OK;
		break;
	case GAAOPTID_quiet:
	OK = 0;
#line 102 "mcrypt.gaa"
{ gaaval->quiet = 2 ;};

		return GAA_OK;
		break;
	case GAAOPTID_verbose:
	OK = 0;
#line 101 "mcrypt.gaa"
{ gaaval->quiet = 0 ;};

		return GAA_OK;
		break;
	case GAAOPTID_list_hash:
	OK = 0;
#line 98 "mcrypt.gaa"
{ print_hashlist(); exit(0); ;};

		return GAA_OK;
		break;
	case GAAOPTID_list_keymodes:
	OK = 0;
#line 97 "mcrypt.gaa"
{ print_keylist(); exit(0); ;};

		return GAA_OK;
		break;
	case GAAOPTID_list:
	OK = 0;
#line 96 "mcrypt.gaa"
{ print_list(); exit(0); ;};

		return GAA_OK;
		break;
	case GAAOPTID_random:
	OK = 0;
#line 93 "mcrypt.gaa"
{ gaaval->real_random_flag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_echo:
	OK = 0;
#line 90 "mcrypt.gaa"
{ gaaval->noecho = 0 ;};

		return GAA_OK;
		break;
	case GAAOPTID_force:
	OK = 0;
#line 87 "mcrypt.gaa"
{ gaaval->force = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_time:
	OK = 0;
#line 84 "mcrypt.gaa"
{ gaaval->timer = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_nodelete:
	OK = 0;
#line 80 "mcrypt.gaa"
{ gaaval->nodelete = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_unlink:
	OK = 0;
#line 77 "mcrypt.gaa"
{ gaaval->unlink_flag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_doublecheck:
	OK = 0;
#line 74 "mcrypt.gaa"
{ gaaval->double_check = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_flush:
	OK = 0;
#line 71 "mcrypt.gaa"
{ gaaval->flush = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_bzip2:
	OK = 0;
#line 67 "mcrypt.gaa"
{ gaaval->bzipflag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_gzip:
	OK = 0;
#line 64 "mcrypt.gaa"
{ gaaval->gzipflag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_bare:
	OK = 0;
#line 62 "mcrypt.gaa"
{ gaaval->bare_flag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_noiv:
	OK = 0;
#line 59 "mcrypt.gaa"
{ gaaval->noiv = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_key:
	OK = 0;
		GAA_LIST_FILL(GAATMP_key.arg1, gaa_getstr, char*, GAATMP_key.size1);
#line 55 "mcrypt.gaa"
{ gaaval->keys = GAATMP_key.arg1; gaaval->keylen = GAATMP_key.size1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_hash:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_hash.arg1, gaa_getstr, GAATMP_hash.size1);
		gaa_index++;
#line 51 "mcrypt.gaa"
{ gaaval->hash = GAATMP_hash.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_modes_directory:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_modes_directory.arg1, gaa_getstr, GAATMP_modes_directory.size1);
		gaa_index++;
#line 48 "mcrypt.gaa"
{ gaaval->modes_directory = GAATMP_modes_directory.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_mode:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_mode.arg1, gaa_getstr, GAATMP_mode.size1);
		gaa_index++;
#line 45 "mcrypt.gaa"
{ gaaval->mode = GAATMP_mode.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_algorithms_directory:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_algorithms_directory.arg1, gaa_getstr, GAATMP_algorithms_directory.size1);
		gaa_index++;
#line 42 "mcrypt.gaa"
{ gaaval->algorithms_directory = GAATMP_algorithms_directory.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_algorithm:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_algorithm.arg1, gaa_getstr, GAATMP_algorithm.size1);
		gaa_index++;
#line 39 "mcrypt.gaa"
{ gaaval->algorithm = GAATMP_algorithm.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_config:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_config.arg1, gaa_getstr, GAATMP_config.size1);
		gaa_index++;
#line 36 "mcrypt.gaa"
{ gaaval->config=1; if (GAATMP_config.size1==1) gaaval->config_file = GAATMP_config.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_keyfile:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_keyfile.arg1, gaa_getstr, GAATMP_keyfile.size1);
		gaa_index++;
#line 32 "mcrypt.gaa"
{ gaaval->keyfile = GAATMP_keyfile.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_keymode:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_keymode.arg1, gaa_getstr, GAATMP_keymode.size1);
		gaa_index++;
#line 29 "mcrypt.gaa"
{ gaaval->kmode = GAATMP_keymode.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_keysize:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_keysize.arg1, gaa_getint, GAATMP_keysize.size1);
		gaa_index++;
#line 26 "mcrypt.gaa"
{ gaaval->keysize = GAATMP_keysize.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_decrypt:
	OK = 0;
#line 23 "mcrypt.gaa"
{ gaaval->ed_specified=1; gaaval->din = 1; gaaval->ein=0; ;};

		return GAA_OK;
		break;
	case GAAOPTID_openpgp_z:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_openpgp_z.arg1, gaa_getint, GAATMP_openpgp_z.size1);
		gaa_index++;
#line 17 "mcrypt.gaa"
{ gaaval->openpgp_z = GAATMP_openpgp_z.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_openpgp:
	OK = 0;
#line 14 "mcrypt.gaa"
{ gaaval->openpgp = 1 ;};

		return GAA_OK;
		break;
	case GAA_REST:
		GAA_OPTIONALLIST_FILL(GAAREST_tmp.arg1, gaa_getstr, char*, GAAREST_tmp.size1);
#line 112 "mcrypt.gaa"
{ gaaval->input = GAAREST_tmp.arg1; gaaval->size = GAAREST_tmp.size1 ;};

		return GAA_OK;
		break;

#line 413 "gaa.skel"
    default: break;
    }
    return GAA_ERROR_UNKNOWN;
}

int gaa(int argc, char **argv, gaainfo *gaaval)
{
    int tmp1, tmp2;
    int i, j, k;
    char *opt_list;

    GAAargv = argv;
    GAAargc = argc;

    opt_list = (char*) gaa_malloc(GAA_NB_OPTION + 1);

    for(i = 0; i < GAA_NB_OPTION + 1; i++)
        opt_list[i] = 0;
    /* initialization */
    if(inited == 0)
    {

#line 114 "mcrypt.gaa"
{ gaaval->force=0; gaaval->quiet=1; gaaval->real_random_flag=0; gaaval->config=0;
       gaaval->bare_flag = 0; gaaval->din = 0; gaaval->ein=1; gaaval->unlink_flag = 0;
       gaaval->kmode = NULL; gaaval->keylen=0; gaaval->gzipflag=0; gaaval->bzipflag=0;
       gaaval->keyfile=NULL; gaaval->algorithm=NULL; gaaval->keys=NULL; gaaval->noiv=0;
       gaaval->config_file=NULL; gaaval->mode=NULL; gaaval->input=NULL; gaaval->ed_specified=0;
       gaaval->double_check=0; gaaval->noecho=1; gaaval->flush=0; gaaval->keysize=0;
       gaaval->algorithms_directory=NULL; gaaval->modes_directory=NULL; gaaval->nodelete=0;
       gaaval->hash=NULL; gaaval->timer=0; gaaval->openpgp=0; gaaval->openpgp_z = 0; ;};

    }
    inited = 1;
#line 438 "gaa.skel"
    gaa_arg_used = NULL;

    if (argc > 0) {
      gaa_arg_used = gaa_malloc(argc * sizeof(char));
    }

    for(i = 1; i < argc; i++)
        gaa_arg_used[i] = 0;
    for(i = 1; i < argc; i++)
    {
        if(gaa_arg_used[i] == 0)
        {
            j = 0;
            tmp1 = gaa_is_an_argument(GAAargv[i]);
            switch(tmp1)
            {
            case GAA_WORD_OPTION:
                j++;
            case GAA_LETTER_OPTION:
                j++;
                tmp2 = gaa_get_option_num(argv[i]+j, tmp1);
                if(tmp2 == GAA_ERROR_NOMATCH)
                {
                    printf("Invalid option '%s'\n", argv[i]+j);
                    return 0;
                }
                switch(gaa_try(tmp2, i+1, gaaval, opt_list))
                {
                case GAA_ERROR_NOTENOUGH_ARGS:
                    printf("'%s': not enough arguments\n",gaa_current_option);
                    return 0;
                case GAA_ERROR_INVALID_ARG:
                    printf("Invalid arguments\n");
                    return 0;
                case GAA_OK:
                    break;
                default:
                    printf("Unknown error\n");
                }
                gaa_arg_used[i] = 1;
                break;
            case GAA_MULTIPLE_OPTION:
                for(j = 1; j < strlen(argv[i]); j++)
                {
                    tmp2 = gaa_get_option_num(argv[i]+j, tmp1);
                    if(tmp2 == GAA_ERROR_NOMATCH)
                    {
                        printf("Invalid option '%c'\n", *(argv[i]+j));
                        return 0;
                    }
                    switch(gaa_try(tmp2, i+1, gaaval, opt_list))
                    {
                    case GAA_ERROR_NOTENOUGH_ARGS:
                        printf("'%s': not enough arguments\n",gaa_current_option);
                        return 0;
                    case GAA_ERROR_INVALID_ARG:
                        printf("Invalid arguments\n");
                        return 0;
                    case GAA_OK:
                        break;
                    default:
                        printf("Unknown error\n");
                    }
                }
                gaa_arg_used[i] = 1;
                break;
            default: break;
            }
        }
    }
if(gaa_processing_file == 0)
{
	GAA_INCOMP("gp");
	GAA_INCOMP("gz");
	GAA_INCOMP("bg");
	GAA_INCOMP("mg");
	GAA_INCOMP("zp");
	GAA_INCOMP("Vq");
	GAA_INCOMP("kf");

#line 507 "gaa.skel"
#ifdef GAA_REST_EXISTS
    switch(gaa_try(GAA_REST, 1, gaaval, opt_list))
    {
    case GAA_ERROR_NOTENOUGH_ARGS:
        printf("Rest: not enough arguments\n");
        return 0;
    case GAA_ERROR_INVALID_ARG:
        printf("Invalid arguments\n");
        return 0;
    case GAA_OK:
        break;
    default:
        printf("Unknown error\n");
    }
#endif
}
    for(i = 1; i < argc; i++)
    {
        if(gaa_arg_used[i] == 0)
        {
            printf("Too many arguments\n");
            return 0;
        }
    }
    free(gaa_arg_used);
    free(opt_list);
    return -1;
}

struct gaastrnode
{
    char *str;
    struct gaastrnode *next;
};

typedef struct gaastrnode gaa_str_node;

int gaa_internal_get_next_str(FILE *file, gaa_str_node *tmp_str, int argc)
{
    int pos_ini;
    char a;
    int i = 0, len = 0, newline = 0;

    if(argc == 1) {
        newline = 1;
        len = 2;
    }
    
    if(fscanf(file,"%c", &a) != 1) return 0;

    while(a == ' ' || a == 9 || a == '\n')
    {
        if(a == '\n')
        {
            newline=1;
            len = 2;
        }
        if(fscanf(file,"%c", &a) != 1) return 0;
    }

    pos_ini = ftell(file) - 1;

    while(a != ' ' && a != 9 && a != '\n')
    {

        len++;
        if(fscanf(file,"%c", &a) != 1) a = ' ';
    }

    len += 1;
    tmp_str->str = gaa_malloc((len) * sizeof(char));

    if(newline == 1)
    {
        tmp_str->str[0] = '-';
        tmp_str->str[1] = '-';
        i = 2;
    }
    else
    {
        i = 0;
    }

    fseek(file,pos_ini, SEEK_SET);
    do
    {
        if(fscanf(file, "%c", &a) != 1)
        {
            i+=2;
            break;
        }
        tmp_str->str[i] = a;
        i++;
    }
    while(a != ' ' && a != 9 && a != '\n' && i < len);

    tmp_str->str[i - 1] = 0;

    fseek(file,- 1, SEEK_CUR);
/*    printf("%d\n", ftell(file)); */
    
    return -1;
}

int gaa_file(char *name, gaainfo *gaaval)
{
    gaa_str_node *first_str, **tmp_str, *tmp_str2;
    int rval, i;
    char **argv;
    int argc = 0;
    FILE *file;

    gaa_processing_file = 1;
    
    if((file = fopen(name, "r")) == NULL)
    {
        printf("Couldn't open '%s' configuration file for reading\n", name);
        return 0;
    }
    
    tmp_str = &first_str;
    do
    {
        argc++;
        *tmp_str = gaa_malloc(sizeof(gaa_str_node));

        (*tmp_str)->str = NULL;
        (*tmp_str)->next = NULL;

        rval = gaa_internal_get_next_str(file, *tmp_str, argc);
        tmp_str = &((*tmp_str)->next);
    }
    while(rval == -1);
    
    if(rval == 1)
        return 0;
    
    argv = gaa_malloc((1 + argc) * sizeof(char*));

    tmp_str2 = first_str;
    argv[0] = "cfg";
    for(i = 1; i < argc; i++)
    {
        argv[i] = tmp_str2->str;
        tmp_str2 = tmp_str2->next;
    }

    rval = gaa(argc, argv, gaaval);
    gaa_processing_file = 0;
    return rval;
}
