C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq5D (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=9)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ5D
C       PARAMETER (ISET=2)
        DATA  DrI, FlI, AlI /   2.,   5.,  .2260 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.300,    4.500,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .100000E+01, .100000E+05,
     +  .100000E+01, .130000E+01, .167097E+01, .222659E+01, .309171E+01,
     +  .450000E+01, .754288E+01, .138228E+02, .281243E+02, .646894E+02,
     +  .171811E+03, .540159E+03, .206963E+04, .100000E+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C Parton Distribution Table:                                               
        DATA (UPDI(I),I=1,52) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .212365E+06,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=469,520) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=521,572) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .108971E+06, .831805E+05,
     +  .624953E+05, .469154E+05, .351986E+05, .263836E+05,
     +  .197634E+05, .147899E+05, .110603E+05, .826250E+04,
     +  .616779E+04, .459900E+04, .342644E+04, .254979E+04,
     +  .189576E+04, .140769E+04, .104428E+04, .773633E+03,
     +  .572544E+03, .423105E+03, .312338E+03, .230216E+03,
     +  .169491E+03, .124586E+03, .914642E+02, .670464E+02 /
        DATA (UPDI(I),I=573,624) /
     +  .491047E+02, .357442E+02, .261093E+02, .190423E+02,
     +  .138786E+02, .101028E+02, .735113E+01, .535013E+01,
     +  .389230E+01, .283196E+01, .206335E+01, .150467E+01,
     +  .109983E+01, .805295E+00, .591802E+00, .436021E+00,
     +  .322434E+00, .239166E+00, .178139E+00, .133073E+00,
     +  .999143E-01, .750454E-01, .566908E-01, .428127E-01,
     +  .324482E-01, .246108E-01, .186983E-01, .142055E-01,
     +  .107997E-01, .819853E-02, .621852E-02, .470437E-02,
     +  .355319E-02, .267242E-02, .200366E-02, .149349E-02,
     +  .110730E-02, .815974E-03, .595215E-03, .428851E-03,
     +  .305029E-03, .212984E-03, .145562E-03, .962979E-04,
     +  .610482E-04, .359834E-04, .186469E-04, .693905E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=625,676) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .253813E+06, .193131E+06, .144568E+06,
     +  .108126E+06, .808167E+05, .603480E+05, .450316E+05,
     +  .335688E+05, .250047E+05, .186056E+05, .138326E+05,
     +  .102723E+05, .762156E+04, .564790E+04, .418130E+04,
     +  .309146E+04, .228331E+04, .168404E+04, .124066E+04,
     +  .912638E+03, .670553E+03, .491899E+03, .360386E+03,
     +  .263596E+03, .192539E+03, .140408E+03, .102287E+03,
     +  .740488E+02, .537874E+02, .390068E+02, .282626E+02,
     +  .204507E+02, .147884E+02, .106952E+02, .772996E+01,
     +  .558666E+01, .404222E+01, .292704E+01, .212397E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .154376E+01, .112593E+01, .823229E+00, .604039E+00,
     +  .444561E+00, .328503E+00, .243458E+00, .181335E+00,
     +  .135122E+00, .101253E+00, .758572E-01, .570325E-01,
     +  .429151E-01, .323453E-01, .243794E-01, .183868E-01,
     +  .138485E-01, .104217E-01, .782373E-02, .586436E-02,
     +  .437869E-02, .326019E-02, .241485E-02, .178065E-02,
     +  .130667E-02, .950985E-03, .685655E-03, .490118E-03,
     +  .346181E-03, .241699E-03, .165976E-03, .112113E-03,
     +  .739015E-04, .473400E-04, .291418E-04, .171408E-04,
     +  .924123E-05, .433565E-05, .140400E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .442527E+06, .335630E+06, .250279E+06, .186473E+06,
     +  .138835E+06, .103267E+06, .767523E+05, .569869E+05,
     +  .422765E+05, .313290E+05, .231955E+05, .171535E+05,
     +  .126730E+05, .935107E+04, .689268E+04, .507373E+04,
     +  .373059E+04, .273902E+04, .200857E+04, .147062E+04,
     +  .107537E+04, .785052E+03, .572321E+03, .416512E+03,
     +  .302675E+03, .219567E+03, .159096E+03, .114537E+03,
     +  .827298E+02, .596540E+02, .429679E+02, .309049E+02,
     +  .222095E+02, .159611E+02, .114604E+02, .822762E+01,
     +  .591207E+01, .425113E+01, .306258E+01, .220978E+01,
     +  .159965E+01, .116079E+01, .845192E+00, .617275E+00,
     +  .452575E+00, .332804E+00, .245942E+00, .181841E+00,
     +  .135191E+00, .100496E+00, .749671E-01, .559774E-01 /
        DATA (UPDI(I),I=781,832) /
     +  .418640E-01, .313131E-01, .234341E-01, .175162E-01,
     +  .130817E-01, .974765E-02, .725186E-02, .537552E-02,
     +  .397371E-02, .292337E-02, .214159E-02, .156216E-02,
     +  .113095E-02, .812192E-03, .579231E-03, .409246E-03,
     +  .286815E-03, .198796E-03, .136572E-03, .926592E-04,
     +  .621893E-04, .412694E-04, .273067E-04, .179008E-04,
     +  .117700E-04, .777969E-05, .523721E-05, .359223E-05,
     +  .253740E-05, .182273E-05, .132378E-05, .948433E-06,
     +  .656870E-06, .424644E-06, .245695E-06, .117244E-06,
     +  .379215E-07, .412770E-08, .000000E+00, .684254E+06,
     +  .517233E+06, .384186E+06, .285113E+06, .211428E+06,
     +  .156632E+06, .115942E+06, .857317E+05, .633371E+05,
     +  .467398E+05, .344586E+05, .253738E+05, .186648E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .137120E+05, .100621E+05, .737353E+04, .539680E+04,
     +  .394408E+04, .287867E+04, .209767E+04, .152646E+04,
     +  .110889E+04, .804359E+03, .582405E+03, .421033E+03,
     +  .303807E+03, .218942E+03, .156741E+03, .112575E+03,
     +  .807088E+02, .577895E+02, .413155E+02, .295068E+02,
     +  .210718E+02, .150313E+02, .107197E+02, .765009E+01,
     +  .546274E+01, .390740E+01, .279906E+01, .201129E+01,
     +  .144867E+01, .104684E+01, .758779E+00, .552068E+00,
     +  .402871E+00, .295438E+00, .216773E+00, .159924E+00,
     +  .117978E+00, .873373E-01, .647255E-01, .480416E-01,
     +  .356666E-01, .264922E-01, .196560E-01, .145716E-01,
     +  .107794E-01, .796121E-02, .585975E-02, .430131E-02,
     +  .314321E-02, .228765E-02, .165856E-02, .119402E-02 /
        DATA (UPDI(I),I=885,936) /
     +  .853531E-03, .606591E-03, .427870E-03, .300055E-03,
     +  .208848E-03, .144726E-03, .997018E-04, .685310E-04,
     +  .471106E-04, .326948E-04, .228365E-04, .162133E-04,
     +  .116983E-04, .860235E-05, .640154E-05, .480341E-05,
     +  .358249E-05, .262492E-05, .185836E-05, .124734E-05,
     +  .771416E-06, .421608E-06, .187836E-06, .565688E-07,
     +  .626404E-08, .000000E+00, .988864E+06, .744948E+06,
     +  .551109E+06, .407345E+06, .300840E+06, .221957E+06,
     +  .163615E+06, .120478E+06, .886309E+05, .651268E+05,
     +  .478071E+05, .350499E+05, .256687E+05, .187734E+05,
     +  .137141E+05, .100038E+05, .728804E+04, .530131E+04,
     +  .385085E+04, .279260E+04, .202220E+04, .146173E+04,
     +  .105494E+04, .759921E+03, .546490E+03, .392229E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .281123E+03, .200128E+03, .142922E+03, .101877E+03,
     +  .725148E+02, .515315E+02, .365752E+02, .259556E+02,
     +  .183950E+02, .130321E+02, .923731E+01, .655084E+01,
     +  .465272E+01, .330926E+01, .236064E+01, .168786E+01,
     +  .121064E+01, .870995E+00, .628959E+00, .455546E+00,
     +  .331559E+00, .241460E+00, .176799E+00, .129457E+00,
     +  .951224E-01, .699790E-01, .515593E-01, .380007E-01,
     +  .280201E-01, .206406E-01, .151920E-01, .111595E-01,
     +  .818402E-02, .598264E-02, .436179E-02, .316680E-02,
     +  .229032E-02, .165075E-02, .118196E-02, .841094E-03,
     +  .595659E-03, .419365E-03, .294105E-03, .205318E-03,
     +  .143195E-03, .997574E-04, .697312E-04, .490622E-04,
     +  .350395E-04, .253202E-04, .186273E-04, .139093E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .105215E-04, .799271E-05, .605744E-05, .452262E-05,
     +  .328602E-05, .229141E-05, .150465E-05, .905169E-06,
     +  .477878E-06, .203904E-06, .585427E-07, .655450E-08,
     +  .000000E+00, .136674E+07, .102608E+07, .756006E+06,
     +  .556511E+06, .409309E+06, .300731E+06, .220751E+06,
     +  .161863E+06, .118566E+06, .867477E+05, .634001E+05,
     +  .462773E+05, .337399E+05, .245654E+05, .178633E+05,
     +  .129705E+05, .940517E+04, .680902E+04, .492232E+04,
     +  .355231E+04, .255964E+04, .184098E+04, .132189E+04,
     +  .947311E+03, .677676E+03, .483779E+03, .344848E+03,
     +  .244114E+03, .173348E+03, .122855E+03, .869316E+02,
     +  .614065E+02, .433160E+02, .305474E+02, .215101E+02,
     +  .151395E+02, .106591E+02, .750781E+01, .529539E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .373995E+01, .264881E+01, .188028E+01, .133884E+01,
     +  .956203E+00, .685411E+00, .492789E+00, .356032E+00,
     +  .257385E+00, .187078E+00, .135987E+00, .991958E-01,
     +  .724540E-01, .530007E-01, .387869E-01, .283971E-01,
     +  .207725E-01, .151829E-01, .110770E-01, .806835E-02,
     +  .585923E-02, .424405E-02, .306225E-02, .220145E-02,
     +  .157790E-02, .112409E-02, .796595E-03, .562382E-03,
     +  .395320E-03, .277320E-03, .194169E-03, .136216E-03,
     +  .958218E-04, .679088E-04, .486342E-04, .354418E-04,
     +  .261730E-04, .196482E-04, .149231E-04, .114178E-04,
     +  .872262E-05, .660341E-05, .489888E-05, .351732E-05,
     +  .241371E-05, .155288E-05, .911316E-06, .466684E-06,
     +  .191733E-06, .528116E-07, .597027E-08, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .182852E+07, .136803E+07, .100382E+07, .735890E+06,
     +  .538990E+06, .394354E+06, .288250E+06, .210455E+06,
     +  .153496E+06, .111816E+06, .813622E+05, .591252E+05,
     +  .429136E+05, .311033E+05, .225137E+05, .162715E+05,
     +  .117434E+05, .846151E+04, .608749E+04, .437182E+04,
     +  .313457E+04, .224320E+04, .160251E+04, .114249E+04,
     +  .813013E+03, .577286E+03, .409262E+03, .288089E+03,
     +  .203423E+03, .143345E+03, .100836E+03, .708045E+02,
     +  .496407E+02, .347911E+02, .243425E+02, .170224E+02,
     +  .119055E+02, .832952E+01, .583480E+01, .409246E+01,
     +  .287812E+01, .202861E+01, .143414E+01, .101694E+01,
     +  .723701E+00, .516576E+00, .370538E+00, .265954E+00,
     +  .191921E+00, .138517E+00, .100326E+00, .727682E-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .528592E-01, .384170E-01, .279325E-01, .202943E-01,
     +  .147336E-01, .106784E-01, .772704E-02, .557581E-02,
     +  .401365E-02, .287897E-02, .205801E-02, .146749E-02,
     +  .104061E-02, .734744E-03, .517378E-03, .363321E-03,
     +  .255080E-03, .179187E-03, .126449E-03, .897604E-04,
     +  .643819E-04, .467753E-04, .346058E-04, .259361E-04,
     +  .197090E-04, .150984E-04, .115958E-04, .885200E-05,
     +  .666388E-05, .489755E-05, .346976E-05, .234212E-05,
     +  .147691E-05, .846313E-06, .421015E-06, .166932E-06,
     +  .442689E-07, .505006E-08, .000000E+00, .238473E+07,
     +  .177801E+07, .129929E+07, .948573E+06, .691870E+06,
     +  .504084E+06, .366894E+06, .266730E+06, .193699E+06,
     +  .140489E+06, .101776E+06, .736312E+05, .532021E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .383855E+05, .276573E+05, .198964E+05, .142921E+05,
     +  .102491E+05, .733810E+04, .524435E+04, .374161E+04,
     +  .266425E+04, .189364E+04, .134311E+04, .950778E+03,
     +  .671508E+03, .473483E+03, .331440E+03, .232725E+03,
     +  .163062E+03, .114040E+03, .796038E+02, .554730E+02,
     +  .386409E+02, .268664E+02, .186675E+02, .129710E+02,
     +  .901511E+01, .627261E+01, .436966E+01, .305189E+01,
     +  .213617E+01, .149960E+01, .105591E+01, .746137E+00,
     +  .528841E+00, .376675E+00, .268464E+00, .192378E+00,
     +  .137884E+00, .991778E-01, .714458E-01, .515461E-01,
     +  .372113E-01, .268748E-01, .193974E-01, .139907E-01,
     +  .100753E-01, .724468E-02, .519594E-02, .371805E-02,
     +  .265208E-02, .188582E-02, .133835E-02, .945133E-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .665254E-03, .467526E-03, .328195E-03, .230753E-03,
     +  .162709E-03, .115519E-03, .827107E-04, .599614E-04,
     +  .440815E-04, .329884E-04, .249744E-04, .191132E-04,
     +  .146944E-04, .112797E-04, .857433E-05, .640332E-05,
     +  .465462E-05, .325134E-05, .215810E-05, .133403E-05,
     +  .746719E-06, .361127E-06, .138383E-06, .354258E-07,
     +  .407647E-08, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .543123E+05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .244285E+05, .190786E+05, .147178E+05, .113463E+05,
     +  .874605E+04, .673689E+04, .518850E+04, .399293E+04,
     +  .307229E+04, .236199E+04, .181549E+04, .139422E+04,
     +  .107042E+04, .821041E+03, .629569E+03, .482260E+03,
     +  .369290E+03, .282474E+03, .215981E+03, .164950E+03,
     +  .125927E+03, .960226E+02, .731883E+02, .557167E+02,
     +  .423975E+02, .322290E+02, .244967E+02, .185276E+02,
     +  .140676E+02, .106716E+02, .809897E+01, .614364E+01,
     +  .466428E+01, .354437E+01, .269620E+01, .205282E+01,
     +  .156720E+01, .119834E+01, .919522E+00, .707113E+00,
     +  .546207E+00, .423045E+00, .329023E+00, .256600E+00,
     +  .200975E+00, .157767E+00, .124430E+00, .981085E-01,
     +  .777568E-01, .615583E-01, .488779E-01, .387957E-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .308326E-01, .244806E-01, .194448E-01, .154099E-01,
     +  .121979E-01, .962452E-02, .758305E-02, .594747E-02,
     +  .465219E-02, .361897E-02, .280301E-02, .216106E-02,
     +  .165276E-02, .125184E-02, .939886E-03, .697123E-03,
     +  .510911E-03, .367893E-03, .260068E-03, .178741E-03,
     +  .118899E-03, .746856E-04, .437015E-04, .217533E-04,
     +  .709104E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .601505E+05,
     +  .467777E+05, .359112E+05, .275511E+05, .211324E+05,
     +  .161976E+05, .124119E+05, .950386E+04, .727496E+04,
     +  .556433E+04, .425448E+04, .325018E+04, .248200E+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .189363E+04, .144412E+04, .110022E+04, .837824E+03,
     +  .637325E+03, .484556E+03, .367991E+03, .279323E+03,
     +  .211772E+03, .160469E+03, .121449E+03, .918647E+02,
     +  .694145E+02, .524384E+02, .394136E+02, .297366E+02,
     +  .224150E+02, .168996E+02, .127347E+02, .960176E+01,
     +  .724580E+01, .547194E+01, .413569E+01, .313317E+01,
     +  .237723E+01, .180943E+01, .138018E+01, .105719E+01,
     +  .811932E+00, .626041E+00, .484069E+00, .375830E+00,
     +  .292495E+00, .228685E+00, .178776E+00, .140470E+00,
     +  .110270E+00, .868151E-01, .683415E-01, .538649E-01,
     +  .424233E-01, .334228E-01, .262782E-01, .206373E-01,
     +  .161604E-01, .126367E-01, .984058E-02, .764457E-02,
     +  .590944E-02, .455129E-02, .349213E-02, .266142E-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .201276E-02, .151287E-02, .112759E-02, .834668E-03,
     +  .611624E-03, .444669E-03, .319511E-03, .227407E-03,
     +  .159328E-03, .110946E-03, .758288E-04, .512545E-04,
     +  .340170E-04, .222808E-04, .142856E-04, .902616E-05,
     +  .555983E-05, .335407E-05, .195007E-05, .109326E-05,
     +  .574451E-06, .278710E-06, .118311E-06, .385281E-07,
     +  .390835E-08, .000000E+00, .109565E+06, .848665E+05,
     +  .648548E+05, .495297E+05, .378140E+05, .288491E+05,
     +  .220018E+05, .167671E+05, .127729E+05, .972233E+04,
     +  .739715E+04, .562321E+04, .427266E+04, .324347E+04,
     +  .246092E+04, .186532E+04, .141306E+04, .106932E+04,
     +  .808694E+03, .610902E+03, .461197E+03, .347771E+03,
     +  .262065E+03, .197243E+03, .148353E+03, .111460E+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .837116E+02, .625449E+02, .469042E+02, .351414E+02,
     +  .263286E+02, .197144E+02, .147668E+02, .110698E+02,
     +  .830206E+01, .623087E+01, .468616E+01, .352943E+01,
     +  .266598E+01, .201796E+01, .153351E+01, .116844E+01,
     +  .893647E+00, .685445E+00, .527835E+00, .407488E+00,
     +  .316005E+00, .245075E+00, .191013E+00, .148768E+00,
     +  .116201E+00, .907733E-01, .709939E-01, .554937E-01,
     +  .433887E-01, .338617E-01, .263966E-01, .205223E-01,
     +  .159315E-01, .123201E-01, .950433E-02, .729840E-02,
     +  .558466E-02, .425853E-02, .322659E-02, .242787E-02,
     +  .181713E-02, .135037E-02, .998108E-03, .732055E-03,
     +  .534209E-03, .386935E-03, .279004E-03, .199629E-03,
     +  .143112E-03, .101975E-03, .728545E-04, .520172E-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .373306E-04, .267859E-04, .192989E-04, .138139E-04,
     +  .979282E-05, .677180E-05, .451253E-05, .281798E-05,
     +  .159491E-05, .764646E-06, .260725E-06, .279925E-07,
     +  .000000E+00, .174073E+06, .135523E+06, .103113E+06,
     +  .784017E+05, .595899E+05, .452593E+05, .343604E+05,
     +  .260662E+05, .197650E+05, .149748E+05, .113398E+05,
     +  .857969E+04, .648780E+04, .490136E+04, .370062E+04,
     +  .279123E+04, .210395E+04, .158418E+04, .119197E+04,
     +  .895843E+03, .672797E+03, .504682E+03, .378283E+03,
     +  .283192E+03, .211836E+03, .158278E+03, .118206E+03,
     +  .878083E+02, .654663E+02, .487600E+02, .363104E+02,
     +  .270219E+02, .201121E+02, .149802E+02, .111601E+02,
     +  .831943E+01, .621326E+01, .464657E+01, .348426E+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .261800E+01, .197453E+01, .149313E+01, .113319E+01,
     +  .862546E+00, .659071E+00, .504908E+00, .388541E+00,
     +  .299050E+00, .231305E+00, .178803E+00, .138616E+00,
     +  .107495E+00, .834578E-01, .647698E-01, .502766E-01,
     +  .389611E-01, .301583E-01, .232864E-01, .179522E-01,
     +  .137899E-01, .105667E-01, .806162E-02, .612900E-02,
     +  .464438E-02, .349751E-02, .261701E-02, .194858E-02,
     +  .144170E-02, .106174E-02, .776950E-03, .566475E-03,
     +  .410855E-03, .297358E-03, .214351E-03, .155282E-03,
     +  .112336E-03, .817829E-04, .597460E-04, .439584E-04,
     +  .323869E-04, .239154E-04, .175047E-04, .126217E-04,
     +  .883591E-05, .592059E-05, .369554E-05, .207424E-05,
     +  .975515E-06, .321295E-06, .348317E-07, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .280473E+06, .215485E+06, .163135E+06, .123423E+06,
     +  .933335E+05, .705290E+05, .532688E+05, .402019E+05,
     +  .303233E+05, .228534E+05, .172132E+05, .129537E+05,
     +  .974181E+04, .731945E+04, .549550E+04, .412191E+04,
     +  .308928E+04, .231283E+04, .173010E+04, .129270E+04,
     +  .965063E+03, .719595E+03, .536073E+03, .398858E+03,
     +  .296484E+03, .220122E+03, .163327E+03, .120521E+03,
     +  .892514E+02, .660257E+02, .488240E+02, .360781E+02,
     +  .266563E+02, .197086E+02, .145703E+02, .107778E+02,
     +  .798480E+01, .592332E+01, .440465E+01, .328195E+01,
     +  .245407E+01, .183987E+01, .138416E+01, .104447E+01,
     +  .791074E+00, .600794E+00, .458308E+00, .349736E+00,
     +  .268181E+00, .205565E+00, .158020E+00, .121539E+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .935831E-01, .720441E-01, .554681E-01, .426433E-01,
     +  .327444E-01, .250850E-01, .191835E-01, .146192E-01,
     +  .111105E-01, .840719E-02, .633666E-02, .475890E-02,
     +  .354910E-02, .262847E-02, .193483E-02, .141344E-02,
     +  .102564E-02, .737776E-03, .526898E-03, .372750E-03,
     +  .261625E-03, .181698E-03, .125804E-03, .861677E-04,
     +  .588028E-04, .398846E-04, .270321E-04, .182494E-04,
     +  .123375E-04, .829247E-05, .553764E-05, .362355E-05,
     +  .229978E-05, .137579E-05, .751304E-06, .348524E-06,
     +  .114982E-06, .123663E-07, .000000E+00, .421279E+06,
     +  .322293E+06, .242795E+06, .182785E+06, .137532E+06,
     +  .103406E+06, .777029E+05, .583424E+05, .437782E+05,
     +  .328220E+05, .245911E+05, .184076E+05, .137689E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .102892E+05, .768274E+04, .573062E+04, .427087E+04,
     +  .317940E+04, .236470E+04, .175667E+04, .130373E+04,
     +  .966374E+03, .715579E+03, .529184E+03, .390926E+03,
     +  .288420E+03, .212635E+03, .155877E+03, .114671E+03,
     +  .842633E+02, .618823E+02, .454095E+02, .333108E+02,
     +  .244506E+02, .179410E+02, .131708E+02, .968173E+01,
     +  .712569E+01, .525602E+01, .388454E+01, .288059E+01,
     +  .214172E+01, .159768E+01, .119549E+01, .897795E+00,
     +  .676127E+00, .511443E+00, .387044E+00, .294316E+00,
     +  .223747E+00, .170586E+00, .130152E+00, .994086E-01,
     +  .759235E-01, .579894E-01, .442333E-01, .336995E-01,
     +  .256185E-01, .194394E-01, .147018E-01, .110877E-01,
     +  .832733E-02, .622931E-02, .464379E-02, .343782E-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .252832E-02, .184863E-02, .134221E-02, .968534E-03,
     +  .693601E-03, .493731E-03, .348843E-03, .245078E-03,
     +  .171025E-03, .119438E-03, .829885E-04, .577731E-04,
     +  .402618E-04, .281966E-04, .197844E-04, .139245E-04,
     +  .974821E-05, .674226E-05, .454225E-05, .293439E-05,
     +  .176639E-05, .954071E-06, .427650E-06, .132021E-06,
     +  .144613E-07, .000000E+00, .606043E+06, .461720E+06,
     +  .346147E+06, .259324E+06, .194163E+06, .145263E+06,
     +  .108609E+06, .811364E+05, .605717E+05, .451795E+05,
     +  .336736E+05, .250744E+05, .186562E+05, .138669E+05,
     +  .102981E+05, .763958E+04, .566209E+04, .419158E+04,
     +  .309989E+04, .228969E+04, .168949E+04, .124498E+04,
     +  .916407E+03, .673629E+03, .494594E+03, .362641E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .265668E+03, .193491E+03, .141414E+03, .103229E+03,
     +  .752978E+02, .548750E+02, .399713E+02, .291307E+02,
     +  .212185E+02, .154612E+02, .112788E+02, .823723E+01,
     +  .602811E+01, .441985E+01, .325112E+01, .239764E+01,
     +  .177395E+01, .131656E+01, .980587E+00, .732446E+00,
     +  .549526E+00, .412501E+00, .311136E+00, .234643E+00,
     +  .177469E+00, .134345E+00, .101808E+00, .771567E-01,
     +  .584754E-01, .442645E-01, .334671E-01, .252516E-01,
     +  .190169E-01, .142763E-01, .106872E-01, .796852E-02,
     +  .591780E-02, .438028E-02, .322005E-02, .235249E-02,
     +  .170923E-02, .123393E-02, .885886E-03, .631912E-03,
     +  .448599E-03, .316708E-03, .222827E-03, .156251E-03,
     +  .110006E-03, .773964E-04, .547670E-04, .389549E-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .279066E-04, .200576E-04, .144351E-04, .103073E-04,
     +  .723097E-05, .491666E-05, .318349E-05, .190864E-05,
     +  .101789E-05, .445670E-06, .132870E-06, .146990E-07,
     +  .000000E+00, .843898E+06, .640313E+06, .477745E+06,
     +  .356194E+06, .265399E+06, .197587E+06, .147000E+06,
     +  .109270E+06, .811643E+05, .602321E+05, .446625E+05,
     +  .330850E+05, .244875E+05, .181051E+05, .133738E+05,
     +  .986768E+04, .727350E+04, .535480E+04, .393803E+04,
     +  .289236E+04, .212195E+04, .155462E+04, .113760E+04,
     +  .831250E+03, .606638E+03, .442061E+03, .321830E+03,
     +  .232892E+03, .169115E+03, .122644E+03, .888634E+02,
     +  .643229E+02, .465288E+02, .336719E+02, .243498E+02,
     +  .176133E+02, .127528E+02, .924341E+01, .671239E+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .488337E+01, .356379E+01, .260743E+01, .191378E+01,
     +  .140902E+01, .104105E+01, .771414E+00, .574167E+00,
     +  .427595E+00, .319979E+00, .239431E+00, .179686E+00,
     +  .134986E+00, .101514E+00, .763547E-01, .574317E-01,
     +  .431519E-01, .323847E-01, .242570E-01, .181346E-01,
     +  .135165E-01, .100461E-01, .743820E-02, .548557E-02,
     +  .403281E-02, .294494E-02, .213810E-02, .154440E-02,
     +  .110916E-02, .792760E-03, .563627E-03, .399335E-03,
     +  .281912E-03, .198777E-03, .140105E-03, .994154E-04,
     +  .707268E-04, .507253E-04, .366390E-04, .266552E-04,
     +  .194377E-04, .141482E-04, .101820E-04, .716300E-05,
     +  .486246E-05, .312623E-05, .185163E-05, .968882E-06,
     +  .412576E-06, .118819E-06, .132609E-07, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .114471E+07, .865078E+06, .642405E+06, .476690E+06,
     +  .353480E+06, .261893E+06, .193892E+06, .143419E+06,
     +  .106000E+06, .782682E+05, .577424E+05, .425556E+05,
     +  .313342E+05, .230464E+05, .169338E+05, .124278E+05,
     +  .911111E+04, .667109E+04, .487895E+04, .356343E+04,
     +  .259947E+04, .189356E+04, .137757E+04, .100068E+04,
     +  .725925E+03, .525773E+03, .380414E+03, .273542E+03,
     +  .197371E+03, .142214E+03, .102365E+03, .736010E+02,
     +  .528773E+02, .380019E+02, .272866E+02, .195959E+02,
     +  .140845E+02, .101330E+02, .730294E+01, .527264E+01,
     +  .381824E+01, .277200E+01, .201872E+01, .147472E+01,
     +  .108108E+01, .794840E+00, .587023E+00, .433798E+00,
     +  .322127E+00, .239203E+00, .178158E+00, .132840E+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .991578E-01, .740344E-01, .552778E-01, .412329E-01,
     +  .307220E-01, .228484E-01, .169606E-01, .125535E-01,
     +  .926590E-02, .681434E-02, .499197E-02, .364618E-02,
     +  .264594E-02, .190985E-02, .137215E-02, .980890E-03,
     +  .698422E-03, .495286E-03, .350509E-03, .247631E-03,
     +  .175118E-03, .124114E-03, .887507E-04, .637759E-04,
     +  .462557E-04, .338023E-04, .248497E-04, .182744E-04,
     +  .133665E-04, .963245E-05, .675542E-05, .455395E-05,
     +  .289441E-05, .168711E-05, .863526E-06, .356855E-06,
     +  .992376E-07, .111714E-07, .000000E+00, .151887E+07,
     +  .114332E+07, .845082E+06, .624155E+06, .460644E+06,
     +  .339666E+06, .250262E+06, .184217E+06, .135486E+06,
     +  .995453E+05, .730722E+05, .535817E+05, .392514E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .287207E+05, .209931E+05, .153258E+05, .111757E+05,
     +  .813871E+04, .591981E+04, .429979E+04, .311909E+04,
     +  .225921E+04, .163416E+04, .118016E+04, .851079E+03,
     +  .612720E+03, .440625E+03, .314856E+03, .225756E+03,
     +  .161632E+03, .115588E+03, .825625E+02, .589175E+02,
     +  .420552E+02, .299872E+02, .213836E+02, .152589E+02,
     +  .108982E+02, .779650E+01, .558711E+01, .401551E+01,
     +  .289317E+01, .209092E+01, .151585E+01, .110276E+01,
     +  .804616E+00, .589753E+00, .432531E+00, .318779E+00,
     +  .234956E+00, .173704E+00, .128576E+00, .952790E-01,
     +  .706279E-01, .523570E-01, .387786E-01, .286910E-01,
     +  .211905E-01, .156218E-01, .114846E-01, .842038E-02,
     +  .615234E-02, .447823E-02, .325083E-02, .234518E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .168364E-02, .120378E-02, .857053E-03, .608349E-03,
     +  .430634E-03, .304653E-03, .215570E-03, .153000E-03,
     +  .109072E-03, .785807E-04, .569750E-04, .417048E-04,
     +  .307403E-04, .227501E-04, .168001E-04, .122959E-04,
     +  .883693E-05, .615672E-05, .410894E-05, .257533E-05,
     +  .147419E-05, .736888E-06, .295274E-06, .793367E-07,
     +  .900724E-08, .000000E+00, .197698E+07, .148242E+07,
     +  .109071E+07, .801864E+06, .589045E+06, .432308E+06,
     +  .317010E+06, .232233E+06, .169975E+06, .124276E+06,
     +  .907763E+05, .662323E+05, .482743E+05, .351432E+05,
     +  .255554E+05, .185594E+05, .134626E+05, .975194E+04,
     +  .705503E+04, .509643E+04, .367658E+04, .264814E+04,
     +  .190463E+04, .136761E+04, .980518E+03, .701728E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .501605E+03, .356221E+03, .253838E+03, .180601E+03,
     +  .128329E+03, .910705E+02, .645604E+02, .457754E+02,
     +  .324172E+02, .229565E+02, .162660E+02, .115348E+02,
     +  .819238E+01, .582805E+01, .415785E+01, .297356E+01,
     +  .213305E+01, .153490E+01, .110830E+01, .802654E+00,
     +  .583976E+00, .425140E+00, .311040E+00, .227586E+00,
     +  .167043E+00, .122767E+00, .903300E-01, .664901E-01,
     +  .489457E-01, .360026E-01, .264554E-01, .194080E-01,
     +  .142122E-01, .103801E-01, .756154E-02, .549037E-02,
     +  .397201E-02, .286660E-02, .205664E-02, .146921E-02,
     +  .104594E-02, .742110E-03, .525488E-03, .371590E-03,
     +  .263000E-03, .186523E-03, .132937E-03, .953353E-04,
     +  .691714E-04, .505437E-04, .372672E-04, .276345E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .205268E-04, .151726E-04, .110783E-04, .791845E-05,
     +  .546790E-05, .360576E-05, .222513E-05, .124926E-05,
     +  .609272E-06, .236665E-06, .615071E-07, .704146E-08,
     +  .000000E+00, .252961E+07, .188962E+07, .138405E+07,
     +  .101291E+07, .740668E+06, .541076E+06, .394917E+06,
     +  .287943E+06, .209746E+06, .152618E+06, .110937E+06,
     +  .805448E+05, .584148E+05, .423124E+05, .306126E+05,
     +  .221183E+05, .159609E+05, .115011E+05, .827629E+04,
     +  .594657E+04, .426655E+04, .305616E+04, .218584E+04,
     +  .156066E+04, .111252E+04, .791551E+03, .562471E+03,
     +  .397023E+03, .281195E+03, .198833E+03, .140399E+03,
     +  .990030E+02, .697295E+02, .491166E+02, .345507E+02,
     +  .243015E+02, .171003E+02, .120420E+02, .849217E+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .599828E+01, .424852E+01, .301644E+01, .214810E+01,
     +  .153450E+01, .109996E+01, .790830E+00, .571229E+00,
     +  .412867E+00, .299903E+00, .217880E+00, .158795E+00,
     +  .115893E+00, .846831E-01, .619070E-01, .452618E-01,
     +  .330694E-01, .241386E-01, .175925E-01, .127993E-01,
     +  .928905E-02, .672476E-02, .485356E-02, .349092E-02,
     +  .250560E-02, .178850E-02, .127193E-02, .902075E-03,
     +  .638225E-03, .451145E-03, .318913E-03, .225980E-03,
     +  .160731E-03, .115073E-03, .830095E-04, .606179E-04,
     +  .445815E-04, .330499E-04, .245978E-04, .182928E-04,
     +  .135005E-04, .981189E-05, .696129E-05, .475669E-05,
     +  .309524E-05, .187869E-05, .103362E-05, .491573E-06,
     +  .185117E-06, .465962E-07, .537825E-08, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .464548E+05, .160858E+05, .125191E+05, .974334E+04,
     +  .758309E+04, .590187E+04, .459345E+04, .357516E+04,
     +  .278266E+04, .216589E+04, .168588E+04, .131230E+04,
     +  .102155E+04, .795269E+03, .619154E+03, .482083E+03,
     +  .375399E+03, .292364E+03, .227733E+03, .177426E+03,
     +  .138267E+03, .107783E+03, .840522E+02, .655763E+02,
     +  .511904E+02, .399878E+02, .312626E+02, .243809E+02,
     +  .191054E+02, .149929E+02, .117856E+02, .928296E+01,
     +  .732875E+01, .580549E+01, .461035E+01, .367418E+01,
     +  .293941E+01, .236126E+01, .190493E+01, .154323E+01,
     +  .125569E+01, .102556E+01, .840443E+00, .690652E+00,
     +  .568737E+00, .468959E+00, .387162E+00, .319151E+00,
     +  .263099E+00, .216224E+00, .177363E+00, .145007E+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .118088E+00, .957298E-01, .772069E-01, .619136E-01,
     +  .493399E-01, .390531E-01, .306847E-01, .239197E-01,
     +  .184884E-01, .141606E-01, .107400E-01, .807104E-02,
     +  .598648E-02, .438621E-02, .317135E-02, .226017E-02,
     +  .158572E-02, .109362E-02, .740184E-03, .490701E-03,
     +  .317842E-03, .200516E-03, .123406E-03, .733026E-04,
     +  .419808E-04, .230548E-04, .120593E-04, .595724E-05,
     +  .274915E-05, .117011E-05, .447771E-06, .151154E-06,
     +  .430811E-07, .974671E-08, .157834E-08, .150672E-09,
     +  .548407E-11, .188828E-13, .000000E+00, .444358E+05,
     +  .291849E+05, .227488E+05, .177248E+05, .138135E+05,
     +  .107607E+05, .838421E+04, .652969E+04, .508627E+04,
     +  .396008E+04, .308372E+04, .240012E+04, .186830E+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .145357E+04, .113104E+04, .879591E+03, .684117E+03,
     +  .531788E+03, .413418E+03, .321221E+03, .249621E+03,
     +  .193883E+03, .150621E+03, .116963E+03, .908539E+02,
     +  .705588E+02, .548269E+02, .424553E+02, .330233E+02,
     +  .256960E+02, .200224E+02, .156157E+02, .122029E+02,
     +  .955778E+01, .750251E+01, .590342E+01, .466206E+01,
     +  .369293E+01, .293744E+01, .234416E+01, .187910E+01,
     +  .151100E+01, .121947E+01, .986616E+00, .800431E+00,
     +  .650226E+00, .529404E+00, .430427E+00, .350506E+00,
     +  .284649E+00, .231063E+00, .187079E+00, .151117E+00,
     +  .121634E+00, .975771E-01, .779151E-01, .619388E-01,
     +  .489682E-01, .385184E-01, .301038E-01, .233882E-01,
     +  .180404E-01, .138180E-01, .105147E-01, .792245E-02 /
        DATA (UPDI(I),I=2705,2756) /
     +  .591070E-02, .436681E-02, .318861E-02, .230014E-02,
     +  .163384E-02, .114109E-02, .778355E-03, .516486E-03,
     +  .327417E-03, .195954E-03, .104171E-03, .422583E-04,
     +  .208099E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .609392E+05, .478473E+05,
     +  .371397E+05, .288164E+05, .223593E+05, .173415E+05,
     +  .134500E+05, .104269E+05, .808320E+04, .626323E+04,
     +  .485288E+04, .375813E+04, .291018E+04, .225230E+04,
     +  .174300E+04, .134807E+04, .104253E+04, .805735E+03,
     +  .622662E+03, .480887E+03, .371368E+03, .286621E+03,
     +  .221208E+03, .170632E+03, .131627E+03, .101504E+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .783020E+02, .601749E+02, .464438E+02, .358516E+02,
     +  .277050E+02, .214241E+02, .165937E+02, .128790E+02,
     +  .100140E+02, .780306E+01, .610021E+01, .478225E+01,
     +  .376351E+01, .297094E+01, .235541E+01, .187312E+01,
     +  .149495E+01, .119621E+01, .959935E+00, .771521E+00,
     +  .621696E+00, .500395E+00, .403611E+00, .324780E+00,
     +  .261357E+00, .209881E+00, .168240E+00, .134457E+00,
     +  .107156E+00, .850473E-01, .672319E-01, .528853E-01,
     +  .414113E-01, .322343E-01, .249544E-01, .191894E-01,
     +  .146584E-01, .111293E-01, .836822E-02, .623130E-02,
     +  .459481E-02, .334833E-02, .240959E-02, .170635E-02,
     +  .118663E-02, .804697E-03, .529249E-03, .331085E-03,
     +  .194125E-03, .994237E-04, .366669E-04, .000000E+00 /
        DATA (UPDI(I),I=2809,2860) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .961749E+05, .751599E+05, .580298E+05,
     +  .447847E+05, .345599E+05, .266572E+05, .205594E+05,
     +  .158488E+05, .122159E+05, .941087E+04, .724883E+04,
     +  .558041E+04, .429524E+04, .330411E+04, .254118E+04,
     +  .195320E+04, .150094E+04, .115265E+04, .884968E+03,
     +  .679003E+03, .520871E+03, .399308E+03, .306064E+03,
     +  .234452E+03, .179579E+03, .137490E+03, .105289E+03,
     +  .803041E+02, .615067E+02, .471106E+02, .361146E+02,
     +  .276997E+02, .212738E+02, .163700E+02, .126155E+02,
     +  .974119E+01, .754436E+01, .585818E+01, .456532E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .356836E+01, .280076E+01, .220496E+01, .174206E+01,
     +  .138002E+01, .109648E+01, .872720E+00, .696580E+00,
     +  .555482E+00, .444053E+00, .354243E+00, .282704E+00,
     +  .225232E+00, .179180E+00, .142176E+00, .112534E+00,
     +  .887406E-01, .697219E-01, .545304E-01, .424692E-01,
     +  .328930E-01, .253466E-01, .194095E-01, .147705E-01,
     +  .111779E-01, .838149E-02, .622829E-02, .458710E-02,
     +  .334281E-02, .240960E-02, .171332E-02, .120052E-02,
     +  .825095E-03, .554731E-03, .360794E-03, .226677E-03,
     +  .133758E-03, .718207E-04, .350123E-04, .222810E-04,
     +  .142856E-04, .902616E-05, .555983E-05, .335407E-05,
     +  .195007E-05, .109326E-05, .574451E-06, .278710E-06,
     +  .118311E-06, .385281E-07, .390835E-08, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .145129E+06, .112884E+06, .866872E+05, .665398E+05,
     +  .510662E+05, .391717E+05, .300418E+05, .230279E+05,
     +  .176477E+05, .135171E+05, .103508E+05, .792159E+04,
     +  .606084E+04, .463431E+04, .354251E+04, .270615E+04,
     +  .206661E+04, .157712E+04, .120317E+04, .917247E+03,
     +  .699058E+03, .532402E+03, .405361E+03, .308432E+03,
     +  .234628E+03, .178394E+03, .135654E+03, .102715E+03,
     +  .780971E+02, .593746E+02, .451704E+02, .343776E+02,
     +  .261925E+02, .199921E+02, .152785E+02, .116974E+02,
     +  .898048E+01, .691159E+01, .533750E+01, .413378E+01,
     +  .321451E+01, .250723E+01, .196241E+01, .154024E+01,
     +  .121256E+01, .956417E+00, .756648E+00, .598173E+00,
     +  .474173E+00, .375192E+00, .297063E+00, .234882E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .185491E+00, .146155E+00, .114902E+00, .900229E-01,
     +  .702897E-01, .546497E-01, .423199E-01, .326009E-01,
     +  .249922E-01, .190456E-01, .144272E-01, .108715E-01,
     +  .811931E-02, .601226E-02, .441476E-02, .321004E-02,
     +  .231094E-02, .164344E-02, .115406E-02, .797483E-03,
     +  .541578E-03, .358844E-03, .232712E-03, .145443E-03,
     +  .873437E-04, .527120E-04, .373308E-04, .267859E-04,
     +  .192989E-04, .138139E-04, .979282E-05, .677180E-05,
     +  .451253E-05, .281798E-05, .159491E-05, .764646E-06,
     +  .260725E-06, .279925E-07, .000000E+00, .164732E+06,
     +  .163191E+06, .124672E+06, .951981E+05, .726745E+05,
     +  .554508E+05, .422976E+05, .322466E+05, .245767E+05,
     +  .187201E+05, .142546E+05, .108476E+05, .825200E+04 /
        DATA (UPDI(I),I=3017,3068) /
     +  .627338E+04, .476740E+04, .362043E+04, .274832E+04,
     +  .208477E+04, .158076E+04, .119771E+04, .907122E+03,
     +  .686526E+03, .519373E+03, .392638E+03, .296727E+03,
     +  .224115E+03, .169274E+03, .127283E+03, .961025E+02,
     +  .725466E+02, .547915E+02, .413929E+02, .312992E+02,
     +  .237068E+02, .179745E+02, .136511E+02, .103942E+02,
     +  .793295E+01, .607413E+01, .466391E+01, .359526E+01,
     +  .277982E+01, .215677E+01, .167814E+01, .130975E+01,
     +  .102433E+01, .803637E+00, .630138E+00, .495539E+00,
     +  .389057E+00, .305719E+00, .239968E+00, .188167E+00,
     +  .147253E+00, .114997E+00, .895226E-01, .694662E-01,
     +  .536882E-01, .413347E-01, .316655E-01, .241446E-01,
     +  .183053E-01, .137977E-01, .103478E-01, .769311E-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .567277E-02, .414956E-02, .300732E-02, .215933E-02,
     +  .153317E-02, .107638E-02, .745279E-03, .508689E-03,
     +  .340595E-03, .224905E-03, .145067E-03, .920915E-04,
     +  .602360E-04, .439586E-04, .323869E-04, .239154E-04,
     +  .175047E-04, .126217E-04, .883591E-05, .592059E-05,
     +  .369554E-05, .207424E-05, .975515E-06, .321295E-06,
     +  .348317E-07, .000000E+00, .315094E+06, .242756E+06,
     +  .184383E+06, .139976E+06, .106227E+06, .805709E+05,
     +  .610886E+05, .462903E+05, .350628E+05, .265422E+05,
     +  .200836E+05, .151868E+05, .114786E+05, .866996E+04,
     +  .654536E+04, .493781E+04, .372317E+04, .280517E+04,
     +  .211239E+04, .158945E+04, .119534E+04, .898243E+03,
     +  .674635E+03, .506303E+03, .379788E+03, .284697E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .213390E+03, .159196E+03, .119246E+03, .892971E+02,
     +  .668886E+02, .501112E+02, .375674E+02, .282084E+02,
     +  .211970E+02, .159532E+02, .120346E+02, .909890E+01,
     +  .690030E+01, .524737E+01, .400566E+01, .306703E+01,
     +  .235634E+01, .181568E+01, .140343E+01, .108720E+01,
     +  .844995E+00, .656499E+00, .511641E+00, .398188E+00,
     +  .310223E+00, .241497E+00, .187839E+00, .145852E+00,
     +  .113034E+00, .873460E-01, .672882E-01, .516419E-01,
     +  .394853E-01, .300463E-01, .227575E-01, .171409E-01,
     +  .128346E-01, .956133E-02, .705909E-02, .516801E-02,
     +  .375138E-02, .269626E-02, .191795E-02, .134733E-02,
     +  .933955E-03, .636781E-03, .426264E-03, .278435E-03,
     +  .177994E-03, .109901E-03, .659175E-04, .402200E-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .270323E-04, .182494E-04, .123375E-04, .829247E-05,
     +  .553764E-05, .362355E-05, .229978E-05, .137579E-05,
     +  .751304E-06, .348524E-06, .114982E-06, .123663E-07,
     +  .000000E+00, .455406E+06, .349173E+06, .263737E+06,
     +  .199098E+06, .150238E+06, .113301E+06, .854074E+05,
     +  .643405E+05, .484468E+05, .364552E+05, .274178E+05,
     +  .206064E+05, .154787E+05, .116185E+05, .871593E+04,
     +  .653341E+04, .489444E+04, .366361E+04, .274057E+04,
     +  .204836E+04, .153002E+04, .114187E+04, .851642E+03,
     +  .634649E+03, .472658E+03, .351745E+03, .261702E+03,
     +  .193758E+03, .144029E+03, .107022E+03, .795324E+02,
     +  .591060E+02, .439467E+02, .327242E+02, .243805E+02,
     +  .181903E+02, .136008E+02, .101911E+02, .765815E+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .577029E+01, .436400E+01, .331041E+01, .251963E+01,
     +  .192357E+01, .147312E+01, .113081E+01, .871010E+00,
     +  .670732E+00, .518199E+00, .399862E+00, .308933E+00,
     +  .238545E+00, .184068E+00, .141818E+00, .109072E+00,
     +  .836598E-01, .639800E-01, .487555E-01, .370179E-01,
     +  .279773E-01, .210482E-01, .157498E-01, .117165E-01,
     +  .867297E-02, .636294E-02, .463012E-02, .334122E-02,
     +  .238822E-02, .169011E-02, .118205E-02, .816568E-03,
     +  .555760E-03, .372253E-03, .244406E-03, .158075E-03,
     +  .999138E-04, .625597E-04, .404852E-04, .281968E-04,
     +  .197844E-04, .139245E-04, .974821E-05, .674226E-05,
     +  .454225E-05, .293439E-05, .176639E-05, .954071E-06,
     +  .427650E-06, .132021E-06, .144613E-07, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .639683E+06, .488215E+06, .366787E+06, .275401E+06,
     +  .206684E+06, .155012E+06, .116199E+06, .870454E+05,
     +  .651704E+05, .487578E+05, .364572E+05, .272393E+05,
     +  .203395E+05, .151753E+05, .113149E+05, .842941E+04,
     +  .627545E+04, .466775E+04, .346943E+04, .257638E+04,
     +  .191181E+04, .141735E+04, .104999E+04, .777133E+03,
     +  .574768E+03, .424726E+03, .313744E+03, .230582E+03,
     +  .170138E+03, .125477E+03, .925345E+02, .682353E+02,
     +  .503324E+02, .371782E+02, .274710E+02, .203250E+02,
     +  .150675E+02, .111928E+02, .833734E+01, .622669E+01,
     +  .466727E+01, .350890E+01, .264682E+01, .200270E+01,
     +  .152013E+01, .115666E+01, .883215E+00, .674316E+00,
     +  .516586E+00, .395322E+00, .302948E+00, .232072E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .177679E+00, .135853E+00, .103700E+00, .789568E-01,
     +  .599482E-01, .453613E-01, .342011E-01, .256725E-01,
     +  .191843E-01, .142608E-01, .105396E-01, .775184E-02,
     +  .565120E-02, .408716E-02, .293209E-02, .208426E-02,
     +  .146754E-02, .102200E-02, .703709E-03, .478224E-03,
     +  .320639E-03, .211647E-03, .138452E-03, .893966E-04,
     +  .579739E-04, .391029E-04, .279068E-04, .200576E-04,
     +  .144351E-04, .103073E-04, .723097E-05, .491666E-05,
     +  .318349E-05, .190864E-05, .101789E-05, .445670E-06,
     +  .132870E-06, .146990E-07, .000000E+00, .877059E+06,
     +  .666427E+06, .498087E+06, .372038E+06, .277737E+06,
     +  .207194E+06, .154479E+06, .115091E+06, .856940E+05,
     +  .637562E+05, .474035E+05, .352164E+05, .261445E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .193928E+05, .143742E+05, .106447E+05, .787676E+04,
     +  .582302E+04, .430128E+04, .317408E+04, .234036E+04,
     +  .172388E+04, .126873E+04, .932805E+03, .685262E+03,
     +  .502911E+03, .368920E+03, .269197E+03, .197206E+03,
     +  .144383E+03, .105687E+03, .773471E+02, .566150E+02,
     +  .414932E+02, .304151E+02, .223215E+02, .164113E+02,
     +  .120897E+02, .892937E+01, .661213E+01, .491364E+01,
     +  .366235E+01, .273874E+01, .205446E+01, .154607E+01,
     +  .116641E+01, .883202E+00, .668709E+00, .508105E+00,
     +  .385700E+00, .293235E+00, .222892E+00, .169348E+00,
     +  .128515E+00, .973738E-01, .736039E-01, .554861E-01,
     +  .416918E-01, .312173E-01, .232744E-01, .172760E-01,
     +  .127582E-01, .936791E-02, .684623E-02, .495978E-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .356556E-02, .254321E-02, .179819E-02, .126005E-02,
     +  .874035E-03, .600156E-03, .407468E-03, .273669E-03,
     +  .181717E-03, .120244E-03, .791878E-04, .528679E-04,
     +  .367369E-04, .266553E-04, .194377E-04, .141482E-04,
     +  .101820E-04, .716300E-05, .486246E-05, .312623E-05,
     +  .185163E-05, .968882E-06, .412576E-06, .118819E-06,
     +  .132609E-07, .000000E+00, .117740E+07, .890818E+06,
     +  .662453E+06, .492304E+06, .365638E+06, .271358E+06,
     +  .201260E+06, .149153E+06, .110461E+06, .817387E+05,
     +  .604413E+05, .446540E+05, .329651E+05, .243136E+05,
     +  .179182E+05, .131921E+05, .970437E+04, .713141E+04,
     +  .523597E+04, .384023E+04, .281399E+04, .205974E+04,
     +  .150626E+04, .110030E+04, .803007E+03, .585393E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .426521E+03, .309061E+03, .224830E+03, .163442E+03,
     +  .118775E+03, .862889E+02, .626883E+02, .455968E+02,
     +  .331648E+02, .241487E+02, .176132E+02, .128705E+02,
     +  .942840E+01, .692419E+01, .510284E+01, .377171E+01,
     +  .279698E+01, .208071E+01, .155284E+01, .116188E+01,
     +  .872616E+00, .655361E+00, .494002E+00, .372048E+00,
     +  .280671E+00, .211725E+00, .159660E+00, .120272E+00,
     +  .904669E-01, .678956E-01, .508236E-01, .379250E-01,
     +  .282031E-01, .208864E-01, .154010E-01, .112999E-01,
     +  .824398E-02, .598709E-02, .431080E-02, .308089E-02,
     +  .218537E-02, .153737E-02, .107251E-02, .741377E-03,
     +  .507968E-03, .344816E-03, .232196E-03, .155213E-03,
     +  .103916E-03, .697087E-04, .476831E-04, .338668E-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .248497E-04, .182744E-04, .133665E-04, .963245E-05,
     +  .675542E-05, .455395E-05, .289441E-05, .168711E-05,
     +  .863526E-06, .356855E-06, .992376E-07, .111714E-07,
     +  .000000E+00, .155108E+07, .116869E+07, .864839E+06,
     +  .639541E+06, .472623E+06, .348992E+06, .257520E+06,
     +  .189864E+06, .139879E+06, .102963E+06, .757294E+05,
     +  .556473E+05, .408566E+05, .299676E+05, .219614E+05,
     +  .160775E+05, .117591E+05, .859120E+04, .627065E+04,
     +  .457170E+04, .332975E+04, .242233E+04, .176041E+04,
     +  .127785E+04, .926623E+03, .671113E+03, .485751E+03,
     +  .349590E+03, .252584E+03, .182351E+03, .131585E+03,
     +  .949137E+02, .684531E+02, .494236E+02, .356783E+02,
     +  .257811E+02, .186583E+02, .135276E+02, .983129E+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .716245E+01, .523597E+01, .383889E+01, .282378E+01,
     +  .208370E+01, .154256E+01, .114496E+01, .853110E+00,
     +  .635674E+00, .475449E+00, .355329E+00, .266034E+00,
     +  .199194E+00, .149109E+00, .111513E+00, .832804E-01,
     +  .620638E-01, .461370E-01, .341937E-01, .252573E-01,
     +  .185814E-01, .136121E-01, .992374E-02, .719443E-02,
     +  .519287E-02, .371670E-02, .264134E-02, .186374E-02,
     +  .130496E-02, .906762E-03, .624997E-03, .427616E-03,
     +  .290470E-03, .196297E-03, .132196E-03, .895623E-04,
     +  .611130E-04, .426529E-04, .307827E-04, .227502E-04,
     +  .168001E-04, .122959E-04, .883693E-05, .615672E-05,
     +  .410894E-05, .257533E-05, .147419E-05, .736888E-06,
     +  .295274E-06, .793367E-07, .900724E-08, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .200874E+07, .150742E+07, .111018E+07, .817024E+06,
     +  .600848E+06, .441495E+06, .324159E+06, .237796E+06,
     +  .174302E+06, .127641E+06, .933921E+05, .682654E+05,
     +  .498538E+05, .363700E+05, .265078E+05, .192987E+05,
     +  .140360E+05, .101967E+05, .739972E+04, .536349E+04,
     +  .388339E+04, .280821E+04, .202847E+04, .146337E+04,
     +  .105453E+04, .758897E+03, .545751E+03, .390171E+03,
     +  .280035E+03, .200809E+03, .143912E+03, .103085E+03,
     +  .738202E+02, .529172E+02, .379214E+02, .271992E+02,
     +  .195367E+02, .140568E+02, .101375E+02, .732831E+01,
     +  .531541E+01, .386661E+01, .282184E+01, .206596E+01,
     +  .151746E+01, .111757E+01, .826296E+00, .610975E+00,
     +  .453520E+00, .336400E+00, .250003E+00, .185830E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .138106E+00, .102552E+00, .760515E-01, .562858E-01,
     +  .415572E-01, .305933E-01, .224484E-01, .164077E-01,
     +  .119429E-01, .865236E-02, .623415E-02, .447296E-02,
     +  .318308E-02, .224996E-02, .157977E-02, .110139E-02,
     +  .762680E-03, .524514E-03, .358637E-03, .243998E-03,
     +  .165628E-03, .112441E-03, .770801E-04, .534151E-04,
     +  .378951E-04, .276623E-04, .205268E-04, .151726E-04,
     +  .110783E-04, .791845E-05, .546790E-05, .360576E-05,
     +  .222513E-05, .124926E-05, .609272E-06, .236665E-06,
     +  .615071E-07, .704146E-08, .000000E+00, .256090E+07,
     +  .191426E+07, .140324E+07, .102785E+07, .752296E+06,
     +  .550126E+06, .401958E+06, .293422E+06, .214007E+06,
     +  .155931E+06, .113512E+06, .825456E+05, .599690E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .435192E+05, .315493E+05, .228452E+05, .165246E+05,
     +  .119381E+05, .861488E+04, .620879E+04, .446953E+04,
     +  .321320E+04, .230727E+04, .165450E+04, .118500E+04,
     +  .847497E+03, .605638E+03, .430189E+03, .306760E+03,
     +  .218531E+03, .155568E+03, .110680E+03, .787135E+02,
     +  .560319E+02, .398682E+02, .283899E+02, .202431E+02,
     +  .144576E+02, .103487E+02, .742471E+01, .534453E+01,
     +  .385821E+01, .279423E+01, .203016E+01, .147983E+01,
     +  .108159E+01, .793700E+00, .582483E+00, .429180E+00,
     +  .316013E+00, .233155E+00, .172073E+00, .126980E+00,
     +  .936352E-01, .689610E-01, .506923E-01, .371772E-01,
     +  .271887E-01, .198206E-01, .143946E-01, .104120E-01,
     +  .749715E-02, .536948E-02, .383040E-02, .271084E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .190644E-02, .133249E-02, .925439E-03, .638999E-03,
     +  .438778E-03, .300063E-03, .204644E-03, .139641E-03,
     +  .956006E-04, .662835E-04, .465644E-04, .334644E-04,
     +  .246159E-04, .182928E-04, .135005E-04, .981189E-05,
     +  .696129E-05, .475669E-05, .309524E-05, .187869E-05,
     +  .103362E-05, .491573E-06, .185117E-06, .465962E-07,
     +  .537825E-08, .000000E+00, .382558E+05, .402822E+05,
     +  .313572E+05, .244104E+05, .190032E+05, .147944E+05,
     +  .115183E+05, .896817E+04, .698304E+04, .543771E+04,
     +  .423470E+04, .329814E+04, .256900E+04, .200130E+04,
     +  .155928E+04, .121510E+04, .947077E+03, .738345E+03,
     +  .575775E+03, .449143E+03, .350495E+03, .273636E+03,
     +  .213743E+03, .167064E+03, .130675E+03, .102301E+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .801705E+02, .626882E+02, .492634E+02, .387787E+02,
     +  .305855E+02, .241785E+02, .191643E+02, .152464E+02,
     +  .121648E+02, .974476E+01, .784051E+01, .633846E+01,
     +  .515014E+01, .420631E+01, .345470E+01, .285238E+01,
     +  .236747E+01, .197490E+01, .165523E+01, .139330E+01,
     +  .117788E+01, .997492E+00, .846752E+00, .717644E+00,
     +  .606588E+00, .509319E+00, .423233E+00, .346828E+00,
     +  .279502E+00, .221164E+00, .171783E+00, .131062E+00,
     +  .983340E-01, .726325E-01, .528524E-01, .378932E-01,
     +  .267548E-01, .186133E-01, .126865E-01, .846771E-02,
     +  .551474E-02, .348693E-02, .212517E-02, .123481E-02,
     +  .671470E-03, .329642E-03, .133433E-03, .295759E-04,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=3901,3952) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .363899E+05, .528889E+05, .412036E+05,
     +  .320942E+05, .250019E+05, .194733E+05, .151691E+05,
     +  .118140E+05, .920205E+04, .716621E+04, .558144E+04,
     +  .434629E+04, .338490E+04, .263566E+04, .205255E+04,
     +  .159816E+04, .124456E+04, .969046E+03, .754676E+03,
     +  .587670E+03, .457750E+03, .356549E+03, .277830E+03,
     +  .216517E+03, .168829E+03, .131692E+03, .102810E+03,
     +  .800382E+02, .626090E+02, .490282E+02, .384598E+02,
     +  .302200E+02, .238017E+02, .188044E+02, .148953E+02,
     +  .118378E+02, .944655E+01, .756889E+01, .609338E+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .492749E+01, .400590E+01, .327173E+01, .268535E+01,
     +  .221378E+01, .183313E+01, .152342E+01, .127109E+01,
     +  .106143E+01, .888234E+00, .741520E+00, .617311E+00,
     +  .510488E+00, .418134E+00, .338170E+00, .269526E+00,
     +  .211418E+00, .163241E+00, .124151E+00, .931369E-01,
     +  .689788E-01, .504912E-01, .365369E-01, .261392E-01,
     +  .185134E-01, .129236E-01, .889789E-02, .603694E-02,
     +  .402780E-02, .263865E-02, .169069E-02, .105604E-02,
     +  .636730E-03, .366700E-03, .194089E-03, .885834E-04,
     +  .241067E-04, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .216840E-18, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .169407E-20, .370577E-21, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .906191E+05, .712075E+05, .553271E+05, .429779E+05,
     +  .333861E+05, .259285E+05, .201371E+05, .156352E+05,
     +  .121400E+05, .942352E+04, .731497E+04, .567663E+04,
     +  .440527E+04, .341768E+04, .265153E+04, .205655E+04,
     +  .159513E+04, .123691E+04, .959189E+03, .743659E+03,
     +  .576636E+03, .447062E+03, .346682E+03, .268834E+03,
     +  .208546E+03, .161809E+03, .125634E+03, .972468E+02,
     +  .756247E+02, .588616E+02, .458839E+02, .358195E+02,
     +  .280219E+02, .219846E+02, .172888E+02, .136375E+02,
     +  .107988E+02, .858334E+01, .685330E+01, .549510E+01,
     +  .442865E+01, .358490E+01, .291566E+01, .238135E+01,
     +  .195323E+01, .160748E+01, .132796E+01, .109753E+01,
     +  .908868E+00, .750593E+00, .618121E+00, .505710E+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .410002E+00, .328495E+00, .259673E+00, .202307E+00,
     +  .155377E+00, .117723E+00, .881080E-01, .651905E-01,
     +  .477341E-01, .345990E-01, .248252E-01, .176607E-01,
     +  .124017E-01, .860402E-02, .589379E-02, .397914E-02,
     +  .264452E-02, .172385E-02, .109886E-02, .678875E-03,
     +  .402607E-03, .221788E-03, .108469E-03, .385511E-04,
     +  .709262E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .125450E+06,
     +  .982017E+05, .759696E+05, .587537E+05, .454370E+05,
     +  .351279E+05, .271562E+05, .209869E+05, .162181E+05,
     +  .125287E+05, .967795E+04, .747331E+04, .577043E+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .445405E+04, .343770E+04, .265236E+04, .204630E+04,
     +  .157819E+04, .121712E+04, .938372E+03, .723490E+03,
     +  .557686E+03, .429930E+03, .331399E+03, .255515E+03,
     +  .197024E+03, .152014E+03, .116899E+03, .903087E+02,
     +  .698179E+02, .540500E+02, .418975E+02, .325398E+02,
     +  .253411E+02, .197774E+02, .154796E+02, .121601E+02,
     +  .958691E+01, .759109E+01, .603524E+01, .482221E+01,
     +  .386947E+01, .311925E+01, .252481E+01, .205208E+01,
     +  .167325E+01, .136934E+01, .112083E+01, .919122E+00,
     +  .751495E+00, .612680E+00, .496321E+00, .398582E+00,
     +  .316544E+00, .248264E+00, .192119E+00, .146734E+00,
     +  .110691E+00, .825769E-01, .609639E-01, .445849E-01,
     +  .323092E-01, .231996E-01, .165352E-01, .116479E-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .811917E-02, .559897E-02, .381542E-02, .256841E-02,
     +  .170423E-02, .111383E-02, .713873E-03, .447586E-03,
     +  .271011E-03, .158258E-03, .874471E-04, .512569E-04,
     +  .340170E-04, .222808E-04, .142856E-04, .902616E-05,
     +  .555983E-05, .335407E-05, .195007E-05, .109326E-05,
     +  .574450E-06, .278710E-06, .118311E-06, .385281E-07,
     +  .390835E-08, .000000E+00, .174023E+06, .135626E+06,
     +  .104394E+06, .803277E+05, .618025E+05, .475329E+05,
     +  .365534E+05, .280999E+05, .215985E+05, .165951E+05,
     +  .127489E+05, .979038E+04, .751731E+04, .576970E+04,
     +  .442773E+04, .339653E+04, .260514E+04, .199736E+04,
     +  .153120E+04, .117341E+04, .899182E+03, .688836E+03,
     +  .527710E+03, .404194E+03, .309635E+03, .237198E+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .181804E+03, .138855E+03, .106538E+03, .817925E+02,
     +  .628721E+02, .483850E+02, .373018E+02, .288327E+02,
     +  .223305E+02, .173419E+02, .135151E+02, .105693E+02,
     +  .830039E+01, .654440E+01, .518512E+01, .412542E+01,
     +  .329708E+01, .264572E+01, .213160E+01, .172275E+01,
     +  .139729E+01, .113328E+01, .920788E+00, .745810E+00,
     +  .602359E+00, .483470E+00, .384826E+00, .303100E+00,
     +  .235947E+00, .181398E+00, .137778E+00, .103460E+00,
     +  .768974E-01, .566074E-01, .413100E-01, .298932E-01,
     +  .214488E-01, .152872E-01, .107776E-01, .752625E-02,
     +  .520596E-02, .356408E-02, .241524E-02, .161776E-02,
     +  .107139E-02, .699870E-03, .451021E-03, .284997E-03,
     +  .177980E-03, .110117E-03, .728571E-04, .520172E-04 /
        DATA (UPDI(I),I=4265,4316) /
     +  .373306E-04, .267859E-04, .192989E-04, .138139E-04,
     +  .979281E-05, .677180E-05, .451253E-05, .281798E-05,
     +  .159491E-05, .764646E-06, .260725E-06, .279925E-07,
     +  .000000E+00, .157065E+06, .185648E+06, .142156E+06,
     +  .108813E+06, .832766E+05, .637076E+05, .487282E+05,
     +  .372555E+05, .284785E+05, .217600E+05, .166231E+05,
     +  .126934E+05, .969062E+04, .739490E+04, .564185E+04,
     +  .430244E+04, .328036E+04, .249995E+04, .190486E+04,
     +  .145082E+04, .110486E+04, .841102E+03, .640272E+03,
     +  .487265E+03, .370845E+03, .282219E+03, .214872E+03,
     +  .162987E+03, .124194E+03, .946840E+02, .722660E+02,
     +  .552145E+02, .422551E+02, .324192E+02, .249180E+02,
     +  .192028E+02, .148485E+02, .115202E+02, .897463E+01 /
        DATA (UPDI(I),I=4317,4368) /
     +  .701874E+01, .551553E+01, .435225E+01, .344954E+01,
     +  .274503E+01, .219306E+01, .175743E+01, .141326E+01,
     +  .113627E+01, .915137E+00, .734652E+00, .588094E+00,
     +  .467915E+00, .369323E+00, .288606E+00, .223056E+00,
     +  .170397E+00, .128707E+00, .961924E-01, .712096E-01,
     +  .522448E-01, .380205E-01, .274517E-01, .196629E-01,
     +  .139976E-01, .986231E-02, .688770E-02, .476876E-02,
     +  .327137E-02, .222433E-02, .149763E-02, .999366E-03,
     +  .660134E-03, .432290E-03, .279872E-03, .181129E-03,
     +  .118100E-03, .817854E-04, .597460E-04, .439584E-04,
     +  .323869E-04, .239154E-04, .175047E-04, .126217E-04,
     +  .883591E-05, .592059E-05, .369554E-05, .207424E-05,
     +  .975515E-06, .321295E-06, .348317E-07, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .343211E+06, .264887E+06, .201615E+06, .153394E+06,
     +  .116677E+06, .887092E+05, .674270E+05, .512277E+05,
     +  .389090E+05, .295389E+05, .224186E+05, .170065E+05,
     +  .128970E+05, .977574E+04, .740757E+04, .561031E+04,
     +  .424782E+04, .321461E+04, .243201E+04, .183907E+04,
     +  .139037E+04, .105070E+04, .793880E+03, .599633E+03,
     +  .452887E+03, .341998E+03, .258352E+03, .194395E+03,
     +  .146934E+03, .111109E+03, .840984E+02, .637157E+02,
     +  .483432E+02, .367697E+02, .280125E+02, .213950E+02,
     +  .163935E+02, .126026E+02, .972679E+01, .753607E+01,
     +  .586639E+01, .458547E+01, .359988E+01, .283744E+01,
     +  .224518E+01, .178188E+01, .141903E+01, .112969E+01,
     +  .900836E+00, .715953E+00, .567433E+00, .447086E+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .349578E+00, .270780E+00, .207590E+00, .157438E+00,
     +  .118157E+00, .878137E-01, .646861E-01, .472530E-01,
     +  .342543E-01, .246466E-01, .175968E-01, .124892E-01,
     +  .877372E-02, .610971E-02, .421703E-02, .288280E-02,
     +  .195157E-02, .130651E-02, .864885E-03, .564888E-03,
     +  .363892E-03, .230207E-03, .144296E-03, .901270E-04,
     +  .588049E-04, .398846E-04, .270321E-04, .182494E-04,
     +  .123375E-04, .829247E-05, .553764E-05, .362355E-05,
     +  .229978E-05, .137579E-05, .751304E-06, .348524E-06,
     +  .114982E-06, .123663E-07, .000000E+00, .483118E+06,
     +  .370986E+06, .280721E+06, .212324E+06, .160538E+06,
     +  .121323E+06, .916556E+05, .692077E+05, .522385E+05,
     +  .394095E+05, .297198E+05, .224005E+05, .168772E+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .127088E+05, .956616E+04, .719659E+04, .541183E+04,
     +  .406741E+04, .305581E+04, .229456E+04, .172238E+04,
     +  .129224E+04, .969257E+03, .726701E+03, .544751E+03,
     +  .408250E+03, .306032E+03, .228455E+03, .171314E+03,
     +  .128508E+03, .964760E+02, .724912E+02, .545402E+02,
     +  .411321E+02, .310655E+02, .235200E+02, .178623E+02,
     +  .136094E+02, .104091E+02, .799164E+01, .616425E+01,
     +  .477421E+01, .371355E+01, .290006E+01, .227343E+01,
     +  .178746E+01, .141011E+01, .111189E+01, .878148E+00,
     +  .691167E+00, .542512E+00, .423409E+00, .328034E+00,
     +  .251895E+00, .191559E+00, .144216E+00, .107518E+00,
     +  .794322E-01, .581974E-01, .423063E-01, .305317E-01,
     +  .218787E-01, .155615E-01, .110063E-01, .770741E-02 /
        DATA (UPDI(I),I=4525,4576) /
     +  .535239E-02, .368584E-02, .251548E-02, .170135E-02,
     +  .113927E-02, .755530E-03, .495580E-03, .321742E-03,
     +  .206450E-03, .132428E-03, .856363E-04, .577749E-04,
     +  .402618E-04, .281966E-04, .197844E-04, .139245E-04,
     +  .974821E-05, .674225E-05, .454225E-05, .293439E-05,
     +  .176639E-05, .954071E-06, .427650E-06, .132021E-06,
     +  .144613E-07, .000000E+00, .666997E+06, .509715E+06,
     +  .383529E+06, .288438E+06, .216837E+06, .162921E+06,
     +  .122359E+06, .918438E+05, .689086E+05, .516705E+05,
     +  .387270E+05, .290084E+05, .217185E+05, .162505E+05,
     +  .121533E+05, .908344E+04, .678573E+04, .506602E+04,
     +  .378035E+04, .281922E+04, .210155E+04, .156567E+04,
     +  .116600E+04, .867919E+03, .645863E+03, .480441E+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .357446E+03, .264778E+03, .197019E+03, .146634E+03,
     +  .109210E+03, .813985E+02, .607406E+02, .454298E+02,
     +  .340228E+02, .255401E+02, .192295E+02, .145239E+02,
     +  .110112E+02, .837942E+01, .640607E+01, .491740E+01,
     +  .379074E+01, .293384E+01, .227919E+01, .177573E+01,
     +  .138807E+01, .108438E+01, .848450E+00, .661520E+00,
     +  .514388E+00, .397772E+00, .305428E+00, .232553E+00,
     +  .175451E+00, .131127E+00, .971083E-01, .713058E-01,
     +  .519512E-01, .375708E-01, .269836E-01, .192492E-01,
     +  .136330E-01, .960373E-02, .670015E-02, .463732E-02,
     +  .318410E-02, .216803E-02, .146407E-02, .979987E-03,
     +  .650644E-03, .428316E-03, .280035E-03, .181989E-03,
     +  .119086E-03, .791594E-04, .547684E-04, .389549E-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .279066E-04, .200576E-04, .144351E-04, .103073E-04,
     +  .723097E-05, .491666E-05, .318349E-05, .190864E-05,
     +  .101789E-05, .445670E-06, .132870E-06, .146990E-07,
     +  .000000E+00, .903982E+06, .687621E+06, .514590E+06,
     +  .384890E+06, .287746E+06, .214990E+06, .160551E+06,
     +  .119822E+06, .893796E+05, .666280E+05, .496415E+05,
     +  .369609E+05, .275043E+05, .204531E+05, .152011E+05,
     +  .112897E+05, .838004E+04, .621582E+04, .460795E+04,
     +  .341360E+04, .252751E+04, .187017E+04, .138314E+04,
     +  .102234E+04, .755365E+03, .557838E+03, .411994E+03,
     +  .302889E+03, .223681E+03, .165209E+03, .122090E+03,
     +  .902851E+02, .668347E+02, .495854E+02, .368310E+02,
     +  .274195E+02, .204715E+02, .153315E+02, .115245E+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .869502E+01, .659013E+01, .501499E+01, .383242E+01,
     +  .294028E+01, .226417E+01, .174846E+01, .135463E+01,
     +  .104871E+01, .813105E+00, .628166E+00, .484011E+00,
     +  .370935E+00, .282348E+00, .213201E+00, .159599E+00,
     +  .118417E+00, .871105E-01, .635703E-01, .460494E-01,
     +  .331241E-01, .236695E-01, .168044E-01, .118471E-01,
     +  .830959E-02, .577373E-02, .398140E-02, .272491E-02,
     +  .185055E-02, .124745E-02, .834521E-03, .554671E-03,
     +  .366443E-03, .241268E-03, .158710E-03, .105734E-03,
     +  .718974E-04, .507264E-04, .366390E-04, .266552E-04,
     +  .194377E-04, .141482E-04, .101820E-04, .716300E-05,
     +  .486246E-05, .312623E-05, .185163E-05, .968882E-06,
     +  .412576E-06, .118819E-06, .132609E-07, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .120394E+07, .911709E+06, .678721E+06, .504973E+06,
     +  .375505E+06, .279044E+06, .207247E+06, .153817E+06,
     +  .114095E+06, .845704E+05, .626480E+05, .463741E+05,
     +  .343061E+05, .253592E+05, .187336E+05, .138283E+05,
     +  .102007E+05, .751883E+04, .553845E+04, .407647E+04,
     +  .299857E+04, .220402E+04, .161909E+04, .118858E+04,
     +  .872121E+03, .639534E+03, .468966E+03, .342249E+03,
     +  .250896E+03, .183934E+03, .134903E+03, .989978E+02,
     +  .727158E+02, .535262E+02, .394416E+02, .291268E+02,
     +  .215693E+02, .160213E+02, .119434E+02, .893615E+01,
     +  .671627E+01, .506809E+01, .384032E+01, .292139E+01,
     +  .223044E+01, .170760E+01, .131152E+01, .100641E+01,
     +  .773416E+00, .592177E+00, .452237E+00, .343562E+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .259295E+00, .194206E+00, .144265E+00, .106274E+00,
     +  .776568E-01, .563194E-01, .405591E-01, .290145E-01,
     +  .206247E-01, .145700E-01, .102230E-01, .713806E-02,
     +  .493870E-02, .339253E-02, .231415E-02, .156743E-02,
     +  .105477E-02, .705343E-03, .469461E-03, .311374E-03,
     +  .206527E-03, .137495E-03, .931278E-04, .645509E-04,
     +  .462566E-04, .338023E-04, .248497E-04, .182744E-04,
     +  .133665E-04, .963245E-05, .675542E-05, .455395E-05,
     +  .289441E-05, .168711E-05, .863526E-06, .356855E-06,
     +  .992376E-07, .111714E-07, .000000E+00, .157724E+07,
     +  .118928E+07, .880876E+06, .652030E+06, .482350E+06,
     +  .356569E+06, .263423E+06, .194463E+06, .143462E+06,
     +  .105755E+06, .779054E+05, .573435E+05, .421789E+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .309988E+05, .227656E+05, .167049E+05, .122486E+05,
     +  .897330E+04, .656898E+04, .480470E+04, .351178E+04,
     +  .256462E+04, .187167E+04, .136489E+04, .994751E+03,
     +  .724466E+03, .527563E+03, .382269E+03, .278236E+03,
     +  .202504E+03, .147433E+03, .107389E+03, .782846E+02,
     +  .571867E+02, .418129E+02, .306367E+02, .225081E+02,
     +  .165855E+02, .122648E+02, .910253E+01, .678576E+01,
     +  .507875E+01, .381683E+01, .287959E+01, .218025E+01,
     +  .165517E+01, .126052E+01, .958971E+00, .730601E+00,
     +  .554525E+00, .419818E+00, .316217E+00, .236679E+00,
     +  .175858E+00, .129651E+00, .948321E-01, .688363E-01,
     +  .496118E-01, .355185E-01, .252671E-01, .178655E-01,
     +  .125569E-01, .876769E-02, .609374E-02, .419806E-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .287266E-02, .195310E-02, .131956E-02, .886659E-03,
     +  .592910E-03, .395376E-03, .263427E-03, .176105E-03,
     +  .118647E-03, .815996E-04, .574866E-04, .417054E-04,
     +  .307403E-04, .227501E-04, .168001E-04, .122959E-04,
     +  .883693E-05, .615672E-05, .410894E-05, .257533E-05,
     +  .147419E-05, .736888E-06, .295274E-06, .793367E-07,
     +  .900724E-08, .000000E+00, .203452E+07, .152772E+07,
     +  .112599E+07, .829336E+06, .610437E+06, .448965E+06,
     +  .329978E+06, .242330E+06, .177834E+06, .130394E+06,
     +  .955378E+05, .699379E+05, .511578E+05, .373869E+05,
     +  .273010E+05, .199174E+05, .145188E+05, .105735E+05,
     +  .769393E+04, .559326E+04, .406290E+04, .294851E+04,
     +  .213816E+04, .154917E+04, .112167E+04, .811459E+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .586928E+03, .422338E+03, .305269E+03, .220619E+03,
     +  .159476E+03, .115323E+03, .834516E+02, .605104E+02,
     +  .439107E+02, .319297E+02, .232781E+02, .170203E+02,
     +  .124883E+02, .919570E+01, .680114E+01, .504988E+01,
     +  .376484E+01, .281755E+01, .211600E+01, .159323E+01,
     +  .120334E+01, .907783E+00, .685770E+00, .516069E+00,
     +  .387400E+00, .289368E+00, .214826E+00, .158377E+00,
     +  .115897E+00, .841792E-01, .607013E-01, .434772E-01,
     +  .309431E-01, .218890E-01, .153941E-01, .107646E-01,
     +  .747951E-02, .517450E-02, .354962E-02, .241983E-02,
     +  .164010E-02, .110561E-02, .742088E-03, .496482E-03,
     +  .331913E-03, .222293E-03, .149852E-03, .102153E-03,
     +  .712445E-04, .508804E-04, .372677E-04, .276345E-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .205268E-04, .151726E-04, .110783E-04, .791845E-05,
     +  .546790E-05, .360576E-05, .222513E-05, .124926E-05,
     +  .609272E-06, .236665E-06, .615071E-07, .704146E-08,
     +  .000000E+00, .258632E+07, .193427E+07, .141882E+07,
     +  .103998E+07, .761750E+06, .557490E+06, .407695E+06,
     +  .297891E+06, .217490E+06, .158645E+06, .115627E+06,
     +  .841949E+05, .612549E+05, .445220E+05, .323315E+05,
     +  .234553E+05, .170007E+05, .123097E+05, .890501E+04,
     +  .643537E+04, .464653E+04, .335152E+04, .241539E+04,
     +  .173906E+04, .125115E+04, .899266E+03, .646175E+03,
     +  .461837E+03, .331570E+03, .237991E+03, .170842E+03,
     +  .122675E+03, .881407E+02, .634516E+02, .457092E+02,
     +  .329927E+02, .238741E+02, .173251E+02, .126158E+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .921885E+01, .676599E+01, .498502E+01, .368760E+01,
     +  .273813E+01, .204009E+01, .152377E+01, .114160E+01,
     +  .854128E+00, .639912E+00, .477547E+00, .355516E+00,
     +  .263388E+00, .193985E+00, .141919E+00, .103096E+00,
     +  .743646E-01, .532745E-01, .379221E-01, .268310E-01,
     +  .188739E-01, .132026E-01, .918509E-02, .635101E-02,
     +  .437385E-02, .298797E-02, .202965E-02, .137173E-02,
     +  .922965E-03, .619126E-03, .414675E-03, .278115E-03,
     +  .187350E-03, .127399E-03, .878405E-04, .620356E-04,
     +  .448025E-04, .330502E-04, .245978E-04, .182928E-04,
     +  .135005E-04, .981189E-05, .696129E-05, .475669E-05,
     +  .309524E-05, .187869E-05, .103362E-05, .491573E-06,
     +  .185117E-06, .465962E-07, .537825E-08, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .382834E+05, .401325E+05, .312273E+05, .242977E+05,
     +  .189055E+05, .147097E+05, .114449E+05, .890446E+04,
     +  .692782E+04, .538984E+04, .419322E+04, .326221E+04,
     +  .253787E+04, .197434E+04, .153594E+04, .119489E+04,
     +  .929588E+03, .723215E+03, .562688E+03, .437829E+03,
     +  .340715E+03, .265185E+03, .206443E+03, .160760E+03,
     +  .125232E+03, .976028E+02, .761151E+02, .591949E+02,
     +  .462469E+02, .361727E+02, .283323E+02, .222281E+02,
     +  .174730E+02, .137759E+02, .108829E+02, .862289E+01,
     +  .685392E+01, .546574E+01, .437281E+01, .350849E+01,
     +  .282266E+01, .227453E+01, .183400E+01, .147775E+01,
     +  .118795E+01, .951086E+00, .757586E+00, .597979E+00,
     +  .468511E+00, .363285E+00, .280069E+00, .215587E+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .167103E+00, .131736E+00, .106464E+00, .883492E-01,
     +  .748729E-01, .641685E-01, .550625E-01, .469449E-01,
     +  .395735E-01, .328975E-01, .269360E-01, .217347E-01,
     +  .172406E-01, .134595E-01, .103392E-01, .781195E-02,
     +  .580203E-02, .423232E-02, .302880E-02, .212343E-02,
     +  .145549E-02, .972828E-03, .634976E-03, .400951E-03,
     +  .244686E-03, .143603E-03, .805511E-04, .428485E-04,
     +  .213971E-04, .991090E-05, .415813E-05, .155146E-05,
     +  .493874E-06, .126436E-06, .235606E-07, .264649E-08,
     +  .116911E-09, .511630E-12, .000000E+00, .364154E+05,
     +  .527271E+05, .410633E+05, .319725E+05, .248964E+05,
     +  .193818E+05, .150897E+05, .117452E+05, .914245E+04,
     +  .711457E+04, .553671E+04, .430755E+04, .335135E+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .260663E+04, .202742E+04, .157642E+04, .122575E+04,
     +  .952791E+03, .740626E+03, .575532E+03, .447266E+03,
     +  .347498E+03, .270018E+03, .209778E+03, .163016E+03,
     +  .126678E+03, .984859E+02, .763174E+02, .593992E+02,
     +  .462580E+02, .360670E+02, .281508E+02, .220092E+02,
     +  .172476E+02, .135397E+02, .106530E+02, .840618E+01,
     +  .665035E+01, .527715E+01, .419698E+01, .334682E+01,
     +  .267221E+01, .213544E+01, .170546E+01, .136013E+01,
     +  .108122E+01, .856772E+00, .674082E+00, .528242E+00,
     +  .411081E+00, .319368E+00, .248441E+00, .194799E+00,
     +  .154839E+00, .125317E+00, .103175E+00, .860596E-01,
     +  .722011E-01, .605521E-01, .504629E-01, .416680E-01,
     +  .340027E-01, .274006E-01, .218124E-01, .171057E-01 /
        DATA (UPDI(I),I=5253,5304) /
     +  .132234E-01, .100759E-01, .756056E-02, .558368E-02,
     +  .405162E-02, .288488E-02, .200894E-02, .136464E-02,
     +  .896829E-03, .568915E-03, .340313E-03, .186614E-03,
     +  .868880E-04, .248353E-04, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .173472E-17, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .271051E-19,
     +  .338813E-20, .000000E+00, .904225E+05, .710366E+05,
     +  .551789E+05, .428494E+05, .332747E+05, .258319E+05,
     +  .200534E+05, .155627E+05, .120771E+05, .936909E+04,
     +  .726782E+04, .563582E+04, .436994E+04, .338711E+04,
     +  .262509E+04, .203369E+04, .157537E+04, .121983E+04,
     +  .944435E+03, .730921E+03, .565641E+03, .437576E+03,
     +  .338501E+03, .261780E+03, .202465E+03, .156569E+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .121119E+03, .933643E+02, .722780E+02, .559757E+02,
     +  .433932E+02, .336675E+02, .261594E+02, .203687E+02,
     +  .158832E+02, .124104E+02, .972276E+01, .763491E+01,
     +  .601222E+01, .474428E+01, .375340E+01, .297314E+01,
     +  .235732E+01, .186840E+01, .147945E+01, .116846E+01,
     +  .920818E+00, .721345E+00, .563784E+00, .438337E+00,
     +  .340808E+00, .265620E+00, .208636E+00, .165829E+00,
     +  .133755E+00, .109310E+00, .901884E-01, .746800E-01,
     +  .617626E-01, .507639E-01, .413706E-01, .333532E-01,
     +  .265801E-01, .209473E-01, .162745E-01, .124718E-01,
     +  .942577E-02, .701750E-02, .514310E-02, .370303E-02,
     +  .261513E-02, .180454E-02, .121261E-02, .785743E-03,
     +  .489018E-03, .283884E-03, .147725E-03, .608373E-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .930068E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .125243E+06, .980220E+05, .758138E+05,
     +  .586186E+05, .453199E+05, .350264E+05, .270682E+05,
     +  .209107E+05, .161521E+05, .124716E+05, .962847E+04,
     +  .743049E+04, .573338E+04, .442200E+04, .341000E+04,
     +  .262841E+04, .202561E+04, .156032E+04, .120169E+04,
     +  .925061E+03, .712008E+03, .547787E+03, .421397E+03,
     +  .324048E+03, .249183E+03, .191571E+03, .147319E+03,
     +  .112865E+03, .868342E+02, .668243E+02, .514686E+02,
     +  .396692E+02, .306132E+02, .236712E+02, .183265E+02,
     +  .142146E+02, .110525E+02, .861244E+01, .672880E+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .526754E+01, .413403E+01, .324852E+01, .255532E+01,
     +  .200984E+01, .157985E+01, .123933E+01, .970830E+00,
     +  .756678E+00, .589132E+00, .456861E+00, .354701E+00,
     +  .276244E+00, .216772E+00, .171903E+00, .138013E+00,
     +  .111972E+00, .915022E-01, .749357E-01, .612560E-01,
     +  .497693E-01, .401147E-01, .320094E-01, .252675E-01,
     +  .197411E-01, .152158E-01, .115768E-01, .869352E-02,
     +  .643664E-02, .469618E-02, .337027E-02, .237643E-02,
     +  .164136E-02, .110789E-02, .725414E-03, .460773E-03,
     +  .278295E-03, .157373E-03, .798787E-04, .340148E-04,
     +  .142879E-04, .902615E-05, .555982E-05, .335406E-05,
     +  .195006E-05, .109326E-05, .574449E-06, .278710E-06,
     +  .118310E-06, .385280E-07, .390834E-08, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .173806E+06, .135437E+06, .104231E+06, .801860E+05,
     +  .616797E+05, .474265E+05, .364613E+05, .280201E+05,
     +  .215294E+05, .165353E+05, .126972E+05, .974560E+04,
     +  .747857E+04, .573621E+04, .439879E+04, .337153E+04,
     +  .258355E+04, .197872E+04, .151512E+04, .115954E+04,
     +  .887228E+03, .678537E+03, .518839E+03, .396556E+03,
     +  .303061E+03, .231541E+03, .176937E+03, .134677E+03,
     +  .102942E+03, .786972E+02, .602053E+02, .460852E+02,
     +  .353154E+02, .271129E+02, .208380E+02, .160426E+02,
     +  .123793E+02, .957192E+01, .741986E+01, .576265E+01,
     +  .448674E+01, .349787E+01, .272999E+01, .213096E+01,
     +  .166290E+01, .129563E+01, .100869E+01, .781945E+00,
     +  .606108E+00, .468397E+00, .362704E+00, .281869E+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .220651E+00, .174375E+00, .139271E+00, .112192E+00,
     +  .908816E-01, .737032E-01, .596355E-01, .479642E-01,
     +  .382839E-01, .302684E-01, .236875E-01, .183589E-01,
     +  .140446E-01, .106121E-01, .791869E-02, .582972E-02,
     +  .423235E-02, .302517E-02, .212705E-02, .146753E-02,
     +  .991894E-03, .652989E-03, .419642E-03, .259386E-03,
     +  .153484E-03, .856049E-04, .454703E-04, .267883E-04,
     +  .192989E-04, .138139E-04, .979281E-05, .677179E-05,
     +  .451253E-05, .281798E-05, .159491E-05, .764646E-06,
     +  .260725E-06, .279925E-07, .000000E+00, .157081E+06,
     +  .185450E+06, .141985E+06, .108665E+06, .831482E+05,
     +  .635964E+05, .486318E+05, .371721E+05, .284063E+05,
     +  .216976E+05, .165691E+05, .126467E+05, .965022E+04 /
        DATA (UPDI(I),I=5565,5616) /
     +  .735999E+04, .561169E+04, .427640E+04, .325788E+04,
     +  .248056E+04, .188814E+04, .143641E+04, .109245E+04,
     +  .830413E+03, .631072E+03, .479349E+03, .364037E+03,
     +  .276365E+03, .209839E+03, .158670E+03, .120482E+03,
     +  .914915E+02, .695181E+02, .528472E+02, .402126E+02,
     +  .306529E+02, .233872E+02, .178721E+02, .136873E+02,
     +  .105027E+02, .807847E+01, .622544E+01, .480934E+01,
     +  .372036E+01, .288144E+01, .223245E+01, .172962E+01,
     +  .133851E+01, .103561E+01, .798359E+00, .615878E+00,
     +  .474045E+00, .365849E+00, .283455E+00, .221166E+00,
     +  .174061E+00, .138259E+00, .110608E+00, .888699E-01,
     +  .714321E-01, .572653E-01, .456373E-01, .361040E-01,
     +  .283044E-01, .219735E-01, .169025E-01, .128385E-01 /
        DATA (UPDI(I),I=5617,5668) /
     +  .963615E-02, .714595E-02, .523096E-02, .377825E-02,
     +  .268877E-02, .188400E-02, .129713E-02, .876550E-03,
     +  .578733E-03, .374691E-03, .235199E-03, .143300E-03,
     +  .844871E-04, .496648E-04, .323892E-04, .239154E-04,
     +  .175047E-04, .126216E-04, .883590E-05, .592058E-05,
     +  .369553E-05, .207424E-05, .975515E-06, .321295E-06,
     +  .348316E-07, .000000E+00, .342972E+06, .264679E+06,
     +  .201435E+06, .153238E+06, .116541E+06, .885922E+05,
     +  .673257E+05, .511400E+05, .388331E+05, .294733E+05,
     +  .223618E+05, .169575E+05, .128546E+05, .973914E+04,
     +  .737597E+04, .558305E+04, .422430E+04, .319434E+04,
     +  .241454E+04, .182402E+04, .137742E+04, .103956E+04,
     +  .784295E+03, .591395E+03, .445808E+03, .335916E+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .253128E+03, .189919E+03, .143090E+03, .107806E+03,
     +  .812589E+02, .612726E+02, .462383E+02, .349522E+02,
     +  .264400E+02, .200307E+02, .152056E+02, .115644E+02,
     +  .881528E+01, .673215E+01, .515387E+01, .395124E+01,
     +  .303317E+01, .232979E+01, .179002E+01, .137436E+01,
     +  .105559E+01, .808359E+00, .619935E+00, .474733E+00,
     +  .364723E+00, .281385E+00, .218550E+00, .171077E+00,
     +  .134982E+00, .107127E+00, .852920E-01, .678899E-01,
     +  .538790E-01, .425112E-01, .333025E-01, .258629E-01,
     +  .198948E-01, .151688E-01, .114216E-01, .849955E-02,
     +  .624908E-02, .453462E-02, .324547E-02, .228717E-02,
     +  .158532E-02, .107805E-02, .717752E-03, .465254E-03,
     +  .294145E-03, .178770E-03, .104061E-03, .574704E-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .309186E-04, .182514E-04, .123375E-04, .829246E-05,
     +  .553764E-05, .362354E-05, .229978E-05, .137579E-05,
     +  .751303E-06, .348524E-06, .114982E-06, .123663E-07,
     +  .000000E+00, .482866E+06, .370767E+06, .280532E+06,
     +  .212160E+06, .160396E+06, .121200E+06, .915492E+05,
     +  .691156E+05, .521589E+05, .393407E+05, .296603E+05,
     +  .223491E+05, .168328E+05, .126705E+05, .953309E+04,
     +  .716808E+04, .538726E+04, .404624E+04, .303758E+04,
     +  .227887E+04, .170888E+04, .128064E+04, .959288E+03,
     +  .718140E+03, .537401E+03, .401942E+03, .300620E+03,
     +  .223822E+03, .167339E+03, .125097E+03, .935479E+02,
     +  .699753E+02, .523758E+02, .392664E+02, .294544E+02,
     +  .221252E+02, .166508E+02, .125535E+02, .948519E+01 /
        DATA (UPDI(I),I=5773,5824) /
     +  .717998E+01, .544820E+01, .414029E+01, .315072E+01,
     +  .239960E+01, .182852E+01, .139294E+01, .106201E+01,
     +  .807771E+00, .615691E+00, .468890E+00, .358423E+00,
     +  .275193E+00, .212650E+00, .165497E+00, .129690E+00,
     +  .102121E+00, .805980E-01, .635618E-01, .499655E-01,
     +  .390524E-01, .303102E-01, .233293E-01, .177907E-01,
     +  .134520E-01, .100473E-01, .741921E-02, .541433E-02,
     +  .390116E-02, .277340E-02, .194243E-02, .133893E-02,
     +  .906410E-03, .601637E-03, .389834E-03, .247346E-03,
     +  .151974E-03, .905875E-04, .525178E-04, .307679E-04,
     +  .197860E-04, .139245E-04, .974820E-05, .674225E-05,
     +  .454224E-05, .293439E-05, .176639E-05, .954070E-06,
     +  .427650E-06, .132021E-06, .144613E-07, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .666733E+06, .509486E+06, .383330E+06, .288266E+06,
     +  .216688E+06, .162792E+06, .122247E+06, .917472E+05,
     +  .688251E+05, .515983E+05, .386647E+05, .289546E+05,
     +  .216720E+05, .162104E+05, .121188E+05, .905366E+04,
     +  .676008E+04, .504393E+04, .376135E+04, .280288E+04,
     +  .208751E+04, .155361E+04, .115565E+04, .859036E+03,
     +  .638244E+03, .473908E+03, .351847E+03, .259991E+03,
     +  .192917E+03, .143119E+03, .106196E+03, .788130E+02,
     +  .585199E+02, .435190E+02, .323761E+02, .241178E+02,
     +  .179974E+02, .134533E+02, .100778E+02, .756287E+01,
     +  .568923E+01, .428639E+01, .323419E+01, .244271E+01,
     +  .184633E+01, .139563E+01, .105630E+01, .797960E+00,
     +  .604418E+00, .457672E+00, .347985E+00, .265795E+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .204272E+00, .158021E+00, .122981E+00, .960925E-01,
     +  .752031E-01, .587845E-01, .457932E-01, .354707E-01,
     +  .272876E-01, .208233E-01, .157474E-01, .118113E-01,
     +  .875292E-02, .641479E-02, .464747E-02, .332555E-02,
     +  .234880E-02, .163524E-02, .112128E-02, .755941E-03,
     +  .500515E-03, .324419E-03, .206766E-03, .128539E-03,
     +  .784316E-04, .474519E-04, .296000E-04, .200589E-04,
     +  .144351E-04, .103073E-04, .723097E-05, .491665E-05,
     +  .318349E-05, .190864E-05, .101789E-05, .445670E-06,
     +  .132870E-06, .146990E-07, .000000E+00, .903704E+06,
     +  .687379E+06, .514381E+06, .384709E+06, .287589E+06,
     +  .214854E+06, .160434E+06, .119721E+06, .892921E+05,
     +  .665525E+05, .495763E+05, .369046E+05, .274557E+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .204113E+05, .151650E+05, .112587E+05, .835330E+04,
     +  .619282E+04, .458818E+04, .339661E+04, .251291E+04,
     +  .185765E+04, .137240E+04, .101313E+04, .747477E+03,
     +  .551083E+03, .406211E+03, .297951E+03, .219455E+03,
     +  .161593E+03, .118994E+03, .876331E+02, .645609E+02,
     +  .476328E+02, .351520E+02, .259728E+02, .192220E+02,
     +  .142494E+02, .105847E+02, .787644E+01, .587519E+01,
     +  .438939E+01, .328441E+01, .246045E+01, .184499E+01,
     +  .138398E+01, .103992E+01, .780253E+00, .587288E+00,
     +  .442100E+00, .334291E+00, .253954E+00, .194069E+00,
     +  .149204E+00, .115320E+00, .894250E-01, .694153E-01,
     +  .538003E-01, .415481E-01, .319060E-01, .243375E-01,
     +  .184191E-01, .138171E-01, .102828E-01, .756230E-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .550174E-02, .395800E-02, .281333E-02, .197462E-02,
     +  .136700E-02, .932830E-03, .626651E-03, .414200E-03,
     +  .268813E-03, .172282E-03, .108454E-03, .677016E-04,
     +  .425021E-04, .277672E-04, .194387E-04, .141482E-04,
     +  .101820E-04, .716300E-05, .486246E-05, .312623E-05,
     +  .185163E-05, .968882E-06, .412576E-06, .118819E-06,
     +  .132609E-07, .000000E+00, .120364E+07, .911455E+06,
     +  .678502E+06, .504784E+06, .375341E+06, .278902E+06,
     +  .207124E+06, .153711E+06, .114003E+06, .844913E+05,
     +  .625798E+05, .463153E+05, .342554E+05, .253155E+05,
     +  .186960E+05, .137959E+05, .101729E+05, .749489E+04,
     +  .551788E+04, .405882E+04, .298343E+04, .219104E+04,
     +  .160797E+04, .117905E+04, .863967E+03, .632558E+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .463001E+03, .337163E+03, .246549E+03, .180219E+03,
     +  .131728E+03, .962828E+02, .703925E+02, .515353E+02,
     +  .377337E+02, .276593E+02, .203056E+02, .149307E+02,
     +  .110001E+02, .811837E+01, .600587E+01, .445029E+01,
     +  .330297E+01, .245464E+01, .182633E+01, .135971E+01,
     +  .101442E+01, .755982E+00, .565439E+00, .423135E+00,
     +  .318148E+00, .240347E+00, .182607E+00, .139516E+00,
     +  .107093E+00, .824274E-01, .634770E-01, .487945E-01,
     +  .373683E-01, .284586E-01, .215305E-01, .161649E-01,
     +  .120315E-01, .888621E-02, .648708E-02, .468608E-02,
     +  .334837E-02, .236480E-02, .164999E-02, .113630E-02,
     +  .772081E-03, .517174E-03, .341565E-03, .222197E-03,
     +  .143370E-03, .914669E-04, .583696E-04, .378289E-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .255778E-04, .182752E-04, .133665E-04, .963244E-05,
     +  .675542E-05, .455394E-05, .289441E-05, .168711E-05,
     +  .863525E-06, .356855E-06, .992375E-07, .111714E-07,
     +  .000000E+00, .157694E+07, .118901E+07, .880646E+06,
     +  .651831E+06, .482178E+06, .356420E+06, .263294E+06,
     +  .194352E+06, .143366E+06, .105672E+06, .778341E+05,
     +  .572821E+05, .421260E+05, .309533E+05, .227264E+05,
     +  .166712E+05, .122196E+05, .894841E+04, .654762E+04,
     +  .478637E+04, .349608E+04, .255117E+04, .186016E+04,
     +  .135504E+04, .986332E+03, .717272E+03, .521420E+03,
     +  .377038E+03, .273772E+03, .198695E+03, .144183E+03,
     +  .104615E+03, .759155E+02, .551611E+02, .400796E+02,
     +  .291517E+02, .212336E+02, .154897E+02, .113210E+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .828835E+01, .608246E+01, .447104E+01, .329208E+01,
     +  .242750E+01, .179240E+01, .132463E+01, .981326E+00,
     +  .726443E+00, .539942E+00, .401657E+00, .300278E+00,
     +  .225564E+00, .170369E+00, .129348E+00, .986113E-01,
     +  .753441E-01, .575743E-01, .439051E-01, .333527E-01,
     +  .251969E-01, .189120E-01, .140893E-01, .104072E-01,
     +  .763014E-02, .553036E-02, .396764E-02, .281657E-02,
     +  .197712E-02, .137187E-02, .940285E-03, .636553E-03,
     +  .425504E-03, .281079E-03, .183491E-03, .119330E-03,
     +  .771968E-04, .503036E-04, .334927E-04, .232255E-04,
     +  .168006E-04, .122959E-04, .883693E-05, .615672E-05,
     +  .410894E-05, .257533E-05, .147419E-05, .736888E-06,
     +  .295274E-06, .793367E-07, .900723E-08, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .203420E+07, .152744E+07, .112575E+07, .829128E+06,
     +  .610257E+06, .448809E+06, .329844E+06, .242214E+06,
     +  .177734E+06, .130308E+06, .954634E+05, .698739E+05,
     +  .511027E+05, .373394E+05, .272601E+05, .198823E+05,
     +  .144887E+05, .105476E+05, .767177E+04, .557427E+04,
     +  .404664E+04, .293459E+04, .212626E+04, .153900E+04,
     +  .111299E+04, .804051E+03, .580611E+03, .416965E+03,
     +  .300691E+03, .216719E+03, .156154E+03, .112493E+03,
     +  .810407E+02, .584540E+02, .421559E+02, .304308E+02,
     +  .219961E+02, .159225E+02, .115470E+02, .838787E+01,
     +  .610740E+01, .445439E+01, .325447E+01, .238151E+01,
     +  .174536E+01, .128058E+01, .942161E+00, .692861E+00,
     +  .511785E+00, .378454E+00, .281312E+00, .210110E+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .157757E+00, .119019E+00, .901230E-01, .683629E-01,
     +  .518456E-01, .392303E-01, .295682E-01, .221641E-01,
     +  .165080E-01, .122060E-01, .894981E-02, .651492E-02,
     +  .468942E-02, .334216E-02, .235779E-02, .164559E-02,
     +  .113601E-02, .775352E-03, .523334E-03, .349395E-03,
     +  .231088E-03, .151552E-03, .994306E-04, .652369E-04,
     +  .433395E-04, .295073E-04, .208362E-04, .151730E-04,
     +  .110783E-04, .791845E-05, .546790E-05, .360576E-05,
     +  .222513E-05, .124926E-05, .609272E-06, .236665E-06,
     +  .615071E-07, .704146E-08, .000000E+00, .258598E+07,
     +  .193398E+07, .141857E+07, .103976E+07, .761561E+06,
     +  .557327E+06, .407555E+06, .297770E+06, .217385E+06,
     +  .158555E+06, .115550E+06, .841281E+05, .611975E+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .444726E+05, .322890E+05, .234189E+05, .169694E+05,
     +  .122829E+05, .888204E+04, .641570E+04, .462970E+04,
     +  .333714E+04, .240311E+04, .172857E+04, .124221E+04,
     +  .891646E+03, .639686E+03, .456327E+03, .326883E+03,
     +  .234006E+03, .167454E+03, .119795E+03, .856923E+02,
     +  .613685E+02, .439369E+02, .314837E+02, .225882E+02,
     +  .162285E+02, .116799E+02, .842001E+01, .608412E+01,
     +  .440370E+01, .319318E+01, .231930E+01, .168742E+01,
     +  .122933E+01, .898354E+00, .656366E+00, .481850E+00,
     +  .354217E+00, .261787E+00, .194405E+00, .145099E+00,
     +  .108781E+00, .818178E-01, .616232E-01, .463891E-01,
     +  .348364E-01, .260564E-01, .193839E-01, .143295E-01,
     +  .105179E-01, .765697E-02, .553535E-02, .395776E-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .280287E-02, .196566E-02, .136456E-02, .937642E-03,
     +  .637652E-03, .429425E-03, .286602E-03, .189983E-03,
     +  .125292E-03, .829830E-04, .552049E-04, .373166E-04,
     +  .258665E-04, .184936E-04, .135008E-04, .981188E-05,
     +  .696129E-05, .475669E-05, .309524E-05, .187869E-05,
     +  .103362E-05, .491573E-06, .185117E-06, .465962E-07,
     +  .537825E-08, .000000E+00, .398690E+04, .344368E+04,
     +  .296879E+04, .256221E+04, .221381E+04, .191498E+04,
     +  .165841E+04, .143790E+04, .124820E+04, .108482E+04,
     +  .943956E+03, .822377E+03, .717321E+03, .626440E+03,
     +  .547729E+03, .479479E+03, .420228E+03, .368730E+03,
     +  .323916E+03, .284872E+03, .250813E+03, .221067E+03,
     +  .195058E+03, .172288E+03, .152331E+03, .134818E+03 /
        DATA (UPDI(I),I=6397,6448) /
     +  .119432E+03, .105719E+03, .938284E+02, .833448E+02,
     +  .740913E+02, .659142E+02, .586803E+02, .522917E+02,
     +  .466133E+02, .415759E+02, .371023E+02, .331251E+02,
     +  .295854E+02, .264300E+02, .236184E+02, .211060E+02,
     +  .188595E+02, .168483E+02, .150460E+02, .134294E+02,
     +  .119833E+02, .106760E+02, .950804E+01, .845139E+01,
     +  .750478E+01, .665354E+01, .588832E+01, .520073E+01,
     +  .458331E+01, .402940E+01, .353306E+01, .308892E+01,
     +  .269218E+01, .233844E+01, .202374E+01, .174443E+01,
     +  .149718E+01, .127989E+01, .108755E+01, .918994E+00,
     +  .771875E+00, .644025E+00, .533460E+00, .438358E+00,
     +  .357046E+00, .287990E+00, .229744E+00, .180986E+00,
     +  .140919E+00, .107859E+00, .811193E-01, .597864E-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .430384E-01, .301353E-01, .204146E-01, .132966E-01,
     +  .822280E-02, .478380E-02, .256251E-02, .122628E-02,
     +  .498374E-03, .156436E-03, .306441E-04, .189436E-05,
     +  .000000E+00, .415003E+06, .327884E+06, .256347E+06,
     +  .200390E+06, .156701E+06, .122524E+06, .958367E+05,
     +  .749564E+05, .586500E+05, .458893E+05, .359220E+05,
     +  .281203E+05, .220250E+05, .172524E+05, .135227E+05,
     +  .106012E+05, .831711E+04, .652715E+04, .512704E+04,
     +  .402906E+04, .316963E+04, .249510E+04, .196670E+04,
     +  .155158E+04, .122602E+04, .969946E+03, .768817E+03,
     +  .608447E+03, .484274E+03, .386219E+03, .308925E+03,
     +  .247725E+03, .199357E+03, .161031E+03, .130552E+03,
     +  .106249E+03, .868869E+02, .713599E+02, .589114E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .488500E+02, .407236E+02, .340935E+02, .286785E+02,
     +  .242150E+02, .205272E+02, .174534E+02, .148937E+02,
     +  .127239E+02, .109017E+02, .934287E+01, .801936E+01,
     +  .688538E+01, .591214E+01, .507377E+01, .435079E+01,
     +  .372597E+01, .318576E+01, .271830E+01, .231389E+01,
     +  .196420E+01, .166207E+01, .140152E+01, .117695E+01,
     +  .984822E+00, .819069E+00, .677534E+00, .557027E+00,
     +  .454917E+00, .368747E+00, .296461E+00, .236143E+00,
     +  .186205E+00, .145147E+00, .111643E+00, .848175E-01,
     +  .632820E-01, .463341E-01, .332071E-01, .232035E-01,
     +  .157451E-01, .103077E-01, .647354E-02, .384376E-02,
     +  .213885E-02, .108871E-02, .491667E-03, .186315E-03,
     +  .538589E-04, .973560E-05, .631800E-06, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .100412E+07, .787990E+06, .611299E+06, .474049E+06,
     +  .367666E+06, .285050E+06, .221031E+06, .171327E+06,
     +  .132822E+06, .102933E+06, .797845E+05, .618208E+05,
     +  .479114E+05, .371198E+05, .287659E+05, .222858E+05,
     +  .172707E+05, .133812E+05, .103716E+05, .803765E+04,
     +  .623190E+04, .483164E+04, .374836E+04, .290835E+04,
     +  .225842E+04, .175433E+04, .136423E+04, .105797E+04,
     +  .824610E+03, .643425E+03, .503049E+03, .393944E+03,
     +  .309317E+03, .243601E+03, .192397E+03, .152452E+03,
     +  .121326E+03, .969465E+02, .778582E+02, .628123E+02,
     +  .509596E+02, .415392E+02, .340411E+02, .280232E+02,
     +  .231792E+02, .192472E+02, .160558E+02, .134190E+02,
     +  .112590E+02, .945594E+01, .796064E+01, .670875E+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .565777E+01, .477182E+01, .402347E+01, .338972E+01,
     +  .285235E+01, .239615E+01, .200869E+01, .167968E+01,
     +  .140039E+01, .116370E+01, .963080E+00, .794309E+00,
     +  .651093E+00, .530814E+00, .430069E+00, .346098E+00,
     +  .276388E+00, .218872E+00, .171672E+00, .133255E+00,
     +  .102214E+00, .773212E-01, .577454E-01, .423208E-01,
     +  .304131E-01, .213743E-01, .146293E-01, .971131E-02,
     +  .620879E-02, .380156E-02, .219488E-02, .118437E-02,
     +  .582304E-03, .252839E-03, .915020E-04, .251078E-04,
     +  .432447E-05, .287640E-06, .000000E+00, .193634E+07,
     +  .151009E+07, .116311E+07, .895395E+06, .689288E+06,
     +  .530348E+06, .408047E+06, .313783E+06, .241288E+06,
     +  .185442E+06, .142516E+06, .109468E+06, .840807E+05 /
        DATA (UPDI(I),I=6657,6708) /
     +  .645460E+05, .495491E+05, .380162E+05, .291680E+05,
     +  .223677E+05, .171537E+05, .131488E+05, .100800E+05,
     +  .772431E+04, .592038E+04, .453645E+04, .347723E+04,
     +  .266491E+04, .204357E+04, .156166E+04, .119900E+04,
     +  .921064E+03, .708526E+03, .545625E+03, .421020E+03,
     +  .325694E+03, .252515E+03, .196330E+03, .153239E+03,
     +  .120055E+03, .945065E+02, .747249E+02, .594143E+02,
     +  .474703E+02, .381354E+02, .307857E+02, .249795E+02,
     +  .203562E+02, .166738E+02, .136887E+02, .112885E+02,
     +  .932213E+01, .772065E+01, .640396E+01, .531770E+01,
     +  .441785E+01, .367043E+01, .304798E+01, .252866E+01,
     +  .209483E+01, .173210E+01, .142886E+01, .117534E+01,
     +  .963719E+00, .786989E+00, .640512E+00, .518036E+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .416691E+00, .333052E+00, .264372E+00, .208203E+00,
     +  .162557E+00, .125668E+00, .961126E-01, .726113E-01,
     +  .540687E-01, .397295E-01, .286265E-01, .202088E-01,
     +  .139393E-01, .935298E-02, .607883E-02, .379865E-02,
     +  .226926E-02, .127497E-02, .667574E-03, .317212E-03,
     +  .132472E-03, .457981E-04, .119282E-04, .195619E-05,
     +  .132285E-06, .000000E+00, .330067E+07, .255940E+07,
     +  .195836E+07, .149756E+07, .114500E+07, .874900E+06,
     +  .668400E+06, .510310E+06, .389539E+06, .297151E+06,
     +  .226629E+06, .172726E+06, .131614E+06, .100218E+06,
     +  .762939E+05, .580396E+05, .441432E+05, .335500E+05,
     +  .254938E+05, .193584E+05, .146970E+05, .111507E+05,
     +  .845921E+04, .641369E+04, .486281E+04, .368507E+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .279325E+04, .210878E+04, .159912E+04, .121285E+04,
     +  .920717E+03, .699441E+03, .532151E+03, .405759E+03,
     +  .309926E+03, .237311E+03, .182342E+03, .140597E+03,
     +  .108895E+03, .847029E+02, .662455E+02, .520624E+02,
     +  .411405E+02, .326738E+02, .260861E+02, .209222E+02,
     +  .168719E+02, .136396E+02, .110805E+02, .901635E+01,
     +  .736054E+01, .601986E+01, .493013E+01, .404080E+01,
     +  .331277E+01, .271523E+01, .222371E+01, .181889E+01,
     +  .148508E+01, .120988E+01, .982923E+00, .796049E+00,
     +  .642066E+00, .516156E+00, .412289E+00, .327500E+00,
     +  .258471E+00, .202560E+00, .157463E+00, .121324E+00,
     +  .925325E-01, .697976E-01, .519870E-01, .381450E-01,
     +  .276074E-01, .195790E-01, .135944E-01, .921495E-02 /
        DATA (UPDI(I),I=6813,6864) /
     +  .607017E-02, .386861E-02, .236707E-02, .138232E-02,
     +  .757525E-03, .385909E-03, .177821E-03, .717227E-04,
     +  .238280E-04, .593855E-05, .935544E-06, .631533E-07,
     +  .000000E+00, .519658E+07, .400818E+07, .304814E+07,
     +  .231646E+07, .175993E+07, .133617E+07, .101414E+07,
     +  .769151E+06, .583157E+06, .441801E+06, .334591E+06,
     +  .253196E+06, .191529E+06, .144762E+06, .109370E+06,
     +  .825608E+05, .622973E+05, .469664E+05, .353936E+05,
     +  .266489E+05, .200567E+05, .150822E+05, .113375E+05,
     +  .851568E+04, .639442E+04, .479780E+04, .359972E+04,
     +  .268883E+04, .201701E+04, .151286E+04, .113534E+04,
     +  .852371E+03, .640647E+03, .482439E+03, .363783E+03,
     +  .274911E+03, .208404E+03, .158504E+03, .121060E+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .928454E+02, .715849E+02, .554596E+02, .432003E+02,
     +  .338234E+02, .266229E+02, .210546E+02, .167451E+02,
     +  .133524E+02, .107022E+02, .859356E+01, .692446E+01,
     +  .559115E+01, .452161E+01, .366028E+01, .296429E+01,
     +  .240046E+01, .194257E+01, .157026E+01, .126714E+01,
     +  .102037E+01, .819410E+00, .655997E+00, .523006E+00,
     +  .415612E+00, .328120E+00, .257591E+00, .200896E+00,
     +  .155557E+00, .119458E+00, .909047E-01, .684583E-01,
     +  .509726E-01, .374636E-01, .271121E-01, .193464E-01,
     +  .135187E-01, .924270E-02, .616455E-02, .399208E-02,
     +  .249857E-02, .149948E-02, .857676E-03, .459499E-03,
     +  .228370E-03, .102391E-03, .400586E-04, .128641E-04,
     +  .309121E-05, .471193E-06, .310819E-07, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .808910E+07, .620364E+07, .468654E+07, .353779E+07,
     +  .266952E+07, .201279E+07, .151695E+07, .114233E+07,
     +  .859807E+06, .646608E+06, .486023E+06, .364992E+06,
     +  .273949E+06, .205423E+06, .153947E+06, .115258E+06,
     +  .862383E+05, .644601E+05, .481509E+05, .359307E+05,
     +  .267946E+05, .199607E+05, .148606E+05, .110525E+05,
     +  .821552E+04, .610036E+04, .452840E+04, .334516E+04,
     +  .248121E+04, .183967E+04, .136426E+04, .101182E+04,
     +  .750980E+03, .558314E+03, .415457E+03, .309745E+03,
     +  .231578E+03, .173664E+03, .130745E+03, .988255E+02,
     +  .750821E+02, .573147E+02, .439854E+02, .339304E+02,
     +  .263138E+02, .205057E+02, .160725E+02, .126314E+02,
     +  .998090E+01, .790175E+01, .627890E+01, .500077E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .398968E+01, .318678E+01, .254691E+01, .203569E+01,
     +  .162618E+01, .129775E+01, .103397E+01, .822129E+00,
     +  .651932E+00, .515392E+00, .405756E+00, .318407E+00,
     +  .248204E+00, .192379E+00, .148117E+00, .113206E+00,
     +  .857956E-01, .644203E-01, .478570E-01, .351412E-01,
     +  .254634E-01, .181594E-01, .127652E-01, .878197E-02,
     +  .590797E-02, .387465E-02, .246543E-02, .151478E-02,
     +  .891476E-03, .499444E-03, .261704E-03, .127005E-03,
     +  .555008E-04, .211193E-04, .658608E-05, .153558E-05,
     +  .227766E-06, .142769E-07, .000000E+00, .120614E+08,
     +  .919884E+07, .690437E+07, .517798E+07, .388123E+07,
     +  .290676E+07, .217573E+07, .162709E+07, .121606E+07,
     +  .908005E+06, .677543E+06, .505074E+06, .376242E+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .279980E+06, .208190E+06, .154638E+06, .114770E+06,
     +  .850826E+05, .630224E+05, .466266E+05, .344669E+05,
     +  .254475E+05, .187725E+05, .138318E+05, .101832E+05,
     +  .748735E+04, .550228E+04, .402228E+04, .295202E+04,
     +  .216517E+04, .158784E+04, .116431E+04, .854081E+03,
     +  .627422E+03, .461173E+03, .339542E+03, .250615E+03,
     +  .185502E+03, .137813E+03, .102775E+03, .770257E+02,
     +  .579980E+02, .438996E+02, .334003E+02, .255477E+02,
     +  .196371E+02, .151836E+02, .117718E+02, .917804E+01,
     +  .717011E+01, .562324E+01, .442091E+01, .348212E+01,
     +  .274635E+01, .216754E+01, .171108E+01, .135013E+01,
     +  .106436E+01, .837773E+00, .658126E+00, .515628E+00,
     +  .402762E+00, .313284E+00, .242902E+00, .187060E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .143226E+00, .108923E+00, .822205E-01, .615325E-01,
     +  .456152E-01, .334492E-01, .242380E-01, .173266E-01,
     +  .121854E-01, .844452E-02, .572423E-02, .379244E-02,
     +  .244797E-02, .153202E-02, .925056E-03, .534541E-03,
     +  .293734E-03, .150777E-03, .715798E-04, .305543E-04,
     +  .113371E-04, .344391E-05, .781590E-06, .112894E-06,
     +  .648892E-08, .000000E+00, .173217E+08, .131407E+08,
     +  .980165E+07, .730465E+07, .544032E+07, .404812E+07,
     +  .301014E+07, .223614E+07, .165995E+07, .123097E+07,
     +  .912134E+06, .675149E+06, .499315E+06, .368852E+06,
     +  .272232E+06, .200679E+06, .147791E+06, .108704E+06,
     +  .798739E+05, .586124E+05, .429658E+05, .314530E+05,
     +  .230011E+05, .167973E+05, .122540E+05, .892610E+04 /
        DATA (UPDI(I),I=7125,7176) /
     +  .649721E+04, .470274E+04, .341700E+04, .248067E+04,
     +  .180017E+04, .130588E+04, .947402E+03, .688187E+03,
     +  .500016E+03, .363822E+03, .265316E+03, .193991E+03,
     +  .142331E+03, .104812E+03, .775547E+02, .576496E+02,
     +  .430739E+02, .323499E+02, .244253E+02, .185331E+02,
     +  .141475E+02, .108288E+02, .833691E+01, .643165E+01,
     +  .498190E+01, .386897E+01, .301063E+01, .234617E+01,
     +  .182983E+01, .142760E+01, .111339E+01, .867635E+00,
     +  .675124E+00, .524331E+00, .406156E+00, .313677E+00,
     +  .241237E+00, .184939E+00, .140811E+00, .106589E+00,
     +  .801348E-01, .597937E-01, .442292E-01, .324030E-01,
     +  .234784E-01, .168075E-01, .118674E-01, .824113E-02,
     +  .563830E-02, .377173E-02, .246515E-02, .156910E-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .967911E-03, .575746E-03, .327560E-03, .177105E-03,
     +  .893863E-04, .416922E-04, .174736E-04, .636140E-05,
     +  .189631E-05, .422392E-06, .597649E-07, .305184E-08,
     +  .000000E+00, .240820E+08, .181765E+08, .134767E+08,
     +  .998276E+07, .738923E+07, .546414E+07, .403742E+07,
     +  .298013E+07, .219786E+07, .161915E+07, .119173E+07,
     +  .876123E+06, .643471E+06, .472013E+06, .345882E+06,
     +  .253123E+06, .185035E+06, .135075E+06, .984899E+05,
     +  .717091E+05, .521471E+05, .378643E+05, .274596E+05,
     +  .198833E+05, .143795E+05, .103813E+05, .748796E+04,
     +  .536890E+04, .386398E+04, .277795E+04, .199583E+04,
     +  .143310E+04, .102885E+04, .739410E+03, .531371E+03,
     +  .382338E+03, .275652E+03, .199222E+03, .144454E+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .105111E+03, .768418E+02, .564286E+02, .416482E+02,
     +  .308980E+02, .230446E+02, .172728E+02, .130264E+02,
     +  .985054E+01, .749371E+01, .571278E+01, .437344E+01,
     +  .335728E+01, .258265E+01, .198996E+01, .153470E+01,
     +  .118413E+01, .913413E+00, .704095E+00, .541988E+00,
     +  .416446E+00, .319171E+00, .243901E+00, .185603E+00,
     +  .140803E+00, .106081E+00, .794574E-01, .591093E-01,
     +  .436401E-01, .319386E-01, .231493E-01, .165932E-01,
     +  .117497E-01, .820527E-02, .563447E-02, .381164E-02,
     +  .252051E-02, .162814E-02, .102399E-02, .623987E-03,
     +  .366552E-03, .205894E-03, .109871E-03, .547133E-04,
     +  .251710E-04, .104036E-04, .373440E-05, .109818E-05,
     +  .241364E-06, .335732E-07, .149297E-08, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .325438E+08, .244437E+08, .180189E+08, .132695E+08,
     +  .976389E+07, .717692E+07, .527072E+07, .386652E+07,
     +  .283374E+07, .207438E+07, .151696E+07, .110794E+07,
     +  .808319E+06, .588941E+06, .428601E+06, .311473E+06,
     +  .226072E+06, .163841E+06, .118584E+06, .856925E+05,
     +  .618390E+05, .445518E+05, .320521E+05, .230202E+05,
     +  .165096E+05, .118178E+05, .845009E+04, .600425E+04,
     +  .428199E+04, .304992E+04, .217039E+04, .154332E+04,
     +  .109694E+04, .780353E+03, .554961E+03, .395080E+03,
     +  .281758E+03, .201399E+03, .144401E+03, .103886E+03,
     +  .750789E+02, .545003E+02, .397599E+02, .291557E+02,
     +  .214936E+02, .159244E+02, .118723E+02, .887524E+01,
     +  .667585E+01, .503235E+01, .381005E+01, .289294E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .220152E+01, .167828E+01, .128075E+01, .977962E+00,
     +  .746655E+00, .569728E+00, .434167E+00, .330293E+00,
     +  .250656E+00, .189678E+00, .142943E+00, .107400E+00,
     +  .801392E-01, .594523E-01, .438061E-01, .320340E-01,
     +  .232217E-01, .166710E-01, .118357E-01, .830060E-02,
     +  .574097E-02, .390401E-02, .261542E-02, .171248E-02,
     +  .109524E-02, .681936E-03, .411350E-03, .239165E-03,
     +  .132949E-03, .701989E-04, .345844E-04, .157376E-04,
     +  .643333E-05, .228335E-05, .664075E-06, .144309E-06,
     +  .197619E-07, .761031E-09, .000000E+00, .428876E+08,
     +  .320622E+08, .235032E+08, .172108E+08, .125916E+08,
     +  .920189E+07, .671817E+07, .489908E+07, .356882E+07,
     +  .259651E+07, .188698E+07, .136951E+07, .992756E+06 /
        DATA (UPDI(I),I=7385,7436) /
     +  .718622E+06, .519516E+06, .375007E+06, .270323E+06,
     +  .194549E+06, .139811E+06, .100303E+06, .718497E+05,
     +  .513759E+05, .366785E+05, .261372E+05, .185953E+05,
     +  .132019E+05, .936111E+04, .659412E+04, .466168E+04,
     +  .329081E+04, .232047E+04, .163468E+04, .115079E+04,
     +  .810720E+03, .570820E+03, .402252E+03, .283908E+03,
     +  .200807E+03, .142443E+03, .101372E+03, .724652E+02,
     +  .520271E+02, .375380E+02, .272236E+02, .198488E+02,
     +  .145447E+02, .107263E+02, .793182E+01, .590282E+01,
     +  .440263E+01, .329865E+01, .247899E+01, .186745E+01,
     +  .140945E+01, .106506E+01, .805407E+00, .609061E+00,
     +  .460378E+00, .347590E+00, .262014E+00, .197047E+00,
     +  .147782E+00, .110387E+00, .822177E-01, .608170E-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .447300E-01, .326773E-01, .236934E-01, .170308E-01,
     +  .121240E-01, .853566E-02, .593625E-02, .407153E-02,
     +  .274562E-02, .182413E-02, .118438E-02, .751139E-03,
     +  .463739E-03, .277359E-03, .159875E-03, .881021E-04,
     +  .461068E-04, .225090E-04, .101464E-04, .410734E-05,
     +  .144266E-05, .415062E-06, .891610E-07, .120238E-07,
     +  .403573E-09, .000000E+00, .552633E+08, .411280E+08,
     +  .299864E+08, .218386E+08, .158889E+08, .115466E+08,
     +  .838217E+07, .607741E+07, .440134E+07, .318330E+07,
     +  .229953E+07, .165877E+07, .119499E+07, .859587E+06,
     +  .617453E+06, .442812E+06, .317091E+06, .226675E+06,
     +  .161784E+06, .115259E+06, .819768E+05, .581936E+05,
     +  .412391E+05, .291659E+05, .205903E+05, .145031E+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .102013E+05, .712622E+04, .499562E+04, .349637E+04,
     +  .244382E+04, .170619E+04, .119013E+04, .830624E+03,
     +  .579253E+03, .404230E+03, .282481E+03, .197791E+03,
     +  .138874E+03, .978149E+02, .691965E+02, .491619E+02,
     +  .350993E+02, .251887E+02, .181736E+02, .131790E+02,
     +  .961951E+01, .704075E+01, .518721E+01, .383045E+01,
     +  .284197E+01, .211530E+01, .157846E+01, .118030E+01,
     +  .883785E+00, .662351E+00, .496482E+00, .372044E+00,
     +  .278515E+00, .208195E+00, .155288E+00, .115523E+00,
     +  .856035E-01, .632600E-01, .464310E-01, .338877E-01,
     +  .245692E-01, .176810E-01, .126150E-01, .891434E-02,
     +  .623021E-02, .430141E-02, .292892E-02, .196081E-02,
     +  .129339E-02, .833700E-03, .524899E-03, .321685E-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .190970E-03, .109243E-03, .597327E-04, .310069E-04,
     +  .150085E-04, .670379E-05, .268716E-05, .933579E-06,
     +  .265440E-06, .562964E-07, .747583E-08, .221722E-09,
     +  .000000E+00, .697817E+08, .517071E+08, .375026E+08,
     +  .271682E+08, .196606E+08, .142101E+08, .102590E+08,
     +  .739678E+07, .532657E+07, .383044E+07, .275091E+07,
     +  .197269E+07, .141263E+07, .100996E+07, .720985E+06,
     +  .513817E+06, .365586E+06, .259646E+06, .184090E+06,
     +  .130269E+06, .920165E+05, .648644E+05, .456386E+05,
     +  .320429E+05, .224534E+05, .156952E+05, .109544E+05,
     +  .759096E+04, .527843E+04, .366386E+04, .253928E+04,
     +  .175759E+04, .121518E+04, .840520E+03, .580782E+03,
     +  .401519E+03, .277925E+03, .192729E+03, .134002E+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .934543E+02, .654570E+02, .460426E+02, .325449E+02,
     +  .231236E+02, .165187E+02, .118613E+02, .857403E+01,
     +  .621520E+01, .453593E+01, .331835E+01, .243960E+01,
     +  .179960E+01, .133113E+01, .986824E+00, .732711E+00,
     +  .544615E+00, .404947E+00, .301060E+00, .223637E+00,
     +  .165908E+00, .122830E+00, .907125E-01, .667384E-01,
     +  .489740E-01, .356970E-01, .258760E-01, .186348E-01,
     +  .133215E-01, .944233E-02, .662910E-02, .460325E-02,
     +  .315773E-02, .213642E-02, .142107E-02, .931372E-03,
     +  .596442E-03, .373047E-03, .227081E-03, .133874E-03,
     +  .760288E-04, .412574E-04, .212438E-04, .101931E-04,
     +  .450937E-05, .178842E-05, .613909E-06, .172259E-06,
     +  .360212E-07, .471053E-08, .125531E-09, .000000E+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .382834E+05, .405392E+05, .315919E+05, .246246E+05,
     +  .191986E+05, .149724E+05, .116803E+05, .911558E+04,
     +  .711708E+04, .555952E+04, .434534E+04, .339859E+04,
     +  .266014E+04, .208397E+04, .163424E+04, .128303E+04,
     +  .100863E+04, .794096E+03, .626261E+03, .494853E+03,
     +  .391874E+03, .311090E+03, .247644E+03, .197749E+03,
     +  .158453E+03, .127452E+03, .102950E+03, .832996E+02,
     +  .679514E+02, .557358E+02, .459871E+02, .381843E+02,
     +  .319195E+02, .268866E+02, .228075E+02, .194995E+02,
     +  .168063E+02, .146046E+02, .127965E+02, .113037E+02,
     +  .100661E+02, .903212E+01, .816246E+01, .742523E+01,
     +  .679481E+01, .625071E+01, .577824E+01, .535990E+01,
     +  .499062E+01, .465784E+01, .435859E+01, .408637E+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .383664E+01, .360518E+01, .338803E+01, .318168E+01,
     +  .298328E+01, .279091E+01, .260347E+01, .242058E+01,
     +  .224232E+01, .206901E+01, .190108E+01, .173972E+01,
     +  .158364E+01, .143425E+01, .129188E+01, .115681E+01,
     +  .102930E+01, .909528E+00, .797647E+00, .693756E+00,
     +  .597849E+00, .509855E+00, .430494E+00, .358491E+00,
     +  .294275E+00, .237618E+00, .188250E+00, .145848E+00,
     +  .110042E+00, .804559E-01, .564532E-01, .377321E-01,
     +  .236228E-01, .135283E-01, .681008E-02, .279663E-02,
     +  .792259E-03, .905568E-04, .000000E+00, .364154E+05,
     +  .531958E+05, .414833E+05, .323489E+05, .252337E+05,
     +  .196840E+05, .153606E+05, .119879E+05, .935992E+04,
     +  .730941E+04, .571130E+04, .446397E+04, .349151E+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .273219E+04, .213992E+04, .167721E+04, .131607E+04,
     +  .103371E+04, .813132E+03, .640501E+03, .505492E+03,
     +  .399682E+03, .316799E+03, .251721E+03, .200635E+03,
     +  .160432E+03, .128784E+03, .103487E+03, .838209E+02,
     +  .682264E+02, .558518E+02, .459898E+02, .381209E+02,
     +  .318283E+02, .267615E+02, .226713E+02, .193625E+02,
     +  .166686E+02, .144691E+02, .126593E+02, .111665E+02,
     +  .992263E+01, .888103E+01, .800018E+01, .725019E+01,
     +  .660492E+01, .604732E+01, .555570E+01, .512432E+01,
     +  .473746E+01, .439171E+01, .407871E+01, .379327E+01,
     +  .353022E+01, .328542E+01, .305504E+01, .283639E+01,
     +  .262744E+01, .242712E+01, .223485E+01, .205050E+01,
     +  .187412E+01, .170580E+01, .154645E+01, .139449E+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .125106E+01, .111620E+01, .989970E+00, .872344E+00,
     +  .763293E+00, .662723E+00, .570544E+00, .486571E+00,
     +  .410505E+00, .342813E+00, .282217E+00, .228911E+00,
     +  .182549E+00, .142736E+00, .109078E+00, .811076E-01,
     +  .583871E-01, .402758E-01, .264243E-01, .162033E-01,
     +  .906405E-02, .443945E-02, .176491E-02, .483545E-03,
     +  .556762E-04, .000000E+00, .909989E+05, .715537E+05,
     +  .556422E+05, .432644E+05, .336465E+05, .261649E+05,
     +  .203517E+05, .158299E+05, .123164E+05, .958341E+04,
     +  .745978E+04, .580771E+04, .452387E+04, .352494E+04,
     +  .274851E+04, .214419E+04, .167431E+04, .130841E+04,
     +  .102375E+04, .801934E+03, .629230E+03, .494514E+03,
     +  .389495E+03, .307454E+03, .243387E+03, .193244E+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .154000E+03, .122810E+03, .987083E+02, .797141E+02,
     +  .647372E+02, .528774E+02, .434756E+02, .360059E+02,
     +  .300302E+02, .252366E+02, .213829E+02, .182636E+02,
     +  .157312E+02, .136585E+02, .119576E+02, .105469E+02,
     +  .937091E+01, .838065E+01, .754114E+01, .682195E+01,
     +  .620320E+01, .566012E+01, .518584E+01, .476244E+01,
     +  .438576E+01, .404628E+01, .373809E+01, .345547E+01,
     +  .319400E+01, .294969E+01, .271977E+01, .250214E+01,
     +  .229563E+01, .209948E+01, .191336E+01, .173712E+01,
     +  .157059E+01, .141445E+01, .126695E+01, .112902E+01,
     +  .100052E+01, .881320E+00, .771236E+00, .670087E+00,
     +  .577629E+00, .493648E+00, .417844E+00, .349794E+00,
     +  .289798E+00, .236600E+00, .190256E+00, .150355E+00 /
        DATA (UPDI(I),I=7905,7956) /
     +  .116448E+00, .881068E-01, .648098E-01, .461192E-01,
     +  .314122E-01, .203245E-01, .122697E-01, .674253E-02,
     +  .323389E-02, .125376E-02, .334435E-03, .387397E-04,
     +  .000000E+00, .125874E+06, .985877E+05, .763205E+05,
     +  .590724E+05, .457263E+05, .353903E+05, .273940E+05,
     +  .212024E+05, .164132E+05, .127054E+05, .983774E+04,
     +  .761778E+04, .590102E+04, .457202E+04, .354425E+04,
     +  .274853E+04, .213309E+04, .165648E+04, .128773E+04,
     +  .100203E+04, .780871E+03, .609392E+03, .476519E+03,
     +  .373369E+03, .293324E+03, .231088E+03, .182705E+03,
     +  .144512E+03, .115201E+03, .922638E+02, .743050E+02,
     +  .601859E+02, .490723E+02, .403059E+02, .333419E+02,
     +  .277943E+02, .233642E+02, .198017E+02, .169274E+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .145887E+02, .126801E+02, .111055E+02, .979941E+01,
     +  .870485E+01, .778120E+01, .699356E+01, .631897E+01,
     +  .572960E+01, .521721E+01, .476185E+01, .435852E+01,
     +  .399659E+01, .366946E+01, .337093E+01, .309626E+01,
     +  .284128E+01, .260312E+01, .237958E+01, .216934E+01,
     +  .197145E+01, .178539E+01, .161079E+01, .144723E+01,
     +  .129521E+01, .115282E+01, .102078E+01, .898772E+00,
     +  .786536E+00, .683734E+00, .590054E+00, .505129E+00,
     +  .428638E+00, .360186E+00, .299256E+00, .246010E+00,
     +  .199222E+00, .158841E+00, .124411E+00, .954461E-01,
     +  .714841E-01, .520088E-01, .365753E-01, .245879E-01,
     +  .156801E-01, .931104E-02, .501980E-02, .235301E-02,
     +  .886859E-03, .229261E-03, .267484E-04, .000000E+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .174492E+06, .136052E+06, .104781E+06, .806792E+05,
     +  .621212E+05, .478217E+05, .368150E+05, .283366E+05,
     +  .218127E+05, .167887E+05, .129239E+05, .994845E+04,
     +  .766003E+04, .589850E+04, .454394E+04, .350132E+04,
     +  .269961E+04, .208248E+04, .160788E+04, .124246E+04,
     +  .961351E+03, .744788E+03, .578062E+03, .449493E+03,
     +  .350389E+03, .273865E+03, .214790E+03, .168486E+03,
     +  .133204E+03, .105795E+03, .844914E+02, .678661E+02,
     +  .548748E+02, .447030E+02, .366803E+02, .303351E+02,
     +  .253028E+02, .212832E+02, .180606E+02, .154547E+02,
     +  .133402E+02, .116054E+02, .101737E+02, .897986E+01,
     +  .797714E+01, .712607E+01, .640040E+01, .576927E+01,
     +  .522296E+01, .473959E+01, .431323E+01, .393228E+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .358943E+01, .327802E+01, .299302E+01, .273009E+01,
     +  .248620E+01, .225902E+01, .204706E+01, .184918E+01,
     +  .166467E+01, .149293E+01, .133333E+01, .118616E+01,
     +  .104937E+01, .923519E+00, .808130E+00, .702797E+00,
     +  .607060E+00, .520494E+00, .442628E+00, .373051E+00,
     +  .311291E+00, .256761E+00, .209505E+00, .168337E+00,
     +  .133121E+00, .103372E+00, .785868E-01, .582893E-01,
     +  .419663E-01, .291809E-01, .193731E-01, .121846E-01,
     +  .712239E-02, .377059E-02, .172942E-02, .634823E-03,
     +  .159493E-03, .187341E-04, .000000E+00, .157081E+06,
     +  .186117E+06, .142582E+06, .109199E+06, .836257E+05,
     +  .640236E+05, .490140E+05, .375140E+05, .287121E+05,
     +  .219711E+05, .168137E+05, .128654E+05, .984574E+04 /
        DATA (UPDI(I),I=8113,8164) /
     +  .753475E+04, .576790E+04, .441599E+04, .338261E+04,
     +  .259200E+04, .198769E+04, .152532E+04, .117187E+04,
     +  .901331E+03, .694406E+03, .535904E+03, .414546E+03,
     +  .321482E+03, .250141E+03, .194618E+03, .152615E+03,
     +  .120221E+03, .952247E+02, .758618E+02, .608405E+02,
     +  .491660E+02, .400236E+02, .328448E+02, .271900E+02,
     +  .227038E+02, .191299E+02, .162579E+02, .139408E+02,
     +  .120503E+02, .104980E+02, .921019E+01, .813351E+01,
     +  .722388E+01, .645166E+01, .578299E+01, .520661E+01,
     +  .469879E+01, .425268E+01, .385573E+01, .349998E+01,
     +  .317837E+01, .288552E+01, .261695E+01, .236943E+01,
     +  .214051E+01, .192850E+01, .173207E+01, .155029E+01,
     +  .138237E+01, .122747E+01, .108569E+01, .954885E+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .835411E+00, .726669E+00, .628128E+00, .539221E+00,
     +  .459423E+00, .388180E+00, .325004E+00, .269361E+00,
     +  .220613E+00, .178707E+00, .142502E+00, .111797E+00,
     +  .860895E-01, .648708E-01, .476639E-01, .339684E-01,
     +  .233614E-01, .153224E-01, .950819E-02, .547386E-02,
     +  .284734E-02, .127895E-02, .457872E-03, .112084E-03,
     +  .132488E-04, .000000E+00, .343785E+06, .265408E+06,
     +  .202087E+06, .153822E+06, .117063E+06, .890588E+05,
     +  .677430E+05, .515131E+05, .391666E+05, .297714E+05,
     +  .226283E+05, .171955E+05, .130673E+05, .992912E+04,
     +  .754566E+04, .573456E+04, .435957E+04, .331508E+04,
     +  .252231E+04, .192018E+04, .146321E+04, .111609E+04,
     +  .852566E+03, .652283E+03, .500116E+03, .384361E+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .296338E+03, .228400E+03, .177427E+03, .138451E+03,
     +  .108625E+03, .857211E+02, .681012E+02, .545256E+02,
     +  .439819E+02, .357727E+02, .293575E+02, .243088E+02,
     +  .203164E+02, .171317E+02, .145794E+02, .125108E+02,
     +  .108224E+02, .942993E+01, .827201E+01, .729902E+01,
     +  .647716E+01, .576911E+01, .516170E+01, .462916E+01,
     +  .416350E+01, .375119E+01, .338348E+01, .305286E+01,
     +  .275361E+01, .248101E+01, .223162E+01, .200278E+01,
     +  .179257E+01, .159945E+01, .142222E+01, .125988E+01,
     +  .111136E+01, .976529E+00, .853154E+00, .741395E+00,
     +  .640508E+00, .549837E+00, .468707E+00, .396496E+00,
     +  .332569E+00, .276366E+00, .227299E+00, .184688E+00,
     +  .148390E+00, .117322E+00, .912276E-01, .695992E-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .519334E-01, .377633E-01, .266143E-01, .180863E-01,
     +  .117086E-01, .716238E-02, .405797E-02, .207293E-02,
     +  .911849E-03, .318759E-03, .762880E-04, .906915E-05,
     +  .000000E+00, .483755E+06, .371563E+06, .281243E+06,
     +  .212796E+06, .160965E+06, .121709E+06, .920036E+05,
     +  .695217E+05, .525217E+05, .396648E+05, .299498E+05,
     +  .226076E+05, .170636E+05, .128765E+05, .971692E+04,
     +  .733208E+04, .553356E+04, .417671E+04, .315391E+04,
     +  .238257E+04, .180131E+04, .136299E+04, .103266E+04,
     +  .783493E+03, .595612E+03, .453795E+03, .346798E+03,
     +  .264877E+03, .203908E+03, .157673E+03, .122579E+03,
     +  .958543E+02, .754632E+02, .598837E+02, .478810E+02,
     +  .386121E+02, .314248E+02, .258124E+02, .214060E+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .179162E+02, .151374E+02, .128997E+02, .110837E+02,
     +  .959454E+01, .836266E+01, .733286E+01, .646722E+01,
     +  .572505E+01, .509130E+01, .453829E+01, .405693E+01,
     +  .363274E+01, .325628E+01, .291962E+01, .261667E+01,
     +  .234251E+01, .209344E+01, .186663E+01, .165989E+01,
     +  .147146E+01, .129992E+01, .114405E+01, .100258E+01,
     +  .875161E+00, .759497E+00, .655556E+00, .562479E+00,
     +  .479501E+00, .405857E+00, .340847E+00, .283775E+00,
     +  .234026E+00, .190971E+00, .153910E+00, .122627E+00,
     +  .961022E-01, .740412E-01, .559419E-01, .413160E-01,
     +  .297153E-01, .206961E-01, .138859E-01, .886351E-02,
     +  .533799E-02, .297138E-02, .148733E-02, .638804E-03,
     +  .217154E-03, .505672E-04, .605375E-05, .000000E+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .667701E+06, .510352E+06, .384105E+06, .288958E+06,
     +  .217307E+06, .163344E+06, .122741E+06, .921882E+05,
     +  .692189E+05, .519499E+05, .389785E+05, .292346E+05,
     +  .219218E+05, .164332E+05, .123175E+05, .923076E+04,
     +  .691792E+04, .518456E+04, .388661E+04, .291442E+04,
     +  .218681E+04, .164199E+04, .123428E+04, .928990E+03,
     +  .700465E+03, .529251E+03, .401054E+03, .303663E+03,
     +  .231746E+03, .177640E+03, .136895E+03, .106118E+03,
     +  .828203E+02, .651631E+02, .516657E+02, .413245E+02,
     +  .333658E+02, .271972E+02, .223879E+02, .186049E+02,
     +  .156116E+02, .132157E+02, .112822E+02, .970522E+01,
     +  .840723E+01, .732747E+01, .642404E+01, .565304E+01,
     +  .499760E+01, .442826E+01, .393490E+01, .350220E+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .312003E+01, .278011E+01, .247598E+01, .220252E+01,
     +  .195579E+01, .173274E+01, .153094E+01, .134843E+01,
     +  .118356E+01, .103491E+01, .901019E+00, .781366E+00,
     +  .673589E+00, .577493E+00, .492117E+00, .416607E+00,
     +  .350127E+00, .291917E+00, .241237E+00, .197431E+00,
     +  .159846E+00, .127776E+00, .100950E+00, .784178E-01,
     +  .598596E-01, .447881E-01, .327386E-01, .232880E-01,
     +  .160278E-01, .106164E-01, .668103E-02, .396078E-02,
     +  .216586E-02, .106214E-02, .445354E-03, .147223E-03,
     +  .333702E-04, .402341E-05, .000000E+00, .904757E+06,
     +  .688322E+06, .515223E+06, .385461E+06, .288261E+06,
     +  .215454E+06, .160970E+06, .120199E+06, .897188E+05,
     +  .669331E+05, .499158E+05, .372073E+05, .277256E+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .206517E+05, .153793E+05, .114495E+05, .852321E+04,
     +  .634405E+04, .472275E+04, .351631E+04, .261935E+04,
     +  .195227E+04, .145648E+04, .108782E+04, .813816E+03,
     +  .609997E+03, .458506E+03, .344281E+03, .260568E+03,
     +  .198071E+03, .151364E+03, .116357E+03, .900595E+02,
     +  .702833E+02, .552799E+02, .438716E+02, .351549E+02,
     +  .284469E+02, .232521E+02, .191924E+02, .159994E+02,
     +  .134584E+02, .114187E+02, .976364E+01, .840785E+01,
     +  .728525E+01, .635014E+01, .555563E+01, .488310E+01,
     +  .430151E+01, .379975E+01, .336173E+01, .297675E+01,
     +  .263615E+01, .233317E+01, .206246E+01, .181985E+01,
     +  .160207E+01, .140648E+01, .123090E+01, .107347E+01,
     +  .932598E+00, .806664E+00, .694973E+00, .595134E+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .506799E+00, .428925E+00, .360588E+00, .300900E+00,
     +  .249056E+00, .204288E+00, .165915E+00, .133274E+00,
     +  .105664E+00, .827775E-01, .637329E-01, .481995E-01,
     +  .357123E-01, .258349E-01, .181746E-01, .123598E-01,
     +  .808162E-02, .501381E-02, .292575E-02, .157155E-02,
     +  .755026E-03, .309097E-03, .994103E-04, .219597E-04,
     +  .266614E-05, .000000E+00, .120479E+07, .912479E+06,
     +  .679416E+06, .505600E+06, .376069E+06, .279552E+06,
     +  .207704E+06, .154228E+06, .114465E+06, .849027E+05,
     +  .629465E+05, .466419E+05, .345464E+05, .255746E+05,
     +  .189266E+05, .140011E+05, .103554E+05, .765720E+04,
     +  .566215E+04, .418700E+04, .309727E+04, .229211E+04,
     +  .169766E+04, .125862E+04, .934528E+03, .695121E+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .518439E+03, .386186E+03, .289967E+03, .218662E+03,
     +  .165764E+03, .126413E+03, .970705E+02, .751681E+02,
     +  .586720E+02, .462193E+02, .367704E+02, .295485E+02,
     +  .239913E+02, .196753E+02, .162999E+02, .136285E+02,
     +  .114948E+02, .977203E+01, .836706E+01, .720887E+01,
     +  .624821E+01, .543544E+01, .475033E+01, .416043E+01,
     +  .365372E+01, .321343E+01, .282834E+01, .248946E+01,
     +  .218974E+01, .192361E+01, .168667E+01, .147547E+01,
     +  .128712E+01, .111928E+01, .969887E+00, .837195E+00,
     +  .719442E+00, .615783E+00, .523818E+00, .443066E+00,
     +  .372421E+00, .310907E+00, .257600E+00, .211668E+00,
     +  .172327E+00, .138885E+00, .110682E+00, .870317E-01,
     +  .676038E-01, .515878E-01, .386514E-01, .283572E-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .203011E-01, .141232E-01, .948983E-02, .612484E-02,
     +  .374570E-02, .215129E-02, .113501E-02, .534201E-03,
     +  .213547E-03, .668515E-04, .144097E-04, .176144E-05,
     +  .000000E+00, .157818E+07, .119012E+07, .881636E+06,
     +  .652715E+06, .482967E+06, .357123E+06, .263921E+06,
     +  .194911E+06, .143865E+06, .106116E+06, .782294E+05,
     +  .576340E+05, .424392E+05, .312319E+05, .229742E+05,
     +  .168914E+05, .124154E+05, .912227E+04, .670198E+04,
     +  .492336E+04, .361759E+04, .265890E+04, .195564E+04,
     +  .143961E+04, .106121E+04, .783556E+03, .580051E+03,
     +  .428785E+03, .319509E+03, .239104E+03, .179876E+03,
     +  .136134E+03, .103749E+03, .797481E+02, .617967E+02,
     +  .483391E+02, .381952E+02, .304923E+02, .246009E+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .200520E+02, .165138E+02, .137278E+02, .115131E+02,
     +  .973315E+01, .828775E+01, .710121E+01, .612104E+01,
     +  .529514E+01, .460181E+01, .400737E+01, .349898E+01,
     +  .305927E+01, .267659E+01, .234161E+01, .204705E+01,
     +  .178711E+01, .155721E+01, .135365E+01, .117341E+01,
     +  .101392E+01, .872982E+00, .748709E+00, .639226E+00,
     +  .543552E+00, .459301E+00, .385876E+00, .322128E+00,
     +  .267046E+00, .219683E+00, .179196E+00, .144800E+00,
     +  .115803E+00, .915553E-01, .713986E-01, .549890E-01,
     +  .415869E-01, .308669E-01, .224228E-01, .158849E-01,
     +  .109276E-01, .725434E-02, .462116E-02, .278562E-02,
     +  .157452E-02, .815885E-03, .376180E-03, .146858E-03,
     +  .447723E-04, .942782E-05, .116014E-05, .000000E+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .203555E+07, .152864E+07, .112682E+07, .830084E+06,
     +  .611109E+06, .449569E+06, .330521E+06, .242817E+06,
     +  .178271E+06, .130786E+06, .958889E+05, .702523E+05,
     +  .514392E+05, .376386E+05, .275259E+05, .201184E+05,
     +  .146982E+05, .107335E+05, .783663E+04, .572039E+04,
     +  .417609E+04, .304921E+04, .222769E+04, .162870E+04,
     +  .119228E+04, .874121E+03, .642476E+03, .471458E+03,
     +  .348755E+03, .259089E+03, .193491E+03, .145379E+03,
     +  .110002E+03, .839625E+02, .646162E+02, .502084E+02,
     +  .394169E+02, .312723E+02, .250790E+02, .203233E+02,
     +  .166428E+02, .137589E+02, .114766E+02, .965019E+01,
     +  .817306E+01, .696528E+01, .597150E+01, .513742E+01,
     +  .444003E+01, .384462E+01, .333761E+01, .290114E+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .252315E+01, .219406E+01, .190632E+01, .165398E+01,
     +  .143223E+01, .123722E+01, .106572E+01, .915031E+00,
     +  .782821E+00, .667073E+00, .565829E+00, .477996E+00,
     +  .401218E+00, .334801E+00, .277573E+00, .228500E+00,
     +  .186631E+00, .151122E+00, .121199E+00, .961796E-01,
     +  .754360E-01, .583408E-01, .445485E-01, .333887E-01,
     +  .245490E-01, .176565E-01, .123769E-01, .841882E-02,
     +  .552127E-02, .347117E-02, .206226E-02, .114709E-02,
     +  .583755E-03, .263665E-03, .100538E-03, .298645E-04,
     +  .615031E-05, .761758E-06, .000000E+00, .258743E+07,
     +  .193528E+07, .141973E+07, .104080E+07, .762481E+06,
     +  .558147E+06, .408285E+06, .298420E+06, .217963E+06,
     +  .159070E+06, .116007E+06, .845346E+05, .615585E+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .447932E+05, .325736E+05, .236714E+05, .171933E+05,
     +  .124813E+05, .905779E+04, .657129E+04, .476735E+04,
     +  .345883E+04, .251064E+04, .182353E+04, .132600E+04,
     +  .965560E+03, .704821E+03, .513582E+03, .377274E+03,
     +  .278325E+03, .206411E+03, .154019E+03, .115747E+03,
     +  .877611E+02, .671009E+02, .518112E+02, .404276E+02,
     +  .318861E+02, .254262E+02, .204913E+02, .166904E+02,
     +  .137255E+02, .113890E+02, .952666E+01, .802633E+01,
     +  .680423E+01, .580246E+01, .496491E+01, .426739E+01,
     +  .367436E+01, .317158E+01, .274078E+01, .236955E+01,
     +  .204809E+01, .176864E+01, .152507E+01, .131240E+01,
     +  .112662E+01, .964342E+00, .822750E+00, .699388E+00,
     +  .592149E+00, .499012E+00, .418793E+00, .349181E+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .289406E+00, .238286E+00, .194783E+00, .157953E+00,
     +  .126962E+00, .101056E+00, .795734E-01, .619126E-01,
     +  .474837E-01, .359470E-01, .266990E-01, .194448E-01,
     +  .138461E-01, .960335E-02, .645848E-02, .418412E-02,
     +  .259593E-02, .151994E-02, .831900E-03, .415754E-03,
     +  .183957E-03, .685238E-04, .198427E-04, .400074E-05,
     +  .498670E-06, .000000E+00, .382558E+05, .405075E+05,
     +  .315592E+05, .245915E+05, .191656E+05, .149400E+05,
     +  .116488E+05, .908512E+04, .708789E+04, .553171E+04,
     +  .431897E+04, .337370E+04, .263675E+04, .206205E+04,
     +  .161375E+04, .126394E+04, .990879E+03, .777632E+03,
     +  .611015E+03, .480759E+03, .378864E+03, .299097E+03,
     +  .236602E+03, .187594E+03, .149121E+03, .118884E+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .950882E+02, .760990E+02, .613500E+02, .496848E+02,
     +  .404405E+02, .330989E+02, .272546E+02, .226030E+02,
     +  .188705E+02, .158756E+02, .134643E+02, .115155E+02,
     +  .993358E+01, .864233E+01, .758369E+01, .670832E+01,
     +  .597900E+01, .536573E+01, .484463E+01, .439671E+01,
     +  .400815E+01, .366308E+01, .335605E+01, .307553E+01,
     +  .281831E+01, .257881E+01, .235402E+01, .214227E+01,
     +  .194299E+01, .175626E+01, .158234E+01, .142127E+01,
     +  .127276E+01, .113620E+01, .101082E+01, .895838E+00,
     +  .790492E+00, .694543E+00, .606422E+00, .526247E+00,
     +  .453580E+00, .388027E+00, .329215E+00, .276784E+00,
     +  .230380E+00, .189641E+00, .154178E+00, .123592E+00,
     +  .977676E-01, .759057E-01, .577877E-01, .430179E-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .312027E-01, .219555E-01, .149016E-01, .969055E-02,
     +  .595865E-02, .342962E-02, .180600E-02, .842440E-03,
     +  .329756E-03, .978510E-04, .175222E-04, .912805E-06,
     +  .000000E+00, .363899E+05, .531485E+05, .414363E+05,
     +  .323027E+05, .251887E+05, .196407E+05, .153191E+05,
     +  .119484E+05, .932249E+04, .727412E+04, .567814E+04,
     +  .443292E+04, .346252E+04, .270521E+04, .211486E+04,
     +  .165399E+04, .129458E+04, .101387E+04, .794846E+03,
     +  .623669E+03, .490017E+03, .385473E+03, .303766E+03,
     +  .239778E+03, .189699E+03, .150425E+03, .119634E+03,
     +  .951347E+02, .761887E+02, .612543E+02, .494819E+02,
     +  .401695E+02, .327996E+02, .269591E+02, .223016E+02,
     +  .185811E+02, .156042E+02, .132082E+02, .112746E+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .970222E+01, .842008E+01, .736347E+01, .648770E+01,
     +  .575386E+01, .513383E+01, .460339E+01, .414650E+01,
     +  .374364E+01, .338886E+01, .306823E+01, .277843E+01,
     +  .251279E+01, .226797E+01, .204156E+01, .183242E+01,
     +  .163977E+01, .146312E+01, .130178E+01, .115490E+01,
     +  .102143E+01, .900294E+00, .790474E+00, .690976E+00,
     +  .601412E+00, .520098E+00, .446996E+00, .381525E+00,
     +  .323176E+00, .271459E+00, .225918E+00, .186099E+00,
     +  .151577E+00, .121910E+00, .966383E-01, .755630E-01,
     +  .579546E-01, .435811E-01, .320438E-01, .229426E-01,
     +  .159253E-01, .106522E-01, .682152E-02, .412447E-02,
     +  .233135E-02, .120318E-02, .548918E-03, .209441E-03,
     +  .604383E-04, .105643E-04, .562087E-06, .000000E+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .909383E+05, .714938E+05, .555836E+05, .432077E+05,
     +  .335920E+05, .261129E+05, .203023E+05, .157832E+05,
     +  .122725E+05, .954219E+04, .742125E+04, .577180E+04,
     +  .449049E+04, .349399E+04, .271986E+04, .211773E+04,
     +  .164991E+04, .128596E+04, .100311E+04, .782985E+03,
     +  .611855E+03, .478601E+03, .374935E+03, .294144E+03,
     +  .231228E+03, .182145E+03, .143874E+03, .113589E+03,
     +  .903024E+02, .720536E+02, .577548E+02, .465131E+02,
     +  .376711E+02, .307079E+02, .251899E+02, .208093E+02,
     +  .173258E+02, .145386E+02, .123026E+02, .104944E+02,
     +  .902822E+01, .782634E+01, .683538E+01, .600938E+01,
     +  .531529E+01, .472485E+01, .421941E+01, .377673E+01,
     +  .338989E+01, .304327E+01, .273305E+01, .245175E+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .219551E+01, .196136E+01, .174762E+01, .155289E+01,
     +  .137614E+01, .121620E+01, .107183E+01, .941697E+00,
     +  .824527E+00, .719149E+00, .624416E+00, .539832E+00,
     +  .463657E+00, .395742E+00, .335422E+00, .282119E+00,
     +  .235274E+00, .194378E+00, .158928E+00, .128464E+00,
     +  .102521E+00, .806181E-01, .625204E-01, .475434E-01,
     +  .354346E-01, .258129E-01, .183053E-01, .125790E-01,
     +  .832321E-02, .526914E-02, .314591E-02, .175404E-02,
     +  .891482E-03, .399815E-03, .149560E-03, .422107E-04,
     +  .723252E-05, .391636E-06, .000000E+00, .125799E+06,
     +  .985149E+05, .762502E+05, .590049E+05, .456620E+05,
     +  .353293E+05, .273365E+05, .211484E+05, .163626E+05,
     +  .126581E+05, .979377E+04, .757697E+04, .586321E+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .453707E+04, .351200E+04, .271883E+04, .210578E+04,
     +  .163140E+04, .126473E+04, .980971E+03, .761606E+03,
     +  .591788E+03, .460446E+03, .358709E+03, .279961E+03,
     +  .218915E+03, .171623E+03, .134442E+03, .106041E+03,
     +  .839340E+02, .667294E+02, .532965E+02, .428032E+02,
     +  .345973E+02, .281391E+02, .230473E+02, .190254E+02,
     +  .158288E+02, .132807E+02, .112332E+02, .958294E+01,
     +  .823826E+01, .713591E+01, .622240E+01, .545919E+01,
     +  .481384E+01, .426480E+01, .378714E+01, .337277E+01,
     +  .300444E+01, .267768E+01, .238423E+01, .211963E+01,
     +  .188035E+01, .166412E+01, .146904E+01, .129352E+01,
     +  .113601E+01, .994919E+00, .868686E+00, .755850E+00,
     +  .655113E+00, .565204E+00, .485525E+00, .414306E+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .351299E+00, .295770E+00, .247090E+00, .204647E+00,
     +  .167893E+00, .136293E+00, .109364E+00, .866271E-01,
     +  .675934E-01, .520053E-01, .392226E-01, .289827E-01,
     +  .209214E-01, .146914E-01, .999120E-02, .653725E-02,
     +  .408922E-02, .240937E-02, .132404E-02, .662017E-03,
     +  .291460E-03, .106696E-03, .293880E-04, .493434E-05,
     +  .274730E-06, .000000E+00, .174403E+06, .135966E+06,
     +  .104699E+06, .806006E+05, .620468E+05, .477516E+05,
     +  .367492E+05, .282751E+05, .217552E+05, .167353E+05,
     +  .128744E+05, .990261E+04, .761769E+04, .585948E+04,
     +  .450802E+04, .346832E+04, .266934E+04, .205475E+04,
     +  .158251E+04, .121927E+04, .940182E+03, .725483E+03,
     +  .560472E+03, .433481E+03, .335823E+03, .260621E+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .202757E+03, .157574E+03, .123298E+03, .968061E+02,
     +  .763331E+02, .604628E+02, .481529E+02, .385958E+02,
     +  .311272E+02, .252808E+02, .206946E+02, .170746E+02,
     +  .142081E+02, .119199E+02, .100872E+02, .860308E+01,
     +  .739364E+01, .639739E+01, .556990E+01, .487442E+01,
     +  .428634E+01, .377805E+01, .334015E+01, .295384E+01,
     +  .261390E+01, .231128E+01, .204088E+01, .179864E+01,
     +  .158170E+01, .138767E+01, .121450E+01, .106025E+01,
     +  .923063E+00, .801169E+00, .692950E+00, .596998E+00,
     +  .511942E+00, .437091E+00, .370662E+00, .312319E+00,
     +  .261277E+00, .216863E+00, .178432E+00, .145406E+00,
     +  .117230E+00, .934087E-01, .734593E-01, .568937E-01,
     +  .434408E-01, .325045E-01, .238207E-01, .170466E-01 /
        DATA (UPDI(I),I=9361,9412) /
     +  .118616E-01, .798959E-02, .517413E-02, .320152E-02,
     +  .186420E-02, .101160E-02, .498949E-03, .216542E-03,
     +  .781461E-04, .213125E-04, .362088E-05, .217718E-06,
     +  .000000E+00, .157065E+06, .186016E+06, .142486E+06,
     +  .109109E+06, .835408E+05, .639440E+05, .489396E+05,
     +  .374447E+05, .286476E+05, .219113E+05, .167584E+05,
     +  .128143E+05, .979874E+04, .749154E+04, .572822E+04,
     +  .437962E+04, .334931E+04, .256155E+04, .195989E+04,
     +  .149996E+04, .114876E+04, .880302E+03, .675281E+03,
     +  .518527E+03, .398766E+03, .307162E+03, .237155E+03,
     +  .182865E+03, .141965E+03, .110577E+03, .864893E+02,
     +  .679512E+02, .536734E+02, .426686E+02, .341292E+02,
     +  .274923E+02, .223221E+02, .182695E+02, .150816E+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .125537E+02, .105418E+02, .892280E+01, .761123E+01,
     +  .653736E+01, .565056E+01, .490966E+01, .428691E+01,
     +  .375205E+01, .329428E+01, .289334E+01, .254317E+01,
     +  .223397E+01, .195998E+01, .171660E+01, .150044E+01,
     +  .130862E+01, .113868E+01, .988370E+00, .855574E+00,
     +  .738347E+00, .634944E+00, .543860E+00, .463643E+00,
     +  .393522E+00, .331712E+00, .277801E+00, .230968E+00,
     +  .190507E+00, .155748E+00, .126097E+00, .100988E+00,
     +  .799210E-01, .624155E-01, .479924E-01, .363743E-01,
     +  .270081E-01, .196343E-01, .139326E-01, .960928E-02,
     +  .641221E-02, .411134E-02, .251711E-02, .144897E-02,
     +  .776677E-03, .378027E-03, .161779E-03, .575656E-04,
     +  .155328E-04, .265271E-05, .169057E-06, .000000E+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .343661E+06, .265290E+06, .201975E+06, .153717E+06,
     +  .116965E+06, .889673E+05, .676578E+05, .514340E+05,
     +  .390934E+05, .297037E+05, .225659E+05, .171381E+05,
     +  .130145E+05, .988073E+04, .750134E+04, .569403E+04,
     +  .432255E+04, .328131E+04, .249154E+04, .189218E+04,
     +  .143775E+04, .109297E+04, .831578E+03, .633254E+03,
     +  .482873E+03, .368746E+03, .282209E+03, .215640E+03,
     +  .165892E+03, .128028E+03, .992071E+02, .772131E+02,
     +  .604123E+02, .475730E+02, .376916E+02, .300767E+02,
     +  .241922E+02, .196178E+02, .160473E+02, .132385E+02,
     +  .110193E+02, .924683E+01, .782090E+01, .666169E+01,
     +  .571088E+01, .492202E+01, .426353E+01, .370209E+01,
     +  .322515E+01, .281080E+01, .245194E+01, .213792E+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .186218E+01, .161951E+01, .140590E+01, .121797E+01,
     +  .105283E+01, .907899E+00, .780802E+00, .669429E+00,
     +  .571906E+00, .486635E+00, .412090E+00, .347419E+00,
     +  .290851E+00, .241899E+00, .199711E+00, .163555E+00,
     +  .132748E+00, .106685E+00, .847989E-01, .665934E-01,
     +  .515980E-01, .393514E-01, .295762E-01, .217693E-01,
     +  .156818E-01, .110216E-01, .752487E-02, .496750E-02,
     +  .314830E-02, .190355E-02, .108072E-02, .570432E-03,
     +  .272787E-03, .114337E-03, .396511E-04, .103436E-04,
     +  .168775E-05, .104490E-06, .000000E+00, .483609E+06,
     +  .371426E+06, .281115E+06, .212676E+06, .160853E+06,
     +  .121605E+06, .919068E+05, .694321E+05, .524390E+05,
     +  .395886E+05, .298798E+05, .225433E+05, .170047E+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .128226E+05, .966767E+04, .728715E+04, .549260E+04,
     +  .413943E+04, .312002E+04, .235178E+04, .177338E+04,
     +  .133767E+04, .100973E+04, .762744E+03, .576850E+03,
     +  .436839E+03, .331488E+03, .251083E+03, .191466E+03,
     +  .146456E+03, .112467E+03, .867422E+02, .672492E+02,
     +  .524757E+02, .411970E+02, .325767E+02, .259680E+02,
     +  .208717E+02, .169243E+02, .138427E+02, .114256E+02,
     +  .950896E+01, .797756E+01, .674119E+01, .573373E+01,
     +  .490349E+01, .421507E+01, .363221E+01, .314060E+01,
     +  .271677E+01, .235262E+01, .203664E+01, .176154E+01,
     +  .152151E+01, .131199E+01, .112915E+01, .969724E+00,
     +  .830838E+00, .709916E+00, .604710E+00, .513242E+00,
     +  .433842E+00, .364933E+00, .305594E+00, .254084E+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .209852E+00, .172031E+00, .139877E+00, .112701E+00,
     +  .898982E-01, .709109E-01, .552520E-01, .424674E-01,
     +  .321190E-01, .239348E-01, .174604E-01, .124611E-01,
     +  .867258E-02, .586046E-02, .382683E-02, .239733E-02,
     +  .143166E-02, .801997E-03, .417262E-03, .196459E-03,
     +  .809931E-04, .276214E-04, .710692E-05, .115970E-05,
     +  .759979E-07, .000000E+00, .667533E+06, .510195E+06,
     +  .383957E+06, .288821E+06, .217179E+06, .163226E+06,
     +  .122632E+06, .920874E+05, .691261E+05, .518647E+05,
     +  .389003E+05, .291630E+05, .218564E+05, .163735E+05,
     +  .122630E+05, .918116E+04, .687280E+04, .514358E+04,
     +  .384943E+04, .288071E+04, .215629E+04, .161437E+04,
     +  .120933E+04, .906451E+03, .680127E+03, .510909E+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .384528E+03, .288806E+03, .218374E+03, .165614E+03,
     +  .126080E+03, .963954E+02, .740783E+02, .572997E+02,
     +  .445904E+02, .349541E+02, .276234E+02, .220143E+02,
     +  .177018E+02, .143603E+02, .117576E+02, .970831E+01,
     +  .808169E+01, .677716E+01, .572092E+01, .485610E+01,
     +  .414362E+01, .354444E+01, .304252E+01, .261299E+01,
     +  .224672E+01, .193143E+01, .165913E+01, .142348E+01,
     +  .121940E+01, .104268E+01, .889724E+00, .757428E+00,
     +  .643046E+00, .544224E+00, .458908E+00, .385373E+00,
     +  .322008E+00, .267843E+00, .221175E+00, .181407E+00,
     +  .147667E+00, .119208E+00, .953468E-01, .754889E-01,
     +  .590911E-01, .456826E-01, .348309E-01, .261244E-01,
     +  .193016E-01, .139551E-01, .986677E-02, .680000E-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .454792E-02, .293753E-02, .181895E-02, .107291E-02,
     +  .593061E-03, .304178E-03, .141040E-03, .572204E-04,
     +  .192116E-04, .488659E-05, .800896E-06, .556174E-07,
     +  .000000E+00, .904564E+06, .688142E+06, .515056E+06,
     +  .385306E+06, .288117E+06, .215321E+06, .160847E+06,
     +  .120086E+06, .896151E+05, .668381E+05, .498289E+05,
     +  .371279E+05, .276532E+05, .205858E+05, .153192E+05,
     +  .113949E+05, .847370E+04, .629916E+04, .468209E+04,
     +  .347953E+04, .258611E+04, .192225E+04, .142941E+04,
     +  .106342E+04, .791844E+03, .590222E+03, .440726E+03,
     +  .328332E+03, .246247E+03, .185220E+03, .139835E+03,
     +  .106018E+03, .807879E+02, .619658E+02, .478170E+02,
     +  .371718E+02, .291341E+02, .230301E+02, .183710E+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .147865E+02, .120137E+02, .984496E+01, .813458E+01,
     +  .677159E+01, .567480E+01, .478236E+01, .405168E+01,
     +  .344115E+01, .293312E+01, .250140E+01, .213594E+01,
     +  .182372E+01, .155615E+01, .132637E+01, .112887E+01,
     +  .959112E+00, .813219E+00, .687910E+00, .580310E+00,
     +  .487982E+00, .408823E+00, .341071E+00, .283103E+00,
     +  .233908E+00, .191837E+00, .156256E+00, .126300E+00,
     +  .101229E+00, .803764E-01, .631623E-01, .490652E-01,
     +  .376351E-01, .284648E-01, .211719E-01, .155089E-01,
     +  .111129E-01, .778397E-02, .531212E-02, .351631E-02,
     +  .224654E-02, .137500E-02, .801094E-03, .436969E-03,
     +  .220962E-03, .100920E-03, .403068E-04, .133316E-04,
     +  .335445E-05, .551779E-06, .403871E-07, .000000E+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .120457E+07, .912274E+06, .679226E+06, .505424E+06,
     +  .375907E+06, .279403E+06, .207567E+06, .154102E+06,
     +  .114350E+06, .847973E+05, .628503E+05, .465542E+05,
     +  .344665E+05, .255020E+05, .188607E+05, .139413E+05,
     +  .103013E+05, .760820E+04, .561785E+04, .414700E+04,
     +  .306119E+04, .225959E+04, .166838E+04, .123229E+04,
     +  .910863E+03, .673866E+03, .499371E+03, .369119E+03,
     +  .274676E+03, .204973E+03, .153513E+03, .115455E+03,
     +  .872690E+02, .663992E+02, .508266E+02, .391971E+02,
     +  .304796E+02, .239072E+02, .189253E+02, .151189E+02,
     +  .121935E+02, .992018E+01, .813831E+01, .672703E+01,
     +  .559808E+01, .468495E+01, .394182E+01, .332473E+01,
     +  .281452E+01, .238388E+01, .202188E+01, .171487E+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .145367E+01, .123102E+01, .104104E+01, .878903E+00,
     +  .740519E+00, .622464E+00, .521772E+00, .435956E+00,
     +  .362880E+00, .300769E+00, .247998E+00, .203535E+00,
     +  .165790E+00, .134106E+00, .107635E+00, .856519E-01,
     +  .675119E-01, .526573E-01, .405925E-01, .308924E-01,
     +  .231772E-01, .170952E-01, .124155E-01, .881662E-02,
     +  .611788E-02, .413421E-02, .270844E-02, .171159E-02,
     +  .103549E-02, .595898E-03, .320772E-03, .159939E-03,
     +  .719714E-04, .283086E-04, .922940E-05, .229844E-05,
     +  .379030E-06, .290988E-07, .000000E+00, .157793E+07,
     +  .118989E+07, .881423E+06, .652518E+06, .482786E+06,
     +  .356957E+06, .263769E+06, .194771E+06, .143737E+06,
     +  .105999E+06, .781232E+05, .575374E+05, .423515E+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .311523E+05, .229021E+05, .168261E+05, .123563E+05,
     +  .906893E+04, .665385E+04, .487998E+04, .357854E+04,
     +  .262377E+04, .192407E+04, .141128E+04, .103580E+04,
     +  .760778E+03, .559659E+03, .410574E+03, .303231E+03,
     +  .224565E+03, .166898E+03, .124555E+03, .934197E+02,
     +  .705322E+02, .535755E+02, .410028E+02, .316441E+02,
     +  .246371E+02, .193613E+02, .153568E+02, .122983E+02,
     +  .993626E+01, .809573E+01, .664648E+01, .549375E+01,
     +  .456671E+01, .381664E+01, .319752E+01, .268879E+01,
     +  .226221E+01, .190603E+01, .160606E+01, .135266E+01,
     +  .113819E+01, .956461E+00, .802433E+00, .671856E+00,
     +  .561202E+00, .467447E+00, .388075E+00, .320945E+00,
     +  .264278E+00, .216468E+00, .176472E+00, .142767E+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .114684E+00, .913993E-01, .722111E-01, .565019E-01,
     +  .437406E-01, .334609E-01, .252652E-01, .188026E-01,
     +  .137526E-01, .990219E-02, .696875E-02, .479034E-02,
     +  .320535E-02, .207828E-02, .129907E-02, .776851E-03,
     +  .441597E-03, .234605E-03, .115357E-03, .511562E-04,
     +  .198237E-04, .637445E-05, .157184E-05, .259608E-06,
     +  .208176E-07, .000000E+00, .203526E+07, .152838E+07,
     +  .112658E+07, .829864E+06, .610907E+06, .449384E+06,
     +  .330352E+06, .242662E+06, .178130E+06, .130658E+06,
     +  .957721E+05, .701464E+05, .513431E+05, .375515E+05,
     +  .274472E+05, .200472E+05, .146340E+05, .106756E+05,
     +  .778447E+04, .567348E+04, .413392E+04, .301136E+04,
     +  .219374E+04, .159829E+04, .116506E+04, .849776E+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .620729E+03, .452081E+03, .331475E+03, .243692E+03,
     +  .179780E+03, .133179E+03, .991480E+02, .743061E+02,
     +  .560276E+02, .425682E+02, .326165E+02, .252151E+02,
     +  .196781E+02, .155015E+02, .123308E+02, .989644E+01,
     +  .801024E+01, .653331E+01, .536497E+01, .443055E+01,
     +  .367875E+01, .306178E+01, .255787E+01, .213800E+01,
     +  .178971E+01, .149837E+01, .125394E+01, .104848E+01,
     +  .875562E+00, .729986E+00, .607387E+00, .504173E+00,
     +  .417296E+00, .344233E+00, .282854E+00, .231395E+00,
     +  .188280E+00, .152467E+00, .122506E+00, .977269E-01,
     +  .773366E-01, .606625E-01, .471183E-01, .362034E-01,
     +  .274829E-01, .205882E-01, .151982E-01, .110231E-01,
     +  .786859E-02, .548776E-02, .373689E-02, .247588E-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .158875E-02, .982273E-03, .580633E-03, .326037E-03,
     +  .170963E-03, .829128E-04, .362437E-04, .138427E-04,
     +  .439253E-05, .107283E-05, .177311E-06, .147974E-07,
     +  .000000E+00, .258712E+07, .193498E+07, .141946E+07,
     +  .104055E+07, .762257E+06, .557942E+06, .408098E+06,
     +  .298249E+06, .217808E+06, .158929E+06, .115879E+06,
     +  .844185E+05, .614535E+05, .446983E+05, .324879E+05,
     +  .235941E+05, .171237E+05, .124186E+05, .900143E+04,
     +  .652067E+04, .472195E+04, .341815E+04, .247423E+04,
     +  .179097E+04, .129692E+04, .939608E+03, .681689E+03,
     +  .493019E+03, .358979E+03, .262064E+03, .191968E+03,
     +  .141201E+03, .104375E+03, .776726E+02, .581553E+02,
     +  .438786E+02, .333906E+02, .256400E+02, .198771E+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .155563E+02, .122948E+02, .980471E+01, .788572E+01,
     +  .639113E+01, .521502E+01, .427936E+01, .353066E+01,
     +  .291968E+01, .242357E+01, .201275E+01, .167413E+01,
     +  .139274E+01, .115821E+01, .962392E+00, .798682E+00,
     +  .661759E+00, .547196E+00, .451371E+00, .371237E+00,
     +  .304288E+00, .248421E+00, .201902E+00, .163194E+00,
     +  .131269E+00, .104754E+00, .829862E-01, .652086E-01,
     +  .507818E-01, .391545E-01, .298589E-01, .224927E-01,
     +  .167171E-01, .122406E-01, .880346E-02, .622994E-02,
     +  .430573E-02, .290441E-02, .190538E-02, .121004E-02,
     +  .739992E-03, .432386E-03, .239847E-03, .124146E-03,
     +  .593928E-04, .255987E-04, .964001E-05, .302012E-05,
     +  .730798E-06, .120771E-06, .104557E-07, .000000E+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
