/*            Copyright (C) 1999, 2000, 2001, 2002 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/


#include <stdio.h>
#include <stdlib.h>

#include "util/io.h"
#include "util/err.h"


void report_xf
(  mcxIO* xf
)
   {  mcxTell
      (  "xf counters"
      ,  "xbc <%ld> xlc <%ld> xlo <%ld> xlo_ <%ld>"
      ,  (long) xf->bc
      ,  (long) mcxIOlc(xf)
      ,  (long) xf->lo
      ,  (long) xf->lo_
      )
;  }


int main
(  int   argc
,  char* argv[]
)
   {  mcxIO* xf = mcxIOnew(argc > 2 ? argv[2] : "-", "r")
   ;  int mode = argc > 1 ? atoi(argv[1]) : 0
   ;  int c
   ;  mcxTing* line = mcxTingEmpty(NULL, 160)
   ;  char buf[4096]

   ;  mcxIOopen(xf, EXIT_ON_FAIL)

   ;  if (!mode)
      fprintf
      (  stderr,
"Usage: read <mode> <fname>\n"
"mode  1    fgetc\n"
"mode  2    mcxIOstep\n"
"mode  3    mcxIOreadLine\n"
"mode  4    mcxIOreadFile\n"
"mode  5    read\n"
      )
   ,  exit(0)

   ;  if (mode == 1)
      while ((c = fgetc(xf->fp)) != EOF)
      ;

   ;  if (mode == 2)
      {  while ((c = mcxIOstep(xf)) != EOF)
         fprintf(stderr, "[%c-%ld]", c, mcxIOlc(xf))
      ;  report_xf(xf)
   ;  }

      if (mode == 3)
      {  long lc = 0
      ;  mcxstatus status
      ;  while
         (  STATUS_OK
         == (status = mcxIOreadLine(xf, line, MCX_READLINE_DEFAULT))
         )
         {  if (line->len)
            lc++
         ;  mcxTell(NULL, "<%s>", line->str)
      ;  }

         mcxTell
         (  NULL
         ,  "last line [?] <%s>\n"
            "line count <%ld>"
         ,  line->str
         ,  lc
         )
      ;  report_xf(xf)
   ;  }

      if (mode == 4)
         mcxIOreadFile(xf, line)
      ,  mcxTell(NULL, "string size <%ld>", (long) line->len)
      ,  report_xf(xf)

   ;  if (mode == 5)
      while (read(fileno(xf->fp), buf, 4096) > 0)
      ;

   ;  return 0
;  }


