/*            Copyright (C) 2002, 2003 Stijn van Dongen
 *
 * You can redistribute and/or modify this file under the terms of the GNU
 * General Public License; either version 2 of the License or (at your option)
 * any later version.  You should have received a copy of the GPL along with
 * this file, in the file COPYING.
*/


#include <stdio.h>
#include <math.h>

#include "util/ting.h"
#include "util/ding.h"
#include "util/alloc.h"
#include "util/minmax.h"
#include "util/err.h"
#include "util/types.h"
#include "util/ding.h"
#include "util/let.h"


int main
(  int   argc
,  char* argv[]
)
   {  long ival
   ;  double fval
   ;  int flags
   ;  int debug = argc > 2
   ;  telRaam *raam

   ;  if (argc <= 1)
      exit(1)

   ;  raam = trmInit(argv[argc-1])

   ;  if (trmParse(raam))
      {  mcxErr("main", "parse error")
      ;  trmExit(raam)
      ;  exit(1)
   ;  }

      if (debug)
      trmDump(raam, "after parse")

   ;  flags = trmEval(raam, &ival, &fval)

   ;  if (debug)
      trmDump(raam, "after eval")

   ;  if (flags < 0)
      printf ("evaluation error occurred\n")
   ;  else if (trmIsNan(flags))
      printf ("arithmetic exception\n")
   ;  else if (trmIsNum(flags))
      printf ("integer result <%ld>\n", ival)
   ;  else
      printf ("genuine result <%.*f>\n", (int) (15-log10(fval)), fval)

   ;  if (trmExit(raam))
      mcxErr("main", "unexpected free error")
   ;  return 0
;  }



