# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class WebGLObject(Object):
    r"""
    WebGLObject - WebGLObject represent and manipulate an web_gl
    object and its data.
    
    Superclass: Object
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkWebGLObject, obj, update, **traits)
    
    id = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetId,
                        self.id)

    layer = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _layer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLayer,
                        self.layer)

    renderer_id = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _renderer_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRendererId,
                        self.renderer_id)

    def get_binary_data(self, *args):
        """
        get_binary_data(self, part:int) -> Pointer
        C++: virtual unsigned char *get_binary_data(int part)
        get_binary_data(self, part:int, buffer:UnsignedCharArray) -> None
        C++: void get_binary_data(int part, UnsignedCharArray *buffer)"""
        my_args = deref_array(args, [['int'], ('int', 'vtkUnsignedCharArray')])
        ret = self._wrap_call(self._vtk_obj.GetBinaryData, *my_args)
        return ret

    def get_binary_size(self, *args):
        """
        get_binary_size(self, part:int) -> int
        C++: virtual int get_binary_size(int part)"""
        ret = self._wrap_call(self._vtk_obj.GetBinarySize, *args)
        return ret

    def _get_md5(self):
        return self._vtk_obj.GetMD5()
    md5 = traits.Property(_get_md5, desc=\
        r"""
        
        """
    )

    def _get_number_of_parts(self):
        return self._vtk_obj.GetNumberOfParts()
    number_of_parts = traits.Property(_get_number_of_parts, desc=\
        r"""
        
        """
    )

    def generate_binary_data(self):
        """
        generate_binary_data(self) -> None
        C++: virtual void generate_binary_data()"""
        ret = self._vtk_obj.GenerateBinaryData()
        return ret
        

    def has_changed(self):
        """
        has_changed(self) -> bool
        C++: bool has_changed()"""
        ret = self._vtk_obj.HasChanged()
        return ret
        

    def has_transparency(self):
        """
        has_transparency(self) -> bool
        C++: bool has_transparency()"""
        ret = self._vtk_obj.HasTransparency()
        return ret
        

    def interact_at_server(self):
        """
        interact_at_server(self) -> bool
        C++: bool interact_at_server()"""
        ret = self._vtk_obj.InteractAtServer()
        return ret
        

    def set_has_transparency(self, *args):
        """
        set_has_transparency(self, t:bool) -> None
        C++: void set_has_transparency(bool t)"""
        ret = self._wrap_call(self._vtk_obj.SetHasTransparency, *args)
        return ret

    def set_interact_at_server(self, *args):
        """
        set_interact_at_server(self, i:bool) -> None
        C++: void set_interact_at_server(bool i)"""
        ret = self._wrap_call(self._vtk_obj.SetInteractAtServer, *args)
        return ret

    def set_is_widget(self, *args):
        """
        set_is_widget(self, w:bool) -> None
        C++: void set_is_widget(bool w)"""
        ret = self._wrap_call(self._vtk_obj.SetIsWidget, *args)
        return ret

    def set_transformation_matrix(self, *args):
        """
        set_transformation_matrix(self, m:Matrix4x4) -> None
        C++: void set_transformation_matrix(Matrix4x4 *m)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTransformationMatrix, *my_args)
        return ret

    def set_type(self, *args):
        """
        set_type(self, t:WebGLObjectTypes) -> None
        C++: void set_type(WebGLObjectTypes t)"""
        ret = self._wrap_call(self._vtk_obj.SetType, *args)
        return ret

    def set_visibility(self, *args):
        """
        set_visibility(self, vis:bool) -> None
        C++: void set_visibility(bool vis)"""
        ret = self._wrap_call(self._vtk_obj.SetVisibility, *args)
        return ret

    def set_wireframe_mode(self, *args):
        """
        set_wireframe_mode(self, wireframe:bool) -> None
        C++: void set_wireframe_mode(bool wireframe)"""
        ret = self._wrap_call(self._vtk_obj.SetWireframeMode, *args)
        return ret

    def is_visible(self):
        """
        is_visible(self) -> bool
        C++: bool is_visible()"""
        ret = self._vtk_obj.isVisible()
        return ret
        

    def is_widget(self):
        """
        is_widget(self) -> bool
        C++: bool is_widget()"""
        ret = self._vtk_obj.isWidget()
        return ret
        

    def is_wireframe_mode(self):
        """
        is_wireframe_mode(self) -> bool
        C++: bool is_wireframe_mode()"""
        ret = self._vtk_obj.isWireframeMode()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('id', 'GetId'), ('layer', 'GetLayer'),
    ('renderer_id', 'GetRendererId'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'id', 'layer', 'renderer_id'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(WebGLObject, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit WebGLObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['id', 'layer', 'renderer_id']),
            title='Edit WebGLObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit WebGLObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

