# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.partitioned_data_set_algorithm import PartitionedDataSetAlgorithm


class PartitionedDataSetSource(PartitionedDataSetAlgorithm):
    r"""
    PartitionedDataSetSource - a source that produces a
    PartitionedDataSet.
    
    Superclass: PartitionedDataSetAlgorithm
    
    PartitionedDataSetSource generates a PartitionedDataSet which
    is composed of partitions of a given ParametricFunction. The
    resulting partitioned dataset is split among ranks in an even fashion
    by default.
    
    The user can pass the parametric function to be used using
    set_parametric_function. Otherwise it will default to
    ParametricKlein as its Parametric function.
    
    The partitioning scheme for the produced PartitionedDataSet can be
    controlled with the methods: set_number_of_partitiones, enable_rank,
    disable_rank, enable_all_ranks, disable_all_ranks.
    
    @see ParametricFunction@see PartitionedDataSet
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPartitionedDataSetSource, obj, update, **traits)
    
    number_of_partitions = traits.Trait(0, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the number of partitions of the resulting
        partitioned_data_set. If not specified, the number of partitions
        will be the number of enabled ranks.
        
        set_number_of_partitions(0) means auto in this context, the
        implementation will decided the optimal number of partitions
        which by default will be one partition per each rank.
        """
    )

    def _number_of_partitions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfPartitions,
                        self.number_of_partitions)

    def _get_parametric_function(self):
        return wrap_vtk(self._vtk_obj.GetParametricFunction())
    def _set_parametric_function(self, arg):
        old_val = self._get_parametric_function()
        self._wrap_call(self._vtk_obj.SetParametricFunction,
                        deref_vtk(arg))
        self.trait_property_changed('parametric_function', old_val, arg)
    parametric_function = traits.Property(_get_parametric_function, _set_parametric_function, desc=\
        r"""
        
        """
    )

    def disable_all_ranks(self):
        """
        disable_all_ranks(self) -> None
        C++: void disable_all_ranks()"""
        ret = self._vtk_obj.DisableAllRanks()
        return ret
        

    def disable_rank(self, *args):
        """
        disable_rank(self, rank:int) -> None
        C++: void disable_rank(int rank)"""
        ret = self._wrap_call(self._vtk_obj.DisableRank, *args)
        return ret

    def enable_all_ranks(self):
        """
        enable_all_ranks(self) -> None
        C++: void enable_all_ranks()"""
        ret = self._vtk_obj.EnableAllRanks()
        return ret
        

    def enable_rank(self, *args):
        """
        enable_rank(self, rank:int) -> None
        C++: void enable_rank(int rank)
        Enable/Disable ranks.
        
        By default every rank is enabled, this default policy will be
        changed if disable_all_ranks is used, and again reverted when
        enable_all_ranks is used.
        
        enable_rank/disable_rank are used to specify individual exceptions
        of the default policy.
        """
        ret = self._wrap_call(self._vtk_obj.EnableRank, *args)
        return ret

    def is_enabled_rank(self, *args):
        """
        is_enabled_rank(self, rank:int) -> bool
        C++: bool is_enabled_rank(int rank)"""
        ret = self._wrap_call(self._vtk_obj.IsEnabledRank, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_partitions', 'GetNumberOfPartitions'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'number_of_partitions', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PartitionedDataSetSource, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PartitionedDataSetSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_partitions']),
            title='Edit PartitionedDataSetSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PartitionedDataSetSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

