#-----------------------------------------------------------------------------
#
#  Copyright (c) 2005, 2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: Dave Peterson <dpeterson@enthought.com>
#
#-----------------------------------------------------------------------------

""" An action to close the current project.  This is only enabled when
    there is a current project.
"""

# Standard library imports.

# Major packages.

# Enthought library imports
from enthought.envisage.single_project.project_action import ProjectAction

# Application specific imports.

# Local imports.


##############################################################################
# class 'CloseAction'
##############################################################################

class CloseAction(ProjectAction):
    """ An action to close the current project.  This is only enabled when
        there is a current project.
    """

    ##########################################################################
    # Traits
    ##########################################################################

    #### public 'ObjectAction' interface #####################################

    # The universal object locator (UOL).
    uol = 'service://enthought.envisage.single_project.UiService'

    # The name of the method to invoke on the object.
    method_name = 'close'


#### EOF #####################################################################
