""" The resource plugin definition. """


# Enthought library imports.
from enthought.envisage import ExtensionItem, ExtensionPoint, PluginDefinition
from enthought.traits.api import List, Str

# Plugin definition imports.
#
# NOTE: Resources cannot require ui_plugin definition as not all plugins using
# resources use the UI plugin!
from enthought.envisage.ui.ui_plugin_definition \
     import Action, EnabledWhen, Group, Menu

# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = "enthought.envisage.resource_ui"


###############################################################################
# Extension points.
###############################################################################

class ResourceWizard(ExtensionItem):
    """ The deifnition of a single resource wizard. """

    # The category that the wizard belongs to.
    category = Str

    # The name of the wizard.
    name = Str

    # The name of the class that implements the 'ResourceWizard' interface.
    class_name = Str

class ResourceWizards(ExtensionPoint):
    """ Allows other plugins to contribute new resource wizards. """

    resource_wizards = List(ResourceWizard)

class ResourceAction(Action):
    """ An action on a resource context menu. """

    # The resource type to add the action to.
    resource_type = Str

    # The location on the context menu.
    path = Str

class ResourceMenu(Menu):
    """ A submenu on a resource context menu. """

    # The resource type to add the submenu to.
    resource_type = Str

class ResourceActions(ExtensionPoint):
    """ Allows other plugins to contribute new resource types. """

    actions = List(ResourceAction)
    groups  = List(Group)
    menus   = List(ResourceMenu)

class CookieImplementation(ExtensionItem):
    """ A cookie implementation for a resource type. """

    # The resource to add the cookie instance to.
    resource_type = Str

    # The id of the cookie interface (i.e. the class name).
    cookie_interface = Str

    # The class name of the cookie implementation.
    cookie_implementation = Str

class CookieImplementations(ExtensionPoint):
    """ Allows other plugins to contribute new cookie implementations. """

    implementations = List(CookieImplementation)


###############################################################################
# Extensions.
###############################################################################
# fixme: these actions really need to move over to the resource source tree!
PROJECT_ID = "enthought.envisage.project"

resource_actions = ResourceActions(

    actions = [
        ResourceAction(
            id            = PROJECT_ID + ".action.open_action.OpenAction",
            class_name    = PROJECT_ID + ".action.open_action.OpenAction",
            name          = "Open",
            image         = "action/images/open",
            description   = "Open the selected resource",
            tooltip       = "Open the selected resource",

            resource_type = "",
            path          = "system_top",

            enabled_when  = EnabledWhen(
                cookie = PROJECT_ID + ".action.open_cookie.OpenCookie"
            )
        ),

        ResourceAction(
            id            = PROJECT_ID + ".action.copy_action.CopyAction",
            class_name    = PROJECT_ID + ".action.copy_action.CopyAction",
            name          = "Copy",
            image         = "action/images/copy",
            description   = "Copies the selected resource(s)",
            tooltip       = "Copies the selected resource(s)",

            resource_type = "",
            path          = "edit_group",
        ),

        ResourceAction(
            id            = PROJECT_ID + ".action.paste_action.PasteAction",
            class_name    = PROJECT_ID + ".action.paste_action.PasteAction",
            name          = "Paste",
            image         = "action/images/paste",
            description   = "Pastes the selected resource(s)",
            tooltip       = "Pastes the selected resource(s)",

            resource_type = "",
            path          = "edit_group",
        ),

        ResourceAction(
            id            = PROJECT_ID + ".action.delete_action.DeleteAction",
            class_name    = PROJECT_ID + ".action.delete_action.DeleteAction",
            name          = "Delete",
            image         = "action/images/delete",
            description   = "Delete the selected resource(s)",
            tooltip       = "Delete the selected resource(s)",

            resource_type = "",
            path          = "edit_group",
        ),

        ResourceAction(
            id            = PROJECT_ID + ".action.rename_action.RenameAction",
            class_name    = PROJECT_ID + ".action.rename_action.RenameAction",
            name          = "Rename",
            image         = "action/images/rename",
            description   = "Rename the selected resource(s)",
            tooltip       = "Rename the selected resource(s)",

            resource_type = "",
            path          = "edit_group",
        ),
        ResourceAction(
            id            = PROJECT_ID + ".action.properties_action.PropertiesAction",
            class_name    = PROJECT_ID + ".action.properties_action.PropertiesAction",
            name          = "Properties",
            image         = "action/images/open",
            description   = "Open the selected resource properties view",
            tooltip       = "Open the selected resource properties view",

            resource_type = "",
            path          = "system_bottom",

            enabled_when  = EnabledWhen(
                cookie = PROJECT_ID + ".action.properties_cookie.PropertiesCookie"
            )
        ),
    ]
)

###############################################################################
# The plugin definition.
###############################################################################

PluginDefinition(
    # The plugin's globally unique identifier.
    id = ID,

    # The name of the class that implements the plugin.
    class_name = \
        "enthought.envisage.resource.resource_ui_plugin.ResourceUIPlugin",

    # General information about the plugin.
    name          = "Resource UI Plugin",
    version       = "1.0.0",
    provider_name = "Enthought Inc",
    provider_url  = "www.enthought.com",
    enabled       = True,
    autostart     = True,

    # The Id's of the plugins that this plugin requires.
    requires = [
        "enthought.envisage.core",
        "enthought.envisage.ui",
        "enthought.envisage.resource"
    ],

    # The extension points offered by this plugin.
    extension_points = [
        ResourceActions,
        ResourceWizards,
        CookieImplementations,
        ],

    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [
        resource_actions
        ],
)

#### EOF ######################################################################
