#-----------------------------------------------------------------------------
#
#  Copyright (c) 2005-2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: David C. Morrill <dmorrill@enthought.com>
#
#-----------------------------------------------------------------------------

""" Action for creating a new, persistent, user defined perspective.
"""

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------

from workbench_action \
    import WorkbenchAction
    
from user_perspective_name \
    import UserPerspectiveName

#-------------------------------------------------------------------------------
#  'NewUserPerspectiveAction' class:
#-------------------------------------------------------------------------------    

class NewUserPerspectiveAction ( WorkbenchAction ):
    """ Creates a new, persistent, user defined perspective
    """
    
    #---------------------------------------------------------------------------
    #  'Action' interface:
    #---------------------------------------------------------------------------

#-- Public Interface -----------------------------------------------------------

    def perform ( self, event ):
        """ Performs the action, which is to create a new, persistent, user 
            defined perspective.
        """
        window           = event.window
        user_perspective = window.workbench.user_perspective
        
        # Get the name of the new user perspective:
        upn = UserPerspectiveName( 
            name = 'User Perspective %d' % (user_perspective.next_id + 1)
        )
        
        # If the user clicked the OK button, create the new perspective: 
        if upn.edit_traits( view = 'new_view' ).result:
            name = upn.name.strip()
            perspective = user_perspective.new_perspective( name )
            window.perspectives.append( perspective )
            window.active_perspective = perspective
            
            # Make sure the Perspective menu is updated:
            self._manager.changed = True

#### EOF #####################################################################

