#-------------------------------------------------------------------------------
#  
#  A factory class for creating RepositoryRoot objects for use with the  
#  Repository class based on user specified RepositoryRoots.
#  
#  Written by: David C. Morrill
#  
#  Date: 03/30/2006
#  
#  (c) Copyright 2006 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------

from repository_root \
    import RepositoryRoot
    
from repository_root_factory \
    import RepositoryRootFactory

#-------------------------------------------------------------------------------
#  'UserRepositoryRootFactory' class:  
#-------------------------------------------------------------------------------

class UserRepositoryRootFactory ( RepositoryRootFactory ):
    
    #---------------------------------------------------------------------------
    #  'RepositoryRootFactory' interface:  
    #---------------------------------------------------------------------------
        
    def roots ( self ):
        """ Returns the list of RepositoryRoot objects this factory creates.
        """
        roots = self.plugin.preferences.get( 'roots', default = [] )
        for i, root in enumerate( roots ):
            root.priority = i - self.priority
        return roots
    
