/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   Thanx to: Tobias Gler - gcc v4 patch                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kmessagebox.h>

#include <qdatetime.h>
#include "programmaster.h"
//-----------------------------------------------------------------------------------------------------------------------
QTime ProgramMaster::elapsed(Program *p)
{
	QDateTime now(QDateTime::currentDateTime());
	now = now.addSecs(now.time().second()*(-1));
	QTime diff;

	if(p->startDT() <= now)
		diff = diff.addSecs(p->startDT().secsTo(now));
	if(now >= p->stopDT())
		diff = p->duration();
	return(diff);
}
//-----------------------------------------------------------------------------------------------------------------------
bool ProgramMaster::onNow(Program *p)
{
	QDateTime now(QDateTime::currentDateTime());
	now = now.addSecs(now.time().second()*(-1));

	if(p->startDT() <= now && now < p->stopDT())
		return(true);
	return(false);
}
//-----------------------------------------------------------------------------------------------------------------------
bool ProgramMaster::hasEnded(Program *p)
{
	QDateTime now(QDateTime::currentDateTime());
	now = now.addSecs(now.time().second()*(-1));

	if(now >= p->stopDT())
		return(true);
	return(false);
}
//-----------------------------------------------------------------------------------------------------------------------
bool ProgramMaster::hasStarted(Program *p)
{
	QDateTime now(QDateTime::currentDateTime());
	now = now.addSecs(now.time().second()*(-1));

	if(now >= p->startDT())
		return(true);
	return(false);
}
//-----------------------------------------------------------------------------------------------------------------------
bool ProgramMaster::isWithinTimeframe(Program *p, int dayStart, QDate *date)
{
	QTime startStop(dayStart, 0, 0);
	QDateTime frameStart(*date, startStop), frameEnd(frameStart.addDays(1));

	if(p->startDT() >= frameStart && p->startDT() < frameEnd)
		return(true);
	return(false);
}
//-----------------------------------------------------------------------------------------------------------------------
bool ProgramMaster::startsInXMinutes(Program *p, int minutes)
{
	QDateTime now(QDateTime::currentDateTime());
	now = now.addSecs(now.time().second()*(-1) + minutes*60);

	if(now.secsTo(p->startDT()) == 0)
		return(true);
	return(false);
}
//-----------------------------------------------------------------------------------------------------------------------
double ProgramMaster::elapsedPercentage(Program *p)
{
	QTime elapsed(ProgramMaster::elapsed(p));
	double e = elapsed.hour()*60+elapsed.minute(), d = p->duration().hour()*60+p->duration().minute();
	return(e/d);
}
//-----------------------------------------------------------------------------------------------------------------------
