/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __FORUMVIEW_H__
#define __FORUMVIEW_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <klistview.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qhttp.h>
#include <qtimer.h>
#include "programmaster.h"
#include "programitem.h"
#include "baseview.h"
//-----------------------------------------------------------------------------------------------------------------------
class MainWidget;
//-----------------------------------------------------------------------------------------------------------------------
class ForumView : public BaseView
{
	Q_OBJECT

public:
	enum ReqType { RT_NONE, RT_RELOAD, RT_SUBMIT };

	ForumView(MainWidget *parent, ProgramMaster *programMaster, KListView *lv, QPtrList<Program> *programs, QWidget *frame);
	~ForumView();

	virtual void loadSettings(KConfig */*cfg*/) { }
	virtual void saveSettings(KConfig */*cfg*/) { }
	
	virtual void newDay() { }
	virtual void aboutToShow();
	virtual void preParse() { }
	virtual void postParse() { }

public slots:
	void timerDone();
	void done(bool error);
	
	virtual void showPopupMenu(KListView*, QListViewItem */*item*/, const QPoint&) { }
	virtual bool rebuild() { return(true); }
	void leaveClicked();
	void reload();
	void submit();
	void textChanged();

private:
	QWidget *m_fromView;
	QString m_channelId;
	QString m_startTime;
	QString m_data;
	QTimer m_timer;
	QHttp m_http;
	int m_limiter;
	ReqType m_req;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
