#! /usr/bin/perl
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

package testdb;

@ISA = ('Exporter');
@EXPORT = ('new');


BEGIN {
    if (!($^O =~ /MSWin32/i)) {
        push(@INC, "/devtool/local/bin");
        push(@INC, "/devtool/TOOL/tool/bin");
        push(@INC, "/devtool/TOOL/tool/lib/perl5");
        push(@INC, "/devtool/TOOL/tool/lib");
        push(@INC, "/SAP_DB/TESTDB/lib");
    }
}
use Getopt::Long;
use Sys::Hostname;
use File::Copy;
use Net::SMTP;
use File::Path;
use qadb;

if ($^O =~ /MSWin32/i) {
  require File::DosGlob ;
  import  File::DosGlob 'glob';
  require WinLink;
  import  WinLink;
  require Win32::TieRegistry;
  import  Win32::TieRegistry;
  require Win32::Process;
  import  Win32::Process;
}

1;


sub new {
      #
      # Lets get initialized
      #
      my $name = shift;
      my $options = shift;

      my $self = {};
      $self->{'cmdcount'};
      $self->{'path'} = $ENV{'PATH'};

      ##
      ## Basic settings: things we should know about:
      ##
      $self->{'versions'}    = ['7402', '7403', '7404', '7405', '8000'];
      $self->{'status'}      = ['DEV', 'COR', 'RAMP'];
      $self->{'profiles'}    = ['workday', 'weekend'];
      $self->{'hostname'}    = hostname();
      $self->{'error_text'}  = "";
      $self->{'error_code'}  = 0;
      $self->{'prot_count'}  = 0;
      $ENV{'RELVER'}           = "R74"; # Well, this will have to be taken into getVersionDep someday.

    if ($^O =~ /MSWin32/i) {
        $self->{'delimit'}       = "\\"; # As we know, Windows uses backslashes
        $self->{'pathsep'}       = ";";
        $self->{'rootdir'}       = "D:\\SAP_DB\\";
        $self->{'rmcmd'}         = "del /s /q ";
        $self->{'xserver_param'} = "";
        $self->{'instwrap'}      = "";
        $self->{'path'}          = "D:\\sapdb\\programs\\bin;d:\\sapdb\\programs\\pgm;D:\\devtool\\perl\\bin;D:\\DEVTOOL\\bin;d:\\devtool\\adminbin;d:\\devtool\\pgm;d:\\devtool\\posix;d:\\devtool\\Perl;d:\\devtool\\python\\bin;" . $self->{'path'};
        $self->{'globtemp'}      = "D:\\temp";
        $ENV{'JTEST_TOOL'}       = "d:\\devtool\\";
        $ENV{'TOOLVARS'}         = "d:\\devtool\\bin\\toolvars.pl";
        $ENV{'TOOL'}             = "d:\\devtool";
        $ENV{'TOOLEXT'}          = ".pl";
        $ENV{'TOOLSHELL'}        = "D:\\devtool\\perl\\bin\\perl";
        $ENV{'PYTHON'}           = "D:\\devtool\\python";
        $ENV{'PERL'}             = "d:\\devtool\\perl";
        $ENV{'PERL5LIB'}        .= $ENV{'TOOL'} . "\\bin;" . $ENV{'TOOL'} ."\\perl;" . $ENV{'TOOL'} ."\\Perl\\site;" . $ENV{'TOOL'} ."\\Perl\\site\\lib";
        $ENV{'ISWDFNACHT'}       = 1;
        $ENV{'PYTHONPATH'}       = "d:\\devtool\\lib\\Python";
    }
    else {
        $self->{'delimit'}       = "/";
        $self->{'pathsep'}       = ":";
        $self->{'rootdir'}       = "/SAP_DB/";
        $self->{'user'}          = "remuser";
        $self->{'group'}         = "sapsys";
        $self->{'instwrap'}      = $self->{'rootdir'} . "TESTDB/tinysudo";
        $self->{'rmcmd'}         = "rm -rf ";
        $self->{'vserverext'}    = ".old";
        $self->{'ininame'}       =  "/usr/spool/sql/ini/SAP_DBTech.ini";
        $self->{'xserver_param'} = " -Y";
        $self->{'path'}         .= ":/devtool/TOOL/tool/pgm:/devtool/TOOL/tool/Posix:/usr/bin/X11:.";
        $self->{'path'}         .= ":/usr/bin:/bin:/usr/local/bin:/devtool/local/bin:/devtool/TOOL/tool/bin";
        $self->{'globtemp'}      = "/tmp";
        $ENV{'TOOL'}             = "/devtool/TOOL/tool";
        $ENV{'TOOLEXT'}          = ".pl";
        $ENV{'TOOLSHELL'}        = "/devtool/local/bin/perl";
        $ENV{'PYTHON'}           = "/devtool/TOOL/tool/Python";
        $ENV{'PERL'}             = "/devtool/local";
        $ENV{'PERL5LIB'}         = $ENV{'TOOL'} . "/bin:" . $ENV{'TOOL'} . "/lib/perl5";
        $ENV{'RELVER'}           = "R74"; # Well, this will have to be taken into getVersionDep someday.
        $ENV{'JTEST_TOOL'}       = $ENV{'TOOL'};
        $ENV{'TOOLVARS'}         = $ENV{'TOOL'} . "/bin/toolvars";
        $ENV{'ISWDFNACHT'}       = '1';
        $ENV{'PYTHONPATH'}       = "/devtool/TOOL/tool/lib/Python";
    }

  ##################################################################
  # parameter checking
  ##################################################################
  




  $self->{'hostname'} = hostname();

    if ($self->{'hostname'} eq "us0062") {
        $self->{'path'}     .= ":/usr/j2se/jre/bin:/sapdb/programs/bin:/sapdb/programs/pgm:/opt/WS6U2/SUNWspro/bin:/opt/WS6U2/SUNWspro";
        $self->{'bits'}      = "64";
        $self->{'platform'}  = "sun_64";
        $ENV{'BIT64'}        = '1';
    }
    elsif ($self->{'hostname'} eq "ds0116") {
        $self->{'path'}     .= ":/usr/opt/java131/bin:/SAP_DB/TESTDB/prog_indep/bin:/SAP_DB/TESTDB/prog_indep/pgm";
        $self->{'bits'}      = "64";
        $self->{'platform'}  = "alphaosf";
        $ENV{'BIT64'}        = '1';
    }
    elsif ($self->{'hostname'} eq "is0025") {
        $self->{'path'}     .= ":/usr/java130/jre/sh:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
        $self->{'bits'}      = "64";
        $self->{'platform'}  = "rs6000_51_64";
        $ENV{'BIT64'}        = '1';
    }
    elsif ($self->{'hostname'} eq "is0026") {
        $self->{'path'}         .= ":/usr/java131/jre/sh:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
        $self->{'bits'}          = "64";
        $self->{'platform'}      = "rs6000_64";
        $self->{'xserver_param'} = ""; # This is secialy needed for this release
        $ENV{'BIT64'}            = '1';
        pop @versions; # Currently, SAP DB 7.4.3 is only availble von AIX 5, not an AIX 4
    }
    elsif ($self->{'hostname'} =~ "^hs0") {
        $self->{'path'}    .= ":/opt/java1.3/jre/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/opt/aCC/bin";
        $self->{'bits'}     = "64";
        $self->{'platform'} = "hp_64";
        $ENV{'BIT64'}       = '1';
        $ENV{'UNIX95'}      = "1";
        $ENV{'TZ'}          = "MET-1METDST";
    }
        elsif ($self->{'hostname'} eq "ls0049") {
                $self->{'path'}    .= ":/usr/lib/java/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
                $self->{'bits'}     = "32";
                $self->{'platform'} = "linuxintel";
        delete $ENV{'BIT64'}; # Someday, this belongs to getHostDep
        }
	elsif ($self->{'hostname'} eq "ls3007") {
		$self->{'bits'}     = "64";
		$self->{'platform'} = "linuxia64";
		$self->{'path'}    .= ":/SAP_DB/programs/bin:/SAP_DB/programs/pgm:";
	}
	
	elsif ($self->{'hostname'} eq "PWDF0238") {
		$self->{'path'}         .= ";C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\IDE;C:\\Program Files\\";
		$self->{'path'}         .= "Microsoft Visual Studio .NET\\VC7\\BIN;C:\\Program Files\\Microsoft Visual Studio .N";
		$self->{'path'}         .= "ET\\Common7\\Tools;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin";
		$self->{'path'}         .= "\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin;C:\\P";
		$self->{'path'}         .= "rogram Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\bin;C:\\WINNT\\Microsoft.NE";
		$self->{'path'}         .= "T\\Framework\\v1.0.3705;";
		$ENV{'INCLUDE'}          = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\INCLUDE;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\INCLUDE;C:\\Program Files\\Microsoft Visual Studio .NET\\"
			     . "VC7\\PlatformSDK\\include\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\include;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include\\";
		$ENV{'LIB'}              = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\LIB;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\LIB;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\lib;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\Lib\\";
		$ENV{'VSINSTALLDIR'}     = "C:\\Program Files\\Microsoft Visual Studio .NET";
		$ENV{'FrameworkDir'}     = "C:\\WINNT\\Microsoft.NET\\Framework";
		$ENV{'FrameworkVersion'} = "v1.0.3705";
		$ENV{'FrameworkSDKDir'}  = "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK";
		$self->{'bits'}          = "32";
		$self->{'platform'}      = "NTintel";
    }
    	elsif ($self->{'hostname'} eq "pwdf2027") {
		$self->{'path'}         .= ";C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\IDE;C:\\Program Files\\";
		$self->{'path'}         .= "Microsoft Visual Studio .NET\\VC7\\BIN;C:\\Program Files\\Microsoft Visual Studio .N";
		$self->{'path'}         .= "ET\\Common7\\Tools;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin";
		$self->{'path'}         .= "\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin;C:\\P";
		$self->{'path'}         .= "rogram Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\bin;C:\\WINNT\\Microsoft.NE";
		$self->{'path'}         .= "T\\Framework\\v1.0.3705;";
		$ENV{'INCLUDE'}          = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\INCLUDE;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\INCLUDE;C:\\Program Files\\Microsoft Visual Studio .NET\\"
			     . "VC7\\PlatformSDK\\include\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\include;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include\\";
		$ENV{'LIB'}              = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\LIB;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\LIB;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\lib;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\Lib\\";
		$ENV{'VSINSTALLDIR'}     = "C:\\Program Files\\Microsoft Visual Studio .NET";
		$ENV{'FrameworkDir'}     = "C:\\WINNT\\Microsoft.NET\\Framework";
		$ENV{'FrameworkVersion'} = "v1.0.3705";
		$ENV{'FrameworkSDKDir'}  = "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK";
		$self->{'bits'}          = "32";
		$self->{'platform'}      = "NTintel";
    }
    elsif ($self->{'hostname'} eq "itanium21") {
        $self->{'path'}         .= ";C:\\Program Files (x86)\\Java\\j2sdk1.4.2.beta;C:\\Program Files\\Microsoft Platform SDK\\Bin\\Win64;C:\\Program Files\\Microsoft Platform SDK\\";
        $self->{'path'}         .= "Bin;C:\\Program Files\\Microsoft Platform SDK\\Bin\\WinNT;C:\\WINNT;C:\\WINNT\\system32;D:\\DEVTOOL";
        $self->{'path'}         .= "\\bin;d:\\devtool\\adminbin;d:\\devtool\\pgm;d:\\devtool\\posix;d:\\devtool\\Perl;d:\\devtool\\python\\bin";
        $ENV{'INCLUDE'}          = "C:\\Program Files\\Microsoft Platform SDK\\Include\\prerelease;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\crt;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\crt\\sys;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\mfc;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\atl;C:\\Program Files\\Microsoft Platform SDK\\Include;C:\\Program Files\\Microsoft Platform SDK\\Include\\DShowIDL;C:\\Program Files\\Microsoft Platform SDK\\PATCH\\include";
        $ENV{'ComSpec'}          = "C:\\WINDOWS\\system32\\cmd.exe";
        $ENV{'CPU'}              = "IA64";
        $ENV{'DEBUGMSG'}         = "RETAIL";
        $ENV{'DXSDKROOT'}        = "C:\\Program Files\\Microsoft Platform SDK";
        $ENV{'INETSDK'}          = "C:\\Program Files\\Microsoft Platform SDK";
        $ENV{'Lib'}              = "C:\\Program Files\\Microsoft Platform SDK\\Lib\\Prerelease\\IA64;C:\\Program Files\\Microsoft Platform SDK\\Lib\\IA64;C:\\Program Files\\Microsoft Platform SDK\\Lib\\IA64\\mfc;C:\\Program Files\\Microsoft Platform SDK\\PATCH\\lib";
        $ENV{'MSSdk'}            = "C:\\Program Files\\Microsoft Platform SDK";
        $ENV{'Mstools'}          = "C:\\Program Files\\Microsoft Platform SDK";
        $ENV{'MSVCVer'}          = "Win64";
        $ENV{'BIT64'}      = '1';
        $self->{'bits'} = "64";
        $self->{'platform'} = "NTia64";
    }
    else {
        print "The host $self->{'hostname'} ist not known in the configuration\n(See sub getdep!)\n";
        exit(1);
    }

	if (defined ${$options}{'ID'}) {
		$self->{'qah'} = qadb->new({'ID' => ${$options}{'ID'}});
		$self->{'qah'}->get_testlist();
		$self->{'version'} = $self->{'qah'}->{'VERSION'};
		$self->{'status'}  = $self->{'qah'}->{'QASTATUS'};
		if (${$options}{'profile'} eq 'weekend') {
			$self->{'profile'} = 'weekend';
		}
		else {
			$self->{'profile'} = 'workday';
		}
	} else {
		$self->{'version'} = ${$options}{'version'};
		$self->{'status'}  = ${$options}{'status'};
		if (${$options}{'profile'} eq 'weekend') {
			$self->{'profile'} = 'weekend';
		}
		else {
			$self->{'profile'} = 'workday';
		}
		
		
		$self->{'qah'} = qadb->new_test({'QASTATUS' => $self->{'status'}, 'VERSION' => $self->{'version'}});
		if ($qah->{'error_code'} != 0) {
			print "Exiting:\n" . $qah->{'error_text'} . "\n";
			exit(1);
		}
	}
	print $self->{'qah'}->{'platformname'} . "\n";
    $self->{'platform'} = $self->{'qah'}->{'platformname'};
    $ENV{'PLATFORM'} = $self->{'platform'};

    $self->{'node'} = $self->{'version'} . $self->{'status'};


    ##################################################################
    # Find out which files to use
    ##################################################################
    if (($self->{'status'} eq "RAMP") && !($^O =~ /MSWin32/i)){
        print "################\n/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}??_$self->{'bits'}_RAMP";
        @subdirs           = glob ("/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}??_$self->{'bits'}_RAMP");
        sort (@subdirs);
        $self->{'subdir'}  = pop(@subdirs);

        @files             = (glob "$self->{'subdir'}/" . $self->{'qah'}->{'LCPOOLID'} . "/SAPDB$self->{'version'}*.SAR");
        $self->{'srcfile'} = pop(@files);

        $self->{'srcdir'}  = "$self->{'subdir'}/" . $self->{'qah'}->{'LCPOOLID'};
        $self->{'build'}   = substr($self->{'subdir'}, length("/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}"), 2);
        $self->{'sdbinst'} = $self->{'srcdir'} . "/SAPDB_COMPONENTS/SDBINST";
    }

    elsif (($self->{'status'} eq "RAMP") && ($^O =~ /MSWin32/i)) {
        @subdirs = glob ("L:\\LC_$self->{'version'}??_$self->{'bits'}_RAMP");
        sort (@subdirs);
        $self->{'subdir'}  = pop(@subdirs);
        $self->{'srcdir'}  = $self->{'subdir'} . "\\" . $self->{'qah'}->{'LCPOOLID'};
        @files             = (glob ("$self->{'srcdir'}\\SAPDB$self->{'version'}*.SAR"));
        $self->{'srcfile'} = pop(@files);
        $self->{'build'}   = substr($self->{'subdir'}, length("L:\\LC_$self->{'version'}"), 2);
        $self->{'sdbinst'} = $self->{'srcdir'} . "\\SAPDB_COMPONENTS\\SDBINST.EXE";
    }

    elsif (($self->{'status'} ne "RAMP") && !($^O =~ /MSWin32/i)) {
        $self->{'subdir'} = "/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}_$self->{'bits'}_$self->{'status'}";
        @files = (glob "$self->{'subdir'}/LastBuild/SAPDB$self->{'version'}*.SAR");

        $self->{'srcfile'} = pop(@files);
        $self->{'srcdir'}  = "$self->{'subdir'}/LastBuild";
        $self->{'build'}   = substr($self->{'srcfile'}, -6 ,2);
        $self->{'sdbinst'} = $self->{'srcdir'} . $self->{'delimit'} . "SAPDB_COMPONENTS" . $self->{'delimit'} . "SDBINST";
    }
    elsif (($self->{'status'} ne "RAMP") && ($^O =~ /MSWin32/i)) {
        $self->{'subdir'}   = "L:\\LC_$self->{'version'}_$self->{'bits'}_$self->{'status'}";
        $self->{'srcdir'}   = $self->{'subdir'} . "\\" . $self->{'qah'}->{'LCPOOLID'};

        @files              = (glob "$self->{'srcdir'}\\SAPDB$self->{'version'}*.SAR");
        $self->{'srcfile'}  = pop(@files);
        $self->{'build'}    = substr($self->{'srcfile'}, -6, 2);
        $self->{'sdbinst'}  = $self->{'srcdir'} . "\\SAPDB_COMPONENTS\\SDBINST.EXE";
    }

    $self->{'tempdir'}    = $self->{'rootdir'} . $self->{'node'} . $self->{'delimit'} . "tmp";
    $self->{'dbroot'}     = $self->{'rootdir'} . $self->{'node'} . $self->{'delimit'} . "db";
    $self->{'testdir'}    = $self->{'rootdir'} . $self->{'node'} . $self->{'delimit'} . "test";
    $self->{'jtest_root'} = $self->{'testdir'} . $self->{'delimit'}. "jtest";

    #
    # Read the independend program path
    #

    $ENV{'PATH'} = $self->{'path'};
    if ($self->{'version'} gt "74")
    {
        open (DBMCLII, "dbmcli dbm_getpath IndepProgPath|");
    }
    else
    {
        open (DBMCLII, "dbmcli -s dbm_getpath IndepProgPath|");
    }
    while (<DBMCLII>) {
        if (!(/^OK/)) {
            $self->{'indeppath'} = $_;
        }
    }

    chomp($self->{'indeppath'});
    $ENV{'INDEPPATH'}   = $self->{'indeppath'};
    $self->{'vserver'}  = $self->{'indeppath'} . $self->{'delimit'} . "pgm" . $self->{'delimit'} . "vserver";

    $self->{'path'}    .= $self->{'pathsep'} . $self->{'testdir'} . $self->{'delimit'} . "pc" . $self->{'delimit'} . "bin" . $self->{'pathsep'} . $self->{'dbroot'} . $self->{'delimit'} . "bin". $self->{'pathsep'} . $self->{'dbroot'} . $self->{'delimit'} . "pgm";
    $ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
    $ENV{'PYTHONPATH'} .= $self->{'pathsep'} . $self->{'dbroot'} . $self->{'delimit'} . "misc";
    $ENV{'TEST_ROOT'}   = $self->{'testdir'};
    $ENV{'TESTROOT'}    = $self->{'testdir'};
    $ENV{'SAPDBSDK'}    = $self->{'dbroot'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'version'};
    $ENV{'TMP'}         = $self->{'tempdir'};
    $ENV{'TEMP'}        = $self->{'tempdir'};

    for $x (keys(%$self)) {
        print "$x = " . $self->{$x} . "\n";
    }
    return bless $self;
}

sub unlock {
    my $self = shift;

    return $self->{'qah'}->unlock();
}

sub lock {
    my $self = shift;

#00 19 * * 5 cd /SAP_DB/TESTDB && . ./tp2-73.sh > /tmp/tp2-73.log

    $self->{'qah'} = $self->{'qah'}->lock();

    return 0;
}
#
# Provide a terminal
#
sub term {
    $self = shift;
    $ENV{'PATH'}        = $self->{'path'};
    $ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
    $ENV{'INSTROOT'}    = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}   = $self->{'testdir'};
    $ENV{'TESTROOT'}    = $self->{'testdir'};
    $ENV{'SAPDBSDK'}    = $self->{'dbroot'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'version'};
    $ENV{'TMP'}         = $self->{'tempdir'};
    $ENV{'TEMP'}        = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);

    if ($^O =~ /MSWin32/i) {
        system ("cmd");
    }
    else {
        system ("xterm &");
    }
}

sub cmd {
    $self = shift;
    $cmd  = shift;

    $ENV{'PATH'}        = $self->{'path'};
    $ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
    $ENV{'INSTROOT'}    = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}   = $self->{'testdir'};
    $ENV{'TESTROOT'}    = $self->{'testdir'};
    $ENV{'SAPDBSDK'}    = $self->{'dbroot'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'version'};
    $ENV{'TMP'}         = $self->{'tempdir'};
    $ENV{'TEMP'}        = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);


    &doCmd($cmd);
}

##################################################################
# subs
##################################################################
##################################################################
# preClean:
# Throws away current instances, unregisters the installation
# and eraes tempoary and test directorys.
##################################################################
sub preClean {
    $self = shift;
    $ENV{'PATH'}        = $self->{'path'};
    $ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
    $ENV{'INSTROOT'}    = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}   = $self->{'testdir'};
    $ENV{'TESTROOT'}    = $self->{'testdir'};
    $ENV{'SAPDBSDK'}    = $self->{'dbroot'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'version'};
    $ENV{'TMP'}         = $self->{'tempdir'};
    $ENV{'TEMP'}        = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);

    unless ($^O =~ /MSWin32/i)
    {
        &doCmd($self, "uptime");
    }
    &doCmd($self, "x_niserver stop");
    &doCmd($self, "x_server $self->{'xserver_param'}");
    open (DBLIST, 'dbmcli db_enum|');
    my $x = "";
    while (<DBLIST>) {
        if ($self->{'verbose'}) {
            print "$_ \n";
            print $self->{'node'} . "\n";
        }

        if ( /fast/ && /$self->{node}/i ) {
            s/^(\w+)\s+.*$/$1 /;
            $x = $_;
            chomp($x);
            foreach $y ("control,control", "dbm,dbm", "superdba,colduser") {
                print "dbmcli -u $x -d $x\n";
                &doCmd($self, "dbmcli -u $y -d $x db_stop");
                &doCmd($self, "dbmcli -u $y -d $x db_clear");
                &doCmd($self, "dbmcli -u $y -d $x db_drop");
            }
        }
    }

    &doCmd($self, "x_niserver stop");
    print "#######################################################################################\n";
    &doCmd($self, "x_server stop");

    # If we were called with -noinstall, it is _not_ usefull to
    # deregister the installation.
    if (!($options{'noinstall'})) {e
    &doCmd($self, "dbmcli inst_unreg $self->{'dbroot'}");
    }

    if ($^O =~ /MSWin32/i) {
        &doCmd($self, "kill dbmsrv.exe");
    }


    &doCmd($self, "$self->{'rmcmd'} $self->{'tempdir'}" . $self->{'delimit'} . "*");
    
    unless ($^O =~ /MSWin32/i) {
	    &doCmd($self, "$self->{'rmcmd'} $self->{'tempdir'}" . $self->{'delimit'} . ".[xX]*");
    }
    
    &doCmd($self, "$self->{'rmcmd'} $self->{'testdir'}" . $self->{'delimit'} . "* ");
}

##################################################################
# installLC:
# installs the LC depending on the informations we have
# already figured out.
##################################################################
sub installLC {
    my $self = shift;
    my $rc;
    my $sig;
    my $core;
    my $outbuf;
    print $ENV{'PATH'} . "\n";

    system("x_server stop");


    if ($^O =~ /MSWin32/i) {
        $self->{'odbcinst_param'} = " -b -profile ODBC  ";
        $self->{'inst_param'} = " -b -profile Server  -depend $self->{'dbroot'} ";
	$self->{'loader_param'} = " -b -profile Loader -loader_path $self->{'indeppath'}";
        ($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'inst_param'} ");
        if ($rc != 0) {
            send_error($self, 1109, $rc, $sig, $core, "LC installation - Core installation failed.", $outbuf);
        }
	
	if ($self->{'version'} =~ /7404/) {
		($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'loader_param'} ");
		if ($rc != 0) {
			send_error($self, 1109, $rc, $sig, $core, "LC installation - Loader installation failed.", $outbuf);
		}
	}
	
        system("x_server $self->{'xserver_param'}");
        open (LTFD, (">" . $self->{'subdir'} . $self->{'delimit'} . "LastTest"));
        print LTFD $self->{'buildidx'} . "\n";
        close (LTFD);
    }
    else {
        # Set the lastTest-Directory correctly:
        # First, the old LastTest has to be unlinked
        if (-e $self->{'subdir'} . $self->{'delimit'} . "LastTest") {
            if (!($options{'dry'})) {
                if ($options{'verbose'}) {
                    print "Unlinking LastTest $self->{'subdir'}" . $self->{'delimit'} . "LastTest\n"
                }
                unlink ($self->{'subdir'} . "" . $self->{'delimit'} . "LastTest") || print "Could not erase LastTest!\n";
            }
            else {
                print "Normaly, the LastTest ($self->{'subdir'}" . $self->{'delimit'} . "LastTest) would be erased now.\n";
            }
        }
        # then, create a new link
        if (!($options{'dry'})) {
            if ($options{'verbose'}) {
                print "Linking $self->{'subdir'}" . $self->{'delimit'} . "$self->{'qah'}->{'LCPOOLID'} to LastTest\n";
            }
            symlink ($self->{'subdir'} .  $self->{'delimit'} . $self->{'qah'}->{'LCPOOLID'}, $self->{'subdir'} . $self->{'delimit'} . "LastTest") ||
            print "Could not link $self->{'subdir'}" . $self->{'delimit'} . $self->{'qah'}->{'LCPOOLID'} . " to LastTest\n";
        }
        else {
            print "Normaly:\nLinking $self->{'subdir'}" . $self->{'delimit'} . "$self->{'qah'}->{'LCPOOLID'} to LastTest\n";
        }
        # End of link-setting

        # perform the installation itself
        $self->{'odbcinst_param'} = " -b -profile ODBC -o $self->{'user'} -g $self->{'group'}  ";
        $self->{'inst_param'} = " -b -profile Server -o $self->{'user'} -g $self->{'group'} -depend $self->{'dbroot'} ";
	$self->{'loader_param'} = " -b -profile Loader -o $self->{'user'} -g $self->{'group'} -loader_path $self->{'indeppath'}";
        ###################
        ($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'inst_param'} ");
        if ($rc != 0) {
            send_error($self, 1109, $rc, $sig, $core, "LC installation - Core installation failed.", $outbuf);
        }

	if ($self->{'version'} =~ /7404/) {
		($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'loader_param'} ");
		if ($rc != 0) {
			send_error($self, 1109, $rc, $sig, $core, "LC installation - Loader installation failed.", $outbuf);
		}
	}
    }

    print "#####ODBC###############################################################\n";
    #####ODBC###############################################################
    # Okay, dann machen wir mal etwas ODBC
    # First, remove the currently installed ODBC package

    if (!($^O =~ /MSWin32/i)) {
        ($rc, $sig, $core, $outbuf) = &doCmd($self, "echo y | $self->{'instwrap'} $self->{'indeppath'}" . $self->{'delimit'} . "bin" . $self->{'delimit'} . "sdbuninst -autoresolve -package ODBC");
        if ($rc != 0) {
            send_error($self, 1109, $rc, $sig, $core, "LC installation - removing old ODBC failed.", $outbuf);
        }
        # Then install the package we want.
        ($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'odbcinst_param'} ");
        if ($rc != 0) {
            send_error($self, 1109, $rc, $sig, $core, "LC installation - ODBC installation failed.", $outbuf);
        }
    }


    #####PRECOMPILER###############################################################
    # Okay, now we will handle the precompiler
    #

    print "#####PRECOMPILER###############################################################\n";
    ($rc, $sig, $core, $outbuf) = &doCmd($self, "cd $self->{'dbroot'} && SAPCAR -xvf $self->{'srcdir'}" . $self->{'delimit'} . "SAPDBCSDK.SAR");
    if ($rc != 0) {
        send_error($self, 1109, $rc, $sig, $core, "LC installation - Precompiler installation failed.", $outbuf);
    }

    ##### RESTART THE x_server
    ($rc, $sig, $core, $outbuf) = &doCmd($self, "x_server $self->{'xserver_param'}");


    #####SIMULATOR###############################################################
    # Okay, now we will install the files for the lc-simulator
    #


    print "#####SIMULATOR###############################################################\nStart copying simulator files:\n";

    open LIST_FH, ($self->{'srcdir'} . $self->{'delimit'}. "simul.lst") or return throw_err("Could not open $self->{'srcdir'}$self->{'delimit'}simul.lst\n");

    while(<LIST_FH>) {
        print "###########################################\nTry to copy ${_}: \n";

        # At first: Figure out what the sourcename is
        my $srcfile  = "$self->{'srcdir'}$self->{'delimit'}sys$self->{'delimit'}src$self->{'delimit'}lcsrc$self->{'delimit'}$_";
        # Then find the target-directory:

        my $destfile = "$self->{'dbroot'}$self->{'delimit'}$_";
        chomp $srcfile;
        chomp $destfile;
        print "$srcfile -> $destfile\n";
        checkdir ($destfile);
        copy ($srcfile, $destfile) or throw_err ("Could not copy $srcfile to $destfile:\n$! \n");
        chmod ((stat($srcfile))[2], $destfile);
    }
}

##################################################################
# installTF:
# installs the Java TestFrame depending on the informations we
# have already figured out.
##################################################################
sub installTF {
    $self = shift;
    $ENV{'PATH'}        = $self->{'path'};
    $ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
    $ENV{'INSTROOT'}    = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}   = $self->{'testdir'};
    $ENV{'TESTROOT'}    = $self->{'testdir'};
    $ENV{'SAPDBSDK'}    = $self->{'dbroot'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'version'};
    $ENV{'TMP'}         = $self->{'tempdir'};
    $ENV{'TEMP'}        = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);

    # Extract alltestpkg.sar :
    my ($rc, $sig, $core, $outbuf) = &doCmd($self, "cd $self->{'tempdir'} && SAPCAR -xvf $self->{'srcdir'}" . $self->{'delimit'} . "test" . $self->{'delimit'} . "jtest" . $self->{'delimit'} . "alltestpkg.sar");
    if ($rc != 0) {
        send_error($self, 1119, $rc, $sig, $core, "TestFrame installation - SAPCAR failed.", $outbuf);
    }
    ($rc, $sig, $core, $outbuf) = &doCmd($self, "cd $self->{'tempdir'} && perl jtinstall.pl -n -jr $self->{'jtest_root'} -ir $self->{'dbroot'}");

    if ($rc != 0) {
        send_error($self, 1119, $rc, $sig, $core, "TestFrame installation - jtinstall failed.", $outbuf);
    }
}

##################################################################
# runTF:
# run the Java TestFrame.
##################################################################
sub runTF {
    $self = shift;
    my %tests = ();
    $ENV{'PATH'}        = $self->{'path'};
    $ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
    $ENV{'INSTROOT'}    = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}   = $self->{'testdir'};
    $ENV{'TESTROOT'}    = $self->{'testdir'};
    $ENV{'SAPDBSDK'}    = $self->{'dbroot'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'version'};
    $ENV{'TMP'}         = $self->{'tempdir'};
    $ENV{'TEMP'}        = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);

    my $testlist;
    if ($self->{'profile'} eq "weekend") {
        $testlist = $self->{'qah'}->{weekendtests};
    }
    else {
        $testlist = $self->{'qah'}->{worktests};
    }

    foreach my $x (@$testlist) {
        $tests{$x} = $self->{'qah'}->{'testnames'}->{$x};
    }

    $myNameAppend = substr($self->{'version'}, 0, 2) . substr($self->{'version'}, 3, 1) . substr($self->{'status'}, 0, 1);

    while (($key, $value) = each(%tests)) {
        $tests{$key} = $value . $myNameAppend;
    }

    my @testq = keys(%tests);


    if ($options{'verbose'}) {
        print "The following tests will be performed:\n\n";
        foreach $x (@testq) {
            print "$x\t (Testname = ${tests{$x}})\n";
        }
    }

    $self->{'qah'}->update_columns({'IDOBJSTATUS' => 2000});  ## START OF TESTING
    foreach $x (@testq) {
        $cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -bits $self->{'bits'} -scheduled -monitor -MAKEKEY $self->{'qah'}->{'ID'}  -QA $self->{'status'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{'qah'}->{'CHANGELIST'} -d $tests{$x} $x \n");
        &doCmd($self, $cmd);
    }

    $self->{'qah'}->update_columns({'IDOBJSTATUS' => 3000});  ## END OF TESTING
    return $self->{qah}->check_lcok();
}

#
# This Method is for performing only a single test-sequence (mostly for debug-purposes)
sub run_single_test {
    $self = shift;
    $testname = shift;

    $ENV{'PATH'}         = $self->{'path'};
    $ENV{'HOME'}         = $self->{'tempdir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}   = $self->{'jtest_root'};
    $ENV{'INSTROOT'}     = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}    = $self->{'testdir'};
    $ENV{'TESTROOT'}     = $self->{'testdir'};
    $ENV{'SAPDBSDK'}     = $self->{'dbroot'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'version'};
    $ENV{'TMP'}          = $self->{'tempdir'};
    $ENV{'TEMP'}         = $self->{'tempdir'};

    my %tests            = ();

    $tests{"$testname"} = $self->{'qah'}->{'testnames'}->{$testname};


    $myNameAppend = substr($self->{'version'}, 0, 2) . substr($self->{'version'}, 3, 1) . substr($self->{'status'}, 0, 1);
    while (($key, $value) = each(%tests)) {
         $tests{$key} = $value . $myNameAppend;
    }

    my @testq = keys(%tests);

    if ($options{'verbose'}) {
        print "The following tests will be performed:\n\n";
        foreach $x (@testq) {
            print "$x\t (Testname = ${tests{$x}})\n";
        }
    }

    foreach $x (@testq) {
        $cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -bits $self->{'bits'} -scheduled -monitor -QA $self->{'status'} -MAKEKEY $self->{'qah'}->{'ID'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{qah}->{'CHANGELIST'} -d $tests{$x} $x \n");
        &doCmd($self, $cmd);
    }
    return $self->{qah}->check_lcok();
}

sub run_lowtrack {
    # For letting the SUT run parallel
    $self = shift;
    $ENV{'PATH'}        = $self->{'path'};
    $ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
    $ENV{'INSTROOT'}    = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}   = $self->{'testdir'};
    $ENV{'TESTROOT'}    = $self->{'testdir'};
    $ENV{'SAPDBSDK'}    = $self->{'dbroot'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'version'};
    $ENV{'TMP'}         = $self->{'tempdir'};
    $ENV{'TEMP'}        = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);

    my %tests = ();

    my $testlist;
    if ($self->{'profile'} eq "weekend") {
        $testlist = $self->{'qah'}->{'lowtests_we'};
    }
    else {
        $testlist = $self->{'qah'}->{'lowtests'};
    }

    foreach my $x (@$testlist) {
        $tests{$x} = $self->{'qah'}->{'testnames'}->{$x};
    }


    $myNameAppend = substr($self->{'version'}, 0, 2) . substr($self->{'version'}, 3, 1) . substr($self->{'status'}, 0, 1);

    while (($key, $value) = each(%tests)) {
        $tests{$key} = $value . $myNameAppend;
    }

    my @testq = my @testq = keys(%tests);;
    #foreach $x (sort(keys(%tests))) {
    #   $tmp =  substr($x, 1, 1000);
    #   push(@testq, $tmp);
    #   $tests{$tmp} = $tests{$x};
    #}


    if ($options{'verbose'}) {
        print "The following tests will be performed:\n\n";
        foreach $x (@testq) {
            print "$x\t (Testname = ${tests{$x}})\n";
        }
    }

    # Paralell running tests should run in reverted sequences for avoiding
    # lock-problems with conflicting tests (this is mainly done for the
    # oltptest-sequence)

    foreach $x (@testq) {
        $cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -bits $self->{'bits'} -scheduled -monitor -QA $self->{'status'} -MAKEKEY $self->{'qah'}->{'ID'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{qah}->{'CHANGELIST'} -d $tests{$x} $x \n");
        &doCmd($self, $cmd);
    }
    return $self->{qah}->check_lcok();
}

#
# Helpers
#

sub doCmd {
    my $self    = shift;
    $kommando = pop(@_);
    my $rc      = 0;
    my $sig     = 0;
    my $core    = 0;

    my $outbuf = "CMD: \r\n $kommando \r\n";

    if ($options{'verbose'}) {
        print ($kommando . "\n");
    }

    if (!($self->{'dry'})) {

        $outbuf .= `$kommando`;
        $rc = ($? >> 8);    # Evaluate return code by dividing by 256
        $signum = ($? & 127);   # get the signal caused the program to abort
        $core = ($? & 128); # get any core errors, if exist

        if (length($outbuf) < 1000) {
            $self->{qah}->write_log($outbuf);
        }
        else {
            if (length($kommando) > 299) {
                $kommando = substr($kommando, 0, 290) . "...";
            }

            $self->{qah}->write_prot("p" . $self->{'prot_count'} . $$, $outbuf, $kommando);
            $self->{'prot_count'}++;
        }
        if ($self->{qah}->{error_code} != 0) {
            print "Error in output-handling of $kommando \nI will ignore it.\nOutput:\n$outbuf";
            $self->{qah}->{error_code} = 0;
        }
    }

    return wantarray ? ($rc, $sig, $core, $outbuf) : $rc;
}

##################################################################
# get_free_FH
#
# A 'bit dirty version' to get a unique filename for output.
##################################################################
sub get_free_FH
{
  my $count = 1;
  my $outstr = $count . ".out";

  while (-e $outstr)
  {
    $count ++;
    $outstr = $count . ".out";
  }

  return $outstr;
}

##################################################################
# send_error
#
# Reports an error via email and updates the status in qadb
##################################################################
sub send_error
{
    my $self = shift;
    my ($errcode, $rc, $sig, $core, $errstr, $outstr) = @_;

    my $smtp = Net::SMTP->new("mail.sap-ag.de");
    $smtp->mail("remuser\@$self->{'hostname'}.wdf.sap-ag.de");
    $smtp->to("falko.flessner\@sap.com", "ulrich.jansen\@sap.com");
    $smtp->data();
    #$smtp->datasend("To: falko.flessner\@sap.com; ulrich.jansen\@sap.com\n");
    $smtp->datasend("Subject: $self->{'hostname'} / TESTDB Error - $errstr ($errcode)\n");
    #$smtp->datasend("Priority: Urgent\nX-Priority: 1 (Highest)\n");
    $smtp->datasend("\n");
    $smtp->datasend("Platform      : $self->{'hostname'}\n");
    $smtp->datasend("Time          : " . (scalar localtime) . "\n\n");
    $smtp->datasend("Error Code    : $errcode\n\n");
    $smtp->datasend("Error Text    : $errstr\n\n");
    $smtp->datasend("Return Code   : $rc\n");
    $smtp->datasend("Signal cought : $sig (1=Yes, 0=No)\n");
    $smtp->datasend("Core error    : $core (1=Yes, 0=No)\n");
    $smtp->datasend("HTML Link     : http://pgwdf160:1081/TestMonitor/Make_Details.jsp?id=$self->{qah}->{ID}\n\n");
    $smtp->datasend("Original program output:\n\n");
    $smtp->datasend("$outstr\n");
    $smtp->dataend();
    $smtp->quit();

    $self->{qah}->update_columns({"IDOBJSTATUS" => "$errcode"});
    $self->{qah}->write_log("$errstr RC=$rc SIG=$sig CORE=$core");
}

sub throw_err {
  my $errortext = shift;
  #my $smtp = Net::SMTP->new("mail.sap-ag.de");
  #$smtp->mail("remuser\@is0025.wdf.sap-ag.de");
  #$smtp->to("falko.flessner\@sap.com");
  #$smtp->data();
  #$smtp->datasend("To: falko.flessner\@sap.com\n");
  #$smtp->datasend("Subject: Error during qadb-run \n");
    #$smtp->datasend("Priority: Urgent\nX-Priority: 1 (Highest)\n");
  #$smtp->datasend("\n");
  #$smtp->datasend($errortext);
  #$smtp->dataend();
  #$smtp->quit;
  print $errortext;
  return $errortext;
}

# parameter: file with full path or directory with "/" at the end
sub checkdir
{
    local $path = shift;
    # convert \ to /
    $path =~ s/\\/\//g;
    if ($path =~ /^(.*)\/[^\/]*$/)
    {
        unless ( -d "$1" )
        {
            mkpath("$1", 0775) || throw_err "can't mkdir $path : $!";
        }
    }
}



__END__

=head1 NAME

testdb - A perl module for testing SAP DB/liveCache-builds on preconfigured
testmachines.

=head1 NOTE

This module is intended for internal use only.
Although it is free software, it won't be very usefull for the wide world

=head1 CONSTRUCTOR

 use testdb;
 $tdh =  testdb->new({'version' => '7404', 'status' => 'DEV', 'profile' => 'weekend'}) ;

 if ($tdh->{error_code}) {
    print "Error:\n$tdh->{error_text}\n";
    return -1;
 }

=head1 DESCRIPTION

The C<testdb> class is a abstraction of the Tests in the SAP-internal QA-System
for SAP DB and liveCache.

With C<testdb>, you can clean up the system, install the latest makes, install all
compononts required for testing execute the tests.

=over 4

=item Prepare for the

A couple of informations are required to create a new entry. Following
the perl standards, the constructor of the class is named C<new>. It
requires a hash-reference with the following entries:

  Name          Description                   Example value

 version       4-digit Version              '7402'
 status        The quality-status           'DEV'
 profile       The test-profile             'workday' or 'weekend'

For AIX-Machines, the aditional "PLATFORM"-entry is required. This is
necssary becase the perl-interpreter does not make a difference between
AIX 4.x and AIX 5.x as we do it.

Currently, the followning values are accepted for PLATFORM:

    - sun_64
    - alphaosf
        - rs6000_51_64
    - rs6000_64
    - hp_64

Please keep in mind that a C<qadb>-instance normaly contains a variable
called C<ID> (you can access it with B<$qah-E<gt>{'ID'}>. This C<ID> identifies
a make-entry and will be needed later. So, I suggest to write this C<ID>
to the harddisk.

=back

=head1 METHODS

C<qadb> provides the following methods:

=over 4

=item $rv = update_columns({name1 => value1, ... , nameN => valueN});

Performs a update-statement on the main table. This should only be used
for updating IDOBJSTATUS, LCPOOLID, LC_OK and LCOK_TRANS.

It takes a hash-reference as arguement, filled with columnnames and the
corresponing values.

The "VARIABLES"-Section of this manual contains a complete description of all
fields.

Returns 0 on success.

=item $rv = write_log($log_text);

This adds a comment to the entry. The log-Text must not contain more than
1000 characters.

Returns 0 on success.

=item $rv = write_prot($prot_name, $prot  [, $info_text]);

Writes a protocoll to the WebDAV-server and creates a entry in the
appropriate table in the database.

It takes a protocolname, the protocol itself and a optional info text as
arguments.

If the info text is not provieded, the protocolname will be used for it.

Returns 0 on success.

=item $rv = unlock();

Releases the current DB-Connection, but don't forget about the Values.

This becomes necessary when the program forkes. See B<lock> for
further informations

Returns 0 on success.

=item $qah = lock();

Re-Creates the DB-Connection. This becomes necessary after performing
an B<unlock> in forking situations.

B<TAKE CARE:> this method will return a new instance. Overwrite the current one
with it. The following example will give you an idea how to do this:

   $qah->unlock();
   $pid = fork();
   $qah = $qah->lock();

   if ($pid) {
       #
       # go on here


=back

=head1 VARIABLES

C<qadb> contains the following variables. Variables corresponding with
fields in the database are marked with a X.

Please note that B<IDQASTATUS> and B<IDPLATFORM> differ from the
parameters B<QASTATUS> and B<PLATFORM> for the C<new>-constructor. The values stored in the
database are simple numeric representations of their alphanumeric
assignments. These assignments are stored in the tables B<PLATFORMS>
and B<QASTATUS>.

  Name         DB-Variable       Description

 ID                X            Identifies the complete build-process
 LCPOOLID          X            The number in the LC_POOL-directory
 VERSION           X            A four-digit version, eg. "7402"
 BUILDPFX          X            A two-digit buildprefix, eg. "05"
 IDPLATFORM        X            The numeric id of the platform
 IDQASTATUS        X            The numeric id if the QA-status
 IDOBJSTATUS       X            The numeric id of the make-status
 CHANGELIST        X            The Changelist-number
 TS                X            The timestamp of the last modification
 LCOK              X            Will be set when the tests are finished
                                successfully.
 LCOK_TRANS        X            Will be set after the LCOK-bit is
                                transfered into the appropriate structures
                in the filesystem.
 HISTCOUNT         X            Counts the number of changes in on these
                                informations. Will be updated automaticaly.
 error_code                     Conains the last error code set. After
                                successfull opterations it will be set to
                0.
 error_text                     Contains a human-readable description of
                                the last error.

=head1 ERROR HANDLING

Beneath the already introduced variables B<error_code> and B<error_text>
for error handling, a email will be sent in each case of a detected error.

The recipients of these Mails are currently hard-coded.

=head1 DBI INSTANCE

C<qadb> contains a ready-to-use DBI instance. It can be accessed by
B<$qah-E<gt>{dbh}>. Please use this with extreme care and use it
only if you can not avoid it.

The DBI documentation describes it in depth.

=head1 EXAMPLE

 use qadb;
 my $qah =  qadb->new({'VERSION' => '7403',
    'BUILDPFX'   => '07',
    'QASTATUS'   => 'DEV',
    'CHANGELIST' => '12345'}) ;

 if ($qah->{error_code} != 0) {
    print "Fehler:\n$qah->{error_text}\n";
    return -1;
 }

 if ($qah->update_columns({'LCPOOLID' => '012'}) != 0 ) {
     print "Error while update:\n$qah->{error_text}\n";
     return -1;
 }

 if ($qah->write_log("Hallo Welt, dies ist ein Test")) {
     print "Error while writing a log:\n$qah->{error_text}\n";
     return -1;
 }

 my $protocol = "";
 open (PROTOFILE, "/path/to/protocol") or die "Error reading protocol\n";

 while (<PROTOFILE>) {
     $protocol .= $_;
 }

 if ($qah->write_prot("make.log", $protocol, "This protocol contains the make-output.\n")) {
     print "Error while writing protocol make.log:\n$qah->{error_text}\n";
 }

=head1 COPYRIGHT

Copyright 2002 SAP AG

=cut


