/* @(#) $Id: //bas/46D/src/include/sapuc.h#11 $ SAP*/
/*eric*/
#ifndef SAPUC_H
#define SAPUC_H "$Id: //bas/46D/src/include/sapuc.h#11 $"
/*******************************************************************************
 * (c) Copyright (c) 2004 SAP AG Walldorf, 1996 - 1998
 *
 *
 *              SSSS   AAA   PPPP          U   U   CCCC
 *             S      A   A  P   P         U   U  C
 *              SSS   AAAAA  PPPP          U   U  C
 *                 S  A   A  P             U   U  C
 *             SSSS   A   A  P      =====   UUU    CCCC
 *
 *
 * This is one of the central include files which should be included by all
 * SAP sources.
 *
 * Implementation of the system function interface for the R/3 Unicode kernel.
 * The functions declared here are to replace those system functions which
 * handle variables of type char. The coding of the external functions is in
 * nlsui?.c, ? = 1, 2, 3, ... 
 * Unicode specific behavior of the functions is documented in nlsui1.c .
 *
 * Requirements (Version of C runtime library etc.): see nlsui1.c
 *
 ******************************************************************************/

/*-HISTORY--------------------------------------------------------------
 * #61
 * 12.08.2000 meb      fix _splitpathU for NT (macro parameters swapped)
 * #60
 * 16.02.2000 meb      add _splitpathU for NT
 * #58
 * 05.01.2000 bs       ccQ treats mem..U() macros as functions 
 * 30.11.1999 bs       introduce SAPccQ preprocessor flag 
 * #54
 * 09.11.1999 meb      solve problems with U functions isascii, chdir, exec...
 *                     isascii: declare a prototype for ccQ on NT
 *                     chdir: declare chdirU additionally to _chdirU
 *                     exec... declare for NT
 *                     map getoptU in Unicode case on NT to an external
 *                     function like on other platforms
 *                     remove old separate ccQ part for ccQ version before 2.3
 * #51
 * 27.10.1999 meb      define _XOPEN_SOURCE always with a numeric value
 * 20.10.1999 bs       #undef SAP_UC_is_4B for ccQ 
 * 06.10.1999 ub       environU for OS400 ASCII (Non-Unicode case)
 * #47
 * 24.09.1999 meb      avoid ccQ warning because of sapuc.h macros
 *                     replace char* in single byte branches with SAP_CHAR
 *                     use special ccQ definition for main, setvbufU
 * #46
 * 21.09.1999 meb      use PATH_MAX only if it is defined
 *                     use dummy definition for fgetsR for all ccQ versions
 * #45
 * 21.09.1999 meb      map SAP_UC_is_4B to SAP_UC_is_2B for all ccQ versions
 * #44
 * 08.09.1999 meb      add getpassU
 * #43
 * 08.09.1999 meb      begining with ccQ version 2.3.0 use same defintions for
 *                     normale compiler and ccQ
 * #40
 * 27.08.1999 meb      define sizeofR/U as sizeofccQ not as (size_t)4 when ccQ
 *                     is running to enable correct compile time compilations
 * #38
 * 09.08.1999 meb      remove #include <netdb.h> for SunOS
 *                     it is not needed and causes ccQ compiler errors on
 *                     SunOS 5.6 if only _POSIX_SOURCE is defined
 * #37 
 * 06.08.1999 bs       #include "ntport.h" always (undo change #32)
 * #34
 * 19.07.1999 meb      fix forward declaration for struct DIR on NT
 *                     the underlying struct is named _DIR
 * #32
 * 15.07.1999 bs       #include "ntport.h" only if not C++; otherwise it is
 *                     enough to declare struct DIR;
 * #30
 * 18.06.1999 bs       SAPccU: p and u mode of ccU now see the same code
 *                     some str..U() functions names now usable as function  ptr
 * 14.05.1999 HJL      What string for unicode object file identification 
 *                     inserted.
 * #27
 * 15.04.1999 bs       #include <wchar.h> on NT also in case of C++ compilation
 * #19
 * 31.03.1999 bs       #undef for all function names in SAPccU section 
 * #18
 * 29.03.1999 bs       xdr_stringU: enable on HP-UX 11
 * #15
 * 19.03.1999 bs       #define SAP_UC_is_2B and similar switches for 
 *                     internal use of ccU even if SAP_UC is 4 bytes long
 * #8
 * 18.02.1999 bs       always include <stdarg.h> in the Unicode case
 *-
 * 05.02.1999 tk       some corrections for AS/400
 *-
 * 28.11.1998 tk, fs   Functions for SAP_UC_is_UTF16_without_wchar added.
 *                     Support for Unicode on SUN.
 *                     HP_UX switch _INCLUDE_POSIX_SOURCE not necessary for
 *                     each Unicode compilation.
 *-
 * 24.11.1998 mit      SAP_E8 is "char" on OS/400 and "unsigned char" elsewhere.
 *            /else/   mainO4 enhanced.
 *-
 * 16.11.1998 mit      Move alternative character types from sapuc2.h to
 *                     sapuc.h . Now they can be used in other include
 *                     files for prototypes or field definitions.
 *                     For using data of these types, you still have to
 *                     include sapuc2.h .
 *-20.70
 * 09.10.98 ub         types in prototypes changed from wchar_t to
 *                     SAP_UC and SAP_CHAR;
 *                     Preprocessor switch SAP_UC_is_UTF16_without_wchar
 *                     introduced
 *-20.61
 * 22.09.98 js         main4U renamed to mainO4, static function removed
 * 16.09.98 bs         struct groupU, getgrdgid
 * 10.09.98 js         main4U - only for AS/400 command processing programs
 * 06.08.98 bs         return type of mem..U() is always SAP_UC*, not sometimes
 *                     void *. Three new function names on NT
 *-20.51
 * 23.07.98 bs         remove parentheses from some macro definitions: enable
 *                     usage in function pointers
 *-20.50
 * 23.06.98 ub         getoptU
 *-20.49
 * 05.06.98 ub         basic support for HP_UX
 *-20.48
 * 22.05.98 ub         fwriteU, freadU, putcharU, getcharU
 *-20.47
 *-20.46
 * 11.05.98 ub         mainU, main3U, environment
 *          bs         introduce preprocessor switch SAPccU
 *-20.45
 *          ub         printf, scanf, put, get family for NT and DEC OSF1.
 *                     Type WINT_T introduced as return type / argument
 *                     type of fgetcU, fputcU, tolowerU, toupperU,
 *                     isalnum,  ..., isxdigit.
 *-20.43
 * 10.03.98 bs         typedef of SAP_UC and some Unicode preprocessor
 *                     switches moved to saptypeb.h
 *-20.42
 * 04.03.98 ub         printf, scanf, putc, getc, puts, gets etc.
 *                     reorganized; implemented for AIX.
 *
 *          on         SAPonOS400
 *-20.41
 * 21.01.98 bs         enabled double inclusion of sapuc.h
 *-20.40
 * 20.01.98 bs         removed all SAPuses... switches
 *                     started re-implementation of prinf-like functions
 *                     according to the new specification
 *                     made the Unicode case compilable: no more #error for
 *                     missing functions, but dummy implementations in rscpw1.c
 *-20.39
 * 08.01.98 bs         preconversion to unsigned char will not take place:
 *                     remove SAPwithUCHAR and SAPwithSTDC_CHAR and all
 *                     casts to char* or SAP_UC*
 *                     remove also UNS_CH and the ..T() macros
 *-20.38
 * 17.12.97 bs         more parentheses: (SAP_UC*)f(x) -> ((SAP_UC*)f(x))
 *-20.35
 * 15.12.97 bs         treat functions for SAPonOS2_2x from o2port.h
 *                     like system functions
 *                     introduced precompiler switch SAPwithSTDC_CHAR
 *-20.34
 * 11.12.97 bs         Parentheses in macro definitions for all parameters
 *                     which are cast: (char*)s -> (char*)(s)
 *-20.32
 * 09.12.97 bs         sapuc3.h merged into sapuc.h; new preprocessor
 *                     switches: SAPuses... for the use of U-structures
 *-20.31
 * 03.12.97 bs         added U-macros and T-macros for the snc interface
 *-20.28
 * 26.11.97 bs         Casts in the ...U() -macros for the non-Unicode Kernel.
 *                     New type UNS_CH and new macros ...T() added.
 *                     They are identical to type SAP_UC and ...U() macros.
 *-20.27
 * 12.11.97 bs         no more double parentheses necessary for U-functions
 *                     with variable parameter list
 *-20.26
 * 11.11.97 bs         struct utsnameU moved from sapuc3.h (back in 20.31)
 *-20.23
 * 10.10.97 bs         macro SCCSID added
 *-20.21
 * 20.09.97 bs         SAPwithUCHAR added: typedef unsigned char SAP_UC
 *-20.19
 * 03.06.97 bs         I/O streams now handle always UCS2 Little Endian
 *                     Added mblenU(), redefinition of MB_CUR_MAX, etc.
 *                     Reorganized derived preprocessor switches
 *-20.18
 * 29.05.1997 mit      SAP_RAW moved to satypeb.h
 *-20.16
 * 07.05.97 bs         NT port for the case SAPwithUNICODE
 *-20.15
 * 16.04.97 bs         added macros memcpyR(), memsetR() etc.
 *-20.13
 * 07.03.97 bs         more new functions added
 *-20.10
 * 27.01.97 B. Schilling (bs)
 *                     Completely new coding; new naming convention:
 *                       system function      SAP function
 *                          name()        ->    nameU()
 *                     many new functions
 *-20.8
 * 21.08.1996 mit      Change the compilation default for real Unicode
 *                     support from 'on' to 'off'.
 *                     To switch it on again define SAPwithUNICODE.
 *                     i.e. cc -DSAPwithUNICODE +w1 -c ...
 *-20.7
 * 15.08.1996 Thomas Rastetter
 *                     With Visual-C releases after 4.1 Microsoft has
 *                     inserted some C++ into "wchar.h" which breaks
 *                     the current projects.
 *                     Intermediate solution: Do not include "wchar.h"
 *                     in case of C++ compilation.
 *-20.6
 * 02.08.1996 wfg      Add SAPonOpenVMS (includes SAPonVMS, -VAX, -AXP)
 *-20.5
 * 31.07.1996 mori     Add SAPonOS400
 *-20.4
 * 30.07.1996 mit      Add SAPonOS2_2x, SAPonWINDOWS, SAPonApple
 *-20.3
 * 15.07.1996 mit      Add SAPonRS6000 and SAPonSUN
 *-20.2
 * 12.07.1996 mit..... First implementation. BINK092268
 *-END-HISTORY----------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 * sapuc.h  - compilation switches
 *
 *  There are some compilations switches which have to be derived
 *  from the global switch SAPwithUNICODE and platform switches.
 *  For every platform that supports Unicode,  the following switches must
 *  be set:
 *
 *   SAP_UC_is_1B   or  SAP_UC_is_wchar  or  SAP_UC_is_UTF16_without_wchar
 *
 *                   WCHAR_is_UCS2 or WCHAR_is_UTF16 or WCHAR_is_UCS4
 *
 *  The decision between SAP_UC_is_1B or not is made in saptypeb.h
 *  already.
 *----------------------------------------------------------------------------*/
#if defined (SAP_UC_is_wchar)

  #if defined(SAPonNT)
    #define WCHAR_is_UCS2

  #elif defined(SAPonOS400)
    #define WCHAR_is_UCS2

  #elif defined(SAPonAIX)
    #define WCHAR_is_UCS2

  #elif defined(SAPonOSF1)          /*     XXX? */
    #define WCHAR_is_UCS4

  #elif defined(SAPonHP_UX)         /*     XXX? */
    #define WCHAR_is_UCS4

  #elif defined(SAPonSUN)           /*     XXX? */
    #define WCHAR_is_UCS4

  #else
    #error "Unicode on this platform not yet implemented"

  #endif /* different platforms */

#endif /* SAP_UC_is_wchar */

/*-----------------------------------------------------------------------------
 * sapuc.h   - check compilation switches
 *
 * The case           #if defined(SAP_UC_is_1B)
 * is identical to    #if !defined(SAPwithUNICODE)
 *
 * The Unicode implementation is currently based on the type 
 * --  wchar_t     if (sizeof(wchar_t)==2)
 * --  wchar_t     if (sizeof(wchar_t)==4)  and  SAP_UC_is_wchar
 * -- unsigned short    if (sizeof(wchar_t)==4) 
 *                         and SAP_UC_is_UTF16_without_wchar
 *                         and SAP_UC is defined as unsigned short
 * --  wchar_t     if (sizeof(wchar_t)==4)  
 *                         and SAP_UC_is_UTF16_without_wchar
 *                         and SAP_UC is defined as wchar_t ; this
 *                         is for temporary testing only. 
 *
 *
 * SAP_UC_is_wchar or SAP_UC_is_UTF16_without_wchar
 * are defined in saptypeb.h .
 * 
 * In sapuc.h we distinguish as follows:
 *
 * #ifndef SAPwithUNICODE
 *         ... /o    No Unicode   o/
 * #else
 *             /o    Unicode U-functions that are independent of
 *                   the definition of SAP_UC      o/
 *   #if defined(SAP_UC_is_wchar) 
 *             /o    Unicode U-functions or macros that use wchar_t       o/
 *   #elif defined(SAP_UC_is_UTF16_without_wchar)
 *             /o    Unicode U-functions that are necessary in the case 
 *                   that SAP_UC is not wchar_t                           o/
 *   #endif
 * #endif
 *
 *
 * Source coding that depends on SAPwithUNICODE but not on the implementation
 * of Unicode should look like:
 *
 * #if defined(SAPwithUNICODE)
 *         ...
 * #else
 *         ...
 * #endif
 *
 *----------------------------------------------------------------------------*/
#if defined(SAPwithUNICODE)

  #if defined(SAP_UC_is_wchar)  

    #if !defined(WCHAR_is_UCS2) && !defined(WCHAR_is_UTF16) \
       && !defined(WCHAR_is_UCS4)
      #error "WCHAR_is_?  is not defined"

    #elif !defined(SAPwithINT_BIGENDIAN) && !defined(SAPwithINT_LITTLEENDIAN)
      #error "SAPwithINT_LITTLEENDIAN/BIGENDIAN)__is_not_defined"

    #endif

  #elif defined(SAP_UC_is_UTF16_without_wchar)
          /* Some checks may be inserted here            XXX? */

  #else  

    #error "Which type shall I use for Unicode?"

  #endif  /* SAP_UC_is_? */

#else /* not SAPwithUNICODE */

  #if !defined(SAP_UC_is_1B)

    #error "SAP_UC_is_1B  not defined"

  #endif

#endif  /* SAPwithUNICODE or not */


/*-----------------------------------------------------------------------------
 * sapuc.h   -   derive further compilation switches for convenience
 *
 *  Length of Unicode in bytes:     Little endian or big endian byte order:
 *
 *   SAP_UC_is_2B, SAP_UC_is_4B      SAP_UC_is_2B_L, SAP_UC_is_4B_B  etc.
 *
 *  What kind of Unicode is used:
 *
 *   SAP_UC_is_UCS2L    UCS-2, little endian format
 *   SAP_UC_is_UCS4B    UCS-4, big endian format
 *         etc.
 *
 * Remark: Using two bytes is regarded as identical to using either
 * UCS-2 or UTF-16. If it should become necessary to distinguish between
 * UCS-4 and 4-byte UCS2, the following case distinctions must be extended.
 *
 *----------------------------------------------------------------------------*/
#if defined(SAP_UC_is_wchar) 

  #if defined(WCHAR_is_UCS2)

    #define WCHAR_is_2B
    #define SAP_UC_is_2B
    #define SAP_UC_is_UCS2
    #if defined(SAPwithINT_LITTLEENDIAN)
      #define SAP_UC_is_2B_L
      #define SAP_UC_is_UCS2_L
    #else
      #define SAP_UC_is_2B_B
      #define SAP_UC_is_UCS2_B
    #endif

  #elif defined(WCHAR_is_UTF16)

    #define WCHAR_is_2B
    #define SAP_UC_is_2B
    #define SAP_UC_is_UTF16
    #if defined(SAPwithINT_LITTLEENDIAN)
      #define SAP_UC_is_2B_L
      #define SAP_UC_is_UTF16_L
    #else
      #define SAP_UC_is_2B_B
      #define SAP_UC_is_UTF16_B
    #endif

  #elif defined(WCHAR_is_UCS4)

    #define WCHAR_is_4B
    #define SAP_UC_is_4B
    #define SAP_UC_is_UCS4
    #if defined(SAPwithINT_LITTLEENDIAN)
      #define SAP_UC_is_4B_L
      #define SAP_UC_is_UCS4_L
    #else
      #define SAP_UC_is_4B_B
      #define SAP_UC_is_UCS4_B
    #endif

  #endif /* WCHAR_is_? */

#elif defined(SAP_UC_is_UTF16_without_wchar)

    #define SAP_UC_is_2B
    #define SAP_UC_is_UTF16
    #if defined(SAPwithINT_LITTLEENDIAN)
      #define SAP_UC_is_2B_L
      #define SAP_UC_is_UTF16_L
    #else
      #define SAP_UC_is_2B_B
      #define SAP_UC_is_UTF16_B
    #endif

#endif  /* SAP_UC_is_... */

/* 
 * For internal use of ccQ only: 
 * SAPccQ    ccQ is running
 * SAPccUp   converison mode of ccQ is active
 * SAPccUu   Unicode compatibility check mode is active  
 */
#if !defined(SAPccQ) && defined(CCQ_VERSION)
  #define SAPccQ     CCQ_VERSION
#endif
#if defined(SAPccUp) || defined(SAPccUu)
  #define SAPccU            /* obsolescent */
#endif

/*-----------------------------------------------------------------------------
 * sapuc.h   - further includes
 *
 * Via saptype.h most neccessary headers are known, including
 * <limits.h>, <stddef.h>, <stdio.h>, <stdlib.h>, and <string.h>
 *----------------------------------------------------------------------------*/
#include <ctype.h>

#if defined(SAPwithUNICODE) 
  #include <stdarg.h>

  #ifdef SAPonNT
    #include "ntport.h" /* nocheck */
    #include <wchar.h>

  #elif defined(SAPonOS400)	/* wchar.h does not include time.h. */
    #ifndef _POSIX_LOCALE
      #define _POSIX_LOCALE
    #endif
    #include <wchar.h>
    #include <wctype.h>
    #include <dirent.h>
    #include <locale.h>
    #include <ifs.h>
    #include <time.h>
    #include <spawn.h>

  #elif defined(SAPonAIX)
    #ifndef _XOPEN_SOURCE
      #define not_XOPEN_SOURCE
      #define _XOPEN_SOURCE 1
    #endif
    #include <wchar.h>
    #ifdef not_XOPEN_SOURCE
      #undef _XOPEN_SOURCE
      #undef not_XOPEN_SOURCE
    #endif
    #include <dirent.h>

  #elif defined(SAPonOSF1)
    #include <wchar.h>       /* also for SAP_UC_is_UTF16_without_wchar
                              * because we do use iswprint, iswtoupper etc. 
                              */
  #elif defined(SAPonHP_UX)
    #include <wchar.h>
    #include <dirent.h>
    #ifndef _INCLUDE__STDC__
      #define not_INCLUDE__STDC__
      #define _INCLUDE__STDC__
    #endif
    #include <locale.h>     /* this is necessary !        XXX? */
    #ifdef not_INCLUDE__STDC__
      #undef _INCLUDE__STDC__
      #undef not_INCLUDE__STDC__
    #endif
    #if defined(_LOCALE_INCLUDED) && !defined(LC_CTYPE)
      #error "Something went wrong when #including <locale.h>"
    #endif

  #elif defined(SAPonSUN) 
    #include <wchar.h>
    #include <widec.h>
    #include <dirent.h>
    #include <locale.h>

  #else /* other platforms */
    #error "Please edit sapuc.h for this platform"
  #endif /* different platforms */

#endif /* SAPwithUNICODE */


/*-----------------------------------------------------------------------------
 * sapuc.h  -  extern oder extern "C"
 *----------------------------------------------------------------------------*/
#if defined(__cplusplus) && !defined(SAPonOS400)
  #define externC extern "C"
#else
  #define externC extern  
#endif  


/*-----------------------------------------------------------------------------
 * sapuc.h  -  Return type of fgetcU
 *----------------------------------------------------------------------------*/
/* We want that the following code works:
 *   int c;   c = fgetcU(f);   if (c==EOF) ...
 *  Under NT, wchar.h defines:
 *  typedef unsigned short wchar_t;
 *  typedef wchar_t wint_t;
 *  #define WEOF (wint_t)(0xFFFF)
 *  Now  WEOF != EOF !!!         We don't like this.
 *  So we use WINT_T and WINT_EOF instead.
 *  Outside sapuc.h and nlsui1.c it is not necessary to use WINT_T .
 */
#if defined(SAPwithUNICODE) && !defined(NLSUI_WINT_T)
                /* also for SAP_UC_is_UTF16_without_wchar */
  #define NLSUI_WINT_T
  #if defined(SAPonNT)
    typedef int WINT_T;
    #define WINT_EOF (-1)
                      /* Now WINT_EOF == EOF */
  #elif defined(SAPonAIX)   || defined(SAPonOSF1) \
     || defined(SAPonHP_UX) || defined(SAPonOS400)\
     || defined(SAPonSUN)
    typedef wint_t WINT_T;
    #define WINT_EOF WEOF
  #else
    #error "type WINT_T not defined on this platform"
  #endif
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  The SCCSID macro
 *----------------------------------------------------------------------------*/
#define sccsidR   sccsid

#ifndef SAPwithUNICODE
  #define SCCSID  sccsid
  #define sccsidU sccsid     /* nicer name than SCCSID */

#else /* Now SAPwithUNICODE */
  #define SCCSID  ConvertSCCSID_w( sccsid )
  #define sccsidU ConvertSCCSID_w( sccsid )
  externC SAP_UC *ConvertSCCSID_w( const char *sccsid );
#endif

/*-----------------------------------------------------------------------------
 * sapuc.h  -  Conversions between SAP_RAW and "wide bytes"
 *----------------------------------------------------------------------------*/
externC void WideBytetoSAP_RAW( SAP_RAW *rdest,
                                const wchar_t *wsource,
                                size_t len );
externC void SAP_RAWtoWideByte( wchar_t *wdest,
                                const SAP_RAW *rsource,
                                size_t len );


/*-----------------------------------------------------------------------------
 * sapuc.h  -  macros for length calculations
 *----------------------------------------------------------------------------*/

#ifndef SAPwithUNICODE
  #define SAP_UC_LN          (1U)
  #define SAP_UC_SF          (0U)  /* shift factor: logarithm of SAP_UC_LN */
  #define SAP_UC_ALIGN_MASK  (0U)  /* # bits necessary to check alignment  */

#elif defined(SAP_UC_is_2B)
  #define SAP_UC_LN          (2U)
  #define SAP_UC_SF          (1U)
  #define SAP_UC_ALIGN_MASK  (1U)

#elif defined(SAP_UC_is_4B)
  #define SAP_UC_LN          (4U)
  #define SAP_UC_SF          (2U)
  #define SAP_UC_ALIGN_MASK  (3U)

#endif


#ifdef SAPccQ
  #ifdef SAP_UC_is_4B                 /* SAP_UC_is_4B is not implemented  ... */
    #define SAP_UC_is_2B              /* ... in the entire source code        */
    #define SAP_UC_is_UTF16
    #undef SAP_UC_is_4B
    #ifdef SAPwithINT_LITTLEENDIAN
      #define SAP_UC_is_2B_L
      #define SAP_UC_is_UTF16_L
    #else
      #define SAP_UC_is_2B_B
      #define SAP_UC_is_UTF16_B
    #endif 
  #endif
#endif


/* beginning with ccQ Version 2.3.0 use same definitions
 * for normale compiler and ccQ
 * (with some minor differences)
 */
#if defined(SAPccQ) && SAPccQ<230
  #error ccQ version is out of date
#endif



#define sizeofR(par)         sizeof(par)

#ifndef SAPwithUNICODE
  #define sizeofU(par)       sizeof(par)
#else
  #define sizeofU(par)       (sizeofR(par)/sizeofR(SAP_UC))
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  character constants and string constants
 *----------------------------------------------------------------------------*/
#define cR(par)        par

#ifndef SAPwithUNICODE
  #define cU(par)      par
#elif defined (SAP_UC_is_wchar)
  #define cU(par)      cU_HELP(par)   /* if par is a macro, it must be ...    */
  #define cU_HELP(par) L##par         /* ... resolved before the 'L' is added */
#else 
  /* In this case cU is not replaced by the precompiler, but by another tool. */
#endif     


/*-----------------------------------------------------------------------------
 * sapuc.h  - What identifier definition for distinguishing unicode
 *            from non unicode object files. 
 *----------------------------------------------------------------------------*/
#if SAP_RELEASE_NO >= 5010
  #ifdef SAPwithUNICODE
   static SAP_RAW unicodeId[] = cR("@(#)     Unicode");    
  #else                                                           
   static SAP_RAW unicodeId[] = cR("@(#) non-Unicode");    
  #endif                                                          
#endif
 

/*-----------------------------------------------------------------------------
 * sapuc.h  -   Function that counts number of bytes to write
 *----------------------------------------------------------------------------*/

#ifndef SAPwithUNICODE
  #define UcnToFileLenR(data, n)  (n)
#else
  externC size_t UcnToFileLenR( SAP_CHAR *data, size_t n );
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -   Functions that test character properties: is...
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define isalnumU(c)        isalnum(c)
  #define isasciiU(c)        isascii(c)
  #define isalphaU(c)        isalpha(c)
  #define iscntrlU(c)        iscntrl(c)
  #define isdigitU(c)        isdigit(c)
  #define isgraphU(c)        isgraph(c)
  #define islowerU(c)        islower(c)
  #define isprintU(c)        isprint(c)
  #define ispunctU(c)        ispunct(c)
  #define isspaceU(c)        isspace(c)
  #define isupperU(c)        isupper(c)
  #define isxdigitU(c)       isxdigit(c)

#else /* Now SAPwithUNICODE */

 #ifdef SAPonNT
    #ifndef NDEBUG
      int isalnumU(WINT_T c);
      int isalphaU(WINT_T c);
      #define isasciiU(c)        isascii(c)
      int iscntrlU(WINT_T c);
      int isdigitU(WINT_T c);
      int islowerU(WINT_T c);
      int isgraphU(WINT_T c);
      int isprintU(WINT_T c);
      int ispunctU(WINT_T c);
      int isspaceU(WINT_T c);
      int isupperU(WINT_T c);
      int isxdigitU(WINT_T c);
    #else
      #define isalnumU(c)        iswalnum((wint_t)(c))
      #define isalphaU(c)        iswalpha((wint_t)(c))
      #define isasciiU(c)        isascii(c)
      #define iscntrlU(c)        iswcntrl((wint_t)(c))
      #define isdigitU(c)        iswdigit((wint_t)(c))
      #define islowerU(c)        iswlower((wint_t)(c))
      #define isgraphU(c)        iswgraph((wint_t)(c))
      #define isprintU(c)        iswprint((wint_t)(c))
      #define ispunctU(c)        iswpunct((wint_t)(c))
      #define isspaceU(c)        iswspace((wint_t)(c))
      #define isupperU(c)        iswupper((wint_t)(c))
      #define isxdigitU(c)       iswxdigit((wint_t)(c))
    #endif
 #else
  /* We use the w-functions even for SAP_UC_is_UTF16_without_wchar */
  #define isalnumU(c)        iswalnum(c)
  #define isalphaU(c)        iswalpha(c)
  #define isasciiU(c)        isascii(c)
  #define iscntrlU(c)        iswcntrl(c)
  #define isdigitU(c)        iswdigit(c)
  #define islowerU(c)        iswlower(c)
  #define isgraphU(c)        iswgraph(c)
  #define isprintU(c)        iswprint(c)
  #define ispunctU(c)        iswpunct(c)
  #define isspaceU(c)        iswspace(c)
  #define isupperU(c)        iswupper(c)
  #define isxdigitU(c)       iswxdigit(c)

 #endif
#endif

/* ccQ requires that if function is a realized as macro
   that there is a real function behind the macro
   this is not the case for isascii on NT
   therefore we declare a prototype ourselves here */
#if defined(SAPccQ) && defined(SAPonNT)
  #undef isascii
  extern int isascii ( int c );
#endif

/*-----------------------------------------------------------------------------
 * sapuc.h  -   toupper and tolower
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define tolowerU(c)        tolower(c)
  #define toupperU(c)        toupper(c)

#else /* Now SAPwithUNICODE */

 #ifdef SAPonNT
    #ifndef NDEBUG
      WINT_T tolowerU(WINT_T c);
      WINT_T toupperU(WINT_T c);
    #else
      #define tolowerU(c)        towlower((wint_t)(c))
      #define toupperU(c)        towupper((wint_t)(c))
    #endif
 #else
    /* We use the w-functions even for SAP_UC_is_UTF16_without_wchar */
  #define tolowerU(c)        towlower(c)
  #define toupperU(c)        towupper(c)
 #endif
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  Functions for string handling:  str...
 *
 * A few ..U() functionnames ar available both as macro and as function.
 * For the use in function pointers, #undef the macro first. 
 *----------------------------------------------------------------------------*/
/* available as function: */
externC SAP_UC *strchrU ( const SAP_UC *, int );
externC int     strcmpU ( const SAP_UC *, const SAP_UC * );
externC SAP_UC *strcpyU (       SAP_UC *, const SAP_UC * );

#ifndef SAPwithUNICODE

  #define strcatU(  s1, s2 )              strcat(  s1, s2 )
  #define strchrU(  s,  c  )              strchr(  s,  c  )
  #define strcmpU(  s1, s2 )              strcmp(  s1, s2 )
  #define strcollU( s1, s2 )              strcoll( s1, s2 )
  #define strcpyU(  s1, s2 )              strcpy(  s1, s2 )
  #define strcspnU( s1, s2 )              strcspn( s1, s2 )
  #ifdef SAPonNT
    #define _strcmpiU(  s1, s2 )          _strcmpi(  s1, s2 )
    #define strcmpiU(   s1, s2 )          _strcmpi(  s1, s2 )
    #define _stricmpU(  s1, s2 )          _stricmp(  s1, s2 )
    #define stricmpU(   s1, s2 )          _stricmp(  s1, s2 )
    #define _strnicmpU( s1, s2, n )       _strnicmp( s1, s2, n )
    #define strnicmpU(  s1, s2, n )       _strnicmp( s1, s2, n )
    #define _strdupU(   s1 )              _strdup( s1 )
    #define strdupU(    s1 )              _strdup( s1 )
  #elif defined(SAPonOS400)
    #if !defined(__EXTENDED__) || !defined(__cplusplus)
      #define strdupU(s1)                 strdup_o4port(s1)
    #else
      #define strdupU(s1)                 strdup(s1)
    #endif
  #else
    #define strdupU(s1)                   strdup(s1)
  #endif
  #define strlenU(s)                      strlen(s)
  #define strncatU( s1, s2, n )           strncat( s1, s2, n )
  #define strncmpU( s1, s2, n )           strncmp( s1, s2, n )
  #define strncpyU( s1, s2, n )           strncpy( s1, s2, n )
  #define strpbrkU( s1, s2 )              strpbrk( s1, s2 )
  #define strrchrU( s,  c )               strrchr( s,  c )
  #define strspnU(  s1, s2 )              strspn(  s1, s2 )
  #define strstrU(  s1, s2 )              strstr(  s1, s2 )
  #define strtodU(  s,  end )             strtod(  s,  end )
  #define strtokU(  s1, s2 )              strtok(  s1, s2 )
  #define strtok_rU(s1, s2 )              strtok_r(s1, s2 )
  #define strtolU(  s,  end, base )       strtol(  s,  end, base )
  #define strtoulU( s,  end, base )       strtoul( s,  end, base )
  #define strxfrmU( s1, s2,  n )          strxfrm( s1, s2,  n )

#else /* Now SAPwithUNICODE */

 #if defined(SAP_UC_is_wchar)
  #define strcatU(  s1, s2 )              wcscat(  s1, s2 )
  #define strchrU(  s,  c  )              wcschr(  s,  c  )
  #define strcmpU(  s1, s2 )              wcscmp(  s1, s2 )
  #define strcollU( s1, s2 )              wcscoll( s1, s2 )
  #define strcpyU(  s1, s2 )              wcscpy(  s1, s2 )
  #define strcspnU( s1, s2 )              wcscspn( s1, s2 )
  #ifdef SAPonNT
    #define _strcmpiU(  s1, s2 )          _wcsicmp(  s1, s2 )
    #define strcmpiU(   s1, s2 )          _wcsicmp(  s1, s2 )
    #define _stricmpU(  s1, s2 )          _wcsicmp(  s1, s2 )
    #define stricmpU(   s1, s2 )          _wcsicmp(  s1, s2 )
    #define _strnicmpU( s1, s2, n )       _wcsnicmp( s1, s2, n )
    #define strnicmpU(  s1, s2, n )       _wcsnicmp( s1, s2, n )
    #define _strdupU(   s1 )              _wcsdup(   s1 )
    #define strdupU(    s1 )              _wcsdup(   s1 )
  #elif defined(SAPonOS400)
    #if !defined(__EXTENDED__) || !defined(__cplusplus)
        #define strdupU(s1)                    strdup_o4port(s1)
    #else
        externC SAP_UC * strdupU(const SAP_UC *);
    #endif
  #else
    externC SAP_UC * strdupU(const SAP_UC *);
  #endif
  #define strlenU(s)                      wcslen(s)
  #define strncatU( s1, s2, n )           wcsncat( s1, s2, n )
  #define strncmpU( s1, s2, n )           wcsncmp( s1, s2, n )
  #define strncpyU( s1, s2, n )           wcsncpy( s1, s2, n )
  #define strpbrkU( s1, s2 )              wcspbrk( s1, s2 )
  #define strrchrU( s1, c  )              wcsrchr( s1, c  )
  #define strspnU(  s1, s2 )              wcsspn(  s1, s2 )
  #define strstrU(  s1, s2 )              wcswcs(  s1, s2 )
  #if defined (SAPonOSF1)
  /* wcstod causes a segmentation fault when trying to convert 1E-37 */
    externC double strtodU( const SAP_UC *, SAP_UC ** );
  #else
    #define strtodU( s, end )             wcstod( s, end )
  #endif
  #if defined(SAPonOS400)  /* third parameter is required for wcstok() */
    externC SAP_UC * strtokU( SAP_UC *, const SAP_UC * );
  #else
    #define strtokU( s1, s2 )             wcstok( s1, s2 )
  #endif
  externC SAP_UC *strtok_rU( SAP_UC *, const SAP_UC *, SAP_UC ** );  
  #define strtolU(  s, end, base )        wcstol(  s, end, base )
  #define strtoulU( s, end, base )        wcstoul( s, end, base )
  #define strxfrmU( s1, s2, n )           wcsxfrm( s1, s2, n )

 #elif defined(SAP_UC_is_UTF16_without_wchar)

  externC SAP_UC *strcatU (       SAP_UC *, const SAP_UC *         );
  externC SAP_UC *strchrU ( const SAP_UC *,       WINT_T           );
  externC int     strcmpU ( const SAP_UC *, const SAP_UC *         ); 
  /* externC int  strcollU( const SAP_UC *, const SAP_UC *        ); */ /*XXX?*/
  externC SAP_UC *strcpyU (       SAP_UC *, const SAP_UC *         );
  externC size_t  strcspnU( const SAP_UC *, const SAP_UC *         );
  externC SAP_UC *strdupU ( const SAP_UC *                         ); /*XXX?*/
  externC size_t  strlenU ( const SAP_UC *                         );
  externC SAP_UC *strncatU(       SAP_UC *, const SAP_UC *, size_t );
  externC int     strncmpU( const SAP_UC *, const SAP_UC *, size_t );
  externC SAP_UC *strncpyU(       SAP_UC *, const SAP_UC *, size_t );
  externC SAP_UC *strpbrkU( const SAP_UC *, const SAP_UC *         );
  externC SAP_UC *strrchrU( const SAP_UC *,       WINT_T           ); 
  externC size_t  strspnU ( const SAP_UC *, const SAP_UC *         );
  externC SAP_UC *strstrU ( const SAP_UC *, const SAP_UC *         );
  externC double  strtodU ( const SAP_UC *,       SAP_UC **        );
  externC SAP_UC *strtokU (       SAP_UC *, const SAP_UC *         );
  externC SAP_UC *strtok_rU(      SAP_UC *, const SAP_UC *, SAP_UC **);  
  externC          long strtolU ( const SAP_UC *, SAP_UC **, int   ); 
  externC unsigned long strtoulU( const SAP_UC *, SAP_UC **, int   );
  /* externC size_t strxfrmU(SAP_UC *, const SAP_UC *, size_t); */    /*XXX?*/
 #endif
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - functions for string handling: conversion to numeric types
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define atoiU(s)                   atoi(s)
  #define atofU(s)                   atof(s)
  #define atolU(s)                   atol(s)

#else  /* Now SAPwithUNICODE */
 #if defined(SAP_UC_is_wchar)

  #define atoiU(s)                   ((int)wcstol(s, (SAP_UC **)0, 10))
  #define atofU(s)                   wcstod(s, (SAP_UC **)0)
  #define atolU(s)                   wcstol(s, (SAP_UC **)0, 10)

 #elif defined(SAP_UC_is_UTF16_without_wchar)

  #define atoiU(s)                   ((int)strtolU(s, (SAP_UC **)0, 10))
  #define atofU(s)                   strtodU(s, (SAP_UC **)0)
  #define atolU(s)                   strtolU(s, (SAP_UC **)0, 10)

 #endif
#endif

/*-----------------------------------------------------------------------------
 * sapuc.h - further functions for string handling
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define getoptU(ac, av, op)        getopt(ac, av, op)
  /* In NT's C runtime lib, there is no getopt.
   * There are several getopt clones in the R/3 sources, and for NT the
   * obove #define is necessary in order to be able to use such a clone
   */
  #define optargU                    optarg

#else /* Now SAPwithUNICODE */

  externC int getoptU(int argc, SAP_UC * const argv[], const SAP_UC * optstr);

  extern SAP_UC *optargU;

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - Memory operations
 *
 * The macros memcmpR(), memcpyR(), memmoveR(), etc. should  be
 * used in those cases where the length parameter counts the number
 * of bytes even in a Unicode system.
 *
 * The ..R function names can be used in function pointer expressions
 * directly as they are defined as macros without parameter list.
 * The ..U function names are available both as macros and functions.
 * Normally the macro is used; if the function name is to be used in a
 * function pointer expression, #undef the macro first.
 * The functions you get then are less perfomant than the macros.
 *----------------------------------------------------------------------------*/
#define mallocR                   malloc
#define reallocR                  realloc
#define callocR                   calloc
#define memcmpR                   memcmp
#define memcpyR                   memcpy
#define memmoveR                  memmove
#define memchrR                   memchr
#define memsetR                   memset
#define bzeroR                    bzero

/* available as function: */
externC SAP_CHAR *mallocU  ( size_t );
externC SAP_CHAR *reallocU (       SAP_CHAR *,                   size_t );
externC SAP_CHAR *callocU  (       size_t,                       size_t );
externC int       memcmpU  ( const SAP_CHAR *, const SAP_CHAR *, size_t );
externC SAP_CHAR *memcpyU  (       SAP_CHAR *, const SAP_CHAR *, size_t );
externC SAP_CHAR *memmoveU (       SAP_CHAR *, const SAP_CHAR *, size_t );
externC SAP_CHAR *memchrU  ( const SAP_CHAR *,       int,        size_t );
externC SAP_CHAR *memsetU  (       SAP_CHAR *,       int,        size_t );

#ifndef SAPwithUNICODE

  #define mallocU( len )           ((SAP_CHAR *)malloc( len ))
  #define reallocU( s,      len )  ((SAP_CHAR *)realloc( s,      len ))
  #define callocU(  number, len )  ((SAP_CHAR *)calloc(  number, len ))
  #define memcmpU(  s1, s2, len )           memcmp(  s1, s2, len )
  #define memcpyU(  s1, s2, len )  ((SAP_CHAR *)memcpy(  s1, s2, len ))
  #define memmoveU( s1, s2, len )  ((SAP_CHAR *)memmove( s1, s2, len ))
  #define memchrU(  s,  c,  len )  ((SAP_CHAR *)memchr(  s, c,   len ))
  #define memsetU(  s,  c,  len )  ((SAP_CHAR *)memset(  s, c,   len ))

  #define bzeroU( s, len )         bzero( s, len )

#else /* Now SAPwithUNICODE */

  #define mallocU(       len )  ((SAP_CHAR *) malloc(       (len)*SAP_UC_LN))
  #define reallocU( s,   len )  ((SAP_CHAR *) realloc( s,   (len)*SAP_UC_LN))
  #define callocU(  num, len )  ((SAP_CHAR *) calloc(  num, (len)*SAP_UC_LN))

  #if defined(SAPonOS400) || defined(SAPonOSF1) || \
     (defined(SAPonNT) && defined(__cplusplus) )
    #if defined(SAP_UC_is_wchar)
      #define memcmpU(  s1, s2, len )  wmemcmp(  s1, s2, len )
      #define memcpyU(  s1, s2, len )  wmemcpy(  s1, s2, len )
      #define memmoveU( s1, s2, len )  wmemmove( s1, s2, len )
      #define memchrU(  s,  wc, len )  wmemchr(  s,  wc, len )
      #define memsetU(  s,  wc, len )  wmemset(  s,  wc, len )
    #elif defined(SAP_UC_is_UTF16_without_wchar)
      #define        memcpyU(  s1, s2, len )              \
         ((SAP_CHAR*)memcpy(   s1, s2, (len)*SAP_UC_LN ))
      #define        memmoveU( s1, s2, len )              \
         ((SAP_CHAR*)memmove(  s1, s2, (len)*SAP_UC_LN ))
    #endif
  #elif defined(SAPonAIX) || defined(SAPonHP_UX) || defined(SAPonSUN) || \
        ( defined(SAPonNT) && !defined(__cplusplus) )
    #define          memcpyU(  s1, s2, len )              \
         ((SAP_CHAR*)memcpy(   s1, s2, (len)*SAP_UC_LN ))
    #define          memmoveU( s1, s2, len )              \
         ((SAP_CHAR*)memmove(  s1, s2, (len)*SAP_UC_LN ))
    /* Some more macros should be added here in order to increase speed */
  #else
    #error "mem...U() functions not yet implemented on this platform"
  #endif /* different platforms */

  #define bzeroU( s, len )             memsetU( s, (WINT_T)0, len )

#endif 

#ifdef SAPccQ
  #undef mallocU
  #undef reallocU
  #undef callocU
  #undef memcpyU
  #undef memmoveU
  #undef memchrU
  #undef memsetU
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - Functions that handle type char pointers (no string handling):
 *          1. functions that pass a type char pointer
 *              to the non-unicode world
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define accessU(path, amode)         access(path, amode)
  #define chdirU(path)                 chdir(path)
  #define fdopenU(filedes, mode)       fdopen(filedes, mode)
  #define fopenU(path, mode)           fopen(path, mode)
  #define fopen64U(path, mode)         fopen64(path, mode)  /* rb002 */
  #define freopenU(path, mode, stream) freopen(path, mode, stream)
  #define gethostnameU(name, len)      gethostname(name, len)
  #define opendirU(path)               opendir(path)
      /* For NT, opendir and readdir are defined in ntport.h, ntuxport.c */
  #ifdef SAPonNT
    #define _openU                     _open
    #define openU                      _open
  #else
    #define openU                      open
  #endif
  #define perrorU(program)             perror(program)
  #define removeU(path)                remove(path)
  #define renameU(from ,to)            rename(from, to)
  #define systemU(s)                   system(s)
  #define strftimeU(s, maxsize, format, tptr) \
          strftime (s, maxsize, format, tptr)

  #ifdef SAPonNT
    #define _utimeU(path, time)         _utime(path, time)
    #define utimeU(path, time)          _utime(path, time)
    #define _mkdirU(path)               _mkdir(path)
    #define _creatU(path, mode)         _creat(path, mode)
    #define creatU(path, mode)          _creat(path, mode)
    #define _chmodU(path, mode)         _chmod(path, mode)
    #define chmodU(path, mode)          _chmod(path, mode)
    #define _popenU(command, type)      _popen(command, type)
    #define popenU(command, type)       _popen(command, type)
    #define _rmdirU(path)               _rmdir(path)
    #define rmdirU(path)                _rmdir(path)
    #define _unlinkU(path)              _unlink(path)
    #define unlinkU(path)               _unlink(path)
  #else
    #define utimeU(path, time)          utime(path, time)
    #define mkdirU(path, mode)          mkdir(path, mode)
    #define mkfifoU(path, mode)         mkfifo(path, mode)
    #define creatU(path, mode)          creat(path, mode)
    #define chmodU(path, mode)          chmod(path, mode)
    #define popenU(command, type)       popen(command, type)
    #define rmdirU(path)                rmdir(path)
    #define unlinkU(path)               unlink(path)
  #endif

  #if defined(SAPonUNIX) || defined(SAPonOS400)
    #define linkU(path1, path2)         link(path1, path2)
    #define symlinkU(path1, path2)      symlink(path1, path2)
    #define readlinkU(path, buf, size)  readlink(path, buf, size)
    #define chownU(path, owner, group)  chown(path, owner, group)
  #endif

  #if defined(SAPonAIX) && defined(_ALL_SOURCE)
    #define loadU(fpath, flags, lpath) load(fpath, flags, lpath)
  #endif 
  #if defined(SAPonHP_UX)
    #define shl_findsymU(handle, sym, type, value) \
                                       shl_findsym(handle, sym, type, value)
    #define shl_loadU(path, fl, addr)  shl_load(path, fl, addr)
  #elif defined(SAPonSUN) || defined(SAPonSINIX) || defined(SAPonOSF1) \
        || defined (SAPonLIN) || defined(SAPonAIX)
    #define dlopenU(path, mode)        dlopen(path, mode)
    #define dlsymU(handle, name)       dlsym(handle, name)
    #define dlerrorU                   dlerror
  #endif


#else  /* Now SAPwithUNICODE */

  #ifndef SAPonOS400
    externC int  accessU  ( const SAP_UC *path,    int  mode );
  #endif
  externC FILE * fdopenU  (       int     filedes, const SAP_UC *type );
  externC FILE * fopenU   ( const SAP_UC *path,    const SAP_UC *mode );
  externC FILE * fopen64U ( const SAP_UC *path,    const SAP_UC *mode ); /* rb002 */
  externC FILE * freopenU ( const SAP_UC *path,    const SAP_UC *mode,
                                 FILE    *stream );
  externC int    gethostnameU(    SAP_UC *name,    size_t len );
  #if !defined(SAPonHP_UX) || \
      (defined(SAPonHP_UX) && defined (_INCLUDE_POSIX_SOURCE))
    externC DIR   *opendirU ( const SAP_UC *path );
  #endif
  externC void   perrorU  ( const SAP_UC *program );
  externC int    removeU  ( const SAP_UC *path );
  externC int    renameU  ( const SAP_UC *from,    const SAP_UC *to );

  #if defined(SAPonNT)
    #define _utimeU(wpath, time)         _wutime(wpath, time)
    #define utimeU(wpath, time)          _wutime(wpath, time)
    #define _chdirU(wpath)               _wchdir(wpath)
    #define chdirU(wpath)                _wchdir(wpath)
    #define _mkdirU(wpath)               _wmkdir(wpath)
    #define _creatU(wpath, mode)         _wcreat(wpath, mode)
    #define creatU(wpath, mode)          _wcreat(wpath, mode)
    #define _chmodU(wpath, mode)         _wchmod(wpath, mode)
    #define chmodU(wpath, mode)          _wchmod(wpath, mode)
    #define _openU                       _wopen
    #define openU                        _wopen
    #define _popenU(wcommand, wtype)     _wpopen(wcommand, wtype)
    #define popenU(wcommand, wtype)      _wpopen(wcommand, wtype)
    #define _rmdirU(wpath)               _wrmdir(wpath)
    #define rmdirU(wpath)                _wrmdir(wpath)
    #define systemU(wcs)                 _wsystem(wcs)
    #define _unlinkU(wpath)              _wunlink(wpath)
    #define unlinkU(wpath)               _wunlink(wpath)
  #else
    #if (!defined (SAPonHP_UX)) || defined (_MODE_T)
      externC int mkdirU( const SAP_UC *wpath, mode_t mode );
      #ifndef SAPonOS400
        externC int mkfifoU(const SAP_UC *wpath, mode_t mode );
      #endif
      externC int chmodU( const SAP_UC *wpath, mode_t mode );
      externC int creatU( const SAP_UC *wpath, mode_t mode );
    #endif
    externC int chdirU( const SAP_UC *wpath );
    #if defined(SAPonAIX) 
      #ifdef _H_UTIME
        externC int utimeU( const SAP_UC *wpath, const struct utimbuf *time );
      #endif
    #elif defined (SAPonHP_UX)
      #ifdef _UTIME_INCLUDED
        externC int utimeU( const SAP_UC *wpath, const struct utimbuf *time );
      #endif
    #elif defined (SAPonOSF1)
      #ifdef _UTIME_H_
        externC int utimeU( const SAP_UC *wpath, const struct utimbuf *time );
      #endif
    #elif defined (SAPonSUN)
      #ifdef _UTIME_H
        externC int utimeU( const SAP_UC *wpath, const struct utimbuf *time );
      #endif
    #elif defined (SAPonOS400)
      #ifdef __utime_h
        externC int utimeU( const SAP_UC *wpath, const struct utimbuf *time );
      #endif
    #endif
    externC int openU ( const SAP_UC *wpath, int oflag, ... );
    #if defined(SAPonOS400)
      #define popenU(command, type)       popen(command, type)
    #else
      externC FILE *popenU( const SAP_UC *wcomm, const SAP_UC *wtype );
    #endif
    externC int rmdirU  ( const SAP_UC *wpath );
    externC int systemU ( const SAP_UC *wcs );
    externC int unlinkU ( const SAP_UC *path );
  #endif

  #if defined(SAPonNT) || defined(SAPonOS400)
    #define strftimeU(s, maxs, format, tptr) wcsftime(s, maxs, format, tptr)
  #elif defined(SAPonAIX)
    #ifdef _H_TIME /* <time.h> must be included for struct tm */
      externC size_t strftimeU( SAP_UC *wcs, size_t len, const SAP_UC *format, 
                                const struct tm *tmdate );
    #endif
  #elif defined(SAPonOSF1)
    #ifdef _TIME_H_ /* <time.h> must be included for struct tm */
      externC size_t strftimeU( SAP_UC *wcs, size_t len, const SAP_UC *format, 
                                const struct tm *tmdate );
    /* Depending on compiler switches, there are different wcsftime
     * prototypes in wchar.h;  for now: same treatment as on AIX.   XXX?
     */
    #endif
  #elif defined(SAPonHP_UX)
    #ifdef _TIME_INCLUDED  /* <time.h> must be included for struct tm */
      externC size_t strftimeU( SAP_UC *wcs, size_t len, const SAP_UC *format, 
                                const struct tm *tmdate );
    #endif
  #elif defined(SAPonSUN)
    #ifdef _TIME_H /* <time.h> must be included for struct tm */
      externC size_t strftimeU( SAP_UC *wcs, size_t len, const SAP_UC *format, 
                                const struct tm *tmdate );
    #endif
  #else
    #error "strftimeU() not yet implemented on this platform"
  #endif

  #if defined(SAPonUNIX) || defined(SAPonOS400)
    externC int linkU     ( const SAP_UC *path1, const SAP_UC *path2 );
    externC int symlinkU  ( const SAP_UC *path1, const SAP_UC *path2 );
    externC int readlinkU ( const SAP_UC *path,  SAP_UC *buf,
                            size_t size );
    externC int chownU    ( const SAP_UC *path,  SAP_UINT owner,
                            SAP_UINT group );
  #endif

  #if defined(SAPonAIX) && defined(_ALL_SOURCE)
    externC int *loadU( const SAP_UC *wfilepath, uint flags,
                        const SAP_UC *wlibpath );
  #endif
  #if defined(SAPonHP_UX) && defined(_DL_INCLUDED)
    externC shl_t shl_loadU( const SAP_UC *path, int  flags, long address );
    externC int shl_findsymU( shl_t *handle, const SAP_UC *sym,
                              short  type,   void *value );

  #elif ( defined(SAPonSUN) || defined(SAPonSINIX) || defined(SAPonOSF1) || \
          defined(SAPonLIN) || defined(SAPonAIX) )
    externC void *   dlopenU( const SAP_UC * path, int mode );
    externC void *   dlsymU( void *handle, const SAP_UC *name );
    externC SAP_UC * dlerrorU( void );

  #endif /* different platforms */

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - Functions that handle type char pointers:
 *          2. functions that return a type char pointer
 *             from the non-unicode world
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define asctimeU(timeptr)                 asctime(timeptr)
  #define ctimeU(timer)                     ctime(timer)
  #define strerrorU(errnum)                 strerror(errnum)
  #define setlocaleU(cat, locale)           setlocale(cat, locale)
  #define tmpnamU(s)                        tmpnam(s)
  #define tempnamU(s, t)                    tempnam(s, t)
  #define dirnameU(path)                    dirname(path)
  #define basenameU(path)                   basename(path)

  #if defined(SAPonNT)
    #define _ecvtU(value, ndig, dptr, sign) _ecvt(value, ndig, dptr, sign)
    #define ecvtU(value, ndig, dptr, sign)  _ecvt(value, ndig, dptr, sign)
    #define _getcwdU(buf, size)             _getcwd(buf, size)
    #define getcwdU(buf, size)              _getcwd(buf, size)

  #else
    #define ecvtU(value, ndig, dptr, sign)  ecvt(value, ndig, dptr, sign)
    #define getcwdU(buf, size)              getcwd(buf, size)
    #define ttynameU(filedes)               ttyname(filedes)

  #endif  /* different platforms */

#else  /* Now SAPwithUNICODE */

  #if defined (SAPonNT)

    #define asctimeU(timeptr)               _wasctime(timeptr)
    #define ctimeU(timer)                   _wctime(timer)
    #define _ecvtU(value, ndig, dptr, sign) ecvtU(value, ndig, dptr, sign)
    externC SAP_UC *ecvtU( double value, int ndig, int *dptr, int *sign );
    #define _getcwdU(buf, size)             _wgetcwd(buf, size)
    #define getcwdU(buf, size)              _wgetcwd(buf, size)
    #define setlocaleU(category, locale)    _wsetlocale(category, locale)
    externC SAP_UC *strerrorU ( int errnum );
    #define tmpnamU(cbuf)                   _wtmpnam(cbuf)
    #define tempnamU(cbuf, pref)            _wtempnam(cbuf, pref)
    #define dirnameU(path)                  dirname(path)
    #define basenameU(path)                 basename(path)

  #elif defined(SAPonUNIX) || defined(SAPonOS400)

    #if (defined(SAPonAIX)  && defined(_H_TIME) ) \
     || (defined(SAPonOSF1) && defined(_TIME_H_)) \
     || (defined(SAPonHP_UX) && defined(_TIME_INCLUDED)) \
     || (defined(SAPonSUN) && defined(_TIME_H)) \
     || (defined(SAPonOS400) && defined(__time_h))
      externC SAP_UC *asctimeU ( const struct tm *timeptr );
    #endif

    externC SAP_UC *ctimeU  ( const time_t *timer );
    #if defined(SAPonOS400) /* ecvt() is defined in abcnvt.c */
      #define ecvtU(value, ndig, dptr, sign)  ecvt(value, ndig, dptr, sign)
    #else
      externC SAP_UC *ecvtU ( double value, int ndig, int *dptr, int *sign );
    #endif
    externC SAP_UC *getcwdU   ( SAP_UC *wbuf, size_t size );
    externC SAP_UC *setlocaleU( int category, const SAP_UC *w_inPtr);
    externC SAP_UC *strerrorU ( int errnum );
    externC SAP_UC *tmpnamU   ( SAP_UC *wbuf );
    externC SAP_UC *tempnamU  ( SAP_UC *dir, SAP_UC *prefix );
    #ifndef SAPonOS400
      externC SAP_UC *ttynameU ( int filedes  );
      externC SAP_UC *dirnameU ( SAP_UC *path );
      externC SAP_UC *basenameU( SAP_UC *path );
    #endif

  #else
    #error "ctimeU() etc. not yet implemented on this platform"
  #endif /* different platforms */

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - Functions that handle type char pointers:
 *
 *   3. I/O streams
 *
 *     including the printf and scanf function families
 *     and the fputc and fgetc function families
 *
 *     On a Unicode system, the ...U() which write to disk or read from disk
 *     convert between the Unicode format used in the memory and UTF-8.
 *     The ...R() functions read and write raw data without any conversion.
 *----------------------------------------------------------------------------*/
#define fgetcR(stream)                   fgetc(stream)
#define getcR(stream)                    getc(stream)
#define ungetcR(c, stream)               ungetc(c, stream)
#define fputcR(rawdata, stream)          fputc(rawdata, stream)
#define putcR(rawdata, stream)           putc(rawdata, stream)
#define fwriteR(rawdata, s, n, stream)   fwrite(rawdata, s, n, stream)
#define freadR( rawdata, s, n, stream)   fread( rawdata, s, n, stream)

#ifdef SAPccQ
  extern void * fgetsR  (       void *s, int n,              FILE *f );
  extern int   setvbufR ( FILE *stream, void *buf, int mod, size_t n );
#else
  #define fgetsR( s, n, stream)            fgets( (char*)(s), n, stream)
  #define setvbufR(stream, buf, mod, n)    setvbuf(stream, (char*)(buf), mod, n)
#endif

#ifndef SAPwithUNICODE

  #define printfU                        printf
  #define fprintfU                       fprintf
  #define sprintfU                       sprintf
  #define vprintfU(p1, p2)               vprintf(p1, p2)
  #define vfprintfU(p1, p2, p3)          vfprintf(p1, p2, p3)
  #define vsprintfU(p1, p2, p3)          vsprintf(p1, p2, p3)

  #define scanfU                         scanf
  #define fscanfU                        fscanf
  #define sscanfU                        sscanf

  #define fgetcU(stream)                 fgetc(stream)
  #define getcU(stream)                  getc(stream)
  #define ungetcU(c, stream)             ungetc(c, stream)
  #define fputcU(c, stream)              fputc(c, stream)
  #define putcU(c, stream)               putc(c, stream)

  #define fgetsU(s, n, stream)           fgets(s, n, stream)
  #define getsU(s)                       gets(s)
  #define fputsU(s, stream)              fputs(s, stream)
  #define putsU(s)                       puts(s)

  #define putcharU(c)                    putchar(c)
  #define getcharU                       getchar

  #define fwriteU(rawdata, s, n, stream)   fwrite(rawdata, s, n, stream)
  #define  freadU(rawdata, s, n, stream)    fread(rawdata, s, n, stream)

  #define setvbufU(stream, buf, mod, n)    setvbuf(stream, buf, mod, n)

#else  /* Now SAPwithUNICODE */

  #if defined(SAPonNT) /* same function names as before, same order. */
    externC int   printfU(          const SAP_UC *format, ... );
    externC int  fprintfU( FILE *s, const SAP_UC *format, ... );
    #define      sprintfU                swprintf
    externC int  vprintfU(          const SAP_UC *format, va_list ap );
    externC int vfprintfU( FILE *s, const SAP_UC *format, va_list ap );
    #define     vsprintfU(p1, p2, p3)    vswprintf(p1, p2, p3)
    externC int   printfU_count_bytes(         size_t *, const SAP_UC *, ... );
    externC int  fprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, ... );
    externC int  vprintfU_count_bytes(         size_t *, const SAP_UC *, va_list );
    externC int vfprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, va_list );

    externC int    scanfU(          const SAP_UC *format, ... );
    externC int   fscanfU( FILE *s, const SAP_UC *format, ... );
    #define       sscanfU                swscanf

    externC WINT_T fgetcU( FILE *stream );
    #define         getcU( stream )       fgetcU( stream )
                /* ungetcU not implemented. NT's ungetwc cannot push back
		 * more than two bytes, and moreover there is no UTF-8
		 * locale (March 98) 
                 */
    externC WINT_T fputcU( WINT_T  wc,  FILE *stream );
    #define         putcU( wc, stream )   fputcU( wc, stream )

    externC SAP_UC *fgetsU( SAP_UC *wcs, int n, FILE *stream );
    externC SAP_UC  *getsU( SAP_UC *wcs );
    externC int     fputsU( SAP_UC *wcs, FILE *stream );
    externC int      putsU( SAP_UC *wcs );

  #elif defined(SAPonAIX)
    externC char   *formatU_AIX( const SAP_UC *wformat );

    externC int   printfU(            const SAP_UC *format, ... );
    externC int  fprintfU( FILE *s,   const SAP_UC *format, ... );
    externC int  sprintfU( SAP_UC *s, const SAP_UC *format, ... );
    externC int  vprintfU(            const SAP_UC *format, va_list ap );
    externC int vfprintfU( FILE *s,   const SAP_UC *format, va_list ap );
    externC int vsprintfU( SAP_UC *s, const SAP_UC *format, va_list ap );
    externC int   printfU_count_bytes(         size_t *, const SAP_UC *, ... );
    externC int  fprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, ... );
    externC int  vprintfU_count_bytes(         size_t *, const SAP_UC *, va_list );
    externC int vfprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, va_list );

    externC int    scanfU(                  const SAP_UC *format, ... );
    externC int   fscanfU( FILE *stream,    const SAP_UC *format, ... );
    externC int   sscanfU( const SAP_UC *s, const SAP_UC *format, ... );

    #define       ungetcU( wchar, stream ) ungetwc( wchar, stream )

/*  All AIX get-functions have a buffer overflow on hw1012. */ 
    #define        fputcU( wc, stream )   fputwc( wc, stream )
    #define         putcU( wc, stream )    putwc( wc, stream )
    externC WINT_T fgetcU( FILE *stream );
    #define         getcU( stream )       fgetcU( stream )

    externC SAP_UC *fgetsU( SAP_UC *wcs, int n, FILE *stream );
    externC SAP_UC  *getsU( SAP_UC *wcs );
    #define         fputsU( wcs, stream )  fputws( wcs, stream )
    #define          putsU( wcs )          putws( wcs )

  #elif defined(SAPonOSF1)
    externC SAP_UC *formatU_OSF1( const SAP_UC *wformat );
    #define OSF1_SWPRINTF_MAX 9999     /* if too big, you will get a core
					* if SAP_UC_is_wchar */

    externC int   printfU(            const SAP_UC *format, ... );
    externC int  fprintfU( FILE *s,   const SAP_UC *format, ... );
    externC int  sprintfU( SAP_UC *s, const SAP_UC *format, ... );
    externC int  vprintfU(            const SAP_UC *format, va_list ap );
    externC int vfprintfU( FILE *s,   const SAP_UC *format, va_list ap );
    externC int vsprintfU( SAP_UC *s, const SAP_UC *format, va_list ap );
    externC int   printfU_count_bytes(         size_t *, const SAP_UC *, ... );
    externC int  fprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, ... );
    externC int  vprintfU_count_bytes(         size_t *, const SAP_UC *, va_list );
    externC int vfprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, va_list );

    externC int    scanfU(                  const SAP_UC *format, ... );
    externC int   fscanfU( FILE *stream,    const SAP_UC *format, ... );
    externC int   sscanfU( const SAP_UC *s, const SAP_UC *format, ... );

    externC SAP_UC   *getsU( SAP_UC *wcs );
    externC int       putsU( SAP_UC *wcs );

    #define           ungetcU( wchar, stream) ungetwc( wchar, stream )

    #if defined(SAP_UC_is_wchar)
      #define         fgetcU( stream )       fgetwc( stream )
      #define          getcU( stream )       getwc( stream )
      #define         fputcU( wc, stream)    fputwc( wc, stream )
      #define          putcU( wc, stream)    putwc( wc, stream )
      #define         fgetsU(wcs, n, stream) fgetws( wcs, n, stream )
      #define         fputsU( wcs, stream )  fputws( wcs, stream )
    #elif defined(SAP_UC_is_UTF16_without_wchar)
      externC WINT_T  fgetcU( FILE *stream );
      #define          getcU( stream )       fgetcU( stream )
      externC SAP_UC *fgetsU( SAP_UC *wcs, int n, FILE *stream );
      externC WINT_T  fputcU( WINT_T  wc,  FILE *stream );
      #define          putcU( wc, stream )   fputcU( wc, stream )
      externC int     fputsU( SAP_UC *wcs, FILE *stream );
    #endif

  #elif defined(SAPonHP_UX)
    externC char   *formatU_AIX( const SAP_UC *wformat );
                                      /* Sorry for misusing the name */

    externC int   printfU(            const SAP_UC *format, ...);
    externC int  fprintfU( FILE *s,   const SAP_UC *format, ...);
    externC int  sprintfU( SAP_UC *s, const SAP_UC *format, ...);
    externC int  vprintfU(            const SAP_UC *format, va_list ap);
    externC int vfprintfU( FILE *s,   const SAP_UC *format, va_list ap);
    externC int vsprintfU( SAP_UC *s, const SAP_UC *format, va_list ap);
    externC int   printfU_count_bytes(         size_t *, const SAP_UC *, ... );
    externC int  fprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, ... );
    externC int  vprintfU_count_bytes(         size_t *, const SAP_UC *, va_list );
    externC int vfprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, va_list );

    externC int    scanfU(                  const SAP_UC *format, ... );
    externC int   fscanfU( FILE *stream,    const SAP_UC *format, ... );
    externC int   sscanfU( const SAP_UC *s, const SAP_UC *format, ... );

    externC SAP_UC  *getsU( SAP_UC *wcs );

    #define        ungetcU( wchar, stream) ungetwc( wchar, stream )

    #if defined(SAP_UC_is_wchar)

      #define         fgetcU( stream )       fgetwc( stream )
      #define          getcU( stream )       getwc( stream )
      #define         fputcU( wc, stream)    fputwc( wc, stream )
      #define          putcU( wc, stream)    putwc( wc, stream )
      #define         fgetsU(wcs, n, stream) fgetws( wcs, n, stream )
      #define         fputsU( wcs, stream )  fputws( wcs, stream )
      #define          putsU( wcs )          putws( wcs )

    #elif defined(SAP_UC_is_UTF16_without_wchar)

      externC WINT_T  fgetcU( FILE *stream ); 
      #define          getcU( stream )       fgetcU( stream )
      externC WINT_T  fputcU( WINT_T  wc,  FILE *stream );
      #define          putcU( wc, stream )   fputcU( wc, stream )
      externC SAP_UC *fgetsU( SAP_UC *wcs, int n, FILE *stream );
      externC int     fputsU( SAP_UC *wcs, FILE *stream );
      externC int      putsU( SAP_UC *wcs );

    #endif

  #elif defined(SAPonOS400) /* same function names as before, same order */
                            /* change type specifiers to upper case and add   */
                            /* one additional parameter in swprintf()         */
    externC SAP_UC *formatU_OS400( const SAP_UC *wformat );

    externC int   printfU(            const SAP_UC *format, ... );
    externC int  fprintfU( FILE *s,   const SAP_UC *format, ... );
    externC int  sprintfU( SAP_UC *s, const SAP_UC *format, ... );
    externC int  vprintfU(            const SAP_UC *format, va_list ap );
    externC int vfprintfU( FILE *s,   const SAP_UC *format, va_list ap );
    externC int vsprintfU( SAP_UC *s, const SAP_UC *format, va_list ap );
    externC int   printfU_count_bytes(         size_t *, const SAP_UC *, ... );
    externC int  fprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, ... );
    externC int  vprintfU_count_bytes(         size_t *, const SAP_UC *, va_list );
    externC int vfprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, va_list );

    externC int    scanfU(                  const SAP_UC *format, ... );
    externC int   fscanfU( FILE *stream,    const SAP_UC *format, ... );
    externC int   sscanfU( const SAP_UC *s, const SAP_UC *format, ... );

    #define          fgetcU( stream )        fgetwc( stream )
    #define           getcU( stream )         getwc( stream )
    #define         ungetcU( wc, stream)    ungetwc( wc, stream)
    #define          fputcU( wc, stream)     fputwc( wc, stream )
    #define           putcU( wc, stream)      putwc( wc, stream )
    #define          fgetsU( wcs, n, stream) fgetws( wcs, n, stream )
    externC SAP_UC   *getsU( SAP_UC *wcs );
    #define          fputsU( wcs, stream )   fputws( wcs, stream )
    externC int       putsU( SAP_UC *wcs );


  #elif defined(SAPonSUN)
    externC int       printfU(            const SAP_UC *format, ... );
    externC int      fprintfU( FILE *s,   const SAP_UC *format, ... );
    externC int      sprintfU( SAP_UC *s, const SAP_UC *format, ... );
    externC int      vprintfU(            const SAP_UC *format, va_list ap );
    externC int     vfprintfU( FILE *s,   const SAP_UC *format, va_list ap );
    externC int     vsprintfU( SAP_UC *s, const SAP_UC *format, va_list ap );
    externC int   printfU_count_bytes(         size_t *, const SAP_UC *, ... );
    externC int  fprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, ... );
    externC int  vprintfU_count_bytes(         size_t *, const SAP_UC *, va_list );
    externC int vfprintfU_count_bytes( FILE *, size_t *, const SAP_UC *, va_list );

    externC int    scanfU(                  const SAP_UC *format, ... );
    externC int   fscanfU( FILE *stream,    const SAP_UC *format, ... );
    externC int   sscanfU( const SAP_UC *s, const SAP_UC *format, ... );

    #define       ungetcU( wchar, stream ) ungetwc( wchar, stream )

    #if defined(SAP_UC_is_wchar)
/* SUN's get-functions do not return EOF after reading an invalid UTF-8 
 * character 
 */
      externC WINT_T  fgetcU( FILE *stream );
      #define          getcU( stream )       fgetcU( stream )
      externC SAP_UC *fgetsU( SAP_UC *wcs, int n, FILE *stream );
      externC SAP_UC  *getsU( SAP_UC *wcs );
      #define         fputcU( wc, stream)    fputwc( wc, stream )
      #define          putcU( wc, stream)    putwc( wc, stream )
      #define         fputsU( wcs, stream )  fputws( wcs, stream )
      #define          putsU( wcs )          putws( wcs )
    #elif defined(SAP_UC_is_UTF16_without_wchar)
      externC WINT_T     fgetcU( FILE *stream );
      #define             getcU( stream )       fgetcU( stream )
      externC SAP_UC *fgetsU( SAP_UC *wcs, int n, FILE *stream );
      externC SAP_UC  *getsU( SAP_UC *wcs );
      externC WINT_T  fputcU( WINT_T  wc,  FILE *stream );
      #define          putcU( wc, stream )   fputcU( wc, stream )
      externC int     fputsU( SAP_UC *wcs, FILE *stream );
      externC int      putsU( SAP_UC *wcs );
    #endif

  #else
    #error "printfU() etc. not yet implemented on this platform"
  #endif /* different platforms */

  #define putcharU( wc )       putcU( wc, stdout )
  #define getcharU()           getcU( stdin )

  externC size_t fwriteU( const SAP_CHAR *p, size_t s, size_t n, FILE *stream );
  externC size_t freadU (       SAP_CHAR *p, size_t s, size_t n, FILE *stream );

  #ifndef SAPccQ
    #define setvbufU(stream, buf, mod, n)  \
            setvbuf(stream, (char*)(buf), mod, (n)*SAP_UC_LN)
           /* Here n counts the number of SAP_CHAR characters; buf may be of
	    * type SAP_CHAR* . The usefulness may be quite limited;
	    * consider using setvbufR instead.
	   */
  #else
    extern int     setvbufU ( FILE *stream, SAP_CHAR *buf, int mod, size_t n );
  #endif 


#endif /* SAPwithUNICODE or not */


/*-----------------------------------------------------------------------------
 * sapuc.h - Functions that handle type char pointers:
 *         4. exec family
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define execlU                         execl
  #define execleU                        execle
  #define execlpU                        execlp
  #define execvU(p1, p2)                 execv(p1, p2)
  #define execveU(p1, p2, p3)            execve(p1, p2, p3)
  #define execvpU(p1, p2)                execvp(p1, p2)

#else  /* Now SAPwithUNICODE */

  #ifdef SAPonUNIX
    externC int execlU ( const SAP_UC *path, const SAP_UC *arg, ... );
    externC int execleU( const SAP_UC *path, const SAP_UC *arg, ... );
    externC int execlpU( const SAP_UC *file, const SAP_UC *arg, ... );
    externC int execvU ( const SAP_UC *path, SAP_UC* const argv[] );
    externC int execveU( const SAP_UC *path, SAP_UC* const argv[],
			 SAP_UC* const wenv[] );
    externC int execvpU( const SAP_UC *file, SAP_UC* const argv[] );

  #elif defined(SAPonNT)

    #define execlU                         _wexecl
    #define execleU                        _wexecle
    #define execlpU                        _wexeclp
    #define execvU(p1, p2)                 _wexecv(p1, p2)
    #define execveU(p1, p2, p3)            _wexecve(p1, p2, p3)
    #define execvpU(p1, p2)                _wexecvp(p1, p2)

  #elif defined(SAPonOS400)
    /* exec..() not used on OS400 */

  #else
    #error "exec..U() not yet implemented on this platform"
  #endif /* different platforms */

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - functions that handle type char pointers
 *         5. Environment handling and main
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define mainU                          main
  #define main3U                         main

  #ifdef SAPonOS400
      #define spawnU                     spawn
  #endif /* SAPonOS400 */

  #define getenvU(name)                  getenv(name)
  #define putenvU(s)                     putenv(s)
  #ifdef SAPonNT
    #define _putenvU(s)                  _putenv(s)
  #endif

  
  /*******************************************************************
   *   
   * For a documentation of the following macros and an example of
   * their use, see the docu in nlsui1.c
   *
   *******************************************************************/
   #define environU                       environ
   #define DECLAREenvironU                extern SAP_UC ** environ
   #ifdef SAPonOS400
     #define GETenvironU                  ((Qp0zInitEnv() == 0) ? environ : NULL)
   #else
     #define GETenvironU                  environ
   #endif
   #define FREEenvironU                   (1)


#else  /* Now SAPwithUNICODE */

  #ifdef SAPonNT
    #define mainU                        wmain
    #define main3U                       wmain
    #define _putenvU(wcs)                _wputenv(wcs)
    #define putenvU(wcs)                 _wputenv(wcs)
    #define getenvU(wname)               _wgetenv(wname)

   /*******************************************************************
    *  
    * For a documentation of the following macros and an example of
    * their use, see the docu in nlsui1.c
    *
    *******************************************************************/
    #define environU                     _wenviron
    #define DECLAREenvironU              /* declared in stdlib.h */ 
    #define GETenvironU                  _wenviron
    #define FREEenvironU                 (1)

  #else /* other platforms than NT */
    /* The source code looks like this:
     * int mainU (int argc, SAP_UC *argv[ ] ) { .... }
     * or:
     * int main3U (int argc, SAP_UC *argv[ ], SAP_UC *envp[ ] ) { .... }
     */
    #define mainU                                                      \
	    main (int argc, char *argv[ ] )                            \
            {                                                          \
	      SAP_UC **w_argv;                                         \
	      nlsui_initial_setlocale();                               \
	      w_argv = nlsui_alloc_wcsar(argc, argv);                  \
              return nlsui_main(argc, w_argv);                         \
	    }                                                          \
        int nlsui_main /* (...) */

    #define main3U                                                     \
	    main (int argc, char *argv[ ], char *envp[ ] )             \
            {                                                          \
	      SAP_UC **w_argv, **w_envp;                               \
	      nlsui_initial_setlocale();                               \
	      w_argv = nlsui_alloc_wcsar(argc, argv);                  \
	      w_envp = nlsui_alloc_env(envp);                          \
              return nlsui_main3(argc, w_argv, w_envp);                \
	    }                                                          \
        int nlsui_main3   /* (...) */

    #ifdef SAPonOS400

      extern int spawnU( const SAP_UC *cmd, 
                         const int fd_count, 
                         const int fd_map[], 
                         const struct inheritance *inherit, 
                         SAP_UC *argv[], 
                         SAP_UC *envp[]  );

    #endif /* SAPonOS400 */

    externC int      putenvU( const SAP_UC *wcs );
    externC SAP_UC * getenvU( const SAP_UC *wname );

   /*******************************************************************
    *  
    * For a documentation of the following macros and an example of
    * their use, see the docu in nlsui1.c
    *
    *******************************************************************/
    #define environU             nlsui_environ
    #define DECLAREenvironU      SAP_UC **nlsui_environ_i, **nlsui_environ
    #define GETenvironU          nlsui_environ = nlsui_environ_i \
                                               = nlsui_getenvironU()
    #define FREEenvironU         nlsui_freeenvironU(nlsui_environ_i)

    /* The following prototypes are for internal use only.
     * (Don't move the prototypes for nlsui_main etc. into the
     *  corresponding macros. ) */
    externC SAP_UC ** nlsui_getenvironU  ( void );
    externC int       nlsui_freeenvironU ( SAP_UC ** );
    externC void      nlsui_initial_setlocale ( void );
    externC SAP_UC ** nlsui_alloc_wcsar  ( int argc,  char *argv[]);
    externC int       nlsui_wcsar2mbsar  ( int cnt,   SAP_UC *wp[],
                                           char *p[], int plen[] );
    externC SAP_UC ** nlsui_alloc_env    ( char **envp );
    externC int       nlsui_main         ( int argc,  SAP_UC *w_argv[] );
    externC int       nlsui_main3        ( int argc,  SAP_UC *w_argv[],
                                           SAP_UC *w_envp[] );
    #ifdef SAPonOS400
      extern int     nlsui_o4_main      ( int o4_argc, SAP_UC *w_argv[] );
    #endif /* SAPonOS400 */

  #endif /* different platforms */

#endif


/* ccQ complains about main expansion with char, so let mainU, main3U be 
 * simple functions 
 */
#ifdef SAPccQ
  /* extern int mainU   ( int argc, SAP_UC **argv ); */
  /* extern int main3U  ( int argc, SAP_UC **argv, SAP_UC **envptr ); */
  #undef mainU
  #undef main3U
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  NLS specific functions (multibyte functions)
 *
 *  mblen() and MB_CUR_MAX are always 1 in a Unicode system.
 *
 *  Conversions between multibyte and wide characters are reduced
 *  to a memcpy in the Unicode case.
 *----------------------------------------------------------------------------*/
#if !defined(SAPwithUNICODE)

  #define mblenU(mbptr, nbytes)           mblen(mbptr, nbytes)

#else /* SAPwithUNICODE */

  #if defined(SAPonNT)
    #if !defined(_INC_CTYPE) && !defined(_INC_STDLIB)
      #error "stdlib.h or ctype.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonAIX)
    #if !defined(_H_STDLIB)
      #error "stdlib.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonOSF1)
    #if !defined(_STDLIB_H_)
      #error "stdlib.h or ctype.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonHP_UX)
    #if !defined(_STDLIB_INCLUDED)
      #error "stdlib.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonOS400)
    #if !defined(__stdlib_h)
      #error "stdlib.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonSUN)
    #if !defined (_STDLIB_H)
      #error "stdlib.h must be included before sapuc.h"
    #endif

  #else
    #error "Redefinition of MB_CUR_MAX not yet implemented"
    /* please make sure that MB_CUR_MAX cannot be re-redefined if the
     * standard header file should be included again later.
     */

  #endif /* different platforms */

  #undef MB_CUR_MAX
  #define MB_CUR_MAX                     (1)
  #define mblenU(mbptr, nbytes)          (1)

#endif  /* SAPwithUNICODE */


#ifndef SAPwithUNICODE
  #define mbstowcsU(dest, source, len)   mbstowcs(dest, source, len)
  #define wcstombsU(dest, source, len)   wcstombs(dest, source, len)
  #define mbtowcU(wcptr, mbptr, nbytes)  mbtowc(wcptr, mbptr, nbytes)
  #define wctombU(mbptr, wc)             wctomb(mbptr, wc)

#else   /* Now SAPwithUNICODE */
  #define mbstowcsU(dest, source, noch)  wcstowcs(dest, source, noch)
  #define wcstombsU(dest, source, noch)  wcstowcs(dest, source, noch)
  externC size_t wcstowcs(SAP_UC *dest, const SAP_UC *source, size_t noch);
  #define mbtowcU(wcptr, mbptr, nbytes)  ( (wcptr)!=NULL && (mbptr)!=NULL ? \
                                           ( *(wcptr)=*(mbptr), (size_t)1 ) : \
                                           (size_t)0  )
  #define wctombU(mbptr, wc)             ( (mbptr)!=NULL ? \
                                           ( *(mbptr)=(wc), (size_t)1) : \
                                           (size_t)0  )

#endif 


/*-----------------------------------------------------------------------------
 * sapuc.h  -  structures which contain elements of type char
 *             and functions which use these stuctures
 *
 * the following defintions should only be present if _POSIX_SOURCE is defined
 *----------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
 * sapuc.h  - Definition of some preprocessor constants
 *
 *  Other similar constants are defined in nlsui1.c and nlsui2.c.
 *  If used as string length, the terminating zero is included in this length.
 *----------------------------------------------------------------------------*/
#define MAX_ALIASES           64       /* hostname aliases (struct hostentU)  */
#define MAX_ADDRESSES         64       /* hostname adresses (struct hostentU) */

#if defined(SAPonNT)
 #define MAX_PATH_LN     MAXPATHLEN+1    /* see "ntport.h"                    */
 #define SAP_SYS_NMLN    UTS_NAME_LENGTH /* see "ntport.h"                    */
#elif defined(SAPonOS400)
 #define MAX_PATH_LN     _QP0L_DIR_NAME  /* see qsyuinc/h.dirent              */
 #define SAP_SYS_NMLN    32              /* see "o4port.h"                    */
#elif !defined(PATH_MAX)                /* PATH_MAX <limits.h> not present XXX? */
 #define MAX_PATH_LN     1024
 #define SAP_SYS_NMLN    256
#else
 #define MAX_PATH_LN     PATH_MAX+1      /* <sys/limits.h>, no terminating 0  */
 #define SAP_SYS_NMLN    256
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  - struct utsname and function uname()
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define utsnameU              utsname
  #define unameU(name_ptr)      uname(name_ptr)

#else  /* Now SAPwithUNICODE */

  struct utsnameU {
    SAP_UC sysname[SAP_SYS_NMLN];
    SAP_UC nodename[SAP_SYS_NMLN];
    SAP_UC release[SAP_SYS_NMLN];
    SAP_UC version[SAP_SYS_NMLN];
    SAP_UC machine[SAP_SYS_NMLN];
  };
  externC int unameU( struct utsnameU  *name );

#endif 


/*-----------------------------------------------------------------------------
 * sapuc.h  - struct dirent and function readdir()
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define direntU               dirent
  #define readdirU(dirp)        readdir(dirp)

#else  /* Now SAPwithUNICODE */

  #if (!defined (SAPonHP_UX)) || defined (_INCLUDE_POSIX_SOURCE)
    struct direntU {
    #if ! defined (SAPonNT)
      ino_t       d_ino;
    #endif
    #if defined(SAPonOS400)
      SAP_USHORT  d_namelen;
    #elif defined(SAPonSUN)
      /* there is no namelen entry on SUN*/
    #else
      SAP_USHORT  d_namlen;
    #endif
      SAP_UC      d_name[MAX_PATH_LN];
    };
  #endif

  #if defined(SAPonAIX) || defined(SAPonOSF1) || \
      defined(SAPonNT)  || defined(SAPonOS400)|| \
      defined(SAPonSUN) ||                       \
     (defined(SAPonHP_UX) && defined (_INCLUDE_POSIX_SOURCE))
    externC struct direntU * readdirU( DIR *dirp );
  #endif

#endif

/*-----------------------------------------------------------------------------
 * sapuc.h  - struct passwd and functions getpw...()
 *            For the Unicode case, uid_t and gid_t are replaced by
 *            SAP_UINT. Therefore it is not necessary to include
 *            <sys/types.h> here.
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define passwdU               passwd
  #define getpwuidU(uid)        getpwuid(uid)
  #define getpwnamU(name)       getpwnam(name)

#else  /* Now SAPwithUNICODE */

  struct passwdU {
    SAP_UC *pw_name;
 #ifndef SAPonOS400
    SAP_UC *pw_passwd;
 #endif
    SAP_UINT pw_uid;
    SAP_UINT pw_gid;
 #ifndef SAPonOS400
    SAP_UC *pw_gecos;
 #endif
    SAP_UC *pw_dir;
    SAP_UC *pw_shell;
  };
  externC struct passwdU * getpwuidU( SAP_UINT uid );
  externC struct passwdU * getpwnamU( const SAP_UC *name );

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  - struct hostent and struct servent
 *            and the functions
 *            gethostent(), gethostbyname(), gethostbyaddr(),
 *            getservbyname(), getservbyaddr(), getservbyport(),
 *            rexecU()
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define hostentU                        hostent
  #define serventU                        servent
  #define gethostbyaddrU(addr, len, type) gethostbyaddr(addr, len, type)
  #define gethostbynameU(name)            gethostbyname(name)
  #define gethostentU()                   gethostent()
  #define getservbynameU(name, proto)     getservbyname(name, proto)
  #define getservbyportU(port, proto)     getservbyport(port, proto)

  #ifndef SAPonNT
   #define rexecU(host, port, name, pass, cmd, fd2p)  \
					rexec(host, port, name, pass, cmd, fd2p)
  #endif

#else  /* Now SAPwithUNICODE */

  struct hostentU {
    SAP_UC  * h_name;                    /* official name of host         */
    SAP_UC  * h_aliases[MAX_ALIASES];    /* alias list                    */
    SAP_INT   h_addrtype;                /* host address type             */
    SAP_INT   h_length;                  /* length of address in bytes    */
    SAP_RAW * h_addr_list[MAX_ADDRESSES];/* list of addr. from name server*/
    #define   h_addr  h_addr_list[0]     /* address, for backw. compatib. */
  };
  struct serventU {
    SAP_UC   * s_name;                  /* official service name */
    SAP_UC   * s_aliases[MAX_ALIASES];  /* alias list            */
    SAP_INT    s_port;                  /* port #                */
    SAP_UC   * s_proto;                 /* protocol to use       */
  };

  externC struct hostentU *gethostentU   ( void );
  externC struct hostentU *gethostbyaddrU( const void *addr, int len, int type );
  externC struct hostentU *gethostbynameU( const SAP_UC *name );
  externC struct serventU *getservbynameU( const SAP_UC *name,
                                           const SAP_UC *proto );
  externC struct serventU *getservbyportU( int port, const SAP_UC *proto );

  #if defined(SAPonHP_UX) || defined(SAPonSUN) || defined(SAPonAIX) || \
      defined(SAPonOSF1)

   externC int rexecU( SAP_UC **, int, const SAP_UC *, const SAP_UC *, 
	 	       const SAP_UC *, int * );
  #endif

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  - struct nlist and function nlist()
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define nlist_U               nlist
  #define nlistU(filename, nl)  nlist(filename, nl)

#else  /* Now SAPwithUNICODE */

  #if !defined(SAPonUNIX)
    /* nlist is used only on Unix => no code */

  #elif defined(SAPonOSF1)
    struct nlist_U {
      SAP_UC        *n_name;
      unsigned long   n_value;
      short           n_type;          /* 0 if not there, 1 if found */
      short           reserved;
    };
    externC int nlistU( const SAP_UC *filename, struct nlist_U nl[] );

  #elif defined(SAPonAIX)
    struct nlist_U {
      union {
         SAP_UC     *_n_name;        /* symbol name            */
      } _n;
      long           n_value;        /* value of symbol        */
      short          n_scnum;        /* section number         */
      union {
        unsigned short  _n_type;     /* type and derived type  */
      } _n_tylc;
      SAP_UC         n_sclass;       /* storage class          */
      SAP_UC         n_numaux;       /* number of aux. entries */
    };
    externC int nlistU( const SAP_UC *filename, struct nlist_U *nl  );

  #elif defined(SAPonSUN) || defined(SAPonSINIX)
    struct nlist_U {
      SAP_UC        *n_name;         /* symbol name            */
      long           n_value;        /* value of symbol        */
      short          n_scnum;        /* section number         */
      unsigned short n_type;         /* type and derived type  */
      SAP_UC         n_sclass;       /* storage class          */
      SAP_UC         n_numaux;       /* number of aux. entries */
    };
    /* nlistU() not yet implemented */

  #elif defined(SAPonHP_UX)
    struct nlist_U {
      SAP_UC         *n_name;
      SAP_UC         *n_qual;
      unsigned short  n_type;
      unsigned short  n_scope;
      unsigned int    n_info;
      unsigned long   n_value;
    };
    /*nlistU() not yet implemented */

  #else
    #error "struct nlist_U not yet implemented on this platform"

  #endif /* different platforms */

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  struct group and function getgrgid()
 *----------------------------------------------------------------------------*/
#if defined (SAPwithUNICODE)||(defined(SAPonOS400)&&defined(SAPwithCharASCII))
/* SAPwithUNICODE */

  #if defined(SAPonUNIX) || defined(SAPonOS400)
    struct groupU {
      SAP_UC        *gr_name;
    #ifndef SAPonOS400
      SAP_UC        *gr_passwd;
    #endif
      unsigned long  gr_gid;
      SAP_UC       **gr_mem;
    };
    externC struct groupU *getgrgidU( unsigned long gid );
    #ifdef SAPonOS400
    externC struct groupU *getgrnamU( SAP_UC *grname );
    #endif
  #elif defined(SAPonNT)
   /* struct group does not exist */

  #else
    #error "struct groupU not yet implemented on this platform"

  #endif /* different platforms */

#else /* without UNICODE */

 #define groupU              group
 #define getgrgidU( gid )    getgrgid( gid )
 #ifdef SAPonOS400
 #define getgrnamU( grname ) getgrnam( grname )
 #endif
#endif

/*-----------------------------------------------------------------------------
 * sapuc.h  -  function getpass
 *----------------------------------------------------------------------------*/

#ifndef SAPwithUNICODE

 #define getpassU( prompt )  getpass( prompt)

#else  /* Now SAPwithUNICODE */

  #if defined(SAPonUNIX) || defined(SAPonOS400)
    externC SAP_UC *getpassU(SAP_UC *prompt);

  #elif defined(SAPonNT)
    #define getpassU( prompt )  getpass( prompt)

  #else
    #error "getpassU not yet implemented on this platform"

  #endif /* different platforms */

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  struct stat_U and functions statU, lstatU, fstatU
 *
 * struct stat_U must be used on OS/400, because struct stat contains a
 * char array. On the other platforms, stat_U and stat are identical.
 *
 * Attention: If struct stat_U or the functions statU() or lstatU()
 * are used in a file, the header file stat.h must be included BEFORE sapuc.h
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #ifdef SAPonNT
    #define stat_U                      _stat
    #define _statU( path, buffer )      _stat( path, buffer )
    #define  statU( path, buffer )      _stat( path, buffer )
    /* lstat() does not exist */
    #define fstatU( fdes, buffer )     _fstat( fdes, buffer )
  #else
    #define stat_U                       stat
    #define  statU( path, buffer )       stat( path, buffer )
    #define lstatU( path, buffer )      lstat( path, buffer )
    #define fstatU( fdes, buffer )      fstat( fdes, buffer )
  #endif

#else  /* Now SAPwithUNICODE */

  #if (defined(SAPonOS400) && defined(__stat_h))
    struct stat_U {
      mode_t          st_mode;
      ino_t           st_ino;
      nlink_t         st_nlink;
      uid_t           st_uid;
      gid_t           st_gid;
      off_t           st_size;
      time_t          st_atime;
      time_t          st_mtime;
      time_t          st_ctime;
      dev_t           st_dev;
      size_t          st_blksize;
      unsigned long   st_allocsize;
      SAP_UC          st_objtype[11];
      unsigned short  st_codepage;
      unsigned int    st_ino_gen_id;
    };
  #elif defined(SAPonNT)
    #define stat_U    _stat
  #else
    #define stat_U    stat
  #endif

  #if defined(SAPonNT)
    #define _statU( wpath, buffer )     _wstat( wpath, buffer )
    #define  statU( wpath, buffer )     _wstat( wpath, buffer )
    #define fstatU( fdes,  buffer )     _fstat( fdes,  buffer )
  #elif defined(SAPonAIX) || defined(SAPonSUN) || defined(SAPonHP_UX) \
     || defined(SAPonOSF1) 
    #if  (defined(SAPonAIX)   && defined(_H_STAT))            \
      || (defined(SAPonSUN)   && defined(_SYS_STAT_H))        \
      || (defined(SAPonHP_UX) && defined(_SYS_STAT_INCLUDED)) \
      || (defined(SAPonOSF1)  && defined(_SYS_STAT_H_)) 
      externC int statU ( const SAP_UC *path, struct stat_U *buffer );
      externC int lstatU( const SAP_UC *path, struct stat_U *buffer );
      #define fstatU( fdes, buffer )         fstat( fdes, buffer )
    #endif
  #elif defined(SAPonOS400) 
    #if defined(__stat_h)
      externC int statU ( const SAP_UC *path, struct stat_U *buffer );
      externC int lstatU( const SAP_UC *path, struct stat_U *buffer );
      externC int fstatU( int fdes,           struct stat_U *buffer );
    #endif
  #else
    #error "statU() not yet implemented on this platform"
  #endif /* different platforms */

#endif 


/*-----------------------------------------------------------------------------
 * sapuc.h  -  xdr_string()
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define xdr_stringU(xdrs, sp, maxsize) xdr_string(xdrs, sp, maxsize)

#else  /* Now SAPwithUNICODE */
  #if defined(SAPonAIX) || defined(SAPonSUN) || defined(SAPonHP_UX) \
   || defined(SAPonOSF1)
    #if defined(SAPonAIX)   &&   defined(_RPC_XDR_H)        \
     || defined(SAPonSUN)   &&   defined(_RPC_XDR_H)        \
     || defined(SAPonHP_UX) && ( defined(_RPC_XDR_INCLUDED) \
                              || defined(_RPC_XDR_H) )      \
     || defined(SAPonOSF1)  &&   defined(_rpc_xdr_h)
      externC bool_t xdr_stringU ( XDR* xdrs, SAP_UC **sp, u_int maxsize );
    #endif

 /* if defined(SAPonNT) || defined(SAPonOS400)   xdr_string() not used */

  #endif /* different platforms */

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  _splitpath() (for NT only)
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #ifdef SAPonNT
    #define _splitpathU( path, drive, dir, fname, ext ) _splitpath( path, drive, dir, fname, ext )
  #endif

#else  /* Now SAPwithUNICODE */

  #ifdef SAPonNT
    #define _splitpathU( path, drive, dir, fname, ext ) _wsplitpath( path, drive, dir, fname, ext )
  #endif

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - re-definition of the memory related functions in order
 *           to activate runtime Unicode debugger functionality
 *----------------------------------------------------------------------------*/
#if defined(SAPonAIX) && defined(SAPwithUNICODE) && defined(UNICODE_DEBUG)

  /* memory allocation functions  */
  externC void    * mallocRD  (           size_t, const SAP_RAW *, long );
  externC SAP_UC  * mallocUD  (           size_t, const SAP_RAW *, long );
  externC void    * reallocRD ( void *,   size_t, const SAP_RAW *, long );
  externC SAP_UC  * reallocUD ( SAP_UC *, size_t, const SAP_RAW *, long );
  externC void    * callocRD  ( size_t,   size_t, const SAP_RAW *, long );
  externC SAP_UC  * callocUD  ( size_t,   size_t, const SAP_RAW *, long );
  externC void      freeD     ( void *,           const SAP_RAW *, long );
  #define malloc(     len )         \
          mallocRD(  (len), (SAP_RAW *) __FILE__, __LINE__ )
  #define calloc(     num,   len )  \
          callocRD(  (num), (len), (SAP_RAW *) __FILE__, __LINE__ )
  #define realloc(    ptr,   len )  \
          reallocRD( (ptr), (len), (SAP_RAW *) __FILE__, __LINE__ )
  #undef  mallocR
  #define mallocR(    len )         \
          mallocRD(  (len),        (SAP_RAW *) __FILE__, __LINE__ )
  #undef  mallocU
  #define mallocU(    len )         \
          mallocUD(  (len),        (SAP_RAW *) __FILE__, __LINE__ )
  #undef  callocR
  #define callocR(    num,   len )  \
          callocRD(  (num), (len), (SAP_RAW *) __FILE__, __LINE__ )
  #undef  callocU
  #define callocU(    num,   len )  \
          callocUD(  (num), (len), (SAP_RAW *) __FILE__, __LINE__ )
  #undef  reallocR
  #define reallocR(   ptr,   len )  \
          reallocRD( (ptr), (len), (SAP_RAW *) __FILE__, __LINE__ )
  #undef  reallocU
  #define reallocU(   ptr,   len )  \
          reallocUD( (ptr), (len), (SAP_RAW *) __FILE__, __LINE__ )
  #define free( p )    freeD( (p), (SAP_RAW *)__FILE__, __LINE__ )
  
  /* memory functions     */
  externC void     * memsetRD( void *,     int, size_t, const SAP_RAW*, long );
  externC SAP_CHAR * memsetUD( SAP_CHAR *, int, size_t, const SAP_RAW*, long );
  externC int        memcmpRD( const void *,     const void *,     size_t, 
                               const SAP_RAW *,  long );
  externC int        memcmpUD( const SAP_CHAR *, const SAP_CHAR *, size_t,
                               const SAP_RAW *,  long );
  externC void*      memcpyRD(       void *,     const void *,     size_t, 
                               const SAP_RAW *,  long );
  externC SAP_CHAR * memcpyUD(       SAP_CHAR *, const SAP_CHAR *, size_t,
                               const SAP_RAW*,   long );
  #undef  memsetR
  #define memsetR(   s,    c,    len )  \
          memsetRD( (s),  (c),  (len), (SAP_RAW *) __FILE__, __LINE__ )
  #undef  memsetU
  #define memsetU(   s,    c,    len )  \
          memsetUD( (s),  (c),  (len), (SAP_RAW *) __FILE__, __LINE__ )
  #undef  memcmpR
  #define memcmpR(   s1,   s2,   len ) \
          memcmpRD( (s1), (s2), (len), (SAP_RAW *) __FILE__, __LINE__ )
  #undef  memcmpU
  #define memcmpU(   s1,   s2,   len ) \
          memcmpUD( (s1), (s2), (len), (SAP_RAW *) __FILE__, __LINE__ )
  #undef  memcpyR
  #define memcpyR(   s1,   s2,   len ) \
          memcpyRD( (s1), (s2), (len), (SAP_RAW *) __FILE__, __LINE__ )
  #undef  memcpyU
  #define memcpyU(   s1,   s2,   len ) \
          memcpyUD( (s1), (s2), (len), (SAP_RAW *) __FILE__, __LINE__ )
  
  /* string functions     */
  externC size_t   strlenUD( const SAP_UC *,  
                             const SAP_RAW *, long );
  externC int      strcmpUD( const SAP_UC *,  const SAP_UC *, 
                             const SAP_RAW *, long );
  externC SAP_UC * strcpyUD(       SAP_UC *,  const SAP_UC *, 
                             const SAP_RAW *, long );
  #undef  strlenU
  #define strlenU(   p )        \
          strlenUD( (p),        (SAP_RAW *) __FILE__, __LINE__ )
  #undef  strcmpU
  #define strcmpU(   s1,   s2 ) \
          strcmpUD( (s1), (s2), (SAP_RAW *) __FILE__, __LINE__ )
  #undef  strcpyU
  #define strcpyU(   s1,   s2 ) \
          strcpyUD( (s1), (s2), (SAP_RAW *) __FILE__, __LINE__ )
  
#endif /* UNICODE_DEBUG */


#ifdef SAPccQ
  #include <stdarg.h>
  #undef  va_arg
  #define va_arg( p, type ) (((type *)0)[0])
  #undef  va_start
  #define va_start( list, parmN )
  #undef  va_end
  #define va_end( list )
#endif



#undef externC


/**********************************************************************/
/*                                                                    */
/* If you need C types to handle single characters or strings with a  */
/* large character set, you have the choice between six of them.      */
/* Please handle them distinctly! Some pairs may be compatible on     */
/* one platform but not on the others.                                */
/*                                                                    */
/* Each type has some advantages and some disadvantages. That is the  */
/* reason, why we could not drop any one.                             */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                        .---------.                                 */
/*                        | wchar_t |                                 */
/*                       .'         `----------.                      */
/*                       | XPG4 wide char      |                      */
/*                       | + "all" characters  |                      */
/*                       | + fast              |                      */
/*                       | - unknown coding    |                      */
/*                       | + many functions    |                      */
/*                       | - unknown size      |                      */
/*                       | + but size is fixed |                      */
/*                       `---------------------'                      */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*   .---------.                              .--------.              */
/*   |  char   |                              |   UC   |              */
/*  .'         `----------.                  .'        `-----------.  */
/*  | Standard C character|                  | universal character |  */
/*  | - 1 byte            |                  | + "all" characters  |  */
/*  | - variing coding    |                  | + fast              |  */
/*  | + many functions    |                  | - platform dependent|  */
/*  | - also used for     |                  | - unknown size      |  */
/*  |   multi-byte strings|                  | + but size is fixed |  */
/*  | - also used for     |                  | . zero-terminated   |  */
/*  |   raw bytes         |                  |   strings           |  */
/*  `---------------------'                  `---------------------'  */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*   .---------.                              .--------.              */
/*   |   B8    |                              | CHAR   |              */
/*  .'         `----------.                  .'        `-----------.  */
/*  | multibyte           |                  | universal character |  */
/*  | - variable size     |                  | + "all" characters  |  */
/*  | - variing coding    |                  | + fast              |  */
/*  | + many functions    |                  | - platform dependent|  */
/*  | - cannot single char|                  | - unknown size      |  */
/*  | + 'char' compatible |                  | + but size is fixed |  */
/*  `---------------------'                  | . blank-padded      |  */
/*                                           |   strings           |  */
/*                                           `---------------------'  */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


/**********************************************************************/
/*                                                                    */
/*  .----.  .------.  .------.  .---------.  .----.                   */
/*  | UC |  | CHAR |  | char |  | wchar_t |  | B8 |                   */
/*  `----'  `------'  `------'  `---------'  `----'                   */
/*                                                                    */
/* Beside of these three types there are some more character types:   */
/*                                                                    */
/*                                                                    */
/*   .--------.                                                       */
/*   |   U2   |                                                       */
/*  .'        `----------------.                                      */
/*  | ISO Unicode UCS-2        |            The real UCS-2            */
/*  | + 60000 characters       |                                      */
/*  | + coding = UCS-2         |                                      */
/*  | + size   = 2 B           |                                      */
/*  | - unknown byte order     |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .--------.                                                       */
/*   |  UTF8  |                                                       */
/*  .'        `----------------.                                      */
/*  | Unicode Transfer Format  |       Used within some database.     */
/*  | - variable size          |       Used in some files.            */
/*  | - cannot single char     |       Can be used for filenames.     */
/*  | + 2000000000 characters  |                                      */
/*  | + 'char' compatible      |                                      */
/*  | + "file system safe"     |                                      */
/*  | + easy UCS-2 convertable |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .--------.                                                       */
/*   |  UTF7  |                                                       */
/*  .'        `----------------.                                      */
/*  | Unicode Transfer Format  |       Used on some data stream.      */
/*  | - variable size          |       i.e. e-mail                    */
/*  | - cannot single char     |                                      */
/*  | + 2000000000 characters  |                                      */
/*  | + 'char' compatible      |                                      */
/*  | + 7-Bit ASCII compatible |                                      */
/*  | + "file system safe"     |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .--------.                                                       */
/*   |  UTF16 |                                                       */
/*  .'        `----------------.                                      */
/*  | Unicode Transfer Format  |       Unicode 2.0 (with surrogates)  */
/*  | - variable (even) size   |       ISO: UTF-16                    */
/*  | - cannot single char     |       Used in JAVA.                  */
/*  | + 1060000 characters     |                                      */
/*  | + UCS-2 compatible       |                                      */
/*  | + easy UCS-4 convertable |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .--------.                                                       */
/*   |   U4   |                                                       */
/*  .'        `----------------.                                      */
/*  | Unicode 4 byte Format    |       Unicode 2.0  &  ISO            */
/*  | + 2000000000 characters  |                                      */
/*  | + coding = UCS-4         |                                      */
/*  | + size   = 4 B           |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .------.                                                         */
/*   |  B7  |                                                         */
/*  .'      `------------------.                                      */
/*  | Character from 7-Bit set |       "Old C", US-ASCII              */
/*  | - single byte chars      |                                      */
/*  | . zero terminated strings|       Can be 8 bit if used on        */
/*  | + 'char' compatible      |       EBCDIC machine !               */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .------.                                                         */
/*   |  A7  |                                                         */
/*  .'      `------------------.                                      */
/*  | 7-bit-US-ASCII           |       US-ASCII                       */
/*  | - single byte chars      |                                      */
/*  | . zero terminated strings|       Is always ASCII. Even on an    */
/*  | + 'char' compatible      |       EBCDIC machine !               */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .------.                                                         */
/*   |  E8  |                                                         */
/*  .'      `------------------.                                      */
/*  | 8-bit-IBM-500-EBCDIC     |       "international" EBCDIC         */
/*  | - single byte chars      |                                      */
/*  | . IBM-500 coding always  |       even in other countries        */
/*  | + 'char' compatible      |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


/**********************************************************************/
/* wchar_t :   wide character for fast processing                     */
/*             with platform dependent coding.                        */
/*--------------------------------------------------------------------*/
/* This is the C data type as defined by XPG4.                        */
/* A variable of this type can store a wide character.                */
/* The size of this type is platform dependent: often 2 or 4 bytes.   */
/* The coding used is platform dependent and OS release specific.     */
/*--------------------------------------------------------------------*/
/* This type gives direct access to many functions, as has been       */
/* defined in XPG4 and should be implemented everywhere.              */
/*    Classification of a single character:                           */
/*       iswalnum                                                     */
/*       iswalpha                                                     */
/*       iswcntrl                                                     */
/*       iswupper      (Note: most scripts do not have cases.)        */
/*       iswlower                                                     */
/*       iswdigit                                                     */
/*       iswprint                                                     */
/*       wcwidth                                                      */
/*    Simple handling of w-zero terminated strings:                   */
/*       wcscat / wcsncat                                             */
/*       wcscmp / wcsncmp                                             */
/*       wcscpy / wcsncpy                                             */
/*       wcslen                                                       */
/*       wcschr / wcsrchr                                             */
/*       wcspbrk                                                      */
/*       wcsspn / wcscspn                                             */
/*       wcswcs                                                       */
/*       wcstok / wcstok_r                                            */
/*       wcswidth                                                     */
/*    Locale dependent handling of w-zero terminated strings:         */
/*       wcscoll                                                      */
/*       wcsxfrm                                                      */
/*    Conversion functions:                                           */
/*       wcstod / wcstol / wcstoul                                    */
/*       mbtowc / mbstowcs / wctomb / wcstombs                        */
/* Note:                                                              */
/*       wcsftime cannot be used!                                     */
/*--------------------------------------------------------------------*/


/**********************************************************************/
/* SAP_UC:   universal character                                      */
/*--------------------------------------------------------------------*/
/* The size of an universal character is constant and platform        */
/* dependent.                                                         */
/* The coding is platfrom dependent also.                             */
/* It is implementations dependent, wether the coding can vary during */
/* runtime ! ( see setlocale() ).                                     */
/* It is implementations dependent, how many distinct characters can  */
/* be stored. But often all important characters of the world are     */
/* possible.                                                          */
/* To give an idea, why there is this distinction between declared    */
/* features and those which are left 'implementations dependent':     */
/* A specific implementation may map 'SAP_UC' onto                    */
/*  + UCS-2  (16-Bit Unicode, most likely)                            */
/*  + UTF-16 in 32-Bit                                                */
/*  + wchar_t with some propietary coding                             */
/*  + Latin-1 or some other ISO-8859-1 single byte code               */
/*                                                                    */
/* This type gives access to many SAP specific functions.             */
/*--------------------------------------------------------------------*/


/**********************************************************************/
/* SAP_U2:   wide character for Unicode UCS-2                         */
/*--------------------------------------------------------------------*/
/* A variable of this type can store a Unicode UCS-2 character.       */
/* The size of this type is two bytes.                                */
/* The coding used is UCS-2 (ISO 10646). The release of that          */
/* ISO norm is not specified here. It is the most recent release,     */
/* is supported by SAP.                                               */
/* If not explicitelly labeled UTF-16 or SAP_UTF16, surrogates are    */
/* neither expected nor handled.                                      */
/*--------------------------------------------------------------------*/
/* This type gives access to some generic functions, which are        */
/* handled differently on the different platforms, but give the same  */
/* result to all SAP applications.                                    */
/*    Classification of a single character:                           */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Simple handling of zero terminated strings:                     */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Conversion functions:                                           */
/*       SAP_U2_...                                                   */
/*--------------------------------------------------------------------*/

#define U2Null ((SAP_U2)0)

#if defined(WCHAR_is_UCS2) && defined(WCHAR_is_2B)

  typedef wchar_t   SAP_U2;
  typedef wchar_t * SAP_U2S;

#else /* not wchar_t: UCS-2 and 2B */

  typedef SAP_USHORT   SAP_U2 ;
  typedef SAP_USHORT * SAP_U2S;

#endif /* +/- wchar_t: UCS-2 and 2B */

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_U4:   wide character for Unicode UCS-4                         */
/*--------------------------------------------------------------------*/
/* A variable of this type can store a Unicode UCS-4 character.       */
/* The size of this type is four bytes.                               */
/* The coding used is UCS-4 (ISO 10646). The release of that          */
/* ISO norm is not specified here. It is the most recent release,     */
/* is supported by SAP.                                               */
/*--------------------------------------------------------------------*/
/* This type gives access to some generic functions, which are        */
/* handled differently on the different platforms, but give the same  */
/* result to all SAP applications.                                    */
/*    Classification of a single character:                           */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Simple handling of zero terminated strings:                     */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Conversion functions:                                           */
/*       SAP_U4_...                                                   */
/*--------------------------------------------------------------------*/

#define U4Null ((SAP_U4)0)

#if defined(WCHAR_is_UCS4) && defined(WCHAR_is_4B)

  typedef wchar_t   SAP_U4;
  typedef wchar_t * SAP_U4S;

#else /* not wchar_t: UCS-4 and 4B */

  typedef SAP_UINT   SAP_U4 ;
  typedef SAP_UINT * SAP_U4S;

#endif /* +/- wchar_t: UCS-4 and 4B */

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_UTF16:   wide character for Unicode UTF16                      */
/*--------------------------------------------------------------------*/
/* This type cannot be used to define a variable for a single         */
/* character !                                                        */
/* The size of this type is two bytes.                                */
/* The coding used is UTF16 (ISO 10646). The release of that          */
/* ISO norm is not specified here. It is the most recent release,     */
/* is supported by SAP.                                               */
/* This is the same as "Unicode 2.0" with surrogates.                 */
/*--------------------------------------------------------------------*/
/* This type gives access to some generic functions, which are        */
/* handled differently on the different platforms, but give the same  */
/* result to all SAP applications.                                    */
/*    Classification of a single character:                           */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Simple handling of zero terminated strings:                     */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Conversion functions:                                           */
/*       SAP_UTF16_...                                                */
/*--------------------------------------------------------------------*/

#define UTF16Null ((SAP_UTF16)0)

#if (defined(WCHAR_is_UCS2) || defined(WCHAR_is_UTF16)) \
    && defined(WCHAR_is_2B)

  typedef wchar_t   SAP_UTF16;
  typedef wchar_t * SAP_UTF16S;

#else /* not wchar_t: UCS-2 or UTF-16 and 2B */

  typedef SAP_USHORT   SAP_UTF16 ;
  typedef SAP_USHORT * SAP_UTF16S;

#endif /* +/- wchar_t: UCS-2 or UTF16 and 2B */

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_B8:   bytes storing multibyte characters                       */
/*--------------------------------------------------------------------*/
/* This type cannot be used to define a variable for a single         */
/* character !                                                        */
/* A string of this type can store characters using one or more bytes */
/* for each character.                                                */
/* The coding varies during runtime ! ( see setlocale() ).            */
/* The type SAP_B8 is compatible to char. It is used for              */
/* documentation purposes. It marks char[] which may contain          */
/* multibyte characters.                                              */
/*--------------------------------------------------------------------*/
/* This type gives direct access to many functions, as has been       */
/* defined in ANSI C and XPG4 and should be implemented everywhere.   */
/*    Classification of a single character:                           */
/*       mblen                                                        */
/*    Simple handling of zero terminated strings:                     */
/*       strcat                                                       */
/*       strcmp                                                       */
/*       strcpy                                                       */
/*       strlen    (not number of chars, but number of bytes!)        */
/*    Conversion functions:                                           */
/*       strcoll / strxfrm                                            */
/*       mbtowc / mbstowcs / wctomb / wcstombs                        */
/* Note:                                                              */
/* The character classification functions isprint, isalpha,.. are     */
/* only valid, if(mblen(ptr)==1)                                      */
/*--------------------------------------------------------------------*/

typedef char   SAP_B8 ;
#define        B8Null   ((SAP_B8)0)

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_UTF8:   bytes storing multibyte characters with UTF-8 coding   */
/*--------------------------------------------------------------------*/
/* This type cannot be used to define a variable for a single         */
/* character !                                                        */
/* A string of this type can store characters using one or more bytes */
/* for each character.                                                */
/* The coding is defined with Unicode.                                */
/* The type SAP_UTF8 is compatible to char. It is used for            */
/* documentation purposes. It marks char[] which may contain          */
/* UTF-8 multibyte characters.                                        */
/*--------------------------------------------------------------------*/
/* This type gives direct access to some functions, as has been       */
/* defined in ANSI C and XPG4 and should be implemented everywhere.   */
/*    Simple handling of zero terminated strings:                     */
/*       strcat                                                       */
/*       strcmp                                                       */
/*       strcpy                                                       */
/*       strlen    (not number of chars, but number of bytes!)        */
/*--------------------------------------------------------------------*/

typedef unsigned char   SAP_UTF8 ;
#define                 UTF8Null    ((SAP_UTF8)0)

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_UTF7:   bytes storing multibyte characters with UTF-7 coding   */
/*--------------------------------------------------------------------*/
/* This type cannot be used to define a variable for a single         */
/* character !                                                        */
/* A string of this type can store characters using one or more bytes */
/* for each character.                                                */
/* The coding is defined with Unicode.                                */
/* The type SAP_UTF7 is compatible to char. It is used for            */
/* documentation purposes. It marks char[] which may contain          */
/* UTF-7 multibyte characters.                                        */
/* Note: UTF-7 encoding has modes! You always have to convert a whole */
/*       chunck of data (i.e. whole lines)                            */
/*--------------------------------------------------------------------*/
/* This type gives direct access to some functions, as has been       */
/* defined in ANSI C and XPG4 and should be implemented everywhere.   */
/*    Simple handling of zero terminated strings:                     */
/*       strlen    (not number of chars, but number of bytes!)        */
/*--------------------------------------------------------------------*/

typedef unsigned char   SAP_UTF7 ;
#define                 UTF7Null     ((SAP_UTF7)0)

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_A7:   a byte storing a 7-bit-US-ASCII character                */
/*--------------------------------------------------------------------*/
/* The coding is defined as 7-Bit US-ASCII. This is platform          */
/* independent. Even on an EBCDIC machine, variables of type SAP_A7   */
/* contain ASCII. Also it never contains national characters.         */
/* SAP_A7 values are compatible to UTF-8. (Only one direction.)       */
/* When text fields of SAP_A7 are defined, we expect a terminating    */
/* null.                                                              */
/* SAP_A7_A has same implementation as SAP_A7. It shall be used, when */
/* blank-padded non-terminated text fields are defined.               */
/*--------------------------------------------------------------------*/

typedef char   SAP_A7;
#define        A7Null   ((SAP_A7)0)

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_B7:   byte storing an English character or simple symbol       */
/*--------------------------------------------------------------------*/
/* The coding is defined either 7-Bit US-ASCII or a subset of EBCDIC. */
/* The type SAP_B7 is compatible to char. It is used for              */
/* documentation purposes. It marks char[] which never contain        */
/* national characters.                                               */
/*--------------------------------------------------------------------*/

typedef char SAP_B7;
#define      B7Null    ((SAP_B7)0)

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_E8:   a byte storing a 7-bit-US-ASCII character                */
/*--------------------------------------------------------------------*/
/* The coding is defined as 8-Bit IBM 500 EBCDIC. This is platform    */
/* independent. Even on an ASCII machine, variables of type SAP_E8    */
/* contain EBCDIC. If it contains national characters, these are from */
/* the western European area.                                         */
/* When text fields of SAP_E8 are defined, we expect a terminating    */
/* null.                                                              */
/* SAP_E8_A has same implementation as SAP_E8. It shall be used, when */
/* blank-padded non-terminated text fields are defined.               */
/*--------------------------------------------------------------------*/

#if defined (SAPonOS400)
  typedef          char   SAP_E8;
#else /* normal UNIX or NT */
  typedef unsigned char   SAP_E8;
#endif
#define                   E8Null   ((SAP_E8)0)

#ifdef SAPonOS400
#include "o4global.h"
#endif

/* All other routines are in "sapuc2.h". */

#endif /* SAPUC_H */
