
/*!**********************************************************************

  module: vls31_odbc_Result.cpp

  -----------------------------------------------------------------------

  responsible : d033893 and SteffenS

  special area: SAP DB LOADER

  description : odbc

  version     : 7.5.

  see also:

  -----------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gls00.h"
#include "hls10.h"
#include "hls13.h"
#include "hls11.h"
#include "hls15.h"
#include "hls30.h"
#include "hls99.h"
#include "heo01.h"
#include "hsp100.h"
#include "hls31_odbc_Result.h"

#define SEPARATOR   ""CMD_SEPARATOR_TOKEN_LS00""NEW_LINE_LS00""

_TCHAR const *pszSQLModeString_ls31[6] = {_T("NOT USED"),
                                          _T("SQLMODE INTERNAL"NEW_LINE_LS00""),
                                          _T("SQLMODE DB2"NEW_LINE_LS00""),
                                          _T("SQLMODE ANSI"NEW_LINE_LS00""),
                                          _T("SQLMODE ORACLE"NEW_LINE_LS00""),
                                          _T("SQLMODE SAPR3"NEW_LINE_LS00"")};

_TCHAR const *pszLoadCmdBeginString2[6] = {_T("NOT USED"),
                                          _T("DATALOAD TABLE "),
                                          _T("FASTLOAD WITH 80%% USAGE TABLE "),
                                          _T("DATAUPDATE TABLE "),
                                          _T("DATALOAD TABLE "),
                                          _T("FASTLOAD WITH 80%% USAGE TABLE ")};

_TCHAR const *pszDateTimeType2[6] = {_T("FREE MASK"),
                                    _T("ISO"),
                                    _T("USA"),
                                    _T("EUR"),
                                    _T("JIS"),
                                    _T("INTERNAL")};

_TCHAR const *pszEncoding2[8] = {_T("NOT USED"),
                                _T("ASCII"),
                                _T("EBCDIC"),
                                _T("UTF8"),
                                _T("BINARY"),
                                _T("UCS2"),
                                _T("UCS2"),
                                _T("UCS2")};

GUIDGenerator* GUIDGenerator::_guidinstance = NULL;

/*===========================================================================*
 *    GUIDGenerator::Instance()
 *===========================================================================*/
GUIDGenerator* GUIDGenerator::Instance()
{
    // Das ist die funktion, die die Objektinstanz kontrolliert

    if  (_guidinstance == NULL)
         _guidinstance = new GUIDGenerator();
    return _guidinstance;
};
/*===========================================================================*
 *    GUIDGenerator::GUIDGenerator()
 *===========================================================================*/
GUIDGenerator::GUIDGenerator()
{
    Id_Init();
}
/*===========================================================================*
 *    GUIDGenerator::~GUIDGenerator()
 *===========================================================================*/
GUIDGenerator::~GUIDGenerator()
{
}
/*===========================================================================*
 *    GUIDGenerator::Id_Init
 *===========================================================================*/
SAPDB_Bool GUIDGenerator::Id_Init()
{
    if (idManagementInitialized == SAPDB_FALSE)
        RTE_InitIdGenerator();
    return SAPDB_TRUE;
}
/*===========================================================================*
 *    GUIDGenerator::IdGetNext
 *===========================================================================*/
SAPDB_Bool GUIDGenerator::IdGetNext( GUID_Id id )
{
    if (!RTE_FillUniqueId(&hIdManagement))
        return SAPDB_FALSE;
    memcpy(id, &hIdManagement, GUID_MAX_ID_LEN);

    return SAPDB_TRUE;
}
/*===========================================================================*
 *    GUIDGenerator::IdAsString
 *===========================================================================*/
void GUIDGenerator::IdAsString( GUID_Id id, GUID_IdString idString )
{
    SAPDB_UInt2 i = 0;

    for (i = 0; i < GUID_MAX_ID_LEN; i++ )
        sprintf( idString + (i*2), "%02X", (unsigned char)id[i] );

    idString[GUID_MAX_ID_STRING_LEN] = '\0';
}
/*===========================================================================*
 *    GUIDGenerator::IdInitValue
 *===========================================================================*/
void GUIDGenerator::IdInitValue( GUID_Id  id )
{
     memset(id, 0, GUID_MAX_ID_LEN);
}
/*===========================================================================*
 *    GUIDGenerator::IdStringInitValue
 *===========================================================================*/
void GUIDGenerator::IdStringInitValue( GUID_IdString idString )
{
     strncpy(idString, ID_ROOT_STRING, GUID_MAX_ID_STRING_LEN);
     idString[GUID_MAX_ID_STRING_LEN] = '\0';
}
/*===========================================================================*
 *    GUIDGenerator::IdIsInitialValue
 *===========================================================================*/
SAPDB_Bool GUIDGenerator::IdIsInitialValue( GUID_Id id )
{
    if (memcmp(id, ID_INITIAL, GUID_MAX_ID_LEN) == 0)
        return SAPDB_TRUE;
    else
        return SAPDB_FALSE;
}
/*===========================================================================*
 *    GUIDGenerator::IdStringIsInitialValue
 *===========================================================================*/
SAPDB_Bool GUIDGenerator::IdStringIsInitialValue( GUID_IdString idString )
{
    if (memcmp(idString, ID_INITIAL_STRING, GUID_MAX_ID_STRING_LEN) == 0)
        return SAPDB_TRUE;
    else
        return SAPDB_FALSE;
}
/*===========================================================================*
 *    GUIDGenerator::IdsAreIdentical
 *===========================================================================*/
SAPDB_Bool GUIDGenerator::IdsAreIdentical( GUID_Id id1, GUID_Id id2 )
{
    if (memcmp(id1, id2, GUID_MAX_ID_LEN) == 0)
        return SAPDB_TRUE;
    else
        return SAPDB_FALSE;
}
/*===========================================================================*
 *    GUIDGenerator::IdStringsAreIdentical
 *===========================================================================*/
SAPDB_Bool GUIDGenerator::IdStringsAreIdentical( GUID_IdString idString1, GUID_IdString idString2 )
{
    if (memcmp(idString1, idString2, GUID_MAX_ID_STRING_LEN) == 0)
        return SAPDB_TRUE;
    else
        return SAPDB_FALSE;
}

/*===========================================================================*
 *     MetaDataDef::MetaDataDef()
 *===========================================================================*/
MetaDataDef::MetaDataDef( tls00_DBInfo * pDBInfo )
            :m_pDBInfo(pDBInfo)
{
    m_pError = new sapdb_Error();

    // Meta Data
    m_pTransformationDef   = NULL;
    m_pCatalogLoadDef      = NULL;

    m_pUserModeDef         = NULL;
    m_pCURUserDef          = NULL;

    m_pUserDef             = NULL;
    m_pRoleDef             = NULL;
    m_pTableDef            = NULL;
    m_pViewDef             = NULL;
    m_pSynonymDef          = NULL;
    m_pTriggerDef          = NULL;
    m_pDBProcedureDef      = NULL;
    m_pGrantDBProcedureDef = NULL;
    m_pColumnTypeDef       = NULL;
    m_pIndexDef            = NULL;
    m_pSequenceDef         = NULL;

    m_nSchemaCount             = 0;
    m_nTableCount              = 0;
    m_nSynonymCount            = 0;
    m_nViewCount               = 0;

    m_catTransMode             = tmUnknown_els31;
    m_catExtrMode              = emUnknown_els00;

    switch(pDBInfo->dbiSession_ls00.siSQLMode_ls00)
    {
        case sp1sm_db2:
        {
            m_catSqlMode = cpr_kind_db2;
            break;
        }
        case sp1sm_ansi:
        {
            m_catSqlMode = cpr_kind_ansi;
            break;
        }
        case sp1sm_oracle:
        {
            m_catSqlMode = cpr_kind_oracle;
            break;
        }
        case sp1sm_internal:
        default:
        {
            m_catSqlMode = cpr_kind_internal;
        }
    }
}
/*===========================================================================*
 *     MetaDataDef::~MetaDataDef
 *===========================================================================*/
MetaDataDef::~MetaDataDef()
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::~MetaDataDef()");

    if( m_pTransformationDef  != NULL )
    {
        delete m_pTransformationDef;
        m_pTransformationDef = NULL;
    }
    if ( m_pCatalogLoadDef    != NULL )
    {
        delete m_pCatalogLoadDef;
        m_pCatalogLoadDef = NULL;
    }
    if ( m_pCURUserDef  != NULL )
    {
         delete m_pCURUserDef;
         m_pCURUserDef = NULL;
    }
    if ( m_pUserDef       != NULL )
    {
        delete m_pUserDef;
        m_pUserDef = NULL;
    }
    if ( m_pRoleDef       != NULL )
    {
        delete m_pRoleDef;
        m_pRoleDef = NULL;
    }
    if( m_pTableDef      != NULL )
    {
        delete m_pTableDef;
        m_pTableDef = NULL;
    }
    if( m_pViewDef       != NULL )
    {
        delete m_pViewDef;
        m_pViewDef  = NULL;
    }
    if( m_pSynonymDef    != NULL )
    {
        delete m_pSynonymDef;
        m_pSynonymDef = NULL;
    }
    if( m_pTriggerDef    != NULL )
    {
        delete m_pTriggerDef;
        m_pTriggerDef = NULL;
    }
    if( m_pColumnTypeDef != NULL )
    {
        delete m_pColumnTypeDef;
        m_pColumnTypeDef = NULL;
    }
    if( m_pIndexDef      != NULL )
    {
        delete m_pIndexDef ;
        m_pIndexDef = NULL;
    }
    if( m_pSequenceDef   != NULL )
    {
        delete m_pSequenceDef;
        m_pSequenceDef = NULL;
    }
    if( m_pDBProcedureDef != NULL)
    {
        delete m_pDBProcedureDef;
        m_pDBProcedureDef = NULL;
    }
    if( m_pTriggerDef != NULL )
    {
        delete m_pTriggerDef;
        m_pTriggerDef = NULL;
    }
    if ( m_pError != NULL )
    {
        delete m_pError;
        m_pError = NULL;
    }
}
/*===========================================================================*
 *     MetaDataDef::writeCatalogHeader
 *===========================================================================*/
SAPDB_Bool MetaDataDef::writeCatalogHeader ()
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    if ( getExtrMode() == emExtractAsXML_els00 )
    {
    }
    if ( getExtrMode() == emExtractAsDDL_els00 )
    {
    }
    return isOk;
}

/*===========================================================================*
 *     MetaDataDef::writeCatalogFooter
 *===========================================================================*/
SAPDB_Bool MetaDataDef::writeCatalogFooter ()
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    StudioOAL_String catalogObjects;

    if (emExtractAsXML_els00 == getExtrMode())
    {
        if ( getTransformationModel()->m_nObjectCount == 0 )
        {
            catalogObjects  = "</dbm:CatalogSchemas>\n"
                              "</dbm:DeployedCatalog>\n"
                              "</dbm:DataSourceDeployedCatalogs>\n"
                              "</dbm:DataSource>\n"
                              "</uml:ModelPackages>\n"
                              "</uml:Model>\n"
                              "</uml:SystemModels>\n"
                              "</uml:System>\n"
                              "</oim:Transfer>\n";
        }
        if ( getTransformationModel()->m_nObjectCount != 0 )
        {
            catalogObjects  = "</uml:NamespaceOwnedElement>\n"
                              "</sapdbm:DeployedSchema>\n"
                              "</uml:NamespaceOwnedElement>\n"
                              "</dbm:CatalogSchemas>\n"
                              "</dbm:DeployedCatalog>\n"
                              "</dbm:DataSourceDeployedCatalogs>\n"
                              "</dbm:DataSource>\n"
                              "</uml:ModelPackages>\n"
                              "</uml:Model>\n"
                              "</uml:SystemModels>\n"
                              "</uml:System>\n"
                              "</oim:Transfer>\n";
        }
    }
    else if (emExtractAsDDL_els00 == getExtrMode())
        catalogObjects = SEPARATOR;

    return writeLine ( catalogObjects );
}
/*===========================================================================*
 *     MetaDataDef::setODBCDriver
 *===========================================================================*/
SAPDB_Bool MetaDataDef::setODBCDriver( tls00_DBInfo *pDBSession )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::setODBCDriver");

    RepServMessages *pMsgInstance = RepServMessages::Instance();
    SAPDB_Bool isOk = SAPDB_FALSE;

    StudioOAL_String odbcDriver;

    if ( 7 == pDBSession->dbiDBVersion_ls00.MajorVersion_sp100 &&
         2 == pDBSession->dbiDBVersion_ls00.MinorVersion_sp100  )
    {
        m_odbcDriver = "LiveCache 7.2";
        isOk         = SAPDB_TRUE;
    }
    if ( 7 == pDBSession->dbiDBVersion_ls00.MajorVersion_sp100 &&
         3 == pDBSession->dbiDBVersion_ls00.MinorVersion_sp100  )
    {
        m_odbcDriver = "SAP DB 7.3";
        isOk         = SAPDB_TRUE;
    }
    if ( 7 == pDBSession->dbiDBVersion_ls00.MajorVersion_sp100 &&
         4 == pDBSession->dbiDBVersion_ls00.MinorVersion_sp100  )
    {
        m_odbcDriver = "SAP DB";
        isOk         = SAPDB_TRUE;
    }

    return isOk;
}
/*===========================================================================*
 *     MetaDataDef::initResultSets
 *===========================================================================*/
SAPDB_Bool MetaDataDef::initResultSets( tls00_DBInfo *pDBSession )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::initResultSets");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Bool rc = SAPDB_TRUE;

    setODBCDriver        ( pDBSession );
    setMaxErrorCount     ( pDBSession->dbiSession_ls00.siMaxAdmissibleErrors);

    // Set current logged on user
    StudioOAL_String UserName;
    UserName.ConvertFromASCII_Latin1(pDBSession->dbiSession_ls00.siUserName_ls00,
                                     pDBSession->dbiSession_ls00.siUserName_ls00+strlen(pDBSession->dbiSession_ls00.siUserName_ls00));
    m_currentUser = UserName;

    if ( NULL == m_pTransformationDef )
    {
         m_pTransformationDef = new TransformationDef(pDBSession->dbiOdbcConnection, this );
         m_pTransformationDef->initResultSet(pDBSession->dbiOdbcConnection);
    }
    if ( NULL ==  m_pCURUserDef )
         m_pCURUserDef      = new CURUserDef    ( pDBSession->dbiOdbcConnection, this );
    if ( NULL ==  m_pUserDef)
         m_pUserDef         = new UserDef       ( pDBSession->dbiOdbcConnection, this );
    if ( NULL ==  m_pRoleDef)
         m_pRoleDef         = new RoleDef       ( pDBSession->dbiOdbcConnection, this );
    if ( NULL ==  m_pTableDef)
         m_pTableDef        = new TableDef      ( pDBSession->dbiOdbcConnection, this );
    if ( NULL == m_pViewDef )
         m_pViewDef         = new ViewDef       ( pDBSession->dbiOdbcConnection, this );
    if ( NULL ==  m_pSynonymDef)
         m_pSynonymDef      = new SynonymDef    ( pDBSession->dbiOdbcConnection, this );
    if ( NULL ==  m_pTriggerDef )
         m_pTriggerDef      = new TriggerDef    ( pDBSession->dbiOdbcConnection, this );
    if ( NULL == m_pDBProcedureDef )
         m_pDBProcedureDef  = new DBProcedureDef( pDBSession->dbiOdbcConnection, this );
    if ( NULL ==  m_pColumnTypeDef )
         m_pColumnTypeDef   = new ColumnTypeDef ( pDBSession->dbiOdbcConnection, this );
    if ( NULL == m_pIndexDef )
         m_pIndexDef        = new IndexDef      ( pDBSession->dbiOdbcConnection, this );
    if ( NULL == m_pSequenceDef )
         m_pSequenceDef     = new SequenceDef   ( pDBSession->dbiOdbcConnection, this );
    if ( NULL == m_pCatalogLoadDef )
         m_pCatalogLoadDef  = new CatalogLoadDef( pDBSession->dbiOdbcConnection, this );

#ifdef ODBC_PREPARED
    if (SAPDB_TRUE == rc)
        rc = m_pUserModeDef      ->initResultSet(pDBSession->dbiOdbcConnection);
    if (SAPDB_TRUE == rc)
        rc = m_pTransformationDef->initResultSet(pDBSession->dbiOdbcConnection);
    if (SAPDB_TRUE == rc)
    {
        if ( emLoadAsXML_els00 == getExtrMode() || emLoadAsDDL_els00 == getExtrMode() )
             rc                    = m_pCatalogLoadDef->initResultSet(pDBSession->dbiOdbcConnection);
        else
        {
            if (SAPDB_TRUE == rc)
                rc                 = m_pCURUserDef->initResultSet(pDBSession->dbiOdbcConnection);
            if (SAPDB_TRUE == rc)
                rc                 = m_pUserDef->initResultSet(pDBSession->dbiOdbcConnection);
            if (SAPDB_TRUE == rc)
                rc                 = m_pRoleDef->initResultSet(pDBSession->dbiOdbcConnection);
            if (SAPDB_TRUE == rc)
                rc                 = m_pTableDef->initResultSet(pDBSession->dbiOdbcConnection);
            if (SAPDB_TRUE == rc)
                rc                 = m_pViewDef->initResultSet(pDBSession->dbiOdbcConnection);
            if (SAPDB_TRUE == rc)
                rc                 = m_pSynonymDef->initResultSet(pDBSession->dbiOdbcConnection);
            if (SAPDB_TRUE == rc)
                rc                 = m_pTriggerDef->initResultSet(pDBSession->dbiOdbcConnection);
            if (SAPDB_TRUE == rc)
                rc                 = m_pDBProcedureDef->initResultSet(pDBSession->dbiOdbcConnection);
            if (SAPDB_TRUE == rc)
                rc                 = m_pColumnTypeDef->initResultSet(pDBSession->dbiOdbcConnection);
            if (SAPDB_TRUE == rc)
                rc                 = m_pIndexDef->initResultSet(pDBSession->dbiOdbcConnection);
            if (SAPDB_TRUE == rc)
                rc                 = m_pSequenceDef->initResultSet(pDBSession->dbiOdbcConnection);
        }
    }
#endif
    return rc;
}

/*===========================================================================*
 *  MetaDataDef::setCurrentUser
 *===========================================================================*/
void MetaDataDef::setCurrentUser(StudioOAL_String& username )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::setCurrentUser");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    if (ptAll_els00 == getPartSpec().psPartType_ls00)
    {
        if (0 != username.Compare( m_currentUser) )
        {
            // catalog extract/load all
            StudioOAL_String  currentUserCmd;
            StudioOAL_String  currentUser;
            StudioOAL_String  currentPassword = "initial ";
            StudioOAL_String  dbaUser;

           /*-------------------------------------------------------------------------*
            * Prepare the security context for the SQL statements.
            *-------------------------------------------------------------------------*/
            currentUserCmd  = "CURRENT USER ";
            currentUserCmd  += username;

            /*-------------------------------------------------------------------------------*
             * Read/Write the catalog definition of the specified object from/to resources   *
             *-------------------------------------------------------------------------------*/
            if (  m_pCURUserDef->executeSQL( currentUserCmd ) )
            {
                m_currentUser = username;

                if (emExtractAsDDL_els00 == getExtrMode())
                {
                    currentUser   = SEPARATOR;

                    if ( getSqlMode() != cpr_kind_internal )
                    {
                        currentUser += pszSQLModeString_ls31[cpr_kind_internal];
                        currentUser += SEPARATOR;
                    }

                    tls00_DBInfo * pOIConnection = getConnection();
                    dbaUser.ConvertFromASCII_Latin1(pOIConnection->dbiSYSDBA_Name_ls00.asCharp(),
                                                    pOIConnection->dbiSYSDBA_Name_ls00.asCharp() +
                                                    pOIConnection->dbiSYSDBA_Name_ls00.length() );

                    if ( dbaUser.Compare( username ) == 0 )
                    {
                        SAPDB_Char       destBeg[1000] ;
                        memset(destBeg,0,sizeof(destBeg));
                        SAPDB_UInt4      destAt = 1000;
                        currentPassword.Erase();

                        pOIConnection->dbiOdbcConnection.GetPassword( REINTERPRET_CAST(unsigned char*,destBeg ),destAt);
                        currentPassword.ConvertFromASCII_Latin1(destBeg,destBeg+strlen(destBeg));
                    }

                    currentUser += "USE USER ";
                    currentUser += username;
                    currentUser += " ";
                    currentUser += currentPassword;

                    m_pCURUserDef->writeLine( currentUser );
                }// end if (emExtractAsDDL_els00 == getExtrMode())
            }
        }
    }// end if ( (ptAll_els00 == getPartSpec().psPartType_ls00)  && ...
    else if (ptUser_els00 == getPartSpec().psPartType_ls00)
        m_currentUser = username;
    else
        m_currentUser = username;
}
/*===========================================================================*
 *  MetaDataDef::getCurrentUser
 *===========================================================================*/
StudioOAL_String MetaDataDef::getCurrentUser()
{
    return m_currentUser;
}
/*===========================================================================*
 *  MetaDataDef::ExtrCatalogCmd                                          *
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::ExtrCatalogCmd( StudioOAL_String username )
{
     ROUTINE_DBG_MEO00 ("MetaDataDef::ExtrAllCmd");

     RepServMessages *pMsgInstance = RepServMessages::Instance();

     SAPDB_Int4 rc = errOK_els00;

     StudioOAL_String  transformationpackage;
     StudioOAL_String  currentuser;

     //*
     //*  extract connection object
     //*
     connectionExtrCmd  ( );
     //*
     //*  extract authorization objects, schema and privilegies
     //*
     userExtrCmd  ( getPartSpec() );
     roleExtrCmd  ( getPartSpec() );
     //*
     //*  extract catalog objects
     //*
     sequenceExtrCmdDirect   ( getPartSpec() );
     tabletypeExtrCmdDirect  ( getPartSpec() );
     dbprocedureExtrCmdDirect( getPartSpec() );

     writeCatalogFooter();
     //*
     //* statistic of extracted catalog objects
     //*
     pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumTabTransformed_els98     , m_nTableCount   );
     pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumViewsTransformed_els98   , m_nViewCount    );
     pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumSynonymsTransformed_els98, m_nSynonymCount );
     //*
     //*  unload transformationpackage
     //*
     setCurrentUser( username );

     return rc;
}
/*===========================================================================*
 *  MetaDataDef::ExtrSchemaCmd                                           *
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::ExtrSchemaCmd(  StudioOAL_String username )
{
     ROUTINE_DBG_MEO00 ("MetaDataDef::ExtrSchemaCmd");

     RepServMessages *pMsgInstance = RepServMessages::Instance();

     SAPDB_Int4 rc = errOK_els00;

     setCurrentUser    ( username );
     //*
     //*  extract connection object
     //*
     connectionExtrCmd  ( );
     //*
     //*  extract authorization objects, schema and privilegies
     //*
     userExtrCmd  ( getPartSpec() );
     roleExtrCmd  ( getPartSpec() );
     //*
     //* extract catalog objects
     //*
     sequenceExtrCmdDirect   ( getPartSpec() );
     tabletypeExtrCmdDirect  ( getPartSpec() );
     dbprocedureExtrCmdDirect( getPartSpec() );

     writeCatalogFooter();

     //*
     //*  statistic of extracted catalog objects
     //*
     pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumTabTransformed_els98     , m_nTableCount   );
     pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumViewsTransformed_els98   , m_nViewCount    );
     pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumSynonymsTransformed_els98, m_nSynonymCount );

     return rc;
}
/*===========================================================================*
 *  MetaDataDef::ExtrTableCmd
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::ExtrTableCmd ( tls00_PartSpec  catpartSpec )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::ExtrTableCmd");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Int4 rc = errOK_els00;
    //*
    //*  extract connection object
    //*
    connectionExtrCmd( );
    //*
    //* extract catalog objects
    //*
    tabletypeExtrCmdDirect( catpartSpec );

    writeCatalogFooter();
    //*
    //*  statistic of extracted catalog objects
    //*
    pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumTabTransformed_els98     , m_nTableCount  );
    pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumViewsTransformed_els98   , m_nViewCount   );
    pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumSynonymsTransformed_els98, m_nSynonymCount);

    return rc;
}
/*===========================================================================*
 *  MetaDataDef::LoadAllCmd                                              *
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::LoadCatalogCmd( StudioOAL_String username )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::LoadCatalogCmd");

    SAPDB_Int4 rc = LoadSchemaCmd(username);       // no hierarchy here; its simply the same procedure

    return rc;
}
/*===========================================================================*
 *  MetaDataDef::LoadSchemaCmd                                           *
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::LoadSchemaCmd( StudioOAL_String username )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::LoadSchemaCmd");

    SAPDB_Bool rcBool = SAPDB_TRUE;
    SAPDB_Bool rcRead = SAPDB_TRUE;
    SAPDB_Int4 rc     = errOK_els00;

    StudioOAL_String  line;
    StudioOAL_String  definition;
    StudioOAL_String  sqlmode    = "SQLMODE";
    StudioOAL_String  use        = "USE";
    StudioOAL_String  user       = "USER";
    StudioOAL_String  currentuser("CURRENT USER ");
    StudioOAL_String  whitespace((SAPDB_UTF8*)" ");
    StudioOAL_String  token      = CMD_SEPARATOR_TOKEN_LS00;

    SAPDB_Int4 lMaxFailedStmt = getMaxErrorCount();

    // read token
    while ( (errOK_els00 == rc) && (SAPDB_TRUE == (rcRead = readLine ( line )) ) )
    {
        line.Trim();
        if ( 0 != token.Compare(line.SubStr(0,CMD_SEPARATOR_TOKEN_LEN_LS00) ) )
        {
            definition += whitespace;
            definition += line;
        }
        else
        {
            if ( SAPDB_FALSE == definition.Empty() )
            {
                definition.Trim();
                // sqlmode statement
                if ( sqlmode.Compare(definition.SubStr(0,7) ) == 0 )
                {
                    definition = definition.SubStr(7,definition.Length());
                    definition.Trim();
                    m_pCatalogLoadDef->setSQLMode( definition );
                }
                else
                {
                    // convert use user statement to current user statement
                    if ( use.Compare(definition.SubStr(0,3) ) == 0 )
                    {
                        definition = definition.SubStr(3,definition.Length());
                        definition.Trim();
                        if ( user.Compare(definition.SubStr(0,4) ) == 0 )
                        {
                            definition = definition.SubStr(4,definition.Length());
                            definition.Trim();

                            definition = definition.SubStr(0,definition.FindFirstOf(whitespace));

                            currentuser += definition;
                            definition  = currentuser;
                            currentuser = "CURRENT USER ";
                        }
                    }
                    rcBool = m_pCatalogLoadDef->executeSQL( definition );
                    if (SAPDB_FALSE == rcBool)
                    {
                        // Check count of failed statements and report last error to client
                        if (0 == --lMaxFailedStmt)
                        {
                            m_pError->isError(SAPDB_TRUE);
                            m_pError->setErrorText(m_pCatalogLoadDef->getErrorText());
                            rc = errODBCErrors_els98;
                        }
                    }
                }
                definition.Erase();
            }   // end if ( SAPDB_FALSE == definition.Empty() )

        }   // end else of if ( 0 != token.Compare(line.SubStr(0,CMD_SEPARATOR_TOKEN_LEN_LS00) ) )
        line.Erase();

    }   // end while ( readLine ( line ) == SAPDB_TRUE )

    if (errOK_els00 == rc)
    {
        if ( SAPDB_FALSE == rcRead && errOK_els00 != m_pError->getReturnCode() )
            rc = m_pError->getReturnCode();
    }

    // Reset the connected user to the user issuing the command - in any case
    currentuser = "CURRENT USER ";
    currentuser += username;

    if (SAPDB_FALSE == m_pCatalogLoadDef->executeSQL (currentuser))
    {
        if (errOK_els00 == rc)
        {
            m_pError->isError(SAPDB_TRUE);
            m_pError->setErrorText(m_pCatalogLoadDef->getErrorText());
            rc = errODBCErrors_els98;
        }
    }
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::LoadTableCmd
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::LoadTableCmd ( tls00_PartSpec  catpartSpec )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::LoadTableCmd");

    SAPDB_Int4 rc     = errOK_els00;
    SAPDB_Bool rcRead = SAPDB_TRUE;
    SAPDB_Bool rcBool = SAPDB_TRUE;

    StudioOAL_String  line;
    StudioOAL_String  definition;
    StudioOAL_String  tempdefinition;
    StudioOAL_String  sqlmode    = "SQLMODE";
    StudioOAL_String  token      = CMD_SEPARATOR_TOKEN_LS00;
    StudioOAL_String  whitespace((SAPDB_UTF8*)" ");

    SAPDB_Int4        lMaxFailedStmt = getMaxErrorCount();

    // read token
    while ( (errOK_els00 == rc) && (SAPDB_TRUE == (rcRead = readLine ( line )) ) )
    {
        line.TrimLeft();

        // Build definition;
        // doing so we'll find command separators which are to be ignored; the thingies between
        // the separators are the commands we are intereseted in
        if (0 != token.Compare(line.SubStr(0,CMD_SEPARATOR_TOKEN_LEN_LS00) ) )
        {
            definition += whitespace;
            definition += line;
        }
        else
        {// read token and execute definition
            if ( SAPDB_FALSE == definition.Empty() )
            {
                definition.TrimLeft();

                if (0 == sqlmode.Compare(definition.SubStr(0,7) ) )
                {
                    definition = definition.SubStr(7,definition.Length());
                    definition.TrimLeft();
                    m_pCatalogLoadDef->setSQLMode( definition );
                }
                else
                {
                    rcBool = m_pCatalogLoadDef->executeSQL( definition );
                    if (SAPDB_FALSE == rcBool)
                    {
                        // Check count of failed statements and report last error to client
                        if (0 == --lMaxFailedStmt)
                        {
                            m_pError->isError(SAPDB_TRUE);
                            m_pError->setErrorText(m_pCatalogLoadDef->getErrorText());
                            rc = errODBCErrors_els98;
                        }
                    }
                }
                definition.Erase();
            }
        }   // end else of if (0 != token.Compare(line.SubStr(0,CMD_SEPARATOR_TOKEN_LEN_LS00) ) )

    }   // end while

    if (errOK_els00 == rc)
    {
        if ( (SAPDB_FALSE == rcRead) && (errOK_els00 != m_pError->getReturnCode()) )
            rc = m_pError->getReturnCode();
    }

    return rc;
}
/*===========================================================================*
 *  MetaDataDef::readLine
 *===========================================================================*/
SAPDB_Bool MetaDataDef::readLine( StudioOAL_String &record  )
{
    SAPDB_Int4 rc = ls30VFReadLnEx(m_FileSession.vFile, m_ReadBuffer, m_ReadWriteErrText, 0);
    if (rc > 0)
        record = StudioOAL_String( (SAPDB_UTF8* )m_ReadBuffer );
    else
    {
        if (EOF_LS00 != rc)
        {
            m_pError->isError(SAPDB_TRUE);
            m_pError->setReturnCode(rc);
            m_pError->setErrorText(m_ReadWriteErrText);
        }
    }
    return (rc > 0);
}
/*===========================================================================*
 *     MetaDataDef::writeLine
 *===========================================================================*/
SAPDB_Bool MetaDataDef::writeLine (StudioOAL_String& record )
{
    SAPDB_Int4 rc = ls30VFWriteLn(m_FileSession.vFile,
                                  REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,record.StrPtr()))),
                                  record.BasisSize(),
                                  m_ReadWriteErrText);
    if (errOK_els00 != rc)
    {
        m_pError->isError(SAPDB_TRUE);
        m_pError->setReturnCode(rc);
        m_pError->setErrorText(m_ReadWriteErrText);
    }
    record.Erase();
    return (rc > 0);
}

// Connection established

/*===========================================================================*
 *     MetaDataDef::connectionExtrCmd
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::connectionExtrCmd( )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::connectionExtrCmd");

    SAPDB_Int4 rc = errOK_els00;

    if (emExtractAsDDL_els00 == getExtrMode())
    {
        StudioOAL_String catalog("SQLMODE ");

        switch(getSqlMode())
        {
            case cpr_kind_db2:
            {
                catalog += "DB2";
                break;
            }
            case cpr_kind_ansi:
            {
                catalog += "ANSI";
                break;
            }
            case cpr_kind_oracle:
            {
                catalog += "ORACLE";
                break;
            }
            case cpr_kind_internal:
            default:
            {
                catalog += "INTERNAL";
            }
        }
        writeLine( catalog );
    }
    else if (emExtractAsXML_els00 == getExtrMode())
    {
        // SQLGetConnectAttr
        StudioOAL_String  Version;
        StudioOAL_String  Date;
        StudioOAL_String  Time;
        StudioOAL_String  Driver;
        StudioOAL_String  DataSource;
        StudioOAL_String  ServerNode;
        StudioOAL_String  DBName;
        StudioOAL_String  UserName;
        StudioOAL_String  Password;
        StudioOAL_String  SQLMode(" sapdbm:Sql_Mode=");
        StudioOAL_String  ConnectString;
        StudioOAL_String  OpenQuoteString  = " [ ";
        StudioOAL_String  CloseQuoteString = " ] ";

        tsp00_Versionc szVersion;
        tsp00_Datec    szDate;
        tsp00_Timec    szTime;

        tsp00_Date     pDate;
        tsp00_Time     pTime;
        sqldattime(pDate, pTime);
        szDate.p2c(pDate);
        szTime.p2c(pTime);

        //Version
        sp100_GetVersionString( COMP_NAME_REPL_MAN_SP100, s100buildnumber, szVersion );
        Version.ConvertFromASCII_Latin1     (szVersion.asCharp(),szVersion.asCharp()+szVersion.length () );
        Version = Version.SubStr(7,Version.Length());
        Version.Trim  ();
        //Date
        Date.ConvertFromASCII_Latin1        (szDate.asCharp(),szDate.asCharp()+szDate.length () );
        //Time
        Time.ConvertFromASCII_Latin1        (szTime.asCharp(),szTime.asCharp()+szTime.length () );

        SAPDB_Char   destBeg[1000] ;
        SAPDB_UInt4  destAt  = 1000;

        //Driver
        memset(destBeg,0,sizeof(destBeg));
        getConnection()->dbiOdbcConnection.GetDriver( REINTERPRET_CAST(unsigned char*,destBeg ),destAt);
        Driver.ConvertFromASCII_Latin1(destBeg,destBeg+strlen(destBeg));

        //ServerNode
        memset(destBeg,0,sizeof(destBeg));
        getConnection()->dbiOdbcConnection.GetServerNode( REINTERPRET_CAST(unsigned char*, destBeg ), destAt);
        ServerNode.ConvertFromASCII_Latin1( destBeg, destBeg+strlen(destBeg));

        //DatabaseName
        memset(destBeg,0,sizeof(destBeg));
        getConnection()->dbiOdbcConnection.GetServerDb ( REINTERPRET_CAST(unsigned char*,destBeg ),destAt);
        DBName.ConvertFromASCII_Latin1(destBeg,destBeg+strlen(destBeg));

        //UserName
        memset(destBeg,0,sizeof(destBeg));
        getConnection()->dbiOdbcConnection.GetUser( REINTERPRET_CAST(unsigned char*,destBeg ),destAt);
        UserName.ConvertFromASCII_Latin1(destBeg,destBeg+strlen(destBeg));

        //Password
        memset(destBeg,0,sizeof(destBeg));
        getConnection()->dbiOdbcConnection.GetPassword( REINTERPRET_CAST(unsigned char*,destBeg ),destAt);
        Password.ConvertFromASCII_Latin1(destBeg,destBeg+strlen(destBeg));

        // "DRIVER=SAPDB 7.3;SERVERNODE=P52837;SERVERDB=SUTDB73;UID=SUT;PWD=SUT;"

        ConnectString  = "DRIVER=";
        ConnectString += Driver;
        ConnectString += ";SERVERNODE=";
        ConnectString += ServerNode;
        ConnectString += ";SERVERDB=";
        ConnectString += DBName;
        ConnectString += ";UID=";
        ConnectString += UserName;
        ConnectString += ";PWD=";
        ConnectString += Password;
        ConnectString += ";";

        StudioOAL_String catalog;

        catalog = "<?xml version='1.0' encoding='ISO-8859-1'?>\n"
                  "<oim:Transfer "
                  " xmlns:oim='REPOSITORY:oim.dtd' "
                  " xmlns:umx='REPOSITORY:umx.dtd' "
                  " xmlns:uml='REPOSITORY:uml.dtd' "
                  " xmlns:dbm='REPOSITORY:dbm.dtd' "
                  " xmlns:dtm='REPOSITORY:dtm.dtd' "
                  " xmlns:sapdbm='REPOSITORY:sapdbm.dtd'>\n";

        catalog += "<oim:TransferHeader Exporter=\"SAP DB Loader\" ExporterVersion=\"";
        catalog += Version;
        catalog += "\"";
        catalog += " TransferDateTime=\"";
        catalog += Date;
        catalog += "   ";
        catalog += Time;
        catalog += "\"/>\n";

        catalog += "<uml:System oim:id=\"_0\"  name=\"SAP DB Data Warehousing Framework\">\n"
                   "<uml:SystemModels>\n"
                   "<uml:Model  oim:id=\"_1\" oim:label=\"SAP DB Database Schema\" name=\"SAP DB Database Schema\">\n"
                   "<uml:ModelPackages>\n";

        // Dbm:ConnectionSet
        catalog += "<dbm:ConnectionSet oim:id=\"_2\" oim:label=\"SAP DB WEB Agent ODBC Connection Pooling\""
                   " name=\"SAP DB WEB Agent ODBC Connection Pooling\""
                   ">\n";

        // Dbm:ConnectionSetConnections
        catalog += "<dbm:ConnectionSetConnections>\n";

        // sapdbm:Connection
        catalog += "<sapdbm:Connection oim:id=\"_4\" oim:supertype=\"Dbm:Connection\" oim:label=\"SAP DB ODBC Connection\" oim:name =\"";
        catalog += Driver;
        catalog += "\" dbm:UserName = \"";
        catalog += UserName;
        catalog += "\" dbm:Password = \"";
        catalog += Password;
        catalog += "\" dbm:ConnectString = \"";
        catalog += ConnectString;
        catalog += "\" dbm:ConnectionTimeOut = \" \""
                   "  dbm:Mode = \"sapdbwa_DBC_EXCL\""
                   "  dbm:IsReusable = \"0\""
                   "  dbm:OpenQuoteString = \"";
        catalog += OpenQuoteString;
        catalog += "\" dbm:CloseQuoteString = \"";
        catalog += CloseQuoteString;
        catalog += "\" dbm:DBName = \"";
        catalog += DBName;
        catalog += "\" dbm:DSN = \"\""
                   "  dbm:IsReadOnly = \"1\""
                   "  sapdbm:Sql_Producer=\"sp1pr_internal_cmd\" sapdbm:Sql_Component=\"sql_csp_comp_load\" ";

        switch(getSqlMode())
        {
            case cpr_kind_db2:
            {
                SQLMode += "\"db2\"/>";
                break;
            }
            case cpr_kind_ansi:
            {
                SQLMode += "\"ansi\"/>";
                break;
            }
            case cpr_kind_oracle:
            {
                SQLMode += "\"oracle\"/>";
                break;
            }
            case cpr_kind_internal:
            default:
            {
                SQLMode += "\"internal\"/>";
            }
        }
        catalog += SQLMode;

        catalog += "</dbm:ConnectionSetConnections>"
                   "</dbm:ConnectionSet>";

        // Dbm:DataSource
        catalog += "<dbm:DataSource oim:id=\"_3\"  oim:label=\"";
        catalog += DataSource;
        catalog += "\" name=\"";
        catalog += DataSource;
        catalog += "\">\n";

        // Dbm:DataSourceDBMS
        catalog += "<dbm:DataSourceDBMS oim:id=\"_5\" ";
        catalog += "  name=\"";
        catalog += DataSource;
        catalog += "\" version=\"";
        catalog += "";
        catalog += "\">\n";

        // Dbm:ColumnTypeSet
        catalog += "<dbm:ColumnTypeSet oim:id=\"8\"";
        catalog += "  name=\"";
        catalog += DataSource;
        catalog += "\" version=\"";
        catalog += "";
        catalog += "\">\n";

        // Dtm:TypeSetTypes
        catalog += "<dtm:TypeSetTypes>\n";

        writeLine ( catalog );
        catalog.Erase();

        columntypesetExtrCmd( );

        catalog += "</dtm:TypeSetTypes>\n";
        catalog += "</dbm:ColumnTypeSet>\n";
        catalog += "</dbm:DataSourceDBMS>\n";

        // Dbm:DataSourceConnections
        catalog += "<dbm:DataSourceConnections>\n";

        // sapdbm:Connection
        catalog += "<sapdbm:Connection oim:id=\"_6\" oim:supertype=\"Dbm:Connection\" oim:label=\"SAP DB ODBC Connection\" oim:name =\"";
        catalog += getOdbcDriver();
        catalog += "\" dbm:UserName = \"";
        catalog += UserName;
        catalog += "\" dbm:Password = \"";
        catalog += Password;
        catalog += "\" dbm:ConnectString = \"";
        catalog += ConnectString;
        catalog += "\" dbm:ConnectionTimeOut = \" \""
                   "  dbm:Mode = \"sapdbwa_DBC_EXCL\""
                   "  dbm:IsReusable = \"0\""
                   "  dbm:OpenQuoteString = \"";
        catalog += OpenQuoteString;
        catalog += "\" dbm:CloseQuoteString = \"";
        catalog += CloseQuoteString;
        catalog += "\" dbm:DBName = \"";
        catalog += DBName;
        catalog += "\" dbm:DSN = \"\""
                   "  dbm:IsReadOnly = \"1\""
                   "  sapdbm:Sql_Producer=\"sp1pr_internal_cmd\" sapdbm:Sql_Component=\"sql_csp_comp_load\" ";

        catalog += SQLMode;

        catalog += "</dbm:DataSourceConnections>\n";

        // Dbm:DataSourceDeployedCatalogs
        catalog += "<dbm:DataSourceDeployedCatalogs>\n";

        // Dbm:DeployedCatalog
        catalog += "<dbm:DeployedCatalog oim:id=\"_7\" ";
        catalog += " RepositoryUpdatedBy=\"";
        catalog += UserName;
        catalog += "\" RepositoryUpdated=\"";
        catalog += Date;
        catalog += "   ";
        catalog += Time;
        catalog += "\" URL=\"";
        catalog += DBName;
        catalog += "\" name=\"";
        catalog += DBName;
        catalog += "\">\n";

        // Dbm:CatalogSchemas
        catalog += "<dbm:CatalogSchemas>\n";

        writeLine ( catalog );
    }
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::columntypesExtrCmd                                      *
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::columntypesetExtrCmd( )
{
    RepServMessages *pMsgInstance = RepServMessages::Instance();
    SAPDB_Int4 rc = errOK_els00;

    // SYSODBCTYPES  :  0.TYPE_NAME, 1.DATA_TYPE, 2.PRECISION, 3.LITERAL_PREFIX, 4.LITERAL_SUFFIX, 5.CREATE_PARAMS, 6.NULLABLE, 7.CASE_SENSITIVE, 8.SEARCHABLE, 9.UNSIGNED_ATTRIBUTE, 10.MONEY, 11.AUTO_INCREMENT
    //                 12.LOCAL_TYPE_NAME, 13.MINIMUM_SCALE, 14.MAXIMUM_SCALE, 15.SQL_DATA_TYPE, 16.SQL_DATETIME_SUB, 17.NUM_PREC_RADIX, 18.INTERVAL_PRECISION, 19.REMARKS

    // SQLGetTypeInfo:  0.TYPE_NAME, 1.DATA_TYPE, 2.PRECISION, 3.LITERAL_PREFIX, 4.LITERAL_SUFFIX, 5.CREATE_PARAMS, 6.NULLABLE, 7.CASE_SENSITIVE, 8.SEARCHABLE, 9.UNSIGNED_ATTRIBUTE, 10.MONEY, 11.AUTO_INCREMENT
    //                  12.LOCAL_TYPE_NAME, 13.MINIMUM_SCALE, 14.MAXIMUM_SCALE

    if ( getExtrMode() == emExtractAsXML_els00 )
    {
        StudioOAL_String  record[15];

        if( !m_pColumnTypeDef->getDataSourceTypeInfo() )
        {
            StudioOAL_String statement = "SQLGetTypeInfo";
            StudioOAL_String errorText;

            errorText   = m_pColumnTypeDef->getErrorText();

            SAPDB_Char        ErrText[MAX_REPLY_LENGTH_LS00];
            const SAPDB_Char* ErrTextEnd = ErrText + MAX_REPLY_LENGTH_LS00;
            SAPDB_Char*       destAt;

            errorText.ConvertToASCII_Latin1(ErrText, ErrTextEnd, destAt);

            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , statement.StrPtr() );
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, errorText.StrPtr() );
            rc = errODBCErrors_els98;
        }
        else
        {
            /*-------------------------------------------------------------------------------*
             * Read/Write the catalog definition of the specified object from/to resources   *
             *-------------------------------------------------------------------------------*/
            while ( m_pColumnTypeDef->readResult (record) )
                    m_pColumnTypeDef->writeResult(record);
        }
    }
    return rc;
}
// Autorizations Definition

/*===========================================================================*
 *  MetaDataDef::schemaExtrCmd                                           *
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::schemaExtrCmd( StudioOAL_String user  )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::schemaExtrCmd");
    SAPDB_Int4 rc = errOK_els00;

    if ( getExtrMode() == emExtractAsXML_els00 )
    {
        StudioOAL_String  schema;

        /*-------------------------------------------------------------------------*
         * Close the previous Schema                                               *
         *-------------------------------------------------------------------------*/
        if ( m_nSchemaCount > 0 )
        {
            schema += "</uml:NamespaceOwnedElement>\n"
                      "</sapdbm:DeployedSchema>\n"
                      "</uml:NamespaceOwnedElement>\n";
            writeLine(schema);
        }
        // DOMAIN.USERS  : OWNER,GROUPNAME,USERNAME,USERMODE,CONNECTMODE,PERMLIMIT,TEMPLIMIT,MAXTIMEOUT,COSTWARNING,COSTLIMIT,CREATEDATE,CREATETIME,ALTERDATE,ALTERTIME,PWCREADATE,PWCREATIME,SERVERDB,SERVERNODE,USER_ID,COMMENT
        StudioOAL_String  select;
        StudioOAL_String  whereClause;
        StudioOAL_String  record[10];

        select  = "SELECT OWNER, GROUPNAME, USERNAME, USERMODE, MAXTIMEOUT, COSTWARNING, COSTLIMIT, CONNECTMODE, COMMENT "
                  "FROM DOMAIN.USERS ";
        /*-------------------------------------------------------------------------*
         * Prepare the WHERE clause for the SQL statements.                        *
         *-------------------------------------------------------------------------*/
        whereClause  = "WHERE USERNAME = '";
        whereClause  += user;
        whereClause  +="'";

        select       += whereClause;

        /*-------------------------------------------------------------------------------*
         * Read/Write the catalog definition of the specified object from/to resources   *
         *-------------------------------------------------------------------------------*/
        if (  m_pUserDef->executeSQL( select ) )
        {
            if ( m_pUserDef->readResult (record) )
            {
                m_pUserDef->writeResult(record,emExtractAsXML_els00);
                m_nSchemaCount++;
            }
        }
    }
    return rc;
}

/*===========================================================================*
 *  MetaDataDef::userExtrCmd                                                 *
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::userExtrCmd( tls00_PartSpec catpartSpec )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::userExtrCmd");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Int4 rc = errOK_els00;

    // DOMAIN.USERS: OWNER,GROUPNAME,USERNAME,USERMODE,CONNECTMODE,MAXTIMEOUT,COSTWARNING,COSTLIMIT,CREATEDATE,CREATETIME,ALTERDATE,ALTERTIME,PWCREADATE,PWCREATIME,SERVERDB,SERVERNODE,USER_ID,COMMENT
    StudioOAL_String  select;
    StudioOAL_String  whereClause;
    StudioOAL_String  orderClause;
    StudioOAL_String  record[10];

    select = "SELECT OWNER, GROUPNAME, USERNAME, USERMODE, MAXTIMEOUT, COSTWARNING, COSTLIMIT, CONNECTMODE, COMMENT "
             "FROM DOMAIN.USERS ";

    if ( getExtrMode() == emExtractAsDDL_els00 )
    {
        /*-------------------------------------------------------------------------*
         * Prepare the WHERE clause for the SQL statements.                        *
         *-------------------------------------------------------------------------*/

        // catalog extract all
        if  (ptAll_els00 == getPartSpec().psPartType_ls00)
        {
            whereClause = " WHERE USERMODE <> 'SYSDBA'  "
                          " AND   USERMODE <> 'COLDUSER'"
                          " AND   USERMODE <> 'ADMIN'   "
                          " AND   USERNAME <> 'DOMAIN'  "
                          " AND   USERNAME <> 'SYS'     "
                          " AND   USERNAME <> 'SYSINFO' ";

            orderClause  = " ORDER BY CREATETIME ";
        }
        else if (ptUser_els00 == getPartSpec().psPartType_ls00)
        {
            // catalog extract user
            whereClause  = "WHERE OWNER = '";
            whereClause  += getCurrentUser();
            whereClause  +="'";

            orderClause  = " ORDER BY GROUPNAME, USERNAME ASC ";
        }

        select += whereClause;
        select += orderClause;

        /*-------------------------------------------------------------------------------*
         * Read/Write the catalog definition of the specified object from/to resources   *
         *-------------------------------------------------------------------------------*/
        if (  m_pUserDef->executeSQL( select ) )
        {
            while ( m_pUserDef->readResult(record) )
            {
                setCurrentUser( record[0] );
                m_pUserDef->writeResult(record, emExtractAsDDL_els00);
            }
        }
    }   // end if ( getExtrMode() == emExtractAsDDL_els00 )
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::roleExtrCmd                                                 *
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::roleExtrCmd( tls00_PartSpec catpartSpec )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::roleExtrCmd");

    SAPDB_Int4 rc = errOK_els00;

    if ( getExtrMode() == emExtractAsDDL_els00 )
    {
        // <grantee> ::= PUBLIC | <user_name> | <usergroup_name> | <role_name>
        // ROLES: OWNER, ROLE, PASSWORD_REQUIRED, GRANTED, CREATEDATE, CREATEDATE
        StudioOAL_String  select("SELECT ROLE,PASSWORD_REQUIRED FROM DOMAIN.ROLES ");
        StudioOAL_String  whereClause;

        StudioOAL_String  record[2];

        if  (ptUser_els00 == catpartSpec.psPartType_ls00)
        {
            whereClause  = "WHERE OWNER = '";
            whereClause += getCurrentUser();
            whereClause += "'";
        }

        select += whereClause;

        /*-------------------------------------------------------------------------------*
         * Read/Write the role definition of the specified table from/to resources
         *-------------------------------------------------------------------------------*/
        if ( m_pRoleDef->executeSQL( select ) )
        {
            while ( m_pRoleDef->readResult (record) )
                    m_pRoleDef->writeResult(record);
        }
    }
    return rc;
}

// Data Definition

/*===========================================================================*
 *  MetaDataDef::tabletypeExtrCmdDirect                                  *
 *===========================================================================*/
SAPDB_Int4
MetaDataDef::tabletypeExtrCmdDirect( tls00_PartSpec catpartSpec )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::tabletypeExtrCmdDirect");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Int4 rc = errOK_els00;

    // CREATE CATALOG
    // CATALOG 7.2: LEVEL, CMD_NO, SEQ_NO, DT_FORMAT, OWNER, TABLENAME, ERROR_CODE, CMD
    // CATALOG 7.3: LEVEL, CMD_NO, SEQ_NO, DT_FORMAT, OWNER, TABLENAME, ERROR_CODE, SQL_CMD, TYPE, TABLETYPE, CMD

    StudioOAL_String  definition;
    StudioOAL_String  view;
    StudioOAL_String  synonym;

    StudioOAL_String  sql;
    StudioOAL_String  select;
    StudioOAL_String  orderby;
    StudioOAL_String  table  = "TABLE";
    StudioOAL_String  create = "CREATE";
    StudioOAL_String  grant  = "GRANT";
    StudioOAL_String  commit = "COMMIT WORK ";

    SQLRETURN         ReturnCode = 0;
    StudioOAL_String  NativeErrorAsString;

    StudioOAL_String  cmd_no;

    SAPDB_Bool bGrant = SAPDB_FALSE;

    _TCHAR szSelect[1024];
    szSelect[0] = 0;

    if (emExtractAsDDL_els00 == getExtrMode())
        orderby = " ";
    else if (emExtractAsXML_els00 == getExtrMode())
        orderby = " OWNER , ";
    sp77sprintf(szSelect, 1024, SEL_CAT_TABLE_ALL_73_LS00 , getConnection()->dbiPackageid_ls00.StrPtr(), orderby.StrPtr() );

    select.ConvertFromASCII_Latin1(szSelect, szSelect + _tcslen(szSelect));

    if ( !m_pTransformationDef->executeSQL( select ) )
    {
        ReturnCode          = m_pTransformationDef->getReturnCode();
        NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();

        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

        return ReturnCode;
    }

    StudioOAL_String record[5];
    StudioOAL_String parameters[3];

    /*-------------------------------------------------------------------------------*
     * Read/Write the catalog definition of the specified object from/to resources   *
     *-------------------------------------------------------------------------------*/
    while ( m_pTransformationDef->readResult(record) )
    {
        m_pTransformationDef->m_taskid = record[4];
        cmd_no        = record[0];
        parameters[0] = record[1];
        parameters[1] = record[2];

        if ( !m_pTransformationDef->updateBegin( parameters[0], parameters[1] ) )
        {
            ReturnCode          = m_pTransformationDef->getReturnCode();
            NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();

            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

            return ReturnCode;
        }

        SAPDB_Int4 columnlength = 0;

        //  <sapdbm:DeployedSchema>
        if ( record[1].Compare( getCurrentUser() ) != 0  || m_nSchemaCount == 0 )
             schemaExtrCmd ( parameters[0] );

        setCurrentUser( parameters[0] );

        // CREATE TABLE
        if ( table.Compare( record[3].SubStr(0,5) ) == 0)
        {
            parameters[2] = "TABLE";

            // <dbm:SchemaTables>
            // <dbm:SchemaIndexes>

            // <dbm:DeployedTable>
            // CREATE TABLE
            tableExtrCmdExecDirect  ( parameters[0], parameters[1] );
            // <dbm:TableIndices>
            // CREATE INDEX
            indexExtrCmdExecDirect  ( parameters[0], parameters[1] );
            // <dbm:TableTriggers>
            // CREATE TRIGGER
            triggerExtrCmdExecDirect( parameters[0], parameters[1] );

            if (emExtractAsXML_els00 == getExtrMode())
            {
                StudioOAL_String   deployedTable;
                deployedTable  = "</sapdbm:DeployedTable>";
                m_pTransformationDef->writeResult(deployedTable);
            }

            bGrant = SAPDB_FALSE;

            if ( !m_pTransformationDef->updateCat( parameters ) )
            {
                ReturnCode          = m_pTransformationDef->getReturnCode();
                NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();

                pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

                return ReturnCode;
            }
            if ( !m_pTransformationDef->updateEnd( parameters[0], parameters[1]  ) )
            {
                ReturnCode          = m_pTransformationDef->getReturnCode();
                NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();

                pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

                return ReturnCode;
            }

            continue;
        } // CREATE TABLE

        if (create.Compare( record[3].SubStr(0,6) ) == 0)
        {
            definition  = record[3].SubStr(7,record[3].Length());
            definition.Trim()  ;

            // <dbm:SchemaViews>
            // CREATE VIEW
            if(  definition.SubStr(0,4).Compare("VIEW") == 0   )
            {
                parameters[2] = "VIEW";

                viewExtrCmdExecDirect( parameters[0], parameters[1] );

                if ( !m_pTransformationDef->updateCat( parameters ) )
                {
                    ReturnCode          = m_pTransformationDef->getReturnCode();
                    NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();

                    pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

                    return ReturnCode;
                }
                if ( !m_pTransformationDef->updateEnd( parameters[0], parameters[1]  ) )
                {
                    ReturnCode          = m_pTransformationDef->getReturnCode();
                    NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();

                    pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

                    return ReturnCode;
                }

            }// CREATE VIEW

            // <dbm:SchemaTableSynonyms>
            // CREATE SYNONYM
            if ( definition.SubStr(0,7).Compare("SYNONYM")  == 0 ||
                 definition.SubStr(0,6).Compare("PUBLIC" )  == 0    )
            {
                parameters[2] = "SYNONYM";

                synonymExtrCmdExecDirect( parameters[0], parameters[1] );

                if ( !m_pTransformationDef->updateCat( parameters ) )
                {
                    ReturnCode          = m_pTransformationDef->getReturnCode();
                    NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();

                    pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

                    return ReturnCode;
                }
                if ( !m_pTransformationDef->updateEnd( parameters[0], parameters[1]  ) )
                {
                    ReturnCode          = m_pTransformationDef->getReturnCode();
                    NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();

                    pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

                    return ReturnCode;
                }

            }// CREATE SYNONYM

            bGrant = SAPDB_FALSE;

            continue;
        }
        // GRANT
        // DOMAIN.SHOW_PRIV_GRANTED
        if (grant.Compare( record[3].SubStr(0,5) ) == 0 )
        {
            if ( getExtrMode() == emExtractAsDDL_els00 )
            {
                sql    = SEPARATOR;
                sql   += record[3];
                m_pTransformationDef->writeResult(sql);
            }
            bGrant = SAPDB_TRUE;
            continue;
        }
        if ( bGrant == SAPDB_TRUE )
        {
            if ( getExtrMode() == emExtractAsDDL_els00 )
            {
                sql        = record[3];
                m_pTransformationDef->writeResult(sql);
            }
        }
     }//while ( m_pTransformationDef->readResult (record) )

     if ( !m_pTransformationDef->executeSQL( commit ) )
     {
         ReturnCode          = m_pTransformationDef->getReturnCode();
         NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();

         pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());
         return ReturnCode;
    }
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::tableExtrCmdExecDirect
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::tableExtrCmdExecDirect(StudioOAL_String& owner, StudioOAL_String& tablename )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::tableExtrCmdExecDirect");

    SAPDB_Int4 rc = errOK_els00;

    // TABLES   :OWNER,TABLENAME,PRIVILEGES,TYPE,CREATEDATE,CREATETIME,UPDSTATDATE,
    //           UPDSTATTIME,ALTERDATE,ALTERTIME,UNLOADED,SAMPLE_PERCENT,SAMPLE_ROWS,COMMENT,TABLEID

   /*-------------------------------------------------------------------------*
    * Reset the table definition to its initial values.                       *
    *-------------------------------------------------------------------------*/
    rc = m_pTableDef->Init(owner, tablename);

    /*-------------------------------------------------------------------------*
     * Read/Write the table definition of the specified table from/to resources*
     *-------------------------------------------------------------------------*/

    if (errOK_els00 == rc)
    {
        rc = m_pTableDef->readTableDefinitionDirect(owner, tablename);
        if (errOK_els00 == rc)
        {
            ++m_nTableCount;
            m_pTableDef->writeTableDefinition();
        }
    }
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::tableExtrCmdExec
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::tableExtrCmdExec(StudioOAL_String& owner, StudioOAL_String& tablename)
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::tableExtrCmdExec");

    SAPDB_Int4 rc = errOK_els00;

    // CREATE TABLE
    // TABLES: OWNER, TABLENAME, PRIVILEGES, TYPE, CREATEDATE, CREATETIME, UPDSTATDATE,
    //         UPDSTATTIME, ALTERDATE, ALTERTIME, UNLOADED, SAMPLE_PERCENT, SAMPLE_ROWS, COMMENT, TABLEID

   /*-------------------------------------------------------------------------*
    * Reset the table definition to its initial values.                       *
    *-------------------------------------------------------------------------*/
    m_pTableDef->Init(owner, tablename);

    /*-------------------------------------------------------------------------*
     * Read/Write the table definition of the specified table from/to resources*
     *-------------------------------------------------------------------------*/
    if ( m_pTableDef->readTableDefinition( owner, tablename ) )
    {
        ++m_nTableCount;
        m_pTableDef->writeTableDefinition();
    }
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::viewExtrCmdExecDirect
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::viewExtrCmdExecDirect( StudioOAL_String& owner, StudioOAL_String& viewname )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::viewExtrCmdExecDirect");

    SAPDB_Int4 rc = errOK_els00;

    StudioOAL_String  record[3];

    /*-------------------------------------------------------------------------*
     * Prepare the WHERE clause for the SQL statements.                        *
     *-------------------------------------------------------------------------*/
    StudioOAL_String  whereClause("WHERE owner = '");
    whereClause += owner ;
    whereClause += "' AND viewname = '";
    whereClause += viewname ;
    whereClause += "' ";

    StudioOAL_String  select(" SELECT viewname, owner, definition FROM DOMAIN.viewdefs ");
    select += whereClause;

    if ( !m_pViewDef->executeSQL( select )  )
    {
        StudioOAL_String NativeErrorAsString = m_pViewDef->getNativeErrorAsString();

        RepServMessages::Instance()->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98,
                                                                               NativeErrorAsString.StrPtr());
        rc = m_pViewDef->getReturnCode();
    }
    else
    {
        if ( m_pViewDef->readResult ( record ) )
        {
            m_nViewCount ++ ;
            m_pViewDef->writeResult( record );
        }
    }

    return rc;
}
/*===========================================================================*
 *  MetaDataDef::viewExtrCmdExec
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::viewExtrCmdExec( StudioOAL_String owner, StudioOAL_String viewname )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::viewExtrCmdExec");

    SAPDB_Int4 rc = errOK_els00;

    /*-------------------------------------------------------------------------*
     * Read/Write the view definition of the specified table from/to resources
     *-------------------------------------------------------------------------*/
    if ( m_pViewDef->readViewDefinition( owner, viewname ) )
    {
        m_nViewCount ++ ;
        m_pViewDef->writeViewDefinition();
    }
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::synonymExtrCmdExecDirect
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::synonymExtrCmdExecDirect( StudioOAL_String owner, StudioOAL_String synonymname )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::synonymExtrCmdExecDirect");

    SAPDB_Int4 rc = errOK_els00;

    // CREATE SYNONYM
    // SYNONYMS: OWNER, SYNONYMNAME, PUBLIC, TABLEOWNER, TABLENAME, COMMENT

    StudioOAL_String  select;
    StudioOAL_String  whereClause;

    /*-------------------------------------------------------------------------*
     * Prepare the WHERE clause for the SQL statements.                        *
     *-------------------------------------------------------------------------*/
    whereClause += "WHERE synonymname = '";
    whereClause += synonymname;
    whereClause += "' AND owner = '";
    whereClause += owner;
    whereClause += "' ";

    StudioOAL_String  record[6];

    select  = " SELECT OWNER, SYNONYMNAME, PUBLIC, TABLEOWNER, TABLENAME, COMMENT FROM DOMAIN.SYNONYMS ";
    select += whereClause;

    if ( !m_pSynonymDef->executeSQL( select )  )
    {
        SAPDB_Long       NativeError         = m_pSynonymDef->getNativeError();
        StudioOAL_String NativeErrorAsString = m_pSynonymDef->getNativeErrorAsString();

        RepServMessages::Instance()->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());
        rc = STATIC_CAST(SAPDB_Int4, NativeError);
    }
    else
    {
        while ( m_pSynonymDef->readResult( record ) )
        {
            m_nSynonymCount++;
            m_pSynonymDef->writeResult( record );
        }
    }
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::synonymExtrCmdExec
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::synonymExtrCmdExec( StudioOAL_String owner, StudioOAL_String synonymname )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::synonymExtrCmdExec");

    SAPDB_Int4 rc = errOK_els00;

    /*-------------------------------------------------------------------------*
     * Read/Write the synonym definition of the specified table from/to resources
     *-------------------------------------------------------------------------*/
    if ( m_pSynonymDef->readSynonymDefinition  ( owner, synonymname ) )
    {
        m_nSynonymCount++;
        m_pSynonymDef->writeSynonymDefinition();
    }
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::indexExtrCmdExecDirect
 *===========================================================================*/
SAPDB_Int4
MetaDataDef::indexExtrCmdExecDirect( StudioOAL_String& owner, StudioOAL_String& tablename )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::indexExtrCmdExecDirect");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Int4 rc = errOK_els00;

    /*-------------------------------------------------------------------------*
     * Before doing anything else check if more than one table with the same   *
     * name and different owners is found in the DB in case the owner name     *
     * is not specified.                                                       *
     *-------------------------------------------------------------------------*/
    if (SAPDB_TRUE == owner.Empty())
    {
        StudioOAL_String  SelectOwnerCountCmd("SELECT COUNT(DISTINCT OWNER) FROM "
                                              "DOMAIN.COLUMNS WHERE TABLENAME = '");
        SelectOwnerCountCmd += tablename;
        SelectOwnerCountCmd += "'";

        if (SAPDB_TRUE == m_pIndexDef->executeSQL( SelectOwnerCountCmd ))
        {
            StudioOAL_String record[1];

            m_pIndexDef->readResult(record);
            SAPDB_Int4 lOwnerCount = AtoI( record[0] );
            if (lOwnerCount > 1)
            {
                pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errDEAmbiguousTableName_els98);
                rc = errDEAmbiguousTableName_els98;
            }
        }
        else
        {
            rc = errODBCErrors_els98;
        }
    }

    if (errOK_els00 == rc)
    {
        // CREATE INDEX
        // INDEXES: OWNER, TABLENAME, INDEXNAME, TYPE, CREATEDATE, CREATETIME, INDEX_USED, DISABLED, COMMENT

        /*-------------------------------------------------------------------------*
         * Prepare the WHERE clause for the SQL statements.
         *-------------------------------------------------------------------------*/
        StudioOAL_String  whereClause("WHERE tablename = '");
        whereClause += tablename;
        whereClause += "' AND DISABLED = 'NO'";

        if (SAPDB_FALSE == owner.Empty())
        {
            whereClause += " AND owner = '";
            whereClause += owner;
            whereClause += "'";
        }

        //<create_index_statement> ::=
        // CREATE [UNIQUE] INDEX <index_name> ON <table_name> (<column_name> [ASC | DESC],...)
        StudioOAL_String  select("SELECT TYPE, INDEXNAME, COMMENT FROM DOMAIN.INDEXES ");
        select += whereClause;

        if ( !m_pIndexDef->executeSQL( select ) )
             rc = STATIC_CAST(SAPDB_Int4, m_pIndexDef->getNativeError());

        if (errOK_els00 == rc)
        {
            /*-------------------------------------------------------------------------*
             * Read/Write the index definition of the specified table from/to resources
             *-------------------------------------------------------------------------*/
            if (emExtractAsDDL_els00 == getExtrMode())
            {
                while ( m_pIndexDef->readIndexDefinitionDirect( owner, tablename ) )
                {
                    m_pIndexDef->writeIndexDefinition();
                }
            }
            else if (emExtractAsXML_els00 == getExtrMode())
            {
                StudioOAL_String tableIndices;
                SAPDB_Bool       bHasIndex = SAPDB_FALSE;

                while ( m_pIndexDef->readIndexDefinitionDirect(owner, tablename) )
                {
                    if (SAPDB_FALSE == bHasIndex)
                    {
                        tableIndices = "<dbm:TableIndices>\n";
                        m_pIndexDef->writeLine( tableIndices );
                        bHasIndex = SAPDB_TRUE;
                    }
                    m_pIndexDef->writeIndexDefinition();
                }

                if (SAPDB_TRUE == bHasIndex)
                {
                    tableIndices = "</dbm:TableIndices>\n";
                    m_pIndexDef->writeLine( tableIndices );
                }
            }
        }
    }   // end if (errOK_els00 == rc)

    return rc;
}
/*===========================================================================*
 *  MetaDataDef::indexExtrCmdExec
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::indexExtrCmdExec ( StudioOAL_String owner, StudioOAL_String tablename )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::indexExtrCmdExec");

    SAPDB_Int4 rc = errOK_els00;

    /*-------------------------------------------------------------------------*
     * Read/Write the index definition of the specified table from/to resources
     *-------------------------------------------------------------------------*/
    m_pIndexDef->setIndexParameters( owner, tablename ) ;

    if (emExtractAsDDL_els00 == getExtrMode())
    {
         while ( m_pIndexDef->readIndexDefinition  ( owner, tablename ) )
                 m_pIndexDef->writeIndexDefinition ();
    }
    else if (emExtractAsXML_els00 == getExtrMode())
    {
        StudioOAL_String tableIndices;
        SAPDB_Bool       bHasIndex = SAPDB_FALSE;

        while ( m_pIndexDef->readIndexDefinition(owner, tablename) )
        {
            if (SAPDB_FALSE == bHasIndex)
            {
                tableIndices = "<dbm:TableIndices>\n";
                m_pIndexDef->writeLine( tableIndices );
                bHasIndex = SAPDB_TRUE;
            }
            m_pIndexDef->writeIndexDefinition ();
        }

        if (SAPDB_TRUE == bHasIndex)
        {
            tableIndices   = "</dbm:TableIndices>\n";
            m_pIndexDef->writeLine ( tableIndices );
        }
    }
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::sequenceExtrCmdDirect                                   *
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::sequenceExtrCmdDirect( tls00_PartSpec catpartSpec )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::sequenceExtrCmdDirect");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Int4 rc = errOK_els00;

    StudioOAL_String  NativeErrorAsString;

    StudioOAL_String  select;
    StudioOAL_String  whereClause;
    StudioOAL_String  record[9];

    _TCHAR szSelect[1024];
    szSelect[0] = 0;

    if ( getExtrMode() == emExtractAsDDL_els00 )
    {
        /*-------------------------------------------------------------------------*
         * Prepare the WHERE clause for the SQL statements.                        *
         *-------------------------------------------------------------------------*/
        if  (ptAll_els00 == catpartSpec.psPartType_ls00)
        {
            sp77sprintf(szSelect, 1024, SEL_CAT_USER_ALL_73_LS00 );
        }
        else if (ptUser_els00 == catpartSpec.psPartType_ls00)
        {
            sp77sprintf(szSelect, 1024, SEL_CAT_USER_USER_73_LS00, getCurrentUser().StrPtr() );
        }

        select.ConvertFromASCII_Latin1(szSelect,szSelect + _tcslen(szSelect));

        if ( !m_pTransformationDef->executeSQL( select ) )
        {
            NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

            rc = m_pTransformationDef->getReturnCode();
        }
        else
        {
            /*-------------------------------------------------------------------------------*
             * Read/Write the catalog definition of the specified object from/to resources   *
             *-------------------------------------------------------------------------------*/
            while ( m_pTransformationDef->readResult (record) )
            {
                setCurrentUser( record[0] );

                // CREATE SEQUENCE
                // SEQUENCES: OWNER, SEQUENCE_NAME, INCREMENT_BY, LAST_NUMBER, MAX_VALUE, MIN_VALUE,
                //            CYCLE_FLAG, CACHE_SIZE, ORDER_FLAG, CREATEDATE, CREATETIME, COMMENT

                select = " SELECT OWNER,SEQUENCE_NAME,INCREMENT_BY,LAST_NUMBER,MAX_VALUE,MIN_VALUE,CYCLE_FLAG,CACHE_SIZE,ORDER_FLAG "
                         " FROM DOMAIN.SEQUENCES ";

                /*-------------------------------------------------------------------------*
                 * Prepare the WHERE clause for the SQL statements.                        *
                 *-------------------------------------------------------------------------*/
                if (ptUser_els00 == catpartSpec.psPartType_ls00)
                {
                    whereClause  = "WHERE  OWNER = '";
                    whereClause += getCurrentUser();
                    whereClause += "'";
                }
                select  += whereClause;

                if ( ! m_pSequenceDef->executeSQL( select )  )
                {
                    NativeErrorAsString = m_pSequenceDef->getNativeErrorAsString();
                    pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

                    return m_pSequenceDef->getReturnCode();
                }

                /*----------------------------------------------------------------------------*
                 * Read/Write the sequence definition of the specified table from/to resources*
                 *----------------------------------------------------------------------------*/
                while ( m_pSequenceDef->readResult(record) )
                        m_pSequenceDef->writeResult(record);
            }   // end while ( m_pTransformationDef->readResult (record) )
        }
    }// if ( getExtrMode() == emExtractAsDDL_els00 )
    return rc;
}
/*===========================================================================*
 *  MetaDataDef::dbprocedureExtrCmdDirect
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::dbprocedureExtrCmdDirect( tls00_PartSpec catpartSpec )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::dbprocedureExtrCmdDirect");

    SAPDB_Int4       rc           = errOK_els00;
    RepServMessages *pMsgInstance = RepServMessages::Instance();


    SQLRETURN         ReturnCode  = 0;
    StudioOAL_String  NativeErrorAsString;
    StudioOAL_String  select;
    StudioOAL_String  record[4];

    _TCHAR szSelect[1024];
    szSelect[0] = 0;

    if ( getExtrMode() == emExtractAsDDL_els00 )
    {
        if (ptAll_els00 == catpartSpec.psPartType_ls00)
            sp77sprintf(szSelect, 1024, SEL_CAT_USER_ALL_73_LS00);
        else if (ptUser_els00 == catpartSpec.psPartType_ls00)
            sp77sprintf(szSelect, 1024, SEL_CAT_USER_USER_73_LS00, getCurrentUser().StrPtr() );

        if ( !m_pTransformationDef->executeSQL(szSelect) )
        {
            NativeErrorAsString = m_pTransformationDef->getNativeErrorAsString();

            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());
            rc = m_pTransformationDef->getReturnCode();
        }
        else
        {
            // CREATE DBPROC
            // DBPROCEDURES: OWNER, DBPROCNAME, PACKAGE, PARAMETER, CREATEDATE, CREATETIME,
            //               EXCECUTION_KIND, SQL_SUPPORT, REMOTE_LOCATION, DEFINITION, COMMENT
            StudioOAL_String  whereClause;

            /*-------------------------------------------------------------------------------*
             * Read/Write the catalog definition of the specified object from/to resources   *
             *-------------------------------------------------------------------------------*/
            while ( (errOK_els00 == rc) && (m_pTransformationDef->readResult(record)) )
            {
                select       = "SELECT DEFINITION, DBPROCNAME, OWNER, COMMENT FROM DOMAIN.DBPROCEDURES ";
                whereClause  = "WHERE definition IS NOT NULL AND OWNER = '";
                whereClause  += record[0];
                whereClause  += "' ";
                whereClause  += "AND DBPROCNAME <> 'TRANSFORMATIONPACKAGE'";

                select += whereClause;

                setCurrentUser( record[0] );

                if ( !m_pDBProcedureDef->executeSQL( select ) )
                {
                    NativeErrorAsString = m_pDBProcedureDef->getNativeErrorAsString();

                    pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());
                    rc = m_pDBProcedureDef->getReturnCode();
                }
                else
                {
                    /*-------------------------------------------------------------------------------*
                     * Read/Write the dbprocedure definition of the specified table from/to resources*
                     *-------------------------------------------------------------------------------*/
                    while ( m_pDBProcedureDef->readResult(record) )
                            m_pDBProcedureDef->writeResult(record) ;
                }
            }   // end while ( m_pTransformationDef->readResult (record) )
        }   // end else of if ( !m_pTransformationDef->executeSQL( select ) )

     }//if ( getExtrMode() == emExtractAsDDL_els00 )

     return rc;
}
/*===========================================================================*
 *  MetaDataDef::triggerExtrCmdExecDirect
 *===========================================================================*/
SAPDB_Int4
MetaDataDef::triggerExtrCmdExecDirect( StudioOAL_String& owner, StudioOAL_String& tablename )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::triggerExtrCmdExecDirect");

    SAPDB_Int4       rc           = errOK_els00;
    RepServMessages *pMsgInstance = RepServMessages::Instance();

    // CREATE TRIGGER
    // TRIGGERS   : OWNER,TABLENAME,TRIGGERNAME,INSERT,UPDATE,DELETE,
    //              CREATEDATE,CREATETIME,DEFINITION,COMMENT

    StudioOAL_String  select;
    StudioOAL_String  whereClause;
    StudioOAL_String  record[5];

    /*-------------------------------------------------------------------------*
     * Prepare the WHERE clause for the SQL statement.
     *-------------------------------------------------------------------------*/
    whereClause  = " WHERE definition IS NOT NULL "
                   " AND owner = '";
    whereClause +=   owner;
    whereClause += "'";
    whereClause += " AND tablename = '";
    whereClause += tablename;
    whereClause += "'";

    select  = "SELECT DEFINITION, TRIGGERNAME, TABLENAME, COMMENT, OWNER FROM DOMAIN.TRIGGERS ";
    select += whereClause;

    SQLRETURN        ReturnCode = 0;
    StudioOAL_String NativeErrorAsString;

    if ( !m_pTriggerDef->executeSQL( select )  )
    {
        NativeErrorAsString = m_pTriggerDef->getNativeErrorAsString();

        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());
        rc = m_pTriggerDef->getReturnCode();
    }
    else
    {
        /*-------------------------------------------------------------------------------*
         * Read/Write the trigger definition of the specified table from/to resources    *
         *-------------------------------------------------------------------------------*/
        while ( m_pTriggerDef->readResult(record) )
                m_pTriggerDef->writeResult(record);
    }

    return rc;
}
/*===========================================================================*
 *  MetaDataDef::triggerExtrCmdExecDirect
 *===========================================================================*/
SAPDB_Int4 MetaDataDef::triggerExtrCmdExec( StudioOAL_String owner, StudioOAL_String tablename )
{
    ROUTINE_DBG_MEO00 ("MetaDataDef::triggerExtrCmdExec");

    SAPDB_Int4 rc = errOK_els00;

    /*-------------------------------------------------------------------------*
     * Read/Write the synonym definition of the specified table from/to resources
     *-------------------------------------------------------------------------*/
    if ( m_pTriggerDef->readTriggerDefinition( owner, tablename ) )
         m_pTriggerDef->writeTriggerDefinition();

     return rc;
}
/*===========================================================================*
 *   ResultSet::ResultSet
 *===========================================================================*/
ResultSet::ResultSet( sapdbwa_DBC & odbcConnection )
          :StudioOAL_WResult ( odbcConnection.HDBC(),odbcConnection.HENV() )
{
}
/*===========================================================================*
 *    ResultSet::~ResultSet
 *===========================================================================*/
ResultSet::~ResultSet ()
{
}
/*===========================================================================*
 *    MetaDataItem::MetaDataItem()
 *===========================================================================*/
MetaDataItem::MetaDataItem( sapdbwa_DBC & odbcConnection, MetaDataDef  * pMetaData )
             :ResultSet( odbcConnection ),m_pMetaDataDef( pMetaData )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("MetaDataItem::MetaDataItem()");
}
/*===========================================================================*
 *    MetaDataItem::MetaDataItem()
 *===========================================================================*/
MetaDataItem::MetaDataItem( sapdbwa_DBC & odbcConnection )
             :ResultSet( odbcConnection )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("MetaDataItem::MetaDataItem()");
}
/*===========================================================================*
 *    MetaDataItem::~MetaDataItem()
 *===========================================================================*/
MetaDataItem::~MetaDataItem()
{
    ROUTINE_DBG_MEO00 ("MetaDataItem::~MetaDataItem()");
}
/*===========================================================================*
 *     MetaDataItem::executeSQL
 *===========================================================================*/
SAPDB_Bool MetaDataItem::executeSQL (StudioOAL_String& statement)
{
    ROUTINE_DBG_MEO00 ("MetaDataItem::executeSQL()");
    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Bool isOk = SAPDB_TRUE;

    if ( !openResult(statement) )
    {
        StudioOAL_String errorText;
        errorText = getErrorText();
        TRACE_PRNF_MLS99(("failed ", "%s"        , statement.StrPtr() ));
        TRACE_PRNF_MLS99(("getErrorText() ", "%s", errorText.StrPtr() ));

        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , statement.StrPtr() );
        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, errorText.StrPtr() );

        isOk = SAPDB_FALSE;
    }
    return  isOk ;
}
/*===========================================================================*
 *     MetaDataItem::executeSQL (overloaded)
 *===========================================================================*/
SAPDB_Bool MetaDataItem::executeSQL (const char* statement)
{
    ROUTINE_DBG_MEO00 ("MetaDataItem::executeSQL() II");
    StudioOAL_String stmt(statement);

    return executeSQL(stmt);
}

/*===========================================================================*
 *     MetaDataItem::existsTable
 *===========================================================================*/
SAPDB_Bool MetaDataItem::existsTable (StudioOAL_String tablename )
{
    ROUTINE_DBG_MEO00 ("MetaDataItem::existsTable");
    SAPDB_Bool isOk = SAPDB_TRUE;

    StudioOAL_String exists = " EXISTS TABLE ";

    exists += tablename;

    if ( !openResult (exists) )
    {
        StudioOAL_String nativeError;

        nativeError = getNativeErrorAsString();

        if ( nativeError.Compare("-4004") == 0 )
             isOk = SAPDB_FALSE;
    }
    return  isOk;
}
/*===========================================================================*
 *     MetaDataItem::existsDBProc
 *===========================================================================*/
SAPDB_Bool MetaDataItem::existsDBProc (StudioOAL_String dbprocname )
{
  ROUTINE_DBG_MEO00 ("MetaDataItem::existsDBProc");

  RepServMessages *pMsgInstance = RepServMessages::Instance();

  SAPDB_Bool isOk = SAPDB_TRUE;

  StudioOAL_String  statement;
  StudioOAL_String  record[1];

  SAPDB_Int4 exists = 0;

  statement  = " SELECT COUNT(*) FROM DOMAIN.DBPROCEDURES WHERE DBPROCNAME = ";
  statement += "'";
  statement += dbprocname;
  statement += "'";

  if ( executeSQL( statement ) )
  {
       readResult( record ) ;
       exists = AtoI( record[0] );
  }

  exists > 0 ? isOk = SAPDB_TRUE : isOk = SAPDB_FALSE ;

  return isOk;

}
/*===========================================================================*
 *     MetaDataItem::readResult                                        *
 *===========================================================================*/
SAPDB_Bool MetaDataItem::readResult (StudioOAL_String *record)
{
   ROUTINE_DBG_MEO00 ("MetaDataItem::readResult()");

   RepServMessages *pMsgInstance = RepServMessages::Instance();

   SAPDB_Int2       i;
   StudioOAL_String  s;

  /*-------------------------------------------------------------------------*
   * Fetch the next record.                                                  *
   *-------------------------------------------------------------------------*/
  if (!fetch())
  {
    closeResult();
    return SAPDB_FALSE;
  }

  /*-------------------------------------------------------------------------*
   * If there are no more records, reading the result is finished.           *
   *-------------------------------------------------------------------------*/
  if ( noRows())
  {
    closeResult();
    return SAPDB_FALSE;
  }
  /*-------------------------------------------------------------------------*
   * Read all columns of the fetched record.                                 *
   *-------------------------------------------------------------------------*/
  for (i = 0; i < getColCount(); i++)
  {
    getColumnDataAsString (i + 1, s);
    record[i] = s;
  }
  return SAPDB_TRUE;
}
/*===========================================================================*
 *     MetaDataItem::writeLine
 *===========================================================================*/
SAPDB_Bool MetaDataItem::writeLine (StudioOAL_String& record )
{
    return getMetaData()->writeLine(record);
}
/*===========================================================================*
 *     MetaDataItem::
 *===========================================================================*/
StudioOAL_String MetaDataItem::string2XML( StudioOAL_String string )
{

   StudioOAL_String  patterns((SAPDB_UTF8*)"&\"'<>");
   StudioOAL_String  constraintexpression;

   constraintexpression += string;

   SAPDB_UInt  start = 0, end ;

   while ( (end = constraintexpression.FindFirstOf (patterns, start) ) != StudioOAL_String::NPos )
   {
       switch ( constraintexpression[end] )
       {
           case ( '&' ):
               {
               constraintexpression.Replace(end,1,"&amp;");
               end += 5;
               break;
               }
           case ( '\"' ):
               {
               constraintexpression.Replace(end,1,"&quot;");
               end += 6;
               break;
               }
           case ( '\'' ):
               {
               constraintexpression.Replace(end,1,"&apos;");
               end += 6;
               break;
               }
           case ( '<' ):
               {
               constraintexpression.Replace(end,1,"&lt;");
               end += 4;
               break;
               }
           case ( '>' ):
               {
               constraintexpression.Replace(end,1,"&gt;");
               end += 4;
               break;
               }

           default:
               break;
       }

       start = end + 1;

   }

   return constraintexpression;
}
/*===========================================================================*
 *     MetaDataItem::string2SQL
 *===========================================================================*/
StudioOAL_String& MetaDataItem::string2SQL(StudioOAL_String& string)
{
    StudioOAL_String  patterns((SAPDB_UTF8*)"'");

    SAPDB_UInt  start = 0;
    SAPDB_UInt  end   = 0;

    while ( StudioOAL_String::NPos != (end = string.FindFirstOf(patterns, start) ) )
    {
        if ('\'' == string[end])
        {
            string.Replace(end, 1, "\'\'");
            end += 1;
        }
        start = end + 1;
    }
    return string;
}
/*===========================================================================*
 *    TransformationDef::TransformationDef
 *===========================================================================*/
TransformationDef::TransformationDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
                  :MetaDataItem ( odbcConnection , pMetaData )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::TransformationDef()");

    m_pCommand  = new tls00_Command ;
    memset (m_pCommand, DEF_BYTE_LS00, sizeof  (tls00_Command));
    m_pCommand->cmdRpyDat_ls00    = new char[MAX_REPLY_LENGTH_LS00];
    memset (m_pCommand->cmdRpyDat_ls00, DEF_BYTE_LS00, MAX_REPLY_LENGTH_LS00);
    m_pCommand->cmdInternal_ls00  = SAPDB_TRUE;
    m_pCommand->cmdLogging_ls00   = SAPDB_TRUE;

    m_nObjectCount    = 0;
    m_nTableCount     = 0;
    m_nSynonymCount   = 0;
    m_nViewCount      = 0;

    m_headerpos.lnu2GB_Blocks_ls00  = 0;
    m_headerpos.lnuRemainder_ls00   = 0;
    m_datapos.lnu2GB_Blocks_ls00    = 0;
    m_datapos.lnuRemainder_ls00     = 0;
    m_trailerpos.lnu2GB_Blocks_ls00 = 0;
    m_trailerpos.lnuRemainder_ls00  = 0;
    m_exclude         = SAPDB_FALSE;
    m_extractcount    = 0;
    m_loadcount       = 0;

#ifndef ODBC_PREPARED
    m_pUpdate          = new ResultSet ( odbcConnection );
#endif
#ifdef ODBC_PREPARED
    m_pUpdateCat       = new ResultSet ( odbcConnection );
    m_pUpdatePages     = new ResultSet ( odbcConnection );
    m_pUpdateRecords   = new ResultSet ( odbcConnection );
    m_pUpdateRestart   = new ResultSet ( odbcConnection );
    m_pUpdateBegin     = new ResultSet ( odbcConnection );
    m_pUpdateHeader    = new ResultSet ( odbcConnection );
    m_pUpdateData      = new ResultSet ( odbcConnection );
    m_pUpdateEnd       = new ResultSet ( odbcConnection );
#endif

}
/*===========================================================================*
 *    TransformationDef::TransformationDef
 *===========================================================================*/
TransformationDef::TransformationDef( sapdbwa_DBC & odbcConnection   )
                  :MetaDataItem ( odbcConnection )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::TransformationDef()");

    m_pCommand  = new tls00_Command ;
    m_pCommand->cmdRpyDat_ls00    = new char[MAX_REPLY_LENGTH_LS00];
    m_pCommand->cmdInternal_ls00  = SAPDB_TRUE;
    m_pCommand->cmdLogging_ls00   = SAPDB_TRUE;
    memset (m_pCommand, DEF_BYTE_LS00, sizeof  (tls00_Command));
    memset (m_pCommand->cmdRpyDat_ls00, DEF_BYTE_LS00, MAX_REPLY_LENGTH_LS00);

    m_nObjectCount    = 0;
    m_nTableCount     = 0;
    m_nSynonymCount   = 0;
    m_nViewCount      = 0;

    m_headerpos.lnu2GB_Blocks_ls00  = 0;
    m_headerpos.lnuRemainder_ls00   = 0;
    m_datapos.lnu2GB_Blocks_ls00    = 0;
    m_datapos.lnuRemainder_ls00     = 0;
    m_trailerpos.lnu2GB_Blocks_ls00 = 0;
    m_trailerpos.lnuRemainder_ls00  = 0;
    m_exclude         = SAPDB_FALSE;
    m_extractcount    = 0;
    m_loadcount       = 0;
}
/*===========================================================================*
 *    TransformationDef::TransformationDef
 *===========================================================================*/
TransformationDef::~TransformationDef()
{
    ROUTINE_DBG_MEO00 ("TransformationDef::~TransformationDef()");

    if (NULL != m_pCommand->cmdRpyDat_ls00)
    {
        delete [] m_pCommand->cmdRpyDat_ls00;
        m_pCommand->cmdRpyDat_ls00 = NULL;
    }

    if (NULL != m_pCommand)
    {
        delete [] m_pCommand;
        m_pCommand = NULL;
    }

#ifndef ODBC_PREPARED
    if ( NULL != m_pUpdate  )
    {
         delete  m_pUpdate;
         m_pUpdate  = NULL;
    }

#endif //#ifdef ODBC_PREPARED

#ifdef ODBC_PREPARED
    if ( NULL != m_pupdateCat )
    {
        delete  m_pupdateCat;
        m_pupdateCat = NULL;
    }
    if ( NULL != m_pUpdatePages    )
    {
        delete m_pUpdatePages;
        m_pUpdatePages = NULL;
    }
    if ( NULL != m_pUpdateRecords  )
    {
        delete m_pUpdateRecords;
        m_pUpdateRecords = NULL;
    }
    if ( NULL != m_pUpdateRestart  )
    {
        delete m_pUpdateRestart;
        m_pUpdateRestart = NULL;
    }
    if ( NULL != m_pUpdateBegin    )
    {
        delete m_pUpdateBegin;
        m_pUpdateBegin = NULL;
    }
    if ( NULL != m_pUpdateHeader   )
    {
        delete m_pUpdateHeader;
        m_pUpdateHeader = NULL;
    }
    if ( NULL != m_pUpdateData     )
    {
        delete m_pUpdateData;
        m_pUpdateData = NULL;
    }
    if ( NULL != m_pUpdateEnd      )
    {
        delete m_pUpdateEnd;
        m_pUpdateEnd = NULL;
    }

#endif // #ifdef ODBC_PREPARED

}
/*===========================================================================*
 *     TransformationDef::initResultSet
 *===========================================================================*/
SAPDB_Bool TransformationDef::initResultSet( sapdbwa_DBC & odbcConnection )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::initResult ()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Bool       rcBool   = SAPDB_TRUE;
    StudioOAL_String NativeErrorAsString;

    if ( getMetaData()->getExtrMode() == emLoadAsDDL_els00 ||getMetaData()->getExtrMode() == emLoadAsXML_els00  )
        return SAPDB_TRUE;

    if ( odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        MetaDataDef*  pMetaData     = getMetaData();
        tls00_PartSpec    PartSpec  = pMetaData->getPartSpec();

        StudioOAL_String  SaveCatalogStmt;

        if (ptAll_els00 == PartSpec.psPartType_ls00)
            SaveCatalogStmt  = SAVE_CAT_ALL_STMT_LS00;
        else if (ptUser_els00 == PartSpec.psPartType_ls00)
            SaveCatalogStmt = SAVE_CAT_USER_STMT_LS00;
        else if (ptTable_els00 == PartSpec.psPartType_ls00)
        {
            SAPDB_Int4 nTabOwnerLength = PartSpec.psTabOwnr_ls00.length();
            SAPDB_Int4 nTabNameLength  = PartSpec.psTabName_ls00.length();

            if (0 != nTabOwnerLength)
            {
                SaveCatalogStmt = "SAVE CATALOG OF \"";

                StudioOAL_String tabowner_UTF8;
                SAPDB_Char *pszTabOwner = PartSpec.psTabOwnr_ls00.asCharp();
                tabowner_UTF8.ConvertFromASCII_Latin1(pszTabOwner, pszTabOwner + nTabOwnerLength);

                SaveCatalogStmt += tabowner_UTF8;
                SaveCatalogStmt += "\".\"";

            }

            if (0 != nTabNameLength)
            {
                if ( 0 == nTabOwnerLength )
                     SaveCatalogStmt = "SAVE CATALOG OF \"";

                StudioOAL_String tabname_UTF8;
                SAPDB_Char *pszTabName  = PartSpec.psTabName_ls00.asCharp();
                tabname_UTF8.ConvertFromASCII_Latin1(pszTabName, pszTabName + nTabNameLength);

                SaveCatalogStmt += tabname_UTF8;
                SaveCatalogStmt += "\" INTO ";
                SaveCatalogStmt += SAVE_CAT_TABLE_LS00;
            }
        }

        if (tmRestart_els31 != pMetaData->getTransMode())
        {
            StudioOAL_String  record[10];

            // Create special loader system tables/dbprocs if not yet existent
            rcBool = CreateLoaderSystemObjects();
            if (SAPDB_TRUE == rcBool && SaveCatalogStmt != 0 )
            {
                // Run SAVE CATALOG ... and fill system table TRANSFORMATIONMODEL
                rcBool = LoadTransformationPackage(SaveCatalogStmt);
                if (SAPDB_FALSE == rcBool)
                {
                    // Fill error object
                    sapdb_Error *pErrorObj = pMetaData->getError();
                    pErrorObj->isError(SAPDB_TRUE);
                    pErrorObj->setReturnCode(errODBCErrors_els98);
                    pErrorObj->setNativeError(getNativeError());
                    pErrorObj->setErrorText(getErrorText());
                }
                else
                {
                    rcBool = executeSQL(SEL_TASK_ID_LS00);
                    if (SAPDB_TRUE == rcBool)
                    {
                        readResult( record );
                        m_nTaskID = AtoI( record[0] );
                    }
                    else
                    {
                        NativeErrorAsString = getNativeErrorAsString();
                        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());
                    }
                }
            }
        }//if (  getMetaData()->getTransMode() != tmRestart_els31 )


#ifdef ODBC_PREPARED
        // Prepare Statements

        /*-------------------------------------------------------------------------*
         * Prepare the WHERE clause for the SQL statements.                        *
         *-------------------------------------------------------------------------*/
        StudioOAL_String whereClause(" WHERE  owner = ? AND tablename = ? ");
        StudioOAL_String append(" AND TABLETYPE IN('TABLE') ");


        // SQLAllocStmt     SQLPrepare
        // SQLNumParams     SQLDescribeParam SQLBindParameter
        // SQLNumResultCols SQLDescribeCol   SQLBindCol
        StudioOAL_String update("UPDATE TRANSFORMATIONMODEL SET CATALOGSTREAMFORMAT = 'DDL' ");
        update += whereClause;
        update += " AND TABLETYPE = ?";

        rcBool = m_pupdateCat->init(update);

        if (SAPDB_TRUE == rcBool)
        {
            update   = " UPDATE TRANSFORMATIONMODEL SET DATASTREAMFORMAT = 'PAGES' ";
            update  += whereClause;
            update  += append;

            rcBool = m_pUpdatePages->init(update);
        }
        if (SAPDB_TRUE == rcBool)
        {
            update  = " UPDATE TRANSFORMATIONMODEL SET DATASTREAMFORMAT = 'RECORDS' ";
            update += whereClause;
            update += append;

            rcBool = m_pUpdateRecords->init(update);
        }
        if (SAPDB_TRUE == rcBool)
        {
            update  = " UPDATE TRANSFORMATIONMODEL SET RESTART = FALSE ";
            update += whereClause;
            update += append;

            rcBool = m_pUpdateRestart->init(update);
        }
        if (SAPDB_TRUE == rcBool)
        {
            update   = " UPDATE TRANSFORMATIONMODEL SET STARTTIME = TIMESTAMP ";
            update  += whereClause;
            update  += append;

            rcBool = m_pUpdateBegin->init(update);
        }
        if (SAPDB_TRUE == rcBool)
        {
            update   = " UPDATE TRANSFORMATIONMODEL SET "
                       " ROWCOUNT      = ?, "
                       " DATASTREAMHEADERBLOCK   = ?, "
                       " DATASTREAMHEADERPOS     = ?  ";
            update  += whereClause;
            update  += append;

            rcBool = m_pUpdateHeader->init(update);
        }
        if (SAPDB_TRUE == rcBool)
        {
            update   = " UPDATE TRANSFORMATIONMODEL SET "
                       " ROWCOUNT   = ?, "
                       " DATASTREAMDATABLOCK  = ?, "
                       " DATASTREAMDATAPOS    = ?  ";
            update  += whereClause;
            update  += append;

            rcBool = m_pUpdateData->init(update);
        }
        if (SAPDB_TRUE == rcBool)
        {
            update   = " UPDATE TRANSFORMATIONMODEL SET ENDTIME = TIMESTAMP ";
            update  += whereClause;
            update  += append;

            rcBool = m_pUpdateEnd->init(update);
        }
        if (SAPDB_FALSE == rcBool)
        {
            pMetaData->getError()->setErrorText(getErrorText());
            pMetaData->getError()->isError(isError());

            NativeErrorAsString = getNativeErrorAsString();
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());
        }
#endif // ODBC_PREPARED

  }
  return rcBool;
}

/*===========================================================================*
 *     TransformationDef::unload
 *===========================================================================*/
SAPDB_Bool TransformationDef::unload( sapdbwa_DBC & odbcConnection )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::unload()");

    SAPDB_Bool       rcBool       = SAPDB_TRUE;
    SAPDB_Bool       rcExists     = SAPDB_FALSE;
    RepServMessages *pMsgInstance = RepServMessages::Instance();

    StudioOAL_String  SaveCatalogStmt;

    MetaDataDef*    pMetaData   = getMetaData();
    tls00_PartSpec  PartSpec    = pMetaData->getPartSpec();


    if (ptAll_els00 == PartSpec.psPartType_ls00)
        SaveCatalogStmt  = SAVE_CAT_ALL_STMT_LS00;
    else if (ptUser_els00 == PartSpec.psPartType_ls00)
        SaveCatalogStmt = SAVE_CAT_USER_STMT_LS00;
    else if (ptTable_els00 == PartSpec.psPartType_ls00)
    {
        StudioOAL_String owner;
        StudioOAL_String tablename;

        SAPDB_Char*  tabOwner      = PartSpec.psTabOwnr_ls00.asCharp();
        SAPDB_Char*  tabName       = PartSpec.psTabName_ls00.asCharp();

        SAPDB_Int4 nTabOwnerLength = PartSpec.psTabOwnr_ls00.length();
        SAPDB_Int4 nTabLength      = PartSpec.psTabName_ls00.length();

        owner    .ConvertFromASCII_Latin1(tabOwner, tabOwner + nTabOwnerLength);
        tablename.ConvertFromASCII_Latin1(tabName , tabName  + nTabLength);

        SaveCatalogStmt =  "SAVE CATALOG OF \"";
        SaveCatalogStmt += owner;
        SaveCatalogStmt += "\".\"";
        SaveCatalogStmt += tablename;
        SaveCatalogStmt += "\" INTO ";
        SaveCatalogStmt += SAVE_CAT_TABLE_LS00;
    }

    // Create special loader system tables/dbprocs if not yet existent
    rcBool = CreateLoaderSystemObjects();
    if (SAPDB_TRUE == rcBool)
        rcBool = LoadTransformationPackage(SaveCatalogStmt);
    return rcBool;
}

/*
  -----------------------------------------------------------------------------
  function:     TransformationDef::switchUser
  -----------------------------------------------------------------------------
*/
SAPDB_Int4 TransformationDef::switchUser( StudioOAL_String oldUser, StudioOAL_String newUser, tsp00_Addr ErrText )
{
     ROUTINE_DBG_MEO00 ("TransformationDef::switchUser");

     tsp00_Int4 rc = errOK_els00;

     tls00_DBInfo   *pDBInfo = getMetaData()->getConnection();

     if (oldUser.Size() != newUser.Size())
         rc = ls15SwitchUser(pDBInfo, newUser, ErrText);
     else
     {
         if (oldUser != newUser)
            rc = ls15SwitchUser(pDBInfo, newUser, ErrText);
     }

     return rc;
}

/*
  -----------------------------------------------------------------------------
  function:     TransformationDef::readResult
  -----------------------------------------------------------------------------
*/
SAPDB_Bool TransformationDef::readResult( StudioOAL_String * record )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::readResult");

    // OWNER, TABLENAME, DATASTREAMNAME, DATASTREAMHEADERBLOCK, DATASTREAMHEADERPOS, DATASTREAMDATABLOCK, DATASTREAMDATAPOS, PAGECOUNT, ROWCOUNT, MAX(TASKID)
    return MetaDataItem::readResult(record) ;
}
/*
  -----------------------------------------------------------------------------
  function:     TransformationDef::initTransformationStep
  -----------------------------------------------------------------------------
*/
SAPDB_Bool TransformationDef::initTransformationStep( StudioOAL_String * record )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::initTransformationStep");

    SAPDB_Bool rc = SAPDB_FALSE;

    // TRANSFORMATION, PART, OWNER, TABLENAME,
    // DATASTREAMTYPE, DATASTREAMNAME, DATASTREAMFORMAT, CODETYPE, DATASTREAMEBID,
    // DATASTREAMHEADERBLOCK, DATASTREAMHEADERPOS, DATASTREAMDATABLOCK, DATASTREAMDATAPOS, DATASTREAMTRAILERBLOCK, DATASTREAMTRAILERPOS,
    // PAGECOUNT, ROWCOUNT, MAX(TASKID) AS TASKID , EXCLUDE
    if ( MetaDataItem::readResult(record) )
    {
        m_transformation                = record[0];
        m_partspec                      = "TABLE";
        m_owner                         = record[1];
        m_tablename                     = record[2];
        m_datastreamtype                = record[3];
        m_datastreamname                = record[4];
        m_datastreamformat              = record[5];
        m_codetype                      = record[6];
        m_datastreamebid                = record[7];
        m_headerpos_block               = record[8];
        m_headerpos_byte                = record[9];
        m_datapos_block                 = record[10];
        m_datapos_byte                  = record[11];
        m_trailerpos_block              = record[12];
        m_trailerpos_byte               = record[13];
        m_headerpos.lnu2GB_Blocks_ls00  = _ttoi(REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,record[8].StrPtr()))));
        m_headerpos.lnuRemainder_ls00   = _ttoi(REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,record[9].StrPtr()))));
        m_datapos.lnu2GB_Blocks_ls00    = _ttoi(REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,record[10].StrPtr()))));
        m_datapos.lnuRemainder_ls00     = _ttoi(REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,record[11].StrPtr()))));
        m_trailerpos.lnu2GB_Blocks_ls00 = _ttoi(REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,record[12].StrPtr()))));
        m_trailerpos.lnuRemainder_ls00  = _ttoi(REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,record[13].StrPtr()))));
        m_extractcount                  = _ttoi(REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,record[14].StrPtr()))));
        m_loadcount                     = _ttoi(REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,record[15].StrPtr()))));
        m_taskid                        = "1";
        record[16].Compare("TRUE") == 0 ? m_exclude  = SAPDB_TRUE  : m_exclude = SAPDB_FALSE ;

        genLoaderStatement();

        rc = SAPDB_TRUE;
    }
    return rc;
}
/*
  -----------------------------------------------------------------------------
  function:     TransformationDef::genLoaderStatement
  -----------------------------------------------------------------------------
*/
void TransformationDef::genLoaderStatement()
{
    if ( m_datastreamformat.Compare("PAGES") == 0 )
    {
        if ( m_transformation.Compare("EXTRACT") == 0 )
        {
            m_statement  = m_transformation;
            m_statement += " TABLE ";
            m_statement += " TABLE ";
            m_statement += " \"";
            m_statement += m_owner;
            m_statement += "\".\"";
            m_statement += m_tablename;
            m_statement += "\" ";
            m_statement += " DATA ";
            m_statement += " OUTSTREAM ";
            m_statement += m_datastreamtype;
            m_statement += " '";
            m_statement += m_datastreamname;
            m_statement += "' ";
            m_statement += m_datastreamformat;
            m_statement += " ";
            m_statement += m_codetype;
        }
        if ( m_transformation.Compare("LOAD") == 0 )
        {
            m_statement  = m_transformation;
            m_statement += " TABLE ";
            m_statement += " TABLE ";
            m_statement += " \"";
            m_statement += m_owner;
            m_statement += "\".\"";
            m_statement += m_tablename;
            m_statement += "\" ";
            m_statement += " DATA ";
            m_statement += " INSTREAM ";
            m_statement += m_datastreamtype;
            if ( m_datastreamtype.Compare("TAPE") == 0 )
            {
                 m_statement += " EBID ";
                 m_statement += "'";
                 m_statement += m_datastreamebid;
                 m_statement += "'";
            }
            m_statement += " '";
            m_statement += m_datastreamname;
            m_statement += "' ";
            m_statement += m_datastreamformat;
            m_statement += " ";
            m_statement += m_codetype;
            m_statement += " START ";
            m_statement += m_headerpos_block;
            m_statement += ":";
            m_statement += m_headerpos_byte;
            m_statement += " ";
            m_statement += m_datapos_block;
            m_statement += ":";
            m_statement += m_datapos_byte;;
        }
        m_statement += " INTERNAL ";
        if ( true == m_exclude )
             m_statement += " EXCLUDE ";
    }

    if ( m_datastreamformat.Compare("RECORDS") == 0 )
    {
        if ( m_transformation.Compare("EXTRACT") == 0 )
        {
            m_statement  = m_transformation;
            m_statement += " DATA ";
            m_statement += " TABLE ";
            m_statement += " \"";
            m_statement += m_owner;
            m_statement += "\".\"";
            m_statement += m_tablename;
            m_statement += "\" ";
            m_statement += " OUTSTREAM ";
            m_statement += m_datastreamtype;
            m_statement += " '";
            m_statement += m_datastreamname;
            m_statement += "' ";
            m_statement += m_datastreamformat;
            m_statement += " ";
            m_statement += m_codetype;
            m_statement += " START ";
            m_statement += "0";
            m_statement += ":";
            m_statement += m_datapos_byte;
            m_statement += " ";
            m_statement += "0";
            m_statement += ":";
            m_statement += "0";
        }
        if ( m_transformation.Compare("LOAD") == 0 )
        {
            m_statement  = m_transformation;
            m_statement += " DATA ";
            m_statement += " TABLE ";
            m_statement += " \"";
            m_statement += m_owner;
            m_statement += "\".\"";
            m_statement += m_tablename;
            m_statement += "\" ";
            m_statement += " INSTREAM ";
            m_statement += m_datastreamtype;
            if ( m_datastreamtype.Compare("TAPE") == 0 )
            {
                 m_statement += " EBID ";
                 m_statement += "'";
                 m_statement += m_datastreamebid;
                 m_statement += "'";
            }
            m_statement += " '";
            m_statement += m_datastreamname;
            m_statement += "' ";
            m_statement += m_datastreamformat;
            m_statement += " ";
            m_statement += m_codetype;
            bool start = false ;
            if ( true == start )
            {
                m_statement += " START ";
                m_statement += m_headerpos_block;
                m_statement += ":";
                m_statement += m_headerpos_byte;
                m_statement += " ";
                m_statement += m_datapos_block;
                m_statement += ":";
                if ( m_datapos_byte.Compare("0") == 0 )
                    m_statement += "-2";
                else
                    m_statement += m_datapos_byte;
            }
        }
        m_statement += " INTERNAL ";
        if ( true == m_exclude )
             m_statement += " EXCLUDE ";
    }
}
/*
  -----------------------------------------------------------------------------
  function:     TransformationDef::initTransformation
  -----------------------------------------------------------------------------
*/
SAPDB_Int4  TransformationDef::initTransformation()
{
    ROUTINE_DBG_MEO00 (" TransformationDef::initTransformation()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    tsp00_Int4 rc = errOK_els00;

    tls00_DBInfo *pDBInfo  = getMetaData()->getConnection();

    // initialize the request string
    m_pCommand->cmdReqErr_ls00 = 0;
    m_pCommand->cmdReqPos_ls00 = 0;
    m_pCommand->cmdReqDat_ls00 = REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,m_statement.StrPtr())));
    m_pCommand->cmdReqDat_ls00[m_statement.Length()] = DEF_BYTE_LS00;

    // initialize the reply string
    m_pCommand->cmdScnDat_ls00 = NULL;
    memset(&m_pCommand->cmdScanRC_ls00 ,0,sizeof(tls00_ScanResult));
    memset(&m_pCommand->cmdSubFunc_ls00,0,sizeof(tls00_SubFuncClass));
    memset( m_pCommand->cmdRpyDat_ls00, DEF_BYTE_LS00, MAX_REPLY_LENGTH_LS00);

    // initialize logging behaviour
    m_pCommand->cmdInternal_ls00  = SAPDB_TRUE;
    m_pCommand->cmdLogging_ls00   = SAPDB_FALSE;

    if ( SAPDB_FALSE  != m_pCommand->cmdLogging_ls00   )
    {
        tsp00_Date  Date;
        tsp00_Time  Time;
        sqldattime(Date, Time);
        tsp00_Datec szDate;
        tsp00_Timec szTime;
        szDate.p2c(Date);
        szTime.p2c(Time);
        pMsgInstance->ls98PrintMessage(layDispatch_els98, msgStartCommand_els98,  szDate.asCharp(), szTime.asCharp());
        pMsgInstance->ls98PrintMessage(layDispatch_els98, msgSimpleMsg_els98, m_statement.StrPtr());
    }

    rc = ls11ParseLoadCommand( pDBInfo, m_pCommand );

    return rc;
}
/*
  -----------------------------------------------------------------------------
  function:     TransformationDef::genInverseLoaderStatement
  -----------------------------------------------------------------------------
*/
void TransformationDef::genInverseLoaderStatement(  tls00_DatExtrCmd *& pDatExtrCmd, tls00_DextractRec *pDatExtrRec )
{
    ROUTINE_DBG_MEO00 ("genCreateInverseStatement");

    RepServMessages *pMsgObj  = RepServMessages::Instance();
    tsp00_Int4       rc       = errOK_els00;

    m_inverseStatement = "";

    tls00_DBInfo           *pDBInfo      = getMetaData()->getConnection();

    tls00_TableDescription *pTableDef    = &pDatExtrRec->derTableInfo_ls00; // pTableDef, pColumnName, pColumnData, pParamInfo
    tls00_MultColSpec      *pMultColumns = &pDatExtrCmd->dexOutSpec_ls00;  
    tls00_Column           *pColumn      = NULL;
    tls00_ColumnData*       pColumnData  = NULL;
    tsp00_Addr              pColumnName  = NULL;
    tls00_ParamInfo        *pParamInfo   = NULL;

    tls00_FileFormat        *pDatFileFormat= &pDatExtrCmd->dexDatFile_ls00.fsFormat_ls00;
    tls00_CodeType          ffoCodeType_ls00;       
    tls00_DateTime          ffoDateType_ls00;
    _TCHAR                  ffoDateMask_ls00[128];           
    tin_date_mask           ffoSpecialDateMask_ls00;    
    tls00_DateTime          ffoTimeType_ls00; 
    _TCHAR                  ffoTimeMask_ls00[128];      
    tin_date_mask           ffoSpecialTimeMask_ls00;    
    tls00_DateTime          ffoTimeStampType_ls00; 
    _TCHAR                  ffoTimeStampMask_ls00[128];         
    tin_date_mask           ffoSpecialTimeStampMask_ls00;   
    char                    ffoThsdChar_ls00;
    char                    ffoDecPoint_ls00;
    char                    ffoSeperat_ls00[2];     
    char                    ffoDelimit_ls00[2];     
    _TCHAR                  ffoCodeSet_ls00[64];
    tsp00_Int2              ffoTValLen_ls00;        
    _TCHAR                  ffoTrueVal_ls00[11];
    tsp00_Int2              ffoFValLen_ls00;        
    _TCHAR                  ffoFalseVal_ls00[11];
    _TCHAR                  ffoNullSpec_ls00[21];
    tsp00_Int4              ffoCntSpec_ls00; 
    tsp00_Int2              ffoCSetLen_ls00;
    tsp00_Int2              ffoNSpecLen_ls00;
    tsp00_SwapKind          ffoIntSpec_ls00; 
    bool                    ffoBinary_ls00;         
    bool                    ffoFormatted_ls00;
    bool                    ffoCompress_ls00;
    bool                    ffoPage_ls00;     
    bool                    ffoCompact_ls00;  
    bool                    ffoDdl_ls00;
    bool                    ffoXml_ls00;
    tsp00_Int4              ffoBytesPerLine_ls00;

    if ( pDatExtrCmd->dexDatFile_ls00.fsFileName_ls00 != NULL )
    {
        ffoCodeType_ls00                = pDatFileFormat->ffoCodeType_ls00; 
        ffoDateType_ls00                = pDatFileFormat->ffoDateType_ls00; 
        ffoTimeType_ls00                = pDatFileFormat->ffoTimeType_ls00;
        ffoTimeStampType_ls00           = pDatFileFormat->ffoTimeStampType_ls00;
        memcpy(ffoDateMask_ls00,pDatFileFormat->ffoDateMask_ls00,sizeof(pDatFileFormat->ffoDateMask_ls00[128])); 
        ffoSpecialDateMask_ls00         = pDatFileFormat->ffoSpecialDateMask_ls00; 
        memcpy(ffoTimeMask_ls00,pDatFileFormat->ffoTimeMask_ls00,sizeof(pDatFileFormat->ffoTimeMask_ls00[128]));
        ffoSpecialTimeMask_ls00         = pDatFileFormat->ffoSpecialTimeMask_ls00;
        memcpy(ffoTimeStampMask_ls00,pDatFileFormat->ffoTimeStampMask_ls00,sizeof(pDatFileFormat->ffoTimeStampMask_ls00[128]));    
        ffoSpecialTimeStampMask_ls00    = pDatFileFormat->ffoSpecialTimeStampMask_ls00;
        ffoThsdChar_ls00                = pDatFileFormat->ffoThsdChar_ls00;
        ffoDecPoint_ls00                = pDatFileFormat->ffoDecPoint_ls00;
        memcpy(ffoSeperat_ls00,pDatFileFormat->ffoSeperat_ls00,sizeof(pDatFileFormat->ffoSeperat_ls00[2]));  
        memcpy(ffoDelimit_ls00,pDatFileFormat->ffoDelimit_ls00,sizeof(pDatFileFormat->ffoDelimit_ls00[2]));    
        memcpy(ffoCodeSet_ls00,pDatFileFormat->ffoCodeSet_ls00,sizeof(pDatFileFormat->ffoCodeSet_ls00[64]));
        ffoTValLen_ls00                 = pDatFileFormat->ffoTValLen_ls00;    
        strcpy(ffoTrueVal_ls00,pDatFileFormat->ffoTrueVal_ls00);
        ffoFValLen_ls00                 = pDatFileFormat->ffoFValLen_ls00;
        strcpy(ffoFalseVal_ls00,pDatFileFormat->ffoFalseVal_ls00);
        strcpy(ffoNullSpec_ls00,pDatFileFormat->ffoNullSpec_ls00);
        ffoCntSpec_ls00                 = pDatFileFormat->ffoCntSpec_ls00;
        ffoCSetLen_ls00                 = pDatFileFormat->ffoCSetLen_ls00;
        ffoNSpecLen_ls00                = pDatFileFormat->ffoNSpecLen_ls00;
        ffoIntSpec_ls00                 = pDatFileFormat->ffoIntSpec_ls00;
        ffoBinary_ls00                  = pDatFileFormat->ffoBinary_ls00;         
        ffoFormatted_ls00               = pDatFileFormat->ffoFormatted_ls00;
        ffoCompress_ls00                = pDatFileFormat->ffoCompress_ls00;
        ffoPage_ls00                    = pDatFileFormat->ffoPage_ls00;     
        ffoCompact_ls00                 = pDatFileFormat->ffoCompact_ls00;  
        ffoDdl_ls00                     = pDatFileFormat->ffoDdl_ls00;
        ffoXml_ls00                     = pDatFileFormat->ffoXml_ls00;
        ffoBytesPerLine_ls00            = pDatFileFormat->ffoBytesPerLine_ls00;
    }
    else
    {
        ffoCodeType_ls00                = pDBInfo->dbiSession_ls00.siCodeType_ls00;
        ffoDateType_ls00                = pDBInfo->dbiSession_ls00.siDateType_ls00;
        ffoTimeType_ls00                = pDBInfo->dbiSession_ls00.siTimeType_ls00;
        ffoTimeStampType_ls00           = pDBInfo->dbiSession_ls00.siStampType_ls00;
        //ffoDateMask_ls00              = 
        //ffoSpecialDateMask_ls00       = 
        //ffoTimeMask_ls00              = 
        //ffoSpecialTimeMask_ls00       = 
        //ffoTimeStampMask_ls00         = 
        //ffoSpecialTimeStampMask_ls00  = 
        ffoThsdChar_ls00                = pDBInfo->dbiSession_ls00.siThsdChar_ls00;
        ffoDecPoint_ls00                = pDBInfo->dbiSession_ls00.siDecPoint_ls00;
        memcpy(ffoSeperat_ls00 ,pDBInfo->dbiSession_ls00.siSeperat_ls00,sizeof(pDBInfo->dbiSession_ls00.siSeperat_ls00[2]));
        memcpy(ffoDelimit_ls00 ,pDBInfo->dbiSession_ls00.siDelimit_ls00,sizeof(pDBInfo->dbiSession_ls00.siDelimit_ls00[2]));
        strcpy(ffoTrueVal_ls00 ,pDBInfo->dbiSession_ls00.siTrueVal_ls00);
        strcpy(ffoFalseVal_ls00,pDBInfo->dbiSession_ls00.siFalseVal_ls00);
        strcpy(ffoNullSpec_ls00,pDBInfo->dbiSession_ls00.siNullSpec_ls00);
        //ffoNSpecLen_ls00              = 
        //ffoIntSpec_ls00               = 
        //ffoBinary_ls00                = 
        //ffoFormatted_ls00             = 
        //ffoCompress_ls00              = 
        //ffoPage_ls00                  = 
        //ffoCompact_ls00               = 
        //ffoDdl_ls00                   = 
        //ffoXml_ls00                   = 
        //ffoBytesPerLine_ls00          = 
    }

    tsp00_Int4 lPos                = 0;
    tsp00_Int4 pInverseStatementLen = ((pMultColumns->mcsCount_ls00 + 2) * (KNL_IDENTIFIER_SIZE + 50)) + 256;

    tsp00_Addr pInverseStatement = new _TCHAR[pInverseStatementLen];
    pInverseStatement[0] = '\0';

    //*    fastload,dataload,dataupdate?
    if ( ( (pDatExtrCmd->dexRestore_ls00    == resFastloadNoDDL_els00) ||
           (pDatExtrCmd->dexRestore_ls00    == resFastload_els00 )      ) &&
           (pDatExtrRec->derLongColCnt_ls00 != 0) )
    {
        lPos = sp77sprintf(pInverseStatement, pInverseStatementLen, pszLoadCmdBeginString2[STATIC_CAST(int, resDataload_els00)]);
    }
    else
    {
        lPos = sp77sprintf(pInverseStatement, pInverseStatementLen, pszLoadCmdBeginString2[STATIC_CAST(int, pDatExtrCmd->dexRestore_ls00)]);
    }
    //*
    //*     table name
    //*
    lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, "\"%s\""NEW_LINE_LS00"", pDatExtrCmd->dexPartSpec_ls00.psTabName_ls00.asCharp());

    //*     column description
    tsp00_Int4 i = 0;

    for (i; i < pMultColumns->mcsCount_ls00; ++i)
    {
        pColumnName = (*pTableDef->tdColName_ls00[i]).asCharp();
        pParamInfo  = pTableDef->tdParamArray_ls00[i];
        pColumn     = pMultColumns->mcsColumn_ls00[i];

        if (true == pColumn->colIsLit_ls00)       // Extrabehandlung fuer literale im kommando
        {
            continue;
        }

        if (true == ffoFormatted_ls00)
        {
            lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("\"%s\" %d-%d CHAR"),
                                pColumnName, pColumn->colFPos_ls00.fpoStart_ls00, pColumn->colFPos_ls00.fpoEnd_ls00);
        }
        else
        {
            lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("\"%s\" %d CHAR"),
                                pColumnName, pColumn->colFPos_ls00.fpoStart_ls00);
        }
        pColumnData = &pDatExtrRec->pderColumnData_ls00[i];
        if ( (1 == szMap_BlobDataType_ls00[pColumnData->cdSQLDataType_ls00]) &&
             (0 == szMap_LongDataType_ls00[pColumnData->cdSQLDataType_ls00])  )
        {
            if (false == ffoBinary_ls00)
            {
                lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T(" HEX"));
            }
        }
        if ( (false == pParamInfo->piMode_ls00.includes(sp1ot_mandatory)) ||
             (true  == pParamInfo->piMode_ls00.includes(sp1ot_default)) )
        {
            lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T(" DEFAULT NULL"NEW_LINE_LS00""));
        }
        else
        {
            lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T(NEW_LINE_LS00));
        }
    }


    //*     infile-name
    lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("INSTREAM %s '%s'"NEW_LINE_LS00""),
                        pszDeviceTypeName_ls00[pDatExtrCmd->dexDatFile_ls00.fsDeviceType_ls00], pDatExtrCmd->dexDatFile_ls00.fsFileName_ls00);

    //*     infile format
    if (true == ffoCompact_ls00)
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T(" RECORDS "));
    }
    else if (true == ffoFormatted_ls00)
    {
        if (false == ffoBinary_ls00)
        {
            lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T(" FORMATTED "));
        }
        else
        {
            lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T(" FORMATTED BINARY"NEW_LINE_LS00""));
        }
    }
    else
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T(" COMPRESSED "));
    }

    //*     encoding (not if FORMATTED BINARY)
    if ( (false == ffoFormatted_ls00) ||
         ( (true == ffoFormatted_ls00) && (false == ffoBinary_ls00) ) )
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("%s"NEW_LINE_LS00""), 
                            pszEncoding2[ffoCodeType_ls00]);
    }


    //*   decimal symbol
    if (NO_THSD_GROUPS_LS00 == ffoThsdChar_ls00)
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("DECIMAL '//%c/'"NEW_LINE_LS00""),
                            ffoDecPoint_ls00);
    }
    else
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("DECIMAL '/%c/%c/'"NEW_LINE_LS00""),
                            ffoThsdChar_ls00, ffoDecPoint_ls00);
    }

    //* string separator (if it is not the default=comma)
    if (COMMA_LS00 != ffoSeperat_ls00[0])
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("SEPARATOR '%c'"NEW_LINE_LS00""),
                            ffoSeperat_ls00[0]);
    }

    //* string delimiter (if it is not the default=double quotes)
    if (QUOTE_LS00 != ffoDelimit_ls00[0])
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("DELIMITER '%c'"NEW_LINE_LS00""),
                            ffoDelimit_ls00[0]);
    }

    //*     DATE format
    if (ffoDateType_ls00 == dtFreeMask_els00)
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("DATE '%s'"NEW_LINE_LS00""),
                            ffoDateMask_ls00);
    }
    else
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos,_T("DATE %s"NEW_LINE_LS00""),
                            pszDateTimeType2[STATIC_CAST(int, ffoDateType_ls00)]);
    }


    //*     TIME format
    if (ffoTimeType_ls00 == dtFreeMask_els00)
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("TIME '%s'"NEW_LINE_LS00""),
                            ffoTimeMask_ls00);
    }
    else
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("TIME %s"NEW_LINE_LS00""),
                            pszDateTimeType2[STATIC_CAST(int, ffoTimeType_ls00)]);
    }


    //*     TIMESTAMP format
    if (ffoTimeStampType_ls00 == dtFreeMask_els00)
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("TIMESTAMP '%s'"NEW_LINE_LS00""),
                            ffoTimeStampMask_ls00);
    }
    else
    {
        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("TIMESTAMP %s"NEW_LINE_LS00""),
                            pszDateTimeType2[STATIC_CAST(int, ffoTimeStampType_ls00)]);
    }


    //*     NULL value representation
    lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("NULL '%s'"NEW_LINE_LS00""), 
                        ffoNullSpec_ls00);

    //*     boolean value representation
    lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T("BOOLEAN '%s/%s'"NEW_LINE_LS00""),
                        ffoTrueVal_ls00, ffoFalseVal_ls00);

    //*     startpos and recordcount
    if ( pDatExtrRec->derPartSpec_ls00.psPartType_ls00 > ptTable_els00)

         lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos, _T(" START %s %d " ), 
                             pDatExtrRec->derpStartPos_ls00, pDatExtrRec->derRecordCount_ls00 );

    //*     long  columns?
    if ( ffoCompact_ls00 == false )
    {
        if (0 != pDatExtrRec->derLongColCnt_ls00)
        {
            for (i = 0; i < pMultColumns->mcsCount_ls00; ++i)
            {
                pColumn = pMultColumns->mcsColumn_ls00[i];
                if (1 == szMap_LongDataType_ls00[pDatExtrRec->pderColumnData_ls00[i].cdSQLDataType_ls00])
                {
                    if (false == pColumn->colLongInfo.loibFileNumbered_ls00)
                    {   // long file not numbered
                        lPos += sp77sprintf(pInverseStatement + lPos, pInverseStatementLen - lPos,
                                            _T("LONGFILE \"%s\" '%s' %s"NEW_LINE_LS00""),
                                            pColumn->colName_ls00.asCharp(),
                                            pColumn->colLongInfo.loiFileName_ls00,
                                            pszEncoding2[pColumn->colLongInfo.loiFileEncoding_ls00]);
                    }
                }
            }
        }
    }// if ( fsFormat_ls00.ffoCompact_ls00 == false )

    m_inverseStatement.AssignRaw(REINTERPRET_CAST(unsigned char*,pInverseStatement),
                                                         _tcslen(pInverseStatement));

}
/*===========================================================================*
 *    TransformationDef::freeTransformation
 *===========================================================================*/
void TransformationDef::freeTransformation(tls00_ScanResult Type )
{
    if ( m_pCommand->cmdScnDat_ls00 != NULL )
    {
         ls10FreeTransformation( Type, m_pCommand->cmdScnDat_ls00);
         m_pCommand->cmdScnDat_ls00 = NULL;
    }
}

/*===========================================================================*
 *    TransformationDef::writeResult
 *===========================================================================*/
SAPDB_Bool TransformationDef::writeResult( StudioOAL_String record  )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::writeResult ()");

    return MetaDataItem::writeLine ( record);
}
/*===========================================================================*
 *    TransformationDef::updateTaskStatistic
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateTaskStatistic()
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateTaskStatistic()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Bool       rcBool       = SAPDB_TRUE;
  
    StudioOAL_String  record[1];

    _TCHAR sztransformation[4096];
    sztransformation[0] = 0;
    sp77sprintf(sztransformation, 4096, CAT_OBJECT_COUNT_LS00, getMetaData()->getConnection()->dbiPackageid_ls00.StrPtr());

    if ( executeSQL(sztransformation) )
    {
        readResult( record );
        m_nObjectCount = AtoI( record[0] );
    }

    sztransformation[0] = 0;
    sp77sprintf(sztransformation, 4096, CAT_TABLE_COUNT_LS00, getMetaData()->getConnection()->dbiPackageid_ls00.StrPtr());

    if ( executeSQL( sztransformation ) )
    {
        readResult( record ) ;
        m_nTableCount  = AtoI( record[0] );
    }

    sztransformation[0] = 0;
    sp77sprintf(sztransformation, 4096, CAT_VIEW_COUNT_LS00, getMetaData()->getConnection()->dbiPackageid_ls00.StrPtr());

    if ( executeSQL(sztransformation) )
    {
        readResult( record );
        m_nViewCount  = AtoI( record[0] );
    }

    sztransformation[0] = 0;
    sp77sprintf(sztransformation, 4096, CAT_SYNONYM_COUNT_LS00, getMetaData()->getConnection()->dbiPackageid_ls00.StrPtr());

    if ( executeSQL(sztransformation) )
    {
        readResult( record );
        m_nSynonymCount = AtoI( record[0] );
    }

    return rcBool;
}
/*===========================================================================*
 *    TransformationDef::updateDatTask
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateDatTask( StudioOAL_String * parameter )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateDatTask()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();
    SAPDB_Bool       rcBool       = SAPDB_TRUE;

    StudioOAL_String  whereClause;

    whereClause     = " WHERE PACKAGEGUID = x'";
    whereClause    += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause    += "' ";

    StudioOAL_String  updateDatTask = "DELETE TRANSFORMATIONMODEL ";
    updateDatTask  += whereClause;
    updateDatTask  += " AND CMD  LIKE 'GRANT %%'";
    updateDatTask  += " OR  TABLETYPE <> 'TABLE' ";

    rcBool = m_pUpdate->openResult(updateDatTask);
    if (SAPDB_FALSE == rcBool)
    {
        TRACE_PRNF_MLS99(("failed ", "%s"        , updateDatTask.StrPtr() ));
        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 ,updateDatTask.StrPtr());
    }
    else
    {
        updateDatTask = "UPDATE TRANSFORMATIONMODEL ";
        updateDatTask  += " SET STEPID =  ";
        updateDatTask  += parameter[0];
        updateDatTask  += "STEPID";
        updateDatTask  += ", SEQ_NO = ";
        updateDatTask  += parameter[0];
        updateDatTask  += "SEQ_NO";
        updateDatTask  += ", SERVERNODE =  ";
        updateDatTask  += parameter[1];
        updateDatTask  += ", SERVERDB =  ";
        updateDatTask  += parameter[2];
        updateDatTask  += ", USERNAME =  ";
        updateDatTask  += parameter[3];
        updateDatTask  += ", CODEPAGEID =  ";
        updateDatTask  += parameter[4];
        updateDatTask  += ", STORAGEDEVICE = ";
        updateDatTask  += parameter[5];
        updateDatTask  += ", TRANSFORMATION = ";
        updateDatTask  += parameter[6];
        updateDatTask  += ", PART = ";
        updateDatTask  += parameter[7];
        updateDatTask  += ", DATASTREAMTYPE = ";
        updateDatTask  += parameter[8];
        updateDatTask  += ", DATASTREAMEBID = '";
        if ( parameter[9].Compare("") == 0 )
        {
            StudioOAL_String datastreamebid;
            parameter[9] = datastreamebid.AssignRaw(REINTERPRET_CAST(unsigned char*, getMetaData()->getConnection()->dbiSession_ls00.siNullSpec_ls00.asCharp()),
                                                                             _tcslen(getMetaData()->getConnection()->dbiSession_ls00.siNullSpec_ls00.asCharp()));
        }
        updateDatTask  += parameter[9];
        updateDatTask  += "'";
        updateDatTask  += ", DATASTREAMFORMAT = ";
        updateDatTask  += parameter[10];
        updateDatTask  += ", CODETYPE =  ";
        updateDatTask  += parameter[11];
        updateDatTask  += ", TRANSACTIONSIZE = ";
        updateDatTask  += parameter[12];
        updateDatTask  += ", EXCLUDE = FALSE, RESTART = TRUE, STARTTIME = NULL, ENDTIME = NULL ";
        updateDatTask  += whereClause;

        rcBool = m_pUpdate->openResult(updateDatTask);
        if (SAPDB_FALSE == rcBool)
        {
            TRACE_PRNF_MLS99(("failed ", "%s"        , updateDatTask.StrPtr() ));
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 ,updateDatTask.StrPtr());
        }
    }

    if (SAPDB_TRUE == rcBool)
        updateTaskStatistic();

    return rcBool;
}
/*===========================================================================*
 *    TransformationDef::updateCatTask
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateCatTask( StudioOAL_String * parameter )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateCatTask()");
    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Bool rcBool = SAPDB_TRUE;

    /*-------------------------------------------------------------------------*
     * Prepare the WHERE clause for the SQL statements.                        *
     *-------------------------------------------------------------------------*/
    StudioOAL_String whereClause(" WHERE PACKAGEGUID = x'");
    whereClause    += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause    += "' ";

    StudioOAL_String updateCatTask("UPDATE TRANSFORMATIONMODEL ");
    updateCatTask  += " SET SERVERNODE = ";
    updateCatTask  += parameter[1];
    updateCatTask  += ", SERVERDB =  ";
    updateCatTask  += parameter[2];
    updateCatTask  += ", CODETYPE =  ";
    updateCatTask  += parameter[3];
    updateCatTask  += ", USERNAME =  ";
    updateCatTask  += parameter[4];
    updateCatTask  += ", CODEPAGEID =  ";
    updateCatTask  += parameter[5];
    updateCatTask  += ", STORAGEDEVICE = ";
    updateCatTask  += parameter[6];
    updateCatTask  += ", TRANSFORMATION = ";
    updateCatTask  += parameter[7];
    updateCatTask  += ", PART = ";
    updateCatTask  += parameter[8];
    updateCatTask  += ", CATALOGSTREAMNAME = ";
    updateCatTask  += parameter[9];
    updateCatTask  += ", CATALOGSTREAMTYPE = ";
    updateCatTask  += parameter[10];
    updateCatTask  += ", CATALOGSTREAMEBID = '";
    if ( parameter[11].Compare("") == 0 )
    {
         StudioOAL_String catalogstreamebid;
         parameter[11] = catalogstreamebid.AssignRaw(REINTERPRET_CAST(unsigned char*, getMetaData()->getConnection()->dbiSession_ls00.siNullSpec_ls00.asCharp()),
                                                                              _tcslen(getMetaData()->getConnection()->dbiSession_ls00.siNullSpec_ls00.asCharp()));
    }
    updateCatTask  += parameter[11];
    updateCatTask  += "'";
    updateCatTask  += ", CATALOGSTREAMFORMAT = ";
    updateCatTask  += parameter[12];
    updateCatTask  += ", EXCLUDE = FALSE, RESTART = TRUE, STARTTIME = NULL, ENDTIME = NULL ";
    updateCatTask  += whereClause;

    rcBool = m_pUpdate->openResult(updateCatTask);
    if (SAPDB_FALSE == rcBool)
    {
        TRACE_PRNF_MLS99(("failed ", "%s", updateCatTask.StrPtr() ));
        RepServMessages::Instance()->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98, updateCatTask.StrPtr() );
    }

    if (SAPDB_TRUE == rcBool)
        updateTaskStatistic();

    return rcBool;
}
/*===========================================================================*
 *    TransformationDef::updateCat
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateCat( StudioOAL_String *parameter )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateCat()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();
    SAPDB_Bool       rcBool       = SAPDB_TRUE;

#ifndef ODBC_PREPARED

    /*-------------------------------------------------------------------------*
     * Prepare the WHERE clause for the SQL statements.                        *
     *-------------------------------------------------------------------------*/
    StudioOAL_String whereClause(" WHERE PACKAGEGUID = x'");
    whereClause  += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause  += "' AND OWNER = '";
    whereClause  += parameter[0];
    whereClause  += "' AND TABLENAME = '";
    whereClause  += parameter[1] ;
    whereClause  += "' AND TABLETYPE = ";
    whereClause  += "'";
    whereClause  += parameter[2] ;
    whereClause  += "' ";

    StudioOAL_String updateCat("UPDATE TRANSFORMATIONMODEL ");
    updateCat    += "SET CATALOGSTREAMFORMAT = 'DDL' ";
    updateCat    += whereClause;

    rcBool = m_pUpdate->openResult (updateCat);
    if (SAPDB_FALSE == rcBool)
    {
        TRACE_PRNF_MLS99(("failed ", "%s", updateCat.StrPtr() ));

        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateCat.StrPtr() );
    }

#endif //ODBC_PREPARED

#ifdef ODBC_PREPARED

    m_owner      = parameter[0] ;
    m_tableName  = parameter[1] ;

    /*-------------------------------------------------------------------------*
     * Update the column definitions from the database.                          *
     *-------------------------------------------------------------------------*/
    m_pUpdate->openResultDDL->reset();

    rcBool = m_pupdateCat->setParamValues(parameters);
    if (SAPDB_TRUE == rcBool )
    {
        /*-------------------------------------------------------------------------*
         * Execute the prepared statement                                          *
         *-------------------------------------------------------------------------*/
        rcBool = m_pupdateCat->execute();
    }

    if (SAPDB_FALSE == rcBool)
    {
        getMetaData()->getError()->setErrorText(m_pupdateCat->getErrorText());
        getMetaData()->getError()->isError(m_pupdateCat->isError());

        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, errorText.StrPtr());
    }

#endif // ODBC_PREPARED

    return rcBool;
}
/*===========================================================================*
 *    TransformationDef::updatePages
 *===========================================================================*/
SAPDB_Bool TransformationDef::updatePages(  StudioOAL_String owner, StudioOAL_String tablename )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updatePages()");

    SAPDB_Bool rcBool = SAPDB_TRUE;

#ifndef ODBC_PREPARED

    /*-------------------------------------------------------------------------*
     * Prepare the WHERE clause for the SQL statements.                        *
     *-------------------------------------------------------------------------*/
    StudioOAL_String whereClause(" WHERE PACKAGEGUID = x'");
    whereClause  += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause  += "' AND OWNER = '";
    whereClause  += owner;
    whereClause  += "' AND TABLENAME = '";
    whereClause  += tablename;
    whereClause  += "' AND TABLETYPE IN ('TABLE')";

    StudioOAL_String updatePages("UPDATE TRANSFORMATIONMODEL ");
    updatePages  += " SET DATASTREAMFORMAT = 'PAGES' ";
    updatePages  += whereClause;

    rcBool = m_pUpdate->openResult(updatePages);
    if (SAPDB_FALSE == rcBool)
    {
        TRACE_PRNF_MLS99(("failed ", "%s" , updatePages.StrPtr() ));
        RepServMessages::Instance()->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98, updatePages.StrPtr() );
    }
    return rcBool;

#endif // ODBC_PREPARED

#ifdef ODBC_PREPARED

    m_tableName = tablename;
    m_owner     = owner;

    StudioOAL_String parameters[2];

    parameters[0]   = owner;
    parameters[1]   = tablename;

    /*-------------------------------------------------------------------------*
     * Update the column definitions from the database.                          *
     *-------------------------------------------------------------------------*/
    m_pUpdatePages->reset();

    rcBool = m_pUpdatePages->setParamValues(parameters);
    if (SAPDB_TRUE == rcBool)
    {
        /*-------------------------------------------------------------------------*
         * Execute the prepared statement                                          *
         *-------------------------------------------------------------------------*/
        rcBool = m_pUpdatePages->execute());
    }

    if (SAPDB_FALSE == rcBool)
    {
        getMetaData()->getError()->setErrorText(m_pUpdatePages->getErrorText());
        getMetaData()->getError()->isError(m_pUpdatePages->isError());
        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, m_pUpdatePages->getErrorText().StrPtr());
    }
#endif // ODBC_PREPARED

    return rcBool;
}
/*===========================================================================*
 *    TransformationDef::updateRecords
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateRecords( StudioOAL_String owner, StudioOAL_String tablename )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateRecords()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();
    SAPDB_Bool       rcBool       = SAPDB_TRUE;

#ifndef ODBC_PREPARED

    /*-------------------------------------------------------------------------*
     * Prepare the WHERE clause for the SQL statements.                        *
     *-------------------------------------------------------------------------*/
    StudioOAL_String whereClause(" WHERE PACKAGEGUID = x'");
    whereClause   += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause   += "' AND OWNER = '";
    whereClause   += owner;
    whereClause   += "' AND TABLENAME = '";
    whereClause   += tablename ;
    whereClause   += "' AND TABLETYPE IN ('TABLE') ";

    StudioOAL_String updateRecords("UPDATE TRANSFORMATIONMODEL ");
    updateRecords += " SET DATASTREAMFORMAT = 'RECORDS' ";
    updateRecords += whereClause;

    rcBool = m_pUpdate->openResult(updateRecords);
    if (SAPDB_FALSE == rcBool)
    {
        TRACE_PRNF_MLS99(("failed ", "%s", updateRecords.StrPtr() ));
        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateRecords.StrPtr() );
    }
    return rcBool;

#endif // ODBC_PREPARED

#ifdef ODBC_PREPARED

    m_tableName = tablename ;
    m_owner     = owner     ;

    StudioOAL_String parameters[2];

    parameters[0]   = owner     ;
    parameters[1]   = tablename ;

    /*-------------------------------------------------------------------------*
     * Update the column definitions from the database.                          *
     *-------------------------------------------------------------------------*/
    m_pUpdateRecords->reset();

    if ( !m_pUpdateRecords->setParamValues( parameters ) )
    {
          getMetaData()->getError()->setErrorText(getErrorText() );
          getMetaData()->getError()->isError     (isError     () );
          return SAPDB_FALSE;
    }

    /*-------------------------------------------------------------------------*
     * Execute the prepared statement                                          *
     *-------------------------------------------------------------------------*/
     // SQLExecute
     if ( !m_pUpdateRecords->execute() )
     {
        MetaDataDef *pMetaData   = getMetaData();
        sapdb_Error *pError     = pMetaData->getError();

        StudioOAL_String errorText = m_pUpdateRecords->getErrorText();
        SAPDB_Bool       isError   = m_pUpdateRecords->isError     ();

        pError->setErrorText( errorText );
        pError->isError     ( isError   );

        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, errorText.StrPtr());

        return SAPDB_FALSE;
    }

#endif // ODBC_PREPARED

}
/*===========================================================================*
 *    TransformationDef::updateBegin
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateBegin( StudioOAL_String owner, StudioOAL_String tablename  )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateBegin ()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

#ifndef ODBC_PREPARED

    StudioOAL_String whereClause;
    StudioOAL_String updateBegin;

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    whereClause    = " WHERE PACKAGEGUID = x'";
    whereClause   += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause   += "' ";
    whereClause   += " AND  owner     =  ";
    whereClause   += "'";
    whereClause   += owner;
    whereClause   += "'";
    whereClause   += " AND  tablename =  ";
    whereClause   += "'";
    whereClause   += tablename;
    whereClause   += "'";

    updateBegin   = " UPDATE TRANSFORMATIONMODEL ";
    updateBegin  += " SET ";
    updateBegin  += " STARTTIME   = TIMESTAMP ";
    updateBegin  += whereClause;

    if ( !m_pUpdate->openResult (updateBegin) )
    {
            TRACE_PRNF_MLS99(("failed ", "%s", updateBegin.StrPtr() ));
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateBegin.StrPtr() );


            return SAPDB_FALSE;

    }
    return SAPDB_TRUE;


#endif // ODBC_PREPARED

#ifdef ODBC_PREPARED

    m_tableName = tablename ;
    m_owner     = owner     ;

    StudioOAL_String parameters[2];

    parameters[0]   = owner     ;
    parameters[1]   = tablename ;

    /*-------------------------------------------------------------------------*
     * Update the column definitions from the database.                          *
     *-------------------------------------------------------------------------*/
    m_pUpdateBegin->reset();

    if ( !m_pUpdateBegin->setParamValues( parameters ) )
    {
          getMetaData()->getError()->setErrorText(getErrorText() );
          getMetaData()->getError()->isError     (isError     () );
          return SAPDB_FALSE;
    }

    /*-------------------------------------------------------------------------*
     * Execute the prepared statement                                          *
     *-------------------------------------------------------------------------*/
     // SQLExecute
     if ( !m_pUpdateBegin->execute() )
     {
        MetaDataDef *pMetaData   = getMetaData();
        sapdb_Error    *pError     = pMetaData->getError();

        StudioOAL_String errorText = m_pUpdateBegin->getErrorText();
        SAPDB_Bool       isError   = m_pUpdateBegin->isError     ();

        pError->setErrorText( errorText );
        pError->isError     ( isError   );

        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, errorText.StrPtr());

        rc = SAPDB_FALSE;
    }
    return SAPDB_TRUE;

#endif // ODBC_PREPARED

}
/*===========================================================================*
 *    TransformationDef::updateDatStream
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateDatStream( StudioOAL_String * parameters )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateDatStream()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Bool rc = SAPDB_TRUE;

    StudioOAL_String whereClause;
    StudioOAL_String updateDatStream;

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    whereClause      = " WHERE PACKAGEGUID = x'";
    whereClause     += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause     += "' ";
    whereClause     += " AND    owner     =  ";
    whereClause     += "'";
    whereClause     += parameters[1];
    whereClause     += "'";
    whereClause     += " AND    tablename =  ";
    whereClause     += "'";
    whereClause     += parameters[2] ;
    whereClause     += "'";
    whereClause     += " AND TABLETYPE IN ('TABLE') ";

    updateDatStream = " UPDATE TRANSFORMATIONMODEL ";
    updateDatStream += " SET ";
    updateDatStream += " DATASTREAMNAME  = ";
    updateDatStream += parameters[0];
    updateDatStream += whereClause;

    if ( !m_pUpdate->openResult (updateDatStream) )
    {
            TRACE_PRNF_MLS99(("failed ", "%s", updateDatStream.StrPtr() ));
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateDatStream.StrPtr() );


            return SAPDB_FALSE;
    }
    return SAPDB_TRUE;

}
/*===========================================================================*
 *    TransformationDef::updateCatStream
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateCatStream( StudioOAL_String * parameters )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateCatStream()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Bool rc = SAPDB_TRUE;

    StudioOAL_String whereClause;
    StudioOAL_String updateCatStream;

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    whereClause    = " WHERE PACKAGEGUID = x'";
    whereClause   += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause   += "' ";
    whereClause   += " AND     owner     =  ";
    whereClause   += "'";
    whereClause   += parameters[1];
    whereClause   += "'";
    whereClause   += " AND    tablename =  ";
    whereClause   += "'";
    whereClause   += parameters[2] ;
    whereClause   += "'";

    updateCatStream = " UPDATE TRANSFORMATIONMODEL ";
    updateCatStream += " SET ";
    updateCatStream += " CATALOGSTREAMNAME  =  ";
    updateCatStream += parameters[3];
    updateCatStream += whereClause;

    if ( !m_pUpdate->openResult (updateCatStream) )
    {
            TRACE_PRNF_MLS99(("failed ", "%s", updateCatStream.StrPtr() ));
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateCatStream.StrPtr() );

            return SAPDB_FALSE;
    }

    return SAPDB_TRUE;
}
/*===========================================================================*
 *    TransformationDef::updateHeader
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateHeader( StudioOAL_String * parameters )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateHeader()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

#ifndef ODBC_PREPARED

    StudioOAL_String whereClause;
    StudioOAL_String updateHeader;

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    whereClause    = " WHERE PACKAGEGUID = x'";
    whereClause   += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause   += "' ";
    whereClause   += " AND    owner     =  ";
    whereClause   += "'";
    whereClause   += parameters[3];
    whereClause   += "'";
    whereClause   += " AND    tablename =  ";
    whereClause   += "'";
    whereClause   += parameters[4] ;
    whereClause   += "'";
    whereClause   += " AND TABLETYPE IN('TABLE') ";

    updateHeader   = " UPDATE TRANSFORMATIONMODEL ";
    updateHeader  += " SET ";
    updateHeader  += " ROWCOUNT     = ";
    updateHeader  += parameters[0];
    updateHeader  += ",";
    updateHeader  += " DATASTREAMHEADERBLOCK  = ";
    updateHeader  += parameters[1];
    updateHeader  += ",";
    updateHeader  += " DATASTREAMHEADERPOS    = ";
    updateHeader  += parameters[2];
    updateHeader  += whereClause;

    if ( !m_pUpdate->openResult (updateHeader) )
    {
            TRACE_PRNF_MLS99(("failed ", "%s", updateHeader.StrPtr() ));
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateHeader.StrPtr() );

            return SAPDB_FALSE;
    }
    return SAPDB_TRUE;

#endif // ODBC_PREPARED

#ifdef ODBC_PREPARED

    m_owner      = parameters[3] ;
    m_tableName  = parameters[4] ;

    /*-------------------------------------------------------------------------*
     * Update the column definitions from the database.                          *
     *-------------------------------------------------------------------------*/
    m_pUpdateHeader->reset();

    if ( !m_pUpdateHeader->setParamValues( parameters ) )
    {
          getMetaData()->getError()->setErrorText(getErrorText() );
          getMetaData()->getError()->isError     (isError     () );
          return SAPDB_FALSE;
    }

    /*-------------------------------------------------------------------------*
     * Execute the prepared statement                                          *
     *-------------------------------------------------------------------------*/
     // SQLExecute
     if ( !m_pUpdateHeader->execute() )
     {
        MetaDataDef *pMetaData   = getMetaData();
        sapdb_Error    *pError     = pMetaData->getError();

        StudioOAL_String errorText = m_pUpdateHeader->getErrorText();
        SAPDB_Bool       isError   = m_pUpdateHeader->isError     ();

        pError->setErrorText( errorText );
        pError->isError     ( isError   );

        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, errorText.StrPtr());

        return SAPDB_FALSE;
    }
    return SAPDB_TRUE;

#endif // ODBC_PREPARED

}
/*===========================================================================*
 *    TransformationDef::updateTrailer
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateTrailer( StudioOAL_String * parameters )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateHeader()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

#ifndef ODBC_PREPARED

    StudioOAL_String whereClause;
    StudioOAL_String updateTrailer;

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    whereClause    = " WHERE PACKAGEGUID = x'";
    whereClause   += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause   += "' ";
    whereClause   += " AND    owner     =  ";
    whereClause   += "'";
    whereClause   += parameters[3];
    whereClause   += "'";
    whereClause   += " AND    tablename =  ";
    whereClause   += "'";
    whereClause   += parameters[4] ;
    whereClause   += "'";
    whereClause   += " AND TABLETYPE IN('TABLE') ";

    updateTrailer  = " UPDATE TRANSFORMATIONMODEL ";
    updateTrailer += " SET ";
    updateTrailer += " DATASTREAMTRAILERBLOCK  = ";
    updateTrailer += parameters[1];
    updateTrailer += ",";
    updateTrailer += " DATASTREAMTRAILERPOS    = ";
    updateTrailer += parameters[2];
    updateTrailer += whereClause;

    if ( !m_pUpdate->openResult (updateTrailer) )
    {
        TRACE_PRNF_MLS99(("failed ", "%s", updateTrailer.StrPtr() ));
        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateTrailer.StrPtr() );

        return SAPDB_FALSE;
    }
    return SAPDB_TRUE;

#endif // ODBC_PREPARED
}
/*===========================================================================*
 *    TransformationDef::updateExtrData
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateExtrData( StudioOAL_String * parameters )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateExtrData()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

#ifndef ODBC_PREPARED

    StudioOAL_String whereClause;
    StudioOAL_String updateData;

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    whereClause   = " WHERE PACKAGEGUID = x'";
    whereClause  += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause  += "' ";
    whereClause  += " AND    owner     =  ";
    whereClause  += "'";
    whereClause  += parameters[3];
    whereClause  += "'";
    whereClause  += " AND    tablename =  ";
    whereClause  += "'";
    whereClause  += parameters[4] ;
    whereClause  += "'";
    whereClause  += " AND TABLETYPE IN('TABLE') ";

    updateData    = " UPDATE TRANSFORMATIONMODEL ";
    updateData   += " SET ";
    updateData   += " ROWCOUNT   = ";
    updateData   += parameters[0];
    updateData   += ",";
    updateData   += " DATASTREAMDATABLOCK  = ";
    updateData   += parameters[1];
    updateData   += ",";
    updateData   += " DATASTREAMDATAPOS    = ";
    updateData   += parameters[2];
    updateData   += whereClause;

    if ( !m_pUpdate->openResult (updateData) )
    {
        TRACE_PRNF_MLS99(("failed ", "%s", updateData.StrPtr() ));
        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateData.StrPtr() );

        return SAPDB_FALSE;
    }
    return  SAPDB_TRUE;

#endif // ODBC_PREPARED

#ifdef ODBC_PREPARED

    MetaDataDef *pMetaData = getMetaData();
    m_owner      = parameters[3] ;
    m_tableName  = parameters[4] ;

    /*-------------------------------------------------------------------------*
     * Update the column definitions from the database.                          *
     *-------------------------------------------------------------------------*/
    m_pUpdateData->reset();

    if ( !m_pUpdateData->setParamValues( parameters ) )
    {
        pMetaData->getError()->setErrorText(getErrorText() );
        pMetaData->getError()->isError(isError() );
        return SAPDB_FALSE;
    }

    /*-------------------------------------------------------------------------*
     * Execute the prepared statement                                          *
     *-------------------------------------------------------------------------*/
    // SQLExecute
    if ( !m_pUpdateData->execute() )
    {
        sapdb_Error    *pError     = pMetaData->getError();

        StudioOAL_String errorText = m_pUpdateData->getErrorText();
        SAPDB_Bool       isError   = m_pUpdateData->isError     ();

        pError->setErrorText( errorText );
        pError->isError     ( isError   );

        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, errorText.StrPtr());

        return SAPDB_FALSE;
    }
    return  SAPDB_TRUE;

#endif // ODBC_PREPARED

}

/*===========================================================================*
 *    TransformationDef::updateLoadData
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateLoadData( StudioOAL_String * parameters )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateExtrData()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

#ifndef ODBC_PREPARED

    StudioOAL_String whereClause;
    StudioOAL_String updateData;

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    whereClause   = " WHERE PACKAGEGUID = x'";
    whereClause  += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause  += "' ";
    whereClause  += " AND    owner     =  ";
    whereClause  += "'";
    whereClause  += parameters[3];
    whereClause  += "'";
    whereClause  += " AND    tablename =  ";
    whereClause  += "'";
    whereClause  += parameters[4] ;
    whereClause  += "'";

    updateData    = " UPDATE TRANSFORMATIONMODEL ";
    updateData   += " SET ";
    updateData   += " ROWCOUNT   = ";
    updateData   += parameters[0];
    updateData   += ",";
    updateData   += " DATASTREAMDATABLOCK  = ";
    updateData   += parameters[1];
    updateData   += ",";
    updateData   += " DATASTREAMDATAPOS    = ";
    updateData   += parameters[2];
    updateData   += whereClause;
    updateData   += " AND TABLETYPE IN ('TABLE') ";

    if ( !m_pUpdate->openResult (updateData) )
    {
        TRACE_PRNF_MLS99(("failed ", "%s", updateData.StrPtr() ));
        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98, updateData.StrPtr() );

        return SAPDB_FALSE;
    }
    return  SAPDB_TRUE;

#endif // ODBC_PREPARED
}

/*===========================================================================*
 *    TransformationDef::updateRestart
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateRestart( StudioOAL_String owner, StudioOAL_String tablename  )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateRestart ()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

#ifndef ODBC_PREPARED

    StudioOAL_String whereClause;
    StudioOAL_String updateRestart;

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    whereClause   = " WHERE PACKAGEGUID = x'";
    whereClause   += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause   += "' ";
    whereClause   += " AND    owner     =  ";
    whereClause   += "'";
    whereClause   += owner;
    whereClause   += "'";
    whereClause   += " AND    tablename =  ";
    whereClause   += "'";
    whereClause   += tablename ;
    whereClause   += "'";

    updateRestart  = " UPDATE TRANSFORMATIONMODEL ";
    updateRestart += " SET ";
    updateRestart += " RESTART  = FALSE ";
    updateRestart += whereClause;

    if ( !m_pUpdate->openResult (updateRestart) )
    {
            TRACE_PRNF_MLS99(("failed ", "%s", updateRestart.StrPtr() ));
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateRestart.StrPtr() );

            return SAPDB_FALSE;
    }
    return SAPDB_TRUE;

#endif // ODBC_PREPARED

#ifdef ODBC_PREPARED

    m_tableName = tablename ;
    m_owner     = owner     ;

    StudioOAL_String parameters[2];

    parameters[0]   = owner     ;
    parameters[1]   = tablename ;

    /*-------------------------------------------------------------------------*
     * Update the column definitions from the database.                        *
     *-------------------------------------------------------------------------*/
    m_pUpdateEnd->reset();

    if ( !m_pUpdateRestart->setParamValues( parameters ) )
    {
          getMetaData()->getError()->setErrorText(getErrorText() );
          getMetaData()->getError()->isError     (isError     () );
          return SAPDB_FALSE;
    }

    /*-------------------------------------------------------------------------*
     * Execute the prepared statement                                          *
     *-------------------------------------------------------------------------*/
     // SQLExecute
     if ( !m_pUpdateRestart->execute() )
     {
        MetaDataDef *pMetaData  = getMetaData();
        sapdb_Error    *pError    = pMetaData->getError();

        StudioOAL_String errorText = m_pUpdateRestart->getErrorText();
        SAPDB_Bool       isError   = m_pUpdateRestart->isError     ();

        pError->setErrorText( errorText );
        pError->isError     ( isError   );

        pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, errorText.StrPtr());

        return SAPDB_FALSE;
    }
    return SAPDB_TRUE;

#endif // ODBC_PREPARED

}
/*===========================================================================*
 *    TransformationDef::updateExclude
 *===========================================================================*/
SAPDB_Bool TransformationDef::updateExclude( StudioOAL_String owner, StudioOAL_String tablename  )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateExclude ()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

#ifndef ODBC_PREPARED

    StudioOAL_String whereClause;
    StudioOAL_String updateExclude;

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    whereClause   = " WHERE PACKAGEGUID = x'";
    whereClause   += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause   += "' ";
    whereClause   += " AND    owner     =  ";
    whereClause   += "'";
    whereClause   += owner;
    whereClause   += "'";
    whereClause   += " AND    tablename =  ";
    whereClause   += "'";
    whereClause   += tablename ;
    whereClause   += "'";

    updateExclude  = " UPDATE TRANSFORMATIONMODEL ";
    updateExclude += " SET ";
    updateExclude += " EXCLUDE = TRUE ";
    updateExclude += whereClause;

    if ( !m_pUpdate->openResult (updateExclude) )
    {
            TRACE_PRNF_MLS99(("failed ", "%s", updateExclude.StrPtr() ));
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateExclude.StrPtr() );

            return SAPDB_FALSE;
    }
    return SAPDB_TRUE;

#endif // ODBC_PREPARED
}
/*===========================================================================*
 *    TransformationDef::updateEnd
 *===========================================================================*/
SAPDB_Bool
TransformationDef::updateEnd( StudioOAL_String& owner, StudioOAL_String& tablename  )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updateEnd ()");

#ifndef ODBC_PREPARED

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    StudioOAL_String whereClause(" WHERE PACKAGEGUID = x'");
    whereClause   += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause   += "' ";
    whereClause   += " AND    owner     =  ";
    whereClause   += "'";
    whereClause   += owner;
    whereClause   += "'";
    whereClause   += " AND    tablename =  ";
    whereClause   += "'";
    whereClause   += tablename ;
    whereClause   += "'";

    StudioOAL_String updateEnd("UPDATE TRANSFORMATIONMODEL SET ENDTIME = TIMESTAMP ");
    updateEnd     += whereClause;

    if ( !m_pUpdate->openResult (updateEnd) )
    {
        TRACE_PRNF_MLS99(("failed ", "%s", updateEnd.StrPtr() ));
        RepServMessages::Instance()->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updateEnd.StrPtr() );
        return SAPDB_FALSE;
    }
    return SAPDB_TRUE;

#endif // ODBC_PREPARED

#ifdef ODBC_PREPARED

    m_tableName = tablename;
    m_owner     = owner;

    StudioOAL_String parameters[2];

    parameters[0] = owner;
    parameters[1] = tablename;

    /*-------------------------------------------------------------------------*
     * Update the column definitions from the database.                        *
     *-------------------------------------------------------------------------*/
    m_pUpdateEnd->reset();

    if ( !m_pUpdateEnd->setParamValues( parameters ) )
    {
        getMetaData()->getError()->setErrorText(getErrorText() );
        getMetaData()->getError()->isError     (isError     () );
        return SAPDB_FALSE;
    }

    /*-------------------------------------------------------------------------*
     * Execute the prepared statement                                          *
     *-------------------------------------------------------------------------*/
    // SQLExecute
    if ( !m_pUpdateEnd->execute() )
    {
        MetaDataDef *pMetaData  = getMetaData();
        sapdb_Error    *pError    = pMetaData->getError();

        StudioOAL_String errorText = m_pUpdateEnd->getErrorText();
        SAPDB_Bool       isError   = m_pUpdateEnd->isError     ();

        pError->setErrorText( errorText );
        pError->isError     ( isError   );

        RepServMessages::Instance()->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, errorText.StrPtr());

        return SAPDB_FALSE;
    }
    return SAPDB_TRUE;

#endif // ODBC_PREPARED
}

/*===========================================================================*
 *    TransformationDef::updatePerformance
 *===========================================================================*/
SAPDB_Bool TransformationDef::updatePerformance( StudioOAL_String owner, StudioOAL_String tablename  )
{
    ROUTINE_DBG_MEO00 ("TransformationDef::updatePerformance ()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

#ifndef ODBC_PREPARED
    StudioOAL_String whereClause;
    StudioOAL_String updatePerformance;

    StudioOAL_String  request;
    StudioOAL_String  receive;
    StudioOAL_String  io;
    StudioOAL_String  log;
    _TCHAR _request[256];
    _TCHAR _receive[256];
    _TCHAR _io [256];
    _TCHAR _log[256];

    extern tls00_Performance performance;

    sprintf(_request, "%f", performance.perRequest_ls00 );
    sprintf(_receive, "%f", performance.perReceive_ls00 );
    sprintf(_io     , "%f", performance.perIO_ls00 );
    sprintf(_log    , "%f", performance.perLog_ls00 );

    request.ConvertFromASCII_Latin1(_request, _request + _tcslen(_request));
    receive.ConvertFromASCII_Latin1(_receive, _receive + _tcslen(_receive));
    io     .ConvertFromASCII_Latin1(_io     , _io      + _tcslen(_io )    );
    log    .ConvertFromASCII_Latin1(_log    , _log     + _tcslen(_log)    );

   /*-------------------------------------------------------------------------*
    * Prepare the WHERE clause for the SQL statements.                        *
    *-------------------------------------------------------------------------*/
    whereClause   = " WHERE PACKAGEGUID = x'";
    whereClause   += getMetaData()->getConnection()->dbiPackageid_ls00;
    whereClause   += "' ";
    whereClause   += " AND    owner     =  ";
    whereClause   += "'";
    whereClause   += owner;
    whereClause   += "'";
    whereClause   += " AND    tablename =  ";
    whereClause   += "'";
    whereClause   += tablename ;
    whereClause   += "'";

    updatePerformance   = " UPDATE TRANSFORMATIONMODEL ";
    updatePerformance  += " SET ";
    updatePerformance  += " REQUESTTIME =  ";
    updatePerformance  += request;
    updatePerformance  += ", ";
    updatePerformance  += " RECEIVETIME =  ";
    updatePerformance  += receive;
    updatePerformance  += ", ";
    updatePerformance  += " IOTIME = ";
    updatePerformance  += io;
    updatePerformance  += ", ";
    updatePerformance  += " LOGTIME = ";
    updatePerformance  += log;
    updatePerformance  += whereClause;

    if ( !m_pUpdate->openResult (updatePerformance) )
    {
          TRACE_PRNF_MLS99(("failed ", "%s", updatePerformance.StrPtr() ));
          pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSimpleMsg_els98 , updatePerformance.StrPtr() );

          return SAPDB_FALSE;
    }
    return SAPDB_TRUE;

#endif // ODBC_PREPARED

}
/*===========================================================================*
 *    TransformationDef::CreateLoaderSystemObjects
 *===========================================================================*/
SAPDB_Bool
TransformationDef::CreateLoaderSystemObjects()
{
    ROUTINE_DBG_MEO00 ("TransformationDef::CreateLoaderSystemObjects");

    SAPDB_Bool rcBool   = SAPDB_TRUE;
    SAPDB_Bool rcExists = SAPDB_FALSE;

    MetaDataDef*      pMetaData       = getMetaData();
    tls00_DBInfo*     pOIConnection   = pMetaData->getConnection();
    tls00_PartSpec    PartSpec        = pMetaData->getPartSpec();
    //*
    //*     To do what has to be done we need to be SYSDBA
    //*
    StudioOAL_String  CurrentUserCmd("CURRENT USER SYSDBA");
    rcBool = executeSQL(CurrentUserCmd);

    // System table may only be created if installation flag is set
    SQLSetConnectAttr(pOIConnection->dbiOdbcConnection.HDBC(), SQL_PRODUCER, REINTERPRET_CAST(SQLPOINTER, sp1pr_installation), SQL_IS_POINTER);

    // TRANSFORMATIONMODEL
    if (SAPDB_TRUE == rcBool)
    {
        rcExists = existsTable(LOAD_MAP_TABLE_LS00);
        if (SAPDB_FALSE == rcExists)
        {
            rcBool = executeSQL(CREATE_MAP_TABLE_LS00);
            if (SAPDB_TRUE == rcBool)
                rcBool = executeSQL(GRANT_MAP_TABLE_LS00);
        }
        else
            rcBool = executeSQL(ALTER_MAP_TABLE_LS00);
    }
    // TRANSFORMATIONPACKAGES
    if (SAPDB_TRUE == rcBool)
    {
        rcExists = existsTable (VIEW_PACK_LS00);
        if (SAPDB_FALSE == rcExists)
        {
            rcBool = executeSQL(CREATE_VIEW_PACK_LS00);
            if (SAPDB_TRUE == rcBool)
                rcBool = executeSQL(GRANT_VIEW_PACK_LS00);
        }
    }
    // TRANSFORMATIONSTEPS
    if (SAPDB_TRUE == rcBool)
    {
        rcExists = existsTable (VIEW_TRANS_LS00);
        if (SAPDB_FALSE == rcExists)
        {
            rcBool = executeSQL(CREATE_VIEW_TRANS_LS00);
            if (SAPDB_TRUE == rcBool)
                rcBool = executeSQL(GRANT_VIEW_TRANS_LS00);
        }
    }
    // Create view TRANSFORMATIONRESOURCES
    if (SAPDB_TRUE == rcBool)
    {
        rcExists = existsTable (VIEW_RES_LS00);
        if (SAPDB_FALSE == rcExists)
        {
            rcBool = executeSQL(CREATE_VIEW_RES_LS00);
            if (SAPDB_TRUE == rcBool)
                rcBool = executeSQL(GRANT_VIEW_RES_LS00);
        }
    }
    // Create view TRANSFORMATIONSTATISTIC
    if (SAPDB_TRUE == rcBool)
    {
        rcExists = existsTable (VIEW_STAT_LS00);
        if (SAPDB_FALSE == rcExists)
        {
            rcBool = executeSQL(CREATE_VIEW_STAT_LS00);
            if (SAPDB_TRUE == rcBool)
                rcBool = executeSQL(GRANT_VIEW_STAT_LS00);
        }
    }
    // Create view TRANSFORMATIONMONITOR
    if (SAPDB_TRUE == rcBool)
    {
        rcExists = existsTable (VIEW_PERF_LS00);
        if (SAPDB_FALSE == rcExists)
        {
            rcBool = executeSQL(CREATE_VIEW_PERF_LS00);
            if (SAPDB_TRUE == rcBool)
                rcBool = executeSQL(GRANT_VIEW_PERF_LS00);
        }
    }
    // Create dbprocedure TRANSFORMATIONPACKAGE
    if (SAPDB_TRUE == rcBool)
    {
        rcExists = existsDBProc(DBPROC_MAP_TABLE_LS00);
        if (SAPDB_FALSE == rcExists)
        {
            StudioOAL_String  create;
            StudioOAL_String  dbaUser;
            _TCHAR            szCreate[2048];
            szCreate[0] = 0;

            dbaUser.ConvertFromASCII_Latin1(pOIConnection->dbiSYSDBA_Name_ls00.asCharp(),
                                            pOIConnection->dbiSYSDBA_Name_ls00.asCharp() +
                                            pOIConnection->dbiSYSDBA_Name_ls00.length() );

            sp77sprintf(szCreate, 2048, CREATE_DBPROC_MAP_TABLE_LS00, dbaUser.StrPtr(), dbaUser.StrPtr());
            create.ConvertFromASCII_Latin1(szCreate, szCreate + _tcslen(szCreate));

            rcBool = executeSQL(create);
            if (SAPDB_TRUE == rcBool)
                rcBool = executeSQL(GRANT_DBPROC_MAP_TABLE_LS00);
        }
    }
    if (SAPDB_TRUE == rcBool)
        rcBool = executeSQL("COMMIT WORK");

    SQLSetConnectAttr(pOIConnection->dbiOdbcConnection.HDBC(), SQL_PRODUCER, REINTERPRET_CAST(SQLPOINTER, sp1pr_internal_cmd), SQL_IS_POINTER);

    CurrentUserCmd = "CURRENT USER ";
    CurrentUserCmd += pMetaData->getCurrentUser();
    rcBool = executeSQL(CurrentUserCmd);

    if (SAPDB_FALSE == rcBool)
    {
        StudioOAL_String NativeErrorAsString = getNativeErrorAsString();
        RepServMessages::Instance()->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());
    }

    return rcBool;
}
/*===========================================================================*
 *    TransformationDef::LoadTransformationPackage
 *===========================================================================*/
SAPDB_Bool
TransformationDef::LoadTransformationPackage(StudioOAL_String& SaveCatalogStmt)
{
    ROUTINE_DBG_MEO00 ("TransformationDef::LoadTransformationPackage");

    SAPDB_Bool rcBool   = SAPDB_TRUE;
    SAPDB_Bool rcExists = SAPDB_FALSE;

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    MetaDataDef *     pMetaData     = getMetaData();
    tls00_DBInfo*     pOIConnection = pMetaData->getConnection();
    tls00_PartSpec    PartSpec      = pMetaData->getPartSpec();
    StudioOAL_String  transformationpackage;

    transformationpackage  = "LOAD TRANSFORMATIONPACKAGE ";
    transformationpackage += "x'";
    transformationpackage += getMetaData()->getConnection()->dbiPackageid_ls00;
    transformationpackage += "'";

    pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgCommandExecuting_els98,transformationpackage.StrPtr());

    //*
    //*     execute save catalog statement
    //*
    if (SAPDB_TRUE == rcBool)
    {
        rcBool = executeSQL(SaveCatalogStmt);
        if (SAPDB_TRUE == rcBool)
        {
            if (ptAll_els00 == PartSpec.psPartType_ls00)
                rcBool = executeSQL(DEL_CAT_TABLE_LS00);
        }
    }
    //*
    //*  load  transformationpackage
    //*
    if (SAPDB_TRUE == rcBool)
    {
        StudioOAL_String SqlStmt;
        _TCHAR           szSqlStmt[2048];
        szSqlStmt[0] = 0;

        if (PartSpec.psPartType_ls00 > ptTable_els00 )
            sp77sprintf(szSqlStmt, 2048, LOAD_MAP_TABLE_CAT_LS00, pOIConnection->dbiPackageid_ls00.StrPtr());
        else if ( PartSpec.psPartType_ls00 == ptTable_els00 )
            sp77sprintf(szSqlStmt, 2048, LOAD_MAP_TABLE_CAT_1_LS00, pOIConnection->dbiPackageid_ls00.StrPtr());

        SqlStmt.ConvertFromASCII_Latin1(szSqlStmt, szSqlStmt + _tcslen(szSqlStmt));

        rcBool = executeSQL(SqlStmt);
        if (SAPDB_TRUE == rcBool)
        {
            szSqlStmt[0] = 0;
            sp77sprintf(szSqlStmt, 2048, UPDATE_MAP_TABLE_LS00, pOIConnection->dbiPackageid_ls00.StrPtr());

            rcBool = executeSQL(szSqlStmt);
            if (SAPDB_TRUE == rcBool )
            {
                szSqlStmt[0] = 0;
                sp77sprintf(szSqlStmt, 2048, CALL_DBPROC_MAP_TABLE_LS00, pOIConnection->dbiPackageid_ls00.StrPtr());

                rcBool = executeSQL(szSqlStmt);
            }
        }
    }
    if (SAPDB_TRUE == rcBool)
    {
        rcExists = existsTable(SAVE_CAT_TABLE_LS00);
        if (SAPDB_TRUE == rcExists)
            rcBool = executeSQL(DROP_CAT_TABLE_LS00);
    }


    return rcBool;
}
/*===========================================================================*
 *    CatalogLoadDef::CatalogLoadDef
 *===========================================================================*/
CatalogLoadDef::CatalogLoadDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
               :MetaDataItem  ( odbcConnection , pMetaData )
{
    ROUTINE_DBG_MEO00 ("CatalogLoadDef::CatalogLoadDef()");
}
/*===========================================================================*
 *    CatalogLoadDef::CatalogLoadDef
 *===========================================================================*/
CatalogLoadDef::CatalogLoadDef( sapdbwa_DBC & odbcConnection )
               :MetaDataItem  ( odbcConnection )
{
    ROUTINE_DBG_MEO00 ("CatalogLoadDef::CatalogLoadDef()");
}
/*===========================================================================*
 *    CatalogLoadDef::CatalogLoadDef
 *===========================================================================*/
CatalogLoadDef::~CatalogLoadDef()
{
    ROUTINE_DBG_MEO00 ("CatalogLoadDef::~CatalogLoadDef()");
}
/*===========================================================================*
 *     CatalogLoadDef::initResultSet
 *===========================================================================*/
SAPDB_Bool CatalogLoadDef::initResultSet( sapdbwa_DBC & odbcConnection )
{
    ROUTINE_DBG_MEO00 ("CatalogLoadDef::initResult ()");

    SAPDB_Bool isOk = SAPDB_FALSE;

    if ( (emExtractAsDDL_els00 == getMetaData()->getExtrMode()) ||
         (emExtractAsDDL_els00 == getMetaData()->getExtrMode())  )
    {
        isOk = SAPDB_TRUE;
    }
    else
    {
        if ( odbcConnection.HDBC() && odbcConnection.HENV() )
        {
            isOk = SAPDB_TRUE;
        }
    }
    return isOk;
}
/*===========================================================================*
 *    CatalogLoadDef::setSQLMode
 *===========================================================================*/
void CatalogLoadDef::setSQLMode( StudioOAL_String  record )
{
    //typedef enum tpr00_SQLModeEnum {
    //            cpr_kind_empty         =   0,
    //            cpr_kind_internal      =   1,
    //            cpr_kind_db2           =   2,
    //            cpr_kind_ansi          =   3,
    //            cpr_kind_oracle        =   4,
    //            cpr_kind_sapr3         =   5
    //          } tpr00_SQLModeEnum;

    StudioOAL_String internal = "INTERNAL";
    StudioOAL_String db2      = "DB2";
    StudioOAL_String ansi     = "ANSI";
    StudioOAL_String oracle   = "ORACLE";
    StudioOAL_String sapr3    = "SAPR3";

    if ( internal.Compare(record.SubStr(0,8) ) == 0 )
    {
         setSqlMode( cpr_kind_internal );
         m_sqlmode = internal;
    }
    if ( db2     .Compare(record.SubStr(0,3) ) == 0 )
    {
         setSqlMode( cpr_kind_db2 );
         m_sqlmode = db2;
    }
    if ( ansi    .Compare(record.SubStr(0,4) ) == 0 )
    {
         setSqlMode( cpr_kind_ansi );
         m_sqlmode = ansi ;
    }
    if ( oracle  .Compare(record.SubStr(0,6) ) == 0 )
    {
         setSqlMode( cpr_kind_oracle );
         m_sqlmode = oracle;
    }
    if ( sapr3   .Compare(record.SubStr(0,5) ) == 0 )
    {
         setSqlMode( cpr_kind_sapr3 );
         m_sqlmode = sapr3;
    }

}
/*===========================================================================*
 *    CatalogLoadDef::getSQLMode
 *===========================================================================*/
StudioOAL_String CatalogLoadDef::getSQLMode ( )
{
    return m_sqlmode;
}
/*===========================================================================*
 *    CatalogLoadDef::readResult
 *===========================================================================*/
SAPDB_Bool CatalogLoadDef::readResult ( StudioOAL_String *record  )
{
    ROUTINE_DBG_MEO00 ("CatalogLoadDef::readResult ()");

    return MetaDataItem::readResult( record);
}
/*===========================================================================*
 *    CatalogLoadDef::writeResult
 *===========================================================================*/
SAPDB_Bool CatalogLoadDef::writeResult( StudioOAL_String record  )
{
    ROUTINE_DBG_MEO00 ("CatalogLoadDef::writeResult ()");

    return MetaDataItem::writeLine ( record);
}
/*===========================================================================*
 *    UserDef::UserDef
 *===========================================================================*/
UserDef::UserDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
            :MetaDataItem ( odbcConnection , pMetaData )
{
    ROUTINE_DBG_MEO00 ("UserDef::UserDef()");
}
/*===========================================================================*
 *    UserDef::UserDef
 *===========================================================================*/
UserDef::UserDef( sapdbwa_DBC & odbcConnection )
            :MetaDataItem ( odbcConnection )
{
}
/*===========================================================================*
 *    UserDef::~UserDef
 *===========================================================================*/
UserDef::~UserDef()
{
   ROUTINE_DBG_MEO00 ("UserDef::~UserDef()");
}
/*===========================================================================*
 *     UserDef::initResultSet
 *===========================================================================*/
SAPDB_Bool UserDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    if ( odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        // DOMAIN.USERS  : OWNER,GROUPNAME,USERNAME,USERMODE,CONNECTMODE,MAXTIMEOUT,COSTWARNING,COSTLIMIT,CREATEDATE,CREATETIME,ALTERDATE,ALTERTIME,PWCREADATE,PWCREATIME,SERVERDB,SERVERNODE,USER_ID,COMMENT

        StudioOAL_String  userDef;
        StudioOAL_String  whereClause;
        StudioOAL_String  orderClause;

        userDef = "SELECT OWNER, GROUPNAME, USERNAME, USERMODE, MAXTIMEOUT, COSTWARNING, COSTLIMIT, CONNECTMODE, COMMENT "
                  "FROM DOMAIN.USERS ";

        /*-------------------------------------------------------------------------*
         * Prepare the WHERE clause for the SQL statements.                        *
         *-------------------------------------------------------------------------*/

        if  (ptAll_els00 == getMetaData()->getPartSpec().psPartType_ls00)
        {
            // catalog extract all
            whereClause  = " WHERE USERMODE <> 'SYSDBA'"
                           " AND   USERMODE <> 'COLDUSER'"
                           " AND   USERMODE <> 'ADMIN'"
                           " AND   USERNAME <> 'DOMAIN'"
                           " AND   USERNAME <> 'SYS'";

            orderClause  = " ORDER BY OWNER, GROUPNAME, USERNAME ASC ";
       }
       else if (ptUser_els00 == getMetaData()->getPartSpec().psPartType_ls00)
       {
           // catalog extract user
            whereClause  = "WHERE OWNER = ? ";

            orderClause  = " ORDER BY GROUPNAME, USERNAME ASC ";
       }

       userDef += whereClause;
       userDef += orderClause;

       //m_owner;
       //m_groupName;
       //m_userName;
       //m_userMode;
       //m_maxTimeOut;
       //m_costWarning;
       //m_costLimit;
       //m_connectMode;
       //m_comment;

       isOk = SAPDB_TRUE;
    }
    return isOk;
}
/*===========================================================================*
 *    UserDef::readResult
 *===========================================================================*/
SAPDB_Bool UserDef::readResult (StudioOAL_String *record)
{
    ROUTINE_DBG_MEO00 ("UserDef::readResult()");

    SAPDB_Bool isOk = SAPDB_FALSE;

    isOk = MetaDataItem::readResult( record);

    // do this if using prepared statements

    m_owner       = record[0];
    m_groupName   = record[1];
    m_userName    = record[2];
    m_userMode    = record[3];
    m_maxTimeOut  = record[4];
    m_costWarning = record[5];
    m_costLimit   = record[6];
    m_connectMode = record[7];
    m_comment     = record[8];

    return isOk;;
}
/*===========================================================================*
 *    UserDef::writeResult
 *===========================================================================*/
SAPDB_Bool UserDef::writeResult( StudioOAL_String *record ,tls00_ExtrMode catextrMode )
{
    ROUTINE_DBG_MEO00 ("UserDef::writeResult ()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    StudioOAL_String user;
    StudioOAL_String comment = SEPARATOR;

    //select       =  "SELECT OWNER, GROUPNAME, USERNAME, USERMODE, MAXTIMEOUT, COSTWARNING, COSTLIMIT, CONNECTMODE, COMMENT ";
    //select      +=  "FROM DOMAIN.USERS ";

    // USERGROUP <=> if ( !record[1].Empty() &&  record[2].Empty() )
    // GROUPUSER <=> if ( !record[1].Empty() && !record[2].Empty() )
    // USER      <=> if (  record[1].Empty() && !record[2].Empty() )

    if ( catextrMode == emExtractAsDDL_els00 )
    {

        // <create_usergroup_statement> ::=
        // CREATE USERGROUP <usergroup_name>
        // [<usergroup_mode>]
        // [TIMEOUT   <unsigned_integer>] [COSTWARNING <unsigned_integer>]
        // [COSTLIMIT <unsigned_integer>] [[NOT] EXCLUSIVE]
        // [<usergroup_mode>] ::= RESOURCE | STANDARD

        //<create_user_statement> ::=
        // CREATE USER <user_name> PASSWORD <password> USERGROUP <usergroup_name>

        //<create_user_statement> ::=
        // CREATE USER <user_name> PASSWORD <password>
        //[<user_mode>]
        //[TIMEOUT <unsigned_integer>] [COSTWARNING <unsigned_integer>]
        //[COSTLIMIT <unsigned_integer>] [[NOT] EXCLUSIVE]
        // <user_mode> :: = DBA | RESOURCE | STANDARD

        // GROUPUSER
        if ( !record[1].Empty() && !record[2].Empty() )
        {
             user  = SEPARATOR;

             if ( getMetaData()->getSqlMode() != cpr_kind_internal )
             {
                  user += pszSQLModeString_ls31[cpr_kind_internal];
                  user += SEPARATOR;
             }

             user += "CREATE USER ";
             // <user_name>
             user  += record[2];

             // <password>
             user  += " PASSWORD ";
             user  += "initial"   ;

             user  += " USERGROUP ";
             user  += record[1];

             writeLine( user );

             // COMMENT ON USER <user_name> IS <comment>
             if ( !record[8].Empty() &&  !getColumn(9)->getColIsNull() )
             {
                  comment += "COMMENT ON USER ";
                  comment += record[2];
                  comment += " IS ";
                  comment += string2SQL(record[8]);

                  writeLine( comment );
             }
             // <grant_user_statement> ::= GRANT USER  <granted_users> [FROM <user_name>] TO <user_name>
        }
        else
        {
            user  = SEPARATOR;

            if ( getMetaData()->getSqlMode()  != cpr_kind_internal )
            {
                  user += pszSQLModeString_ls31[cpr_kind_internal];
                  user += SEPARATOR;
            }
            // USERGROUP
            if ( !record[1].Empty() &&  record[2].Empty() )
            {
                 user += "CREATE USERGROUP ";
                 // <usergroup_name>
                 user += record[1];
            }
            // USER
            if (  record[1].Empty() && !record[2].Empty() )
            {
                 user += "CREATE USER ";
                 // <user_name>
                 user  += record[2];

                 // <password>
                 user  += " PASSWORD ";
                 user  += "initial" ;
            }

            // [<usergroup_mode>] ::= RESOURCE | STANDARD
            // [<user_mode>     ]:: = DBA | RESOURCE | STANDARD

            if ( record[3].Empty() || getColumn(4)->getColIsNull() )
                 user += "" ;
            else
            {
                 user += "  ";
                 user += record[3];
            }
            // [TIMEOUT]
            if (record[4].Empty() || getColumn(5)->getColIsNull() )
                user += "" ;
            else
            {
                user += " TIMEOUT   ";
                user += record[4];
            }
            // [COSTWARNING]
            if ( record[5].Empty() || getColumn(6)->getColIsNull() )
                 user += "" ;
            else
            {
                 user += " COSTWARNING ";
                 user += record[5];
            }
            // [COSTLIMIT]
            if ( record[6].Empty() || getColumn(7)->getColIsNull() )
                 user += "" ;
            else
            {
                 user += " COSTLIMIT ";
                 user += record[6];
            }
            // [[NOT] EXCLUSIVE]
            if ( record[7].Empty() || getColumn(8)->getColIsNull() )
                 user += "" ;
            else
            {
                if ( record[7].Compare("SINGLE") == 0 )
                     user += " EXCLUSIVE " ;
                else
                     user += " NOT EXCLUSIVE ";
            }

            writeLine(user);

            // USERGROUP
            if ( !record[1].Empty() &&  record[2].Empty() )
            {
                 // COMMENT ON USERGROUP <usergroup_name> IS <comment>
                 if ( !record[8].Empty() &&  !getColumn(9)->getColIsNull() )
                 {
                      comment += "COMMENT ON USERGROUP ";
                      comment += record[1];
                      comment += string2SQL(record[8]);
                      comment += " IS ";
                      writeLine(comment  );
                 }

            }
            // USER
            if (  record[1].Empty() && !record[2].Empty() && !getColumn(9)->getColIsNull() )
            {
                  // COMMENT ON USER <user_name> IS <comment>
                  comment += "COMMENT ON USER ";
                  comment += record[2];
                  comment += " IS ";
                  comment += string2SQL(record[8]);
                  writeLine(comment  );
            }
        }

        // <grant_usergroup_statement> ::= GRANT USERGROUP <granted_usergroups> [FROM <user_name>] TO <user_name>
        // <grant_user_statement>      ::= GRANT USER      <granted_users>      [FROM <user_name>] TO <user_name>
    }
    if ( catextrMode == emExtractAsXML_els00 )
    {
        StudioOAL_String schema;
        StudioOAL_String label;
        StudioOAL_String name;

        // USERGROUP
        if ( !record[1].Empty() &&  record[2].Empty() )
        {
            label = "USERGROUP";
            name  = record[1];
        }
        // GROUPUSER
        if ( !record[1].Empty() && !record[2].Empty() )
        {
            label = "GROUPUSER";
            name  = record[1];
        }
        // USER
        if (  record[1].Empty() && !record[2].Empty() )
        {
            label = "USER";
            name  = record[2];
        }

        // Uml:NamespaceOwnedElement
        schema  = "<uml:NamespaceOwnedElement>\n";

        // sapdbm:Schema
        schema += "<sapdbm:DeployedSchema oim:id=\"_";
        !getColumn(1)->getColIsNull() ? schema += record[0] : schema += "";
        schema += ".";
        if ( !record[1].Empty() )
        {
              schema += record[1];
              schema += ".";
        }
        schema += record[2];
        schema += "\" oim:supertype=\"dbm:DeployedSchema\"";
        schema += " oim:label=\"";
        schema += label;
        schema += "\" oim:name=\"";
        schema += name;
        schema += "\" sapdbm:Owner=\"";
        !getColumn(1)->getColIsNull() ? schema += record[0] : schema += "";
        schema += "\" sapdbm:Groupname=\"";
        !getColumn(2)->getColIsNull() ? schema += record[1] : schema += "";
        schema += "\" sapdbm:Username=\"";
        !getColumn(3)->getColIsNull() ? schema += record[2] : schema += "";
        schema += "\" sapdbm:Usermode=\"";
        !getColumn(4)->getColIsNull() ? schema += record[3] : schema += "";
        schema += "\" sapdbm:MaxTimeOut=\"";
        !getColumn(5)->getColIsNull() ? schema += record[4] : schema += "";
        schema += "\" sapdbm:Costwarning=\"";
        !getColumn(6)->getColIsNull() ? schema += record[5] : schema += "";
        schema += "\" sapdbm:Costlimit=\"";
        !getColumn(7)->getColIsNull() ? schema += record[6] : schema += "";
        schema += "\" sapdbm:Connectmode=\"";
        !getColumn(8)->getColIsNull() ? schema += record[7] : schema += "";
        schema += "\" sapdbm:Comment=\"";
        !getColumn(9)->getColIsNull() ? schema += record[8] : schema += "";
        schema += "\">\n";

        schema += "<uml:NamespaceOwnedElement>\n";

        writeLine( schema );
    }

    return SAPDB_TRUE;

}
/*===========================================================================*
 *    ConnectionDef::ConnectionDef
 *===========================================================================*/
ConnectionDef::ConnectionDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
              :MetaDataItem ( odbcConnection , pMetaData )
{
    ROUTINE_DBG_MEO00 ("ConnectionDef::ConnectionDef()");
}
/*===========================================================================*
 *    ConnectionDef
 *===========================================================================*/
ConnectionDef::ConnectionDef( sapdbwa_DBC & odbcConnection )
              :MetaDataItem ( odbcConnection )
{
    ROUTINE_DBG_MEO00 ("ConnectionDef::ConnectionDef()");
}
/*===========================================================================*
 *    ConnectionDef::ConnectionDef
 *===========================================================================*/
ConnectionDef::~ConnectionDef()
{
    ROUTINE_DBG_MEO00 ("ConnectionDef::~ConnectionDef()");
}
/*===========================================================================*
 *     ConnectionDef::initResultSet
 *===========================================================================*/
SAPDB_Bool ConnectionDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    ROUTINE_DBG_MEO00 ("ConnectionDef::initResult ()");

    SAPDB_Bool rcBool = SAPDB_FALSE;

    return rcBool;
}
/*===========================================================================*
 *    ConnectionDef::readResult
 *===========================================================================*/
SAPDB_Bool ConnectionDef::readResult ( StudioOAL_String *record  )
{
    ROUTINE_DBG_MEO00 ("ConnectionDef::readResult ()");

    return MetaDataItem::readResult( record);
}
/*===========================================================================*
 *    CURUserDef::CURUserDef
 *===========================================================================*/
CURUserDef::CURUserDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
           :MetaDataItem ( odbcConnection , pMetaData )
{
    ROUTINE_DBG_MEO00 ("CURUserDef::CURUserDef()");
}
/*===========================================================================*
 *    CURUserDef::CURUserDef
 *===========================================================================*/
CURUserDef::CURUserDef( sapdbwa_DBC & odbcConnection )
           :MetaDataItem ( odbcConnection )
{
    ROUTINE_DBG_MEO00 ("CURUserDef::CURUserDef()");
}
/*===========================================================================*
 *    CURUserDef::CURUserDef
 *===========================================================================*/
CURUserDef::~CURUserDef()
{
    ROUTINE_DBG_MEO00 ("CURUserDef::~CURUserDef()");
}
/*===========================================================================*
 *     CURUserDef::initResultSet
 *===========================================================================*/
SAPDB_Bool CURUserDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    ROUTINE_DBG_MEO00 ("CURUserDef::initResult ()");

    SAPDB_Bool isOk = SAPDB_FALSE;

    if (  odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        isOk = SAPDB_TRUE;
    }
    return isOk;
}
/*===========================================================================*
 *    CURUserDef::writeResult
 *===========================================================================*/
SAPDB_Bool CURUserDef::writeResult( StudioOAL_String record  )
{
    ROUTINE_DBG_MEO00 ("CURUserDef::writeResult ()");

    return MetaDataItem::writeLine ( record);
}
/*===========================================================================*
 *    RoleDef::RoleDef
 *===========================================================================*/
RoleDef::RoleDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
            :MetaDataItem ( odbcConnection , pMetaData )
{
    ROUTINE_DBG_MEO00 ("RoleDef::RoleDef()");
}
/*===========================================================================*
 *    RoleDef ::RoleDef
 *===========================================================================*/
RoleDef::RoleDef( sapdbwa_DBC & odbcConnection )
        :MetaDataItem ( odbcConnection )
{
    ROUTINE_DBG_MEO00 ("RoleDef::RoleDef()");
}
/*===========================================================================*
 *    RoleDef::RoleDef
 *===========================================================================*/
RoleDef::~RoleDef()
{
    ROUTINE_DBG_MEO00 ("RoleDef::~RoleDef()");
}
/*===========================================================================*
 *     RoleDef::initResultSet
 *===========================================================================*/
SAPDB_Bool RoleDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    if (  odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        // <grantee> ::= PUBLIC | <user_name> | <usergroup_name> | <role_name>

        // ROLES : OWNER, ROLE, PASSWORD_REQUIRED, GRANTED, CREATEDATE, CREATEDATE

/*      StudioOAL_String  roleDef("SELECT ROLE,PASSWORD_REQUIRED FROM DOMAIN.ROLES ");
        StudioOAL_String  whereClause;

        if  (ptUser_els00 == getMetaData()->getPartSpec().psPartType_ls00)
        {
            whereClause  = "WHERE OWNER = ? ";
        }
        roleDef  += whereClause;
*/
        isOk = SAPDB_TRUE;
    }
    return isOk;
}
/*===========================================================================*
 *    RoleDef::readResult
 *===========================================================================*/
SAPDB_Bool RoleDef::readResult (StudioOAL_String *record)
{
    return MetaDataItem::readResult( record);
}
/*===========================================================================*
 *    RoleDef::writeResult
 *===========================================================================*/
SAPDB_Bool RoleDef::writeResult( StudioOAL_String *record )
{
    ROUTINE_DBG_MEO00 ("RoleDef::writeResult ()");

    if ( getMetaData()->getExtrMode() == emExtractAsDDL_els00 )
    {
        // <create_role_statement> ::= CREATE ROLE <role_name> [IDENTIFIED BY <password>]

        StudioOAL_String role;
        StudioOAL_String comment;

        role  = SEPARATOR;
        role +="CREATE ROLE ";

        // <role_name>
        role += record[0];

        // [IDENTIFIED BY <password>]
        if ( record[1].Empty() || getColumn(2)->getColIsNull() )
             role += "" ;
        else
        {
             role += " IDENTIFIED BY ";

             // <password>
             role += "initial" ;
        }

        return writeLine(role);
    }

    return SAPDB_TRUE;
}
/*===========================================================================*
 *    SequenceDef::SequenceDef
 *===========================================================================*/
SequenceDef::SequenceDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
            :MetaDataItem ( odbcConnection , pMetaData )
{
    ROUTINE_DBG_MEO00 ("SequenceDef::SequenceDef()");

    m_pSequenceValueDef  = new SequenceValueDef( odbcConnection, pMetaData );
    m_pSequenceValueDef->initResultSet(odbcConnection);
}
/*===========================================================================*
 *    SequenceDef::SequenceDef
 *===========================================================================*/
SequenceDef::SequenceDef(  sapdbwa_DBC & odbcConnection )
            :MetaDataItem ( odbcConnection )
{
    ROUTINE_DBG_MEO00 ("SequenceDef::SequenceDef()");

}
/*===========================================================================*
 *    SequenceDef::~SequenceDef
 *===========================================================================*/
SequenceDef::~SequenceDef()
{
    ROUTINE_DBG_MEO00 ("SequenceDef::~SequenceDef()");

    if ( m_pSequenceValueDef != NULL )
    {
         delete m_pSequenceValueDef;
         m_pSequenceValueDef = NULL;
    }
}
/*===========================================================================*
 *     SequenceDef::initResultSet
 *===========================================================================*/
SAPDB_Bool SequenceDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    ROUTINE_DBG_MEO00 ("SequenceDef::initResult ()");

    SAPDB_Bool isOk = SAPDB_FALSE;

    if (  odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        // CREATE SEQUENCE
        // SEQUENCES  : OWNER,SEQUENCE_NAME,INCREMENT_BY,LAST_NUMBER,MAX_VALUE,MIN_VALUE,
        //              CYCLE_FLAG,CACHE_SIZE,ORDER_FLAG,CREATEDATE,CREATETIME,COMMENT

/*      StudioOAL_String  sequenceDef;
        StudioOAL_String  whereClause;

        // START_WITH = LAST_NUMBER+1
        sequenceDef  = "SELECT OWNER, SEQUENCE_NAME, INCREMENT_BY, LAST_NUMBER+1, MAX_VALUE, "
                       "MIN_VALUE, CYCLE_FLAG, CACHE_SIZE, ORDER_FLAG "
                       " FROM DOMAIN.SEQUENCES ";

        *-------------------------------------------------------------------------*
        * Prepare the WHERE clause for the SQL statements.                        *
        *-------------------------------------------------------------------------*
        whereClause  = "WHERE  OWNER = ? ";
        sequenceDef += whereClause;
*/
        isOk = SAPDB_TRUE;
    }

    return isOk;
}
/*===========================================================================*
 *    SequenceDef::readResult
 *===========================================================================*/
SAPDB_Bool SequenceDef::readResult ( StudioOAL_String *record  )
{
    ROUTINE_DBG_MEO00 ("SequenceDef::readResult ()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Int4 rc        = errOK_els00;
    SAPDB_Int4 rcCompare = 0;
    SAPDB_Bool rcBool = SAPDB_FALSE;

    StudioOAL_String  NativeErrorAsString;
    StudioOAL_String  nextvalue,maxvalue,minvalue;

    // CREATE SEQUENCE
    // SEQUENCES: OWNER, SEQUENCE_NAME, INCREMENT_BY, LAST_NUMBER, MAX_VALUE, MIN_VALUE,
    //            CYCLE_FLAG, CACHE_SIZE, ORDER_FLAG, CREATEDATE, CREATETIME, COMMENT

    if ( MetaDataItem::readResult( record) )
    {
        rcBool = SAPDB_TRUE;

        if ( record[0].Compare("?") == 0)
             record[0] = "";
        if ( record[1].Compare("?") == 0)
             record[1] = "";
        if ( record[2].Compare("?") == 0)
             record[2] = "";
        if ( record[3].Compare("?") == 0)
             record[3] = "";
        if ( record[4].Compare("?") == 0)
             record[4] = "";
        if ( record[5].Compare("?") == 0)
             record[5] = "";
        if ( record[6].Compare("?") == 0)
             record[6] = "";

        m_owner         = record[0];
        m_sequencename  = record[1];
        m_incrementby   = record[2];
        m_lastnumber    = record[3];
        m_maxvalue      = record[4];
          maxvalue      = record[4];
        m_minvalue      = record[5];
          minvalue      = record[5];
        m_cycleflag     = record[6];
        m_cachesize     = record[7];
        m_orderflag     = record[8];

        StudioOAL_String  select;
        StudioOAL_String  whereClause;
        StudioOAL_String  record_nextvalue[1];

        select  = " SELECT ";
        select += m_owner;
        select += ".";
        select += m_sequencename;
        select += ".NEXTVAL FROM DUAL";

        if ( ! m_pSequenceValueDef->executeSQL( select )  )
        {
            NativeErrorAsString = m_pSequenceValueDef->getNativeErrorAsString();
            pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());
        }

        while ( m_pSequenceValueDef->readResult( record_nextvalue ) )
        {
             StudioOAL_String   patterns((SAPDB_UTF8*)"-");

             m_nextvalue =  record_nextvalue[0];
               nextvalue =  record_nextvalue[0];

             SAPDB_UInt  start = 0,end_incrementby = 0, end_nextvalue =0, end_minvalue = 0, end_maxvalue = 0 ;

             // ascending sequence
             if ( (end_incrementby = m_incrementby.Find ("-", start) ) == StudioOAL_String::NPos && m_cycleflag.Compare("N") == 0 )
             {
                 // lastnumber negativ and maxvalue positiv or null
                 if ( (end_nextvalue  = m_nextvalue.FindFirstOf (patterns, start) ) != StudioOAL_String::NPos &&
                      (end_maxvalue   = m_maxvalue .FindFirstOf (patterns, start) ) == StudioOAL_String::NPos    )
                 {
                     ;
                 }
                 // lastnumber positiv or null and maxvalue negativ
                 if ( (end_nextvalue  = m_nextvalue.FindFirstOf (patterns, start) ) == StudioOAL_String::NPos &&
                      (end_maxvalue   = m_maxvalue .FindFirstOf (patterns, start) ) != StudioOAL_String::NPos    )
                 {
                     pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSequenceRangeExhausted_els98, m_sequencename.StrPtr());
                 }
                 // lastnumber and maxvalue positiv or null
                 if ( (end_nextvalue  = m_nextvalue.FindFirstOf (patterns, start) ) == StudioOAL_String::NPos &&
                      (end_maxvalue   = m_maxvalue .FindFirstOf (patterns, start) ) == StudioOAL_String::NPos    )
                 {
                     if ( m_nextvalue.Length() >  m_maxvalue.Length() )
                          rcCompare =  1;
                     if ( m_nextvalue.Length() <  m_maxvalue.Length() )
                          rcCompare = -1;
                     if ( m_nextvalue.Length() == m_maxvalue.Length() )
                          rcCompare = m_nextvalue.Compare(m_maxvalue);
                     if ( rcCompare >= 0 )
                          pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSequenceRangeExhausted_els98, m_sequencename.StrPtr());
                 }
                 // lastnumber and maxvalue negativ
                 if ( (end_nextvalue = m_nextvalue.FindFirstOf (patterns, start) ) != StudioOAL_String::NPos &&
                      (end_maxvalue  = m_maxvalue .FindFirstOf (patterns, start) ) != StudioOAL_String::NPos    )
                 {
                     nextvalue.Replace(end_nextvalue,1,"");
                     maxvalue .Replace(end_maxvalue ,1,"");

                     nextvalue = maxvalue;
                     maxvalue  = nextvalue;

                     if ( nextvalue.Length() >  maxvalue.Length() )
                          rcCompare = +1;
                     if ( nextvalue.Length() <  maxvalue.Length() )
                          rcCompare = -1;
                     if ( nextvalue.Length() == maxvalue.Length() )
                          rcCompare = nextvalue.Compare(maxvalue);
                     if ( rcCompare >= 0 )
                          pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSequenceRangeExhausted_els98, m_sequencename.StrPtr());
                 }
             }

             start = 0,end_incrementby = 0, end_nextvalue =0, end_minvalue = 0, end_maxvalue = 0 ;

             // descending sequence
             if ( (end_incrementby = m_incrementby.Find ("-", start) ) != StudioOAL_String::NPos  && m_cycleflag.Compare("N") == 0 )
             {
                 // lastnumber negativ and minvalue positiv or null
                 if ( (end_nextvalue  = m_nextvalue.FindFirstOf (patterns, start) ) != StudioOAL_String::NPos &&
                      (end_minvalue   = m_minvalue .FindFirstOf (patterns, start) ) == StudioOAL_String::NPos    )
                 {
                     pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSequenceRangeExhausted_els98, m_sequencename.StrPtr());
                 }
                 // lastnumber positiv or null and minvalue negativ
                 if ( (end_nextvalue  = m_nextvalue.FindFirstOf (patterns, start) ) == StudioOAL_String::NPos &&
                      (end_minvalue   = m_minvalue .FindFirstOf (patterns, start) ) != StudioOAL_String::NPos    )
                 {
                     ;
                 }
                 // lastnumber and minvalue positiv or null
                 if ( (end_nextvalue  = m_nextvalue.FindFirstOf (patterns, start) ) == StudioOAL_String::NPos &&
                      (end_minvalue   = m_minvalue .FindFirstOf (patterns, start) ) == StudioOAL_String::NPos    )
                 {
                     if ( m_nextvalue.Length() >  m_minvalue.Length() )
                          rcCompare = -1;
                     if ( m_nextvalue.Length() <  m_minvalue.Length() )
                          rcCompare = +1;
                     if ( m_nextvalue.Length() == m_minvalue.Length() )
                          rcCompare = m_nextvalue.Compare(m_minvalue);
                     if ( rcCompare <= 0 )
                          pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSequenceRangeExhausted_els98, m_sequencename.StrPtr());
                 }
                 // lastnumber and maxvalue negativ
                 if ( (end_nextvalue  = m_nextvalue.FindFirstOf (patterns, start) ) != StudioOAL_String::NPos &&
                      (end_minvalue   = m_minvalue .FindFirstOf (patterns, start) ) != StudioOAL_String::NPos    )
                 {
                     nextvalue.Replace(end_nextvalue ,1,"");
                     minvalue .Replace(end_minvalue  ,1,"");

                     nextvalue = minvalue;
                     minvalue  = nextvalue;

                     if ( nextvalue.Length() >  minvalue.Length() )
                          rcCompare = -1;
                     if ( nextvalue.Length() <  minvalue.Length() )
                          rcCompare = +1;
                     if ( nextvalue.Length() == minvalue.Length() )
                          rcCompare = nextvalue.Compare(minvalue);
                     if ( rcCompare <= 0  )
                          pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgSequenceRangeExhausted_els98, m_sequencename.StrPtr());
                 }
             }
        }//while ( m_pSequenceValueDef->readResult( record_lastnumber ) )
    }
    return rcBool;
}
/*===========================================================================*
 *    SequenceDef::writeResult
 *===========================================================================*/
SAPDB_Bool SequenceDef::writeResult( StudioOAL_String *record  )
{
    ROUTINE_DBG_MEO00 ("SequenceDef::writeResult ()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    if ( getMetaData()->getExtrMode() == emExtractAsDDL_els00 )
    {

        StudioOAL_String sequence;

        // SEQUENCES  : OWNER,SEQUENCE_NAME,INCREMENT_BY,LAST_NUMBER,MAX_VALUE,MIN_VALUE,
        //              CYCLE_FLAG,CACHE_SIZE,ORDER_FLAG,CREATEDATE,CREATETIME,COMMENT

        //<create_sequence_statement> ::= CREATE SEQUENCE [<owner>.]<sequence_name>
        //[INCREMENT BY <integer>] [START WITH <integer>]
        //[MAXVALUE <integer> | NOMAXVALUE] [MINVALUE <integer> | NOMINVALUE]
        //[CYCLE | NOCYCLE]
        //[CACHE <unsigned_integer> | NOCACHE]
        //[ORDER | NOORDER]

        sequence  =  SEPARATOR;

        // Special handling of 'foreign' sqlmodes

        if ( getMetaData()->getSqlMode() != cpr_kind_internal )
        {
             SAPDB_Int4 iSqlMode = getMetaData()->getSqlMode();
             sequence += pszSQLModeString_ls31[iSqlMode];
             sequence += SEPARATOR;
        }

        sequence += "CREATE SEQUENCE  ";

        // <sequence_name>
        if ( m_sequencename.Empty() )
             sequence += "" ;
        else
        {
             sequence += "\"";
             sequence += m_sequencename;
             sequence += "\"";
        }
        // [MINVALUE <integer> | NOMINVALUE]
        if ( m_minvalue.Compare("-99999999999999999999999999999999999999")== 0 )
             sequence += " NOMINVALUE ";
        else
        {
             sequence += " MINVALUE ";
             sequence += m_minvalue;
        }
        // [MAXVALUE <integer>  | NOMAXVALUE]
        if ( m_maxvalue.Compare("99999999999999999999999999999999999999") == 0 )
             sequence += " NOMAXVALUE ";
        else
        {
            sequence += " MAXVALUE " ;
            sequence += m_maxvalue;
        }
        // [START WITH <integer>]
        if ( m_lastnumber.Empty())
             sequence += " " ;
        else
        {
             sequence   += " START WITH ";
             sequence   += m_lastnumber;
        }
        // [INCREMENT BY <integer>]
        if ( m_incrementby.Empty() )
             sequence += " " ;
        else
        {
             sequence += " INCREMENT BY ";
             sequence += m_incrementby;
        }
        // [CYCLE | NOCYCLE]
        if ( m_cycleflag.Empty() )
             sequence += " NOCYCLE ";
        else
        {
             if ( m_cycleflag.Compare("Y") == 0 )
                  sequence += " CYCLE ";
             else
                  sequence += " NOCYCLE ";

        }
        // [CACHE <unsigned_integer> | NOCACHE]
        if ( m_cachesize.Empty() )
             sequence += " ";
        else
        {
             if ( m_cachesize.Compare("0") == 0 )
                 sequence += " NOCACHE ";
             else
             {
                 sequence += " CACHE " ;
                 sequence += m_cachesize;
             }

        }
        // [ORDER | NOORDER]
        if ( m_orderflag.Empty() )
             sequence += " NOORDER ";
        else
        {
            if ( m_orderflag.Compare("Y") == 0 )
                 sequence += " ORDER " ;
            else
                 sequence += " NOORDER ";
        }

        return writeLine(sequence);
    }

    // COMMENT ON not described in reference manual

    return SAPDB_TRUE;
}

/*===========================================================================*
 *    SequenceValueDef::SequenceValueDef
 *===========================================================================*/
SequenceValueDef::SequenceValueDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
                 :MetaDataItem ( odbcConnection , pMetaData )
{
}
/*===========================================================================*
 *    SequenceValueDef::~SequenceDef
 *===========================================================================*/
SequenceValueDef::~SequenceValueDef()
{
    ROUTINE_DBG_MEO00 ("SequenceValueDef::~SequenceValueDef()");
}

/*===========================================================================*
 *    SequenceValueDef::initResult
 *===========================================================================*/
SAPDB_Bool SequenceValueDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    ROUTINE_DBG_MEO00 ("SequenceValueDef::initResultSet ()");

    SAPDB_Bool isOk = SAPDB_FALSE;

    if (  odbcConnection.HDBC() && odbcConnection.HENV() )
          isOk = SAPDB_TRUE;
    return isOk;
}
/*===========================================================================*
 *    SequenceValueDef::readResult
 *===========================================================================*/
SAPDB_Bool SequenceValueDef::readResult ( StudioOAL_String *record  )
{
    ROUTINE_DBG_MEO00 ("SequenceValueDef::readResult ()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    SAPDB_Bool isOk = SAPDB_FALSE;

    if ( MetaDataItem::readResult(record) )
    {
         m_lastnumber = record[0];
         isOk = SAPDB_TRUE;
    }

    return isOk;
}

/*===========================================================================*
 *    TableDef::TableDef
 *===========================================================================*/
TableDef::TableDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
             :MetaDataItem ( odbcConnection , pMetaData )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("TableDef::TableDef()");

    setCaseSensitive(SAPDB_TRUE);

    m_pColumnDefResult     = new ResultSet ( odbcConnection );
    m_pConstraintDefResult = new ResultSet ( odbcConnection );
    m_pForeignKeyDefResult = new ResultSet ( odbcConnection );
    m_pTableAttrDefResult  = new ResultSet ( odbcConnection );

    setType (ClassTableDef);
}
/*===========================================================================*
 *     TableDef::TableDef()
 *===========================================================================*/
TableDef::TableDef( sapdbwa_DBC & odbcConnection )
         :MetaDataItem ( odbcConnection )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("TableDef::TableDef()");

    setCaseSensitive(SAPDB_TRUE);

    m_pColumnDefResult     = new ResultSet ( odbcConnection );
    m_pConstraintDefResult = new ResultSet ( odbcConnection );
    m_pForeignKeyDefResult = new ResultSet ( odbcConnection );
    m_pTableAttrDefResult  = new ResultSet ( odbcConnection );

    setType (ClassTableDef);
}
/*===========================================================================*
 *     TableDef::~TableDef
 *===========================================================================*/
TableDef::~TableDef()
{
    ROUTINE_DBG_MEO00 ("TableDef::~TableDef()");

    if ( m_pColumnDefResult     != NULL )
    {
       delete m_pColumnDefResult;
       m_pColumnDefResult = NULL;
    }
    if ( m_pConstraintDefResult != NULL )
    {
       delete m_pConstraintDefResult;
       m_pConstraintDefResult = NULL;
    }
    if ( m_pForeignKeyDefResult != NULL )
    {
       delete m_pForeignKeyDefResult;
       m_pForeignKeyDefResult = NULL;
    }
    if ( m_pTableAttrDefResult  != NULL )
    {
       delete m_pTableAttrDefResult;
       m_pTableAttrDefResult = NULL;
    }

}
/*===========================================================================*
 *     TableDef::Init
 *===========================================================================*/
SAPDB_Int4
TableDef::Init(const StudioOAL_String &OwnerName, const StudioOAL_String &TableName)
{
    SAPDB_Int4 rc = errOK_els00;

    // Set values of StudioTD_TableDef to initial values
    // mOwner and mName are members of StudioTD_TableDef; TableDef is
    // derived from StudioTD_TableDef

    StudioTD_TableDef::reset();

    setOwner(OwnerName);
    setName(TableName);
    setCaseSensitive(SAPDB_TRUE);

    // Additionally set onwer and tablename members of TableDef
    m_owner     = OwnerName;
    m_tableName = TableName;


    /*-------------------------------------------------------------------------*
     * Before doing anything else check if more than one table with the same   *
     * name and different owners is found in the DB in case the owner name     *
     * is not specified.                                                       *
     *-------------------------------------------------------------------------*/
    if (SAPDB_TRUE == m_owner.Empty())
        rc = CheckForAmbiguousTableNames();

    return rc;
}
// TableDef::Init()

/*===========================================================================*
 *     TableDef::executeSQL
 *===========================================================================*/
SAPDB_Bool TableDef::executeSQL (StudioOAL_String& statement)
{
    return MetaDataItem::executeSQL ( statement);
}
/*===========================================================================*
 *     TableDef::executeSQL - overloaded
 *===========================================================================*/
SAPDB_Bool TableDef::executeSQL (const char* statement)
{
    StudioOAL_String stmt(statement);

    return executeSQL(stmt);
}

/*===========================================================================*
 *     TableDef::readResult
 *===========================================================================*/
SAPDB_Bool TableDef::readResult ( StudioOAL_String *record , SAPDB_Bool* bIsNull )
{
    return MetaDataItem::readResult ( record );
}
/*===========================================================================*
 *     TableDef::readTableDefinitionDirect
 *===========================================================================*/
SAPDB_Int4
TableDef::readTableDefinitionDirect(StudioOAL_String &owner, StudioOAL_String &tablename)
{
    ROUTINE_DBG_MEO00 ("TableDef::readTableDefinitionDirect()");

    SAPDB_Int4 rc = errOK_els00;


    StudioOAL_String        columnDef;
    StudioOAL_String        forkeyDef;
    StudioOAL_String        attributeDef;
    StudioOAL_String        name;
    StudioOAL_String        record[10];
    StudioOAL_String        s;
    StudioOAL_String        whereClause;
    SAPDB_Bool              bRead = SAPDB_FALSE;
    SAPDB_Bool             *pIsNull = NULL;
    StudioTD_ColumnDef     *col;
    StudioTD_ForeignKeyDef *forkey;

    /*-------------------------------------------------------------------------*
     * Prepare the WHERE clause for the SQL statements.                        *
     *-------------------------------------------------------------------------*/
    whereClause += "WHERE TABLENAME = '";
    whereClause += m_tableName;

    if (SAPDB_FALSE == m_owner.Empty())
    {
        whereClause += "' AND OWNER = '";
        whereClause += m_owner;
    }
    whereClause += "' ";


    /*-------------------------------------------------------------------------*
     *  Load the column definitions from the database.                         *
     *-------------------------------------------------------------------------*/
    columnDef  = "SELECT COLUMNNAME, DATATYPE, LEN, DEC, CODETYPE, MODE, KEYPOS, "
                 "NULLABLE, \"DEFAULT\", COMMENT FROM DOMAIN.COLUMNS ";
    columnDef += whereClause;

    if (!executeSQL( columnDef ))
    {
        rc = errODBCErrors_els98;
    }
    else
    {
        while (readResult(record, pIsNull ) )
        {
            col = addColumn();
            col->setTableOwner(owner);
            col->setTableName (tablename);
            col->setName      (record[0]);
            col->setOldName   (record[0]);
            col->setDataType  (ProperCase (record[1]));

            if ((col->dataType() == "Char") || (col->dataType() == "Varchar") || (col->dataType() == "Float"))
            {
                col->setDimension(record[2]);
            }

            if (col->dataType() == "Fixed")
            {
                s  = record[2];
                s += ",";
                s += record[3];
                col->setDimension(s);
            }

            col->setCodeType (record[4]);

            if (record[5] == "KEY")
            {
                col->setKey (SAPDB_TRUE);
                if (!getColumn(6)->getColIsNull() )
                     col->setKeyPos(AtoI(record[6]));
            }

            if (record[7] == "NO")
                col->setNotNull (SAPDB_TRUE);
            if (record[7] == "YES")
                col->setNotNull (SAPDB_FALSE);

            if ( !getColumn(9)->getColIsNull() )
            {
                col->setDefaultValueEx(record[8]);
            }

            if ( !getColumn(10)->getColIsNull() )
                  col->setComment ( record[9] );

            //if ( !getColumn(9)->getColIsNull() )  // record[8] != NULL_VALUE
                   col->setUnique (SAPDB_FALSE);

            bRead = SAPDB_TRUE;
        }   // end while (readResult(record, pIsNull ) )

        if (!bRead)
        {
            rc = errODBCErrors_els98;
        }
    }

    /*-------------------------------------------------------------------------*
     * Load the constraint definitions from the database.                      *
     *-------------------------------------------------------------------------*/
    rc = getListOfConstraintValues();

   /*-------------------------------------------------------------------------*
    * Load the foreign key definitions from the database.                     *
    *-------------------------------------------------------------------------*/
    if (errOK_els00 == rc)
    {
        forkeyDef  = "SELECT FKEYNAME, COLUMNNAME, REFTABLENAME, REFOWNER, REFCOLUMNNAME, RULE, COMMENT "
                     "FROM FOREIGNKEYCOLUMNS ";
        forkeyDef += whereClause;

        if (!executeSQL (forkeyDef))
        {
            rc = errODBCErrors_els98;
        }
        else
        {
            while (readResult(record, pIsNull ))
            {
                if (name != record[0])
                {
                    forkey = addForeignKey();
                    forkey->setName(record[0]);

                    s.Erase();
                    // The next builds full qualified table name of referenced table
                    // In case of EXTRACT CATALOG USER|TABLE we do not extract the user name if
                    // it the current user -> so check this and build the name appropriately
                    if ( (ptAll_els00 == getMetaData()->getPartSpec().psPartType_ls00) ||
                         ( (ptAll_els00 != getMetaData()->getPartSpec().psPartType_ls00) &&
                           (0 != mOwner.Compare(record[3])) ) )
                    {
                        s  = record[3];
                        s += ".";
                    }

                    s += record[2];
                    s += " (";
                    forkey->setReference(s);

                    if (record[5].SubStr(0, 6) == "DELETE")
                    {
                        forkey->setOnDelete (record[5].SubStr(6));
                    }
                    else
                    {
                        forkey->setOnDelete(record[5]);
                    }

                    if ( !getColumn(7)->getColIsNull() )
                    {
                        forkey->setComment(record[6]);
                    }
                    name = record[0];
                }

                if (!forkey->referencingColumns().Empty())
                {
                    s  = forkey->referencingColumns();
                    s += ",";
                    forkey->setReferencingColumns (s);
                    s  = forkey->reference().SubStr (0, forkey->reference().Length() - 1);
                    s += ",";
                    forkey->setReference (s);
                }

                s  = forkey->referencingColumns();
                s += record[1];
                forkey->setReferencingColumns (s);
                s  = forkey->reference();
                s += record[4];
                s += ")";
                forkey->setReference (s);
            }
        }
    }

   /*-------------------------------------------------------------------------*
    * Load the misc attributes of the table definition.                       *
    *-------------------------------------------------------------------------*/
    if (errOK_els00 == rc)
    {
        attributeDef  = "SELECT COMMENT, SAMPLE_PERCENT, SAMPLE_ROWS FROM DOMAIN.TABLES ";
        attributeDef += whereClause;

        if (!executeSQL (attributeDef))
        {
            rc = errODBCErrors_els98;
        }
        else
        {
            if (readResult(record, pIsNull ))
            {
                if ( !getColumn(1)->getColIsNull() ) // record[0] != NULL_VALUE
                    mComment = record[0];

                if ( !getColumn(2)->getColIsNull() )  // record[1] != NULL_VALUE
                {
                    mSampleValue = AtoI (record[1]);
                    mSampleUnit  = "Percent";
                }
                else
                {
                    mSampleValue = AtoI (record[2]);
                    mSampleUnit  = "Rows";
                }

                if (owner.ToUpper() == "TEMP")
                    mTemporary = SAPDB_TRUE;
            }

            setAlterType (AlterNoChange);
        }
    }

    return rc;
}
// TableDef::readTableDefinitionDirect()


/*===========================================================================*
 *     TableDef::getListOfDefaultValues
 *===========================================================================*/
SAPDB_Int4
TableDef::getListOfDefaultValues()
{
    ROUTINE_DBG_MEO00 ("TableDef::getListOfDefaultValues()");

    SAPDB_Bool rcBool = SAPDB_TRUE;
    SAPDB_Int4 rc     = errOK_els00;

    StudioOAL_String    record[3];
    SAPDB_Bool         *pIsNull = NULL;
    StudioTD_ColumnDef *pCol    = NULL;

    StudioOAL_String defaultdef("SELECT \"DEFAULT\", POS, DATATYPE FROM "
                                "DOMAIN.COLUMNS WHERE TABLENAME = '");
    defaultdef += m_tableName;
    if (SAPDB_FALSE == m_owner.Empty())
    {
        defaultdef += "' AND OWNER = '";
        defaultdef += m_owner;
    }
    defaultdef += "' ORDER BY POS";


    if (!executeSQL( defaultdef ))
    {
        rc = errODBCErrors_els98;
    }
    else
    {
        while ( SAPDB_TRUE == (rcBool = readResult(record, pIsNull)) )
        {
            pCol = addColumn();
            pCol->setDataType(ProperCase(record[2]));
            pCol->setColPos(STATIC_CAST(SAPDB_Int2, AtoI(record[1])));

            if ( !getColumn(1)->getColIsNull() )
            {
                pCol->setDefaultValueEx(record[0]);
            }
        }   // end while (readResult(record, pIsNull ) )
//TODOTODO readResult liefert SAPDB_FALSE egal ob ein fehler aufgetreten ist oder keine daten (mehr) gefunden wurden?
    }   // end else of if (!executeSQL( defaultdef ))

    return rc;
}
// TableDef::getListOfDefaultValues()


/*===========================================================================*
 *     TableDef::getListOfConstraintValues
 *===========================================================================*/
SAPDB_Int4
TableDef::getListOfConstraintValues()
{
    ROUTINE_DBG_MEO00 ("TableDef::getListOfConstraintValues()");

    SAPDB_Bool rcBool = SAPDB_TRUE;
    SAPDB_Int4 rc     = errOK_els00;

    StudioOAL_String        record[2];
    SAPDB_Bool             *pIsNull = NULL;
    StudioTD_ConstraintDef *pconstr;

    /*-------------------------------------------------------------------------*
     * Load constraint definitions from db.                                    *
     *-------------------------------------------------------------------------*/

    StudioOAL_String constraintDef("SELECT CONSTRAINTNAME, DEFINITION FROM "
                                   "DOMAIN.CONSTRAINTS WHERE TABLENAME = '");
    constraintDef += m_tableName;
    if (SAPDB_FALSE == m_owner.Empty())
    {
        constraintDef += "' AND OWNER = '";
        constraintDef += m_owner;
    }
    constraintDef += "' ";

    if (!executeSQL (constraintDef))
    {
        rc = errODBCErrors_els98;
    }
    else
    {
        while (readResult(record, pIsNull ))
        {
            pconstr = addConstraint();
            pconstr->setName(record[0]);
            pconstr->setDefinition(record[1]);
            //constr->parseConditions (record[1]);

            setConstraintName(record[0]);
            setConstraintExpression(record[1]);
        }
    }

//TODOTODO readResult liefert SAPDB_FALSE egal ob ein fehler aufgetreten ist oder keine daten (mehr) gefunden wurden?

    return rc;
}
// TableDef::getListOfConstraintValues()


// If no owner name was given this function checks for ambiguous table names

/*===========================================================================*
 *     TableDef::CheckForAmbiguousTableNames
 *===========================================================================*/
SAPDB_Int4 TableDef::CheckForAmbiguousTableNames()
{
    SAPDB_Int4 rc = errOK_els00;

    /*-------------------------------------------------------------------------*
     * Check if more than one table with the same                              *
     * name and different owners is found in the DB in case the owner name     *
     * is not specified.                                                       *
     *-------------------------------------------------------------------------*/
    StudioOAL_String  record[1];
    StudioOAL_String  SelectOwnerCountCmd("SELECT COUNT(DISTINCT OWNER) FROM "
                                          "DOMAIN.COLUMNS WHERE TABLENAME = '");
    SelectOwnerCountCmd += m_tableName;
    SelectOwnerCountCmd += "'";

    if (SAPDB_TRUE == executeSQL( SelectOwnerCountCmd ))
    {
        MetaDataItem::readResult(record);
        SAPDB_Int4 lOwnerCount = AtoI( record[0] );
        if (lOwnerCount > 1)
        {
            RepServMessages::Instance()->ls98PrintMessage(layCatalogExtract_els98, errDEAmbiguousTableName_els98);
            rc = errDEAmbiguousTableName_els98;
        }
    }
    else
    {
        rc = errODBCErrors_els98;
    }
    return rc;
}
// TableDef::CheckForAmbiguousTableNames()


/*===========================================================================*
 *     TableDef::genCreateStatement
 *===========================================================================*/
StudioOAL_String TableDef::genCreateStatement()
{
    StudioOAL_String         sql,s,k,temp;
    SAPDB_Bool               casesensitive = mCaseSensitive;
    SAPDB_Bool               bKey = false;
    StudioTD_String*         primaryKeys;
    char                     buf[256];

    StudioTD_ColumnDef      *col    = NULL;
    StudioTD_ConstraintDef  *constr = NULL;
    StudioTD_ForeignKeyDef  *forkey = NULL;

    StudioOAL_String::ConstIterator  iter;

    /*-------------------------------------------------------------------------*
     * Check if a table name was given. If not --> return an empty string.     *
     *-------------------------------------------------------------------------*/
    if (mName.Empty())
        return "";

    /*-------------------------------------------------------------------------*
     * Generate the intro of the CREATE TABLE statement.                       *
     *-------------------------------------------------------------------------*/
    sql += "CREATE TABLE \"";

    if (mTemporary)
        sql += "TEMP\".\"";

    mOwner = ""; //PTS 1118546

    if(mOwner != "")
    {
        sql += CASE(mOwner);
        sql += "\".\"";
    }
    sql += CASE(mName);
    sql += "\""NEW_LINE_LS00"("NEW_LINE_LS00;


    /*-------------------------------------------------------------------------*
     * For each item in the columns list generate its part of the statement.   *
     * In a second run the PRIMARY KEY clause is generated.                    *
     *-------------------------------------------------------------------------*/
    for (col = (StudioTD_ColumnDef *)mColumns.first(); col; col = (StudioTD_ColumnDef *)mColumns.next())
    {
        sql += col->genCreateStatement (mMode, mCaseSensitive);
    }

    /*-------------------------------------------------------------------------*
     * A primary key, constraints and foreign keys are only inserted if the    *
     * mode is not CreateFromQuery (query as a template).                      *
     *-------------------------------------------------------------------------*/
    if (mMode != CreateFromQuery)
    {
        SAPDB_UInt keyCounter = keyCount();
        primaryKeys = new StudioTD_String[keyCounter];

        for (col = (StudioTD_ColumnDef *)mColumns.first(); col; col = (StudioTD_ColumnDef *)mColumns.next())
        {
            if (col->key())
            {
                //the fist column will set the the key flag
                if(col->keyPos() == 1 )
                {
                   bKey = true;
                   temp = "\tPRIMARY KEY (";
                }
                else
                   temp = "";
                temp += "\"";
                temp += CASE(col->name());
                temp += "\", ";

                primaryKeys[col->keyPos()-1] = temp;
            }
        }

        for(SAPDB_UInt i = 0; i < keyCounter;i++)
            sql += primaryKeys[i];

        //delete all elements
        if(primaryKeys != NULL)
           delete[] primaryKeys;

        if (bKey)
        {
            iter = sql.End();
            iter -= 2;
            sql.Erase (iter, sql.End());
            sql += "),"NEW_LINE_LS00;
        }

        /*-----------------------------------------------------------------------*
         * For each item in the constraint list generate its part of the         *
         * statement.                                                            *
         *-----------------------------------------------------------------------*/

        // Column Constraint
        for (constr = (StudioTD_ConstraintDef *)mConstraints.first(); constr; constr = (StudioTD_ConstraintDef *)mConstraints.next())
        {
            // CONSTRAINT <constraint_name> CHECK <search_condition>
            if ( !constr->name().Empty() )
            {
                sql += " CONSTRAINT ";
                sql += "\"";
                sql += constr->name();
                sql += "\"";
                sql += " CHECK ";
                sql += constr->definition();
                sql += ","NEW_LINE_LS00;
            }
            // CONSTRAINT <search_condition>
            else
            {
                sql += " CONSTRAINT ";
                sql += constr->definition();
                sql += ","NEW_LINE_LS00;
            }
        }

        /*-----------------------------------------------------------------------*
         * For each item in the foreignkey list generate its part of the         *
         * statement.                                                            *
         *-----------------------------------------------------------------------*/
        for (forkey = (StudioTD_ForeignKeyDef *)mForeignKeys.first();forkey; forkey = (StudioTD_ForeignKeyDef *)mForeignKeys.next())
            sql += forkey->genCreateStatement (mMode, mCaseSensitive);

    }// if (mMode != CreateFromQuery)

    iter = sql.End();
    iter -= (1 + NEW_LINE_LEN_LS00);
    sql.Erase (iter, sql.End());
    sql += NEW_LINE_LS00")";

    /*-------------------------------------------------------------------------*
     * Insert misc table attributes.                                           *
     *-------------------------------------------------------------------------*/
    if (mTemporary && mIgnoreRollback)
        sql += NEW_LINE_LS00"IGNORE ROLLBACK";

    if ((mSampleValue != 20000) || (mSampleUnit != "Rows"))
    {
        sprintf (buf, NEW_LINE_LS00"SAMPLE %d %s", mSampleValue, UpperCase(mSampleUnit).StrPtr());
        sql += buf;
    }

    /*-------------------------------------------------------------------------*
     * If the table is based on a query template the SELECT statement is       *
     * appended in the AS clause.                                              *
     *-------------------------------------------------------------------------*/
    if (mMode == CreateFromQuery)
    {
        sql += NEW_LINE_LS00"AS ";
        sql += mCreateAs;

        if (!mDuplicates.Empty())
        {
            sql += " ";
            sql += UpperCase(mDuplicates);
            sql += " DUPLICATES";
        }
    }

    /*-------------------------------------------------------------------------*
     * Finally, append the comments.                                           *
     *-------------------------------------------------------------------------*/
    if (!mComment.Empty())
    {
        sql += NEW_LINE_LS00;
        sql += SEPARATOR;
        sql += "COMMENT ON TABLE \"";
        sql += CASE(mName);
        sql += "\" IS '";
        sql += string2SQL(mComment);
        sql += "'";
    }

    StudioOAL_String TmpCommentString;
    for (col = (StudioTD_ColumnDef *)mColumns.first(); col; col = (StudioTD_ColumnDef *)mColumns.next())
    {
        if (!col->comment().Empty())
        {
            TmpCommentString = col->comment();

            sql += NEW_LINE_LS00;
            sql += SEPARATOR;
            sql += "COMMENT ON COLUMN \"";
            sql += CASE(mName);
            sql += "\".\"";
            sql += CASE(col->name());
            sql += "\" IS '";
            sql += string2SQL(TmpCommentString);
            sql += "'";
        }
    }

    if (mMode != CreateFromQuery)
    {
        for (forkey = (StudioTD_ForeignKeyDef *)mForeignKeys.first();
             forkey;
             forkey = (StudioTD_ForeignKeyDef *)mForeignKeys.next())
        {
            if (!forkey->comment().Empty() && (forkey->name() != "<no name>"))
            {
                TmpCommentString = forkey->comment();

                sql += NEW_LINE_LS00;
                sql += SEPARATOR;
                sql += "COMMENT ON FOREIGN KEY \"";
                sql += CASE(mName);
                sql += "\".\"";
                sql += CASE(forkey->name());
                sql += "\" IS '";
                sql += string2SQL(TmpCommentString);
                sql += "'";
            }
        }
    }

  return sql;
}
/*===========================================================================*
 *     TableDef::writeTableDefinition
 *===========================================================================*/
SAPDB_Bool TableDef::writeTableDefinition ( )
{
   ROUTINE_DBG_MEO00 ("TableDef::writeTableDefinition ()");

   StudioOAL_String table;

   if ( getMetaData()->getExtrMode() == emExtractAsDDL_els00 )
   {
        table  = SEPARATOR;

        if ( getMetaData()->getSqlMode() != cpr_kind_internal )
        {
             table += pszSQLModeString_ls31[cpr_kind_internal];
             table += SEPARATOR;
        }

        // does not support constraints PTS 1110139
        // table += StudioTD_TableDef::genCreateStatement();
        table += genCreateStatement();
   }
   if ( getMetaData()->getExtrMode() == emExtractAsXML_els00 )
   {
        table += StudioTD_TableDef::genCreateXML();
   }

   return writeLine(table);
}
/*===========================================================================*
 *     TableDef::initResultSet
 *===========================================================================*/
SAPDB_Bool TableDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    if (  odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        StudioOAL_String columnDef;
        StudioOAL_String constraintDef;
        StudioOAL_String foreignKeyDef;
        StudioOAL_String tableAttrDef;
        StudioOAL_String whereClause;

       /*-------------------------------------------------------------------------*
        * Prepare the WHERE clause for the SQL statements.                        *
        *-------------------------------------------------------------------------*/
        whereClause    = "WHERE OWNER = ?  AND TABLENAME = ? ";

        columnDef      = " SELECT A.columnname, A.datatype, A.len, A.dec, A.codetype, A.mode, A.default, A.comment "
                         " FROM DOMAIN.columns A ";
        columnDef     += whereClause;

        constraintDef = "SELECT constraintname, definition "
                        "FROM  DOMAIN.constraints ";
        constraintDef += whereClause;

        foreignKeyDef  = "SELECT fkeyname, columnname, reftablename, refowner, refcolumnname, rule, comment "
                         "FROM   DOMAIN.foreignkeycolumns ";
        foreignKeyDef += whereClause;

        tableAttrDef   = "SELECT comment, sample_percent, sample_rows "
                         "FROM   DOMAIN.tables ";
        tableAttrDef  += whereClause;

        // SQLAllocStmt     SQLPrepare
        // SQLNumParams     SQLDescribeParam SQLBindParameter
        // SQLNumResultCols SQLDescribeCol   SQLBindCol
        if ( !m_pColumnDefResult->init( columnDef ) )
        {
            getMetaData()->getError()->setErrorText(getErrorText() );
            getMetaData()->getError()->isError(isError     () );

            return SAPDB_FALSE;
        }
        if ( !m_pConstraintDefResult->init( constraintDef ) )
        {
             getMetaData()->getError()->setErrorText(getErrorText() );
             getMetaData()->getError()->isError(isError() );
             return SAPDB_FALSE;
        }
        if ( !m_pForeignKeyDefResult->init( foreignKeyDef ) )
        {
             getMetaData()->getError()->setErrorText(getErrorText() );
             getMetaData()->getError()->isError(isError() );
             return SAPDB_FALSE;
        }
        if ( !m_pTableAttrDefResult->init( tableAttrDef  ) )
        {
             getMetaData()->getError()->setErrorText(getErrorText() );
             getMetaData()->getError()->isError(isError() );
             return SAPDB_FALSE;
        }
    }// if ( odbcConnection.HDBC() && odbcConnection.HENV() )

    return SAPDB_TRUE;
}
/*===========================================================================*
 *     TableDef::readTableDefinition                                     *
 *===========================================================================*/
SAPDB_Bool TableDef::readTableDefinition ( StudioOAL_String owner, StudioOAL_String tablename )
{
    StudioOAL_String        sql;
    StudioOAL_String        name;
    StudioOAL_String        record[8];
    StudioOAL_String        s;
    SAPDB_Bool              bRead = false;

    StudioTD_ColumnDef     *col;
    StudioTD_ConstraintDef *constr;
    StudioTD_ForeignKeyDef *forkey;

    SAPDB_Bool isOk       = SAPDB_FALSE;

    StudioOAL_String parameters[2];

    parameters[0]   = m_owner;
    parameters[1]   = m_tableName;

    /*-------------------------------------------------------------------------*
     * Load the column definitions from the database.                          *
     *-------------------------------------------------------------------------*/
    m_pColumnDefResult->reset();

    if ( !m_pColumnDefResult->setParamValues( parameters ) )
    {
        getMetaData()->getError()->setErrorText(getErrorText() );
        getMetaData()->getError()->isError     (isError     () );
        return SAPDB_FALSE;
    }

    /*-------------------------------------------------------------------------*
     * Execute the prepared statement                                          *
     *-------------------------------------------------------------------------*/
    // SQLExecute
    if ( !m_pColumnDefResult->execute() )
    {
        MetaDataDef *pMetaData  = getMetaData();
        sapdb_Error    *pError    = pMetaData->getError();

        StudioOAL_String errorText = m_pColumnDefResult->getErrorText();
        SAPDB_Bool      isError   = m_pColumnDefResult->isError     ();

        pError->setErrorText( errorText );
        pError->isError     ( isError   );

        return SAPDB_FALSE;
    }
    // SQlFetch SQLFreeStatement
    while (readColumnDefResult(record))
    {
        col = addColumn();
        col->setTableOwner(owner);
        col->setTableName (tablename);
        col->setName      (record[0]);
        col->setOldName   (record[0]);
        col->setDataType  (ProperCase (record[1]));

        if ((col->dataType() == "Char") || (col->dataType() == "Varchar") || (col->dataType() == "Float"))
        {
            col->setDimension (record[2]);
        }

        if (col->dataType() == "Fixed")
        {
            s  = record[2];
            s += ",";
            s += record[3];
            col->setDimension (s);
        }

        col->setCodeType (record[4]);

        if (record[5] == "KEY")
        {
            col->setKey (SAPDB_TRUE);
        }

        if (record[5] == "MAN")
        {
            col->setNotNull (SAPDB_TRUE);
        }

        if ( !m_pColumnDefResult->getColumn(7)->getColIsNull() ) // record[6] != NULL_VALUE
        {
            col->setDefaultValueEx(record[6].SubStr(8));
        }

        if ( !m_pColumnDefResult->getColumn(8)->getColIsNull() ) // record[7] != NULL_VALUE
        {
            col->setComment (record[7]);
        }

        //if ( !m_pColumnDefResult->getColumn(9)->getColIsNull() ) // record[8] != NULL_VALUE)
        col->setUnique (SAPDB_FALSE);

        bRead = SAPDB_TRUE;
    }

    if (!bRead)
    {
        return isOk;
    }

    /*-------------------------------------------------------------------------*
     * Load the constraint definitions from the database.                      *
     *-------------------------------------------------------------------------*/
    m_pConstraintDefResult->reset();

    if ( !m_pConstraintDefResult->setParamValues( parameters ) )
    {
        getMetaData()->getError()->setErrorText(getErrorText() );
        getMetaData()->getError()->isError     (isError     () );
        return SAPDB_FALSE;
    }

    /*-------------------------------------------------------------------------*
     * Execute the prepared statement                                          *
     *-------------------------------------------------------------------------*/
    // SQLExecute
    if (!m_pConstraintDefResult->execute() )
    {
        MetaDataDef *pMetaData  = getMetaData();
        sapdb_Error    *pError    = pMetaData->getError();

        StudioOAL_String errorText = m_pConstraintDefResult->getErrorText();
        SAPDB_Bool      isError   = m_pConstraintDefResult->isError     ();

        pError->setErrorText( errorText );
        pError->isError     ( isError   );

        return SAPDB_FALSE;
    }
    // SQlFetch SQLFreeStatement
    while (readConstraintDefResult(record))
    {
        constr = addConstraint( );
        constr->setName         (record[0]);
        constr->setDefinition   (record[1]);
        //constr->parseConditions (record[1]);

        setConstraintName       (record[0]);
        setConstraintExpression (record[1]);

        bRead = true;
    }

    /*-------------------------------------------------------------------------*
     * Load the foreign key definitions from the database.                     *
     *-------------------------------------------------------------------------*/
    m_pForeignKeyDefResult->reset();

    if ( !m_pForeignKeyDefResult->setParamValues( parameters ) )
    {
        getMetaData()->getError()->setErrorText(getErrorText() );
        getMetaData()->getError()->isError     (isError     () );
        return SAPDB_FALSE;
    }

    /*-------------------------------------------------------------------------*
     * Execute the prepared statement                                          *
     *-------------------------------------------------------------------------*/
    // SQLExecute
    if (!m_pForeignKeyDefResult->execute() )
    {
        MetaDataDef *pMetaData  = getMetaData();
        sapdb_Error *pError     = pMetaData->getError();

        StudioOAL_String errorText = m_pForeignKeyDefResult->getErrorText();
        SAPDB_Bool      isError   = m_pForeignKeyDefResult->isError     ();

        pError->setErrorText( errorText );
        pError->isError     ( isError   );

        return SAPDB_FALSE;
    }
    // SQlFetch SQLFreeStatement
    while (readForeignKeyDefResult(record))
    {
        bRead = true;

        if (name != record[0])
        {
            forkey = addForeignKey( );
            forkey->setName       (record[0]);
            s  = record[3];
            s += ".";
            s += record[2];
            s += " (";
            forkey->setReference (s);

            if (record[5].SubStr (0, 6) == "DELETE")
                forkey->setOnDelete (record[5].SubStr (6));
            else
                forkey->setOnDelete (record[5]);

            if ( !m_pForeignKeyDefResult->getColumn(7)->getColIsNull() ) // record[6] != NULL_VALUE
                forkey->setComment (record[6]);

            name = record[0];
        }

        if (!forkey->referencingColumns().Empty())
        {
            s  = forkey->referencingColumns();
            s += ",";
            forkey->setReferencingColumns (s);
            s  = forkey->reference().SubStr (0, forkey->reference().Length() - 1);
            s += ",";
            forkey->setReference (s);
        }

        s  = forkey->referencingColumns();
        s += record[1];
        forkey->setReferencingColumns (s);
        s  = forkey->reference();
        s += record[4];
        s += ")";
        forkey->setReference (s);
    }

    /*-------------------------------------------------------------------------*
     * Load the misc attributes of the table definition.                       *
     *-------------------------------------------------------------------------*/
    m_pTableAttrDefResult->reset();
    if ( !m_pTableAttrDefResult->setParamValues( parameters ) )
    {
        getMetaData()->getError()->setErrorText(getErrorText() );
        getMetaData()->getError()->isError     (isError     () );
        return SAPDB_FALSE;
    }

    /*-------------------------------------------------------------------------*
     * Execute the prepared statement                                          *
     *-------------------------------------------------------------------------*/
    // SQLExecute
    if (!m_pTableAttrDefResult->execute() )
    {
        MetaDataDef *pMetaData  = getMetaData();
        sapdb_Error    *pError    = pMetaData->getError();

        StudioOAL_String errorText = m_pTableAttrDefResult->getErrorText();
        SAPDB_Bool      isError   = m_pTableAttrDefResult->isError     ();

        pError->setErrorText( errorText );
        pError->isError     ( isError   );

        return SAPDB_FALSE;
    }
    // SQlFetch SQLFreeStatement
    while (readTableAttrDefResult(record))
    {
        bRead = true;

        if ( !m_pTableAttrDefResult->getColumn(1)->getColIsNull() ) // record[0] != NULL_VALUE
            mComment = record[0];
        if ( !m_pTableAttrDefResult->getColumn(2)->getColIsNull() ) // record[1] != NULL_VALUE
        {
            mSampleValue = AtoI (record[1]);
            mSampleUnit  = "Percent";
        }
        else
        {
            mSampleValue = AtoI (record[2]);
            mSampleUnit  = "Rows";
        }
        if (owner.ToUpper() == "TEMP")
            mTemporary = true;
    }
    setAlterType (AlterNoChange);

    isOk = SAPDB_TRUE;

    return isOk;
}
/*===========================================================================*
 *     TableDef::readColumnDefResult
 *===========================================================================*/
SAPDB_Bool TableDef::readColumnDefResult(StudioOAL_String *record)
{
    SAPDB_Bool rc = SAPDB_TRUE;

    /*-------------------------------------------------------------------------*
     * Fetch the next record.                                                  *
     *-------------------------------------------------------------------------*/
    // SQLFetch
    rc = m_pColumnDefResult->fetch();
    if (SAPDB_TRUE == rc)
    {
        /*-------------------------------------------------------------------------*
         * If there are no more records, reading the result is finished.           *
         *-------------------------------------------------------------------------*/
        rc = m_pColumnDefResult->noRows();
        if (SAPDB_TRUE == rc)
        {
            /*-------------------------------------------------------------------------*
             * Read all columns of the fetched record.                                 *
             *-------------------------------------------------------------------------*/
            SAPDB_Int2       i;
            StudioOAL_String s;

            for (i = 0; i < m_pColumnDefResult->getColCount(); i++)
            {
                m_pColumnDefResult->bindColumnDataAsString (i + 1, s);
                record[i] = s;
            }
        }
    }
    if (SAPDB_FALSE == rc)
    {
        m_pColumnDefResult->closeCursor();
    }

    return rc;
}
/*===========================================================================*
 *     TableDef::readConstraintDefResult
 *===========================================================================*/
SAPDB_Bool TableDef::readConstraintDefResult(StudioOAL_String *record)
{
    SAPDB_Bool rc = SAPDB_TRUE;

    /*-------------------------------------------------------------------------*
     * Fetch the next record.                                                  *
     *-------------------------------------------------------------------------*/
    // SQLFetch
    rc = m_pConstraintDefResult->fetch();
    if (SAPDB_TRUE == rc)
    {
        /*-------------------------------------------------------------------------*
         * If there are no more records, reading the result is finished.           *
         *-------------------------------------------------------------------------*/
        rc = m_pConstraintDefResult->noRows();
        if (SAPDB_TRUE == rc)
        {
            /*-------------------------------------------------------------------------*
             * Read all columns of the fetched record.                                 *
             *-------------------------------------------------------------------------*/
            SAPDB_Int2       i = 0;
            StudioOAL_String s;

            for (i; i < m_pConstraintDefResult->getColCount(); i++)
            {
                m_pConstraintDefResult->bindColumnDataAsString (i + 1, s);
                record[i] = s;
            }
        }
    }
    if (SAPDB_FALSE == rc)
    {
        m_pConstraintDefResult->closeCursor();
    }

    return rc;
}
/*===========================================================================*
 *     TableDef::readForeignKeyDefResult
 *===========================================================================*/
SAPDB_Bool TableDef::readForeignKeyDefResult(StudioOAL_String *record)
{
    SAPDB_Bool rc = SAPDB_TRUE;

    /*-------------------------------------------------------------------------*
     * Fetch the next record.                                                  *
     *-------------------------------------------------------------------------*/
    // SQLFetch
    rc = m_pForeignKeyDefResult->fetch();
    if (SAPDB_TRUE == rc)
    {
        /*-------------------------------------------------------------------------*
         * If there are no more records, reading the result is finished.           *
         *-------------------------------------------------------------------------*/
        rc = m_pForeignKeyDefResult->noRows();
        if (SAPDB_TRUE == rc)
        {
            /*-------------------------------------------------------------------------*
             * Read all columns of the fetched record.                                 *
             *-------------------------------------------------------------------------*/
            SAPDB_Int2       i = 0;
            StudioOAL_String s;

            for (i; i < m_pForeignKeyDefResult->getColCount(); i++)
            {
                m_pForeignKeyDefResult->bindColumnDataAsString (i + 1, s);
                record[i] = s;
            }
        }
    }
    if (SAPDB_FALSE == rc)
    {
        m_pForeignKeyDefResult->closeCursor();
    }

    return rc;
}
/*===========================================================================*
 *     TableDef::readTableAttrDefResult
 *===========================================================================*/
SAPDB_Bool TableDef::readTableAttrDefResult(StudioOAL_String *record)
{
    SAPDB_Bool rc = SAPDB_TRUE;

    /*-------------------------------------------------------------------------*
     * Fetch the next record.                                                  *
     *-------------------------------------------------------------------------*/
    // SQLFetch
    rc = m_pTableAttrDefResult->fetch();
    if (SAPDB_TRUE == rc)
    {
        /*-------------------------------------------------------------------------*
         * If there are no more records, reading the result is finished.           *
         *-------------------------------------------------------------------------*/
        rc = m_pTableAttrDefResult->noRows();
        if (SAPDB_TRUE == rc)
        {
            /*-------------------------------------------------------------------------*
             * Read all columns of the fetched record.                                 *
             *-------------------------------------------------------------------------*/
            SAPDB_Int2       i = 0;
            StudioOAL_String s;

            for (i; i < m_pTableAttrDefResult->getColCount(); i++)
            {
                m_pTableAttrDefResult->bindColumnDataAsString (i + 1, s);
                record[i] = s;
            }
        }
    }
    if (SAPDB_FALSE == rc)
    {
        m_pTableAttrDefResult->closeCursor();
    }

    return rc;
}
/*===========================================================================*
 *    ViewDef::ViewDef
 *===========================================================================*/
ViewDef::ViewDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
            :MetaDataItem ( odbcConnection , pMetaData )
{
    m_pViewDefResult = new ResultSet ( odbcConnection );
}
/*===========================================================================*
 *     ViewDef::ViewDef()
 *===========================================================================*/
ViewDef::ViewDef( sapdbwa_DBC & odbcConnection )
            :MetaDataItem ( odbcConnection )
{
    m_pViewDefResult = new ResultSet ( odbcConnection );
}
/*===========================================================================*
 *     ViewDef::~ViewDef()
 *===========================================================================*/
ViewDef::~ViewDef()
{
    if ( m_pViewDefResult != NULL )
    {
         delete m_pViewDefResult;
         m_pViewDefResult = NULL;
    }
}
/*===========================================================================*
 *     ViewDef::initResultSet
 *===========================================================================*/
SAPDB_Bool ViewDef::initResultSet( sapdbwa_DBC & odbcConnection )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    if (  odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        StudioOAL_String  viewDef("SELECT viewname, owner, definition FROM DOMAIN.viewdefs ");
        StudioOAL_String  whereClause("WHERE owner = ? AND viewname = ?");

        viewDef  += whereClause;

        // SQLAllocStmt     SQLPrepare
        // SQLNumParams     SQLDescribeParam SQLBindParameter
        // SQLNumResultCols SQLDescribeCol   SQLBindCol
        isOk = m_pViewDefResult->init(viewDef);
        if (SAPDB_FALSE == isOk)
        {
            getMetaData()->getError()->setErrorText(getErrorText());
            getMetaData()->getError()->isError(isError());
        }
    }
    return isOk;
}
/*===========================================================================*
 *     ViewDef::readViewDefinition
 *===========================================================================*/
SAPDB_Bool ViewDef::readViewDefinition( StudioOAL_String owner, StudioOAL_String viewname )
{
   ROUTINE_DBG_MEO00 ("ViewDef::readViewDefinition()");

   RepServMessages *pMsgInstance = RepServMessages::Instance();

   // VIEWS    : OWNER,VIEWNAME,PRIVILEGES,TYPE,CREATEDATE,CREATETIME,UPDSTATDATE,UPDSTATTIME,ALTERDATE,ALTERTIME,UNLOADED,COMMENT
   // VIEWDEFS : OWNER,VIEWNAME,LEN,DEFINITION

   SAPDB_Bool isOk = SAPDB_FALSE;

   StudioOAL_String  viewDef[2];
   StudioOAL_String  record[3];

   viewDef[0] = owner;
   viewDef[1] = viewname;

  /*-------------------------------------------------------------------------*
   * Load the index definitions from the database.                           *
   *-------------------------------------------------------------------------*/
   m_pViewDefResult->reset();

   if ( !m_pViewDefResult->setParamValues( viewDef ) )
   {
        getMetaData()->getError()->setErrorText(getErrorText() );
        getMetaData()->getError()->isError     (isError     () );
        return SAPDB_FALSE;
   }
   /*-------------------------------------------------------------------------*
    * Execute the prepared statement                                          *
    *-------------------------------------------------------------------------*/
   // SQLExecute
   if ( !m_pViewDefResult->execute() )
   {
        StudioOAL_String errorText = m_pViewDefResult->getErrorText();
        SAPDB_Bool       isError   = m_pViewDefResult->isError     ();

        getMetaData()->getError()->setErrorText( errorText );
        getMetaData()->getError()->isError     ( isError   );

        return SAPDB_FALSE;
   }
   // SQlFetch SQLFreeStatement
   while ( readViewDefResult (record) )
   {
         m_viewName       = record[0];
         m_owner          = record[1];
         m_viewDefinition = record[2];

         isOk = SAPDB_TRUE;
   }

   return isOk;

}
/*===========================================================================*
 *     ViewDef::writeViewDefinition
 *===========================================================================*/
SAPDB_Bool ViewDef::writeViewDefinition()
{
   ROUTINE_DBG_MEO00 ("ViewDef::writeViewDefinition");

   RepServMessages *pMsgInstance = RepServMessages::Instance();

   StudioOAL_String schemaview;

   if ( getMetaData()->getExtrMode() == emExtractAsDDL_els00 )
   {
        schemaview  = SEPARATOR;

        if ( getMetaData()->getSqlMode() != cpr_kind_internal )
        {
             SAPDB_Int4 iSqlMode = getMetaData()->getSqlMode();
             schemaview += pszSQLModeString_ls31[iSqlMode];
             schemaview += SEPARATOR;
        }

        schemaview += m_viewDefinition;

        //!! ToDo COMMENT ON -> PTS 1109219
        //definition  = record[3].SubStr(11,record[3].Length());
        //definition.Trim();
   }

   if ( getMetaData()->getExtrMode() == emExtractAsXML_els00 )
        schemaview += genCreateXML();

   return writeLine( schemaview );

}
/*===========================================================================*
 *     ViewDef::readViewDefResult
 *===========================================================================*/
SAPDB_Bool ViewDef::readViewDefResult( StudioOAL_String *record )
{
    SAPDB_Bool rc = SAPDB_TRUE;

    /*-------------------------------------------------------------------------*
     * Fetch the next record.                                                  *
     *-------------------------------------------------------------------------*/
    // SQLFetch
    rc = m_pViewDefResult->fetch();
    if (SAPDB_TRUE == rc)
    {
        /*-------------------------------------------------------------------------*
         * If there are no more records, reading the result is finished.           *
         *-------------------------------------------------------------------------*/
        rc = m_pViewDefResult->noRows();
        if (SAPDB_TRUE == rc)
        {
            /*-------------------------------------------------------------------------*
             * Read all columns of the fetched record.                                 *
             *-------------------------------------------------------------------------*/
            SAPDB_Int2       i = 0;
            StudioOAL_String s;

            for (i; i < m_pViewDefResult->getColCount(); i++)
            {
                m_pViewDefResult->bindColumnDataAsString (i + 1, s);
                record[i] = s;
            }
        }
    }
    if (SAPDB_FALSE == rc)
    {
        m_pViewDefResult->closeCursor();
    }

    return rc;
}
/*===========================================================================*
 *     ViewDef::readResult()
 *===========================================================================*/
SAPDB_Bool ViewDef::readResult( StudioOAL_String *record )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    isOk = MetaDataItem::readResult( record);

    if ( isOk )
    {
         m_viewName       = record[0];
         m_owner          = record[1];
         // <create_view_statement> ::= CREATE [OR REPLACE] VIEW <table_name> [(<alias_name>,...)] AS <query_expression> [WITH CHECK OPTION]
         m_viewDefinition = record[2];
    }

    return isOk;
}
/*===========================================================================*
 *     ViewDef::writeResult()
 *===========================================================================*/
SAPDB_Bool ViewDef::writeResult( StudioOAL_String *record )
{
    StudioOAL_String schemaview;

    if ( getMetaData()->getExtrMode() == emExtractAsDDL_els00 )
    {
        schemaview  = SEPARATOR;

        if ( getMetaData()->getSqlMode() != cpr_kind_internal )
        {
            SAPDB_Int4 iSqlMode = getMetaData()->getSqlMode();
            schemaview += pszSQLModeString_ls31[iSqlMode];
            schemaview += SEPARATOR;
        }

        schemaview += m_viewDefinition;

        //!! ToDo COMMENT ON -> PTS 1109219
        //definition  = record[3].SubStr(11,record[3].Length());
        //definition.Trim();
    }

    if ( getMetaData()->getExtrMode() == emExtractAsXML_els00 )
        schemaview += genCreateXML();

    return writeLine( schemaview );
}
/*===========================================================================*
 *     ViewDef::genCreateXML()
 *===========================================================================*/
StudioOAL_String ViewDef::genCreateXML()
{
    // <dbm:SchemaViews>

   StudioOAL_String  as   ((SAPDB_UTF8*)" AS ");
   StudioOAL_String  check((SAPDB_UTF8*)" WITH CHECK OPTION ");
   StudioOAL_String  schemaView;
   StudioOAL_String  viewQuery;
   StudioOAL_String  checkOption = "";

   viewQuery += m_viewDefinition;

   SAPDB_UInt  start = 0, end ;

   if ( (end = viewQuery.Find (as, start) ) != StudioOAL_String::NPos )
   {
       viewQuery = viewQuery.SubStr( end + as.Length(),viewQuery.Length() );

       start = end +1 ;

       if ( (end = viewQuery.Find (check, start) ) != StudioOAL_String::NPos )
       {
             viewQuery   = viewQuery.SubStr( 0, end );
             checkOption = check;
       }

   }

   schemaView  = "<dbm:DeployedView oim:id=\"_";
   schemaView += m_owner;
   schemaView += ".";
   schemaView += m_viewName;
   schemaView += "\" oim:supertype = \"Query\"";
   schemaView += "   oim:seqno     = \"";
   schemaView += "\" dbm:Body = \"";
   schemaView += string2XML ( viewQuery );
   schemaView += "\" dbm:CheckOption = \"";
   schemaView += checkOption;
   schemaView += "\" dbm:description = \"";
   schemaView += string2XML ( m_viewDefinition );
   schemaView += "\" dbm:isSpecification = \"1";
   schemaView += "\" dbm:comments = \"";
   schemaView += "\" dbm:EstimatedRows = \"";
   schemaView += "\" dbm:EstimatedSize = \"";
   schemaView += "\"/>\n";

   return schemaView;
}
/*===========================================================================*
 *    SynonymDef::SynonymDef
 *===========================================================================*/
SynonymDef::SynonymDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
               :MetaDataItem ( odbcConnection , pMetaData )
{
    m_pSynonymDefResult = new ResultSet ( odbcConnection );
}
/*===========================================================================*
 *     SynonymDef::SynonymDef()
 *===========================================================================*/
SynonymDef::SynonymDef( sapdbwa_DBC & odbcConnection )
               :MetaDataItem        ( odbcConnection )
{
    m_pSynonymDefResult = new ResultSet  ( odbcConnection );
}
/*===========================================================================*
 *     SynonymDef::~SynonymDef()
 *===========================================================================*/
SynonymDef::~SynonymDef()
{
    if ( m_pSynonymDefResult != NULL )
    {
        delete m_pSynonymDefResult;
        m_pSynonymDefResult = NULL;
    }
}
/*===========================================================================*
 *     SynonymDef::initResultSet
 *===========================================================================*/
SAPDB_Bool SynonymDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    if (  odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        // CREATE SYNONYM
        // SYNONYMS  : OWNER, SYNONYMNAME, PUBLIC, TABLEOWNER, TABLENAME, COMMENT

        StudioOAL_String  synonymDef("SELECT OWNER, SYNONYMNAME, PUBLIC, TABLEOWNER, TABLENAME, COMMENT "
                                     "FROM DOMAIN.SYNONYMS "
                                     "WHERE OWNER = ? AND SYNONYMNAME = ?");

        // SQLAllocStmt     SQLPrepare
        // SQLNumParams     SQLDescribeParam SQLBindParameter
        // SQLNumResultCols SQLDescribeCol   SQLBindCol

        isOk = m_pSynonymDefResult->init(synonymDef);
        if (SAPDB_FALSE == isOk)
        {
            getMetaData()->getError()->setErrorText(getErrorText());
            getMetaData()->getError()->isError(isError());
        }
    }
    return isOk;
}
/*===========================================================================*
 *     SynonymDef::readSynonymDefinition
 *===========================================================================*/
SAPDB_Bool SynonymDef::readSynonymDefinition( StudioOAL_String owner, StudioOAL_String synonymname )
{
   ROUTINE_DBG_MEO00 ("SynonymDef::readSynonymDefinition");

   RepServMessages *pMsgInstance = RepServMessages::Instance();

   SAPDB_Bool isOk = SAPDB_FALSE;

   StudioOAL_String  synonymDef[2];
   StudioOAL_String  record[6];

   synonymDef[0] = owner;
   synonymDef[1] = synonymname;

  /*-------------------------------------------------------------------------*
   * Load the synonym definitions from the database.                           *
   *-------------------------------------------------------------------------*/

   if ( !m_pSynonymDefResult->setParamValues( synonymDef ) )
   {
        getMetaData()->getError()->setErrorText(getErrorText() );
        getMetaData()->getError()->isError     (isError     () );
        return SAPDB_FALSE;
   }
   /*-------------------------------------------------------------------------*
    * Execute the prepared statement                                          *
    *-------------------------------------------------------------------------*/
   // SQLExecute
   if ( !m_pSynonymDefResult->execute() )
   {
        StudioOAL_String errorText = m_pSynonymDefResult->getErrorText();
        SAPDB_Bool      isError   = m_pSynonymDefResult->isError     ();

        getMetaData()->getError()->setErrorText( errorText );
        getMetaData()->getError()->isError     ( isError   );

        return SAPDB_FALSE;
   }
   // SQlFetch SQLFreeStatement
   while ( readSynonymDefResult (record) )
   {
           m_owner             = record[0];
           m_synonymName       = record[1];
           m_public            = record[2];
           m_tableowner        = record[3];
           m_tablename         = record[4];
           m_comment           = record[5];

           isOk = SAPDB_TRUE;
   }

   return isOk;

}
/*===========================================================================*
 *     SynonymDef::writeSynonymDefinition
 *===========================================================================*/
SAPDB_Bool SynonymDef::writeSynonymDefinition()
{
   ROUTINE_DBG_MEO00 ("SynonymDef::writeSynonymDefinition");

   RepServMessages *pMsgInstance = RepServMessages::Instance();

   StudioOAL_String tableSynonym;

   if ( getMetaData()->getExtrMode() == emExtractAsXML_els00 )
        tableSynonym += genCreateXML();

   if ( getMetaData()->getExtrMode() == emExtractAsDDL_els00 )
   {
        tableSynonym  = SEPARATOR;

        // Special handling of 'foreign' sqlmodes
        if ( getMetaData()->getSqlMode() != cpr_kind_internal )
        {
             SAPDB_Int4 iSqlMode = getMetaData()->getSqlMode();
             tableSynonym += pszSQLModeString_ls31[iSqlMode];
             tableSynonym += SEPARATOR;
        }

        tableSynonym += genCreateDDL();
        //!! ToDo COMMENT ON
   }
   return writeLine( tableSynonym );

}
/*===========================================================================*
 *     SynonymDef::readSynonymDefResult
 *===========================================================================*/
SAPDB_Bool SynonymDef::readSynonymDefResult( StudioOAL_String *record )
{
   SAPDB_Int2       i;
   StudioOAL_String  s;

  /*-------------------------------------------------------------------------*
   * Fetch the next record.                                                  *
   *-------------------------------------------------------------------------*/
  // SQLFetch
  if (!m_pSynonymDefResult->fetch())
  {
      m_pSynonymDefResult->closeCursor();
      return SAPDB_FALSE;
  }

  /*-------------------------------------------------------------------------*
   * If there are no more records, reading the result is finished.           *
   *-------------------------------------------------------------------------*/
  if (m_pSynonymDefResult->noRows())
  {
     m_pSynonymDefResult->closeCursor();
     return SAPDB_FALSE;
  }

  /*-------------------------------------------------------------------------*
   * Read all columns of the fetched record.                                 *
   *-------------------------------------------------------------------------*/
  for (i = 0; i < m_pSynonymDefResult->getColCount(); i++)
  {
    m_pSynonymDefResult->bindColumnDataAsString (i + 1, s);
    record[i] = s;
  }

  return SAPDB_TRUE;
}
/*===========================================================================*
 *     SynonymDef::readResult()
 *===========================================================================*/
SAPDB_Bool SynonymDef::readResult( StudioOAL_String *record )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    // SYNONYMS  : OWNER, SYNONYMNAME, PUBLIC, TABLEOWNER, TABLENAME, COMMENT

    isOk = MetaDataItem::readResult( record);

    if ( isOk )
    {
         m_owner              = record[0];
         m_synonymName        = record[1];
         m_public             = record[2];
         m_tableowner         = record[3];
         m_tablename          = record[4];
         m_comment            = record[5];
    }

    return isOk;
}
/*===========================================================================*
 *     SynonymDef::writeResult()
 *===========================================================================*/
SAPDB_Bool SynonymDef::writeResult( StudioOAL_String *record )
{
      StudioOAL_String tableSynonym;

      if ( getMetaData()->getExtrMode() == emExtractAsXML_els00 )
      {
           tableSynonym += genCreateXML();
      }

      if ( getMetaData()->getExtrMode() == emExtractAsDDL_els00 )
      {
           tableSynonym  = SEPARATOR;
           tableSynonym += genCreateDDL();
           //!! ToDo COMMENT ON

      }
       return writeLine( tableSynonym );
}
/*===========================================================================*
 *     SynonymDef::genCreateXML()
 *===========================================================================*/
StudioOAL_String SynonymDef::genCreateXML()
{
    // <dbm:SchemaTableSynonyms>

   StudioOAL_String  schemaTableSynonym;

   schemaTableSynonym = "<dbm:TableSynonym oim:id=\"_";
   schemaTableSynonym += string2XML(m_owner);
   schemaTableSynonym += ".";
   schemaTableSynonym += string2XML(m_synonymName);
   schemaTableSynonym += "\" oim:href= \"#_";
   schemaTableSynonym += string2XML(m_tableowner);
   schemaTableSynonym += ".";
   schemaTableSynonym += string2XML(m_tablename);
   schemaTableSynonym += "\" oim:seqno  = \"";
   schemaTableSynonym += "\" dbm:name   = \"";
   schemaTableSynonym += string2XML(m_synonymName);
   schemaTableSynonym += "\" dbm:description = \"";
   schemaTableSynonym += string2XML(m_synonymDefinition);
   schemaTableSynonym += "\" dbm:isSpecification = \"1";
   schemaTableSynonym += "\" dbm:comments = \"";
   schemaTableSynonym += string2XML(m_comment);
   schemaTableSynonym += "\"/>\n";

   return schemaTableSynonym;
}
/*===========================================================================*
 *     SynonymDef::genCreateDDL()
 *===========================================================================*/
StudioOAL_String SynonymDef::genCreateDDL()
{
    // CREATE SYNONYM

   m_synonymDefinition  = "CREATE ";
   m_public.Compare( "NO" )           != 0 ? m_synonymDefinition += m_public : m_synonymDefinition += "";
   m_synonymDefinition += " SYNONYM ";
   m_synonymDefinition += " \"";
   m_synonymDefinition += m_synonymName;
   m_synonymDefinition += "\" FOR \"";
   m_tableowner.Compare( NULL_VALUE ) != 0 ? m_synonymDefinition += m_tableowner : m_synonymDefinition += ""; // !getColumn(4)->getColIsNull()
   m_synonymDefinition += "\".\"";
   m_synonymDefinition += m_tablename;
   m_synonymDefinition += "\"";

   return m_synonymDefinition;
}
/*===========================================================================*
 *    ColumnTypeDef::ColumnTypeDef
 *===========================================================================*/
ColumnTypeDef::ColumnTypeDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
                  :MetaDataItem ( odbcConnection , pMetaData )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("ColumnTypeDef::ColumnTypeDef()");
}
/*===========================================================================*
 *     ColumnTypeDef::ColumnTypeDef
 *===========================================================================*/
ColumnTypeDef::ColumnTypeDef( sapdbwa_DBC & odbcConnection )
                  :MetaDataItem ( odbcConnection )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("ColumnTypeDef::ColumnTypeDef()");
}
/*===========================================================================*
 *     ColumnTypeDef::~ColumnTypeDef
 *===========================================================================*/
ColumnTypeDef::~ColumnTypeDef()
{
}
/*===========================================================================*
 *     ColumnTypeDef::initResultSet
 *===========================================================================*/
SAPDB_Bool ColumnTypeDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    if (  odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        isOk = SAPDB_TRUE;
    }
    return isOk;
}
/*===========================================================================*
 *    ColumnTypeDef::readResult
 *===========================================================================*/
SAPDB_Bool ColumnTypeDef::readResult ( StudioOAL_String *record  )
{
    return MetaDataItem::readResult( record);
}
/*===========================================================================*
 *    ColumnTypeDef::writeResult
 *===========================================================================*/
SAPDB_Bool ColumnTypeDef::writeResult( StudioOAL_String *record  )
{
    ROUTINE_DBG_MEO00 ("ColumnTypeDef::writeResult ()");

    RepServMessages *pMsgInstance = RepServMessages::Instance();

    if ( getMetaData()->getExtrMode() == emExtractAsXML_els00 )
    {

        // SYSODBCTYPES  :  0.TYPE_NAME, 1.DATA_TYPE, 2.PRECISION, 3.LITERAL_PREFIX, 4.LITERAL_SUFFIX, 5.CREATE_PARAMS, 6.NULLABLE, 7.CASE_SENSITIVE, 8.SEARCHABLE, 9.UNSIGNED_ATTRIBUTE, 10.MONEY, 11.AUTO_INCREMENT
        //                 12.LOCAL_TYPE_NAME, 13.MINIMUM_SCALE, 14.MAXIMUM_SCALE, 15.SQL_DATA_TYPE, 16.SQL_DATETIME_SUB, 17.NUM_PREC_RADIX, 18.INTERVAL_PRECISION, 19.REMARKS

        // SQLGetTypeInfo( hStmt, SQL_ALL_TYPES )

        // <data_typ> ::=
        //  CHAR[ACTER] [(<unsigned_integer>)] [ASCII | BYTE | EBCDIC]
        //| VARCHAR     [(<unsigned_integer>)] [ASCII | BYTE | EBCDIC]
        //| LONG [VARCHAR]                     [ASCII | BYTE | EBCDIC]
        //| BOOLEAN
        //| FIXED (<unsigned_integer> [,<unsigned_integer>])
        //| FLOAT (<unsigned_integer>)
        //| INT[EGER] | SMALLINT
        //| DATE | TIME | TIMESTAMP

        StudioOAL_String columntype;
        StudioOAL_String columntypeid;
        StudioOAL_String strLong     = "LONG";
        StudioOAL_String strDouble   = "DOUB";
        StudioOAL_String strUnicode  = "UN";

        columntype  = "<sapdbm:";

        if ( strUnicode.Compare(record[12].SubStr(0,2)) == 0 && record[12].Length() != 7  )
             columntypeid = "UNICODE_VARCHAR" ;
        if ( strUnicode.Compare(record[12].SubStr(0,2)) == 0 && record[12].Length() == 7  )
             columntypeid = "UNICODE" ;

        if ( strDouble.Compare(record[12].SubStr(0,4)) == 0  )
             columntypeid = "DOUBLE_PRECISION";

        if ( strLong  .Compare(record[12].SubStr(0,4)) == 0  && record[12].Length() == 12 )
             columntypeid = "LONG_UNICODE" ;
        if ( strLong  .Compare(record[12].SubStr(0,4)) == 0  && record[12].Length() == 9  )
             columntypeid = "LONG_BYTE" ;
        if ( strLong  .Compare(record[12].SubStr(0,4)) == 0  && record[12].Length() == 4  )
             columntypeid = record[12];

        if ( strLong   .Compare(record[12].SubStr(0,4)) != 0 &&
             strDouble .Compare(record[12].SubStr(0,4)) != 0 &&
             strUnicode.Compare(record[12].SubStr(0,2)) != 0    )
             columntypeid = record[12];

        columntype += columntypeid;

        columntype += " oim:id=\"_";
        columntype += "sapdbm:";
        columntype += columntypeid;
        columntype += "\" oim:label=\"";                                                    // SQLColAttribute
        !getColumn(13)->getColIsNull() ? columntype += record[12] : columntype+= "";        // record[12].Compare( NULL_VALUE )  != 0
        columntype += "\" oim:supertype=\"";
        columntype += "dbm:ColumnType";
        columntype += "\" name=\"";                                                         // SQL_DESC_TYPE(ODBC 3.0), SQL_DESC_TYPE_NAME(ODBC 1.0), SQL_DESC_NAME(ODBC 3.0)
        !getColumn(1)->getColIsNull() ? columntype += record[0]  : columntype+= "";         // SQL_DESC_LABEL(ODBC 2.0) record[0].Compare( NULL_VALUE )   != 0
        columntype += "\" ColumnSize=\"";                                                   // SQL_DESC_LENGTH (ODBC 3.0) ,SQLDescribeCol
        !getColumn(3)->getColIsNull() ? columntype += record[2]  : columntype+= "";         // record[2].Compare( NULL_VALUE )   != 0
        //columntype += " \"IsFixedLength=\"";
        //columntype += record[];
        columntype += "\" LiteralPrefix=\"";                                                // SQL_DESC_LITERAL_PREFIX(ODBC 3.0)
        !getColumn(4)->getColIsNull() ? columntype += record[3]  : columntype+= "";         // record[3].Compare( NULL_VALUE )  != 0
        columntype += "\" LiteralSuffix=\"";                                                // SQL_DESC_LITERAL_SUFFIX(ODBC 3.0)
        !getColumn(5)->getColIsNull() ? columntype += record[4]  : columntype+= "";         // record[4].Compare( NULL_VALUE )  != 0
        columntype += "\" CreateParams=\"";
        !getColumn(6)->getColIsNull() ? columntype += record[5] : columntype+= "";          // record[5].Compare( NULL_VALUE )  != 0
        columntype += "\" IsNullable=\"";                                                   // SQL_DESC_NULLABLE(ODBC 3.0)
        !getColumn(7)->getColIsNull() ? columntype += record[6]  : columntype+= "";         // record[6].Compare( NULL_VALUE )  != 0
        columntype += "\" IsCaseSensitive=\"";                                              // SQL_DESC_CASE_SENSITIVE(ODBC 1.0)
        !getColumn(8)->getColIsNull() ? columntype += record[7]  : columntype+= "";         // record[7].Compare( NULL_VALUE )  != 0
        columntype += "\" Searchable=\"";                                                   // SQL_DESC_SEARCHABLE(ODBC 1.0)
        !getColumn(9)->getColIsNull() ? columntype += record[8] : columntype+= "";          // record[8].Compare( NULL_VALUE )  != 0
        columntype += "\" IsUnsignedAttribute=\"";
        !getColumn(10)->getColIsNull()? columntype += record[9]  : columntype += "";        // record[9].Compare( NULL_VALUE )  != 0
        columntype += "\" IsAutoUniqueValue=\"";                                            // SQL_DESC_AUTO_UNIQUE_VALUE(ODBC 1.0)
        !getColumn(12)->getColIsNull()? columntype += record[11] : columntype+= "";         // record[11].Compare( NULL_VALUE ) != 0
        columntype += "\" MinimumScale=\"";                                                 // SQL_DESC_SCALE(ODBC 3.0)
        !getColumn(14)->getColIsNull()? columntype += record[13]: columntype+= "";          // SQL_DESC_UNSIGNED(ODBC 1.0) record[13].Compare( NULL_VALUE ) != 0
        columntype += "\" MaximumScale=\"";
        !getColumn(15)->getColIsNull()? columntype += record[14]: columntype+= "";          // SQL_DESC_FIXED_PREC_SCALE(ODBC 1.0) record[14].Compare( NULL_VALUE ) != 0
        columntype += "\" IsFixedPrecisionScale=\"";                                        // SQL_DESC_PRECISION(ODBC 3.0)
        !getColumn(3)->getColIsNull() ? columntype += record[2] : columntype+= "";          // record[2].Compare( NULL_VALUE )  != 0

        columntype += "\" IsLong=\"";
        !getColumn(13)->getColIsNull() && strLong.Compare(record[12].SubStr(0,4)) == 0 ? columntype += "1" : columntype += "0"; // record[12].Compare( NULL_VALUE ) != 0

        columntype += "\"/>";

        return writeLine( columntype );
    }

    return SAPDB_TRUE;

}
/*===========================================================================*
 *    TriggerDef::TriggerDef
 *===========================================================================*/
TriggerDef::TriggerDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
               :MetaDataItem ( odbcConnection , pMetaData )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("TriggerDef::TriggerDef()");

    m_pTriggerDefResult = new ResultSet ( odbcConnection );

}
/*===========================================================================*
 *     TriggerDef::TriggerDef()
 *===========================================================================*/
TriggerDef::TriggerDef( sapdbwa_DBC & odbcConnection )
               :MetaDataItem ( odbcConnection )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("TriggerDef::TriggerDef()");

    m_pTriggerDefResult = new ResultSet ( odbcConnection );
}

/*===========================================================================*
 *     TriggerDef::~TriggerDef()
 *===========================================================================*/
TriggerDef::~TriggerDef( )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("TriggerDef::~TriggerDef()");

    if ( m_pTriggerDefResult != NULL )
    {
         delete m_pTriggerDefResult;
         m_pTriggerDefResult = NULL;
    }
}
/*===========================================================================*
 *     TriggerDef::initResultSet
 *===========================================================================*/
SAPDB_Bool TriggerDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    if ( odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        StudioOAL_String  triggerDef("SELECT DEFINITION, TRIGGERNAME, TABLENAME, COMMENT, OWNER "
                                     "FROM DOMAIN.TRIGGERS "
                                     "WHERE DEFINITION IS NOT NULL AND OWNER = ? AND TABLENAME = ?");

        // SQLAllocStmt     SQLPrepare
        // SQLNumParams     SQLDescribeParam SQLBindParameter
        // SQLNumResultCols SQLDescribeCol   SQLBindCol
        isOk = m_pTriggerDefResult->init(triggerDef);
        if (SAPDB_FALSE == isOk)
        {
            getMetaData()->getError()->setErrorText(getErrorText() );
            getMetaData()->getError()->isError     (isError     () );
        }
    }
    return isOk;
}
/*===========================================================================*
 *     TriggerDef::readTriggerDefinition
 *===========================================================================*/
SAPDB_Bool TriggerDef::readTriggerDefinition( StudioOAL_String owner, StudioOAL_String tablename )
{
   ROUTINE_DBG_MEO00 ("ViewDef::readTriggerDefinition()");

   RepServMessages *pMsgInstance = RepServMessages::Instance();

   SAPDB_Bool isOk = SAPDB_FALSE;

   StudioOAL_String  triggerDef[2];
   StudioOAL_String  record[5];

   triggerDef[0] = owner;
   triggerDef[1] = tablename;

  /*-------------------------------------------------------------------------*
   * Load the trigger definitions from the database.                           *
   *-------------------------------------------------------------------------*/

   if ( !m_pTriggerDefResult->setParamValues( triggerDef ) )
   {
        getMetaData()->getError()->setErrorText(getErrorText() );
        getMetaData()->getError()->isError     (isError     () );
        return SAPDB_FALSE;
   }
   /*-------------------------------------------------------------------------*
    * Execute the prepared statement                                          *
    *-------------------------------------------------------------------------*/
   // SQLExecute
   if ( !m_pTriggerDefResult->execute() )
   {
        StudioOAL_String errorText = m_pTriggerDefResult->getErrorText();
        SAPDB_Bool      isError   = m_pTriggerDefResult->isError     ();

        getMetaData()->getError()->setErrorText( errorText );
        getMetaData()->getError()->isError     ( isError   );

        return SAPDB_FALSE;
   }
   // SQlFetch SQLFreeStatement
   if ( readTriggerDefResult (record) )
   {
        m_triggerDefinition = record[0];
        m_triggerName       = record[1];
        m_tableName         = record[2];
        m_comment           = record[3];
        m_owner             = record[4];

        isOk = SAPDB_TRUE;
   }

   return isOk;

}
/*===========================================================================*
 *     TriggerDef::writeTriggerDefinition
 *===========================================================================*/
SAPDB_Bool TriggerDef::writeTriggerDefinition()
{
   ROUTINE_DBG_MEO00 ("TriggerDef::writeTriggerDefinition");

   RepServMessages *pMsgInstance = RepServMessages::Instance();

   SAPDB_Bool isOk = SAPDB_FALSE;

   StudioOAL_String tableTrigger;

   if ( getMetaData()->getExtrMode() == emExtractAsDDL_els00 )
   {
      tableTrigger  = SEPARATOR;

      // Special handling of 'foreign' sqlmodes
      if ( getMetaData()->getSqlMode() != cpr_kind_internal )
      {
           SAPDB_Int4 iSqlMode = getMetaData()->getSqlMode();
           tableTrigger += pszSQLModeString_ls31[iSqlMode];
           tableTrigger += SEPARATOR;
      }

      tableTrigger += m_triggerDefinition;

      // COMMENT ON TRIGGER <trigger_name> ON < table_name> IS <comment>
      if ( !m_comment.Empty() && m_comment.Compare( NULL_VALUE) != 0 )
//    if ( !getColumn(4)->getColIsNull() && !m_comment.Empty() ) // record[3]!= NULL_VALUE
      {
           tableTrigger += NEW_LINE_LS00;
           tableTrigger += SEPARATOR;
           tableTrigger += "COMMENT ON TRIGGER \"";
           tableTrigger += m_triggerName;
           tableTrigger += "\" ON \"";
           tableTrigger += m_tableName;
           tableTrigger += "\" IS ' ";
           tableTrigger += string2SQL(m_comment);
           tableTrigger += "'";

      }

   }
   if ( getMetaData()->getExtrMode() == emExtractAsXML_els00 )
       tableTrigger += genCreateXML();

   return writeLine( tableTrigger );

}
/*===========================================================================*
 *     TriggerDef::readTriggerDefResult
 *===========================================================================*/
SAPDB_Bool TriggerDef::readTriggerDefResult( StudioOAL_String *record )
{
   SAPDB_Int2       i;
   StudioOAL_String  s;

  /*-------------------------------------------------------------------------*
   * Fetch the next record.                                                  *
   *-------------------------------------------------------------------------*/
  // SQLFetch
  if (!m_pTriggerDefResult->fetch())
  {
      m_pTriggerDefResult->closeCursor();
      return SAPDB_FALSE;
  }

  /*-------------------------------------------------------------------------*
   * If there are no more records, reading the result is finished.           *
   *-------------------------------------------------------------------------*/
  if (m_pTriggerDefResult->noRows())
  {
     m_pTriggerDefResult->closeCursor();
     return SAPDB_FALSE;
  }

  /*-------------------------------------------------------------------------*
   * Read all columns of the fetched record.                                 *
   *-------------------------------------------------------------------------*/
  for (i = 0; i < m_pTriggerDefResult->getColCount(); i++)
  {
    m_pTriggerDefResult->bindColumnDataAsString (i + 1, s);
    record[i] = s;
  }

  return SAPDB_TRUE;
}
/*===========================================================================*
 *     TriggerDef::readResult()
 *===========================================================================*/
SAPDB_Bool TriggerDef::readResult( StudioOAL_String *record )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    isOk = MetaDataItem::readResult( record);

    if ( isOk )
    {
         m_triggerName       = record[1];
         m_owner             = record[4];
         m_triggerDefinition = record[0];

         m_tableName         = record[2] ;
         m_comment           = record[3];

    }

    return isOk;
}
/*===========================================================================*
 *     TriggerDef::writeResult()
 *===========================================================================*/
SAPDB_Bool TriggerDef::writeResult( StudioOAL_String *record )
{
      StudioOAL_String tableTrigger;

      if ( getMetaData()->getExtrMode() == emExtractAsDDL_els00 )
      {
          tableTrigger  = SEPARATOR;
          tableTrigger += record[0];

          // COMMENT ON TRIGGER <trigger_name> ON < table_name> IS <comment>
          if ( !getColumn(4)->getColIsNull() && !record[3].Empty() ) // record[3]!= NULL_VALUE
          {
               tableTrigger += NEW_LINE_LS00;
               tableTrigger += SEPARATOR;
               tableTrigger += "COMMENT ON TRIGGER \"";
               tableTrigger += record[1];
               tableTrigger += "\" ON \"";
               tableTrigger += record[2];
               tableTrigger += "\" IS ' ";
               tableTrigger += string2SQL(record[3]);
               tableTrigger += "'";

          }

      }
      if ( getMetaData()->getExtrMode() == emExtractAsXML_els00 )
           tableTrigger += genCreateXML();

      return writeLine( tableTrigger );
}
/*===========================================================================*
 *     TriggerDef::genCreateXML()
 *===========================================================================*/
StudioOAL_String TriggerDef::genCreateXML()
{
    // <dbm:TableTrigger>

    StudioOAL_String tableTrigger;

   tableTrigger  = "<dbm:DeployedTrigger oim:id=\"_";
   tableTrigger += string2XML( m_owner );
   tableTrigger += ".";
   tableTrigger += string2XML( m_triggerName );
   tableTrigger += ".";
   tableTrigger += string2XML( m_tableName );
   tableTrigger += "\" oim:supertype = \"Trigger";
   tableTrigger += "\" dbm:StatementsLanguage = \"";
   tableTrigger += "\" dbm:Statements         = \"";
   tableTrigger += string2XML ( m_triggerDefinition );
   tableTrigger += "\" dbm:isSpecification = \"1";
   tableTrigger += "\" dbm:comments = \"";
   tableTrigger += string2XML ( m_comment );
   tableTrigger += "\"/>\n";

   //IsDelete, IsInsert, IsUpdate, isQuery, name, ownerScope, Statements, StatementsLanguage

   return tableTrigger;
}
/*===========================================================================*
 *    DBProcedureDef::DBProcedureDef
 *===========================================================================*/
DBProcedureDef::DBProcedureDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
                   :MetaDataItem ( odbcConnection , pMetaData )
{
    m_pGrantDBProcedureDef = new GrantDBProcedureDef( odbcConnection, pMetaData );
}
/*===========================================================================*
 *     DBProcedureDef::DBProcedureDef()
 *===========================================================================*/
DBProcedureDef::DBProcedureDef(sapdbwa_DBC & odbcConnection )
                   :MetaDataItem ( odbcConnection )
{
    m_pGrantDBProcedureDef = new GrantDBProcedureDef( odbcConnection );
}
/*===========================================================================*
 *     DBProcedureDef::~DBProcedureDef()
 *===========================================================================*/
DBProcedureDef::~DBProcedureDef()
{
    if( m_pGrantDBProcedureDef != NULL )
    {
        delete m_pGrantDBProcedureDef;
        m_pGrantDBProcedureDef = NULL;
    }
}
/*===========================================================================*
 *     DBProcedureDef::initResultSet
 *===========================================================================*/
SAPDB_Bool DBProcedureDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    ROUTINE_DBG_MEO00 ("DBProcedureDef::initResult ()");

    SAPDB_Bool isOk = SAPDB_FALSE;

    if ( odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        // CREATE DBPROC
        // DBPROCEDURES : OWNER,DBPROCNAME,PACKAGE,PARAMETER,CREATEDATE,CREATETIME,
        //                EXCECUTION_KIND,SQL_SUPPORT,REMOTE_LOCATION,DEFINITION,COMMENT

/*      StudioOAL_String  dbProceduredef;
        StudioOAL_String  whereClause;

        //!! ToDo PTS 1109226
        dbProceduredef  = "SELECT DEFINITION, DBPROCNAME, OWNER, COMMENT ";
        dbProceduredef += "FROM DOMAIN.DBPROCEDURES ";

        *-------------------------------------------------------------------------*
        * Prepare the WHERE clause for the SQL statements.                        *
        *-------------------------------------------------------------------------*

        whereClause     = " WHERE definition IS NOT NULL ";
        whereClause    += " AND   owner = ? ";

        dbProceduredef += whereClause;
*/
        isOk = SAPDB_TRUE;
    }
    return isOk;
}
/*===========================================================================*
 *     DBProcedureDef::readResult
 *===========================================================================*/
SAPDB_Bool DBProcedureDef::readResult(  StudioOAL_String *record )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    isOk = MetaDataItem::readResult( record);

    if( isOk )
    {
        m_dbprocedureName       = record[1];
        m_owner                 = record[2];
        m_dbprocedureDefinition = record[0];
        m_comment               = record[3];
    }

    return isOk;

}
/*===========================================================================*
 *     DBProcedureDef::writeResult
 *===========================================================================*/
SAPDB_Bool DBProcedureDef::writeResult(  StudioOAL_String *record )
{
      StudioOAL_String dbProcedure;

      if ( getMetaData()->getExtrMode() == emExtractAsDDL_els00 )
      {
          // DEFINITION, DBPROCNAME, OWNER, COMMENT
          dbProcedure  = SEPARATOR;

          // Special handling of 'foreign' sqlmodes
          if ( getMetaData()->getSqlMode() != cpr_kind_internal )
          {
               SAPDB_Int4 iSqlMode = getMetaData()->getSqlMode();
               dbProcedure += pszSQLModeString_ls31[iSqlMode];
               dbProcedure += SEPARATOR;
          }

          dbProcedure += record[0];

          // COMMENT ON DBPROC <dbproc_name> IS <comment>
          if ( !getColumn(4)->getColIsNull() && !record[3].Empty() ) // record[3].Compare( NULL_VALUE ) != 0
          {
               dbProcedure += NEW_LINE_LS00;
               dbProcedure += SEPARATOR;
               dbProcedure += "COMMENT ON DBPROC \"";
               dbProcedure += record[1];
               dbProcedure += "\" IS '";
               dbProcedure += string2SQL(record[3]);
               dbProcedure += "'";

          }
          // GRANT EXECUTE ON <dbproc_name> TO <grantee>,...
          grantDBProcedureExtrCmd( record[1] );
      }
      if ( getMetaData()->getExtrMode() == emExtractAsXML_els00 )
           dbProcedure  = genCreateXML();

      return writeLine(dbProcedure);

}
/*===========================================================================*
 *     DBProcedureDef::genCreateXML()
 *===========================================================================*/
StudioOAL_String  DBProcedureDef::genCreateXML()
{
    // <dbm:StoredProcedure>

    StudioOAL_String dbProcedure;

    dbProcedure  = "<dbm:StoredProcedure oim:id=\"_";
    dbProcedure += string2XML( m_owner );
    dbProcedure += ".";
    dbProcedure += string2XML( m_dbprocedureName );
    dbProcedure += "\" oim:label=\"";
    dbProcedure += string2XML( m_dbprocedureName );
    dbProcedure += "\" dbm:bodyLanguage = \"&lt;create_dbproc_statement&gt;::= see SAPDB reference manual";
    dbProcedure += "\" dbm:body         = \"";
    dbProcedure += string2XML( m_dbprocedureDefinition );
    dbProcedure += "\" dbm:name= \"";
    dbProcedure += string2XML( m_dbprocedureName );
    dbProcedure += "\" dbm:isQuery =\"";
    dbProcedure += "\" dbm:isSpecification = \"1";
    dbProcedure += "\" dbm:comments = \"";
    dbProcedure += string2XML ( m_comment );
    dbProcedure += "\"/>\n";

    return dbProcedure;
}
/*===========================================================================*
 *  DBProcedureDef::grantDBProcedureExtrCmd
 *===========================================================================*/
SAPDB_Int4 DBProcedureDef::grantDBProcedureExtrCmd( StudioOAL_String dbprocname )
{
    ROUTINE_DBG_MEO00 ("DBProcedureDef::grantDBProcedureExtrCmd");

    SAPDB_Int4 rc = errOK_els00;

    // GRANT EXECUTE ON <dbproc_name> TO <grantee>,...
    // <grantee> ::= <usergroup_name> | <user_name> | <role_name> | PUBLIC

    // SYSDD.PRIVILEGES : OWNER, NAME1, NAME2, TYPE, GRANTEE, GRANTEEOWNER,
    //                    PRIVILEGES, GRANTOR, DATE, TIME

    StudioOAL_String  select;
    StudioOAL_String  whereClause;
    StudioOAL_String  record[2];

    StudioOAL_String  grantdbProcedure;

    select  = "SELECT NAME1, GRANTEE FROM SYSDD.PRIVILEGES ";

    /*-------------------------------------------------------------------------*
     * Prepare the WHERE clause for the SQL statements.
     *-------------------------------------------------------------------------*/

    whereClause  = " WHERE type   = 'DBPROC' "; //'SEQUENCE'
    whereClause += "  AND  name1  = '";
    whereClause +=  m_dbprocedureName ;
    whereClause += "' AND  grantee <> '";
    whereClause +=  m_owner;
    whereClause += "'";

    select      += whereClause;

    if ( !m_pGrantDBProcedureDef->executeSQL( select )  )
    {
        rc = STATIC_CAST(SAPDB_Int4, m_pGrantDBProcedureDef->getNativeError());
    }
    else
    {
        while ( m_pGrantDBProcedureDef->readResult (record ) )
        {
            grantdbProcedure  = SEPARATOR;
            grantdbProcedure += "GRANT EXECUTE ON \"";
            grantdbProcedure += record[0];
            grantdbProcedure += "\" TO ";
            grantdbProcedure += record[1];

            m_pGrantDBProcedureDef->writeResult(grantdbProcedure);
        }
    }
    return rc;
}
/*===========================================================================*
 *    GrantDBProcedureDef::GrantDBProcedureDef
 *===========================================================================*/
GrantDBProcedureDef::GrantDBProcedureDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
                        :MetaDataItem   ( odbcConnection , pMetaData )
{
    ROUTINE_DBG_MEO00 ("GrantDBProcedureDef::GrantDBProcedureDef()");
}
/*===========================================================================*
 *    GrantDBProcedureDef::GrantDBProcedureDef
 *===========================================================================*/
GrantDBProcedureDef::GrantDBProcedureDef( sapdbwa_DBC & odbcConnection )
                        :MetaDataItem   ( odbcConnection )
{
    ROUTINE_DBG_MEO00 ("GrantDBProcedureDef::GrantDBProcedureDef()");

}
/*===========================================================================*
 *    GrantDBProcedureDef::GrantDBProcedureDef
 *===========================================================================*/
GrantDBProcedureDef::~GrantDBProcedureDef()
{
    ROUTINE_DBG_MEO00 ("GrantDBProcedureDef::~GrantDBProcedureDef()");
}
/*===========================================================================*
 *     GrantDBProcedureDef::initResultSet
 *===========================================================================*/
SAPDB_Bool GrantDBProcedureDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    ROUTINE_DBG_MEO00 ("GrantDBProcedureDef::initResult ()");

    SAPDB_Bool isOk = SAPDB_FALSE;

    if (  odbcConnection.HDBC() && odbcConnection.HENV() )
        isOk = SAPDB_TRUE;

    return isOk;
}
/*===========================================================================*
 *    GrantDBProcedureDef::readResult
 *===========================================================================*/
SAPDB_Bool GrantDBProcedureDef::readResult ( StudioOAL_String *record  )
{
    ROUTINE_DBG_MEO00 ("GrantDBProcedureDef::readResult ()");

    return MetaDataItem::readResult( record);
}
/*===========================================================================*
 *    GrantDBProcedureDef::writeResult
 *===========================================================================*/
SAPDB_Bool GrantDBProcedureDef::writeResult( StudioOAL_String record  )
{
    ROUTINE_DBG_MEO00 ("GrantDBProcedureDef::writeResult ()");

    return MetaDataItem::writeLine ( record);
}
/*===========================================================================*
 *    IndexDef::IndexDef
 *===========================================================================*/
IndexDef::IndexDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
         :MetaDataItem ( odbcConnection , pMetaData )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("IndexDef::IndexDef()");

    m_pIndexDefResult    = new ResultSet ( odbcConnection );
    m_pIndexColDefResult = new ResultSet ( odbcConnection );
    m_pIndexColDefODBC   = new IndexColumnDefODBC( odbcConnection, pMetaData );
    m_pIndexColDefODBC->setIndexDef( this );
}
/*===========================================================================*
 *     IndexDef::IndexDef()
 *===========================================================================*/
IndexDef::IndexDef( sapdbwa_DBC & odbcConnection )
         :MetaDataItem ( odbcConnection )
{
    // Trace - Writer
    ROUTINE_DBG_MEO00 ("IndexDef::IndexDef()");

    m_pIndexDefResult    = new ResultSet ( odbcConnection );
    m_pIndexColDefResult = new ResultSet ( odbcConnection );
    m_pIndexColDefODBC   = new IndexColumnDefODBC( odbcConnection );

    m_pIndexColDefODBC->setMetaData(getMetaData());
    m_pIndexColDefODBC->setIndexDef( this );

}
/*===========================================================================*
 *     IndexDef::~IndexDef
 *===========================================================================*/
IndexDef::~IndexDef()
{

   ROUTINE_DBG_MEO00 ("IndexDef::~IndexDef()");

   if( m_pIndexColDefODBC != NULL  )
   {
        delete m_pIndexColDefODBC;
        m_pIndexColDefODBC = NULL;
   }
  /*-------------------------------------------------------------------------*
   * Remove ResultSet
   *-------------------------------------------------------------------------*/
   if ( m_pIndexDefResult != NULL )
   {
       delete m_pIndexDefResult;
       m_pIndexDefResult = NULL;
   }
   if ( m_pIndexColDefResult != NULL )
   {
       delete m_pIndexColDefResult;
       m_pIndexColDefResult = NULL;
   }

  /*-------------------------------------------------------------------------*
   * Remove all columns
   *-------------------------------------------------------------------------*/

   IndexColumnDef  *pCol = (IndexColumnDef*)m_IndexColumns.first();

   while (pCol != NULL)
   {
        delete pCol;
        pCol = (IndexColumnDef*)m_IndexColumns.next();
   }
   m_IndexColumns.clear();
}
/*===========================================================================*
 *     IndexDef::initResultSet
 *===========================================================================*/
SAPDB_Bool IndexDef::initResultSet ( sapdbwa_DBC & odbcConnection )
{
    SAPDB_Bool isOk = SAPDB_FALSE;

    if (  odbcConnection.HDBC() && odbcConnection.HENV() )
    {
        // INDEXES: OWNER,TABLENAME,INDEXNAME,TYPE,CREATEDATE,CREATETIME,INDEX_USED, DISABLED, COMMENT
        //<create_index_statement> ::=
        // CREATE [UNIQUE] INDEX <index_name> ON <table_name> (<column_name> [ASC | DESC],...)
        StudioOAL_String  indexDef("SELECT TYPE,INDEXNAME, COMMENT FROM DOMAIN.INDEXES "
                                   "WHERE  OWNER = ? AND TABLENAME = ? AND DISABLED = 'NO'");


        // INDEXCOLUMNS : OWNER,TABLENAME,INDEXNAME,TYPE,COLUMNNAME,SORT,COLUMNNO,DATATYPE,LEN,DISTINCTVALUES,
        //                PAGECOUNT,AVGLISTLENGTH,CREATEDATE,CREATETIME,INDEX_USED, DISABLED, COMMENT
        StudioOAL_String  indexColDef("SELECT OWNER,TABLENAME,INDEXNAME,TYPE,COLUMNNAME,SORT,COMMENT "
                                      "FROM DOMAIN.INDEXCOLUMNS "
                                      "WHERE OWNER = ? AND TABLENAME = ? AND INDEXNAME = ? AND DISABLED = 'NO' "
                                      "ORDER BY COLUMNNO ");

        // SQLAllocStmt     SQLPrepare
        // SQLNumParams     SQLDescribeParam SQLBindParameter
        // SQLNumResultCols SQLDescribeCol   SQLBindCol

        isOk = m_pIndexDefResult->init(indexDef);
        if (SAPDB_TRUE == isOk)
        {
            isOk = m_pIndexColDefResult->init(indexColDef);
        }
        if (SAPDB_FALSE == isOk)
        {
            getMetaData()->getError()->setErrorText(getErrorText());
            getMetaData()->getError()->isError(isError());
        }
    }
    return isOk;
}
/*===========================================================================*
 *     IndexDef::reset()
 *===========================================================================*/
void IndexDef::reset()
{
    ROUTINE_DBG_MEO00 ("IndexDef::reset()");

  /*-------------------------------------------------------------------------*
   * Remove all columns
   *-------------------------------------------------------------------------*/

   IndexColumnDef  *pCol = (IndexColumnDef *)m_IndexColumns.first();

   while (pCol != NULL)
   {
        delete pCol;
        pCol = (IndexColumnDef* )m_IndexColumns.next();
   }
   m_IndexColumns.clear();

}
/*===========================================================================*
 *     IndexDef::readIndexDefinitionDirect
 *===========================================================================*/
SAPDB_Bool IndexDef::readIndexDefinitionDirect(StudioOAL_String& owner,
                                               StudioOAL_String& tablename)
{
    ROUTINE_DBG_MEO00 ("IndexDef::readIndexDefinitionDirect ()");

    StudioOAL_String  record[3];

    // INDICES
    if ( !readResult( record ) )
         return SAPDB_FALSE;

    m_owner     = owner;
    m_tableName = tablename;
    m_indexType = record[0];
    m_indexName = record[1];
    m_comment   = record[2];

    // INDEXCOLUMNS
    readIndexColDefinitionDirect(/*owner, tablename, m_indexName*/);

    return SAPDB_TRUE;
}
/*===========================================================================*
 *    IndexDef::readIndexColDefinitionDirect
 *===========================================================================*/
SAPDB_Bool
IndexDef::readIndexColDefinitionDirect()
{
    ROUTINE_DBG_MEO00 ("IndexDef::readIndexColumnDefinitionDirect ()");

    SAPDB_Bool isOk = SAPDB_FALSE;

    StudioOAL_String  indexColDef;
    StudioOAL_String  whereClause;
    StudioOAL_String  orderClause;
    StudioOAL_String  comment;
    StudioOAL_String  record[4];

    reset();

    /*-------------------------------------------------------------------------*
     * Prepare the WHERE clause for the SQL statements.
     *-------------------------------------------------------------------------*/
     whereClause   = "WHERE tablename = '";
    whereClause  += m_tableName;
    whereClause  += "' AND indexname = '";
    whereClause  += m_indexName;
    whereClause  += "' AND DISABLED = 'NO'";

    if (SAPDB_FALSE == m_owner.Empty())
    {
        whereClause  += " AND owner = '";
        whereClause  += m_owner;
        whereClause  += "'";
    }

    orderClause = " ORDER BY COLUMNNO ";

    // INDEXCOLUMNS: OWNER, TABLENAME, INDEXNAME, TYPE, COLUMNNAME, SORT, COLUMNNO, DATATYPE, LEN, DISTINCTVALUES,
    //               PAGECOUNT, AVGLISTLENGTH, CREATEDATE, CREATETIME, INDEX_USED, DISABLED, COMMENT

    //<create_index_statement> ::=
    // CREATE [UNIQUE] INDEX <index_name> ON <table_name> (<column_name> [ASC | DESC],...)
    indexColDef  =  " SELECT TYPE, COLUMNNAME, SORT, COMMENT FROM DOMAIN.INDEXCOLUMNS ";
    indexColDef += whereClause;
    indexColDef += orderClause;

    IndexColumnDef *pIndexColDef;

    if ( m_pIndexColDefODBC->executeSQL( indexColDef ) )
    {
        while ( m_pIndexColDefODBC->readResult(record) )
        {
            // INDEXCOLUMNS
            pIndexColDef = addColumn();

            pIndexColDef->setOwner     ( m_owner);
            pIndexColDef->setTableName ( m_tableName);
            pIndexColDef->setIndexName ( m_indexName);
            pIndexColDef->setIndexType ( record[0]);

            pIndexColDef->m_column.setName( record[1]);
            pIndexColDef->setSorting      ( record[2]);

            // INDEXCOLUMNS : COMMENT
            if ( record[3].Compare( NULL_VALUE ) != 0 )
                pIndexColDef->setComment ( record[3] );

            isOk = SAPDB_TRUE;
        }
    }
    return isOk;
}
/*===========================================================================*
 *     IndexDef::setIndexParameters
 *===========================================================================*/
SAPDB_Bool IndexDef::setIndexParameters( StudioOAL_String owner ,
                                             StudioOAL_String tablename )
{
   ROUTINE_DBG_MEO00 ("IndexDef::setIndexParameters()");

   RepServMessages *pMsgInstance = RepServMessages::Instance();

   SAPDB_Bool isOk = SAPDB_TRUE;


   StudioOAL_String  indexDef[2];

   reset();

   m_owner     = indexDef[0] = owner;
   m_tableName = indexDef[1] = tablename;

  /*-------------------------------------------------------------------------*
   * Load the index definitions from the database.                           *
   *-------------------------------------------------------------------------*/

   if ( !m_pIndexDefResult->setParamValues( indexDef ) )
   {
        getMetaData()->getError()->setErrorText(getErrorText() );
        getMetaData()->getError()->isError     (isError     () );
        return SAPDB_FALSE;
   }
   /*-------------------------------------------------------------------------*
    * Execute the prepared statement                                          *
    *-------------------------------------------------------------------------*/
   // SQLExecute
   if ( !m_pIndexDefResult->execute() )
   {
        StudioOAL_String errorText = m_pIndexDefResult->getErrorText();
        SAPDB_Bool      isError   = m_pIndexDefResult->isError     ();

        getMetaData()->getError()->setErrorText( errorText );
        getMetaData()->getError()->isError     ( isError   );

        return SAPDB_FALSE;
   }

   return isOk;
}
/*===========================================================================*
 *     IndexDef::readIndexDefinition
 *===========================================================================*/
SAPDB_Bool IndexDef::readIndexDefinition( StudioOAL_String owner ,
                                          StudioOAL_String tablename )
{
   ROUTINE_DBG_MEO00 ("IndexDef::readIndexDefinition()");

   RepServMessages *pMsgInstance = RepServMessages::Instance();

   SAPDB_Bool isOk = SAPDB_FALSE;

   StudioOAL_String  record[6];

   // SQlFetch SQLFreeStatement
   if ( readIndexDefResult (record) )
   {
        m_indexType = record[0];
        m_indexName = record[1];
        m_comment   = record[2];

        isOk = readIndexColDefinition( owner, tablename, m_indexName );
   }

   return isOk;
}
/*===========================================================================*
 *     IndexDef::readIndexDefResult
 *===========================================================================*/
SAPDB_Bool IndexDef::readIndexDefResult(StudioOAL_String *record)
{

   SAPDB_Int2       i;
   StudioOAL_String  s;

  /*-------------------------------------------------------------------------*
   * Fetch the next record.                                                  *
   *-------------------------------------------------------------------------*/
  // SQLFetch
  if (!m_pIndexDefResult->fetch())
  {
      m_pIndexDefResult->closeCursor();
      return SAPDB_FALSE;
  }

  /*-------------------------------------------------------------------------*
   * If there are no more records, reading the result is finished.           *
   *-------------------------------------------------------------------------*/
  if (m_pIndexDefResult->noRows())
  {
     m_pIndexDefResult->closeCursor();
     return SAPDB_FALSE;
  }

  /*-------------------------------------------------------------------------*
   * Read all columns of the fetched record.                                 *
   *-------------------------------------------------------------------------*/
  for (i = 0; i < m_pIndexDefResult->getColCount(); i++)
  {
    m_pIndexDefResult->bindColumnDataAsString (i + 1, s);
    record[i] = s;
  }

  return SAPDB_TRUE;
}
/*===========================================================================*
 *    IndexDef::readIndexColDefinition
 *===========================================================================*/
SAPDB_Bool IndexDef::readIndexColDefinition( StudioOAL_String owner    ,
                                             StudioOAL_String tablename,
                                             StudioOAL_String indexname )
{
    ROUTINE_DBG_MEO00 ("IndexDef::readIndexColDefinition()");

    SAPDB_Bool rcBool = SAPDB_TRUE;

    reset();

    StudioOAL_String record[7];
    StudioOAL_String indexColDef[3];

    indexColDef[0] = owner;
    indexColDef[1] = tablename;
    indexColDef[2] = indexname;

    /*-------------------------------------------------------------------------*
     * Load the indexcolumn definitions from the database.                     *
     *-------------------------------------------------------------------------*/
    rcBool = m_pIndexColDefResult->setParamValues( indexColDef );
    if (SAPDB_TRUE == rcBool)
    {
        /*-------------------------------------------------------------------------*
         * Execute the prepared statement                                          *
         *-------------------------------------------------------------------------*/
        // SQLExecute
        rcBool = m_pIndexColDefResult->execute();
    }

    if (SAPDB_FALSE == rcBool)
    {
        getMetaData()->getError()->setErrorText(getErrorText() );
        getMetaData()->getError()->isError     (isError     () );
        rcBool = SAPDB_FALSE;
    }
    else
    {
        IndexColumnDef *pIndexColDef;

        // SQlFetch SQLFreeStatement
        while(SAPDB_TRUE == (rcBool = readIndexColDefResult(record)) )
        {
            // INDEXCOLUMNS
            pIndexColDef = addColumn();

            pIndexColDef->setOwner     ( record[0]);
            pIndexColDef->setTableName ( record[1]);
            pIndexColDef->setIndexName ( record[2]);
            pIndexColDef->setIndexType ( record[3]);
            pIndexColDef->m_column.setName( record[4]);
            pIndexColDef->setSorting      ( record[5]);

            // INDEXCOLUMNS : COMMENT
            if ( !m_pIndexColDefResult->getColumn(7)->getColIsNull() )
            {
                pIndexColDef->setComment ( record[6] );
            }
        }
    }

    return rcBool;
}
/*===========================================================================*
 *     IndexDef::readIndexColDefResult
 *===========================================================================*/
SAPDB_Bool IndexDef::readIndexColDefResult(StudioOAL_String *record)
{

   SAPDB_Int2       i;
   StudioOAL_String  s;

  /*------------------------------------------------------------------------*
   * Fetch the next record.                                                  *
   *-------------------------------------------------------------------------*/
  // SQLFetch
  if (!m_pIndexColDefResult->fetch())
  {
      m_pIndexColDefResult->closeCursor();
      return SAPDB_FALSE;
  }

  /*-------------------------------------------------------------------------*
   * If there are no more records, reading the result is finished.           *
   *-------------------------------------------------------------------------*/
  if (m_pIndexColDefResult->noRows())
  {
     m_pIndexColDefResult->closeCursor();
     return SAPDB_FALSE;
  }

  /*-------------------------------------------------------------------------*
   * Read all columns of the fetched record.                                 *
   *-------------------------------------------------------------------------*/
  for (i = 0; i < m_pIndexColDefResult->getColCount(); i++)
  {
    m_pIndexColDefResult->bindColumnDataAsString (i + 1, s);
    record[i] = s;
  }

  return SAPDB_TRUE;
}
/*===========================================================================*
 *     IndexDef::writeIndexDefinition
 *===========================================================================*/
SAPDB_Bool IndexDef::writeIndexDefinition()
{
    ROUTINE_DBG_MEO00 ("IndexDef::writeIndexDefinition()");

    StudioOAL_String tableIndices;

    if (emExtractAsDDL_els00 == getMetaData()->getExtrMode())
    {
        if ( m_IndexColumns.size() > 0 )
        {
            tableIndices  = SEPARATOR;

            if (cpr_kind_internal != getMetaData()->getSqlMode())
            {
                SAPDB_Int4 iSqlMode = getMetaData()->getSqlMode();
                tableIndices += pszSQLModeString_ls31[iSqlMode];
                tableIndices += SEPARATOR;
            }

            tableIndices += genCreateStatement();

            // COMMENT ON INDEX <index_name> ON <table_name> IS '  '
            if ( (!m_comment.Empty()) && (0 != m_comment.Compare( NULL_VALUE)) )
            {
                tableIndices += NEW_LINE_LS00;
                tableIndices += SEPARATOR;
                tableIndices += "COMMENT ON INDEX \"";
                tableIndices += m_indexName;
                tableIndices += "\" ON \"";

                if (SAPDB_FALSE == m_owner.Empty())
                {
                    tableIndices += m_owner;
                    tableIndices += "\".\"";
                }

                tableIndices += m_tableName;
                tableIndices += "\" IS '";
                tableIndices += string2SQL(m_comment);
                tableIndices += "'";
            }
        }
    }
    else if (emExtractAsXML_els00 == getMetaData()->getExtrMode())
    {
        tableIndices  += genCreateXML();
    }

    return writeLine(tableIndices);
}
/*===========================================================================*
 *     IndexDef::addColumn
 *===========================================================================*/
IndexColumnDef * IndexDef::addColumn ()
{
    /*-------------------------------------------------------------------------*
     * Create a new column object.                                             *
     *-------------------------------------------------------------------------*/
    IndexColumnDef *pIndexColDef = new IndexColumnDef( );

    /*-------------------------------------------------------------------------*
     * Append the new column object to the columns list.                       *
     *-------------------------------------------------------------------------*/
    m_IndexColumns.append(pIndexColDef);

    return pIndexColDef;
}
/*===========================================================================*
 *     IndexDef::genCreateStatement
 *===========================================================================*/
StudioOAL_String IndexDef::genCreateStatement( )
{
    ROUTINE_DBG_MEO00 ("IndexDef::genCreateStatement ()");

    StudioOAL_String  index;
    IndexColumnDef   *pCol;

    // INDEXCOLUMNS: OWNER, TABLENAME, INDEXNAME, TYPE, COLUMNNAME, SORT, COLUMNNO, DATATYPE, LEN, DISTINCTVALUES,
    //               PAGECOUNT, AVGLISTLENGTH, CREATEDATE, CREATETIME, INDEX_USED, DISABLED, COMMENT

    //<create_index_statement> ::=
    // CREATE [UNIQUE] INDEX <index_name> ON <table_name> (<column_name> [ASC | DESC],...)

    index  = "CREATE ";
    index += m_indexType;
    index += " INDEX ";
    index += "\"";
    index += m_indexName;
    index += "\"";
    index += " ON \"";

    // Include owner name of table to create index on only if the whole catalog is extracted
    if ( (ptAll_els00 == getMetaData()->getPartSpec().psPartType_ls00) &&
         (SAPDB_FALSE == m_owner.Empty() ) )
    {
        index += m_owner;
        index += "\".\"";
    }
    index += m_tableName;
    index += "\" (";

    SAPDB_Int4 iIndexColSize  = m_IndexColumns.size();
    SAPDB_Int4 iIndexColCount = 0;

    // CREATE [UNIQUE] INDEX <index_name> ON <table_name> (<column_name> [ASC | DESC],...)  //!! ToDo
    for ( pCol = (IndexColumnDef *)m_IndexColumns.first();pCol; pCol = (IndexColumnDef *)m_IndexColumns.next())
    {
        iIndexColCount++;

        index += pCol->genCreateStatement ();

        if ( iIndexColCount != iIndexColSize )
        {
            index += ",";
        }
        else
        {
            index += " )";
        }
    }

    return index;
}
/*===========================================================================*
 *     IndexDef::genCreateXML()
 *===========================================================================*/
StudioOAL_String IndexDef::genCreateXML()
{
   ROUTINE_DBG_MEO00 ("IndexDef::genCreateXML()");

   StudioOAL_String  index;

   IndexColumnDef  *pCol;

   // INDEXCOLUMNS : OWNER,TABLENAME,INDEXNAME,TYPE,COLUMNNAME,SORT,COLUMNNO,DATATYPE,LEN,DISTINCTVALUES,
   //                PAGECOUNT,AVGLISTLENGTH,CREATEDATE,CREATETIME,INDEX_USED, DISABLED, COMMENT

   //<create_index_statement> ::=
   // CREATE [UNIQUE] INDEX <index_name> ON <table_name> (<column_name> [ASC | DESC],...)

   // <dbm:DeployedTableIndices>
   index  = "<dbm:Index oim:id = \"_";
   index += string2XML( m_owner );
   index += ".";
   index += string2XML( m_tableName );
   index += ".";
   index += string2XML( m_indexName );
   index += "\" oim:href = \"#_";
   index += string2XML( m_owner );
   index += ".";
   index += string2XML( m_tableName );
   index += "\" dbm:name = \"";
   index += string2XML( m_indexName );
   index += "\" dbm:comment = \"";
   m_comment.Compare( NULL_VALUE ) != 0 ? index += string2XML( m_comment ) : index += string2XML("");
   index += "\" dbm:IsUnique = \"";
   m_indexType.Compare("UNIQUE")   == 0 ? index += "1\""     : index += "0\"";
   index += ">\n";

   index +=  "<dbm:IndexIndexColumns>\n";

   for ( pCol   = (IndexColumnDef *)m_IndexColumns.first();pCol; pCol = (IndexColumnDef *)m_IndexColumns.next())
         index += pCol->genCreateXML();

   index +=  "</dbm:IndexIndexColumns>\n";
   index +=  "</dbm:Index>\n";
   // </dbm:DeployedTableIndices>

   return index;
}
/*===========================================================================*
 *    IndexColumnDefODBC::IndexColumnDefODBC
 *===========================================================================*/
IndexColumnDefODBC::IndexColumnDefODBC( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData  )
                   :MetaDataItem ( odbcConnection , pMetaData )
{
}
/*===========================================================================*
 *     IndexColumnDefODBC::IndexColumnDefODBC
 *===========================================================================*/
IndexColumnDefODBC::IndexColumnDefODBC(  sapdbwa_DBC & odbcConnection )
                   :MetaDataItem ( odbcConnection )
{
}
/*===========================================================================*
 *    IndexColumnDefODBC::~IndexColumnDefODBC
 *===========================================================================*/
IndexColumnDefODBC::~IndexColumnDefODBC()
{
}
/*===========================================================================*
 *     IndexColumnDefODBC::initResultSet
 *===========================================================================*/
SAPDB_Bool IndexColumnDefODBC::initResultSet ( sapdbwa_DBC & odbcConnection )
{
  ROUTINE_DBG_MEO00 ("IndexColumnDefODBC::initResult ()");

  SAPDB_Bool isOk = SAPDB_FALSE;

  if (  odbcConnection.HDBC() && odbcConnection.HENV() )
        isOk = SAPDB_TRUE;
  return isOk;
}
/*===========================================================================*
 *    IndexColumnDef::setComment
 *===========================================================================*/
void  IndexColumnDef::setComment ( StudioOAL_String comment )
{
      m_column.setComment(comment);
}
/*===========================================================================*
 *    IndexColumnDef::genCreateStatement
 *===========================================================================*/
StudioOAL_String IndexColumnDef::genCreateStatement()
{
     StudioOAL_String  indexColumn;

     indexColumn  = "\"";
     indexColumn += m_column.name ();
     indexColumn += "\"";
     indexColumn += "  ";
     indexColumn += m_sorting;

     return indexColumn;
}
/*===========================================================================*
 *    IndexColumnDef::genCreateXML
 *===========================================================================*/
StudioOAL_String IndexColumnDef::genCreateXML()
{
     ROUTINE_DBG_MEO00 ("IndexColumnDef::genCreateXML()");

     StudioOAL_String  indexColumn;

     // <dbm:IndexIndexColumns>

     indexColumn  =  "<dbm:IndexColumn oim:id = \"_";
     indexColumn += string2XML( m_owner );
     indexColumn += ".";
     indexColumn += string2XML( m_tableName );
     indexColumn += ".";
     indexColumn += string2XML( m_indexName );
     indexColumn += ".";
     indexColumn += string2XML( m_column.name () );
     indexColumn += "\" oim:href = \"#_";
     indexColumn += string2XML( m_owner );
     indexColumn += ".";
     indexColumn += string2XML( m_tableName );
     indexColumn += ".";
     indexColumn += string2XML( m_column.name () );
     indexColumn += "\" dbm:name = \"";
     indexColumn += string2XML( m_column.name () );
     indexColumn += "\" dbm:IsAscending = \"";
     m_sorting.Compare("ASC")   == 0 ? indexColumn += "1\"" : indexColumn += "0\"";
     indexColumn += "/>\n";

     // </dbm:IndexIndexColumns>

     return indexColumn;
}

/*===========================================================================*
 *    sapdb_Error::sapdb_Error()
 *===========================================================================*/
sapdb_Error::sapdb_Error()
{
    m_isError    = SAPDB_FALSE;
    m_NativeError= 0;
    m_ErrorPos   = 0;
    m_ReturnCode = 0;
}
/*===========================================================================*
 *    ~sapdb_Error::sapdb_Error()
 *===========================================================================*/
sapdb_Error::~sapdb_Error()
{
}
/*===========================================================================*
 *     END
 *===========================================================================*/

