
#ifndef HLS31_ODBC_RESULT_H
#define HLS31_ODBC_RESULT_H

/*!**********************************************************************

  module: hls31_odbc_Result.h

  -----------------------------------------------------------------------

  responsible:  d033893 and SteffenS

  special area: odbc SAP DB LOADER
  description:  
  version:      7.5.

  see also:

  -----------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

// includes
#include "gls00.h"
#include "hls98msg.h"
// ConnectionSet
#include "hwd07dbc.h"      // sapdbwa_DBCPool     sapdbwa_DBC
// StatementAttribute
#include "gpr00.h"
// ResultSet
#include "SAPDB/SQLStudio/OAL/StudioOAL_WResult.hpp"  // Unicode Version using W Version of ODBC calls
// Table
#include "SQLStudio/TableDefinition/StudioTD_TableDef.h"
// GUID
#include "SAPDB/RunTime/RTE_UniqueId.h"

// forward declarations

class ResultSet          ;

class GUIDGenerator           ;

// classes derived from ResultSet
class MetaDataItem        ;
class TransformationDef   ;
class CatalogLoadDef      ;
class UserModeDef         ;
class CURUserDef          ;
class UserDef             ;
class RoleDef             ;
class TableDef            ;
class ViewDef             ;
class SynonymDef          ;
class TriggerDef          ;
class DBProcedureDef      ;
class GrantDBProcedureDef ;
class IndexDef            ;
class IndexColumnDefODBC  ;
class IndexColumnDef      ;
class ColumnTypeDef       ;
class SequenceValueDef    ;
class SequenceDef         ;
class sapdb_Error             ;

typedef enum 
{
   tmUnknown_els31 = 0,
   tmCreateTable_els31,
   tmExtractTable_els31,
   tmLoadTable_els31,
   tmRestart_els31

} tls31_TransMode;


typedef struct definfo_ls31
{
    tsp00_Uint2       colnum;
    tsp00_Uint2       deflen;       // 1 Byte if type is a function, otherwise string length of user defined value
    tsp7_default_Enum deftype;      // 4 Byte value
    StudioOAL_String  defvalue;     // filled only if deftype = sp7_other_default
} definfo_ls31;


static RTE_UniqueId  hIdManagement;
static SAPDB_Bool    idManagementInitialized = SAPDB_FALSE;

#define ID_INITIAL_STRING            "000000000000000000000000000000000000000000000000"
#define ID_INITIAL                   "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"

#define ID_ROOT                      ID_INITIAL
#define ID_ROOT_STRING               ID_INITIAL_STRING

#define GUID_MAX_ID_LEN              24
#define GUID_MAX_ID_STRING_LEN       2*GUID_MAX_ID_LEN

typedef char                         GUID_Id[GUID_MAX_ID_LEN];
typedef char                         GUID_IdString[GUID_MAX_ID_STRING_LEN+1];

/*===========================================================================*
 *    class GUIDGenerator
 *===========================================================================*/
class GUIDGenerator 
{
protected:
    GUIDGenerator();
public:
    static GUIDGenerator *Instance();

    ~GUIDGenerator();
    SAPDB_Bool Id_Init               ( );
    SAPDB_Bool IdGetNext             ( GUID_Id id );
    void       IdAsString            ( GUID_Id  id , GUID_IdString idString );
    void       IdInitValue           ( GUID_Id  id );
    void       IdStringInitValue     ( GUID_IdString idString );
    SAPDB_Bool IdIsInitialValue      ( GUID_Id id );
    SAPDB_Bool IdStringIsInitialValue( GUID_IdString idString );
    SAPDB_Bool IdsAreIdentical       ( GUID_Id id1, GUID_Id id2 );
    SAPDB_Bool IdStringsAreIdentical ( GUID_IdString idString1, GUID_IdString idString2 );

private:
    static GUIDGenerator  *_guidinstance;

};
/*===========================================================================*
 *    class MetaDataDef 
 *===========================================================================*/
class MetaDataDef 
{
public:
     MetaDataDef( tls00_DBInfo * pDBInfo );
    ~MetaDataDef();


    // Catalog
    void              setSqlMode         ( tpr00_SQLModeEnum catSqlMode ){ m_catSqlMode = catSqlMode;}
    tpr00_SQLModeEnum getSqlMode         (){ return m_catSqlMode;}

    void              setExtrMode        ( tls00_ExtrMode   catextrMode ){ m_catExtrMode = catextrMode;}
    SAPDB_Int4        getExtrMode        (){ return m_catExtrMode;}

    void              setPartSpec        ( tls00_PartSpec & catpartSpec ){m_catPartSpec = catpartSpec;}
    tls00_PartSpec    getPartSpec        (){ return m_catPartSpec ;}

    void              setMaxErrorCount   (SAPDB_Int4 lMaxErrorCount){m_catMaxAdmissibleErrors = lMaxErrorCount;}
    SAPDB_Int4        getMaxErrorCount   (){return m_catMaxAdmissibleErrors;}

    void              setTransMode       ( tls31_TransMode transmode ){m_catTransMode = transmode;}
    tls31_TransMode   getTransMode       (){ return m_catTransMode ;}

    // ConnectionSet
    SAPDB_Bool       initResultSets       ( tls00_DBInfo *pDBInfo );
    
    void             setConnection        ( tls00_DBInfo *pDBInfo ) { m_pDBInfo   = pDBInfo; }
    tls00_DBInfo*    getConnection        (){ return m_pDBInfo; }

    SAPDB_Bool       setODBCDriver        ( tls00_DBInfo *pDBSession     );
    StudioOAL_String getOdbcDriver        (){ return m_odbcDriver    ; }
    // Authorization
    void             setCurrentUser       ( StudioOAL_String& user );
    StudioOAL_String getCurrentUser       ();
    
    sapdb_Error *    getError             () { return m_pError; }

    // Medium
    void            setMedium             ( tls00_FileInfo  &FileSession ){ m_FileSession = FileSession ;}
    tls00_FileInfo  getMedium             (){ return m_FileSession ;}
    SAPDB_Bool      readLine              ( StudioOAL_String &record  );
    SAPDB_Bool      writeLine             ( StudioOAL_String&  record  );


    // Transformation Model
    TransformationDef    * getTransformationModel  () { return m_pTransformationDef;}

    CatalogLoadDef       * getCatalogLoadDef       () { return m_pCatalogLoadDef;}
    UserModeDef          * getUserModeDef          () { return m_pUserModeDef;}
    CURUserDef           * getCURUserDef           () { return m_pCURUserDef;}

    // Relational Model
    UserDef              * getUserDef              () { return m_pUserDef;}
    RoleDef              * getRoleDef              () { return m_pRoleDef;}
    TableDef             * getTableDef             () { return m_pTableDef;}
    TriggerDef           * getTriggerDef           () { return m_pTriggerDef;}
    ViewDef              * getViewDef              () { return m_pViewDef;}
    SynonymDef           * getSynonymDef           () { return m_pSynonymDef;}
    ColumnTypeDef        * getColumnTypeDef        () { return m_pColumnTypeDef;}
    IndexDef             * getIndexDef             () { return m_pIndexDef;}
    SequenceDef          * getSequenceDef          () { return m_pSequenceDef;}
    DBProcedureDef       * getDBProcedureDef       () { return m_pDBProcedureDef;}
    GrantDBProcedureDef  * getGrantDBProcedureDef  () { return m_pGrantDBProcedureDef;}
    
    // Extract Catalog Commands
    SAPDB_Int4 ExtrCatalogCmd           ( StudioOAL_String user );
    SAPDB_Int4 ExtrSchemaCmd            ( StudioOAL_String user );
    SAPDB_Int4 ExtrTableCmd             ( tls00_PartSpec  catpartSpec );

    // Load Catalog Commands
    SAPDB_Int4 LoadCatalogCmd           ( StudioOAL_String user );
    SAPDB_Int4 LoadSchemaCmd            ( StudioOAL_String user );
    SAPDB_Int4 LoadTableCmd             ( tls00_PartSpec  catpartSpec );
    
    SAPDB_Bool writeCatalogHeader       ( );    

    // Extract Authorization Objects
    SAPDB_Int4 schemaExtrCmd            ( StudioOAL_String user  );
    SAPDB_Int4 userExtrCmd              ( tls00_PartSpec catpartSpec );
    SAPDB_Int4 roleExtrCmd              ( tls00_PartSpec catpartSpec );
        
    // Extract Catalog Objects 
    SAPDB_Int4 connectionExtrCmd        ( );
    SAPDB_Int4 columntypesetExtrCmd     ( );
    
     // Relational Model
    SAPDB_Int4 tabletypeExtrCmdDirect   ( tls00_PartSpec  catpartSpec );
    
    SAPDB_Int4 tableExtrCmdExecDirect   ( StudioOAL_String& owner, StudioOAL_String& tablename );
    SAPDB_Int4 tableExtrCmdExec         ( StudioOAL_String& owner, StudioOAL_String& tablename );
    SAPDB_Int4 viewExtrCmdExecDirect    ( StudioOAL_String& owner, StudioOAL_String& viewname  );
    SAPDB_Int4 viewExtrCmdExec          ( StudioOAL_String  owner, StudioOAL_String  viewname  );
    SAPDB_Int4 synonymExtrCmdExecDirect ( StudioOAL_String  owner, StudioOAL_String  tablename );
    SAPDB_Int4 synonymExtrCmdExec       ( StudioOAL_String  owner, StudioOAL_String  tablename );
    SAPDB_Int4 indexExtrCmdExecDirect   ( StudioOAL_String& owner, StudioOAL_String& tablename );
    SAPDB_Int4 indexExtrCmdExec         ( StudioOAL_String  owner, StudioOAL_String  tablename );
    SAPDB_Int4 triggerExtrCmdExecDirect ( StudioOAL_String& owner, StudioOAL_String& tablename );
    SAPDB_Int4 triggerExtrCmdExec       ( StudioOAL_String  owner, StudioOAL_String  tablename );

    SAPDB_Int4 sequenceExtrCmdDirect    ( tls00_PartSpec  catpartSpec );
    SAPDB_Int4 dbprocedureExtrCmdDirect ( tls00_PartSpec  catpartSpec );

    SAPDB_Bool writeCatalogFooter       ( );
    
private:
    // database connectionset for metadata
    StudioOAL_String      m_odbcDriver;

    // database connection for data
    tls00_DBInfo         *m_pDBInfo;

    // transformation model 
    TransformationDef    *m_pTransformationDef;

    // relational model
    CatalogLoadDef       *m_pCatalogLoadDef;
    UserModeDef          *m_pUserModeDef;
    CURUserDef           *m_pCURUserDef;

    UserDef              *m_pUserDef;
    RoleDef              *m_pRoleDef;
    TableDef             *m_pTableDef;
    TriggerDef           *m_pTriggerDef;
    ViewDef              *m_pViewDef;
    SynonymDef           *m_pSynonymDef;
    ColumnTypeDef        *m_pColumnTypeDef;
    IndexDef             *m_pIndexDef;
    SequenceDef          *m_pSequenceDef;
    DBProcedureDef       *m_pDBProcedureDef;
    GrantDBProcedureDef  *m_pGrantDBProcedureDef;
        
    SAPDB_Int4            m_nSchemaCount;
    SAPDB_Int4            m_nTableCount;
    SAPDB_Int4            m_nViewCount;
    SAPDB_Int4            m_nSynonymCount;
    
    sapdb_Error          *m_pError;
    SAPDB_Char            m_ReadWriteErrText[MAX_REPLY_LENGTH_LS00];

    SAPDB_Char            m_ReadBuffer[LINELENGTH_MXSP00];

    // stream connection
    tls00_FileInfo        m_FileSession;

    tls31_TransMode       m_catTransMode;
    tls00_ExtrMode        m_catExtrMode;
    tls00_PartSpec        m_catPartSpec;
    tpr00_SQLModeEnum     m_catSqlMode;
    SAPDB_Int4            m_catMaxAdmissibleErrors;

    StudioOAL_String      m_currentUser;
};

/*===========================================================================*
 *    class ResultSet
 *===========================================================================*/
class ResultSet :  public StudioOAL_WResult
{
public:
    ResultSet ( sapdbwa_DBC & odbcConnection ); 
    virtual ~ResultSet ();
    
};
/*===========================================================================*
 *    class MetaDataItem 
 *===========================================================================*/
class MetaDataItem : public ResultSet
{
public:
    MetaDataItem( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
    MetaDataItem( sapdbwa_DBC & odbcConnection );
    
    virtual ~MetaDataItem();

    void            setMetaData  ( MetaDataDef * pMetaData ){ m_pMetaDataDef = pMetaData;}
    MetaDataDef   * getMetaData(){ return m_pMetaDataDef  ;}
        
    virtual SAPDB_Bool initResultSet ( sapdbwa_DBC & odbcConnection ) = 0;
        
    SAPDB_Bool executeSQL            ( StudioOAL_String& statement);
    SAPDB_Bool executeSQL            ( const char*       statement);
    SAPDB_Bool readResult            ( StudioOAL_String *record  );
    SAPDB_Bool writeLine             ( StudioOAL_String&  record  );

    SAPDB_Bool existsTable           ( StudioOAL_String tablename  );
    SAPDB_Bool existsDBProc          ( StudioOAL_String dbprocname );

    StudioOAL_String  string2XML     ( StudioOAL_String  record  );
    StudioOAL_String& string2SQL     ( StudioOAL_String& record  );
        
private:
    MetaDataDef    *m_pMetaDataDef;

};

/*===========================================================================*
 *    class TransformationDef 
 *===========================================================================*/
class TransformationDef : public MetaDataItem
{
public:
   TransformationDef( sapdbwa_DBC & odbcConnection , MetaDataDef * pMetaData );
   TransformationDef( sapdbwa_DBC & odbcConnection  );
  ~TransformationDef();

   // 1.Direct SQL Statement
   SAPDB_Bool initResultSet ( sapdbwa_DBC & odbcConnection );

   SAPDB_Bool readResult             ( StudioOAL_String *record );
   SAPDB_Bool writeResult            ( StudioOAL_String  record );

   SAPDB_Bool initTransformationStep ( StudioOAL_String *record );
   SAPDB_Int4 initTransformation     ();
   void       freeTransformation     ( tls00_ScanResult Type );
   SAPDB_Int4 switchUser             ( StudioOAL_String oldUser , StudioOAL_String newUser, tsp00_Addr ErrText );
   
   SAPDB_Int4 getObjectCount()      { return m_nObjectCount; }

   SAPDB_Bool updateTaskStatistic   ();
   SAPDB_Bool updateDatTask         ( StudioOAL_String *parameters );
   SAPDB_Bool updateBegin           ( StudioOAL_String  owner, StudioOAL_String tablename );
   SAPDB_Bool updatePages           ( StudioOAL_String  owner, StudioOAL_String tablename );
   SAPDB_Bool updateRecords         ( StudioOAL_String  owner, StudioOAL_String tablename );
   SAPDB_Bool updateExclude         ( StudioOAL_String  owner, StudioOAL_String tablename );
   SAPDB_Bool updateRestart         ( StudioOAL_String  owner, StudioOAL_String tablename );
   SAPDB_Bool updateDatStream       ( StudioOAL_String *parameters );
   SAPDB_Bool updateHeader          ( StudioOAL_String *parameters );
   SAPDB_Bool updateTrailer         ( StudioOAL_String *parameters );

   SAPDB_Bool updateEnd             ( StudioOAL_String&  owner, StudioOAL_String& tablename );
   SAPDB_Bool updatePerformance     ( StudioOAL_String   owner, StudioOAL_String tablename );
   
   SAPDB_Bool updateExtrData        ( StudioOAL_String *parameters );
   SAPDB_Bool updateLoadData        ( StudioOAL_String *parameters );
   
   SAPDB_Bool updateCatTask         ( StudioOAL_String *parameters );
   SAPDB_Bool updateCat             ( StudioOAL_String *parameters );
   SAPDB_Bool updateCatStream       ( StudioOAL_String *parameters );

   SAPDB_Bool unload         ( sapdbwa_DBC & odbcConnection );

   void              genLoaderStatement       ();
   void              genInverseLoaderStatement( tls00_DatExtrCmd *& pDatExtrCmd, tls00_DextractRec  *pDatExtrRec );

   // transformation statement and command of loader
   StudioOAL_String  m_statement;
   StudioOAL_String  m_inverseStatement;
   tls00_Command    *m_pCommand;

   // transformationpackage table columns for catalog
   SAPDB_Int4        m_nTaskID;
   SAPDB_Int4        m_nObjectCount;
   SAPDB_Int4        m_nTableCount;
   SAPDB_Int4        m_nViewCount;
   SAPDB_Int4        m_nSynonymCount;

   // transformationpackage table columns for data
   StudioOAL_String  m_taskid;
   StudioOAL_String  m_owner;                  
   StudioOAL_String  m_tablename;              
   StudioOAL_String  m_datastreamname;             
   StudioOAL_String  m_datastreamebid;
   tls00_LargeNumber m_headerpos;
   StudioOAL_String  m_headerpos_block;
   StudioOAL_String  m_headerpos_byte;
   tls00_LargeNumber m_datapos;
   StudioOAL_String  m_datapos_block;
   StudioOAL_String  m_datapos_byte;
   tls00_LargeNumber m_trailerpos;
   StudioOAL_String  m_trailerpos_block;
   StudioOAL_String  m_trailerpos_byte;
   SAPDB_Bool        m_exclude;
   tsp00_Longint     m_extractcount;
   tsp00_Longint     m_loadcount;

   //transformationpackage table columns :
   StudioOAL_String  m_packageid;
   StudioOAL_String  m_servernode;
   StudioOAL_String  m_serverdb;
   StudioOAL_String  m_username;
   StudioOAL_String  m_codetype;
   StudioOAL_String  m_storagedevice;
   StudioOAL_String  m_transformation;
   StudioOAL_String  m_partspec;
   StudioOAL_String  m_stepid;
   StudioOAL_String  m_tabletype;
   StudioOAL_String  m_catalogstreamname;
   StudioOAL_String  m_catalogstreamtype;
   StudioOAL_String  m_catalogstreamebid;
   StudioOAL_String  m_catalogstreamformat;
   StudioOAL_String  m_datastreamtype;
   StudioOAL_String  m_datastreamformat;
   StudioOAL_String  m_restart;
   StudioOAL_String  m_restore;
   StudioOAL_String  m_starttime;
   StudioOAL_String  m_endtime;

#ifndef ODBC_PREPARED
   ResultSet        *m_pUpdate;
   ResultSet        *m_pUpdateCat;
   ResultSet        *m_pUpdatePages;
   ResultSet        *m_pUpdateRecords;
   ResultSet        *m_pUpdateRestart;
   ResultSet        *m_pUpdateBegin;
   ResultSet        *m_pUpdateHeader;
   ResultSet        *m_pUpdateData; 
   ResultSet        *m_pUpdateEnd;
#endif // ODBC_PREPARED

private:
    SAPDB_Bool CreateLoaderSystemObjects();
    SAPDB_Bool LoadTransformationPackage(StudioOAL_String& SaveCatalogStmt);
};

/*===========================================================================*
 *    class CatalogLoadDef 
 *===========================================================================*/
class CatalogLoadDef    : public MetaDataItem
{
public:
   CatalogLoadDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   CatalogLoadDef( sapdbwa_DBC & odbcConnection );
  ~CatalogLoadDef();

   void             setSQLMode ( StudioOAL_String  record );
   StudioOAL_String getSQLMode ( );

   SAPDB_Bool initResultSet    ( sapdbwa_DBC & odbcConnection );
   SAPDB_Bool readResult       ( StudioOAL_String *record );
   SAPDB_Bool writeResult      ( StudioOAL_String  record );

private:
   StudioOAL_String m_servernode;
   StudioOAL_String m_dbname;
   StudioOAL_String m_username;
   StudioOAL_String m_sqlmode;

};

// CatalogObjects created by Autorization Definition Statements

/*===========================================================================*
 *    class ConnectionDef 
 *===========================================================================*/
class ConnectionDef :  public MetaDataItem
{
public:
   ConnectionDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   ConnectionDef( sapdbwa_DBC & odbcConnection );
  ~ConnectionDef();

   SAPDB_Bool initResultSet ( sapdbwa_DBC & odbcConnection );
   SAPDB_Bool readResult    ( StudioOAL_String *record      );

};

/*===========================================================================*
 *    class UserDef 
 *===========================================================================*/
class UserDef :  public MetaDataItem
{
public:
   UserDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   UserDef( sapdbwa_DBC & odbcConnection );
  ~UserDef();

   SAPDB_Bool initResultSet ( sapdbwa_DBC & odbcConnection );
   SAPDB_Bool readResult    ( StudioOAL_String *record  );
   SAPDB_Bool writeResult   ( StudioOAL_String *record ,tls00_ExtrMode catextrMode );

private:
   StudioOAL_String m_owner;
   StudioOAL_String m_groupName;
   StudioOAL_String m_userName;
   StudioOAL_String m_userMode;
   StudioOAL_String m_permLimit;
   StudioOAL_String m_tempLimit;
   StudioOAL_String m_maxTimeOut;
   StudioOAL_String m_costWarning;
   StudioOAL_String m_costLimit;
   StudioOAL_String m_connectMode;
   StudioOAL_String m_comment;

};
/*===========================================================================*
 *    class CURUserDef 
 *===========================================================================*/
class CURUserDef :  public MetaDataItem
{
public:
   CURUserDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   CURUserDef( sapdbwa_DBC & odbcConnection );
  ~CURUserDef();

   SAPDB_Bool initResultSet ( sapdbwa_DBC & odbcConnection );
   SAPDB_Bool writeResult   ( StudioOAL_String  record      );

private:
   StudioOAL_String  m_username;

};
/*===========================================================================*
 *    class RoleDef 
 *===========================================================================*/
class RoleDef :  public MetaDataItem 
{
public:
   RoleDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   RoleDef( sapdbwa_DBC & odbcConnection );
  ~RoleDef();

   SAPDB_Bool initResultSet ( sapdbwa_DBC & odbcConnection );
   SAPDB_Bool readResult    ( StudioOAL_String *record  );
   SAPDB_Bool writeResult   ( StudioOAL_String *record  );

private:
    StudioOAL_String m_role;
    StudioOAL_String m_passwordrequired;

};

// CatalogObjects created by Data Definition Statements

/*===========================================================================*
 *    class TableDef 
 *===========================================================================*/
class TableDef : public MetaDataItem ,
                 public StudioTD_TableDef      
{
public:
   TableDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   TableDef( sapdbwa_DBC & odbcConnection );
  ~TableDef();

   SAPDB_Int4 Init(const StudioOAL_String &OwnerName, const StudioOAL_String &TableName);

   // 1.Direct SQL Statement
   SAPDB_Int4 readTableDefinitionDirect (StudioOAL_String &owner, StudioOAL_String &tablename);

   SAPDB_Int4 getListOfDefaultValues();
   SAPDB_Int4 getListOfConstraintValues();

   SAPDB_Bool executeSQL                ( StudioOAL_String& statement );
   SAPDB_Bool executeSQL                ( const char*       statement );
   SAPDB_Bool readResult                ( StudioOAL_String *record , SAPDB_Bool* bIsNull );
   
   // 2. Prepared SQL Statement
   SAPDB_Bool initResultSet             ( sapdbwa_DBC & odbcConnection );

   SAPDB_Bool readTableDefinition       ( StudioOAL_String owner, StudioOAL_String tablename );
   SAPDB_Bool writeTableDefinition( );
   SAPDB_Bool readColumnDefResult       ( StudioOAL_String *record ) ;
   SAPDB_Bool readConstraintDefResult   ( StudioOAL_String *record ) ;
   SAPDB_Bool readForeignKeyDefResult   ( StudioOAL_String *record ) ;
   SAPDB_Bool readTableAttrDefResult    ( StudioOAL_String *record ) ;

   StudioOAL_String   genCreateStatement();
   
private:
    SAPDB_Int4 CheckForAmbiguousTableNames();

    ResultSet        *m_pColumnDefResult;     
    ResultSet        *m_pConstraintDefResult; 
    ResultSet        *m_pForeignKeyDefResult; 
    ResultSet        *m_pTableAttrDefResult;

    StudioOAL_String  m_tableName ;
    StudioOAL_String  m_owner;
   
};
/*===========================================================================*
 *    class IndexDef 
 *===========================================================================*/
class IndexDef      : public MetaDataItem
{
public:
   IndexDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   IndexDef( sapdbwa_DBC & odbcConnection );
  ~IndexDef();

   // 1.Direct SQL Statement
   SAPDB_Bool readIndexDefinitionDirect    ( StudioOAL_String& owner, StudioOAL_String& tablename);
   SAPDB_Bool readIndexColDefinitionDirect ( );

   // 2. Prepared SQL Statement
   SAPDB_Bool initResultSet                ( sapdbwa_DBC & odbcConnection );
   SAPDB_Bool readIndexDefResult           ( StudioOAL_String * record );
   SAPDB_Bool readIndexColDefResult        ( StudioOAL_String * record );

   SAPDB_Bool setIndexParameters           ( StudioOAL_String owner, StudioOAL_String tablename );
   SAPDB_Bool readIndexDefinition          ( StudioOAL_String owner, StudioOAL_String tablename );
   SAPDB_Bool readIndexColDefinition       ( StudioOAL_String owner, StudioOAL_String tablename, StudioOAL_String indexname );
   
   SAPDB_Bool writeIndexDefinition         ( );

   StudioOAL_String      genCreateStatement( );
   StudioOAL_String      genCreateXML();
   
   IndexColumnDef       *addColumn ();
   void                  reset     ();


   IndexColumnDefODBC   *m_pIndexColDefODBC;
   StudioOAL_List        m_IndexColumns; 

private:
   ResultSet        *m_pIndexDefResult;  
   ResultSet        *m_pIndexColDefResult;

   StudioOAL_String  m_tableName ;
   StudioOAL_String  m_owner;
   StudioOAL_String  m_indexName;
   StudioOAL_String  m_indexType;
   StudioOAL_String  m_comment;
};
/*===========================================================================*
 *    class IndexColumnDefODBC 
 *===========================================================================*/
class IndexColumnDefODBC : public MetaDataItem
{
public:
    IndexColumnDefODBC( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
    IndexColumnDefODBC( sapdbwa_DBC & odbcConnection );
   ~IndexColumnDefODBC();

   SAPDB_Bool initResultSet( sapdbwa_DBC & odbcConnection );

   void       setIndexDef( IndexDef *pIndexDef) { m_pIndexDef = pIndexDef;}  
   IndexDef  *getIndexDef() { return m_pIndexDef;}

   IndexDef  *m_pIndexDef;
};
/*===========================================================================*
 *    class IndexColumnDef
 *===========================================================================*/
class IndexColumnDef 
{
public:
   IndexColumnDef() {;}
   ~IndexColumnDef(){;}

   StudioOAL_String  genCreateStatement();
   StudioOAL_String  genCreateXML();

   void              setOwner     ( StudioOAL_String owner     ){m_owner     = owner    ;}
   void              setTableName ( StudioOAL_String tableName ){m_tableName = tableName;}
   void              setIndexName ( StudioOAL_String indexName ){m_indexName = indexName;}
   void              setIndexType ( StudioOAL_String indextype ){m_indexType = indextype;}
   void              setSorting   ( StudioOAL_String sorting   ){m_sorting   = sorting  ;}
   StudioOAL_String  getSorting   ( ){ return m_sorting ;}
   void              setComment   ( StudioOAL_String comment );
   StudioOAL_String  getComment   ( ){ return m_comment ;}

   StudioTD_ColumnDef m_column;

   StudioOAL_String   m_owner;
   StudioOAL_String   m_tableName ;
   StudioOAL_String   m_indexName;
   StudioOAL_String   m_indexType;
   StudioOAL_String   m_sorting;
   StudioOAL_String   m_comment;
};
/*===========================================================================*
 *    class SynonymDef 
 *===========================================================================*/
class SynonymDef  :  public MetaDataItem
{
public:
   SynonymDef ( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   SynonymDef ( sapdbwa_DBC & odbcConnection );
  ~SynonymDef ();

   // 1.Direct SQL Statement
   SAPDB_Bool readResult    ( StudioOAL_String *record );
   SAPDB_Bool writeResult   ( StudioOAL_String *record );
   // 2. Prepared SQL Statement
   
   SAPDB_Bool initResultSet        ( sapdbwa_DBC & odbcConnection );

   SAPDB_Bool readSynonymDefinition( StudioOAL_String owner, StudioOAL_String tablename );
   SAPDB_Bool writeSynonymDefinition( );
   SAPDB_Bool readSynonymDefResult ( StudioOAL_String *record ) ;

   StudioOAL_String  genCreateXML ( );
   StudioOAL_String  genCreateDDL ( );

private:
   ResultSet*        m_pSynonymDefResult ;
   StudioOAL_String  m_synonymName ;
   StudioOAL_String  m_owner;
   StudioOAL_String  m_synonymDefinition;

   StudioOAL_String  m_tablename;
   StudioOAL_String  m_tableowner;
   StudioOAL_String  m_public;
   StudioOAL_String  m_comment;

};
/*===========================================================================*
 *    class ViewDef 
 *===========================================================================*/
class ViewDef :  public MetaDataItem
{
public:
   ViewDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   ViewDef( sapdbwa_DBC & odbcConnection );
  ~ViewDef();

   // 1.Direct SQL Statement
   SAPDB_Bool readResult    ( StudioOAL_String *record );
   SAPDB_Bool writeResult   ( StudioOAL_String *record );

   // 2. Prepared SQL Statement
   SAPDB_Bool initResultSet      ( sapdbwa_DBC & odbcConnection );

   SAPDB_Bool readViewDefinition ( StudioOAL_String owner, StudioOAL_String tablename );
   SAPDB_Bool writeViewDefinition( );
   SAPDB_Bool readViewDefResult  ( StudioOAL_String *record ) ;

   StudioOAL_String  genCreateXML ( );

private:
   ResultSet*        m_pViewDefResult ;
   StudioOAL_String  m_viewName ;
   StudioOAL_String  m_owner;
   StudioOAL_String  m_viewDefinition;

};
/*===========================================================================*
 *    class TriggerDef 
 *===========================================================================*/
class TriggerDef      : public MetaDataItem
{
public:
   TriggerDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   TriggerDef( sapdbwa_DBC & odbcConnection );
  ~TriggerDef();

   // 1.Direct SQL Statement
   SAPDB_Bool readResult    (  StudioOAL_String *record );
   SAPDB_Bool writeResult   (  StudioOAL_String *record );

   // 2. Prepared SQL Statement
   SAPDB_Bool initResultSet ( sapdbwa_DBC & odbcConnection );

   SAPDB_Bool readTriggerDefinition ( StudioOAL_String owner, StudioOAL_String tablename );
   SAPDB_Bool writeTriggerDefinition();
   SAPDB_Bool readTriggerDefResult  ( StudioOAL_String *record ) ;
   void              reset();
      
   StudioOAL_String  genCreateXML();
   StudioOAL_String  genCreateStatement ();

private:
   ResultSet*        m_pTriggerDefResult ;
   StudioOAL_String  m_triggerName;
   StudioOAL_String  m_owner;
   StudioOAL_String  m_triggerDefinition;

   StudioOAL_String  m_tableName ;
   StudioOAL_String  m_comment;
};
/*===========================================================================*
 *    class DBProcedureDef 
 *===========================================================================*/
class DBProcedureDef  : public MetaDataItem
{
public:
   DBProcedureDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   DBProcedureDef( sapdbwa_DBC & odbcConnection );
  ~DBProcedureDef();

   // 1.Direct SQL Statement
   SAPDB_Bool readResult        ( StudioOAL_String *record );
   SAPDB_Bool writeResult       ( StudioOAL_String *record );

   // 2. Prepared SQL Statement
   SAPDB_Bool initResultSet     ( sapdbwa_DBC & odbcConnection );
  
   StudioOAL_String        genCreateXML();

   SAPDB_Int4 grantDBProcedureExtrCmd  ( StudioOAL_String dbprocedureName );
   GrantDBProcedureDef * m_pGrantDBProcedureDef;
 
private:
   StudioOAL_String       m_dbprocedureName;
   StudioOAL_String       m_owner;
   StudioOAL_String       m_dbprocedureDefinition;

   StudioOAL_String       m_comment;
};
/*===========================================================================*
 *    class GrantDBProcedureDef 
 *===========================================================================*/
class GrantDBProcedureDef : public MetaDataItem
{
public:
   GrantDBProcedureDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   GrantDBProcedureDef( sapdbwa_DBC & odbcConnection );
  ~GrantDBProcedureDef();

   // 1.Direct SQL Statement
   SAPDB_Bool readResult    ( StudioOAL_String *record );
   SAPDB_Bool writeResult   ( StudioOAL_String  record );

   // 2. Prepared SQL Statement
   SAPDB_Bool initResultSet ( sapdbwa_DBC & odbcConnection );
   
private:
   StudioOAL_String        m_grantdbprocedureDefinition;

};
/*===========================================================================*
 *    class ColumnTypeDef
 *===========================================================================*/
class ColumnTypeDef : public MetaDataItem
{
public:
    ColumnTypeDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
    ColumnTypeDef( sapdbwa_DBC & odbcConnection );
   ~ColumnTypeDef();

   SAPDB_Bool initResultSet      ( sapdbwa_DBC & odbcConnection );
   SAPDB_Bool readResult         ( StudioOAL_String *record );
   SAPDB_Bool writeResult        ( StudioOAL_String *record );

private:
   StudioOAL_String m_typeName;
   StudioOAL_String m_dataType;
   StudioOAL_String m_precision;
   StudioOAL_String m_literalPrefix;
   StudioOAL_String m_literalSuffix;
   StudioOAL_String m_createParams;
   StudioOAL_String m_isNullable;
   StudioOAL_String m_isCaseSensitive;
   StudioOAL_String m_isSearchable;
   StudioOAL_String m_unsignedAttribute;
   StudioOAL_String m_money;
   StudioOAL_String m_autoIncrement;
   StudioOAL_String m_localTypeName;
   StudioOAL_String m_minimumScale;
   StudioOAL_String m_maximumScale;

};
/*===========================================================================*
 *    class SequenceDef 
 *===========================================================================*/
class SequenceDef :  public MetaDataItem
{
public:
   SequenceDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
   SequenceDef( sapdbwa_DBC & odbcConnection );
  ~SequenceDef();
 
   SAPDB_Bool initResultSet ( sapdbwa_DBC & odbcConnection );
   SAPDB_Bool readResult    ( StudioOAL_String *record  );
   SAPDB_Bool writeResult   ( StudioOAL_String *record  );

   SequenceValueDef * m_pSequenceValueDef;

private:
   StudioOAL_String m_sequencename;
   StudioOAL_String m_owner;
   StudioOAL_String m_incrementby;
   StudioOAL_String m_lastnumber;
   StudioOAL_String m_nextvalue;
   StudioOAL_String m_maxvalue;
   StudioOAL_String m_minvalue;
   StudioOAL_String m_cycleflag;
   StudioOAL_String m_cachesize;
   StudioOAL_String m_orderflag;
   
};

/*===========================================================================*
 *    class SequenceValueDef
 *===========================================================================*/
class SequenceValueDef : public MetaDataItem
{
public:
    SequenceValueDef( sapdbwa_DBC & odbcConnection, MetaDataDef * pMetaData );
    SequenceValueDef( sapdbwa_DBC & odbcConnection );
   ~SequenceValueDef();

   SAPDB_Bool initResultSet      ( sapdbwa_DBC & odbcConnection );
   SAPDB_Bool readResult         ( StudioOAL_String *record );

private:
	StudioOAL_String m_lastnumber;

};

/*===========================================================================*
 *    class sapdb_Error
 *===========================================================================*/
class sapdb_Error
{
public:
     sapdb_Error( );
    ~sapdb_Error( );

    inline void             setErrorText ( StudioOAL_String errorText ) { m_ErrorText = errorText; }
    inline StudioOAL_String getErrorText ()                             { return m_ErrorText ; }
    inline void             isError      ( SAPDB_Bool     isError )     { m_isError = isError; }
    inline SAPDB_Bool       isError      ()                             { return m_isError;}

    inline void             setReturnCode (SAPDB_Int4 lReturnCode)      { m_ReturnCode = lReturnCode;}
    inline SAPDB_Int4       getReturnCode ()                            { return m_ReturnCode;}

    inline void             setNativeError(SAPDB_Int4 lNativeError)     { m_NativeError = lNativeError;}
    inline SAPDB_Long       getNativeError()                            { return m_NativeError;}

    SAPDB_Bool       m_isError    ;
    SAPDB_Long       m_NativeError;
    SAPDB_Int4       m_ErrorPos  ;
    SQLRETURN        m_ReturnCode ;
    StudioOAL_String m_ErrorText;
    StudioOAL_String m_NativeErrorAsString;
};

#endif


/*===========================================================================*
 *     End
 *===========================================================================*/