/*
  -----------------------------------------------------------------------------

  module: hls14_parse.h

  -----------------------------------------------------------------------------

  responsible:  SteffenS and d033893

  special area: SAP DB LOADER

  description:  definition of parser class

  version:      7.5.

  -----------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#ifndef HLS14_PARSE_H
#define HLS14_PARSE_H

#include "gls00.h"

extern "C" tin_global_in_vars i01g;

template <class T>
void ls14_TemplateNewStruct(T* &parameter)
{
    parameter = new T;
    if (NULL != parameter)
    {
        memset(parameter, DEF_BYTE_LS00, sizeof(T));
    }
}


int ls14ParseLoadCommand(tls00_Command* SvrCmd, tls00_DBInfo*   DBInfo);




class ReplicationParser
{
public:
    ReplicationParser( tls00_Command*   SvrCmd, tls00_DBInfo*   DBInfo );
   ~ReplicationParser();
    int StartParsing(void * & StructToBeDefined);
    int ls14GetErrorCode();

private:

    // Functions from hls12_Expars.h
    void ls14_SetDBName (tls00_SessionInfo* Session, tls00_String DBName);
    void ls14_SetDBNode (tls00_SessionInfo* Session, char* pOldDBNode, tls00_String *pNewDBNode = NULL);
    void ls14_SetUser   (tls00_SessionInfo* Session, tls00_String UserName, tls00_String UserPwd);
    int  ls14_ParseUnknownStmt();

    // Functions from hls11_inpars.h
    int  ls14_SpecialDateTimeParse  (tls00_DateTimeSpec* pSpec, short Type);
    int  ls14_CheckFormat           (tls00_MultColSpec* pMultCol, bool bCompressed, bool bFormatted, bool & bBinary);
    
    tsp00_Int4
    ls14_CheckFormatEx(tls00_MultColSpec *pMultCol,  //!!RECORDS
                       bool              bFormatted,
                       bool &            bBinary,
                       bool              bCompact);

    tsp00_Int4 
    ls14_CheckSelOrderBy( tls00_PartSpec *pPartSpec, tls00_String* OrderByStatement);

    void ls14_ConvertSpecifications (tls00_FileSpec* pFileSpec, tls00_MultColSpec* pMultColSpec);
    int  ls14_ParseSelect           (tls00_String* SelectStatement);

    // found in both moduls
    void ls14_ShowError(const ErrorNumbers lErrorNumber);

    // modules for working on rules
    tsp00_Int4 ls14_FillLongfileStruct(tls00_DeviceType  deviceType,
                                       tsp00_Int4        lColumnId,
                                       tls00_String      *pFileName,
                                       tls00_CodeSpec    *pCodeSpec,
                                       tls00_FileSpec   **pFileSpecifier);

    tsp00_Int4 ls14_FillLongfileStruct(tls00_DeviceType  deviceType,
                                       tls00_String      &pColumnName,
                                       tls00_String      *pFileName,
                                       tls00_CodeSpec    *pCodeSpec,
                                       tls00_FileSpec   **pFileSpecifier);
    
    void       ls14_ChangeUSE_USERString(tls00_String &PwPtr);
    tsp00_Int4 ls14_GetSeparatorDelimiter(char* pszSource, tsp00_Uint4 lSourceLen, char* pszDestination);

    void       ls14_GetVersionInformation();

    int yyparse(void * &Structure);

   // Members
private:
    ReplicationScanner  *Scanner;
    ErrorNumbers        ParseError;           // Error variable; passed to Scanner, too
    
    tls00_DBInfo        *lcpDBInfo_ls14;
    tls00_Command       *lcpCommand_ls14;

    RepServMessages     *MsgInstance_ls14;    // error message object

    _TCHAR              *pszMyUserStmt_ls14;  // used to temporarily save 'use user' stmt w/o pw for later output

    static char const   *pszAncientDateTimeParseErrText[13];
    static char const   *pszDateTimeStrings[3];

    bool                 bFileFormatNotSpecified_ls14;      // Hack; should be removed/replaced in 7.6!
    bool                 bDataFileFormatNotSpecified_ls14;      // Hack; should be removed/replaced in 7.6!

    
    ///////////////////////////////////////////////////////////////////////////////
    // Variables used by Bison
    int         yychar;     //  the lookahead symbol
    ScanReturn  yylval;     //  the semantic value of the lookahead symbol
    ScanReturn  yylloc;     //  location data for the lookahead symbol
    int         yynerrs;    //  number of parse errors so far
};


//*
//*     All following prototypes (i41...) are for compatibility reasons with the respective
//*     pascal source vin41 where no prototypes exist.
//*
externPascal void i41dparse(tin_date_mask&  DateStruct,
                            int&            lError,
                            tsp00_Uint2&    lErrorPos);

externPascal void i41tparse(tin_date_mask&  TimeStruct,
                            int&            lError,
                            tsp00_Uint2&    lErrorPos);

externPascal void i41tsparse(tin_date_mask& TimeStampStruct,
                             int&           lError,
                             tsp00_Uint2&   lErrorPos);


#endif // HLS14_PARSE_H