#!/usr/bin/perl
#
# PackDefs.pm
#
# $Header: //sapdb/V75/c_00/b_12/sys/src/install/perl/BuildPackage/PackDefs.pm#1 $
# $DateTime: 2004/05/03 16:16:26 $
# $Change: 71164 $
#

# added test diff

# Desc:	- define packages and profiles of SAP DB Packages
#		
#
#
#    ========== licence begin LGPL
#    Copyright (c) 2002-2004 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

		
package BuildPackage::PackDefs;

use Exporter;
use BuildPackage::Vars;

my $os = $BuildPackage::Distrib::opt_os;

my $isWindows = 0;
if(defined $os){
	$isWindows = 1 if ($os =~ /WIN/); 	
}
else{
	$isWindows = 1 if ($^O =~ /mswin/i);
}


@ISA = ('Exporter');

@EXPORT = ('%profile_in_name','%profiles','@allpackages',
			'%profile_data','@installer_files','%ALL_RPMS',
			'%RPM_PROFILES','@alltestpackages');

#define profiles -> contain package names


%profiles=(
	'Server' => ['Base','Server Utilities','Database Kernel','JDBC',"PCR $RUNTIME_VERSION",'ODBC','DB Analyzer','Loader'],
	
	#'APO LiveCache' => ['Base','Server Utilities','Database Kernel',"PCR $RUNTIME_VERSION",'APO LC APPS'],

	'APO LiveCache' => ['APO LC APPS'],

&if not ($OS == WIN32 && defined BIT64 || $OSSPEC == LINUX && $MACH == IA64)
	'Script Interface' => ['Base','Perl Interface','Python Interface'],
&else
	'Script Interface' => ['Base','Python Interface'],
&endif

	'ODBC'   => ['Base','ODBC'],

	'JDBC'   => ['Base','JDBC'],

	'Loader' => ['Base','Loader','Redist Python'],

	'C Precompiler' => ['Base','CPC Base',"CPC SDK $RUNTIME_VERSION","PCR $RUNTIME_VERSION"],

	'XML Indexing Engine' => ['Base','ODBC','XML Indexing Engine'],

	'Runtime For SAP AS' => ['Base',"PCR $RUNTIME_VERSION",'JDBC','ODBC','Loader'],
	
	'Webtools' => ['Base', 'ODBC', 'Webtools','XML Indexing Engine'],
	
	'DB Analyzer' => ['Base',$isWindows ? 'ODBC' : undef ,'DB Analyzer'],
	'DB Instance' => ['Base'],

&if not ($OS == WIN32 && defined BIT64 || $OSSPEC == LINUX && $MACH == IA64)	
	'Develop' => ['Base',"PCR $RUNTIME_VERSION","SDK $RUNTIME_VERSION",'ODBC','JDBC','Perl Interface','Python Interface','Database Connectivity']
&else
	'Develop' => ['Base',"PCR $RUNTIME_VERSION","SDK $RUNTIME_VERSION",'ODBC','JDBC','Python Interface','Database Connectivity']
&endif

);

my $name_COR = $COR;
$name_COR =~ s/^0*//g;
$name_COR = 0 unless $name_COR =~ /\S/; 
my $name_BUILD = $BUILD;
$name_BUILD =~ s/^0*//g;
$name_BUILD = 0 unless $name_BUILD =~ /\S/; 






#
#	additional profile data defs needed by SAP Software Center
#


my ($apo_rel_for_lca_package_name) = ($APO_SHORT_VERS =~ /^(.{2})/);
my ($apo_build_for_lca_package_name) = ($APO_BUILD =~ /(\d{2})$/);	# swc supports only 2 digits for apo com build
																	# ignore leading ones 
%profile_data = (
				'Server' => {
				
					'inner_subdir' => "maxdb-server-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXDB${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXDB%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-server-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build'
				},
				'APO LiveCache' => {
					'inner_subdir' => "apo${APO_SHORT_VERS}_livecache-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					#'archive_name' => "LCA${MAJ}${MIN}${COR}${BUILD}_${APO_BUILD}"				
					'archive_name' => "LC${MAJ}${MIN}${COR}${BUILD}A${apo_rel_for_lca_package_name}_${apo_build_for_lca_package_name}"					
				},
				'ODBC' => {
					'inner_subdir' => "maxdb-odbc-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXODBC${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXODBC%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-odbc-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build'					
				},
				'JDBC' => {
					'inner_subdir' => "maxdb-jdbc-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXJDBC${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXJDBC%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-jdbc-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build'					
				},
				'C Precompiler' => {
					'inner_subdir' => "maxdb-precompiler-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXDBCPC${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXDBCPC%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-precompiler-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build'					
				},
				'Script Interface' => {
					'inner_subdir' => "maxdb-scriptif-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXDBSIF${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXDBSIF%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-scriptif-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build'					
				},
				'Runtime For SAP AS' => {
					'inner_subdir' => "maxdb-as_runtime-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXDBART${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXDBART%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-as_runtime-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build',
				},
				'Webtools' => {
					'inner_subdir' => "maxdb-webtools-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXDBWEB${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXDBWEB%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-webtools-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build'
					
				},
				'DB Analyzer' => {
					'inner_subdir' => "maxdb-analyzer-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXDBANA${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXDBANA%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-analyzer-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build'
					
				},
				'DB Instance' => {
					'inner_subdir' => "maxdb-instance-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXDBINSTANCE${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXDBINSTANCE%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-instance-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build'
					
				},
				'Loader' => {
					'inner_subdir' => "maxdb-loader-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXDBLD${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXDBLD%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-loader-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build'
					
				},
				'XML Indexing Engine' => {
					'inner_subdir' => "maxdb-xie-$OS-".$BIT."bit-$ARCH-".$MAJ.'_'.$MIN.'_'.$name_COR.'_'.$name_BUILD,
					'archive_name' => "MAXDBXIE${MAJ}${MIN}${COR}_${BUILD}",
					'archive_name_tmpl' => 'MAXDBXIE%MAJ%MIN%COR_%BUILD',				
					'inner_subdir_tmpl' => 'maxdb-xie-%OS-%BITbit-%ARCH-%MAJ_%MIN_%cor_%build'
				}
);


my $exe_ext = $isWindows ? '.exe' : '';

#
# files of sapdb installer (without SDBUPD - only needed for Server / APO LiveCache)
#

@installer_files = ('SDBINST'.$exe_ext, 'SDBINST.TGZ');

push @installer_files, ($isWindows ? 'sdbrun.dll' : 'SDBRUN');
&if $OS in [ WIN32 ]
&if defined BIT64
push @installer_files,'perl56.dll' if $isWindows;
&else
push @installer_files,'perl58.dll','SDBSETUP.exe','WXPERL.TGZ','IMAGES.TGZ','wxmsw24.dll','Wx.dll' if $isWindows;
&endif
&else 
push @installer_files,'WXPERL.TGZ','IMAGES.TGZ','SDBSETUP';
&if $OSSPEC == AIX
push @installer_files,'libperl.a','Wx.so','libwx_x11univ-2.4.a';
&elif $OSSPEC == HPUX && $MACH != HP_IA64
push @installer_files,'libperl.sl','Wx.sl','libwx_x11univ-2.4.sl';
&else
push @installer_files,'libperl.so','Wx.so','libwx_x11univ-2.4.so';
&endif
&endif


&if $OS == WIN32 && $_MSC_VER == 13 && not defined BIT64
push @installer_files,'msvcr70.dll';
&endif



%profile_in_name = (

	'Runtime For SAP AS' => 'as_runtime',
	'APO LiveCache' => "apo${APO_SHORT_VERS}_livecache",
	'Script Interface' => 'scriptif'

);

	
	
#define packages
@allpackages=(
		{
			'name' => 'Base',
			'subdir' => 'base',
			'script' => 'instbase',
			'archive' => 'SDBBAS.TGZ',
			'filelist' => 'base.lst'
&if $OS == WIN32 && $_MSC_VER == 13 && not defined BIT64
			,'add_files' => ['mfc70.dll','msvcr70.dll']	
&endif		
		},
		{
			'name' => 'Server Utilities',
			'subdir' => 'utils',
			'script' => 'instutils',
			'archive' => 'SDBUTL.TGZ',
			'filelist' => 'utils.lst'	
		},
		{
			'name' => 'Database Kernel',
			'subdir' => 'kernel',
			'script' => 'instsrv',
			'archive' => 'SDBKRN.TGZ',
			'filelist' => 'kernel.lst',
			'pmask' => 0227,
			'additional_installer_files' => ['SDBUPD'.$exe_ext], 
			'README' => 'README'  
		},
		{
			'name' => "PCR $RUNTIME_VERSION",
			'subdir' => 'pcr',
			'script' => 'instpcr',
			'archive' => "PCR$MAJ$MIN$COR.TGZ",
			'filelist' => 'pcr.lst',
			'specialFunc' => \&BuildPackage::New::copyPCR
		},
		
		{
			'name' => 'DB Analyzer',
			'subdir' => 'dbana',
			'script' => 'instdbana',
			'archive' => 'SDBANA.TGZ',
			'filelist' => 'dbana.lst'	
		},
		{
			'name' => "CPC Base",
			'subdir' => 'cpcbase',
			'script' => 'instcpcbase',
			'archive' => "CPCBASE.TGZ",
			'filelist' => 'cpcbase.lst'	
		},
		{
			'name' => "CPC SDK $RUNTIME_VERSION",
			'subdir' => 'cpcsdk',
			'script' => 'instcpcsdk',
			'archive' => "CSDK$RUNTIME_VERSION.TGZ",
			'filelist' => 'cpcsdk.lst'	
		},
		{
			'name' => 'Webtools',
			'subdir' => 'web',
			'script' => 'instweb',
			'archive' => 'SDBWEB.TGZ',
			'filelist' => 'web.lst'	
		},
		{
			'name' => 'ODBC',
			'subdir' => 'odbc',
			'script' => 'instodbc',
			'archive' => 'SDBODBC.TGZ',
			'filelist' => 'odbc.lst'	
		},	
		{
			'name' => 'JDBC',
			'subdir' => 'jdbc',
			'script' => 'instjdbc',
			'archive' => 'SDBJDBC.TGZ',
			'filelist' => 'jdbc.lst'
			#'FileMappings' => $isWindows ? {"$RUNTIME_PATH/pgm/sapdbcbin.dll" => 'pgm/sapdbcbin.dll','runtime/jar/sapdbc.jar' => 'jar/sapdbc.jar'} : {'runtime/jar/sapdbc.jar' => 'jar/sapdbc.jar'} 	
		},
&if not ($OS == WIN32 && defined BIT64 || $OSSPEC == LINUX && $MACH == IA64)
		{
			'name' => 'Perl Interface',
			'subdir' => 'perl',
			'script' => 'instperl',
			'archive' => 'SDBPL.TGZ',
			'filelist' => 'perl.lst'
		},
&endif
		#{
		#	'name' => 'Python Interface',
		#	'subdir' => 'python',
		#	'script' => 'instpy',
		#	'archive' => 'SDBPY.TGZ',
		#	'filelist' => 'py.lst'	
		#},
		{
			'name' => 'APO LC APPS',
			'subdir' => 'apocom',
			'script' => 'instapocom',
			'archive' => 'APOLCA.TGZ',
			'filelist' => 'apocom.lst'
		},
		{
			'name' => 'Loader',
			'subdir' => 'loader',
			'script' => 'instloader',
			'archive' => 'SDBLD.TGZ',
			'filelist' => 'loader.lst'
		},
#		{
#			'name' => 'DB Instance',
#			'subdir' => 'instance',
#			'script' => 'instinstance',
#			'archive' => 'SDBCDB.TGZ',
#			'filelist' => 'instance.lst'
#		},
		{
			'name' => 'XML Indexing Engine',
			'subdir' => 'xie',
			'script' => 'instxie',
			'archive' => 'SDBXIE.TGZ',
			'filelist' => 'xie.lst',
			'FileMappings' => {'config/sapdbxie.reg' => 'config/sapdbxie.reg.org','config/sapdbxie.ini' => 'config/sapdbxie.ini.org'}
		},
		{
			'name' => 'Database Connectivity',
			'subdir' => 'dbc',
			'script' => 'instdbc',
			'archive' => 'SDBC.TGZ',
			'filelist' => 'dbc.lst',
		},
		{
			'name' => 'Redist Python',
			'subdir' => 'rdpy',
			'script' => 'instrdpy',
			'archive' => 'SDBRDPY.TGZ',
			'filelist' => 'rdpy.lst'	
		}
);


@alltestpackages=(
		{
			'name' => 'OMS Test Kernel',
			'pmask' => 0227,
			'subdir' => 'tstknl',
			'script' => 'insttstknl',
			'archive' => 'TSTKNL.TGZ',
			'filelist' => 'tstknl.lst'
		},
		{
			'name' => 'LC Simulator',
			'pmask' => 0227,
			'subdir' => 'lcsim',
			'script' => 'instlcsim',
			'archive' => 'LCSIMUL.TGZ',
			'filelist' => 'lcsim.lst'
		},
		{
			'name' => 'Test Apps',
			'pmask' => 0227,
			'subdir' => 'tstapps',
			'script' => 'insttstapps',
			'archive' => 'TSTAPPS.TGZ',
			'filelist' => 'tstapps.lst'
		}
);





%ALL_RPMS = (
	'ind' => 'maxdb-ind-%MAJ.%MIN.%cor.%build-1.i386.rpm',
	'srv76' => 'maxdb-srv76-%MAJ.%MIN.%cor.%build-1.i386.rpm',
	'web' => 'maxdb-web-%MAJ.%MIN.%cor.%build-1.i386.rpm',
	'callif' => 'maxdb-callif-%MAJ.%MIN.%cor.%build-1.i386.rpm',
	'scriptif' => 'maxdb-scriptif-%MAJ.%MIN.%cor.%build-1.i386.rpm',
	'testdb76' => 'maxdb-testdb76-%MAJ.%MIN.%cor.%build-1.i386.rpm',
	#'precompiler' => 'maxdb-precompiler-%MAJ.%MIN.%cor.%build-1.i386.rpm'
);

%RPM_PROFILES = (
	'Server' => ['ind','srv76','testdb76'],
	'Runtime For SAP AS' => ['ind'],
	'DB Analyzer'  => ['ind'],
	'DB Instance'  => ['ind'],
	'Webtools' => ['callif','web'],
	'ODBC' => ['callif'],
	'JDBC' => ['callif'],
	'SDK' => ['callif','scriptif'],#,'precompiler'],
	#'C Precompiler' => ['precompiler']
);


1;
