/*!***************************************************************************

  module      : vgg942.cpp
  responsible : UweH
  special area: ComponentTests
  created     : 2000-11-24
  last changed: 2000-11-30  9:36
  copyright   : (c) 2000-2004 SAP AG
  description : component tests
                DIAGNOSE CHECK INSTANCE <number>

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*****************************************************************************/

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "Logging/Log_Types.hpp" // needed for vgg999 PTS 1124727 mb 2003-10-30

#if COMPILEMODE_MEO00 >= SLOW_MEO00
#include "hta99.h" /* nocheck */
#endif

#include "hgg942.h" // check of PASCAL header vgg942
#include "hgg999.h" // KernelAdministration_PascalInterface
#include "hbd03.h"  // bd03TestTree
#include "ggg92.h"  // in dependence of hgg06
#include "hgg06.h"  // gg06buildCompressedKey,gg06CalculateHash

#include "DataAccess/Data_Test.hpp"
#include "KernelCommon/Kernel_Test.hpp"
#include "Logging/Log_Test.hpp"
#include "RunTime/RTE_Test.hpp"
#include "Table/Table_Test.hpp"
#include "SAPDBCommon/Algorithms/SAPDBAlgo_Test.hpp"
#include "SQLManager/SQLMan_Context.hpp"
#include "SQLManager/SQLMan_Test.hpp"
#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_Assertions.hpp"
#include "KernelCommon/Kernel_VTrace.hpp"
#include "KernelCommon/Kernel_Trace.hpp"
#include "RunTime/System/RTESys_MicroTime.h"
#include "RunTime/RTE_MySQLProxy.hpp"

/*----------------------------------------------------------------------------*/
void randomKeyAssign ( SAPDB_Byte                     *s,
                       SAPDB_UInt                      l,
                       RTE_MySQLPseudoRandomGenerator &rand,
                       bool                            onlyAscii )
{
    const SAPDB_UInt variableLength = l/10;
    const SAPDB_UInt firstOffset    = l/2 - variableLength/2;
    const SAPDB_UInt lastOffset     = firstOffset+variableLength;
    memset (s,0x20,l-1);
    for ( SAPDB_UInt i = firstOffset; i < lastOffset; i++ )
    {
        if ( onlyAscii )
        {
            SAPDB_Byte b = static_cast<SAPDB_Byte>(rand.RandomNumber() * 127);
            *(s+i) = b < 32 ? 32 : b;
        }
        else
            *(s+i) = static_cast<SAPDB_Byte>(rand.RandomNumber() * SAPDB_MAX_UINT1);
    }
    // Kernel_TraceBuffer (s,l,"randomKey", 80);
}


/*----------------------------------------------------------------------------*/
void testKnownKeys(tgg00_TransContext& trans)
{
    const SAPDB_Byte key1[] = { 0x20,0x30,0x30,0x30,0x20,0x46,0x4f,0x52,0x4d,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
                                0x48,0x52,0x5f,0x49,0x44,0x5f,0x54,0x41,0x58,0x31,0x37,0x32,0x31,0x41,0x42,0x20,
                                0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
                                0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
                                0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
                                0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x54,0x58,0x54,0x20,0x20,0x45 };
    const SAPDB_UInt   key1length = 93;
    const SAPDB_Byte key2[] = { 0x20,0x30,0x30,0x30,0x20,0x46,0x4f,0x52,0x4d,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
                                0x4f,0x44,0x5f,0x56,0x42,0x4c,0x5f,0x41,0x4e,0x4d,0x45,0x4c,0x20,0x20,0x20,0x20,
                                0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
                                0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
                                0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
                                0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x54,0x58,0x54,0x20,0x20,0x45 };
    const SAPDB_UInt   key2length = 93;

    const tsp00_Uint4   MAXHASHTYPE       = 3;
	const tsp00_Uint4   COMPRESSEDKEYSIZE = 56;
          tsp00_Byte    compressedkey1 [COMPRESSEDKEYSIZE];
          tsp00_Byte    compressedkey2 [COMPRESSEDKEYSIZE];
          tsp00_Uint4   key1hashvalue;
          tsp00_Uint4   key2hashvalue;
    
    for ( tsp00_Byte hashtype = 0; hashtype < MAXHASHTYPE; hashtype++ )
    {
        (void)gg06buildCompressedKey (key1,key1length,1,key1length,COMPRESSEDKEYSIZE,compressedkey1);
        (void)gg06buildCompressedKey (key2,key2length,1,key2length,COMPRESSEDKEYSIZE,compressedkey2);

        Kernel_TraceBuffer (compressedkey1,COMPRESSEDKEYSIZE,"compressedkey1", COMPRESSEDKEYSIZE);
        Kernel_TraceBuffer (compressedkey2,COMPRESSEDKEYSIZE,"compressedkey2", COMPRESSEDKEYSIZE);

        if ( memcmp (compressedkey1,compressedkey2,COMPRESSEDKEYSIZE) )
            Kernel_VTrace() << "Hash Type: " << hashtype << " (0=old,1=fnv,2=simple) PASSED.";
        else
        {
            Kernel_VTrace() << "LockKey collision for type (0=old,1=fnv,2=simple): " << hashtype;
            gg06CalculateHash(key1,key1length,hashtype,key1hashvalue);
            gg06CalculateHash(key2,key2length,hashtype,key2hashvalue);
            if ( key1hashvalue == key2hashvalue )
                Kernel_VTrace() << "Hash collision for type (0=old,1=fnv,2=simple): " << hashtype;
            else
                Kernel_VTrace() << "NO Hash collision ?";
        }
    }
}

/*----------------------------------------------------------------------------*/
void testHashSpreading(tgg00_TransContext& trans,
                       bool                onlyAscii)
{
    const tsp00_Uint4   MAXLOOPS = 100000;
    const tsp00_Uint4   MAXHASHTYPE = 3;

    typedef tsp00_Uint2 CollisionList [MAXLOOPS];

    CollisionList       spreading     [MAXHASHTYPE];
    tsp00_Uint4         collisions    [MAXHASHTYPE];
    
    const tsp00_Uint4   KEYLENGTH         = 1024;
    tsp00_Byte          key           [KEYLENGTH];

    tsp00_Uint4         hashvalue;
    tsp00_Uint4         loop;
    tsp00_Byte          hashtype;

    Kernel_VTrace() << "TEST SPREADING: loops=" << MAXLOOPS << " keylength=" << KEYLENGTH
                    << (onlyAscii?" only ascii keys":" keys 0-255");

    for ( hashtype = 0; hashtype < MAXHASHTYPE; hashtype++ )
    {
        collisions[hashtype] = 0;
        for ( loop = 0; loop < MAXLOOPS; loop++ )
            spreading [hashtype][loop] = 0;
    }
    
    RTE_MySQLPseudoRandomGenerator rand(11);

    for ( loop = 0; loop < MAXLOOPS; loop++ )
    {
        randomKeyAssign (key, KEYLENGTH, rand, onlyAscii);
        for ( hashtype = 0; hashtype < MAXHASHTYPE; hashtype++ )
        {
            gg06CalculateHash(key,KEYLENGTH,hashtype,hashvalue);
            if ( spreading [hashtype][hashvalue%MAXLOOPS] > 0 )
                collisions[hashtype]++;
            (spreading[hashtype][hashvalue%MAXLOOPS])++;
        }
    }
    for ( hashtype = 0; hashtype < MAXHASHTYPE; hashtype++ )
        Kernel_VTrace() << "HASHTYPE (0=old,1=fnv,2=simple) " << hashtype
                        << ": collisions=" << collisions[hashtype];
}
/*----------------------------------------------------------------------------*/
void testHashSpeed (tgg00_TransContext& trans)
{
    tgg00_BasisError   &berr              = trans.trError_gg00;
    const tsp00_Uint4   KEYLENGTH         = 1024;
	const tsp00_Uint4   COMPRESSEDKEYSIZE = 56;
    const tsp00_Uint4   MAXLOOPS          = 100000;
    tsp00_Byte          key           [KEYLENGTH];
    tsp00_Byte          compressedkey [COMPRESSEDKEYSIZE];
    tsp00_Uint4         loop;
    SAPDB_UInt8         timeBegin;
    SAPDB_UInt8         timeEnd;

    memset (key, 0xFF, KEYLENGTH);
    memset (compressedkey, 0x00, COMPRESSEDKEYSIZE);

    Kernel_VTrace() << "TEST HASHES:";
    Kernel_VTrace() << "KEYLENGTH = " << KEYLENGTH << ", COMPRESSEDKEYSIZE = " << COMPRESSEDKEYSIZE;
    Kernel_VTrace() << "MAXLOOPS  = " << MAXLOOPS;

    timeBegin = RTESys_MicroSecTimer();
    for ( loop = 0; loop < MAXLOOPS; loop++ )
    {
        (void)gg06buildCompressedKey (key,KEYLENGTH,1,KEYLENGTH,COMPRESSEDKEYSIZE,compressedkey);
    }
    timeEnd = RTESys_MicroSecTimer();
    Kernel_VTrace() << "time = " << timeEnd-timeBegin;
}

/*----------------------------------------------------------------------------*/
void testMessageList (tgg00_TransContext& trans)
{
    SAPDBErr_MessageList &errlist = SQLMan_Context::GetContext()->GetErrorList();
    errlist =  SAPDBErr_Exception(__CONTEXT__,SAPDBERR_ASSERT_STATE_FAILED,
                                  "DIAGNOSE CHECK INSTANCE 6: e_system_error 1");
    errlist = errlist
              + 
              SAPDBErr_Exception(__CONTEXT__,SAPDBERR_ASSERT_STATE_FAILED,
                                 "DIAGNOSE CHECK INSTANCE 6: e_system_error 2");
}

/*----------------------------------------------------------------------------*/

externPascal void gg942ComponentTests (tgg00_TransContext& Trans,
                                       tsp00_Int4          TestNo)
{
    ROUTINE_DBG_MSP00 ("gg942ComponentTests");

    switch (TestNo)
    {
    case 1:
        Data_Test (Trans);
        break;
    case 2:
        Kernel_Test (Trans);
        break;
    case 3:
    {
        Log_Test testRunner;
        testRunner.PerformTest(Trans, Log_Test::Log_TestIOSequences);
        break;
    }
    case 4:
        RTE_Test (Trans);
        break;
    case 5:
        Table_Test (Trans);
        break;
    case 6:
        testMessageList (Trans);
        break;
    case 7:
        SQLMan_Test (Trans);
        break;
    case 8:
        SAPDBAlgo_Test (Trans);
        break;
    case 9:
        bd03TestTree(Trans);
        break;
    case 10:
        testHashSpeed(Trans);
        testHashSpreading(Trans,false);
        testHashSpreading(Trans,true);
        testKnownKeys(Trans);
        break;
    default:
        break;
    }
}
