/*!
  @file           heo00.h
  @author         JoergM
  @special area   
  @brief          RTE - common_rte_include module
  @see            

\if EMIT_LICENCE
  ========== licence begin  GPL
  Copyright (c) 2001-2004 SAP AG

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  ========== licence end
\endif
*/



#ifndef HEO00_H
#define HEO00_H

#if defined (SAPDB_QUICK) || defined (SAPDB_SLOW)
#define DEVELOP_CHECKS TRUE
#endif

#if defined (_WIN32)    /*&if $OSSPEC = WIN32*/ 
#include  "gos00.h"     /* nocheck */
#else                   /*&else*/
#include  "gen00.h"     /* nocheck */
#endif                  /*&endif*/
#include "gsp00.h"



/*
 *  Values for kernel task type
 */
/* --- should not be used, allready defined in geo00_2.h */
#define         TT_TI                   11
#define         TT_TL                   12
#define         TT_AL                   13
#define         TT_TW                   14
#define         TT_DW                   15
#define         TT_SN                   16
#define         TT_RC                   17
#define         TT_UT                   18

#define         TT_EV                   20
#define         TT_GC                   21
#define         TT_BUP                  22

#define         TT_SV                   30
#define         TT_US                   40

/* --- Values for kernel task states */
/* --- should not be used, allready defined in geo00_2.h */
#define TSK_INITIALIZED                 10
#define TSK_INACTIVE                    11
#define TSK_MARKED_FOR_STARTUP          12
#define TSK_RUNNING                     13
#define TSK_CONNECTWAIT                 14
#define TSK_VDEVSIZE                    15
#define TSK_VATTACH                     16
#define TSK_V2INFO                      17
#define TSK_VBLOCKIO                    18
#define TSK_V2BLOCKIO                   19
#define TSK_VDETACH                     20
#define TSK_VFOPEN                      21
#define TSK_VFREAD                      22
#define TSK_VFWRITE                     23
#define TSK_VFCLOSE                     24
#define TSK_VRELEASE                    25
#define TSK_VSHUTDOWN                   26
#define TSK_VRECEIVE                    27
#define TSK_VREPLY                      28
#define TSK_VNRESTART                   29
#define TSK_VNSHUTDOWN                  30
#define TSK_VNOPEN                      31
#define TSK_VNREQUEST                   32
#define TSK_VNRECEIVE                   33
#define TSK_VNCLOSE                     34
#define TSK_VBEGEXCL                    35
#define TSK_VENDEXCL                    36
#define TSK_VSUSPEND                    37
#define TSK_VWAIT                       38
#define TSK_VSLEEP                      39
#define TSK_VDIAGINIT                   40
#define TSK_VOPMSG                      41
#define TSK_LOCKED                      42
#define TSK_TERMINATED                  43
#define TSK_RUNNABLE                    44
#define TSK_ASYNOPEN                    45
#define TSK_ASYNCLOSE                   46
#define TSK_ASYNIO                      47
#define TSK_ASYNWAIT_READ               48
#define TSK_ASYNWAIT_WRITE              49
#define TSK_VCREATE                     50
#define TSK_VKILL                       51
#define TSK_IO_READ                     52
#define TSK_IO_WRITE                    53
#define TSK_IO2_READ                    54
#define TSK_IO2_WRITE                   55
#define TSK_VACKNOWLEDGE                56
#define TSK_VNCLEAR                     57
#define TSK_ASYNCNTL                    58
#define TSK_DCOM_OBJ_CALLED             59     
#define TSK_RESCHEDULE_MSEC             60     
#define TSK_LAST                        61     

/* --- should not be used, allready defined in geo00_2.h */
#define MAX_SUSPEND_REASONS            256
#define MAX_DEVQUEUELEN_STAT             3

/* --- should not be used, allready defined in geo00_2.h */
#define TASK_IS_IN_NON_QUEUE            0
#define TASK_IS_IN_IOC_QUEUE            3
#define TASK_IS_IN_COM_QUEUE            4
#define TASK_IS_IN_RUN_QUEUE            6

/***************************************************************/
#if defined(_WIN32) || defined(OS2) 
/***************************************************************/

/* --- should not be used, allready defined in geo00_2.h */
#define TASK_IS_IN_UToU_QUEUE           1
#define TASK_IS_IN_RAV_QUEUE            2
#define TASK_IS_IN_UKT_QUEUE            3
#define TASK_IS_IN_REX_QUEUE            5

#define  SPRINTF                        wsprintf
#define  KERNEL_GLOBAL_DBNAME           kgs.szServerDB

/* --- should not be used, allready defined in veo01.h */
#define  PATH_DELIMITTER                '\\'

/***************************************************************/
#else
/***************************************************************/

#define  SPRINTF                        sprintf
#define  KERNEL_GLOBAL_DBNAME           en81_dbname

/* --- should not be used, allready defined in veo01.h */
#define  PATH_DELIMITTER                '/'


/* --- should not be used, allready defined in geo001.h */
#ifndef NO_ERROR
#define  NO_ERROR                       0
#endif /* NO_ERROR */
#define  ERROR                          1

/* --- should not be used, allready defined in geo570.h */
#define  ALLOC_MEM( _MemPtr, _Size ) \
    (( *_MemPtr = (void *)malloc ( _Size )) != NULL ? NO_ERROR : ERROR )
#define  FREE_MEM( _MemPtr ) free ( _MemPtr )

/***************************************************************/
#endif
/***************************************************************/


/***************************************************************/
#if !defined(_WIN32) && !defined(OS2) 
/***************************************************************/
/* --- should not be used, allready defined in geo007_1.h and geo200.h */
#if !defined(ERR_TYPE) 
# define IERR_TYPE                        0
# define ERR_TYPE                         1
# define WRN_TYPE                         2
# define INFO_TYPE                        3
#endif
/***************************************************************/
#endif
/***************************************************************/

#endif  /* HEO00_H */

