/*******************************************************************************
  module:       hcn352.h
  ------------------------------------------------------------------------------
  responsible:  TiloH
  special area: cn layer
  description:  connection between dbmsrv and external backup tool NetWorker
  last change:  2000-11-29 10:33
  version:      7.2.5
  see also:     
  ------------------------------------------------------------------------------
                         Copyright (c) 1999-2004 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1999-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*******************************************************************************/

#if !defined (_HCN352_H_)
#define _HCN352_H_


// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------

#include "hni31.h"
#include "hcn35.h"
#include "hcn36.h"

#include "SAPDB/ToolsCommon/Tools_Vector.hpp"


// -----------------------------------------------------------------------------
// class tcn352_NetWorkerConnection
// -----------------------------------------------------------------------------

class tcn352_LevelActionMapEntry;

class tcn352_NetWorkerConnector:public tcn35_BackupToolConnector
{
  public:
    tcn352_NetWorkerConnector(tcn35d_BackupInfo                     * TheBackupInfo,
                              tcn35d_DBBackupControllerLogWriter    * TheLogWriterToUse,
                              tcn35d_DBBackupControllerErrorHandler * TheErrorHandlerToUse,
                              tcn35d_ConfigurationVariableHandler   * TheConfigurationVariableHandler,
                              char                                  * TheExternalBackupIDList=0);
    ~tcn352_NetWorkerConnector();
    
    virtual const char * GiveToolName();
    virtual const char * GiveLongToolName();

  private:
    int CheckToolInstallation(int & IsInstalled);
    int PrepareFirst();
    int PrepareAgain();
    int LastMinutePreparation(int NumberOfCurrentCommandLine);

    int CleanUpTool();
    int CollectExternalBackupIDs(char * ExternalBackupID[MAX_NUMBER_OF_TOOLPROCESSES_CN35], int & NumberOfEBIDsFound);
    int CheckPipes();
    int ConstructNameForPart(char *& Name, int NumberOfPipe);

    int GiveInformationOfLine(const char *                   Line,
                              const char *                 & EBIDInLine,
                              size_t                       & EBIDLength,
                              tcn35d_BackupInfo::ADataType & DataType,
                              const char *                 & DateTimeString,
                              int                          & LineContainsEBID);

    int BuildEBIDFromNSavetime(char       * & EBID,
                               const char *   StartOfNSavetime,
                               const char *   EndOfNSavetime);
    int ToolWasSuccessful(teo00_Uint8 DBBackupSize);
    int ToolWasSuccessfulSoFar();
    int AnalyzeNSROutputLine(const char   * FileName,
                             const char   * Line,
                             int            NumberOfPart,
                             int &          FoundCompletionMessage,
                             int &          FoundNSavetimeMessage,
                             teo00_Uint8  & BytesInCompletionMessage,
                             unsigned int & NumberOfErrorMessages);
    int FoundFileNameFollowedByWarning(const char * FileName,
                                       const char * NSROutputLine);
    int LineContainsCompletionMessage(int           NumberOfPart,
                                      const char *  Line,
                                      teo00_Uint8 & BytesInCompletionMessage);
    int CheckForNSavetimeMessage(const char * FileName,
                                 int          NumberOfPart,
                                 const char * Line,
                                 int        & ContainsNSavetime);


    void DeleteListOfErrorsToIgnore();

    static struct DataTypeToNSRLevelMapEntry
    {
        unsigned                        Index;
        tcn35d_BackupInfo::ADataType    DataType;
        const char                   *  NSRLevel;
    } DataTypeToNSRLevelMap[];

    unsigned int IndexAccordingToNSRFullSetting(unsigned CurrentIndex);
    const char * LevelForAction(tcn35d_BackupInfo::ADataType DataType,
                                int                          NumberOfPipe);
    int          DataTypeForLevelN(tcn35d_BackupInfo::ADataType & DataType,
                                   const char *                   Level,
                                   size_t                         LevelLength);


    char * PathOfNSR_ENVFile;
    char * NameOfNSR_HOST;
    char * NameOfNSR_POOL;
    char * NSR_EXPIREValue;

    char * PathOfNSRSave;
    char * PathOfNSRRecover;
    char * PathOfNSRMminfo;

    int    BuildBackupToolCall();   // TODO: move to base-class
    int    CreateNSRDirectivesFile();
    int    CreateNSRDirectivesFileWriteALine(tni34_ATextFile & DFile, const char * Line, const char *DFileName);
    int    CreateTempOutputFiles();

    long   StartSaveTime;
    long   EndSaveTime;

    int NSRUseDotNSRFile;                       //!< should a .nsr file be used or multiple directive files
    Tools_Vector<char *> DirectiveFileNames;    //!< vector containing names of used directives files

    enum LevelFullType {DataMigration, DataRecovery, DataMigrationAndDataRecovery};    
    LevelFullType LevelFullForBackupType;

    enum VerboseFlagForType {None, Save, Recover, SaveAndRecover};
    VerboseFlagForType VerboseFlagFor;

    enum NSREBIDTypeEnum {SSID, NSaveTime};
    NSREBIDTypeEnum     NSREBIDType;

    char *              TempEBID;
    static const char * NSaveTimeEBIDPrefix;
    static const char * NSaveTimeEBIDPartDelimiter;

    enum NSROutputResultType {NotChecked, FoundError, FoundNoError};
    NSROutputResultType NSROutputResult;
    NSROutputResultType ErrorInOutput[MAX_NUMBER_OF_TOOLPROCESSES_CN35];
    int                UseNSROutput;
    ni31_List<char *>  ListOfErrorsToIgnore;

    int NSRSaveInterval;

    char * NSRBackupName;

    int    NSRAvoidMMInfoBug;
    char * NSRAvoidMMInfoTimeBug;

    tcn36_DateTimeFormat ExplicitDateTimeFormat,
                         StandardDateTimeFormat2DigitYear,
                         StandardDateTimeFormat4DigitYear,
                         OutputDateTimeFormat;
    int                  UseExplicitDateTimeFormat;

    int AllocConstructAndCheckExe(char *& Path, const char * DirectoryPath, const char * Name, int & ExistsAndIsExecutable);

    enum NSRRoundUpValue {NoRoundup, FirstDecimal, Normal, LastInteger};
    NSRRoundUpValue Roundup;

    int    UseLLOptionForSave;
    char * NSRExternalBackupID[MAX_NUMBER_OF_TOOLPROCESSES_CN35];
    int    NSRNumberOfEBIDsFound;

    char * NSRClientName;
    const char * NodeNameToUse() const;
};

#endif
