/*



    ========== licence begin  GPL
    Copyright (c) 1998-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/
/* @lastChanged: "1998-06-24  13:15"
 *
 * @filename:    gcn00.h
 * @purpose:     "common header file for cn modules"
 * @release:     7.1. / 6.2.
 * @see:         "-.-"
 *
 * @copyright:   (c) 1998-2004 SAP AG"
 *
 * ==================================================================
 *
 * responsible:   Bernd Vorsprach (D025588 - Bernd.Vorsprach@SAP-AG.de)
 *
 * created:       1998-01-20 by Bernd Vorsprach
 *
 * purpose:       common header file for cn modules
 *
 * notice:        Wer Funktionen nachmacht oder verfaelscht oder sich
 *                nachgemachte oder verfaelschte Funktionen verschafft,
 *                um sie in Verkehr zu bringen wird mit nicht unter
 *                3 Jahren CONTROL bestraft!
 *
 * ==================================================================
 */

#ifndef _GCN00_H_
#define _GCN00_H_

/* ------------------------------------------------------------------
 * includes
 * ------------------------------------------------------------------
 */

#include "gsp00.h"
#include "geo572.h"

#include "gcn00_1.h"
#include "DBM/Srv/DBMSrv_Common.hpp"
#include "ToolsCommon/Tools_Arguments.hpp"

/***** Memory Debug BEGIN *****/
#ifdef BVMEMDEBUG
#pragma message ("Memory Debug ON")
#include <crtdbg.h>
#endif
/***** Memory Debug END *****/

#define CHAR_P_CAST_CN00
#define UCHAR_P_CAST_CN00


/* ------------------------------------------------------------------
 * memory management definitions
 * ------------------------------------------------------------------
 * Use BVMEMDEBUG only if your under NT 4.0 using MS Visual C(++) and if
 * you have specified the library libcmtd instead of libcmt for the
 * link process.
 *
 * In case of disregard you will get several errors while compiling an
 * linking.
 *
 * void cnMyMalloc (
 *       long    nSize,      IN
 *       void ** pPointer,   OUT
 *       BOOLEAN bOK);       OUT
 *
 * void cnMyFree (
 *       void *  pPointer);  IN
 *
 */
//  #define cn00MyMalloc(a, b, c ) sqlallocat(a, (tsp00_Uint1 **) b, (tsp00_Bool *) c); \
//                                 if ((*b != NULL) && (*c)) memset(*b, '\0', a)
//  #define cn00MyFree(a)          sqlfree((tsp00_Uint1 *) a)

//  #define cn00MyMalloc(a, b, c ) {char ** xyz = (char **) b; *xyz = new char [a]; \
//                                 if (*xyz != NULL) {memset(*xyz, '\0', a); *c = true;}}

  #define cn00MyMalloc(a, b, c ) {                                                                          \
                                   char * xyz; xyz = new char [a];                                          \
                                   if (xyz != NULL) {memset(xyz, '\0', a); *c = true;*((char **) b) = xyz;} \
                                   else { *b = NULL;}                                                       \
                                 }

  #define cn00MyFree(a)          delete [] ((char *) a);

/* ------------------------------------------------------------------
 * SPECIFICATION DATATYPES, CONSTANTS AND MACROS for vcn**c
 * ------------------------------------------------------------------
 */
#define  NAMESIZE_CN00 100

class cn50DBMUser;          //forward declaration to avoid inclusion of  vcn50.h
class DBMSrvBHist_History;  //forward declaration to avoid inclusion of  DBMSrvBHist_History.hpp
class DBMSrvBHist_EBIDList; //forward declaration to avoid inclusion of  DBMSrvBHist_EBIDList.hpp
class DBMSrv_HSSNodes;      //forward declaration to avoid inclusion of  DBMSrv_HSSNodes.hpp
class DBMSrv_KernelSession; //forward declaration to avoid inclusion of  DBMSrv_KernelSession.hpp

class VControlDataT {
public:
    VControlDataT()
    {
      bIsSAPDBAdmi        = false;
      active              = false;
      dbname.rawAssign("");
      dbroot.rawAssign("");
      pXParamSection      = NULL;
      pUtilSession        = NULL;
      pSQLUserSession     = NULL;
      pServiceSession     = NULL;
      pKernelSession      = NULL;
      pBackupSession      = NULL;
      pBackupStageSession = 0;
      pHistorySession     = 0;
      pEBIDList           = 0;
      pHSSNodes           = NULL;
      pEventSession       = NULL;
      pCommandObj         = NULL;
      pParamHistory       = NULL;
      pfCancelFlag        = false;
      pCurrentUser        = NULL;
      bUnicode            = false;
      szNextCommand.rawAssign("");
      nNextCommandSkip    = 0;
      szLastParameter.rawAssign("");
    }

    bool                   bIsSAPDBAdmi;
    bool                   active;
    tsp00_DbNamec          dbname;
    tsp00_Pathc            dbroot;
    tsp00_XpKeyTypec       szLastParameter;
    cn50DBMUser          * pCurrentUser;
    void                 * pXParamSection;
    void                 * pUtilSession;
    void                 * pSQLUserSession;
    void                 * pServiceSession;
    DBMSrv_KernelSession * pKernelSession;
    void                 * pBackupSession;
    void                 * pBackupStageSession;
    DBMSrvBHist_History  * pHistorySession;
    DBMSrvBHist_EBIDList * pEBIDList;
    DBMSrv_HSSNodes      * pHSSNodes;
    void                 * pEventSession;
    void                 * pCommandObj;
    void                 * pParamHistory;
    bool                 * pfCancelFlag;
    bool                   bUnicode;
    tsp00_C512c            szNextCommand;
    int                    nNextCommandSkip;
};

class CommandT {
public:
    CommandT() {
      nIndex    = CommandT::InvalidIndex;
      args      = NULL; 
    } // end CommandT

    void setArgs(const char * pCommand) {
      args = pCommand;
      oArguments.setArguments((Tools_DynamicUTF8String::ConstPointer) pCommand);
    } // end setArgs

    int              nIndex;
    const char *     args;
    Tools_Arguments  oArguments;
    static const int InvalidIndex;
};

class cn00DBMServerData {
  public:
    static VControlDataT * vcontrol() {return m_vcontrol;}
    static void setVcontrol(VControlDataT * vcontrol) {m_vcontrol = vcontrol;}

  private:
    static VControlDataT * m_vcontrol;

}; // end class cn00DBMServerData

/* error codes and error handling */
/*
typedef enum {
  OK_CN00                         = 0,

  ERR_CN00                        = -24999,
  ERR_NOTIMPL_CN00                = -24998,
  ERR_FILE_CN00                   = -24997,
  ERR_PARAM_CN00                  = -24996,
  ERR_MEM_CN00                    = -24995,
  ERR_RTE_CN00                    = -24994,
  ERR_RTEEXT_CN00                 = -24993,
  ERR_NOUTILSESSION_CN00          = -24992,
  ERR_NOSQLUSERSESSION_CN00       = -24991,
  ERR_NOBACKUPSESSION_CN00        = -24990,

  ERR_NOHISTORYSESSION_CN00       = -24989,
  ERR_SQL_CN00                    = -24988,
  ERR_TOSMALL_CN00                = -24987,
  ERR_NOMEDIA_CN00                = -24986,
  ERR_MENOTFOUND_CN00             = -24985,
  ERR_MENOVALID_CN00              = -24984,
  ERR_BANOVALIDTYPE_CN00          = -24983,
  ERR_NOHISTORY_CN00              = -24982,
  ERR_HIENTRYNOTFOUND_CN00        = -24981,
  ERR_NOHELP_CN00                 = -24980,

  ERR_XPNOTFOUND_CN00             = -24979,
  ERR_XPSYNTAX_CN00               = -24978,
  ERR_COMMAND_CN00                = -24977,
  ERR_PARAMEXIST_CN00             = -24976,
  ERR_NOXPSESSION_CN00            = -24975,
  ERR_XPSESSION_CN00              = -24974,
  ERR_XPCHECK_CN00                = -24973,
  ERR_XPINVCONF_CN00              = -24972,
  ERR_XPNOCHECK_CN00              = -24971,
  ERR_XPNOMODIFY_CN00             = -24970,

  ERR_XPDIRTY_CN00                = -24969,
  ERR_XPREADONLY_CN00             = -24968,
  ERR_SYSTEM_CN00                 = -24967,
  ERR_LOGON_CN00                  = -24966,
  ERR_SYSLOGON_CN00               = -24965,
  ERR_EXECUTE_CN00                = -24964,
  ERR_VOLCHECK_CN00               = -24963,
  ERR_VOLTYPE_CN00                = -24962,
  ERR_STATE_CN00                  = -24961,
  ERR_DBRUN_CN00                  = -24960,

  ERR_XPOVERFLOW_CN00             = -24959,
  ERR_BAOVERWRITE_CN00            = -24958,
  ERR_NOUSER_CN00                 = -24957,
  ERR_BASAVETYPECON_CN00          = -24956,
  ERR_BANOSAVETYPE_CN00           = -24955,
  ERR_BANOAUTOMED_CN00            = -24954,
  ERR_DBEXIST_CN00                = -24953,
  ERR_USRSAVE_CN00                = -24952,
  ERR_USRREAD_CN00                = -24951,
  ERR_USRFAIL_CN00                = -24950,

  ERR_USREXISTS_CN00              = -24949,
  ERR_NODBNAME_CN00               = -24948,
  ERR_DBNAME_CN00                 = -24947,
  ERR_TOMANYPARAM_CN00            = -24946,
  ERR_TOFEWPARAM_CN00             = -24945,
  ERR_USRDELSELF_CN00             = -24944,
  ERR_USRDELDBM_CN00              = -24943,
  ERR_USRDELSDBA_CN00             = -24942,
  ERR_NEEDLOGON_CN00              = -24941,
  ERR_NEEDSYSLOGON_CN00           = -24940,

  ERR_LASTREG_CN00                = -24939,
  ERR_NOENTRY_CN00                = -24938,
  ERR_MISSRIGHT_CN00              = -24937,
  ERR_DBNORUN_CN00                = -24936,
  ERR_NOUSERS_CN00                = -24935,
  ERR_VERSION_CN00                = -24934,
  ERR_NOSERVICESESSION_CN00       = -24933,
  ERR_XPMIN_CN00                  = -24932,
  ERR_XPMAX_CN00                  = -24931,
  ERR_XPVALUESET_CN00             = -24930,

  ERR_USRFRM_CN00                 = -24929,
  ERR_NOREPLY_CN00                = -24928,
  ERR_TOOLCHK_CN00                = -24927,
  ERR_MEDIUMCHK_CN00              = -24926,
  ERR_PREPARE_CN00                = -24925,
  ERR_DBREQ_CN00                  = -24924,
  ERR_TOOLREQ_CN00                = -24923,
  ERR_OPCHK_CN00                  = -24922,
  ERR_POSTOP_CN00                 = -24921,
  ERR_BACKUPOP_CN00               = -24920,

  ERR_CLEANUP_CN00                = -24919,
  ERR_MISSMIRR_CN00               = -24918,
  ERR_MAXDATA_CN00                = -24917,
  ERR_MAXVOLCNT_CN00              = -24916,

  ERR_UNKNOWN_CN00                = -24000
} tcn00_Error;
*/

#define OK_CN00                         cn00_1_ErrId(OK_CN00_1)

#define ERR_CN00                        cn00_1_ErrId(ERR_CN00_1)
#define ERR_NOTIMPL_CN00                cn00_1_ErrId(ERR_NOTIMPL_CN00_1)
#define ERR_FILE_CN00                   cn00_1_ErrId(ERR_FILE_CN00_1)
#define ERR_PARAM_CN00                  cn00_1_ErrId(ERR_PARAM_CN00_1)
#define ERR_MEM_CN00                    cn00_1_ErrId(ERR_MEM_CN00_1)
#define ERR_RTE_CN00                    cn00_1_ErrId(ERR_RTE_CN00_1)
#define ERR_RTEEXT_CN00                 cn00_1_ErrId(ERR_RTEEXT_CN00_1)
#define ERR_NOUTILSESSION_CN00          cn00_1_ErrId(ERR_NOUTILSESSION_CN00_1)
#define ERR_NOSQLUSERSESSION_CN00       cn00_1_ErrId(ERR_NOSQLUSERSESSION_CN00_1)
#define ERR_NOBACKUPSESSION_CN00        cn00_1_ErrId(ERR_NOBACKUPSESSION_CN00_1)

#define ERR_NOHISTORYSESSION_CN00       cn00_1_ErrId(ERR_NOHISTORYSESSION_CN00_1)
#define ERR_SQL_CN00                    cn00_1_ErrId(ERR_SQL_CN00_1)
#define ERR_TOOSMALL_CN00               cn00_1_ErrId(ERR_TOOSMALL_CN00_1)
#define ERR_NOMEDIA_CN00                cn00_1_ErrId(ERR_NOMEDIA_CN00_1)
#define ERR_MENOTFOUND_CN00             cn00_1_ErrId(ERR_MENOTFOUND_CN00_1)
#define ERR_MENOVALID_CN00              cn00_1_ErrId(ERR_MENOVALID_CN00_1)
#define ERR_BANOVALIDTYPE_CN00          cn00_1_ErrId(ERR_BANOVALIDTYPE_CN00_1)
#define ERR_NOHISTORY_CN00              cn00_1_ErrId(ERR_NOHISTORY_CN00_1)
#define ERR_HIENTRYNOTFOUND_CN00        cn00_1_ErrId(ERR_HIENTRYNOTFOUND_CN00_1)
#define ERR_NOHELP_CN00                 cn00_1_ErrId(ERR_NOHELP_CN00_1)

#define ERR_XPNOTFOUND_CN00             cn00_1_ErrId(ERR_XPNOTFOUND_CN00_1)
#define ERR_XPSYNTAX_CN00               cn00_1_ErrId(ERR_XPSYNTAX_CN00_1)
#define ERR_COMMAND_CN00                cn00_1_ErrId(ERR_COMMAND_CN00_1)
#define ERR_PARAMEXIST_CN00             cn00_1_ErrId(ERR_PARAMEXIST_CN00_1)
#define ERR_NOXPSESSION_CN00            cn00_1_ErrId(ERR_NOXPSESSION_CN00_1)
#define ERR_XPSESSION_CN00              cn00_1_ErrId(ERR_XPSESSION_CN00_1)
#define ERR_XPCHECK_CN00                cn00_1_ErrId(ERR_XPCHECK_CN00_1)
#define ERR_XPINVCONF_CN00              cn00_1_ErrId(ERR_XPINVCONF_CN00_1)
#define ERR_XPNOCHECK_CN00              cn00_1_ErrId(ERR_XPNOCHECK_CN00_1)
#define ERR_XPNOMODIFY_CN00             cn00_1_ErrId(ERR_XPNOMODIFY_CN00_1)

#define ERR_XPDIRTY_CN00                cn00_1_ErrId(ERR_XPDIRTY_CN00_1)
#define ERR_XPREADONLY_CN00             cn00_1_ErrId(ERR_XPREADONLY_CN00_1)
#define ERR_SYSTEM_CN00                 cn00_1_ErrId(ERR_SYSTEM_CN00_1)
#define ERR_LOGON_CN00                  cn00_1_ErrId(ERR_LOGON_CN00_1)
#define ERR_SYSLOGON_CN00               cn00_1_ErrId(ERR_SYSLOGON_CN00_1)
#define ERR_EXECUTE_CN00                cn00_1_ErrId(ERR_EXECUTE_CN00_1)
#define ERR_VOLCHECK_CN00               cn00_1_ErrId(ERR_VOLCHECK_CN00_1)
#define ERR_VOLTYPE_CN00                cn00_1_ErrId(ERR_VOLTYPE_CN00_1)
#define ERR_STATE_CN00                  cn00_1_ErrId(ERR_STATE_CN00_1)
#define ERR_DBRUN_CN00                  cn00_1_ErrId(ERR_DBRUN_CN00_1)

#define ERR_XPOVERFLOW_CN00             cn00_1_ErrId(ERR_XPOVERFLOW_CN00_1)
#define ERR_BAOVERWRITE_CN00            cn00_1_ErrId(ERR_BAOVERWRITE_CN00_1)
#define ERR_NOUSER_CN00                 cn00_1_ErrId(ERR_NOUSER_CN00_1)
#define ERR_BASAVETYPECON_CN00          cn00_1_ErrId(ERR_BASAVETYPECON_CN00_1)
#define ERR_BANOSAVETYPE_CN00           cn00_1_ErrId(ERR_BANOSAVETYPE_CN00_1)
#define ERR_BANOAUTOMED_CN00            cn00_1_ErrId(ERR_BANOAUTOMED_CN00_1)
#define ERR_DBEXIST_CN00                cn00_1_ErrId(ERR_DBEXIST_CN00_1)
#define ERR_USRSAVE_CN00                cn00_1_ErrId(ERR_USRSAVE_CN00_1)
#define ERR_USRREAD_CN00                cn00_1_ErrId(ERR_USRREAD_CN00_1)
#define ERR_USRFAIL_CN00                cn00_1_ErrId(ERR_USRFAIL_CN00_1)

#define ERR_USREXISTS_CN00              cn00_1_ErrId(ERR_USREXISTS_CN00_1)
#define ERR_NODBNAME_CN00               cn00_1_ErrId(ERR_NODBNAME_CN00_1)
#define ERR_DBNAME_CN00                 cn00_1_ErrId(ERR_DBNAME_CN00_1)
#define ERR_TOOMANYPARAM_CN00           cn00_1_ErrId(ERR_TOOMANYPARAM_CN00_1)
#define ERR_TOOFEWPARAM_CN00            cn00_1_ErrId(ERR_TOOFEWPARAM_CN00_1)
#define ERR_USRDELSELF_CN00             cn00_1_ErrId(ERR_USRDELSELF_CN00_1)
#define ERR_USRDELDBM_CN00              cn00_1_ErrId(ERR_USRDELDBM_CN00_1)
#define ERR_USRDELSDBA_CN00             cn00_1_ErrId(ERR_USRDELSDBA_CN00_1)
#define ERR_NEEDLOGON_CN00              cn00_1_ErrId(ERR_NEEDLOGON_CN00_1)
#define ERR_NEEDSYSLOGON_CN00           cn00_1_ErrId(ERR_NEEDSYSLOGON_CN00_1)

#define ERR_LASTREG_CN00                cn00_1_ErrId(ERR_LASTREG_CN00_1)
#define ERR_NOENTRY_CN00                cn00_1_ErrId(ERR_NOENTRY_CN00_1)
#define ERR_MISSRIGHT_CN00              cn00_1_ErrId(ERR_MISSRIGHT_CN00_1)
#define ERR_DBNORUN_CN00                cn00_1_ErrId(ERR_DBNORUN_CN00_1)
#define ERR_NOUSERS_CN00                cn00_1_ErrId(ERR_NOUSERS_CN00_1)
#define ERR_VERSION_CN00                cn00_1_ErrId(ERR_VERSION_CN00_1)
#define ERR_NOSERVICESESSION_CN00       cn00_1_ErrId(ERR_NOSERVICESESSION_CN00_1)
#define ERR_XPMIN_CN00                  cn00_1_ErrId(ERR_XPMIN_CN00_1)
#define ERR_XPMAX_CN00                  cn00_1_ErrId(ERR_XPMAX_CN00_1)
#define ERR_XPVALUESET_CN00             cn00_1_ErrId(ERR_XPVALUESET_CN00_1)

#define ERR_USRFRM_CN00                 cn00_1_ErrId(ERR_USRFRM_CN00_1)
#define ERR_NOREPLY_CN00                cn00_1_ErrId(ERR_NOREPLY_CN00_1)
#define ERR_TOOLCHK_CN00                cn00_1_ErrId(ERR_TOOLCHK_CN00_1)
#define ERR_MEDIUMCHK_CN00              cn00_1_ErrId(ERR_MEDIUMCHK_CN00_1)
#define ERR_PREPARE_CN00                cn00_1_ErrId(ERR_PREPARE_CN00_1)
#define ERR_DBREQ_CN00                  cn00_1_ErrId(ERR_DBREQ_CN00_1)
#define ERR_TOOLREQ_CN00                cn00_1_ErrId(ERR_TOOLREQ_CN00_1)
#define ERR_OPCHK_CN00                  cn00_1_ErrId(ERR_OPCHK_CN00_1)
#define ERR_POSTOP_CN00                 cn00_1_ErrId(ERR_POSTOP_CN00_1)
#define ERR_BACKUPOP_CN00               cn00_1_ErrId(ERR_BACKUPOP_CN00_1)

#define ERR_CLEANUP_CN00                cn00_1_ErrId(ERR_CLEANUP_CN00_1)
#define ERR_MISSMIRR_CN00               cn00_1_ErrId(ERR_MISSMIRR_CN00_1)
#define ERR_MAXDATA_CN00                cn00_1_ErrId(ERR_MAXDATA_CN00_1)
#define ERR_MAXVOLCNT_CN00              cn00_1_ErrId(ERR_MAXVOLCNT_CN00_1)
#define ERR_NOADDD_CN00                 cn00_1_ErrId(ERR_NOADDD_CN00_1)

#define ERR_DBAUNKNOWN_CN00             cn00_1_ErrId(ERR_DBAUNKNOWN_CN00_1)
#define ERR_DOMPUNKNOWN_CN00            cn00_1_ErrId(ERR_DOMPUNKNOWN_CN00_1)    
#define ERR_DBAWRONG_CN00               cn00_1_ErrId(ERR_DBAWRONG_CN00_1)
#define ERR_EBFDIRTY_CN00               cn00_1_ErrId(ERR_EBFDIRTY_CN00_1)
#define ERR_NOEBIDLIST_CN00             cn00_1_ErrId(ERR_NOEBIDLIST_CN00_1)      
#define ERR_DOMPWRONG_CN00              cn00_1_ErrId(ERR_DOMPWRONG_CN00_1)      
#define ERR_IMPERSONATE_CN00            cn00_1_ErrId(ERR_IMPERSONATE_CN00_1)      
#define ERR_ASCII_CN00                  cn00_1_ErrId(ERR_ASCII_CN00_1)      
#define ERR_NOTADMIN_CN00               cn00_1_ErrId(ERR_NOTADMIN_CN00_1)      

#define ERR_SHUTDOWN_CN00               cn00_1_ErrId(ERR_SHUTDOWN_CN00_1)
#define ERR_KNLDIRTY_CN00               cn00_1_ErrId(ERR_KNLDIRTY_CN00_1)
#define ERR_MDFDIRTY_CN00               cn00_1_ErrId(ERR_MDFDIRTY_CN00_1)
#define ERR_BAWRONGMEDIUM_CN00          cn00_1_ErrId(ERR_BAWRONGMEDIUM_CN00_1)
#define ERR_BAWRONGSAVETYPE_CN00        cn00_1_ErrId(ERR_BAWRONGSAVETYPE_CN00_1)
#define ERR_NOPREVSTAGEBACKUP_CN00      cn00_1_ErrId(ERR_NOPREVSTAGEBACKUP_CN00_1)

#define ERR_MEEXISTSASGROUP_CN00        cn00_1_ErrId(ERR_MEEXISTSASGROUP_CN00_1)
#define ERR_MEEXISTSASMEDIUM_CN00       cn00_1_ErrId(ERR_MEEXISTSASMEDIUM_CN00_1)
#define ERR_MEAMBIGUOUS_CN00            cn00_1_ErrId(ERR_MEAMBIGUOUS_CN00_1)
#define ERR_LOGFULL_CN00                cn00_1_ErrId(ERR_LOGFULL_CN00_1)
#define ERR_NORESTORESTRATEGY_CN00      cn00_1_ErrId(ERR_NORESTORESTRATEGY_CN00_1)
#define ERR_BACKNOTINHIST_CN00          cn00_1_ErrId(ERR_BACKNOTINHIST_CN00_1)
#define ERR_NOTMASTER_CN00              cn00_1_ErrId(ERR_NOTMASTER_CN00_1)
#define ERR_NEEDADMI_CN00               cn00_1_ErrId(ERR_NEEDADMI_CN00_1)
#define ERR_SERVICEDBNOTFOUND_CN00      cn00_1_ErrId(ERR_SERVICEDBNOTFOUND_CN00_1)

#define ERR_UNKNOWN_CN00                cn00_1_ErrId(ERR_UNKNOWN_CN00_1)

typedef teo200_EventList::teo200_EventID tcn00_Error;

/* database state ids */
typedef enum {
  STATE_ERROR_CN00,    /* error while computing state */
  STATE_OFFLINE_CN00,
  STATE_STARTING_CN00,
  STATE_ADMIN_CN00,
  STATE_STANDBY_CN00,
  STATE_ONLINE_CN00,
  STATE_SHUTDOWN_CN00,
  STATE_SHUTDOWNREINIT_CN00,
  STATE_SHUTDOWNKILL_CN00,
  STATE_STOP_CN00,
  STATE_KILL_CN00,
  STATE_ABORT_CN00,
  STATE_STOPPED_CN00,
  STATE_UNDEFINED_CN00,
  STATE_UNKNOWN_CN00
} tcn00_DBState;

//#define STATE_COLD_CN00 STATE_ADMIN_CN00
//#define STATE_WARM_CN00 STATE_ONLINE_CN00

#define TXT_STATE_ERROR_CN00              "ERROR"
#define TXT_STATE_OFFLINE_CN00            "OFFLINE"
#define TXT_STATE_STARTING_CN00           "STARTING"
#define TXT_STATE_ADMIN_CN00              "ADMIN"
#define TXT_STATE_STANDBY_CN00            "STANDBY"
#define TXT_STATE_ONLINE_CN00             "ONLINE"
#define TXT_STATE_SHUTDOWN_CN00           "SHUTDOWN"
#define TXT_STATE_SHUTDOWNREINIT_CN00     "SHUTDOWNREINIT"
#define TXT_STATE_SHUTDOWNKILL_CN00       "SHUTDOWNKILL"
#define TXT_STATE_STOP_CN00               "STOP"
#define TXT_STATE_KILL_CN00               "KILL"
#define TXT_STATE_ABORT_CN00              "ABORT"
#define TXT_STATE_STOPPED_CN00            "STOPPED"
#define TXT_STATE_UNDEFINED_CN00          "UNDEFINED"
#define TXT_STATE_UNKNOWN_CN00            "UNKNOWN"

#define TXT_STATE_RUNNING_CN00            "RUNNING"
#define TXT_STATE_RUIN_CN00               "STOPPED INCORRECTLY"

//#define TXT_STATE_COLD_CN00         TXT_STATE_ADMIN_CN00
//#define TXT_STATE_WARM_CN00         TXT_STATE_ONLINE_CN00

typedef struct tcn00_ValueToText {
  long          nValue;
  const char  * szText;
} tcn00_ValueToText; /* end typedef */

#define ERROR_TO_TEXT_CN00 { \
  { OK_CN00,                    cn00_1_ErrTxt(OK_CN00_1)                   }, \
  { ERR_CN00,                   cn00_1_ErrTxt(ERR_CN00_1)                  }, \
  { ERR_NOTIMPL_CN00,           cn00_1_ErrTxt(ERR_NOTIMPL_CN00_1)          }, \
  { ERR_RTE_CN00,               cn00_1_ErrTxt(ERR_RTE_CN00_1)              }, \
  { ERR_RTEEXT_CN00,            cn00_1_ErrTxt(ERR_RTEEXT_CN00_1)           }, \
  { ERR_SQL_CN00,               cn00_1_ErrTxt(ERR_SQL_CN00_1)              }, \
  { ERR_NOUTILSESSION_CN00,     cn00_1_ErrTxt(ERR_NOUTILSESSION_CN00_1)    }, \
  { ERR_NOSQLUSERSESSION_CN00,  cn00_1_ErrTxt(ERR_NOSQLUSERSESSION_CN00_1) }, \
  { ERR_NOBACKUPSESSION_CN00,   cn00_1_ErrTxt(ERR_NOBACKUPSESSION_CN00_1)  }, \
  { ERR_NOHISTORYSESSION_CN00,  cn00_1_ErrTxt(ERR_NOHISTORYSESSION_CN00_1) }, \
  { ERR_MEM_CN00,               cn00_1_ErrTxt(ERR_MEM_CN00_1)              }, \
  { ERR_PARAM_CN00,             cn00_1_ErrTxt(ERR_PARAM_CN00_1)            }, \
  { ERR_FILE_CN00,              cn00_1_ErrTxt(ERR_FILE_CN00_1)             }, \
  { ERR_TOOSMALL_CN00,          cn00_1_ErrTxt(ERR_TOOSMALL_CN00_1)          }, \
  { ERR_NOMEDIA_CN00,           cn00_1_ErrTxt(ERR_NOMEDIA_CN00_1)          }, \
  { ERR_MENOTFOUND_CN00,        cn00_1_ErrTxt(ERR_MENOTFOUND_CN00_1)       }, \
  { ERR_MENOVALID_CN00,         cn00_1_ErrTxt(ERR_MENOVALID_CN00_1)        }, \
  { ERR_BANOVALIDTYPE_CN00,     cn00_1_ErrTxt(ERR_BANOVALIDTYPE_CN00_1)    }, \
  { ERR_NOHISTORY_CN00,         cn00_1_ErrTxt(ERR_NOHISTORY_CN00_1)        }, \
  { ERR_HIENTRYNOTFOUND_CN00,   cn00_1_ErrTxt(ERR_HIENTRYNOTFOUND_CN00_1)  }, \
  { ERR_NOHELP_CN00,            cn00_1_ErrTxt(ERR_NOHELP_CN00_1)           }, \
  { ERR_XPNOTFOUND_CN00,        cn00_1_ErrTxt(ERR_XPNOTFOUND_CN00_1)       }, \
  { ERR_XPSYNTAX_CN00,          cn00_1_ErrTxt(ERR_XPSYNTAX_CN00_1)         }, \
  { ERR_COMMAND_CN00,           cn00_1_ErrTxt(ERR_COMMAND_CN00_1)          }, \
  { ERR_PARAMEXIST_CN00,        cn00_1_ErrTxt(ERR_PARAMEXIST_CN00_1)       }, \
  { ERR_NOXPSESSION_CN00,       cn00_1_ErrTxt(ERR_NOXPSESSION_CN00_1)      }, \
  { ERR_XPSESSION_CN00,         cn00_1_ErrTxt(ERR_XPSESSION_CN00_1)        }, \
  { ERR_XPCHECK_CN00,           cn00_1_ErrTxt(ERR_XPCHECK_CN00_1)          }, \
  { ERR_XPINVCONF_CN00,         cn00_1_ErrTxt(ERR_XPINVCONF_CN00_1)        }, \
  { ERR_XPNOCHECK_CN00,         cn00_1_ErrTxt(ERR_XPNOCHECK_CN00_1)        }, \
  { ERR_XPNOMODIFY_CN00,        cn00_1_ErrTxt(ERR_XPNOMODIFY_CN00_1)       }, \
  { ERR_XPDIRTY_CN00,           cn00_1_ErrTxt(ERR_XPDIRTY_CN00_1)          }, \
  { ERR_XPREADONLY_CN00,        cn00_1_ErrTxt(ERR_XPREADONLY_CN00_1)       }, \
  { ERR_SYSTEM_CN00,            cn00_1_ErrTxt(ERR_SYSTEM_CN00_1)           }, \
  { ERR_LOGON_CN00,             cn00_1_ErrTxt(ERR_LOGON_CN00_1)            }, \
  { ERR_SYSLOGON_CN00,          cn00_1_ErrTxt(ERR_SYSLOGON_CN00_1)         }, \
  { ERR_EXECUTE_CN00,           cn00_1_ErrTxt(ERR_EXECUTE_CN00_1)          }, \
  { ERR_VOLCHECK_CN00,          cn00_1_ErrTxt(ERR_VOLCHECK_CN00_1)         }, \
  { ERR_VOLTYPE_CN00,           cn00_1_ErrTxt(ERR_VOLTYPE_CN00_1)          }, \
  { ERR_STATE_CN00,             cn00_1_ErrTxt(ERR_STATE_CN00_1)            }, \
  { ERR_DBRUN_CN00,             cn00_1_ErrTxt(ERR_DBRUN_CN00_1)            }, \
  { ERR_XPOVERFLOW_CN00,        cn00_1_ErrTxt(ERR_XPOVERFLOW_CN00_1)       }, \
  { ERR_BAOVERWRITE_CN00,       cn00_1_ErrTxt(ERR_BAOVERWRITE_CN00_1)      }, \
  { ERR_NOUSER_CN00,            cn00_1_ErrTxt(ERR_NOUSER_CN00_1)           }, \
  { ERR_BASAVETYPECON_CN00,     cn00_1_ErrTxt(ERR_BASAVETYPECON_CN00_1)    }, \
  { ERR_BANOSAVETYPE_CN00,      cn00_1_ErrTxt(ERR_BANOSAVETYPE_CN00_1)     }, \
  { ERR_BANOAUTOMED_CN00,       cn00_1_ErrTxt(ERR_BANOAUTOMED_CN00_1)      }, \
  { ERR_DBEXIST_CN00,           cn00_1_ErrTxt(ERR_DBEXIST_CN00_1)          }, \
  { ERR_USRSAVE_CN00,           cn00_1_ErrTxt(ERR_USRSAVE_CN00_1)          }, \
  { ERR_USRREAD_CN00,           cn00_1_ErrTxt(ERR_USRREAD_CN00_1)          }, \
  { ERR_USRFAIL_CN00,           cn00_1_ErrTxt(ERR_USRFAIL_CN00_1)          }, \
  { ERR_USREXISTS_CN00,         cn00_1_ErrTxt(ERR_USREXISTS_CN00_1)        }, \
  { ERR_NODBNAME_CN00,          cn00_1_ErrTxt(ERR_NODBNAME_CN00_1)         }, \
  { ERR_DBNAME_CN00,            cn00_1_ErrTxt(ERR_DBNAME_CN00_1)           }, \
  { ERR_TOOMANYPARAM_CN00,      cn00_1_ErrTxt(ERR_TOOMANYPARAM_CN00_1)     }, \
  { ERR_TOOFEWPARAM_CN00,       cn00_1_ErrTxt(ERR_TOOFEWPARAM_CN00_1)      }, \
  { ERR_USRDELSELF_CN00,        cn00_1_ErrTxt(ERR_USRDELSELF_CN00_1)       }, \
  { ERR_USRDELDBM_CN00,         cn00_1_ErrTxt(ERR_USRDELDBM_CN00_1)        }, \
  { ERR_USRDELSDBA_CN00,        cn00_1_ErrTxt(ERR_USRDELSDBA_CN00_1)       }, \
  { ERR_NEEDLOGON_CN00,         cn00_1_ErrTxt(ERR_NEEDLOGON_CN00_1)        }, \
  { ERR_NEEDSYSLOGON_CN00,      cn00_1_ErrTxt(ERR_NEEDSYSLOGON_CN00_1)     }, \
  { ERR_LASTREG_CN00,           cn00_1_ErrTxt(ERR_LASTREG_CN00_1)          }, \
  { ERR_NOENTRY_CN00,           cn00_1_ErrTxt(ERR_NOENTRY_CN00_1)          }, \
  { ERR_MISSRIGHT_CN00,         cn00_1_ErrTxt(ERR_MISSRIGHT_CN00_1)        }, \
  { ERR_DBNORUN_CN00,           cn00_1_ErrTxt(ERR_DBNORUN_CN00_1)          }, \
  { ERR_NOUSERS_CN00,           cn00_1_ErrTxt(ERR_NOUSERS_CN00_1)          }, \
  { ERR_VERSION_CN00,           cn00_1_ErrTxt(ERR_VERSION_CN00_1)          }, \
  { ERR_NOSERVICESESSION_CN00,  cn00_1_ErrTxt(ERR_NOSERVICESESSION_CN00_1) }, \
  { ERR_XPMIN_CN00,             cn00_1_ErrTxt(ERR_XPMIN_CN00_1)            }, \
  { ERR_XPMAX_CN00,             cn00_1_ErrTxt(ERR_XPMAX_CN00_1)            }, \
  { ERR_XPVALUESET_CN00,        cn00_1_ErrTxt(ERR_XPVALUESET_CN00_1)       }, \
  { ERR_USRFRM_CN00,            cn00_1_ErrTxt(ERR_USRFRM_CN00_1)           }, \
  { ERR_NOREPLY_CN00,           cn00_1_ErrTxt(ERR_NOREPLY_CN00_1)          }, \
  { ERR_TOOLCHK_CN00,           cn00_1_ErrTxt(ERR_TOOLCHK_CN00_1)          }, \
  { ERR_MEDIUMCHK_CN00,         cn00_1_ErrTxt(ERR_MEDIUMCHK_CN00_1)        }, \
  { ERR_PREPARE_CN00,           cn00_1_ErrTxt(ERR_PREPARE_CN00_1)          }, \
  { ERR_DBREQ_CN00,             cn00_1_ErrTxt(ERR_DBREQ_CN00_1)            }, \
  { ERR_TOOLREQ_CN00,           cn00_1_ErrTxt(ERR_TOOLREQ_CN00_1)          }, \
  { ERR_OPCHK_CN00,             cn00_1_ErrTxt(ERR_OPCHK_CN00_1)            }, \
  { ERR_POSTOP_CN00,            cn00_1_ErrTxt(ERR_POSTOP_CN00_1)           }, \
  { ERR_BACKUPOP_CN00,          cn00_1_ErrTxt(ERR_BACKUPOP_CN00_1)         }, \
  { ERR_CLEANUP_CN00,           cn00_1_ErrTxt(ERR_CLEANUP_CN00_1)          }, \
  { ERR_MISSMIRR_CN00,          cn00_1_ErrTxt(ERR_MISSMIRR_CN00_1)         }, \
  { ERR_MAXDATA_CN00,           cn00_1_ErrTxt(ERR_MAXDATA_CN00_1)          }, \
  { ERR_MAXVOLCNT_CN00,         cn00_1_ErrTxt(ERR_MAXVOLCNT_CN00_1)        }, \
  { ERR_NOADDD_CN00,            cn00_1_ErrTxt(ERR_NOADDD_CN00_1)           }, \
  { ERR_DBAUNKNOWN_CN00,        cn00_1_ErrTxt(ERR_DBAUNKNOWN_CN00_1)       }, \
  { ERR_DOMPUNKNOWN_CN00,       cn00_1_ErrTxt(ERR_DOMPUNKNOWN_CN00_1)      }, \
  { ERR_DBAWRONG_CN00,          cn00_1_ErrTxt(ERR_DBAWRONG_CN00_1)         }, \
  { ERR_EBFDIRTY_CN00,          cn00_1_ErrTxt(ERR_EBFDIRTY_CN00_1)         }, \
  { ERR_NOEBIDLIST_CN00,        cn00_1_ErrTxt(ERR_NOEBIDLIST_CN00_1)       }, \
  { ERR_DOMPWRONG_CN00,         cn00_1_ErrTxt(ERR_DOMPWRONG_CN00_1)        }, \
  { ERR_IMPERSONATE_CN00,       cn00_1_ErrTxt(ERR_IMPERSONATE_CN00_1)      }, \
  { ERR_ASCII_CN00,             cn00_1_ErrTxt(ERR_ASCII_CN00_1)            }, \
  { ERR_NOTADMIN_CN00,          cn00_1_ErrTxt(ERR_NOTADMIN_CN00_1)         }, \
  { ERR_SHUTDOWN_CN00,          cn00_1_ErrTxt(ERR_SHUTDOWN_CN00_1)         }, \
  { ERR_KNLDIRTY_CN00,          cn00_1_ErrTxt(ERR_KNLDIRTY_CN00_1)         }, \
  { ERR_MDFDIRTY_CN00,          cn00_1_ErrTxt(ERR_MDFDIRTY_CN00_1)         }, \
  { ERR_BAWRONGMEDIUM_CN00,     cn00_1_ErrTxt(ERR_BAWRONGMEDIUM_CN00_1)    }, \
  { ERR_BAWRONGSAVETYPE_CN00,   cn00_1_ErrTxt(ERR_BAWRONGSAVETYPE_CN00_1)  }, \
  { ERR_NOPREVSTAGEBACKUP_CN00, cn00_1_ErrTxt(ERR_NOPREVSTAGEBACKUP_CN00_1)}, \
  { ERR_MEEXISTSASGROUP_CN00,   cn00_1_ErrTxt(ERR_MEEXISTSASGROUP_CN00_1)  }, \
  { ERR_MEEXISTSASMEDIUM_CN00,  cn00_1_ErrTxt(ERR_MEEXISTSASMEDIUM_CN00_1) }, \
  { ERR_MEAMBIGUOUS_CN00,       cn00_1_ErrTxt(ERR_MEAMBIGUOUS_CN00_1)      }, \
  { ERR_LOGFULL_CN00,           cn00_1_ErrTxt(ERR_LOGFULL_CN00_1)          }, \
  { ERR_NORESTORESTRATEGY_CN00, cn00_1_ErrTxt(ERR_NORESTORESTRATEGY_CN00_1)}, \
  { ERR_BACKNOTINHIST_CN00,     cn00_1_ErrTxt(ERR_BACKNOTINHIST_CN00_1)    }, \
  { ERR_NOTMASTER_CN00,         cn00_1_ErrTxt(ERR_NOTMASTER_CN00_1)        }, \
  { ERR_NEEDADMI_CN00,          cn00_1_ErrTxt(ERR_NEEDADMI_CN00_1)         }, \
  { ERR_SERVICEDBNOTFOUND_CN00, cn00_1_ErrTxt(ERR_SERVICEDBNOTFOUND_CN00_1)}, \
  { ERR_UNKNOWN_CN00,           cn00_1_ErrTxt(ERR_UNKNOWN_CN00_1)          }}

#define ANSWER_OK_CN00         _T("OK")
#define ANSWER_ERR_CN00        _T("ERR")
#define VALUE_SEPSTRING_CN00   _T("\t")
#define LINE_SEPSTRING_CN00    _T("\n")
#define TOKEN_SEPSTRING_CN00   _T(",")
#define PWD_SEPARATOR_CN00     _T(',')
#define KEY_DIREND_CN00        _T("END     ")
#define KEY_DIRCONTINUE_CN00   _T("CONTINUE")

/* param access */
//#define XP_VALUE_LENGTH_MXCN00         100

// param values
#define XP_VAL_DUAL_CN00               "DUAL"
#define XP_VAL_YES_CN00                "YES"

/* devspace specifications */
#define XP_DEV_DAT_CN00                "DATA"
#define XP_DEV_LOG_CN00                "LOG"
#define XP_DEV_MLOG_CN00               "MLOG"
typedef enum {
  XPDevSpaceUnknown_ecn00,
  XPDevSpaceDat_ecn00,
  XPDevSpaceMDat_ecn00,
  XPDevSpaceLog_ecn00,
  XPDevSpaceMLog_ecn00,
  XPHSSNode_ecn00,
  XPHSSDelay_ecn00
} tcn00_XPDevSpace;
/* mode                     multi    mode */
#define XP_DEVSPACE_KEYWORDS_CN00   { \
  {XPDevSpaceDat_ecn00,     true,   false, XP_DEV_DAT_CN00    }, \
  {XPDevSpaceLog_ecn00,     true,   false, XP_DEV_LOG_CN00    }, \
  {XPDevSpaceMLog_ecn00,    true,   true,  XP_DEV_MLOG_CN00   }, \
  {XPDevSpaceUnknown_ecn00, false,  false, ""                 }}

typedef struct tcn00_DevspaceKeywords {
    tcn00_XPDevSpace    nDevSpace;
    bool                bMulti;
    bool                bMirror;
    const _TCHAR      * szText;
  } tcn00_DevspaceKeywords;

/*   mode                     name param                 type param                      size param                    mode                          max count               */
  #define XP_DEVSPACE_PARAMS_CN00   { \
    {XPDevSpaceDat_ecn00,     PAN_DATADEV_N"%04d",       PAN_DATADEV_N_TYPE"%04d",       PAN_DATADEV_N_SIZE"%04d",     PAN_DATA_VOLUME_MODE_N"%04d", PAN_MAXDATADEVSPACES }, \
    {XPDevSpaceLog_ecn00,     PAN_ARCHIVE_LOG_N"%03d",   PAN_ARCHIVE_LOG_N_TYPE"%03d",   PAN_ARCHIVE_LOG_N_SIZE"%03d", "",                           PAN_MAXARCHIVELOGS   }, \
    {XPDevSpaceMLog_ecn00,    PAN_M_ARCHIVE_LOG_N"%03d", PAN_M_ARCHIVE_LOG_N_TYPE"%03d", "",                           "",                           ""                   }, \
    {XPHSSNode_ecn00,         PAN_HS_NODE_N"%03d",       "",                             "",                           "",                           ""                   }, \
    {XPHSSDelay_ecn00,        PAN_HS_DELAY_TIME_N"%03d", "",                             "",                           "",                           ""                   }, \
    {XPDevSpaceUnknown_ecn00, "",                        "",                             "",                           "",                           ""                   }}

typedef struct tcn00_DevspaceParams {
    tcn00_XPDevSpace   nDevSpace;
    const _TCHAR     * szName;
    const _TCHAR     * szType;
    const _TCHAR     * szSize;
    const _TCHAR     * szMode;
    const _TCHAR     * szMaxCount;
} tcn00_DevspaceParams;

typedef tcn00_Error cnFunctionPrototype_CN00
      ( VControlDataT * vcontrol,
        CommandT      * command,
        char          * replyData,
        int           * replyLen,
        int             replyLenMax);

/* supply a text for a boolean expression */
#define     BOOLSTR_CN00(boolval)   ((boolval) ? "True" : "False")

/* Database error codes */
#define DB_ERR_LOGFULL_CN00      (-901)
#define DB_ERR_ROWNOTFOUND_CN00  (100)

#ifdef CONSOLE_TRACE_CN
  #define CONSOLE_TRACE_MSG_CN00(Text)     printf("%s::%8d - %s\n",       (char *) __FILE__, (int) __LINE__, (char *) Text);
  #define CONSOLE_TRACE_ENTER_CN00         printf("%s::%8d - enter %s\n", (char *) __FILE__, (int) __LINE__, (char *) CN_FUNCTION);
  #define CONSOLE_TRACE_LEAVE_CN00         printf("%s::%8d - leave %s\n", (char *) __FILE__, (int) __LINE__, (char *) CN_FUNCTION);
#else
  #define CONSOLE_TRACE_MSG_CN00(Text)
  #define CONSOLE_TRACE_ENTER_CN00
  #define CONSOLE_TRACE_LEAVE_CN00
#endif

#define XDB_RC_CN00(n)          ((n == OK_CN00) ? OK_CN00 : n + 25100)

#ifndef _WIN32
  #define stricmp  strcasecmp
  #define strnicmp strncasecmp
#endif

typedef tsp00_Namec tcn00_UserNamec;

#define vf_t_directory          7

#endif /* _GCN00_H_ */
